/* Imran,made changes for LCPR */
#include	<defs.h>

/* 
History of Changes :
		{Jo, 14 Oct 1999, Made local variables global 
			to fix display problem}
		{Jo, 15 Oct 1999, Modified function display_static_routes()}
		{Jo, 26 Oct 1999, Modified function add_static_route() 
			to prevent accepting zero IP address}
*/

#include	<stdlib.h>
#include	<stdio.h>
#include <string.h>

#include	"telnet.h"
#include	"vmenu.h"

#if 0
#include "..\..\store\boot.h" 
#endif

/* Sudha 12 Feb 1998 */
/* #include "..\..\store\hardware.h"*/

#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 
#include "..\..\stacks\ip\ipfilt.h"

/*	sudhir 5-10-96 */
#include "..\..\stacks\ip\vip.h"
/* sudhir 5-10-96 */


#include <incall.h>
#include <cfgmgr.h>

extern int modify_config_visited;

PARAMETER_NODE *ptr_to_current_node;

#define	ICMP_PROTOCOL	  1
#define	TCP_PROTOCOL	  6
#define	UDP_PROTOCOL	  17
#define	ARP_PROTOCOL	  34
#define	IP_PROTOCOL		  35

extern	TCP_CLASS	tcp;
extern	IP_CLASS	ip;
extern   DHCP_CLASS dhcp;
extern	IP_FILTER_DEFAULT_ACTION	ip_filter_default_action;
extern	IP_FILTERING_ENTRY *sptr_ip_src_filter_chain, *sptr_ip_dest_filter_chain;
extern 	int frame_relay_enabled;  	/* oss on 3-3-97 */
extern 	int no_of_ip_ports;			/* oss on 3-3-97 */

extern enum BOOLEAN dial_bkup_enabled; /* Sudha 12 Feb 1998 */

void force_write_string (BYTE *, BYTE *, ULONG , BYTE *);

/* sudhir 5-10-96 */
extern int toupper (int);
enum BOOLEAN is_default_route_valid (ULONG);
extern BYTE is_an_ip_address(BYTE* address);

/* sudhir */
extern BYTE *net_to_str (BYTE *Addr, ULONG Address);
extern BYTE *get_port_type (USHORT port_type);


BYTE *get_ip_address_str (BYTE *buf, USHORT port_number);
int get_number_of_ip_ports();

void	generate_no_of_ip_ports_strings(int value);
void	initialize_values_of_new_ip_port();

void	generate_no_of_ports_strings(int no_of_ports, int section_id);
void	add_delete_values_of_ip_port(int Flag, int PortNo);

/* added by oss on 28-3-97 */
#define OFFSET_TO_RHS 3
#define OFFSET_OF_PORT_STATS 5
#define PTR_TO_PORT_NO 2

PARA_STR *test_linked_list (PARA_STR *);

BYTE *to_upper_string (BYTE *);
static ULONG str_to_net(BYTE *);  /* Imran,made this function static */

BYTE ChoiceBuffer[80];
STRUCT_STATIC_ROUTE temp_static_route;
/* Jo 14/10/99 */
STRUCT_STATIC_ROUTE *temp_ptr_to_route ;
STRUCT_STATIC_ROUTE dummy_ptr_to_route ;
/* Jo 14/10/99 */

BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);

extern int get_dot_decimal_ip_address (ULONG ip_address, char *dot_ip_address); 

/* extern DNS_CLASS dns;  */

extern void  delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
extern void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
extern BYTE  *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr);
extern BYTE  *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr);
extern void  set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
extern PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr);
extern void force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
extern BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array);

/* sudhir 5-10-96 */

/* Jo 21/08/99 Added for Validating Gateway Address for Static Routes */
extern enum BOOLEAN check_if_gateway_is_valid (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT port_number, BYTE msg_string[300]) ;
extern enum BOOLEAN verify_ip_subnet_mask (ULONG *range_value, char *value_to_check) ;

BYTE *get_ip_port_type (USHORT port_type)
{
   switch ( telnet.model_number)
   {
      case MODEL_UNKNOWN :
         printf ( "\n\rModel Unknown.");
         break;
      case MODEL_MTSR3_200 :
      	switch (port_type) 
         {
		      case 0:	return ("Ethernet");
      		case 1: return ("WAN1");
      		case 2: return ("WAN2");
      		case 3: return ("WAN3");
		      default: return ("Unknown");
         }
         break;
#ifdef _BIG_PROXY_ /* Jo 29/04/99 */
      case MODEL_MTSR1_202ST :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("ISDN_ST");
            default:return ("Unknown");
         }
         break;
      case MODEL_MTSR1_202NT :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("ISDN_NT");
            default:return ("Unknown");
         }
         break;
      case MODEL_MTSR3_201 :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("WAN1(DSU)");
            case 2: return ("WAN2");
            default:return ("Unknown");
         }
         break;
#endif /* Jo 29/04/99 */
      default :
         return ("Unknown");
         break;
	}
}


static BYTE * ip_protocol_string (USHORT_ENUM (IP_PORT_FILTER_PROTOCOL) protocol)
{
	switch (protocol) {
      case PROTOCOL_TCP:
		   return ("TCP");
      case PROTOCOL_UDP:
		   return ("UDP");
		default: return ("Unknown");
	}
}

#ifdef _BIG_PROXY_   
static BYTE * ip_fd_entry_port_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) 
   {
      case FILTER_ON_SOURCE: return ("Filter on source port");
		case FILTER_ON_DESTINATION: return ("Filter on destination port");
		case FORWARD_ON_SOURCE: return ("Forward on source port");
		case FORWARD_ON_DESTINATION: return ("Forward on destination port"); 
      default: return ("Invalid");
   }
}

static BYTE * ip_fd_entry_addr_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) 
   {
		case FILTER_ON_SOURCE: return ("Filter on source address");
		case FORWARD_ON_SOURCE: return ("Forward on source address");
		case FILTER_ON_DESTINATION: return ("Filter on destination address");
		case FORWARD_ON_DESTINATION: return ("Forward on destination address"); 
		default:return ("Invalid");
	}
}

static enum BOOLEAN	ip_add_filt_entry_to_buffer (IP_FILTERING_ENTRY *sptr_ip_fdt_entry, BYTE index, BYTE filter_type)
{
	BYTE	tmp_buffer[81];

	if (filter_type == IP_FILTER_ADDR)
	{
		switch (sptr_ip_fdt_entry->type)
		{
			case IP_FILTER_ON_SOURCE_ADDRESS: 
			case IP_FORWARD_ON_SOURCE_ADDRESS: 
			case IP_FILTER_ON_DESTINATION_ADDRESS: 
			case IP_FORWARD_ON_DESTINATION_ADDRESS:
				sprintf(tmp_buffer, "%3d. %-15s ---------------  %2d  %s\n\r", 
					index,
					convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_ip_fdt_entry->lower_end.ip_address),
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;					

			case IP_FILTER_ON_SOURCE_RANGE: 
			case IP_FILTER_ON_DESTINATION_RANGE: 
			case IP_FORWARD_ON_SOURCE_RANGE: 
			case IP_FORWARD_ON_DESTINATION_RANGE: 
				sprintf(tmp_buffer, "%3d. %-15s %-15s  %2d  %s\n\r", 
					index,
					convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_ip_fdt_entry->lower_end.ip_address),
					convert_ip_address_to_dot_format(&ReplyStrs[1].ReplyStr[0], sptr_ip_fdt_entry->higher_end.ip_address),
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;
			default:
				return(FALSE);
		}
	}
	else if (filter_type == IP_FILTER_PORT)
	{
		switch (sptr_ip_fdt_entry->type)
		{
			case IP_FILTER_ON_SOURCE_PORT: 
			case IP_FILTER_ON_DESTINATION_PORT: 
			case IP_FORWARD_ON_SOURCE_PORT: 
			case IP_FORWARD_ON_DESTINATION_PORT: 
				sprintf(tmp_buffer, "%3d.  %-8s      %04d        %2d    %s\n\r", 
					index,
					ip_protocol_string(sptr_ip_fdt_entry->lower_end.protocol_port.protocol),
					sptr_ip_fdt_entry->lower_end.protocol_port.port_number,
					sptr_ip_fdt_entry->port,
					ip_fd_entry_addr_string (sptr_ip_fdt_entry->type));
				break;
			default:
				return(FALSE);
		}
	}
	else 
	{
		return(FALSE);
	}
	strcat(telnet.tx_buffer, tmp_buffer);
	return(TRUE);
}
#endif


BYTE *modify_dns_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_DNS_PRIMARY_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT,&ReplyStrs[0].ReplyStr[0], 20, NULL);
		
		get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_DNS_SECONDARY_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT,&ReplyStrs[1].ReplyStr[0], 20, NULL);

		sprintf (ChoiceBuffer, EnterChoice, 2);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd <= 2) && 
		(client_info_ptr->modify_option_rcvd >= 1))
	{
		client_info_ptr->menustate = TMS_DNS_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *update_dns_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs ;
	ULONG new_value, port_no, int_ip_address ;

enum CM_SET_RESULTS set_result;

/* printf("\nIP_Section : section_id -%d",CM_IP_SECTION); 	 */
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DNS_ROOT_ADDR:				
            ret_str = NewValue;
            break;

			case MOD_DNS_LOCAL_ADDR:
             ret_str = NewValue; 
            break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

/* printf("\nbuffer-%s",buffer); */
	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DNS_ROOT_ADDR:
         new_rhs = buffer;			
         if (is_an_ip_address_even_if_zero (buffer) == FALSE)
            return InvalidIP;

			get_ulong_ip_address (buffer, &int_ip_address) ;

         switch(set_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_DNS_PRIMARY_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &int_ip_address, sizeof(ULONG), NULL))
			{
				case CM_SET_SUCCESSFUL : break;
				default : return("\n\rFailed to set parameter");
			}

/* Jo 14/07/99 Initialize PPP strings properly */
			set_ppp_strings (PPP_PORT_IPCP_DNS_ADDRESS1, CM_ALL_PORTS, 1) ;
			break;

		case MOD_DNS_LOCAL_ADDR:
         new_rhs = buffer;
         if (is_an_ip_address_even_if_zero (buffer) == FALSE)
            return InvalidIP;
			get_ulong_ip_address (buffer, &int_ip_address) ;
			switch (set_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_DNS_SECONDARY_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &int_ip_address, sizeof(ULONG), NULL))
			{
				case CM_SET_SUCCESSFUL : break;
				default : return("\n\rFailed to set parameter");
			}
/* Jo 14/07/99 Initialize PPP strings properly */
			set_ppp_strings (PPP_PORT_IPCP_DNS_ADDRESS2, CM_ALL_PORTS, 1) ;
			break;  

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
   client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* sudhir 22-9-96*/

/* Jo 09/07/99 Added for DHCP */
BYTE *modify_dhcp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT get_int_value;

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_CLIENT_ENABLE,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &get_int_value, 10, NULL);	 

		strcpy(&ReplyStrs[0].ReplyStr[0], (get_int_value ? "enabled" : "disabled"));

		get_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_SERVER_IP_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT, &ReplyStrs[1].ReplyStr[0], 20, NULL);				

      if ( !ReplyStrs[1].ReplyStr[0])
         strcpy ( &ReplyStrs[1].ReplyStr[0],"0.0.0.0");

		sprintf (ChoiceBuffer, EnterChoice, 2);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd >= 1) && 
		(client_info_ptr->modify_option_rcvd <= 
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_DHCP_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *update_dhcp_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs,dhcp_addr[16] ;
	ULONG port_no, bootp ;
	USHORT get_int_value, new_value ;
	BYTE temp_str[200];
	int number_of_ports, i ;
 
   get_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, (void *) DHCP_SERVER_IP_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT,&dhcp_addr[0], 20, NULL);				

   
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DHCP:				  
            if ( strcmp (dhcp_addr,"0.0.0.0") == 0)
            {
               strcpy(temp_str,"\n\r\DHCP server addr should be entered before enabling this.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               ret_str = temp_str;
            }
            else
            {         
               strcpy(temp_str,"\n\r\Make sure to enter DHCP server addr if you enable this.");
               strcat(temp_str,EnaOrDis);
               ret_str = temp_str;
            }
				break;

			case MOD_DHCP_SER_IP_ADD:	ret_str = NewValue;
												break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DHCP:
         if ( strcmp (dhcp_addr,"0.0.0.0") == 0)
         {
            strcpy(temp_str,"\n\r\DHCP server addr should be entered before enabling this.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
            return(temp_str);
         }
         else
         {
/* Jo 21/09/99 Added for DHCP client */
				if (new_value == 2)
					new_value = 0 ;
				else if(new_value != 1)
					return (InvalidChoice);

				switch (set_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_CLIENT_ENABLE,
	   				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &new_value, sizeof(USHORT), NULL))
		   	{
					case CM_SET_SUCCESSFUL : break;
					default : return("\n\r Failed to set parameter") ;
  				}

				if (new_value)
				{
					bootp = 1 ;
				}
				else
				{
					get_parameter(client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_SERVER_ENABLE,
						CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &get_int_value, 1, NULL) ;
					if (!get_int_value)
						bootp = 0 ;
				}
				number_of_ports =	get_number_of_ip_ports() ;
				for (i = 0; i < number_of_ports; i++)
				{
	 				switch (set_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_BOOTP,
	   				i, CM_USHORT_FORMAT, &bootp, sizeof(USHORT), NULL))
					{
							case CM_SET_SUCCESSFUL : break;
							default : return("\n\r Failed to set parameter");
   				}		
				}
/* Jo 21/09/99 Added for DHCP client */
         }
			break;

		case MOD_DHCP_SER_IP_ADD:
			new_rhs = buffer;
         if (!is_an_ip_address(buffer) || (strcmp ( buffer,"0.0.0.0") == 0 ))
            return (InvalidIP);
			switch (set_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_SERVER_IP_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT, new_rhs, strlen(new_rhs), NULL))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* Jo 09/07/99 Added for DHCP */

BYTE	*ip_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) 
		return (menufsmhdlr[client_info_ptr->menustate].menu);

 	switch (atoi(buffer)) 
   {
 		case IP_GEN_INFO:			
			client_info_ptr->menustate = TMS_MODI_IP;
			break;

 		case IP_PORT:				
			client_info_ptr->menustate = TMS_MODI_IPPORT;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_ip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();
#if 0
		get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_DEFAULT_GATEWAY,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT, &ReplyStrs[0].ReplyStr[0],18,NULL);		

      if ( !ReplyStrs[0].ReplyStr[0])
         strcpy ( &ReplyStrs[0].ReplyStr[0],"0.0.0.0");
#endif
		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
/*		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,		
			&ReplyStrs[0].ReplyStr[0],GoBack, ChoiceBuffer);*/

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,		
			GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if ((client_info_ptr->modify_option_rcvd >= 1) && 
		(client_info_ptr->modify_option_rcvd <= 
					menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{ 
		client_info_ptr->menustate = TMS_IP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 } 
}


BYTE *ip_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs, *ptr_to_metric;
	ULONG  new_value;
   BYTE lan_addr[16],lan_mask[16];
	BYTE temp_str[200];

	if(!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  IP_DHCP_INFO:
				client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
			 	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
#if 0
			case  IP_DEFAULT_GWAY:	
            return("\n\r\Enter Gateway Address : ");
				break;
#endif			
         case  IP_DNS_INFO:
            client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
      
/* Jo 17/08/99 Added for Static Routes */
         case  IP_STATIC_ROUTE:
            client_info_ptr->next_screen = 0;
            client_info_ptr->menustate =  TMS_IP_STATIC_RT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
/* Jo 17/08/99 Added for Static Routes */
            
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
#if 0
		case IP_DEFAULT_GWAY:
         if (!is_an_ip_address(buffer))
            return (InvalidIP);

         strcpy(temp_str,buffer);
         new_rhs = temp_str;
			get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_SUBNET_MASK,
			    0, CM_DOT_FORMAT,&lan_mask[0],16,NULL);				

			 get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_IP_ADDRESS,
			    0, CM_DOT_FORMAT,&lan_addr[0],16,NULL);				
         
         if ( local_ip_address_and_remote_ip_address_on_same_network(lan_addr,buffer,lan_mask) == FALSE )
         {
				return ("\n\rInvalid Gateway address.LAN & Gateway address should belong to the same net.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
         }     

			switch (set_parameter (client_info_ptr->connection_id,CM_IP_SECTION,IP_DEFAULT_GATEWAY,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT, new_rhs,strlen(new_rhs),NULL))
			{
			  	case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

			 	case CM_SET_SUCCESSFUL : break;

			 	default : return("\n\r Failed to set parameter");
			}

			break;
		
#endif
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
		modify_config_visited = 1 ; 

		client_info_ptr->menustate = TMS_MODI_IP;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

   frame_relay_enabled = 0;

	if (!buffer)
	{
		if (frame_relay_enabled)	/* added by oss on 3-3-97 */
		{
			generate_no_of_ports_strings(no_of_ip_ports, IP_ID);
			return (telnet.tx_buffer);
		}
		generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);

	if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports);
		return(telnet.tx_buffer);
	}
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
   else
    	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
	
   client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ip_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG port_no;
	BYTE temp_buff[300] ;
	USHORT get_int_value = 0 ;

	port_no = client_info_ptr->menu_selected_port + 1;
	if (!buffer)
	{
		initialize_replystr ();

		if (client_info_ptr->menu_selected_port)
		{
			strcpy (temp_buff, "**This should be 0.0.0.0 if the IP address is to be assigned by ISP\n\r");
			strcat (temp_buff, GoBack );
		}
		else
		{
			strcpy (temp_buff, GoBack );
		}
		get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_SUBNET_MASK,
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT,&ReplyStrs[0].ReplyStr[0],
				20, NULL);				

		get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_IP_ADDRESS,		
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT,&ReplyStrs[1].ReplyStr[0],
				20,NULL);				

      if ( !ReplyStrs[1].ReplyStr[0])
         strcpy ( &ReplyStrs[1].ReplyStr[0],"0.0.0.0");

/* Jo 12/07/99 Added for RAS */
		if (client_info_ptr->menu_selected_port > 0)
	   {
		   get_parameter (client_info_ptr->connection_id, CM_PPP_SECTION, PPP_PORT_REMOTE_PORT_CLIENT_ONLY,
				client_info_ptr->menu_selected_port-1, CM_USHORT_FORMAT, &get_int_value, 10, NULL) ;

			if (get_int_value == 1)
				strcpy(&ReplyStrs[2].ReplyStr[0], "enabled") ;
			else	
				strcpy(&ReplyStrs[2].ReplyStr[0], "disabled") ;
		}
		else
			strcpy(&ReplyStrs[2].ReplyStr[0], "disabled") ;
		
		get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT,&ReplyStrs[3].ReplyStr[0], 20, NULL);	 

      if ( !ReplyStrs[3].ReplyStr[0] || (strcmp (&ReplyStrs[2].ReplyStr[0], "disabled") == 0))
         strcpy ( &ReplyStrs[3].ReplyStr[0],"0.0.0.0");

		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
#ifdef  _BIG_PROXY_
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1,
		   &ReplyStrs[0].ReplyStr[0],	&ReplyStrs[1].ReplyStr[0],
         &ReplyStrs[2].ReplyStr[0],	&ReplyStrs[3].ReplyStr[0],
			temp_buff, ChoiceBuffer); 
#endif
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1,
			   &ReplyStrs[0].ReplyStr[0],	&ReplyStrs[1].ReplyStr[0],
			   &ReplyStrs[2].ReplyStr[0],	&ReplyStrs[3].ReplyStr[0],
				temp_buff, ChoiceBuffer); 

		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_IP_SUBNETMASK) &&
			(client_info_ptr->modify_option_rcvd <=
			 menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_IPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *upd_modify_ip_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs,ras_str[10],ras_addr[16],lan_addr[16],lan_mask[16];
	ULONG  new_value, port_no, port_num, int_ip_address ;
/*	BYTE IP_frame[] = "IP Port Frame Type";*/
   USHORT set_value = 0,value_got = 0; 
	BYTE temp_str[200], ip_addr_string[20], ip_addr_string1[20], ip_address[20] ;
   BYTE temp_buf[100] ;
   ras_str[0] = ras_addr[0] = lan_addr[0] = lan_mask[0] = 0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_IP_SUBNETMASK:		ret_str = NewValue;
												break;
			case MOD_IP_NODE_ADDRESS:
					ret_str = NewValue;
					break;

/* Jo 12/07/99 Added for RAS */
         case MOD_IP_RAS_ENABLED:
                  client_info_ptr->menustate = TMS_NULL_FUNC;
                  menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPPORTINFO;
                  return (not_supported);
						break;                  

         case MOD_IP_RAS_ADDR:
						if (client_info_ptr->menu_selected_port < 1)
						{
	                  client_info_ptr->menustate = TMS_NULL_FUNC;
   	               menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPPORTINFO;
      	            return (not_supported);
						}
						else
						{	
						   get_parameter (client_info_ptr->connection_id, CM_PPP_SECTION, PPP_PORT_REMOTE_PORT_CLIENT_ONLY,
								client_info_ptr->menu_selected_port-1, CM_USHORT_FORMAT, &value_got, 10, NULL) ;
							
	                  if (value_got == 1)
   	                  ret_str = NewValue;
      	            else
         	            return ("\n\rRAS option is disabled.Enter exit or ESC to PREV menu : \n\r");
						}
					  	break;                  
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port + 1;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{

		case MOD_IP_SUBNETMASK:
         new_rhs = buffer;
/* Jo 21/09/99 Added to accept Subnet Mask */
	
			get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_IP_ADDRESS,
				client_info_ptr->menu_selected_port, CM_ULONG_FORMAT, &int_ip_address, sizeof(ULONG), NULL) ;
			get_dot_decimal_ip_address (int_ip_address, ip_address) ;
			
			if(!is_an_ip_address_mask(&ip_address[0], &new_rhs[0]))
				return InvalidSubnet;
/* Jo 21/09/99 Added to accept Subnet Mask */
			switch (set_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_SUBNET_MASK,
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT, new_rhs, strlen(new_rhs), NULL))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidSubnet;

				case CM_SET_SUCCESSFUL : break;
				default : return("\n\r Failed to set parameter ");
			}
			break;

		case MOD_IP_NODE_ADDRESS: 
			new_rhs = buffer;
			switch (set_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_IP_ADDRESS,
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT, new_rhs, strlen(new_rhs),NULL))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

			  	case CM_SET_SUCCESSFUL : break;
			  	default : return("\n\r Failed to set parameter ");
			}
/* Jo 14/07/99 Initialize PPP strings properly */
			set_ppp_strings (PPP_PORT_OPTION_IPCP_IP_ADDRESS, client_info_ptr->menu_selected_port, 1) ;
			break;

      case MOD_IP_RAS_ENABLED: 
			break ;				

      case MOD_IP_RAS_ADDR: 
			new_rhs = buffer;

         if (( strcmp(buffer,"0.0.0.0") == 0 ) || !buffer[0] )
         {
            
				get_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_CLIENT_ENABLE,
					CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &value_got, 10, NULL);	 

            if (value_got == 0 )
            {
		get_parameter (client_info_ptr->connection_id, CM_DHCP_SECTION, DHCP_SERVER_IP_ADDRESS,
				CM_NO_PORT_PARAMETER_PRESENT, CM_DOT_FORMAT, &ras_addr[0], 20, NULL);				
               
               if (( strcmp(ras_addr,"0.0.0.0") == 0) || !ras_addr[0] )
               {
                  return ("\n\rInvalid Remote Access IP Addr.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }
               else
                  new_rhs = ras_addr;
            }
            else
            {
               return ("\n\rInvalid Remote Access IP Addr.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
            }
         }
         else
         {
            if (!is_an_ip_address(buffer))
               return (InvalidIP);
            else
            {
					get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_SUBNET_MASK,
						0, CM_DOT_FORMAT,&lan_mask[0],20, NULL);				

					get_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_IP_ADDRESS,		
						0, CM_DOT_FORMAT, &lan_addr[0], 20, NULL);				
               
               if ( strcmp(buffer,lan_addr) == 0 )
               {
                  return ("\n\rEntered addr is same as LAN addr.So Invalid.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }

               if ( local_ip_address_and_remote_ip_address_on_same_network(lan_addr,buffer,lan_mask) == FALSE)
               {
                  return ("\n\rInvalid RAS addr.LAN & RAS addr should belong to the same net.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }

					if (client_info_ptr->menu_selected_port == 1)
					{
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port+1, CM_DOT_FORMAT, &ip_addr_string[0], 20, NULL) ;	 
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port+2, CM_DOT_FORMAT, &ip_addr_string1[0], 20, NULL) ;	 
					}
					else if (client_info_ptr->menu_selected_port == 2)
					{
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port-1, CM_DOT_FORMAT, &ip_addr_string[0], 20, NULL) ;	 
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port+1, CM_DOT_FORMAT, &ip_addr_string1[0], 20, NULL) ;	 
					}
					else if (client_info_ptr->menu_selected_port == 3)
					{
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port-2, CM_DOT_FORMAT, &ip_addr_string[0], 20, NULL) ;	 
						get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
							client_info_ptr->menu_selected_port-1, CM_DOT_FORMAT, &ip_addr_string1[0], 20, NULL) ;	 
					}

				   if ((strcmp (ip_addr_string, buffer) != 0) &&
				 		(strcmp (ip_addr_string1, buffer) != 0))
               {
                  new_rhs = buffer;
					}
					else
					{
                  return ("\n\rInvalid RAS addr.It should be unique.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }
            }   
         }
			switch (set_parameter (client_info_ptr->connection_id,CM_IP_SECTION, IP_PORT_REMOTE_ADDRESS,
				client_info_ptr->menu_selected_port, CM_DOT_FORMAT, new_rhs, strlen(new_rhs),NULL))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

			  	case CM_SET_SUCCESSFUL : break ;
			  	default : return("\n\r Failed to set parameter ") ;

			}
/* Jo 14/07/99 Initialize PPP strings properly */
			set_ppp_strings (PPP_PORT_REMOTE_OPTION_IPCP_IP_ADDRESS, client_info_ptr->menu_selected_port, 1) ;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_IPPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

#ifdef _BIG_PROXY_
/* sudhir 3-10-96 */
PARA_STR *test_linked_list (PARA_STR *start_of_linked_list)
{	
/*
	while (start_of_linked_list)
	{
		if (!i)
		{
			printf("The first string is %s\n", &start_of_linked_list->parameter[0]);
			i = 25 ;
		}
		else
		{
			start_of_linked_list = start_of_linked_list->next ;
			i-- ;
		}
	}
*/
	return (start_of_linked_list);
}

enum BOOLEAN is_default_route_valid (ULONG default_rout)
{
	int port_no;
	ULONG default_net, port_net;

	for (port_no =0; port_no < telnet.number_of_ports ; port_no++)
	{
		 default_net = default_rout & ip.port[port_no].config.subnetmask;
		 port_net = ip.port[port_no].config.ip_address & ip.port[port_no].config.subnetmask;
		 if (default_net == port_net)
		 	return (TRUE);
	}
	return (FALSE);
}	 
#endif

BYTE *get_ip_address_str (BYTE *buf, USHORT port_number)
{
	convert_ip_address_to_dot_format (buf, ip.port[port_number].config.ip_address);
	return (buf);
}

int get_number_of_ip_ports()
{
/*	USHORT no_of_ports=0; */
	
	return ip.number_of_ports;

	
/*	get_parameter (CM_IP_SECTION, (void *) &ip.number_of_ports,
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT,&no_of_ports, 10);				
	return no_of_ports; */
}

BYTE  *ip_port_delete_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, PortNoToDelete, "IP");
		return (telnet.tx_buffer);
	}

	new_value = atoi (buffer);
	if (new_value > no_of_ip_ports)
	{
		sprintf (telnet.tx_buffer, EnterProperChoice, no_of_ip_ports);
		return (telnet.tx_buffer);
	}
	else
	{
	}
	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
 	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *ip_tcp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;
	
   switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY_
			will_temp_echo(client_info_ptr, TOECHO);
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], tcp.mib.tcpPassiveOpens),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], tcp.mib.tcpAttemptFails),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], tcp.mib.tcpInSegs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], tcp.mib.tcpOutSegs),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], tcp.mib.tcpRetransSegs),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], tcp.mib.tcpInErrs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], tcp.mib.tcpOutRsts));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr); 
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

#ifdef _BIG_PROXY_ /* 20/05/99 */

BYTE *ip_rip_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY_
			will_temp_echo(client_info_ptr, TOECHO);
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0],
				ip.rip.statistics.number_of_request_packets_sent + ip.rip.statistics.number_of_response_packets_sent),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rip.statistics.number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rip.statistics.number_of_packets_rejected),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rip.statistics.number_of_request_packets_received),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rip.statistics.number_of_response_packets_received),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rip.statistics.number_of_unrecongnized_packets_received),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rip.statistics.number_of_bad_versions),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rip.statistics.number_of_bad_address_families),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rip.statistics.number_of_bad_metrics));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}
#endif /* 20/05/99 */


BYTE *ip_arp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY_
			will_temp_echo(client_info_ptr, TOECHO);
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.arp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.arp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.arp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.arp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.arp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.arp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.arp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.arp.statistics.total_number_of_replies_sent),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.arp.statistics.total_number_of_pending_packets_discarded),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.arp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


#ifdef _BIG_PROXY_ /* Jo 21/05/99 */
void	generate_no_of_ip_ports_strings(int Flag)
{
	BYTE temp_buf[75];
	int i;

	strcpy (telnet.tx_buffer, "\n\r             << Select IP Port >> \n\r");
	for (i = 1; i <= no_of_ip_ports; i++)
	{
		if (!Flag)
			sprintf (temp_buf, "\n\r[%d] Port %2d", i, i);
		else
			sprintf (temp_buf, "\n\r[%d] Port %2d     : %s", i, i,
				enabled_or_disabled (ip.port[i-1].config.port_enabled));
		strcat (telnet.tx_buffer, temp_buf);
	}
	if (!Flag)
	{
		sprintf (temp_buf, "\n\r[%d] Add a Virtual Port", no_of_ip_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port", no_of_ip_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ip_ports + 2);
	}
	else
		sprintf (temp_buf, EnterChoice, no_of_ip_ports);
	strcat (telnet.tx_buffer, temp_buf);
}

BYTE *ip_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY_
			will_temp_echo(client_info_ptr, TOECHO);  			  
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.mib.ipInReceives),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.mib.ipInHdrErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.mib.ipForwDatagrams),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.statistics.number_of_packets_that_couldnot_be_forwarded),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.mib.ipOutRequests),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.mib.ipOutNoRoutes));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr); 
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	return(not_supported);
}

BYTE *ip_rarp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY_
			will_temp_echo(client_info_ptr, TOECHO);
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.rarp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rarp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rarp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rarp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rarp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rarp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rarp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rarp.statistics.total_number_of_replies_sent),
/*				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rarp.statistics.total_number_of_pending_packets_discarded),*/
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], 0),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.rarp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
		return(not_supported);
}

BYTE *ip_icmp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.icmp.mib.icmpInMsgs),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.icmp.mib.icmpInErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.icmp.mib.icmpInDestUnreachs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.icmp.mib.icmpInEchos),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.icmp.mib.icmpInEchoReps),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.icmp.mib.icmpOutMsgs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.icmp.mib.icmpOutErrors),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.icmp.mib.icmpOutDestUnreachs),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.icmp.mib.icmpOutEchos),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.icmp.mib.icmpOutEchoReps));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	return(not_supported);
}

BYTE *ip_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE	filter_type;

	if (!buffer) 
		return (menufsmhdlr[client_info_ptr->menustate].menu);

	filter_type = atoi(buffer);
 	switch( filter_type) {
      case IP_FILTER_ADDR:
			client_info_ptr->menustate = TMS_IPFILTADDR;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;

			/** menu_selected_port is used to save the display_filter_type selected.
			 	 It is later used to ditinguish between address & port filters.
			**/
			client_info_ptr->menu_selected_port = filter_type;
			break;
 		case IP_FILTER_PORT:
			client_info_ptr->menustate = TMS_IPFILTPORT;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
			break;
 		case IP_FILTER_ICMP:
			client_info_ptr->menustate = TMS_IPFILTICMP;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

#endif /* Jo 21/05/99 */

BYTE *ip_udp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
#ifdef _BIG_PROXY
			will_temp_echo(client_info_ptr, TOECHO);
#endif

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.udp.mib.udpInDatagrams),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.udp.mib.udpNoPorts),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.udp.mib.udpInErrors),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.udp.mib.udpOutDatagrams));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


#ifdef _BIG_PROXY_
void initialize_ip_addr_filter ()
{
	strcpy (temp_ip_addr_filter.ip_address, "0.0.0.0");
	temp_ip_addr_filter.physical_port = 0;
	temp_ip_addr_filter.filter_type = 0;
}	

BYTE	*display_ip_addr_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;
   BYTE temp_buff[200];
   USHORT index=0;
   PARAMETER_NODE *ptr_to_previous_node;

	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_node != NULL)
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
		}
		else
		{
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter", (void *) &ip_addr_filter);

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, IPFilterAddrDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;

		}

		strcpy (telnet.tx_buffer, IPFilterAddrDB);
      if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"   %3d.    %-15s   %-4s   %s\n\r", 
            client_info_ptr->index++,
            dummy_ip_addr_filter->ip_address,
            get_ip_port_type(dummy_ip_addr_filter->physical_port),
            ip_fd_entry_addr_string(dummy_ip_addr_filter->filter_type));
      	strcat (telnet.tx_buffer,temp_buff);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPA;
			}
      }

      ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;

   	while (ptr_to_current_node != NULL)
   	{
         client_info_ptr->no_filters = 0;
      	index++;
      	sprintf (temp_buff,"   %3d.    %-15s   %-4s   %s\n\r", 
            client_info_ptr->index++,
            ptr_to_ip_addr_filter->ip_address,
            get_ip_port_type(ptr_to_ip_addr_filter->physical_port),
            ip_fd_entry_addr_string(ptr_to_ip_addr_filter->filter_type));
      	strcat (telnet.tx_buffer,temp_buff);

         if (ptr_to_current_node != NULL)
            ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ip_addr_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            memcpy ((char *) &dup_ip_addr_filter, (char *) &ip_addr_filter, sizeof (STRUCT_IP_ADDRESS_FILTER));
            dummy_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &dup_ip_addr_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;
	   }
SENDFILT_IPA:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit "); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_ip_addr_filter ();
      client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_ADD_ADDR_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_ADDR_EDIT_FILTER;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_ADDR_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IPFILTADDR;
   }
   else
      return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return InvalidFilter;
   }
   client_info_ptr->edit_index = index;


   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter",(void *) &ip_addr_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }                  
   }  
   ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;

   temp_ip_addr_filter.physical_port = ptr_to_ip_addr_filter->physical_port;         
   temp_ip_addr_filter.filter_type = ptr_to_ip_addr_filter->filter_type;
   strcpy (temp_ip_addr_filter.ip_address, ptr_to_ip_addr_filter->ip_address);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_ADD_ADDR_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
   STRUCT_IP_ADDRESS_FILTER ip_address_filter;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_address_filter;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, IPaddrfiltopt,
			temp_ip_addr_filter.ip_address,
			get_ip_port_type (temp_ip_addr_filter.physical_port),
			ip_fd_entry_addr_string (temp_ip_addr_filter.filter_type));
		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= IP_ADDRF_IPADDR &&
      client_info_ptr->modify_option_rcvd <= IP_ADDRF_FTYPE )
   {
      client_info_ptr->menustate = TMS_IP_UPD_ADDRF;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address filter",(void *) &ip_address_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_address_filter);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return (InvalidFilter);
            }
         }  
         ptr_to_ip_address_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_address_filter;
         client_info_ptr->edit_filter = 0;
         cm_edit_string (CM_IP_SECTION, "IP Address Filter", (void *)ptr_to_ip_address_filter, (void *) &temp_ip_addr_filter);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP address Filter", (void *) &temp_ip_addr_filter);

		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPFILTADDR;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}  	

BYTE *upd_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IP_ADDRF_IPADDR:
				return ("\n\rEnter IP Address:");
		
			case IP_ADDRF_PORTNO:
				/* return PortChoice;  Sudha 13 Feb 1998 */
             generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
             return(telnet.tx_buffer);

			case IP_ADDRF_FTYPE:
				return Filtertype;
		}
	}

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case IP_ADDRF_IPADDR:
			if (!is_an_ip_address(buffer))
				return (InvalidIP);
         strcpy (temp_ip_addr_filter.ip_address, buffer);
         break;
	
		case IP_ADDRF_PORTNO:
         /* if (value < 1 || value > 4 )  Sudha 13 Feb 1998 */
			if (value < 1 || value > telnet.number_of_ports)
				return InvalidChoice;
			temp_ip_addr_filter.physical_port = value-1;
			break;
			
		case IP_ADDRF_FTYPE:
			if (value < 1 || value > 4)
				return InvalidChoice;

         temp_ip_addr_filter.filter_type = value-1;
         break;
	}
	client_info_ptr->menustate = TMS_ADD_ADDR_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_ip_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_IP_ADDRESS_FILTER *ptr_to_ip_addr_filter;
   STRUCT_IP_ADDRESS_FILTER ip_addr_filter;

   if (!buffer)
   {
      return EnterFilter;
   }


   index = atoi (buffer) - 1;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Address Filter",(void *) &ip_addr_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_addr_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  

   ptr_to_ip_addr_filter = (STRUCT_IP_ADDRESS_FILTER *) &ip_addr_filter;
   cm_remove_string (CM_IP_SECTION, "IP Address Filter", (void *)ptr_to_ip_addr_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

	client_info_ptr->menustate = TMS_IPFILTADDR;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) {
		if (telnet.number_of_ports == 2)
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled));
		}
		else
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled),
				enabled_or_disabled (ip.port[2].config.port_enabled),
				enabled_or_disabled (ip.port[3].config.port_enabled));
		}
		return (telnet.tx_buffer);
	}

	port_number = atoi(buffer);
	/* Sanjay */
	if (port_number > menufsmhdlr[client_info_ptr->menustate].num_of_items ||
		port_number <= 0)
	{
		/* Invalid choice */
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else if (port_number == menufsmhdlr[client_info_ptr->menustate].num_of_items)
	{	
		/* Move to parent menu */
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
		client_info_ptr->menu_selected_port = port_number-1;
	}
	/* Sanjay */
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
#endif

BYTE *to_upper_string (BYTE *in_str)
{
	BYTE *ptr = in_str;

	while (*ptr)
	{
		*ptr = (char) toupper ((int) *ptr) ;
		ptr ++ ;
	}
	return in_str ;
}

ULONG str_to_net(BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%03u.%03u.%03u.%03u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1l);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

/* Jo 17/08/99 Added for Static Routes */

void initialize_static_route ()
{
   temp_static_route.port_number = 0 ;	
   temp_static_route.ip_address = 0	;
   temp_static_route.gateway_address = 0 ;
   temp_static_route.address_mask = 0 ;
   temp_static_route.metric = 1 ; 
}

BYTE *display_static_routes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE temp_buff[200] ;
   STRUCT_STATIC_ROUTE *ptr_to_static_route ;
	USHORT index = 0, entry_number = 0, no_of_entries = 0 ;   
	ULONG offset ; 
   char temp_ip_address[20], temp_gateway_address[20], temp_address_mask[20], port_string[5] ; 

   if (!buffer)
   {
		get_number_of_static_routes (&no_of_entries) ;
      if (client_info_ptr->next_screen)
      {
			entry_number = client_info_ptr->index ;
         if (entry_number < no_of_entries )
				cm_get_static_entry (CM_STATIC_ROUTES_ID, &ptr_to_static_route, &entry_number) ;
      }         
      else
      {
			if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1 ;
            strcpy (telnet.tx_buffer,static_route_table) ;
            strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):") ;
				return telnet.tx_buffer ;
			}
			cm_get_static_entry (CM_STATIC_ROUTES_ID, &ptr_to_static_route, &entry_number) ;
         client_info_ptr->index = 1 ;
      }

      strcpy (telnet.tx_buffer, static_route_table) ;

      if (client_info_ptr->next_screen)
      {
         index++ ;
			get_dot_decimal_ip_address (temp_ptr_to_route->ip_address, temp_ip_address) ;
			get_dot_decimal_ip_address (temp_ptr_to_route->gateway_address, temp_gateway_address) ;
			get_dot_decimal_ip_address (temp_ptr_to_route->address_mask, temp_address_mask) ;

			if (!temp_ptr_to_route->port_number)
				sprintf (port_string, "LAN")	;
			else
				sprintf (port_string, "WAN%d", temp_ptr_to_route->port_number) ;
			
			sprintf (temp_buff, "%3d.  %-15s    %-15s  %-15s     %-5d  %-5s\n\r",
            client_info_ptr->index++,
            temp_ip_address,
            temp_gateway_address,
            temp_address_mask,
            temp_ptr_to_route->metric,
	         port_string) ;
      	strcat (telnet.tx_buffer, temp_buff) ;

/* ...Jo 15 Oct 1999 Changed the condition to display all static routes */
         if (entry_number == MAX_ENTRIES_PER_PAGE + 1)
/* Jo 15 Oct 1999 Changed the condition to display all static routes... */
         {
            client_info_ptr->next_screen = 0 ; 
            goto STATIC_ADD_MENU ;
			}
      }

   	while (entry_number <= no_of_entries)
   	{
         client_info_ptr->no_filters = 0 ;
         index++ ;

			get_dot_decimal_ip_address (ptr_to_static_route->ip_address, temp_ip_address) ;
			get_dot_decimal_ip_address (ptr_to_static_route->gateway_address, temp_gateway_address) ;
			get_dot_decimal_ip_address (ptr_to_static_route->address_mask, temp_address_mask) ;
			if (!ptr_to_static_route->port_number)
				sprintf (port_string, "LAN")	;
			else
				sprintf (port_string, "WAN%d", ptr_to_static_route->port_number) ;

			sprintf (temp_buff, "%3d.  %-15s    %-15s  %-15s     %-5d  %-5s\n\r",
            client_info_ptr->index++,
            temp_ip_address,
            temp_gateway_address,
            temp_address_mask,
            ptr_to_static_route->metric,
            port_string) ;
         strcat (telnet.tx_buffer, temp_buff) ;

			if (entry_number == no_of_entries)
				entry_number++ ;

         if (entry_number < no_of_entries)
				cm_get_static_entry (CM_STATIC_ROUTES_ID, &ptr_to_static_route, &entry_number) ;

         if (index == MAX_ENTRIES_PER_PAGE && entry_number <= no_of_entries)
         {
            memcpy ((char *) &dummy_ptr_to_route, (char *) ptr_to_static_route, sizeof(STRUCT_STATIC_ROUTE)) ;
            temp_ptr_to_route = (STRUCT_STATIC_ROUTE *) &dummy_ptr_to_route ;
            client_info_ptr->next_screen++ ;
				client_info_ptr->index = entry_number ;
            break ;
         }

         if (entry_number > no_of_entries)
         {
            client_info_ptr->next_screen = 0 ;
            goto STATIC_ADD_MENU ;
         }
      }
STATIC_ADD_MENU:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit ") ;  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ") ;
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):") ;  
      return telnet.tx_buffer ;
   }

   if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0 ;
      initialize_static_route () ;
      client_info_ptr->edit_filter = 0 ;
      client_info_ptr->menustate = TMS_IP_ADD_ROUTE ;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0 ;
      client_info_ptr->menustate = TMS_IP_EDIT_ROUTE ;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_STATIC_RT ;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IP_STATIC_RT ;
   }
   else
      return InvalidChoice ;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)) ;
}

BYTE *te_edit_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_STATIC_ROUTE *ptr_to_static_route;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of Route:") ;

   index = atoi (buffer) ;

   if (index == 0)
   {
      client_info_ptr->next_screen = 0 ;
      return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):") ;
   }

   client_info_ptr->edit_index = index ;
	index-- ;

	cm_get_static_entry (CM_STATIC_ROUTES_ID, &ptr_to_static_route, &index) ;

   temp_static_route.ip_address = ptr_to_static_route->ip_address ;
   temp_static_route.gateway_address = ptr_to_static_route->gateway_address ;
   temp_static_route.address_mask = ptr_to_static_route->address_mask ;
   temp_static_route.metric = ptr_to_static_route->metric ;
   temp_static_route.port_number = ptr_to_static_route->port_number ;

   client_info_ptr->next_screen = 0 ;
   client_info_ptr->edit_filter = 1 ;

   client_info_ptr->menustate = TMS_IP_ADD_ROUTE ;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)) ; 
}

BYTE *add_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   char temp_ip_address[20], temp_gateway_address[20], temp_address_mask[20], temp_buff1[5], temp_buff2[5] ; 
	BYTE msg_string[300]	;

   if (!buffer)
   {
      client_info_ptr->next_screen = 0 ;
		get_dot_decimal_ip_address (temp_static_route.ip_address, temp_ip_address) ;
		get_dot_decimal_ip_address (temp_static_route.gateway_address, temp_gateway_address) ;
		get_dot_decimal_ip_address (temp_static_route.address_mask, temp_address_mask) ;
		my_itoa ((int)temp_static_route.metric, temp_buff1, 10) ;

		if (!temp_static_route.port_number)
			sprintf (temp_buff2, "LAN")	;
		else
			sprintf (temp_buff2, "WAN%d", temp_static_route.port_number) ;
		
      sprintf (telnet.tx_buffer, static_route_menu,
          temp_buff2,
          temp_ip_address,
          temp_gateway_address,
          temp_address_mask,
          temp_buff1) ;
      return (telnet.tx_buffer) ;
    }

    client_info_ptr->modify_option_rcvd = atoi (buffer) ;
      
    if (client_info_ptr->modify_option_rcvd >= STATIC_ROUTE_PORT &&
      client_info_ptr->modify_option_rcvd <= STATIC_ROUTE_METRIC )
    {
      client_info_ptr->menustate = TMS_IP_UPD_ROUTE ;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)) ;
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
/* ...Added by Jo on 26 Oct 1999 to prevent accepting zero IP address */
		if (temp_static_route.ip_address == 0 || temp_static_route.address_mask == 0)
			return ("\n\rInvalid IP Address. Enter Your Choice (1 to 5, exit or ESC) : ") ;
/* Added by Jo on 26 Oct 1999 to prevent accepting zero IP address... */

		get_dot_decimal_ip_address (temp_static_route.gateway_address, temp_gateway_address) ;
		if (check_if_gateway_is_valid (client_info_ptr, (BYTE *)temp_gateway_address, temp_static_route.port_number, msg_string) == FALSE)
		{
			strcat ((char *)msg_string, "\n\rEnter Your Choice (exit or ESC to PREV menu) : ")	;
			return (msg_string) ;
		}
      modify_config_visited = 1 ;

      if (client_info_ptr->edit_filter)
      {
         client_info_ptr->edit_filter = 0 ;
			if (!cm_edit_static_route_entry (client_info_ptr->connection_id, CM_STATIC_ROUTES_SECTION, 
				client_info_ptr->edit_index, (void *) &temp_static_route, 0))
				 return("\nEditing Static Route Entry Failed. Enter exit or ESC to PREV menu:") ;
      }
      else
		{
      	switch (add_parameters (client_info_ptr->connection_id, CM_STATIC_ROUTES_SECTION, 	
 					ADD_STATIC_ROUTE, 0, (void *) &temp_static_route, NULL))
			{
				case CM_ADD_SUCCESSFUL : 
					break ;
				default :  return ("\nAdding Static Route Entry Failed. Enter exit or ESC to PREV menu:\n") ;
			}
		}
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_STATIC_RT ;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)) ;
    }
    return InvalidChoice ;
}

BYTE *upd_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{		
   ULONG int_ip_address ;
   int value = 0 ;
	enum BOOLEAN ret_value ;
	BYTE msg_string[300]	;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
         case STATIC_ROUTE_PORT:
            return stat_rt_port ;

         case STATIC_ROUTE_ADDRESS:
            return stat_rt_target ;
         
         case STATIC_ROUTE_GWAY:
            return stat_rt_target ;

         case STATIC_ROUTE_SMASK:
            return stat_rt_mask ;

         case STATIC_ROUTE_METRIC:
            return stat_rt_metric ;
      }
   }
   switch (client_info_ptr->modify_option_rcvd)
	{
      case STATIC_ROUTE_PORT:
         sscanf (buffer, "%d", &value);
         if (value < 1 || value > 4 )
            return InvalidChoice ;
         temp_static_route.port_number = (BYTE) value - 1 ;
         break ;

      case STATIC_ROUTE_ADDRESS:
         if (!is_an_ip_address(buffer))
				return (InvalidIP) ;
			get_ulong_ip_address (buffer, &int_ip_address) ;
         temp_static_route.ip_address = int_ip_address ;
         break ;
         
      case STATIC_ROUTE_GWAY:
			if (check_if_gateway_is_valid (client_info_ptr, buffer, temp_static_route.port_number, msg_string) == FALSE)
			{
				strcat ((char *)msg_string, "\n\rEnter Your Choice (exit or ESC to PREV menu) : ")	;
				return (msg_string) ;
			}
			get_ulong_ip_address (buffer, &int_ip_address) ;
  	      temp_static_route.gateway_address = int_ip_address ;
      	break ;
      
      case STATIC_ROUTE_SMASK:
   		if (validate_subnetmask (buffer) == FALSE)
			{
				if (strcmp (buffer, "255.255.255.255") != 0)
					return (InvalidSubnet) ;
			}
			get_ulong_ip_address (buffer, &int_ip_address) ;
         temp_static_route.address_mask = int_ip_address ;
         break ;

      case STATIC_ROUTE_METRIC:
         sscanf (buffer, "%d", &value);
         if (value < 1 || value > 16 )
            return InvalidChoice ;
         temp_static_route.metric = (BYTE) value ;
         break ;
   }
   client_info_ptr->menustate = TMS_IP_ADD_ROUTE ;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)) ;
}

BYTE *delete_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0 ;

   if (!buffer)
      return ("\n\rEnter index of Route to delete:") ;

   index = atoi (buffer) - 1 ;

	if (index >= client_info_ptr->index || index < 0)
	   return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ") ;

   switch (delete_parameters (client_info_ptr->connection_id, CM_STATIC_ROUTES_SECTION, 	
										DELETE_STATIC_ROUTE, 0, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break ;
		default : return ("\nDeleting Static Route Entry Failed. Enter exit or ESC to PREV menu:\n") ;
	}
       
   modify_config_visited = 1 ;
   client_info_ptr->next_screen = 0 ;

   client_info_ptr->menustate = TMS_IP_STATIC_RT ;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)) ;
}

/* Jo 17/08/99 Added for Static Routes */

#ifdef _BIG_PROXY_
BYTE *read_till_next_comma (BYTE *start_ptr, USHORT *length)
{
   USHORT count=0;
   BYTE *buf_ptr, *temp_ptr;

   temp_ptr = malloc (10);
   if (temp_ptr == NULL)
   {
      printf ("Malloc failed\n");
      return NULL;
   }
   buf_ptr = temp_ptr;
   while (*start_ptr != ',')
   {
      *temp_ptr++ = *start_ptr++;
      count++;
   }
   *temp_ptr = 0;
   *length = count;
   return buf_ptr;
}
                  
void initialize_ip_port_filter ()
{
	temp_ip_port_filter.protocol = 0;
	strcpy (temp_ip_port_filter.protocol_port, "0");
	temp_ip_port_filter.physical_port = 0;
	temp_ip_port_filter.filter_type = 0;
}	

BYTE	*display_ip_port_filters(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   STRUCT_IP_PORT_FILTER ip_port_filter;
   BYTE temp_buff[200];
   PARAMETER_NODE *ptr_to_previous_node;

   USHORT index=0;

	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_node != NULL)
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
		}
		else
		{
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter", (void *) &ip_port_filter);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, IPFilterPortDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

		strcpy (telnet.tx_buffer, IPFilterPortDB);
      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "   %3d.    %-4s       %-4s           %-4s     %s\n\r",
            client_info_ptr->index++,
            ip_protocol_string(dummy_ip_port_filter->protocol),
            dummy_ip_port_filter->protocol_port,
            get_ip_port_type(dummy_ip_port_filter->physical_port),
            ip_fd_entry_port_string(dummy_ip_port_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPP;
         }
      }         

      ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;

   	while (ptr_to_ip_port_filter != NULL)
   	{
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "   %3d.    %-4s       %-4s           %-4s     %s\n\r",
            client_info_ptr->index++,
            ip_protocol_string(ptr_to_ip_port_filter->protocol),
            ptr_to_ip_port_filter->protocol_port,
            get_ip_port_type(ptr_to_ip_port_filter->physical_port),
            ip_fd_entry_port_string(ptr_to_ip_port_filter->filter_type));

         strcat (telnet.tx_buffer, temp_buff);
         
         if (ptr_to_current_node != NULL)
            ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ip_port_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            memcpy ((char *) &dup_ip_port_filter, (char *) &ip_port_filter,sizeof (STRUCT_IP_PORT_FILTER));
            dummy_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &dup_ip_port_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
		}
SENDFILT_IPP:

      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_ip_port_filter ();
      client_info_ptr->menustate = TMS_ADD_PORT_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_PORT_EDIT_FILTER;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_PORT_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IPFILTPORT;
   }
   else
      return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *te_edit_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return InvalidFilter;

   client_info_ptr->edit_index = index;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidChoice);
      }
   }  
   ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;

   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;
   strcpy (temp_ip_port_filter.protocol_port, ptr_to_ip_port_filter->protocol_port);
   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;
   temp_ip_port_filter.protocol = ptr_to_ip_port_filter->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
      
   client_info_ptr->menustate = TMS_ADD_PORT_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *delete_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;


   if (!buffer)
   {
      return EnterFilter;
   }

   index = atoi (buffer) - 1;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  

   ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
   cm_remove_string (CM_IP_SECTION, "IP Port Filter", (void *)ptr_to_ip_port_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;


	client_info_ptr->menustate = TMS_IPFILTPORT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *add_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_PORT_FILTER ip_port_filter;
   STRUCT_IP_PORT_FILTER *ptr_to_ip_port_filter;
   USHORT i;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, PortFiltopt,
			ip_protocol_string(temp_ip_port_filter.protocol),
			temp_ip_port_filter.protocol_port,
			get_ip_port_type(temp_ip_port_filter.physical_port),
			ip_fd_entry_port_string(temp_ip_port_filter.filter_type));
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= IP_PORTF_PROTOCOL &&
      client_info_ptr->modify_option_rcvd <= IP_PORTF_TYPE )
   {
      client_info_ptr->menustate = TMS_IP_UPD_PORTF;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Port Filter",(void *) &ip_port_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_port_filter);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return InvalidChoice;                  
            }
         }  
         ptr_to_ip_port_filter = (STRUCT_IP_PORT_FILTER *) &ip_port_filter;
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
         cm_edit_string (CM_IP_SECTION, "IP Port Filter", (void *)ptr_to_ip_port_filter,(void *) &temp_ip_port_filter);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP Port Filter", (void *) &temp_ip_port_filter);
   
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPFILTPORT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE *upd_ip_port_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IP_PORTF_PROTOCOL:
				return (Protochoice);

   		case IP_PORTF_PROTPORT:
				return ("\n\rEnter Protocol Port:");

			case IP_PORTF_PORT:
				/* return PortChoice; Sudha 13 Feb 1998 */
            generate_no_of_ports_strings(telnet.number_of_ports,IP_ID);
            return(telnet.tx_buffer);

			case IP_PORTF_TYPE:
				return FilterTypePort;
		}
	}
	
	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case IP_PORTF_PROTOCOL:
			if (value == 1)
				temp_ip_port_filter.protocol = value-1;
			else if ( value == 2)
				temp_ip_port_filter.protocol = value-1;
			else
				return InvalidChoice;

            break;

   	case IP_PORTF_PROTPORT:
			if (strlen (buffer) > 4)
				return InvalidChoice;
			strcpy (temp_ip_port_filter.protocol_port, buffer);
			break;
				
		case IP_PORTF_PORT:
			/* if (value < 1 || value > 4) Sudha 13 Feb 1998 */
         if (value < 1 || value > telnet.number_of_ports )
				return InvalidChoice;
			temp_ip_port_filter.physical_port = value - 1;
			break;
	
		case IP_PORTF_TYPE:
			if (value < 1 || value > 4)
				return InvalidChoice;
			temp_ip_port_filter.filter_type = value -1 ;
			break;
	}
	client_info_ptr->menustate = TMS_ADD_PORT_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

static void add_IP_RIP_entry_to_buffer(IP_ROUTE_ENTRY *sptr_RIP_entry, BYTE index) 
{
	BYTE	tmp_buffer[81];

	sprintf(tmp_buffer, "%3d.   %-15s    %-15s    %-15s     %2ld      %2d\n\r", 
		index,
		convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_RIP_entry->target),
		convert_ip_address_to_dot_format(&ReplyStrs[1].ReplyStr[0], sptr_RIP_entry->gateway),
		convert_ip_address_to_dot_format(&ReplyStrs[2].ReplyStr[0], sptr_RIP_entry->mask),
		sptr_RIP_entry->metric,
		sptr_RIP_entry->port_number+1);
	strcat(telnet.tx_buffer, tmp_buffer);
}


BYTE *ip_rip_table_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	i = 0;
	IP_ROUTE_ENTRY		*sptr_RIP_entry;
	BYTE	index;

	if (client_info_ptr->more) {
		sptr_RIP_entry = (IP_ROUTE_ENTRY *)client_info_ptr->ptr_last_read_primary_table_entry;
	} else {
		/* First set of entries. Go into character-at-a-time mode */
		will_temp_echo(client_info_ptr, TOECHO);
      client_info_ptr->echoing = FALSE;

		sptr_RIP_entry = ip.route_list.sptr_forward_link;
	}

	strcpy (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu);
	index = client_info_ptr->more * MAX_ENTRIES_PER_PAGE;

	while (i < MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) {
		add_IP_RIP_entry_to_buffer (sptr_RIP_entry, ++index);
 		sptr_RIP_entry = sptr_RIP_entry->links.sptr_forward_link;
		i++;
	}

	client_info_ptr->more++;

/*	if (i == MAX_ENTRIES_PER_PAGE) 
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
*/

	if (i) {
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
		/* There are entries to be displayed. Add the continue message */
		if (i == MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) 
			strcat(telnet.tx_buffer, MoreContinue);
		else
			strcat(telnet.tx_buffer, Continue);
		return (telnet.tx_buffer);
	} else {
		/* No more entries. Go back to the parent menu */
		back_to_normal_mode(client_info_ptr);
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}		
#endif

void	initialize_values_of_new_ip_port()
{
}


void	generate_no_of_ports_strings(int no_of_ports, int section_id)
{
	BYTE temp_buf[275];
	int i;
   /* Sudha 12 Feb 1998 */
   char *menu_ptr;
	
	telnet.tx_buffer[0] = 0;
	strcpy (temp_buf, "\n\r\n\r\             << Select %s Port >> \n\r");
	switch (section_id)
	{
		case IP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IP");
							break;
#ifdef _BIG_PROXY_
		case IPX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IPX");
							break;
		case STP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "STP");
							break;
#endif
		case PPP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "PPP");
							break;
		case WAN_ID : 	sprintf (telnet.tx_buffer, temp_buf, "WAN");
							break;
#if 0
		case MUX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "MUX Data");
							break;
		case AG_ID : 	sprintf (telnet.tx_buffer, temp_buf, "AG");
							break;
#endif
      case CHAT_ID : sprintf (telnet.tx_buffer, temp_buf, "WANTalk");
                     break;
#ifdef _BIG_PROXY_
      case SLIP_ID : sprintf (telnet.tx_buffer, temp_buf, "SLIP");
                     break;
#endif
		default	:
							break;
	}


   /* Sudha 12 Feb 1998 */
   switch (telnet.model_number)
   {
      case MODEL_UNKNOWN :
         printf( "\n\rModel Unknown.");
         break;
      case MODEL_MTSR3_200 :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr3IpPPPMenu;
               break;
#if 0
            case IPX_ID :
               menu_ptr = &Mtsr3IpxPPPMenu;
               break;
#endif
            case PPP_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr3WanPPPMenu;
               break;
            case WAN_ID :

#ifdef _BIG_PROXY_ /* Jo 29/04/99 */
               if ( dial_bkup_enabled )
                  menu_ptr = &dlbkmenu;
#endif
               menu_ptr = &Mtsr3WanPPPMenu;
               break;

            default     :
               break;
         }
         break;
#ifdef _BIG_PROXY_ /* Jo 29/04/99 */
      case MODEL_MTSR1_202ST :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr1202STIpMenu;
               break;
#if 0
            case IPX_ID :
               menu_ptr = &Mtsr1202STIpxMenu;
               break;
#endif
            case PPP_ID :
            case WAN_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr1202STWanMenu;
               break;
            default     :
               break;
         }
         break;
      case MODEL_MTSR1_202NT :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr1202NTIpMenu;
               break;
#if 0
            case IPX_ID :
               menu_ptr = &Mtsr1202NTIpxMenu;
               break;
#endif
            case PPP_ID :
            case WAN_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr1202NTWanMenu;
               break;
            default     :
               break;
         }
         break;

      case MODEL_MTSR3_201 :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr3201IpPPPMenu;
               break;
#if 0
            case IPX_ID :
               menu_ptr = &Mtsr3201IpxPPPMenu;
               break;
#endif
            case PPP_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr3201WanPPPMenu;
               break;
            case WAN_ID  :
               if ( dial_bkup_enabled )
                  menu_ptr = &Mtsr3201WanBkupPPPMenu;
               else
                  menu_ptr = &Mtsr3201WanPPPMenu;
               break;
            default      :
               break;
         }
         break;
#endif /* Jo 29/04/99 */
      default  :
         break ;
   }
   strcat ( telnet.tx_buffer,menu_ptr);

   if ( section_id == MUX_ID )
   {
	   for (i = 1; i <= no_of_ports; i++)
   	{
	   	sprintf (temp_buf, "\n\r[%d] Port %2d", i, i);
		   strcat (telnet.tx_buffer, temp_buf);
   	}
	   strcat (telnet.tx_buffer, "\n\r");
   }

	if ((frame_relay_enabled) && (section_id < PPP_ID))
	{
		sprintf (temp_buf, "[%d] Add a Virtual Port", no_of_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port\n\r", no_of_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ports + 2);
	}
	else
   {
		if (no_of_ports > 1)
			sprintf (temp_buf, EnterChoice, no_of_ports);
		else
			strcpy (temp_buf, EnterSingleChoice);
   }
	strcat (telnet.tx_buffer, temp_buf);
}
      
#ifdef _BIG_PROXY_
static BYTE * ip_default_action_string (USHORT_ENUM (IP_FILTER_DEFAULT_ACTION) state)
{
	switch (state) {
		case IP_FILTER_DEFAULT_ACTION_FORWARD: return ("Forward");
		case IP_FILTER_DEFAULT_ACTION_FILTER: return ("Filter");
		default: return ("Unknown");
	}
}
#endif

BYTE *null_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   
/*         if (client_info_ptr->modify_option_rcvd == MOD_ETHER_FRAME)
              return ("\n\rFrame Type is not configurable for WAN Port\n\r\
Enter your choice (exit or ESC to previous menu):");

   else  */
      return not_supported;

}


BYTE *wrong_value_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   return wrong_value;
}

#ifdef _BIG_PROXY_
BYTE	*ip_icmp_port_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT port_number=0;

   if (!buffer)
   {
      generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
		return (telnet.tx_buffer);
   }
   
   port_number = atoi (buffer);
   client_info_ptr->menu_selected_port = port_number-1;

   if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports);
		return(telnet.tx_buffer);
	}
   client_info_ptr->more = 1;
   client_info_ptr->menustate = TMS_IP_ICMP_FILTERS;
	client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*display_ip_icmp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IP_ICMP_FILTER *ptr_to_ip_icmp_filter;
   STRUCT_IP_ICMP_FILTER ip_icmp_filter;
   USHORT i=0;

   if (!buffer)
   {
      if (client_info_ptr->more)
      {
         client_info_ptr->more = 0;
         ip_icmp_filter.physical_port = client_info_ptr->menu_selected_port;

         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP ICMP Filter", (void *) &ip_icmp_filter);
      
         ptr_to_ip_icmp_filter = (STRUCT_IP_ICMP_FILTER *) &ip_icmp_filter;
         old_ip_icmp_filter = ptr_to_ip_icmp_filter;
         
         tel_ip_icmp_filter.physical_port = client_info_ptr->menu_selected_port;

         tel_ip_icmp_filter.echo_reply  = ptr_to_ip_icmp_filter->echo_reply;
         tel_ip_icmp_filter.destination_unreachable = ptr_to_ip_icmp_filter->destination_unreachable;
         tel_ip_icmp_filter.source_quench = ptr_to_ip_icmp_filter->source_quench;
         tel_ip_icmp_filter.redirect = ptr_to_ip_icmp_filter->redirect;
         tel_ip_icmp_filter.echo_request = ptr_to_ip_icmp_filter->echo_request;
         tel_ip_icmp_filter.time_exceeded = ptr_to_ip_icmp_filter->time_exceeded;
         tel_ip_icmp_filter.parameter_problem = ptr_to_ip_icmp_filter->parameter_problem;
         tel_ip_icmp_filter.time_stamp_request = ptr_to_ip_icmp_filter->time_stamp_request;
         tel_ip_icmp_filter.time_stamp_reply = ptr_to_ip_icmp_filter->time_stamp_reply;
         tel_ip_icmp_filter.address_mask_request = ptr_to_ip_icmp_filter->address_mask_request;
         tel_ip_icmp_filter.address_mask_reply = ptr_to_ip_icmp_filter->address_mask_reply;
      }   

      sprintf (telnet.tx_buffer, IPFilterICMPDB,
         enabled_or_disabled (tel_ip_icmp_filter.echo_reply),
         enabled_or_disabled (tel_ip_icmp_filter.destination_unreachable),
         enabled_or_disabled (tel_ip_icmp_filter.source_quench),
         enabled_or_disabled (tel_ip_icmp_filter.redirect),
         enabled_or_disabled (tel_ip_icmp_filter.echo_request),
         enabled_or_disabled (tel_ip_icmp_filter.time_exceeded),
         enabled_or_disabled (tel_ip_icmp_filter.parameter_problem),
         enabled_or_disabled (tel_ip_icmp_filter.time_stamp_request),
         enabled_or_disabled (tel_ip_icmp_filter.time_stamp_reply),
         enabled_or_disabled (tel_ip_icmp_filter.address_mask_request),
         enabled_or_disabled (tel_ip_icmp_filter.address_mask_reply));
      return telnet.tx_buffer;

   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);


   if (client_info_ptr->modify_option_rcvd >= 1 &&
      client_info_ptr->modify_option_rcvd <= 11)
   {
      client_info_ptr->menustate = TMS_IP_UPD_ICMP_FILTERS;
      return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      modify_config_visited = 1;
		client_info_ptr->more = 0;
      client_info_ptr->menustate = TMS_IPFILTICMP;
      cm_edit_string (CM_IP_SECTION, "IP ICMP Filter", (void *) old_ip_icmp_filter, (void *) &tel_ip_icmp_filter);
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE	*upd_ip_icmp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT option=0;
   BYTE *new_rhs;

   if (!buffer)
      return EnaOrDis;
         
   option = atoi (buffer);

   if ( (option < 1) || (option > 2) || strlen (buffer) != 1)
		return (InvalidChoice);


   switch (client_info_ptr->modify_option_rcvd)
   {
      case 1:
         tel_ip_icmp_filter.echo_reply = option;
         break;

      case 2:
         tel_ip_icmp_filter.destination_unreachable = option;
         break;

      case 3:
         tel_ip_icmp_filter.source_quench = option;
         break;

      case 4:
         tel_ip_icmp_filter.redirect = option;
         break;

      case 5:
         tel_ip_icmp_filter.echo_request = option;
         break;

      case 6:
         tel_ip_icmp_filter.time_exceeded = option;
         break;

      case 7:
         tel_ip_icmp_filter.parameter_problem = option;
         break;

      case 8:
         tel_ip_icmp_filter.time_stamp_request = option;
         break;

      case 9:
         tel_ip_icmp_filter.time_stamp_reply = option;
         break;

      case 10:
         tel_ip_icmp_filter.address_mask_request = option;
         break;

      case 11:
         tel_ip_icmp_filter.address_mask_reply = option;
         break;
   }

   client_info_ptr->menustate = TMS_IP_ICMP_FILTERS;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
#endif   
