#if 0
#include	<defs.h>

#include        <string.h>
#include        <stdlib.h>
#include        <stdio.h>

#include        "telnet.h"
#include        "vmenu.h"

#include        "..\..\stacks\ipx\kipx.h"
#include        "..\..\stacks\ipx\vipxstr.h"
#include        "..\..\stacks\ipx\vipx.h"
#include "..\..\lsl\vbufstr.h"
#include "..\..\stacks\ipx\ipxfilt.h"

/* sudhir 3-10-96 */
#include "..\..\include\vnvrmstr.h"
#include <cfgmgr.h>

extern  IPX_CLASS       ipx_class;
extern  str_ipx_filter_class ipx_filter_class;
extern  int modify_config_visited;

extern  int no_of_ipx_networks; /* added by oss on 3-3-97 */
extern  int frame_relay_enabled; /* end of add by oss on 3-3-97 */

USHORT get_number_of_filters (BYTE *str_ptr);



extern void     generate_no_of_ports_strings(int no_of_ports, int section_id);

void            add_delete_values_of_ipx_network(int Flag, int port_no);
void            generate_network_address_from_old_values(BYTE *temp);



extern CONFIGURATION_TABLE ipx_configuration_table ;

BYTE    *get_ipx_network_number(BYTE *buf, USHORT port_number);
extern void *malloc(ULONG);


extern BYTE ChoiceBuffer[80];
extern void  delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
extern void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
extern BYTE  *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr);
extern BYTE  *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr);
extern void  set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
extern PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr);
extern void force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
extern BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array);


typedef struct IPX_FILTER_TABLE
{
	USHORT socket_number;
	USHORT port_number;
	enum IPX_FILTER_TYPE filter_type ;
	struct IPX_FILTER_TABLE *next_ptr;
	BYTE network_number[9];
	BYTE node_number[13];
}IPX_FILTER_TABLE; 

STRUCT_IPX_FILTER temp_ipx_filter;
STRUCT_IPX_FILTER dup_ipx_filter;
STRUCT_IPX_FILTER *dummy_ipx_filter;
PARAMETER_NODE *ptr_to_current_ipx_node;

USHORT no_of_ipx_filters=0;

/* sudhir 3-10-96 */

BYTE *get_physical_port_type (USHORT port_type)
{
	switch (port_type) 
   {
		case ETHERNET_PORT:   return ("LAN");
		case WAN_PORT_1: return ("WAN1");
		case WAN_PORT_2: return ("WAN2");
		case WAN_PORT_3: return ("WAN3");
		default: return ("Unknown");
	}
}

#define IPX_PORT_LAST   7

BYTE    *convert_hex_to_string_ulong(ULONG value, ULONG mask, BYTE *val_str)
{
	if (mask == (ULONG)0)
		return("xxxxxxxx");
	else
	{
		sprintf(val_str,"%08lx", value);
		return(val_str);
	}
}



BYTE    *convert_hex_to_string_ushort(USHORT value, USHORT mask, BYTE *val_str)
{
	if (mask == (USHORT)0)
		return("xxxx");
	else
	{
		sprintf(val_str,"%04x", value);
		return(val_str);
	}
}


static BYTE * ipx_fd_entry_type_string (USHORT_ENUM (FILTER) entry_type)
{
	switch (entry_type) {
#if 0
		case IPX_FILTER_ON_SOURCE_ADDRESS: return ("Filter on source address");
		case IPX_FORWARD_ON_SOURCE_ADDRESS: return ("Forward on source address");
		case IPX_FILTER_ON_DESTINATION_ADDRESS: return ("Filter on destination address");
		case IPX_FORWARD_ON_DESTINATION_ADDRESS: return ("Forward on destination address"); 
#endif
      case FILTER_ON_SOURCE: return ("Filter on source address");
		case FORWARD_ON_SOURCE: return ("Forward on source address");
		case FILTER_ON_DESTINATION: return ("Filter on destination address");
		case FORWARD_ON_DESTINATION: return ("Forward on destination address");
      default: return ("Unknown");
	}
}


/* sudhir 13-9-96 */
BYTE *modify_ipx_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE ipx_filt[] = "IPX Filtering Default Action";

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

      get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].learn_network_address,
				0, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10); 

		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.internal_SAP_id.SAP_name,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 10);				

		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.internal_SAP_id.ipx_address.network,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 10);				

		get_parameter_by_name (CM_IPX_SECTION, ipx_filt,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 10);				

      if (!ReplyStrs[4].ReplyStr[0])
         strcpy (&ReplyStrs[4].ReplyStr[0], "forward");

		sprintf (ChoiceBuffer, EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],	&ReplyStrs[2].ReplyStr[0], 
         &ReplyStrs[3].ReplyStr[0], &ReplyStrs[4].ReplyStr[0],
         GoBack, ChoiceBuffer);
		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer) ;
	if ((client_info_ptr->modify_option_rcvd >= 1) && 
		  (client_info_ptr->modify_option_rcvd <= 
						menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_IPX_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *ipx_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	BYTE  *ret_str, *new_rhs;
	BYTE ipx_fid[] = "IPX Filtering Default Action";

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case IPX_ENABLE   :     
				ret_str = EnaOrDis;
				break;
         
         case IPX_AUTOLEARN:
            ret_str = EnaOrDis;
				break;
                           
			case IPX_RTR_NAME :  
				ret_str = NewValue;
				break;

			case IPX_NW_NUMBER:     
				ret_str = NewValue;
				break;

			case IPX_DEF_FILT_ACTION: 
				ret_str = ForOrFilt;
				break;

			case IPX_PORT_INFO:
				client_info_ptr->menustate =  TMS_MODI_IPXPORT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);

		} 
		return (ret_str);
	}

	new_value = atoi (buffer);
	 switch(client_info_ptr->modify_option_rcvd)
	 {
		 case IPX_ENABLE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
   		break;

       case IPX_AUTOLEARN:
         if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
		
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].learn_network_address,
				0, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
            
		 case IPX_RTR_NAME:
			new_rhs = buffer;
         if (strlen (buffer) > 25)
            return InvalidChoice;

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.internal_SAP_id.SAP_name,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidChoice;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		 case IPX_NW_NUMBER:
         if (strlen (buffer) > 8)
            return InvalidChoice;

			new_rhs = buffer;
			 switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.internal_SAP_id.ipx_address.network,
			    CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			 {
			    case CM_ERROR_WHILE_VALIDATING:
					 return InvalidNet;

				 case CM_NOT_ENOUGH_MEMORY:
					 return Insufficient_memory;

			 }
			 break;

		 case IPX_DEF_FILT_ACTION:
			 if (new_value == 1)
				 new_rhs = &Forward[0];
			 else if (new_value == 2)
				 new_rhs = &Filter[0];
			 else
				 return (InvalidChoice);

			switch (set_parameter_by_name (CM_IPX_SECTION, ipx_fid,
			    CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			 {

				 case CM_NOT_ENOUGH_MEMORY:
					 return Insufficient_memory;

			 }
			 break;

		 case IPX_PORT_INFO:
		    client_info_ptr->menustate = TMS_MODI_IPXPORT;
			 break;

		 default:
			 sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			 return(telnet.tx_buffer);
			 break;

	  }
	  modify_config_visited = 1 ; 
	  client_info_ptr->menustate = TMS_MODI_IPXMAIN;

	  return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE    *modify_ipx_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT  port_number;

   frame_relay_enabled = 0;
	if (!buffer)
	{
		if (frame_relay_enabled) /* added by oss on 3-3-97 */
		{
			generate_no_of_ports_strings(no_of_ipx_networks, IPX_ID);
			return (telnet.tx_buffer);
		}
		generate_no_of_ports_strings(telnet.number_of_ports + 3, IPX_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);
	
	if (frame_relay_enabled) /* added by oss on 3-3-97 */
	{
		if (port_number == no_of_ipx_networks + 1)
		{
			return not_supported;

			if (no_of_ipx_networks >= MAX_NUM_OF_PORTS)
				return (MAX_16_ports);
			no_of_ipx_networks ++;
			add_delete_values_of_ipx_network(0, no_of_ipx_networks);
			client_info_ptr->menu_selected_port = port_number-1;
			client_info_ptr->menustate = TMS_IPX_PORT_CHOICE;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if (port_number == no_of_ipx_networks + 2)
		{
			return not_supported;

			client_info_ptr->menustate = TMS_IPX_DELETE_PORT;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if ((port_number > no_of_ipx_networks) || (port_number < 1))
		{
			sprintf(telnet.tx_buffer, EnterProperChoice, no_of_ipx_networks);
			return(telnet.tx_buffer);
		}
		else
		{
			client_info_ptr->menustate = TMS_IPX_PORT_CHOICE;
			client_info_ptr->menu_selected_port = port_number-1;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
	}               /* end of add by oss on 3-3-97 */

	/* 3 is added to take in to consideration 
		the effect of RAW, LLC, TYPE_II and     SNAP */

	if (port_number > ((telnet.number_of_ports) + 3) ||     port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, ((telnet.number_of_ports) + 3));
		return(telnet.tx_buffer);
	}
   else
	   client_info_ptr->menustate = TMS_IPXPORTINFO;

	client_info_ptr->menu_selected_port = port_number-1;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_ipx_port_choice_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT value;

   if (!buffer)
	{
		sprintf (ChoiceBuffer, EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
						client_info_ptr->menu_selected_port, ChoiceBuffer);
      return (telnet.tx_buffer);
	}

   value = atoi (buffer);

   if (value == 1)
   {
      client_info_ptr->menustate = TMS_MODI_IPXPORTINFO;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if (value == 2)
   {
      client_info_ptr->menustate = TMS_IPX_STAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
}


BYTE	*ipx_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) {
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1);
		return (telnet.tx_buffer);
	}

 	switch( atoi(buffer)) {
 		case IPX_PORT_SETUP:
			client_info_ptr->menustate = TMS_MODI_IPXPORTINFO;
			break;
 		case IPX_PORT_STATS:
			client_info_ptr->menustate = TMS_IPX_STAT;
			break;
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE    *ipx_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	IPX_STATISTICS  *sptr_ipx_port_class_stats;

	sptr_ipx_port_class_stats = &ipx_class.port[client_info_ptr->menu_selected_port].statistics;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_ipx_port_class_stats->number_of_packets_to_route),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_ipx_port_class_stats->number_of_tx_packets_filtered),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_ipx_port_class_stats->number_packets_forwarded),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_ipx_port_class_stats->number_of_packets_sent),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_ipx_port_class_stats->number_of_packets_too_large_received),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_ipx_port_class_stats->number_of_path_not_found_packets),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], sptr_ipx_port_class_stats->number_of_packets_to_send_discarded),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], sptr_ipx_port_class_stats->number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], sptr_ipx_port_class_stats->number_of_rx_packets_filtered),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], sptr_ipx_port_class_stats->number_of_hop_counts_too_large));

			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


/* sudhir 17-9-96 */
BYTE    *modify_ipx_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE ipx_frame[] = "IPX Port Frame Type";
	BYTE ipx_net[] = "IPX Port Network";

	if (!buffer)
	{
		initialize_replystr ();
		
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].port_enabled ,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

		get_parameter_by_name (CM_IPX_SECTION, ipx_frame,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].netbios_enabled,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[2].ReplyStr[0], 10);	
			
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].maximum_number_of_netbios_hops,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 10);	
			
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].periodic_RIP_tx_timer,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[4].ReplyStr[0], 10);	 
			
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].RIP_age_timer,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[5].ReplyStr[0], 10);	
			
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].transport_time,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[6].ReplyStr[0], 10);	
			
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].periodic_SAP_tx_timer,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[7].ReplyStr[0],10);				

		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].SAP_age_timer,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[8].ReplyStr[0], 10);
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_periodic_RIP_broadcasts,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[9].ReplyStr[0], 10);	

		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_periodic_SAP_broadcasts,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[10].ReplyStr[0], 10); 
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_serialization_spoofing,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[11].ReplyStr[0], 10); 
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_watchdog_spoofing,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[12].ReplyStr[0], 10);
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_spx_watchdog_spoofing,				
            client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[13].ReplyStr[0], 10); 
				
		get_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].network,
				client_info_ptr->menu_selected_port , CM_STRING_FORMAT,&ReplyStrs[14].ReplyStr[0], 10);

		sprintf (ChoiceBuffer, EnterChoice, 
						menufsmhdlr[client_info_ptr->menustate].num_of_items);

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port + 1,
			&ReplyStrs[0].ReplyStr[0],&ReplyStrs[1].ReplyStr[0],&ReplyStrs[2].ReplyStr[0],
			&ReplyStrs[3].ReplyStr[0],&ReplyStrs[4].ReplyStr[0],&ReplyStrs[5].ReplyStr[0],
			&ReplyStrs[6].ReplyStr[0],&ReplyStrs[7].ReplyStr[0],&ReplyStrs[8].ReplyStr[0],
			&ReplyStrs[9].ReplyStr[0],&ReplyStrs[10].ReplyStr[0],&ReplyStrs[11].ReplyStr[0],
			&ReplyStrs[12].ReplyStr[0],&ReplyStrs[13].ReplyStr[0],&ReplyStrs[14].ReplyStr[0],			
			GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_IPX_PORT_STATE) &&
			(client_info_ptr->modify_option_rcvd <= 
					menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_IPXPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}        

BYTE *upd_modify_ipx_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value, port_no;
	BYTE *ret_str, *new_rhs;
	BYTE ipx_fr[] = "IPX Port Frame Type";
	BYTE ipx_net[] = "IPX Port Network";

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{               
			case MOD_IPX_PORT_STATE:                        
				ret_str = EnaOrDis;
				break;

			case MOD_IPX_FRAME_TYPE:                        

            client_info_ptr->menustate = TMS_NULL_FUNC;
            menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPXPORTINFO;
				ret_str = not_supported;
				break;

			case MOD_NETBIOS:                                               
				ret_str = EnaOrDis;
				break;

			case MOD_IPX_MAX_NUM_HOPS:      
			case MOD_IPX_RIP_TX_TIME :  
			case MOD_IPX_RIP_AGE_TIMER:
			case MOD_IPX_RIP_TRANSPORT_TIME:
			case MOD_IPX_SAP_TX_TIME :      
			case MOD_IPX_SAP_AGE_TIMER:             
				ret_str = NewValue;
				break;

			case MOD_IPX_PERIODIC_RIP:
			case MOD_IPX_PERIODIC_SAP:
			case MOD_IPX_DISCARD_PACKETS:
			case MOD_IPX_WATCHDOG_SPOOFING:
			case MOD_SPX_WATCHDOG_SPOOFING: 
				ret_str = EnaOrDis;
				break;
			case MOD_IPX_PORT_NWNUMBER:             
				ret_str = NewValue;
				break;

			case IPX_FILTERS:

/*            client_info_ptr->menustate = TMS_NULL_FUNC;
            menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPXPORTINFO;
				return (not_supported);  */
            client_info_ptr->next_screen = 0;
	     		client_info_ptr->menustate = TMS_IPX_FILT;
/*				client_info_ptr->ptr_to_last_read_linked_list = NULL;  */
	     		no_of_ipx_filters = ipx_filter_class.ipx_number_of_dest_filter_entries +
												ipx_filter_class.ipx_number_of_src_filter_entries;
	     		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port ;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_IPX_PORT_STATE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].port_enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

/*		case MOD_IPX_FRAME_TYPE:
			if (port_no < 4)
				return (not_supported);

			switch (new_value)
			{
				case 1: new_rhs =  &RAW[0];
							break;
				case 2: new_rhs =  &LLC[0];
							break;
				case 3: new_rhs =  &TYPE[0];
							break;
				case 4: new_rhs =  &SNAP[0];
							break;
				default: sprintf (telnet.tx_buffer, EnterOption, 1, 4);
							return (telnet.tx_buffer);
			}

			switch (set_parameter_by_name (CM_IPX_SECTION, ipx_fr,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break; */

		case MOD_NETBIOS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
			
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].netbios_enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_MAX_NUM_HOPS:
			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].maximum_number_of_netbios_hops,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_RIP_TX_TIME:
			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].periodic_RIP_tx_timer,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_RIP_AGE_TIMER:
			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].RIP_age_timer,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_RIP_TRANSPORT_TIME:
			new_rhs = buffer;			
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].transport_time,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_SAP_TX_TIME:
			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].periodic_SAP_tx_timer,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_SAP_AGE_TIMER:
			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].SAP_age_timer,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_PERIODIC_RIP:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_periodic_RIP_broadcasts,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_PERIODIC_SAP:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_periodic_SAP_broadcasts,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_DISCARD_PACKETS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);
			
			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_serialization_spoofing,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_WATCHDOG_SPOOFING: 
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_watchdog_spoofing,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_SPX_WATCHDOG_SPOOFING:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			switch (set_parameter (CM_IPX_SECTION, (void *) &ipx_class.port[0].enable_spx_watchdog_spoofing,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IPX_PORT_NWNUMBER:
         if (strlen (buffer) > 8)
            return wrong_value;

			new_rhs = buffer;
			switch (set_parameter (CM_IPX_SECTION, (void *)&ipx_class.port[0].network,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidNet;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);

	}
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_IPXPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* sudhir 17-9-96 */

BYTE    *get_ipx_network_number(BYTE *buf, USHORT port_number)
{
	get_rhs_for_disp ((BYTE *) &ipx_class.port[0].network
						- (BYTE *) &ipx_class, ipx_configuration_table,
						port_number, Pointers_SectHdr.ptrs[1]);
	return (buf);
}

int get_number_of_ipx_networks()
{
	USHORT no_of_ports=0;
	
	return ipx_class.number_of_ports;

	get_parameter (CM_IPX_SECTION, (void *) &ipx_class.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT,&no_of_ports, 10);				

	return no_of_ports;
}

initialize_filter_default ()
{
   strcpy (temp_ipx_filter.network_number, "0");
   strcpy (temp_ipx_filter.node_number, "0");
   strcpy (temp_ipx_filter.socket_number, "0");
   temp_ipx_filter.physical_port = 0;
   temp_ipx_filter.filter_type = 0;
}

USHORT get_number_of_ipx_filters (BYTE *str_ptr)
{
	USHORT count=0;
	BYTE *temp_ptr;

	temp_ptr = str_ptr;
	while (*temp_ptr)
	{
		if (*temp_ptr == ',')
			count++;
		temp_ptr++;
	}
	printf ("Count is %d\n",count);
	return count;
}

BYTE *display_ipx_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IPX_FILTER *ptr_to_ipx_filter;
   STRUCT_IPX_FILTER ipx_filter;
   BYTE temp_buff[200];
   USHORT index=0;
   PARAMETER_NODE *ptr_to_previous_node;


   if (!buffer)
   {
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_ipx_node != NULL)
            ptr_to_current_ipx_node = cm_get_next_entry (CM_IPX_SECTION, ptr_to_current_ipx_node, (void *) &ipx_filter);
		}
		else
		{
         ptr_to_current_ipx_node = cm_get_first_entry (CM_IPX_SECTION, "IPX Filter", (void *) &ipx_filter);

         if (ptr_to_current_ipx_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, IPXFilteringDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

      strcpy (telnet.tx_buffer, IPXFilteringDB);

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "%3d    %s   %s   %s   %-4s   %s\n\r",
            client_info_ptr->index++,
            dummy_ipx_filter->network_number,
            dummy_ipx_filter->node_number,
            dummy_ipx_filter->socket_number,
            get_physical_port_type (dummy_ipx_filter->physical_port),
            ipx_fd_entry_type_string (dummy_ipx_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_ipx_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPX;
         }
      }

      ptr_to_ipx_filter = (STRUCT_IPX_FILTER *) &ipx_filter;

      while (ptr_to_current_ipx_node != NULL)
      {
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "%3d    %s   %s   %s   %-4s   %s\n\r",
            client_info_ptr->index++,
            ptr_to_ipx_filter->network_number,
            ptr_to_ipx_filter->node_number,
            ptr_to_ipx_filter->socket_number,
            get_physical_port_type (ptr_to_ipx_filter->physical_port),
            ipx_fd_entry_type_string (ptr_to_ipx_filter->filter_type));
         strcat (telnet.tx_buffer, temp_buff);

         
         if (ptr_to_current_ipx_node != NULL)
            ptr_to_current_ipx_node =  cm_get_next_entry (CM_IPX_SECTION, ptr_to_current_ipx_node, (void*)&ipx_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_ipx_node != NULL)
         {
            memcpy ((char *) &dup_ipx_filter, (char *) &ipx_filter, sizeof (STRUCT_IPX_FILTER));
            dummy_ipx_filter = (STRUCT_IPX_FILTER *) &dup_ipx_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_ipx_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }

         ptr_to_ipx_filter = (STRUCT_IPX_FILTER *) &ipx_filter;

		}
SENDFILT_IPX:
		strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
   }

   if ((*buffer == 'A') || (*buffer == 'a') && (strlen (buffer) == 1))
   {
      client_info_ptr->next_screen = 0;
      initialize_filter_default();
      client_info_ptr->menustate = TMS_IPX_FILT_CHOICE;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPX_EDIT_FILTER;
   }
   else if ((*buffer == 'D') || (*buffer == 'd') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IPX_DEL_FILT;
   }
   else if ((*buffer == 'N') || (*buffer == 'n') && (strlen (buffer) == 1) && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IPX_FILT;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *te_edit_ipx_filter_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IPX_FILTER ipx_filter;
   STRUCT_IPX_FILTER *ptr_to_ipx_filter;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return InvalidFilter;
   }

   client_info_ptr->edit_index = index;

   ptr_to_current_ipx_node = cm_get_first_entry (CM_IPX_SECTION, "IPX Filter",(void *) &ipx_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_ipx_node = cm_get_next_entry (CM_IPX_SECTION, ptr_to_current_ipx_node, (void *) &ipx_filter);
      if (ptr_to_current_ipx_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  
   ptr_to_ipx_filter = (STRUCT_IPX_FILTER *) &ipx_filter;


   strcpy (temp_ipx_filter.network_number, ptr_to_ipx_filter->network_number);
   strcpy (temp_ipx_filter.node_number, ptr_to_ipx_filter->node_number);
   strcpy (temp_ipx_filter.socket_number, ptr_to_ipx_filter->socket_number);
   temp_ipx_filter.physical_port = ptr_to_ipx_filter->physical_port;         
   temp_ipx_filter.filter_type = ptr_to_ipx_filter->filter_type;

   client_info_ptr->edit_filter = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_IPX_FILT_CHOICE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}


BYTE *recv_filter_choice (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_IPX_FILTER ipx_filter;
   STRUCT_IPX_FILTER *ptr_to_ipx_filter;
   USHORT i=0;

         
   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
	      temp_ipx_filter.network_number,
	      temp_ipx_filter.node_number, 
	      temp_ipx_filter.socket_number, 
	      get_physical_port_type ((USHORT)temp_ipx_filter.physical_port),
	      ipx_fd_entry_type_string (temp_ipx_filter.filter_type));
       return (telnet.tx_buffer);
   }


   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if (client_info_ptr->modify_option_rcvd >= IPX_FILT_NET &&
	 client_info_ptr->modify_option_rcvd <= IPX_FILT_TYPE)
   {
      client_info_ptr->menustate = TMS_IPX_ADD_FILTERS;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
	else if ((*buffer == 'c' || *buffer == 'C') && strlen(buffer) == 1)
	{
      modify_config_visited = 1;
      client_info_ptr->next_screen = 0;
      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_ipx_node = cm_get_first_entry (CM_IPX_SECTION, "IPX Filter",(void *) &ipx_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_ipx_node = cm_get_next_entry (CM_IPX_SECTION, ptr_to_current_ipx_node, (void *) &ipx_filter);
            if (ptr_to_current_ipx_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return (InvalidFilter);
            }                  
         }  
         ptr_to_ipx_filter = (STRUCT_IPX_FILTER *) &ipx_filter;
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
         cm_edit_string (CM_IPX_SECTION, "IPX Filter", (void *)ptr_to_ipx_filter, (void *) &temp_ipx_filter);
      }
      else
         cm_insert_string (CM_IPX_SECTION, "IPX Filter", (void *) &temp_ipx_filter);

		client_info_ptr->menustate = TMS_IPX_FILT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
	}
   else
      return InvalidChoice;
}   


BYTE *add_filters_to_ipx_fdb (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE *ret_str;
   int rcvd_val;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
	      case IPX_FILT_NET:             
            ret_str = NewValue;
				break;

	      case IPX_FILT_NODE:            
            ret_str = NewValue;
				break;

      	case IPX_FILT_SOCK:            
            ret_str = NewValue;
				break;

	      case IPX_FILT_PORT:            
            ret_str = PortChoice;
				break;

      	case IPX_FILT_TYPE:            
            ret_str = Filtertype;
				break;

      }
      return ret_str;
   }

   
   switch (client_info_ptr->modify_option_rcvd )
   {
      case IPX_FILT_NET:
	      if (strlen (buffer) > 8)
	         return (InvalidNet);

			strcpy (temp_ipx_filter.network_number, buffer);
	      break;

      case IPX_FILT_NODE :
			if (strlen (buffer) > 12)
				return InvalidChoice;
			strcpy (temp_ipx_filter.node_number, buffer);
         break;

      case IPX_FILT_SOCK :
         if (strlen (buffer) > 4)
				return InvalidChoice;
			strcpy (temp_ipx_filter.socket_number, buffer);
         break;

      case IPX_FILT_PORT :
			rcvd_val = atoi (buffer);
	      if (rcvd_val < 1 || rcvd_val > 4)
	         return (InvalidChoice);

	      temp_ipx_filter.physical_port = rcvd_val - 1;
         break;

      case IPX_FILT_TYPE :
			rcvd_val = atoi (buffer);
	      if (rcvd_val < 1 || rcvd_val > 4)
	         return (InvalidChoice);
      
         temp_ipx_filter.filter_type = rcvd_val - 1;
	      break;

   } 
   client_info_ptr->menustate = TMS_IPX_FILT_CHOICE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE * delete_ipx_filter_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_IPX_FILTER ipx_filter;
   STRUCT_IPX_FILTER *ptr_to_ipx_filter;


   if (!buffer)
      return EnterFilter;

   index = atoi (buffer) - 1;


   ptr_to_current_ipx_node = cm_get_first_entry (CM_IPX_SECTION, "IPX Filter",(void *) &ipx_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_ipx_node = cm_get_next_entry (CM_IPX_SECTION, ptr_to_current_ipx_node, (void *) &ipx_filter);
      if (ptr_to_current_ipx_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (InvalidFilter);
      }
   }  

   ptr_to_ipx_filter = (STRUCT_IPX_FILTER *) &ipx_filter;
   cm_remove_string (CM_IPX_SECTION, "IPX Filter", (void *)ptr_to_ipx_filter);
       
   modify_config_visited = 1;

   client_info_ptr->next_screen = 0;	
	client_info_ptr->menustate = TMS_IPX_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
   

BYTE  *ipx_port_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, PortNoToDelete, "IPX");
		return (telnet.tx_buffer);
	}

	new_value = atoi (buffer);
	if ((new_value > no_of_ipx_networks) || (new_value < 5))
	{
		sprintf (telnet.tx_buffer, EnterOption, 5, no_of_ipx_networks);
		return (telnet.tx_buffer);
	}
	else
	{
		no_of_ipx_networks --;
		add_delete_values_of_ipx_network(1, new_value - 1);
	}
	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



void generate_network_address_from_old_values(BYTE *temp)
{
	static int first_time_in_net = 1;
	static int Diff_in_ipx_values[10], i;
	BYTE network1[15], network2[15];

	if (first_time_in_net)
	{       /* it is 1 based */
		copy_to_temp_struct (network1,
				get_rhs_from_linked_list ("IPX Port Network =", 1, 
										Pointers_SectHdr.ptrs[1]));
		copy_to_temp_struct (network2,
				get_rhs_from_linked_list ("IPX Port Network =", 2, 
										Pointers_SectHdr.ptrs[1]));
		for (i= 0; i < 8; i++)
			Diff_in_ipx_values[i] = network2[i] - network1[i];
	}
	copy_to_temp_struct (network1, get_rhs_from_linked_list (
					"IPX Port Network =", no_of_ipx_networks - 1,
					Pointers_SectHdr.ptrs[1]));

	for (i = 0; i < 8; i++)
	{
		temp[i] = network1[i] + Diff_in_ipx_values[i];
		if (Diff_in_ipx_values[i])
		{
			if (temp[i] > 0x46)
				temp[i] -= 23;
			else
				if ((temp[i] > 0x39) && (temp[i] < 0x40))
					temp[i] += 7;
		}
	}
	temp[8] = '\0';
}


void    add_delete_values_of_ipx_network(int Flag, int port_no)
{
	BYTE *new_rhs, *lhs_para_str;
	ULONG offset;
	BYTE temp_store_for_del[100], temp[25];
	BYTE store_lhs[40];
	int i;

	sprintf (temp, "%02d", no_of_ipx_networks);
	set_rhs_in_link_list ( (ULONG) ((ULONG) &ipx_class.number_of_ports -
			(ULONG) &ipx_class), ipx_configuration_table, NOT_PORT_PARAMETER,
			Pointers_SectHdr.ptrs[1], &temp[0]);

	offset = (BYTE *) &ipx_class.port[0].port_enabled - (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].wan_port - (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_diagnostic_packets - (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_disabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].maximum_packet_size_including_header
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "1500");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].netbios_enabled - (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].maximum_number_of_netbios_hops
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "8");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].netware_lite_enabled
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_disabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].maximum_number_of_learning_retries
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "2");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].learning_holding_time
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "10");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	strcpy (store_lhs, "IPX Port Frame Type");
	lhs_para_str = store_lhs;
	if (!Flag)
	{
		strcpy (temp, "TYPE_II");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_RIP_broadcasts
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_SAP_broadcasts
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_periodic_RIP_broadcasts
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_periodic_SAP_broadcasts
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].periodic_RIP_tx_timer
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "60");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].periodic_SAP_tx_timer
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "60");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].RIP_age_timer
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "180");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].SAP_age_timer
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "180");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_serialization_spoofing
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].transport_time
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "20");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_watchdog_spoofing
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	
	offset = (BYTE *) &ipx_class.port[0].maximum_size_of_rip_packet
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "446");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].maximum_size_of_SAP_packet
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "494");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].enable_spx_watchdog_spoofing
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		new_rhs = &telnet_enabled_str[0];
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	offset = (BYTE *) &ipx_class.port[0].maximum_number_of_hops
				- (BYTE *) &ipx_class;
/*	lhs_para_str = get_lhs_str (offset, ipx_configuration_table); */
	if (!Flag)
	{
		strcpy (temp, "10");
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	strcpy (store_lhs, "IPX Virtual To Real Port");
	lhs_para_str = store_lhs;
	if (!Flag)
	{
		sprintf (temp, "%d", port_no - 4);
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}

	strcpy (store_lhs, "IPX Port Network");
	lhs_para_str = store_lhs;
	if (!Flag)
	{
		generate_network_address_from_old_values(temp);
		new_rhs = temp;
		force_write_string_with_port_num (lhs_para_str, port_no,
						new_rhs, Pointers_SectHdr.ptrs[1]);
	}
	else
	{
		sprintf (temp_store_for_del, "%s = %02d,", lhs_para_str, port_no);
		delete_string_from_linked_list (temp_store_for_del,
										Pointers_SectHdr.ptrs[1]);
		for (i = port_no; i < no_of_ipx_networks; i ++)
			modify_string_in_linked_list (lhs_para_str, i + 1, i, 
										Pointers_SectHdr.ptrs[1]);
	}
	modify_config_visited = 1 ; 
}

#endif
