/* Sudha 17 Feb 1998 */
/* Imran,made changes for LCPR */

/* 
History of Changes :
		{Jo, 04 Oct 1999, Added to support configurable FTP Data and Control Ports
			Function changed is NAT_upd_dynamic_entry_hdlr()} 
*/

#include <defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <stddef.h>

#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>

#if 0
#include "..\..\include\vnvrmstr.h"		  
#endif

#include <cfgmgr.h>
#include <cnffile.h>  


extern PROXY_SERVER_CLASS proxy_server;

BYTE dummy_nat_global_addr_ptr[25]; 
BYTE dup_nat_global_addr_ptr[16];
BYTE temp_nat_global_addr[16];

PARAMETER_NODE *ptr_to_current_nat_node;

STRUCT_NAT_STATIC_ENTRY *dummy_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY dup_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY temp_nat_static_entry;

typedef struct NAT_ADDR_LIST 
{
BYTE addr[16];
struct NAT_ADDR_LIST *next;
}NAT_ADDR_LIST;

NAT_ADDR_LIST *telnet_nat_global_addr_list=NULL;

USHORT list_index = 0;
ULONG connection_id;
int global_address_added = 0 ; /* Jo 08/06/99 */

STRUCT_NAT_DYNAMIC_ENTRY *dummy_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY dup_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY temp_nat_dynamic_entry;	

extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_even_if_zero(BYTE* address); /* Jo 08/04/99 */
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
extern int get_ulong_ip_address(char *dot_decimal,ULONG *int_ip_addr); 
extern int get_dot_decimal_ip_address (ULONG ip_address, char *dot_ip_address);
extern int get_dot_decimal_ip_address_even_if_zero (ULONG int_ip_address, char *dot_decimal_ip_address) ; /* Jo 08/04/99 */

extern int modify_config_visited;

extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_protocol_type (char *protocol_type_string, USHORT protocol_type);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
extern void get_ftp_port_numbers(ULONG connection_id, USHORT *ctrl_port, USHORT *data_port) ;
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */

extern const BYTE tcp_application_list[] ;  
extern const BYTE udp_application_list[] ;

void telnet_free_nat_global_addr_list ()
{
   NAT_ADDR_LIST *list_ptr;
   NAT_ADDR_LIST *list;

   list = telnet_nat_global_addr_list;

   if (list == NULL)
      return;
   while ( list->next != NULL )
   {
      list_ptr = list->next;
      free (list);
      list = list_ptr;
   }
   return;
}

void telnet_get_global_addr_list()
{
   BYTE nat_global_addr[16];
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   BYTE dynamic_addr[16],temp_str[70];
   BYTE *temp_buff;
	NAT_ADDR_LIST *temp_ptr, *dup_nat_addr_list;
	CNF_PROXY_ADDRESS_INFO *ptr_to_global;
	CNF_PROXY_STATIC_INFO *ptr_to_static;
	ULONG offset;
   USHORT index,no_of_entries,no_of_static_entries,entry_number,num, no_of_dynamic_entries ;
   
   telnet_free_nat_global_addr_list ();
   telnet_nat_global_addr_list = NULL;

/*   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);  */

	get_parameter(connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_dynamic_entries,2,NULL);

	get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,4,NULL);
	
	get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
		CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&offset,4,NULL);
/* Jo 08/04/99 Accept Global Zero IP address */
	get_dot_decimal_ip_address_even_if_zero (offset, dynamic_addr);
	
	get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_static_entries,4,NULL);

/* get number of dynamic entries == 0 */

/* Jo	if ((!dynamic_addr[0]) && (!no_of_static_entries))*/


   if ((no_of_dynamic_entries == 0) && (!no_of_static_entries))
	{
		entry_number = 0;

      while ( entry_number < no_of_entries )
      {
				cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,0);
				ptr_to_global = (CNF_PROXY_ADDRESS_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
				get_dot_decimal_ip_address_even_if_zero (ptr_to_global->address, nat_global_addr);

         	temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST ));
         	if (temp_ptr == NULL)
				{
	            strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
					return;
				}
					
      	   strcpy(temp_ptr->addr,nat_global_addr );
			   temp_ptr->next = telnet_nat_global_addr_list;
				telnet_nat_global_addr_list = temp_ptr;
      }
      goto GET_GLOBADDR;
   }

	entry_number = 0;
   while (entry_number < no_of_entries)
   {
		cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,0);
		ptr_to_global = (CNF_PROXY_ADDRESS_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
		get_dot_decimal_ip_address_even_if_zero (ptr_to_global->address, nat_global_addr); 

      if (strcmp(nat_global_addr,dynamic_addr) || 
				((strcmp(dynamic_addr, "0.0.0.0") == 0) && (no_of_dynamic_entries == 0)))
      {
		 	num = 0;
         while ( num < no_of_static_entries)
         {
				cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &num,1);					
				ptr_to_static = (CNF_PROXY_STATIC_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
				get_dot_decimal_ip_address_even_if_zero (ptr_to_static->global_address, nat_static_entry.global_addr);

            if (strcmp(nat_global_addr,nat_static_entry.global_addr) == 0)
				{
					if(num == no_of_static_entries)
						num++;
					break;
				}
         }
         if (num == no_of_static_entries)
         {
            temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST ));
            if (temp_ptr == NULL)
				{
	            strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
					return;
				}
					
            strcpy(temp_ptr->addr,nat_global_addr );
			   temp_ptr->next = telnet_nat_global_addr_list;
				telnet_nat_global_addr_list = temp_ptr;
         }
      }
   }

GET_GLOBADDR:
   strcpy (telnet.tx_buffer,NATGlobalAddrDB);
   index = 0;

   temp_buff = (BYTE *) malloc (50);
   if ( temp_buff == NULL )
   {
      strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
      return;
   }
   dup_nat_addr_list = telnet_nat_global_addr_list;
   while ( dup_nat_addr_list != NULL )
   {
      sprintf ( temp_buff,"%3d.   %-16s\n\r",
         ++index,
         dup_nat_addr_list->addr);
      strcat ( telnet.tx_buffer,temp_buff);
      dup_nat_addr_list = dup_nat_addr_list->next;
   }
   
   list_index = index;
   free ( temp_buff );

   if ( index >= 1 )
      sprintf (temp_str,"\n\rEnter Your Choice of index ( 1 to %d ) : ",index);
   else
      strcpy(temp_str,"\n\rNo global addr entry to map.Enter exit or ESC to PREV menu : ");
   strcat (telnet.tx_buffer,temp_str);
   return;
}


BYTE is_duplicate_global_addr ( BYTE *string_ptr )
{
	ULONG offset;
	BYTE ip_addr[16];
	CNF_PROXY_ADDRESS_INFO *ptr_to_global;
	USHORT entry_number = 0, no_of_entries;

	get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,4,NULL);

	while(entry_number < no_of_entries)
	{
		cm_get_entry(PROXY_NAT,CM_PROXY_ID,&offset, &entry_number,0);
		ptr_to_global = (CNF_PROXY_ADDRESS_INFO *) offset ;
/* Jo 08/04/99 Accept Global Zero IP address */
		get_dot_decimal_ip_address_even_if_zero (ptr_to_global->address, ip_addr);
 		if (!strcmp(ip_addr,string_ptr))
		{
			strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in global addr list.\n\r\
			Enter exit or ESC to PREV menu : ");
			return TRUE;
		}
	}
	return FALSE ;
}

BYTE is_duplicate_addr ( BYTE *string_ptr,ULONG dyn_flag )
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   CNF_PROXY_STATIC_INFO *ptr_to_static;
	CNF_PROXY_DYNAMIC_INFO *ptr_to_dynamic;
	ULONG offset;
	USHORT entry_number,no_of_entries;

	get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,4,NULL);

	entry_number = 0;
   while ( entry_number < no_of_entries)
   {
		cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number, 1);	
		ptr_to_static = (CNF_PROXY_STATIC_INFO *) offset;
		get_dot_decimal_ip_address(ptr_to_static->local_address, nat_static_entry.local_addr);

      if ( !(strcmp (nat_static_entry.local_addr,string_ptr)))
      {
         strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in static local addr list.\n\r\
Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
   }               
   if ( dyn_flag == 0 )
   {
		get_parameter(connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,      
			CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,4,NULL);
		entry_number = 0;

      while ( entry_number < no_of_entries)
      {

			cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number, 2);	
			ptr_to_dynamic = (CNF_PROXY_DYNAMIC_INFO *) offset;
			get_dot_decimal_ip_address(ptr_to_dynamic->local_address, &nat_dynamic_entry.local_addr[0]);

         if ( !(strcmp (nat_dynamic_entry.local_addr,string_ptr)))
         {
            strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in dynamic local addr list.\n\r\
Enter exit or ESC to PREV menu : ");
            return TRUE;
         }
      }   
   }
   return FALSE;
}

BYTE is_duplicate_dynamic_entry ( USHORT protocol,USHORT port )
{
   CNF_PROXY_DYNAMIC_INFO  *nat_dynamic_entry;
	ULONG offset;
	USHORT entry_number = 0, no_of_entries,proto;

	get_parameter(connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,	
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

   while ( entry_number < no_of_entries )
   {
		cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,2); 
		nat_dynamic_entry = (CNF_PROXY_DYNAMIC_INFO *) offset;
		
		proto = nat_dynamic_entry->protocol; /* Imran,10.3.99 */
			
      if ( (proto == protocol) &&
         (nat_dynamic_entry->port == port))
      {
         strcpy(telnet.tx_buffer,"\n\rEntered Protocol,Port pair already exists.\n\r\
         Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
   }
   return FALSE;
}


void initialize_NAT_global_addr()
{
   strcpy(temp_nat_global_addr,"0.0.0.0");
}

BYTE *NAT_main_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if ( !buffer)
      return (menufsmhdlr[client_info_ptr->menustate].menu);

   switch ( atoi(buffer))
   {
      case NAT_GLOBAL :
         client_info_ptr->menustate = TMS_NAT_GLOBAL;
         break;

      case NAT_MAPPING :
         client_info_ptr->menustate = TMS_NAT_MAPPING;
         break;
   
      default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
   
BYTE *NAT_global_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE *ptr_to_glob_addr;
   USHORT index=0;
   BYTE *temp_buff;
	ULONG offset, *temp_addr;	
	USHORT entry_number = 0, no_of_entries = 0;   

   if (!buffer)
   {  
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES,
					CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

      if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index;
         if (entry_number < no_of_entries )
             cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,0);
		}
		else
		{
         if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;       
            strcpy (telnet.tx_buffer,NATGlobalAddrDB);
            strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");
            return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
			cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,0);
      }            
      strcpy (telnet.tx_buffer,NATGlobalAddrDB);

      temp_buff = (BYTE *)malloc(200);
      if ( temp_buff == NULL )
         return("\n\rInsufficient memory.Enter exit or ESC to prev menu");
		ptr_to_glob_addr = (BYTE *)malloc(20);
		if(ptr_to_glob_addr == NULL)
         return("\n\rInsufficient memory.Enter exit or ESC to prev menu");
      
      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf ( temp_buff,"     %3d.      %-15s\n\r",
            client_info_ptr->index++,
            &dummy_nat_global_addr_ptr[0]);
         strcat ( telnet.tx_buffer,temp_buff);
         if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDNAT_GLBA;
			}
      }

      while (entry_number <= no_of_entries)
      {
			temp_addr = (ULONG *) offset ;
/* Jo 08/04/99 Accept Global Zero IP address */
			get_dot_decimal_ip_address_even_if_zero(*temp_addr, ptr_to_glob_addr);

         client_info_ptr->no_filters = 0;
         index++;
         sprintf ( temp_buff,"     %3d.      %-15s\n\r",
            client_info_ptr->index++,
            ptr_to_glob_addr);
         strcat ( telnet.tx_buffer,temp_buff);

			if (entry_number == no_of_entries)
				entry_number++;
         
         if (entry_number < no_of_entries)
            cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,0);

         if ((index == MAX_ENTRIES_PER_PAGE) && (entry_number < no_of_entries))
         {
				temp_addr = (ULONG *) offset ;
/* Jo 08/04/99 Accept Global Zero IP address */
				get_dot_decimal_ip_address_even_if_zero (*temp_addr, ptr_to_glob_addr);
            memcpy ((char *) &dup_nat_global_addr_ptr[0], (char *) ptr_to_glob_addr, 16);
            strcpy(dummy_nat_global_addr_ptr,dup_nat_global_addr_ptr);
            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number;
            break;
         }

         if (entry_number > no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDNAT_GLBA;
         }
      }
SENDNAT_GLBA:
      free(temp_buff);
		free(ptr_to_glob_addr);
         strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete,"); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return (telnet.tx_buffer);
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_NAT_global_addr();
      client_info_ptr->menustate = TMS_ADD_NAT_GLOBAL;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_NAT_GLOBAL;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_NAT_GLOBAL;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_global_addr_add ( TELNET_CLIENT_CLASS *client_info_ptr,BYTE *buffer)
{

	if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf ( telnet.tx_buffer,NATGlobalSingleMenu,
         temp_nat_global_addr);
      return (telnet.tx_buffer);
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);
   if ( client_info_ptr->modify_option_rcvd == 1 ) 
   {
      client_info_ptr->menustate = TMS_UPD_NAT_GLOBAL;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }

   else if ((*buffer == 'c' || *buffer == 'C' ) && strlen ( buffer ) == 1)
   {

/* Jo 08/04/99 Accept Global Zero IP address */
/* Jo     if ((is_an_ip_address ( temp_nat_global_addr )== FALSE) || 
         ( strcmp(temp_nat_global_addr,"0.0.0.0") == 0 )) */

			if (is_an_ip_address_even_if_zero (temp_nat_global_addr) == FALSE)
	         return (InvalidIP);
   	   else
			{
				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
						ADD_GLOBAL_ADDRESS_ENTRIES, 0, (void *) &temp_nat_global_addr,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						break;
					default :  return ("\nFailed to add global address\n");
				}
			}

      modify_config_visited = 1;

      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_NAT_GLOBAL;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE *NAT_global_addr_upd ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT new_value=0;

	connection_id = client_info_ptr->connection_id;
   if (!buffer)
   {
      switch(client_info_ptr->modify_option_rcvd)
      {
         case NAT_GLOBAL_START_ADDR:
            return stat_rt_target;
      }
   }
   new_value = atoi ( buffer );
   switch (client_info_ptr->modify_option_rcvd)
   {
      case NAT_GLOBAL_START_ADDR :

/* Jo 08/04/99 Accept Global Zero IP address */
         if (is_an_ip_address_even_if_zero (buffer) == FALSE )
            return (InvalidIP);
         if ( is_duplicate_global_addr (buffer) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy ( temp_nat_global_addr,buffer);
         break;

   }
   client_info_ptr->menustate = TMS_ADD_NAT_GLOBAL;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_global_addr_del(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, no_of_entries, entry_number;                                                      
   BYTE dynamic_addr[16];

   BYTE nat_global_addr[16];
	STRUCT_NAT_STATIC_ENTRY nat_static_entry;
	CNF_PROXY_STATIC_INFO *ptr_to_static_mapping;
	CNF_PROXY_ADDRESS_INFO *temp_addr;
	ULONG offset;

   if (!buffer)
      return ("\n\rEnter index of global addr to delete : ");

   index = atoi (buffer) - 1;
	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES,
			CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);
	
	if(index < 0 || index >= no_of_entries )
	{
		client_info_ptr->next_screen = 0;
		return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");
	}
	cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &index,0);
	index--;

	temp_addr = (CNF_PROXY_ADDRESS_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
	get_dot_decimal_ip_address_even_if_zero(temp_addr->address, nat_global_addr);

	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
		CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&offset,4,NULL);
/* Jo 08/04/99 Accept Global Zero IP address */
	get_dot_decimal_ip_address_even_if_zero (offset, dynamic_addr);

	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

   if ( (strcmp(dynamic_addr,&nat_global_addr[0]) == 0) && 
      (no_of_entries != 0 ))
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rDynamic mapping exists for this addr.Can't delete.\n\r\
Enter exit or ESC to PREV menu : ");
   }
   else
   {
		entry_number = 0;
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES,
			CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

      while (entry_number < no_of_entries)
      {
			cm_get_entry(PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,1);
			ptr_to_static_mapping = (CNF_PROXY_STATIC_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
			get_dot_decimal_ip_address_even_if_zero (ptr_to_static_mapping->global_address, &nat_static_entry.global_addr[0]);

         if ( !(strcmp (nat_static_entry.global_addr,nat_global_addr)))
         {
            client_info_ptr->next_screen = 0;
            return ("\n\rStatic mapping exists for this addr.Can't delete.\n\r\
Enter exit or ESC to PREV menu : ");
         }
      }
   }      
	switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
										DELETE_GLOBAL_ADDRESS_ENTRIES, 0, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

	  default :
	   	return("\nFailed to delete global address.\n\rEnter exit or ESC to prev menu");
			break;
	}
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_NAT_GLOBAL;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
      return NATMappingType;

   client_info_ptr->modify_option_rcvd = atoi (buffer);
   switch ( client_info_ptr->modify_option_rcvd )
   {
      case NAT_STATIC_MAPPING :
         client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
         break;

      case NAT_DYNAMIC_MAPPING :
         client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
         break;

      default :
         sprintf(telnet.tx_buffer, EnterProperChoice,2); 
			return(telnet.tx_buffer);
   }
   client_info_ptr->next_screen = 0;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}      

void initialize_nat_static_entry()
{
/* Jo 28/05/99 Make Global address field for configuration as blank */   
	strcpy(temp_nat_static_entry.global_addr,"");
	strcpy(temp_nat_static_entry.local_addr,"0.0.0.0");
}	

BYTE	*NAT_static_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_STATIC_ENTRY *ptr_to_nat_static_entry;
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   BYTE temp_buff[200];
	ULONG offset;	
	USHORT entry_number = 0, no_of_entries = 0;   
   USHORT index=0;
	CNF_PROXY_STATIC_INFO *temp_ptr;

	if (!buffer)
	{
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES,
				CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

		if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index;
         if (entry_number < no_of_entries )
             cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,1);
		}
		else
		{
         if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, NATStaticTableDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
			cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,1);
		}

		strcpy (telnet.tx_buffer, NATStaticTableDB);
      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "     %3d.      %-15s    %-15s\n\r",
            client_info_ptr->index++,
            dummy_nat_static_entry_ptr->global_addr,
            dummy_nat_static_entry_ptr->local_addr);
         strcat (telnet.tx_buffer, temp_buff);
         if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDSTAT_NAT;
         }
      }         

		ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) malloc (sizeof(STRUCT_NAT_STATIC_ENTRY));
		if(ptr_to_nat_static_entry == NULL)
         return("\n\rInsufficient memory.Enter exit or ESC to prev menu");
		
   	while (entry_number <= no_of_entries)
   	{
			temp_ptr = (CNF_PROXY_STATIC_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
			get_dot_decimal_ip_address_even_if_zero(temp_ptr->global_address, ptr_to_nat_static_entry->global_addr);
			get_dot_decimal_ip_address(temp_ptr->local_address, ptr_to_nat_static_entry->local_addr);

         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "     %3d.      %-15s    %-15s\n\r",
            client_info_ptr->index++,
            ptr_to_nat_static_entry->global_addr,
            ptr_to_nat_static_entry->local_addr);
         strcat (telnet.tx_buffer, temp_buff);
         
			if (entry_number == no_of_entries)
				entry_number++;

         if (entry_number < no_of_entries)
            cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,1);

         if ((index == MAX_ENTRIES_PER_PAGE) && (entry_number < no_of_entries))
         {
				temp_ptr = (CNF_PROXY_STATIC_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
				get_dot_decimal_ip_address_even_if_zero(temp_ptr->global_address, ptr_to_nat_static_entry->global_addr);
				get_dot_decimal_ip_address(temp_ptr->local_address, ptr_to_nat_static_entry->local_addr);

            memcpy ((char *) &dup_nat_static_entry_ptr, (char *) ptr_to_nat_static_entry, sizeof (STRUCT_NAT_STATIC_ENTRY));
            dummy_nat_static_entry_ptr = (STRUCT_NAT_STATIC_ENTRY *) &dup_nat_static_entry_ptr;
            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number ;
            break;
         }

         if (entry_number > no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDSTAT_NAT;
         }
		}
SENDSTAT_NAT:
		free(ptr_to_nat_static_entry);
      strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete, E:Edit, ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_nat_static_entry ();
      client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_STATIC_NAT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_STATIC_NAT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_edit_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	CNF_PROXY_STATIC_INFO *temp_ptr;
   USHORT index;
	ULONG offset;

   if (!buffer)
      return ("\n\rEnter index of static mapping : ");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return ("\n\rInvalid index to edit.Enter exit or ESC to PREV menu : ");

   client_info_ptr->edit_index = index;

	index--;
	cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &index,1);
	temp_ptr = (CNF_PROXY_STATIC_INFO *) offset;
/* Jo 08/04/99 Accept Global Zero IP address */
	get_dot_decimal_ip_address_even_if_zero (temp_ptr->global_address, &temp_nat_static_entry.global_addr[0]);
	get_dot_decimal_ip_address(temp_ptr->local_address, &temp_nat_static_entry.local_addr[0]);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
   
   client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *NAT_del_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0 ;

   if (!buffer)
      return ("\n\rEnter index of static mapping to delete : ");

   index = atoi (buffer) - 1;

	if (index >= client_info_ptr->index || index < 0)
	   return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");

	switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
										DELETE_PROXY_STATIC_MAPPING, 1, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

	  default :
	   	return ("\nFailed to delete static mapping.Enter exit or ESC to PREV menu :\n");
	}
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;
   client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_add_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG offset;	

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, NATStaticMappingMenu,
			temp_nat_static_entry.global_addr,
         temp_nat_static_entry.local_addr);
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= NAT_STATIC_GLOBAL &&
      client_info_ptr->modify_option_rcvd <= NAT_STATIC_LOCAL )
   {
      client_info_ptr->menustate = TMS_UPD_STATIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
/* Jo 08/04/99 Accept Global Zero IP address */

/*  Jo    if ((strcmp(temp_nat_static_entry.global_addr,"0.0.0.0") != 0) && 
         (strcmp(temp_nat_static_entry.local_addr,"0.0.0.0") != 0)) */

		if (strcmp(temp_nat_static_entry.local_addr,"0.0.0.0") != 0)
      {
         modify_config_visited = 1;
      
         if (client_info_ptr->edit_filter)
         {
            client_info_ptr->edit_filter = 0;
				
				if(!cm_edit_entry(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_NAT,	
						client_info_ptr->edit_index, (void *) &temp_nat_static_entry, 1))   
					return("\nEditing Failed.Enter exit or ESC to PREV menu:");

         }
         else
			{
			 	switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 	
						ADD_PROXY_STATIC_MAPPING, 1, (void *) &temp_nat_static_entry,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						break;
					default :  return ("\nFailed to add static mapping.Enter exit or ESC to PREV menu:\n");
				}
			 }
      }
      else
         return ("\n\rInvalid Address.\n\r");

		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE *NAT_upd_static_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0,i=0;
   BYTE *addr_value;
   NAT_ADDR_LIST *dup_nat_addr_list;
   ULONG flag = 0;
	
	connection_id = client_info_ptr->connection_id;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case NAT_STATIC_GLOBAL:
				connection_id = client_info_ptr->connection_id;
            telnet_get_global_addr_list();
            return telnet.tx_buffer;

         case NAT_STATIC_LOCAL:
				return ("\n\rEnter Local Addr to map : ");
		}
	}
	value = atoi (buffer);
   addr_value = buffer;

	switch (client_info_ptr->modify_option_rcvd)
	{
		case NAT_STATIC_GLOBAL:
			if ((value <= 0) || (value > list_index))
            return InvalidChoice;
         else
         {
            dup_nat_addr_list = telnet_nat_global_addr_list;
            for ( i = 0;i < value-1 ;i++)
            {
               dup_nat_addr_list = dup_nat_addr_list->next;
               if ( dup_nat_addr_list == NULL )
                  return InvalidChoice;
            }
            strcpy (temp_nat_static_entry.global_addr,dup_nat_addr_list->addr);
         }
         break;

   	case NAT_STATIC_LOCAL:
/* Jo 08/04/99 Accept Global Zero IP address */
         if (is_an_ip_address_even_if_zero (addr_value) == FALSE )
            return ("\n\rEntered address is invalid.Enter exit or ESC to PREV menu : ");
         if (is_duplicate_addr(addr_value,flag) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy (temp_nat_static_entry.local_addr,buffer);             
			break;
				
	}
   client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_nat_dynamic_entry()
{
	strcpy (temp_nat_dynamic_entry.local_addr, "0.0.0.0");
   temp_nat_dynamic_entry.port = 0;
   temp_nat_dynamic_entry.protocol = 0;
}

BYTE	*NAT_dynamic_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
	CNF_PROXY_DYNAMIC_INFO *ptr_to_dynamic;
   BYTE temp_buff[200],dynamic_addr[16];
   BYTE port_buff[20], protocol_buff[25];
	ULONG offset,ip_addr;	
	USHORT entry_number = 0, no_of_entries = 0;   
   USHORT index=0;

   dynamic_addr[0] = 0;
   
	if (!buffer)
	{
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,
				CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

		if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index;
			if (entry_number < no_of_entries )         
             cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,2);   
		}
		else
		{
         if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;
            set_parameter (client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,dynamic_addr,0,NULL);
				strcpy (telnet.tx_buffer, NATTableDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
			cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,2);   
		}

		strcpy (telnet.tx_buffer, NATTableDB);

      get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
         CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&ip_addr,4,NULL);
/* Jo 08/04/99 Accept Global Zero IP address */
		get_dot_decimal_ip_address_even_if_zero (ip_addr, &dynamic_addr[0]);

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "     %3d.    %-15s   %-15s   %-4s   %s (%04d)\n\r",
         client_info_ptr->index++,
         dynamic_addr,
         dummy_nat_dynamic_entry_ptr->local_addr,
         get_protocol_type (protocol_buff,dummy_nat_dynamic_entry_ptr->protocol),
         get_port_type (port_buff, dummy_nat_dynamic_entry_ptr->protocol,dummy_nat_dynamic_entry_ptr->port),
         dummy_nat_dynamic_entry_ptr->port);
         strcat (telnet.tx_buffer, temp_buff);
         if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDDYN_NAT;
         }
      }         

		ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) malloc (sizeof(STRUCT_NAT_DYNAMIC_ENTRY));
		if(ptr_to_nat_dynamic_entry == NULL)
         return("\n\rInsufficient memory.Enter exit or ESC to prev menu");

   	while (entry_number <= no_of_entries)
   	{
			ptr_to_dynamic = (CNF_PROXY_DYNAMIC_INFO *) offset ;
			get_dot_decimal_ip_address(ptr_to_dynamic->local_address, ptr_to_nat_dynamic_entry->local_addr);
			ptr_to_nat_dynamic_entry->port = ptr_to_dynamic->port;
			ptr_to_nat_dynamic_entry->protocol = ptr_to_dynamic->protocol;

			if (ptr_to_nat_dynamic_entry->protocol == 0)
				ptr_to_nat_dynamic_entry->protocol = 6;
			else if (ptr_to_nat_dynamic_entry->protocol == 1)
				ptr_to_nat_dynamic_entry->protocol = 17; 

         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "     %3d.    %-15s   %-15s   %-4s   %s (%04d)\n\r",
            client_info_ptr->index++,
            dynamic_addr,
            ptr_to_nat_dynamic_entry->local_addr,
            get_protocol_type (protocol_buff,ptr_to_nat_dynamic_entry->protocol),
            get_port_type (port_buff, ptr_to_nat_dynamic_entry->protocol,ptr_to_nat_dynamic_entry->port),
            ptr_to_nat_dynamic_entry->port);
         strcat (telnet.tx_buffer, temp_buff);
			
         if (entry_number == no_of_entries)
				entry_number++;

         if (entry_number < no_of_entries)
            cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &entry_number,2);

         if ((index == MAX_ENTRIES_PER_PAGE) && (entry_number < no_of_entries))
         {
				ptr_to_dynamic = (CNF_PROXY_DYNAMIC_INFO *) offset ;
				get_dot_decimal_ip_address(ptr_to_dynamic->local_address, ptr_to_nat_dynamic_entry->local_addr);
				ptr_to_nat_dynamic_entry->port = ptr_to_dynamic->port;
				ptr_to_nat_dynamic_entry->protocol = ptr_to_dynamic->protocol;

            memcpy ((char *) &dup_nat_dynamic_entry_ptr, (char *) ptr_to_nat_dynamic_entry, sizeof (STRUCT_NAT_DYNAMIC_ENTRY));
            dummy_nat_dynamic_entry_ptr = (STRUCT_NAT_DYNAMIC_ENTRY *) &dup_nat_dynamic_entry_ptr;

				if (dummy_nat_dynamic_entry_ptr->protocol == 0)
					dummy_nat_dynamic_entry_ptr->protocol = 6;
				else if (dummy_nat_dynamic_entry_ptr->protocol == 1)
					dummy_nat_dynamic_entry_ptr->protocol = 17;     

            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number;
            break;
         }

         if (entry_number > no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDDYN_NAT;
         }
		}
SENDDYN_NAT:
		free(ptr_to_nat_dynamic_entry);
      strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete, E:Edit, ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_nat_dynamic_entry ();
      client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_DYNAMIC_NAT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_DYNAMIC_NAT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_edit_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   CNF_PROXY_DYNAMIC_INFO *ptr_to_nat_dynamic_entry;
   USHORT i;
   USHORT index;
	ULONG offset;

   if (!buffer)
      return ("\n\rEnter index of dynamic mapping : ");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return ("\n\rInvalid index to edit.Enter exit or ESC to PREV menu : ");

   client_info_ptr->edit_index = index;
	index--;
	cm_get_entry (PROXY_NAT, CM_PROXY_ID, &offset, &index,2);
	ptr_to_nat_dynamic_entry = (CNF_PROXY_DYNAMIC_INFO *) offset;

	get_dot_decimal_ip_address(ptr_to_nat_dynamic_entry->local_address, &temp_nat_dynamic_entry.local_addr[0]);
   temp_nat_dynamic_entry.port = ptr_to_nat_dynamic_entry->port;
   temp_nat_dynamic_entry.protocol = ptr_to_nat_dynamic_entry->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
   
   client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_del_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0,no_of_entries;
	ULONG null_ptr;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   BYTE dynamic_addr[16];

   if (!buffer)
      return ("\n\rEnter index of dynamic mapping to delete : ");

   index = atoi (buffer) - 1;

	if (index >= client_info_ptr->index || index < 0)
	   return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");

	switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
										DELETE_PROXY_DYNAMIC_MAPPING, 2, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

	  default :
	   	return ("\nFailed to delete dynamic mapping.Enter exit or ESC to PREV menu\n");
	}
	    
	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

   if (!no_of_entries)
   {
      null_ptr = 0;
      set_parameter (client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&null_ptr,2,NULL);
		global_address_added = 0 ; /* Jo */
   }

   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_add_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE port_buff[20], protocol_buff[20];
	ULONG ip_addr;
	USHORT no_of_entries;
	BYTE dynamic_addr[16];
	STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;

   dynamic_addr[0] = 0;
/* Jo 28/05/99 Make Global address field for configuration as blank */   
   get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
      CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&ip_addr,4,NULL);

/* Jo 08/06/99 */
	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,      
		CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,4,NULL);

	if ((no_of_entries != 0) || (global_address_added))
		get_dot_decimal_ip_address_even_if_zero (ip_addr, &dynamic_addr[0]);

	if (!buffer)
	{
		if (temp_nat_dynamic_entry.protocol == 0)
			temp_nat_dynamic_entry.protocol = 6;
		else if (temp_nat_dynamic_entry.protocol == 1)
			temp_nat_dynamic_entry.protocol = 17; 

      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, NATDynamicMappingMenu,
         dynamic_addr,
         temp_nat_dynamic_entry.local_addr,
         get_protocol_type ( protocol_buff, temp_nat_dynamic_entry.protocol),
         get_port_type ( port_buff, temp_nat_dynamic_entry.protocol,temp_nat_dynamic_entry.port),
         temp_nat_dynamic_entry.port);
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= NAT_DYNAMIC_GLOBAL &&
      client_info_ptr->modify_option_rcvd <= NAT_DYNAMIC_PORT )
   {
      client_info_ptr->menustate = TMS_UPD_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      if (is_duplicate_dynamic_entry ( temp_nat_dynamic_entry.protocol,
         temp_nat_dynamic_entry.port) == TRUE )
         return telnet.tx_buffer;

     	if ((strcmp(temp_nat_dynamic_entry.local_addr,"0.0.0.0") == 0) ||
         (temp_nat_dynamic_entry.port == 0 ))
	   	   return("\n\rValues for all fields needed.Enter exit or ESC to PREV menu : ");

      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         client_info_ptr->edit_filter = 0;

         if (temp_nat_dynamic_entry.protocol == 6)
				temp_nat_dynamic_entry.protocol = 0;
			else if (temp_nat_dynamic_entry.protocol == 17)
				temp_nat_dynamic_entry.protocol = 1; 

			if(! cm_edit_entry(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_NAT,
					client_info_ptr->edit_index, (void *) &temp_nat_dynamic_entry, 2))   
				return("\n\rEditing failed. Enter exit or ESC to prev menu");
      }
      else
      {
			if (temp_nat_dynamic_entry.protocol == 6)
				temp_nat_dynamic_entry.protocol = 0;
			else if (temp_nat_dynamic_entry.protocol == 17)
				temp_nat_dynamic_entry.protocol = 1; 
			
			switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION,
					ADD_PROXY_DYNAMIC_MAPPING, 2, (void *) &temp_nat_dynamic_entry,NULL))
			{
				case CM_ADD_SUCCESSFUL : 
					break;
				default :  return ("\nFailed to add dynamic mapping.Enter exit or ESC to PREV menu\n");
			}
      }   
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}

BYTE *update_nat_dynamic_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT new_value =0;

	if (!buffer)
		return ("\n\rEnter Proxy Application Port to map : ");

	new_value = atoi (buffer);

	if (new_value > 0 && new_value <= 1024)
	{
		temp_nat_dynamic_entry.port = new_value;
      client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return InvalidChoice;
}

BYTE *NAT_upd_dynamic_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0, i=0, no_of_entries;
   BYTE dynamic_addr[16];
   BYTE port_buff[20];
   NAT_ADDR_LIST *dup_nat_addr_list;
   ULONG flag = 1,ip_addr;
	USHORT ctrl_port = 0, data_port = 0 ;

   dynamic_addr[0] = 0;
	get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
	   CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&ip_addr,4,NULL);
/* Jo 08/04/99 Accept Global Zero IP address */
	get_dot_decimal_ip_address_even_if_zero (ip_addr, &dynamic_addr[0]);

	connection_id = client_info_ptr->connection_id;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case NAT_DYNAMIC_GLOBAL:
/* Jo 08/04/99 Accept Global Zero IP address */
/* Jo       if (!(dynamic_addr[0]) || (!(strcmp(dynamic_addr,"0.0.0.0")))) */
         
				get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES,
					CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

			   if (no_of_entries == 0)
			   {
					connection_id = client_info_ptr->connection_id;
               telnet_get_global_addr_list();
               return telnet.tx_buffer;
            }
            else
               return not_supported;

         case NAT_DYNAMIC_LOCAL:
   	      return("\n\rEnter Local addr to map : ");   

         case NAT_DYNAMIC_PROTOCOL:
            return (Protochoice);
            
         case NAT_DYNAMIC_PORT:
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
            if (!strcmp (get_protocol_type (port_buff,temp_nat_dynamic_entry.protocol), "TCP"))
				{
				 	get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
				 	sprintf(telnet.tx_buffer, tcp_application_list,	ctrl_port, data_port) ;
				 	return telnet.tx_buffer ;
				}
				else if (!strcmp (get_protocol_type (port_buff,temp_nat_dynamic_entry.protocol), "UDP"))
				{
				 	get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
				 	sprintf(telnet.tx_buffer, udp_application_list,	ctrl_port, data_port) ;
				 	return telnet.tx_buffer ;
				}
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */
				else
					return ("\n\rUnknown Protocol");		
      }
   }

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case NAT_DYNAMIC_GLOBAL:
/* Jo 08/04/99 Accept Global Zero IP address */
/* Jo    if ( !(dynamic_addr[0]) || (!(strcmp(dynamic_addr,"0.0.0.0")))) 
			{ */
	   		if ((value <= 0) || (value > list_index))
               return InvalidChoice;
            else
            {
               dup_nat_addr_list = telnet_nat_global_addr_list;
               for ( i = 0;i < value-1 ;i++)
               {
                  dup_nat_addr_list = dup_nat_addr_list->next;
                  if ( dup_nat_addr_list == NULL )
                     return InvalidChoice;
               }
               strcpy (dynamic_addr,dup_nat_addr_list->addr);
					get_ulong_ip_address(dynamic_addr,&ip_addr);

               set_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_ULONG_FORMAT,&ip_addr,4,NULL);
					global_address_added = 1 ; /* Jo 08/06/99 */
            }
/* Jo    }*/
         break;
      
      case NAT_DYNAMIC_LOCAL:
         if ( is_an_ip_address ( buffer ) == FALSE )
            return ("\n\rEntered address is invalid.Enter exit or ESC to PREV menu : ");
         if (is_duplicate_addr(buffer,flag) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy (temp_nat_dynamic_entry.local_addr,buffer);             
			break;

   	case NAT_DYNAMIC_PROTOCOL:
         if (value == 1)
				temp_nat_dynamic_entry.protocol = 6 ;
			else if (value == 2)
				temp_nat_dynamic_entry.protocol = 17 ;
			else
				return InvalidChoice;
			break;
	
		case NAT_DYNAMIC_PORT:
			if (temp_nat_dynamic_entry.protocol == 6)
			{
				if (value < (MAX_TCP_APPLICATIONS + 1))
				{
					temp_nat_dynamic_entry.port = get_protocol_port_number (temp_nat_dynamic_entry.protocol , value);
				}
				else if (value == (MAX_TCP_APPLICATIONS + 1))
				{
					return(not_supported);
#if 0
               client_info_ptr->menustate = TMS_APP_UPD_DYNAMIC;
               return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
#endif
				}
				else
					return InvalidChoice;
			}	
			else if (temp_nat_dynamic_entry.protocol == 17)
			{
				if (value < (MAX_UDP_APPLICATIONS + 1))
					temp_nat_dynamic_entry.port = get_protocol_port_number (temp_nat_dynamic_entry.protocol ,value);
				else if (value == (MAX_UDP_APPLICATIONS + 1))
				{
					return(not_supported);
#if 0
               client_info_ptr->menustate = TMS_APP_UPD_DYNAMIC;
               return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
#endif
				}
				else
					return InvalidChoice;
			}
			else 
				return ("\n\rUnknown Protocol");
			break;

	}

   client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
