/* Sudha 17 Feb 1998 */
#include <defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <stddef.h>


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>

#if 0
#include "..\..\include\vnvrmstr.h"		  
#endif

#include <cfgmgr.h>


PARAMETER_NODE *ptr_to_current_node;

BYTE *dummy_nat_global_addr_ptr[16]; 
BYTE dup_nat_global_addr_ptr[16];
BYTE temp_nat_global_addr[16];

typedef struct nat_global_addr
{
   BYTE start_addr[16];
   BYTE end_addr[16];
   BYTE subnet_mask[16];
}NAT_GLOBAL_ADDR;

NAT_GLOBAL_ADDR temp_addr;

STRUCT_NAT_STATIC_ENTRY *dummy_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY dup_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY temp_nat_static_entry;

STRUCT_NAT_DYNAMIC_ENTRY *dummy_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY dup_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY temp_nat_dynamic_entry;	

extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);


extern int modify_config_visited;

extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_protocol_type (char *protocol_type_string, USHORT protocol_type);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);

extern BYTE tcp_application_list[];
extern BYTE udp_application_list[];

/* char start_global_addr[20],end_global_addr[20],subnet_mask[20];*/

BYTE *NAT_main_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if ( !buffer)
      return (menufsmhdlr[client_info_ptr->menustate].menu);

   switch ( atoi(buffer))
   {
      case NAT_GLOBAL :
         client_info_ptr->menustate = TMS_NAT_GLOBAL;
         break;

      case NAT_MAPPING :
         client_info_ptr->menustate = TMS_NAT_MAPPING;
         break;
   
      default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_nat_global_addr ()
{
   strcpy (temp_addr.start_addr,"0.0.0.0");
   strcpy (temp_addr.end_addr,"0.0.0.0");
   strcpy (temp_addr.subnet_mask,"0.0.0.0");
}
   
BYTE *NAT_global_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE *ptr_to_glob_addr[16];
   BYTE glob_addr[16];
   USHORT index=0;
   BYTE temp_buff[200];
   PARAMETER_NODE *ptr_to_previous_node;

   if (!buffer)
   {  
      if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_node != NULL)
            ptr_to_current_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_node, (void *) &glob_addr);
		}
		else
		{
         ptr_to_current_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT Global Address", (void *) &glob_addr);

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;       
            strcpy (telnet.tx_buffer,NATGlobalAddrDB);
            strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");            
            return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
      }            
      strcpy (telnet.tx_buffer,NATGlobalAddrDB);

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf ( temp_buff,"%3d.   %-16s\n\r",
            client_info_ptr->index++,
            dummy_nat_global_addr_ptr);
         strcat ( telnet.tx_buffer,temp_buff);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDNAT_GLBA;
			}
      }

      ptr_to_glob_addr = (BYTE *) &glob_addr;

      while (ptr_to_current_node != NULL)
      {
         client_info_ptr->no_filters = 0;
         index++;
         sprintf ( temp_buff,"%3d.   %-16s\n\r",
            client_info_ptr->index++,
            ptr_to_glob_addr);
         strcat ( telnet.tx_buffer,temp_buff);
         
         if (ptr_to_current_node != NULL)
            ptr_to_current_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_node, (void*)&glob_addr);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            memcpy ((char *) &dup_nat_global_addr_ptr, (char *) &glob_addr, 16 );    
            dummy_nat_global_addr_ptr = &dup_nat_global_addr_ptr;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_glob_addr = &glob_addr;
      }
SENDNAT_GLBA:
         strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete,"); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_nat_global_addr ();
      return ( NAT_global_addr_add(client_info_ptr,NULL));
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
      return ( NAT_global_addr_del(client_info_ptr,NULL));
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_NAT_GLOBAL;
   }
   else
      return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_global_addr_add ( TELNET_CLIENT_CLASS *client_info_ptr,BYTE *buffer)
{
   ULONG i=0;
   ULONG start_ip_address_array[4];
	ULONG end_ip_address_array[4];
   BYTE global_addr[16];
   BYTE *ptr_to_global_addr[16];

	if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf ( telnet.tx_buffer,NATGlobalRangeMenu,
         temp_addr.start_addr,
         temp_addr.end_addr,
         temp_addr.subnet_mask);
         &end_global_addr[0],&subnet_mask[0] );
      return telnet.tx_buffer;
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if ( client_info_ptr->modify_option_rcvd >= NAT_GLOBAL_START_ADDR &&
      client_info_ptr->modify_option_rcvd <= NAT_GLOBAL_SUBNET_MASK)
      return ( NAT_global_addr_upd ( client_info_ptr, NULL));

   else if ((*buffer == 'c' || *buffer == 'C' ) && strlen ( buffer ) == 1)
   {
      modify_config_visited = 1;

      if ( (!(&start_global_addr[0])) && (!(&end_global_addr[0]))) 
         return ("\n\r\Address can't be empty.Enter 1 to 3,exit or ESC to PREV menu : "); 
      if ( ((&start_global_addr[0]) && (&end_global_addr[0])) && (!(&subnet_mask[0]))) 
         return ("\n\r\Enter Subnet Mask.Enter 1 to 3, exit or ESC to PREV menu : ");
      if ((&start_global_addr[0]) && (!(&end_global_addr[0])))
      {
         if (is_an_ip_address (&start_global_addr[0])== FALSE)
            return (InvalidIP);
         else
            add_addr (ptr_to_current_glob_addr_node,&start_global_addr[0]);
      }
      else if ((!(&start_global_addr[0])) && (&end_global_addr[0])) 
      {
         if ( is_an_ip_address (&end_global_addr[0])== FALSE)
            return (InvalidIP);
         else
            add_addr ( ptr_to_current_glob_addr_node,&end_global_addr[0] );
      }
      else if ( local_ip_address_and_remote_ip_address_on_same_network
         (&start_global_addr[0],&end_global_addr[0],&subnet_mask[0])==FALSE)
            return ("\n\r\Invalid Value.Enter 1 to 3,exit or ESC to PREV menu : ");
      else
      {
         sscanf ( &start_global_addr[0],"%03u.%03u.%03u.%03u",
            (ULONG *)(&start_ip_address_array[0]),(ULONG *)(&start_ip_address_array[1]),
      		(ULONG *)(&start_ip_address_array[2]),(ULONG *)(&start_ip_address_array[3]));

         sscanf(&end_global_addr[0], "%03u.%03u.%03u.%03u", 	
      		(ULONG *)(&end_ip_address_array[0]),(ULONG *)(&end_ip_address_array[1]),
	      	(ULONG *)(&end_ip_address_array[2]),(ULONG *)(&end_ip_address_array[3]));

         for ( i = start_ip_address_array[3]; i <= end_ip_address_array[3]; i++)
         {
            sprintf ( glob_addr,"%03u.%03u.%03u.%03u",&start_ip_address_array[0],
               &start_ip_address_array[1],&start_ip_address_array[2],i);
            add_addr ( ptr_to_current_glob_addr_node, &glob_addr[0]);
         }   
      }
   }
   client_info_ptr->next_screen = 0;
   client_info_ptr->menustate = TMS_NAT_GLOBAL;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_global_addr_upd ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT new_value=0;

   if (!buffer)
   {
      switch(client_info_ptr->modify_option_rcvd)
      {
         case NAT_GLOBAL_START_ADDR:
            return stat_rt_target;
         
         case NAT_GLOBAL_END_ADDR :
            return stat_rt_target;

         case NAT_GLOBAL_SUBNET_MASK :
            return stat_rt_mask;
      }
   }
   new_value = atoi ( buffer );
   switch (client_info_ptr->modify_option_rcvd)
   {
      case NAT_GLOBAL_START_ADDR :
         if (is_an_ip_address (buffer) == FALSE )
            return (InvalidIP);
         
         strcpy ( &start_global_addr[0],buffer);
         break;

      case NAT_GLOBAL_END_ADDR :
         if (is_an_ip_address (buffer) == FALSE )
            return (InvalidIP);
         
         strcpy ( &end_global_addr[0],buffer);
         break;

      case NAT_GLOBAL_SUBNET_MASK :
         if (validate_subnetmask (buffer) == FALSE )
            return ("\n\rInvalid Subnetmask\n\r");
         
         strcpy ( &subnet_mask[0],buffer);
         break;
   }
   return (NAT_global_addr_add(client_info_ptr,NULL));
}

BYTE *NAT_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
      return NATMappingType;

   client_info_ptr->modify_option_rcvd = atoi (buffer);
   switch ( client_info_ptr->modify_option_rcvd )
   {
      case NAT_STATIC_MAPPING :
         return ( NAT_static_mapping_hdlr(client_info_ptr,NULL));

      case NAT_DYNAMIC_MAPPING :
        return ( NAT_dynamic_mapping_hdlr(client_info_ptr,NULL));
         default :
         sprintf(telnet.tx_buffer, EnterProperChoice,2); 
			return(telnet.tx_buffer);
   }
}      

BYTE *NAT_static_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
      return NATStaticMappingMenu;

}

BYTE *NAT_dynamic_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
      return NATDynamicMappingMenu;
}
