/* Imran,made changes for LCPR */
#include <defs.h>

/* 
History of Changes :
		{Jo, 04 Oct 1999, Added to support configurable FTP Data and Control Ports
			Added function get_ftp_port_numbers().
			Changed udp_application_list[], udp_application_list[], ProxyMenu[]. 
			Functions changed are proxy_main_hdlr(), proxy_modify_info_hdlr(), upd_proxy_application()}
*/

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <stddef.h>


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>

#if 0
#include "..\..\include\vnvrmstr.h"		  
#endif

#include <cfgmgr.h>
#include <cnffile.h>  

PARAMETER_NODE *ptr_to_current_proxy_node;
STRUCT_PROXY_ENTRY *dummy_proxy_application_ptr;
STRUCT_PROXY_ENTRY dup_proxy_application_ptr;
STRUCT_PROXY_ENTRY temp_proxy_application;	

/* Imran 4/1/99 */
STRUCT_PROXY_USER_ENTRY *dummy_proxy_user_app_ptr;
STRUCT_PROXY_USER_ENTRY dup_proxy_user_app_ptr;
STRUCT_PROXY_USER_ENTRY temp_proxy_user_app;	
/* Imran 4/1/99 */

STRUCT_PROXY_FILTER *dummy_proxy_addr_filter;
STRUCT_PROXY_FILTER dup_proxy_addr_filter;
STRUCT_PROXY_FILTER temp_proxy_addr_filter;

BYTE menu_ptr[20];

ULONG parameter_id;
ULONG filter_or_app;
BYTE RangeEnabled;  /* Imran */

/*  Imran 8/9/98  */
void  get_ip_address_in_required_format(int filter_type, ULONG *offset, BYTE *temp_addr);
/*  Imran 8/9/98  */

extern int modify_config_visited;
extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_duplicate_application(USHORT protocol, USHORT port, USHORT index);

extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_protocol_type (char *protocol_type_string, USHORT protocol_type);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
void get_ftp_port_numbers (ULONG connection_id, USHORT *ctrl_port, USHORT *data_port) ;
extern BOOL IsStrNumericAndValid (char *Str) ;
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */


/* Jo 08/06/99 Added new ports nos. for VOIP and Road Runner */
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
BYTE tcp_application_list[] =
"\n\r\
\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] RLOGIN (513)        [11] SMTP (25)           [12] TELNET (23)\n\r\
[13] TFTP (69)           [14] HTTP (80)           [15] HOST NAME SERVER(42)\n\r\
[16] HTTPS (443)         [17] IRC (194)           [18] NNTP (119)\n\r\
[19] SSL_NNTP (563)      [20] SSL_SMTP (465)      [21] IMAP (143)\n\r\
[22] SNMP (161)          [23] SNMP_TRAP (162)	  [24] IMAP3 (220)\n\r\
[25] SSL_FTP (989,990)	 [26] SSL_Telnet (992)    [27] SSL_IMAP4 (993)\n\r\
[28] SSL-IRC (994)       [29] SSL-POP3 (995)      [30] Real audio/video(1090)\n\r\
[31] PPTP (1723)         [32] MIRC (6667)         [33] MS_Streaming(1755)\n\r\
[34] Vxtreme (8000)      [35] Real audio/video (7070)\n\r\
[36] AOL(5190)           [37] Q931(900,902)       [38] RTP(5004,5006)\n\r\
[39] RTCP(5005,5007)     [40] Road Runner1 (6284) [41] Road Runner2 (6285)\n\r\
[42] Road Runner3 (7283) [43] VOIP Statistics (5000)\n\r\
[44] Others\n\r\
\n\r\
Enter Your Choice (1 to 44) : "; 

/* Jo 08/06/99 Added new ports nos. for VOIP and Road Runner */
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
BYTE udp_application_list[] = 
"\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] SMTP (25)           [11] TELNET (23)         [12] TFTP (69)\n\r\
[13] HTTP (80)           [14] HOST NAME SERVER(42)\n\r\
[15] HTTPS (443)         [16] IRC (194)           [17] NNTP (119)\n\r\
[18] SSL_NNTP (563)      [19] SSL_SMTP (465)      [20] IMAP (143)\n\r\
[21] SNMP (161)          [22] SNMP_TRAP (162)     [23] IMAP3 (220)\n\r\
[24] SSL_FTP(989,990)    [25] SSL_Telnet (992)    [26] SSL_IMAP4(993)\n\r\
[27] SSL_IRC (994)       [28] SSL_POP3 (995)      [29] Real audio/video(1090)\n\r\
[30] PPTP (1723)         [31] MIRC (6667)         [32] MS_Streaming (1755)\n\r\
[33] Vxtreme(8000)       [34] Real audio/video (7070)\n\r\
[35] AOL(5190)           [36] Q931(900,902)       [37] RTP(5004,5006)\n\r\
[38] RTCP(5005,5007)     [39] Road Runner1 (6284) [40] Road Runner2 (6285)\n\r\
[41] Road Runner3 (7283) [42] VOIP - Statistics (5000)\n\r\
[43] Others\n\r\
\n\r\
Enter Your Choice (1 to 43) : ";

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
const BYTE ProxyMenu[] =
"\n\r\
\n\r\
        << ProxyServer Application Configuration Menu >>\n\r\
\n\r\
[ 1] Proxy Any App            : %s\n\r\
[ 2] FTP Control Port Number  : %s\n\r\
[ 3] FTP Data Port Number     : %s\n\r\
[ 4] ProxyServer Application\n\r\
[ 5] Filters\n\r\
\n\r\
Go Back to \"Proxy Server Management\" menu to save changes.\n\r\
\n\r\
Enter your choice ( 1 to 5,exit or ESC to PREV menu ) : ";
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */

/* Imran,30.12.98 */
const BYTE ProxyAppMenu[]=
"\n\r\
\n\r\
        << ProxyServer Application Configuration Menu >>\n\r\
\n\r\
[ 1] Standard Ports\n\r\
[ 2] User Defined Ports\n\r\
\n\r\
Go Back to \"Proxy Server Management\" menu to save changes.\n\r\
\n\r\
Enter your choice ( 1 to 2,exit or ESC to PREV menu ) : ";
/* Imran,30.12.98 */

const BYTE ProxyFiltersMenu[] =
"\n\r\
\n\r\
                << ProxyServer Filters Menu >>\n\r\
\n\r\
[ 1] Internet Sites (IP Address)\n\r\
[ 2] Internet Sites (Domain Name)\n\r\
[ 3] Client Workstations (IP Address)\n\r\
[ 4] Client Workstations (MAC Address)\n\r\
[ 5] Applications\n\r\
\n\r\
Enter your choice ( 1 to 5,exit or ESC to PREV menu ) : ";

const BYTE ProxyAddrFilter[] =
"\n\r\
\n\r\
                << ProxyServer %s Address Filter >>\n\r\
\n\r\
[ 1]  Enter %s Address          : %s\n\r\
\n\r\
Enter your choice ( 1, exit or ESC to PREV menu, C : Confirm changes ) : ";

const BYTE ProxyAddrFilterDB[] =
"\n\r\
\n\r\
        << ProxyServer %s Address Filter Database >>\n\r\
\n\r\
\n\r\
     Index     Address\n\r\
     -----     -------\n\r\
\n\r\
\n\r";

const BYTE ProxyAppDB[] =
"\n\r\
\n\r\
                      << Proxy Server Application %s Table>>\n\r\
\n\r\
    Index   Protocol      Port\n\r\
    -----   --------   ----------\n\r\
\n\r\
\n\r";


const BYTE  ProxyAppSMenu[]  = 
"\n\r\
\n\r\
1. Protocol             : %s\n\r\
2. Application Port     : %s (%04d)\n\r\
\n\r\
Enter Choice (1 to 2, exit,  C: confirm Changes): ";

/* Imran 4/1/99 */
const BYTE  ProxyUserAppSMenu[] = 
"\n\r\
\n\r\
1. Protocol                    : %s\n\r\
2. Range                       : %s\n\r\
3. Application Port(Lower)     : %04d\n\r\
4. Application Port(Higher)    : %04d\n\r\
5. Description                 : %s\n\r\
\n\r\
Note: Higher Application port should be entered only for port ranges\n\r\
\n\r\
Enter Choice (1 to 5, exit,  C: confirm Changes): ";
/* Imran 4/1/99 */


BYTE is_valid_mac_address(BYTE* string_ptr)
{
	BYTE i;

   if ( (strlen(string_ptr) < 1 ) || (strlen(string_ptr) > 12 ))
      return FALSE;
   if ( !strcmp(string_ptr,"000000000000"))
      return FALSE;
  	for(i=0;i<strlen(string_ptr);++i)
   {
	   if (string_ptr[i] < '0' || (string_ptr[i] > '9' && string_ptr[i] < 'A') || (string_ptr[i] > 'F' && string_ptr[i] < 'a') || string_ptr[i] > 'f')
  		{
   		return FALSE;
	   }
  	}
   return TRUE;
}

void format_the_mac_address(BYTE* string_ptr)
{
	int string_length, i;
	char temp_buff[200] ;
	int number_of_zeros_to_be_inserted ;
	
	string_length = strlen(string_ptr);
	if (string_length == 12)
		return;
	memset (&temp_buff[0], '0', 200) ;

	number_of_zeros_to_be_inserted = 12 - string_length;

	for (i = number_of_zeros_to_be_inserted ; i < 12 ; i++)
		temp_buff[i] = string_ptr[i-number_of_zeros_to_be_inserted] ;
	temp_buff[12] = 0 ;

	strcpy(string_ptr, temp_buff);
}

BYTE is_valid_dns_address(BYTE* string_ptr)
{
   char delim = '.';
   int length = 0,token_len = 0,index = 0;
   char *token, *ptr_to_space;
   char temp_str[256];
   
   if ((strlen(string_ptr) < 1) || (strlen(string_ptr) > 255))
      return FALSE;
   
   ptr_to_space = strchr (string_ptr, ' ');
   if (ptr_to_space)
   {
      printf("\n\rInvalid DNS Name.Space found.\n");
      return FALSE;
   }

   strcpy(temp_str,string_ptr);
   token = strtok ( temp_str,delim );
   while ( token != NULL )
   {
      token_len = strlen ( token );
      if ( token_len > 64 )
         return FALSE;
      else
      {
         
         length = length + strlen ( token ) + 1;
         token = strtok(&temp_str[length],delim);
      }
   }
   return TRUE;
}

void initialize_proxy_server_applications ()
{
	temp_proxy_application.port = 0;
	temp_proxy_application.protocol = 0;
}

/* Imran 4/1/99 */
void initialize_proxy_server_user_applications ()
{
	RangeEnabled = 0;
	temp_proxy_user_app.lower_port_number = 0;
	temp_proxy_user_app.higher_port_number = 0;
	temp_proxy_user_app.protocol = 0;
	temp_proxy_user_app.port_description[0] = 0;
}
/* Imran 4/1/99 */

BYTE *proxy_main_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE get_value;
	USHORT temp_ftp_ctrl_port, temp_ftp_data_port ;
	
   if (!buffer) 
	{
		initialize_replystr ();
		
		get_parameter (client_info_ptr->connection_id,CM_PROXY_SECTION, PROXY_ANY_APP,
				CM_NO_PORT_PARAMETER_PRESENT, CM_BYTE_FORMAT, &get_value, 10, NULL);

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
      get_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &temp_ftp_ctrl_port, sizeof(USHORT), NULL) ;

      get_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &temp_ftp_data_port, sizeof(USHORT), NULL) ;

		strcpy(&ReplyStrs[0].ReplyStr[0], ((int) get_value? "enabled" : "disabled"));

		sprintf (&ReplyStrs[1].ReplyStr[0], "%05d", temp_ftp_ctrl_port) ;
		sprintf (&ReplyStrs[2].ReplyStr[0], "%05d", temp_ftp_data_port) ;
		sprintf (telnet.tx_buffer, ProxyMenu, &ReplyStrs[0].ReplyStr[0],
		&ReplyStrs[1].ReplyStr[0], &ReplyStrs[2].ReplyStr[0]) ;
		return (telnet.tx_buffer);
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */
	}
 	switch (atoi(buffer)) 
   {
		case PROXY_ANY_APP_INFO:
			client_info_ptr->menustate = TMS_MODI_PROXY_MENU;
			client_info_ptr->modify_option_rcvd = atoi (buffer);
			break;

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
 		case PROXY_FTP_CTRL_PORT:			
			client_info_ptr->menustate = TMS_MODI_PROXY_MENU;
			client_info_ptr->modify_option_rcvd = atoi (buffer);
			break;

 		case PROXY_FTP_DATA_PORT:			
			client_info_ptr->menustate = TMS_MODI_PROXY_MENU;
			client_info_ptr->modify_option_rcvd = atoi (buffer);
			break;

/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */

 		case PROXY_APP_INFO:			
			client_info_ptr->menustate = TMS_MODI_PROXY_APP_MENU;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_MAIN_PROXY;
			parameter_id = PROXY_NUMBER_OF_APPLICATION_ENTRIES; /* Imran */
			filter_or_app = PROXY_APPLICATION;
         strcpy(menu_ptr,"");
			break;

      case PROXY_FILTER_INFO:				
			client_info_ptr->menustate = TMS_PROXY_FILTERS;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_MAIN_PROXY;
			filter_or_app = PROXY_FILTER;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Imran,for proxy any app */
BYTE *proxy_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str;
	BYTE app_new_value ;
	USHORT ftp_prev_ctrl_port = 0, ftp_prev_data_port = 0, index = 0, higher_port = 0, protocol = 0x0006 ;
	USHORT new_value, no_of_entries, entry_number = 0 ;
	ULONG offset ;
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	STRUCT_PROXY_USER_ENTRY temp_proxy_user_entry ;

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
      get_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_prev_ctrl_port, sizeof (USHORT), NULL) ;

      get_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_prev_data_port, sizeof (USHORT), NULL) ;
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */

	if(!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case PROXY_ANY_APP_INFO :
				return(EnaOrDis);
	
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
 			case PROXY_FTP_CTRL_PORT:			
				ret_str = (BYTE *)NewValue;
				break;

	 		case PROXY_FTP_DATA_PORT:			
				ret_str = (BYTE *)NewValue;
				break;
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */

			default : return(InvalidChoice);
		}
	   return(ret_str);
	}
	new_value = (USHORT) (atoi (buffer));
	app_new_value = (BYTE) (atoi (buffer));

	switch(client_info_ptr->modify_option_rcvd)
	{
	 	case PROXY_ANY_APP_INFO :
			if (app_new_value == 2)
				app_new_value = 0;
			else if(app_new_value != 1)
					return (InvalidChoice);

			switch (set_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_ANY_APP,
				CM_NO_PORT_PARAMETER_PRESENT, CM_BYTE_FORMAT, &app_new_value, 1 ,NULL))
			{
				case CM_SET_SUCCESSFUL : break;
				 
				default : return("\n\rFailed to set parameter");
			}
			break; 

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
		case PROXY_FTP_CTRL_PORT:
			if (!*buffer)
			{
 				sprintf(buffer,"%d", FTP21);
				new_value = FTP21;
			}

			if ((IsStrNumericAndValid(buffer) == FALSE) || (new_value == 0))
				return("\n\rUnknown Port type.Re-Enter value from 1 to 65535 .\n\r\
Enter ( Esc Or exit ) : ");				

			if (new_value == ftp_prev_data_port)
				return ("\n\rEntered value conflict with ftp data port entry.\n\r\
Enter ( Esc Or exit ) : ");				

			temp_proxy_user_entry.lower_port_number = new_value ;
			temp_proxy_user_entry.higher_port_number = higher_port ;
			temp_proxy_user_entry.protocol = protocol ;
			strcpy ((char *) temp_proxy_user_entry.port_description, "") ;

			if (is_duplicate_user_application (&temp_proxy_user_entry, 0) && 
				(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with User Defined proxy port entries.\n\r\
Enter ( Esc Or exit ) : ") ;
			}
			switch (set_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &new_value, sizeof(USHORT), NULL))
			{
				case CM_SET_SUCCESSFUL : break ;
				default : return("\n\rFailed to set parameter") ;
			}
			
			get_parameter(client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_NUMBER_OF_APPLICATION_ENTRIES,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &no_of_entries, sizeof(USHORT), NULL) ;
			
			while (index < no_of_entries)
			{
	  	      cm_get_entry (PROXY_APPLICATION, CM_PROXY_ID, &offset, &entry_number, client_info_ptr->menu_selected_port) ;
				ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset ;		
				if ((ptr_to_proxy_application->port == ftp_prev_ctrl_port) &&
						(ptr_to_proxy_application->protocol == TCP_PROTOCOL))
				{
					break ;
				}
				else 
					index++ ;
			}

			temp_proxy_application.port = new_value ;
			temp_proxy_application.protocol = 0 ; /* TCP_PROTOCOL */
			if(!cm_edit_entry (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_APPLICATION,
		  		index+1, (void *) &temp_proxy_application, client_info_ptr->menu_selected_port))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}
			index = 0 ;
			entry_number = 0 ;
			while (index < no_of_entries)
			{
	  	      cm_get_entry (PROXY_APPLICATION, CM_PROXY_ID, &offset, &entry_number, client_info_ptr->menu_selected_port) ;
				ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset ;		
				if ((ptr_to_proxy_application->port == ftp_prev_ctrl_port) &&
						(ptr_to_proxy_application->protocol == UDP_PROTOCOL))					
				{
					break ;
				}
				else 
					index++ ;
			}

			temp_proxy_application.port = new_value ;
			temp_proxy_application.protocol = 1 ; /* UDP_PROTOCOL */

			if(!cm_edit_entry (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_APPLICATION,
		  		index+1, (void *) &temp_proxy_application, client_info_ptr->menu_selected_port))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}

         break;

		case PROXY_FTP_DATA_PORT:
			if (!*buffer)
			{
 				sprintf(buffer,"%d",FTP20);
				new_value = FTP20;
			}

			if (new_value == ftp_prev_ctrl_port)
				return ("\n\rEntered value conflict with ftp control port entry.\n\r\
Enter ( Esc Or exit ) : ");				

			if ((IsStrNumericAndValid(buffer) == FALSE) || (new_value == 0))
				return("\n\rUnknown Port type.Re-Enter value from 1 to 65535.\n\r\
Enter ( Esc Or exit ) : ");				

			temp_proxy_user_entry.lower_port_number = new_value ;
			temp_proxy_user_entry.higher_port_number = higher_port ;
			temp_proxy_user_entry.protocol = protocol ;
			strcpy ((char *) temp_proxy_user_entry.port_description, "") ;

			if (is_duplicate_user_application (&temp_proxy_user_entry, 0) && 
					(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with User Defined proxy port entries.\n\r\
Enter ( Esc Or exit ) : ") ;
			}
			switch (set_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &new_value, sizeof(USHORT), NULL))
			{
				case CM_SET_SUCCESSFUL : break ;
				default : return("\n\rFailed to set parameter") ;
			}

			get_parameter (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_NUMBER_OF_APPLICATION_ENTRIES,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &no_of_entries, sizeof(USHORT), NULL) ;

			entry_number = 0 ;
			index = 0 ;
			while (index < no_of_entries)
			{
	  	      cm_get_entry (PROXY_APPLICATION, CM_PROXY_ID, &offset, &entry_number, client_info_ptr->menu_selected_port) ;
				ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset ;		
				if ((ptr_to_proxy_application->port == ftp_prev_data_port) &&
						(ptr_to_proxy_application->protocol == TCP_PROTOCOL))
				{
					break ;
				}
				else 
					index++ ;
			}

			temp_proxy_application.port = new_value ;
			temp_proxy_application.protocol = 0 ; /* TCP_PROTOCOL */

			if(!cm_edit_entry (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_APPLICATION,
		  		index+1, (void *) &temp_proxy_application, client_info_ptr->menu_selected_port))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}
			index = 0 ;
			entry_number = 0 ;
			while (index < no_of_entries)
			{
	  	      cm_get_entry (PROXY_APPLICATION, CM_PROXY_ID, &offset, &entry_number, client_info_ptr->menu_selected_port) ;
				ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset ;		
				if ((ptr_to_proxy_application->port == ftp_prev_data_port) &&
						(ptr_to_proxy_application->protocol == UDP_PROTOCOL))					
				{
					break ;
				}
				else 
					index++ ;
			}

			temp_proxy_application.port = new_value ;
			temp_proxy_application.protocol = 1 ; /* UDP_PROTOCOL */

			if(!cm_edit_entry (client_info_ptr->connection_id, CM_PROXY_SECTION, PROXY_APPLICATION,
		  		index+1, (void *) &temp_proxy_application, client_info_ptr->menu_selected_port))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}
         break;

/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */
	}
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MAIN_PROXY ;	
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}	
/* Imran,for proxy any app */

/* Imran 4/1/99 */
BYTE *proxy_application_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if(!buffer)
		return(ProxyAppMenu);

	switch(atoi(buffer))
	{
		case PROXY_STANDARD_APP:
			client_info_ptr->menustate = TMS_MODI_PROXY;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_MODI_PROXY_APP_MENU;
         strcpy(menu_ptr,"(Standard)");
			break;
		
	   case PROXY_USER_APP:
		  	client_info_ptr->menustate = TMS_MODI_PROXY_USER_APP;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_MODI_PROXY_APP_MENU;
         strcpy(menu_ptr,"(User Defined)");
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice,2);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* Imran 4/1/99 */

BYTE *proxy_server_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	USHORT index=0;
	ULONG offset, *address_to_pass;	
	BYTE temp_buff[200], protocol_buff[25], port_buff[20],temp_db[100];
	USHORT entry_number = 0, no_of_entries = 0;   

	if (!buffer)
	{
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,parameter_id,
					CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);
		
		if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index;
			if (entry_number < no_of_entries )
		       cm_get_entry (filter_or_app, CM_PROXY_ID, &offset, &entry_number,client_info_ptr->menu_selected_port);
		}
		else
		{
         if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;
            sprintf (temp_db,ProxyAppDB,menu_ptr);
				strcpy (telnet.tx_buffer, temp_db);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
			cm_get_entry (filter_or_app, CM_PROXY_ID, &offset, &entry_number,client_info_ptr->menu_selected_port);
         client_info_ptr->index = 1;
		}

      sprintf(temp_db,ProxyAppDB,menu_ptr);
		strcpy (telnet.tx_buffer, temp_db);

		if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"     %3d.       %-4s      %s (%04d)\n\r", 
            client_info_ptr->index++,
				get_protocol_type (protocol_buff, (enum IP_PROTOCOL_VALUE) dummy_proxy_application_ptr->protocol),
				get_port_type (port_buff, (enum IP_PROTOCOL_VALUE) dummy_proxy_application_ptr->protocol,dummy_proxy_application_ptr->port),
				dummy_proxy_application_ptr->port);
			strcat (telnet.tx_buffer,temp_buff);
			if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPA;
			}
		}				

		while (entry_number <= no_of_entries)
	   {
			ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset;		
	  		if (ptr_to_proxy_application->protocol == 0)
	  			ptr_to_proxy_application->protocol = 6;
	  		else if (ptr_to_proxy_application->protocol == 1)
	  			ptr_to_proxy_application->protocol = 17;  

   	   client_info_ptr->no_filters = 0;
      	index++;
      	sprintf (temp_buff,"     %3d.       %-4s      %s (%04d)\n\r", 
           	client_info_ptr->index++,
           	get_protocol_type (protocol_buff, (enum IP_PROTOCOL_VALUE) ptr_to_proxy_application->protocol),
           	get_port_type (port_buff, (enum IP_PROTOCOL_VALUE) ptr_to_proxy_application->protocol, ptr_to_proxy_application->port),
				ptr_to_proxy_application->port);
      	strcat (telnet.tx_buffer,temp_buff);

			if (entry_number == no_of_entries)
				entry_number++;
			
			if (entry_number < no_of_entries)
	  	      cm_get_entry (filter_or_app, CM_PROXY_ID, &offset, &entry_number, client_info_ptr->menu_selected_port);

	      if (index == MAX_ENTRIES_PER_PAGE && entry_number < no_of_entries)
	      {
				address_to_pass = (ULONG *) offset ; 
				memcpy ((char *) &dup_proxy_application_ptr, (char *) address_to_pass, sizeof (STRUCT_PROXY_ENTRY));
				dummy_proxy_application_ptr = (STRUCT_PROXY_ENTRY *) &dup_proxy_application_ptr;

				if (dummy_proxy_application_ptr->protocol == 0)
					dummy_proxy_application_ptr->protocol = 6;
				else if (dummy_proxy_application_ptr->protocol == 1)
					dummy_proxy_application_ptr->protocol = 17; 

            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number;
           	break;
	      }
   	   if (entry_number > no_of_entries)
      	{
         	client_info_ptr->next_screen = 0;
				goto SENDFILT_IPA;
	      }
	   }
SENDFILT_IPA:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit, "); 
      if (client_info_ptr->next_screen)
   	     	strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}

	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
		initialize_proxy_server_applications (); 
		client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_ADD_PROXY_APP;      
   }
	else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1))
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_PROXY_APP;
   }
	else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_PROXY_APP;
   }
	else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
		client_info_ptr->menustate = TMS_MODI_PROXY;
	else
		return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
   USHORT index;
	ULONG offset; 

   if (!buffer)
      return ("\n\rEnter index of Application:");

   index = atoi (buffer);

	if (index >= client_info_ptr->index || index == 0)
      return ("\n\rInvalid index to edit.Enter exit or ESC to PREV menu : ");   

   client_info_ptr->edit_index = index;
	index--;
	cm_get_entry(filter_or_app, CM_PROXY_ID, &offset, &index, client_info_ptr->menu_selected_port);

   ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) offset;

   temp_proxy_application.port = ptr_to_proxy_application->port;
   temp_proxy_application.protocol = ptr_to_proxy_application->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_ADD_PROXY_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}


BYTE *add_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE port_buff[20], protocol_buff[20];
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	ULONG  para_id ; 

   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf (telnet.tx_buffer, ProxyAppSMenu,
          get_protocol_type (protocol_buff, temp_proxy_application.protocol),
          get_port_type (port_buff, temp_proxy_application.protocol, temp_proxy_application.port),
			 temp_proxy_application.port);
      return (telnet.tx_buffer);
    }

    client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= PROXY_PROTOCOL_PORT &&
      client_info_ptr->modify_option_rcvd <= PROXY_APPLICATION_PORT)
    {
      client_info_ptr->menustate = TMS_PROXY_UPD_APPLICATION;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
      if (temp_proxy_application.port == 0 )
         return("\n\rInvalid Value.Enter exit or ESC to PREV menu : ");

		if (is_duplicate_application(temp_proxy_application.protocol, temp_proxy_application.port, filter_or_app) == TRUE)
			return("\n\rApplication already exists!.Enter exit or ESC to PREV menu :");
      
      modify_config_visited = 1;
      
      if (client_info_ptr->edit_filter)
      {
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
			if (temp_proxy_application.protocol == 6)
				temp_proxy_application.protocol = 0;
			else if (temp_proxy_application.protocol == 17)
				temp_proxy_application.protocol = 1;  

#if 0
		   if (ptr_to_proxy_application->protocol == 6)
				ptr_to_proxy_application->protocol = 0;
			else if (ptr_to_proxy_application->protocol == 17)
				ptr_to_proxy_application->protocol = 1;
#endif
 			
		  if(!cm_edit_entry(client_info_ptr->connection_id,CM_PROXY_SECTION,filter_or_app,
		  		client_info_ptr->edit_index, (void *) &temp_proxy_application,client_info_ptr->menu_selected_port))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}
      }
      else
		{
			if (filter_or_app == PROXY_APPLICATION)
 				para_id = ADD_PROXY_APPLICATION;
			else
				para_id = ADD_RESTRICTED_APPLICATION_ENTRIES;

			if (temp_proxy_application.protocol == 50)
			{
				temp_proxy_application.protocol = 0 ;
				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
					para_id, client_info_ptr->menu_selected_port, (void *) &temp_proxy_application,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}
				
				temp_proxy_application.protocol = 1 ;
				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
					para_id, client_info_ptr->menu_selected_port, (void *) &temp_proxy_application,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}
			}
			else
			{
				if (temp_proxy_application.protocol == 6)
					temp_proxy_application.protocol = 0;
				else if (temp_proxy_application.protocol == 17)
					temp_proxy_application.protocol = 1; 

				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
						para_id, client_info_ptr->menu_selected_port, (void *) &temp_proxy_application,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}
			}
		}			
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_MODI_PROXY;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    return InvalidChoice;
}

BYTE *upd_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   ULONG value=0;
	BYTE port_buff[20];
	USHORT new_value = 0, temp_protocol = 17;
	USHORT ctrl_port = 0, data_port = 0;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
         case PROXY_PROTOCOL_PORT:
				if(client_info_ptr->edit_filter)
	            return (not_supported);
				
				if(filter_or_app == PROXY_APPLICATION)
					return (ProtochoiceBoth);
				else
					return (Protochoice);

			case PROXY_APPLICATION_PORT:
				if((client_info_ptr->edit_filter) || (filter_or_app == PROXY_FILTER))
				{
/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
					if (!strcmp (get_protocol_type (port_buff, temp_proxy_application.protocol), "TCP"))
					{
						get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
						sprintf(telnet.tx_buffer, tcp_application_list,	ctrl_port, data_port) ;
						return telnet.tx_buffer ;
					}
					else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "UDP"))
					{
						get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
						sprintf(telnet.tx_buffer, udp_application_list,	ctrl_port, data_port) ;
						return telnet.tx_buffer ;
					}
					else return ("\n\rUnknown Protocol");
				}
				else
				{
					if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP"))
					{
						get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
						sprintf(telnet.tx_buffer, tcp_application_list,	ctrl_port, data_port) ;
						return telnet.tx_buffer ;
					}
					else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "UDP"))
					{
						get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
						sprintf(telnet.tx_buffer, udp_application_list,	ctrl_port, data_port) ;
						return telnet.tx_buffer ;
					}
					else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP & UDP"))
					{
						get_ftp_port_numbers(client_info_ptr->connection_id, &ctrl_port, &data_port) ;
						sprintf(telnet.tx_buffer, tcp_application_list,	ctrl_port, data_port) ;
						return telnet.tx_buffer ;
					}
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */
					else
							return ("\n\rUnknown Protocol");		
				}
      }
   }

	new_value = atoi (buffer);
		
   switch (client_info_ptr->modify_option_rcvd)
   {
   	case PROXY_PROTOCOL_PORT:
			if((client_info_ptr->edit_filter) || (filter_or_app == PROXY_FILTER))
			{
				if (new_value == 1)
					temp_proxy_application.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_application.protocol = 17 ;
				else
					return InvalidChoice;
			}
			else
			{
				if (new_value == 1)
					temp_proxy_application.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_application.protocol = 17 ;
				else if (new_value == 3)
					temp_proxy_application.protocol = 50 ;
				else
					return InvalidChoice;
			}
				break;
	
		case PROXY_APPLICATION_PORT:
			if (temp_proxy_application.protocol == 6)
			{
				if (new_value < (MAX_TCP_APPLICATIONS + 1))
				{
					temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
				}
				else if (new_value == (MAX_TCP_APPLICATIONS + 1))
				{
					if(filter_or_app == PROXY_APPLICATION)
						return(not_supported);
					client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
					return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else
					return InvalidChoice;
			}	
			else if (temp_proxy_application.protocol == 17)
			{
				if (new_value < (MAX_UDP_APPLICATIONS + 1))
					temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
				else if (new_value == (MAX_UDP_APPLICATIONS + 1))
				{
					if(filter_or_app == PROXY_APPLICATION)
						return(not_supported);
					client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
					return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else
					return InvalidChoice;
			}
			else if (temp_proxy_application.protocol == 50)
			{
				if (new_value < (MAX_TCP_APPLICATIONS + 1))
					temp_proxy_application.port = get_protocol_port_number (temp_protocol , new_value);
				else if (new_value == (MAX_TCP_APPLICATIONS + 1))
				{
					if(filter_or_app == PROXY_APPLICATION)
						return(not_supported);
					client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
					return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else
					return InvalidChoice;
			}
			else 
				return ("\n\rUnknown Protocol");
			break;
   }

   client_info_ptr->menustate = TMS_ADD_PROXY_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *update_proxy_application_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT new_value =0;

	if (!buffer)
		return ("\n\rEnter Proxy Application Port : ");

	new_value = atoi (buffer);


/*	if (new_value > 0 && new_value <= 1024)  Commented by Imran */
	{
		temp_proxy_application.port = new_value;
		client_info_ptr->menustate = TMS_ADD_PROXY_APP;
	   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
/*	else
		return InvalidChoice; */
}

BYTE *delete_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0;
	ULONG  para_id; 

   if (!buffer)
   {
      return ("\n\rEnter index of Application to delete:");
   }

   index = atoi (buffer) - 1;

	if (filter_or_app == PROXY_APPLICATION)
		para_id = DELETE_PROXY_APPLICATION;
	else
		para_id = DELETE_RESTRICTED_APPLICATION_ENTRIES;


   switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
										para_id, client_info_ptr->menu_selected_port, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

	  default :
      	return ("\n\rFailed to delete application.Enter exit or ESC to prev menu\n");
	}

   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_MODI_PROXY;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Imran,31/12/98 */
BYTE *proxy_user_application_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
	USHORT index=0;
	ULONG offset, *address_to_pass;	
	BYTE temp_buff[200], protocol_buff[25], port_buff[20],temp_db[100];
	USHORT entry_number = 0, no_of_entries = 0;   

	if (!buffer)
	{
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_NUMBER_OF_USER_DEFINED_APPLICATION_ENTRIES,
					CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);
		
		if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index;
			if (entry_number < no_of_entries )
		       cm_get_entry (PROXY_USER_APPLICATION, CM_PROXY_ID, &offset, &entry_number,0);
		}
		else
		{
         if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;
            sprintf (temp_db,ProxyAppDB,menu_ptr);
				strcpy (telnet.tx_buffer, temp_db);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
			cm_get_entry (PROXY_USER_APPLICATION, CM_PROXY_ID, &offset, &entry_number,0);
         client_info_ptr->index = 1;
		}

      sprintf(temp_db,ProxyAppDB,menu_ptr);
		strcpy (telnet.tx_buffer, temp_db);

		if (client_info_ptr->next_screen)
      {
         index++;
			if(!dummy_proxy_user_app_ptr->higher_port_number)
	      	sprintf (temp_buff,"     %3d.       %-4s      %s (%04d)\n\r", 
   	         client_info_ptr->index++,
					get_protocol_type (protocol_buff, dummy_proxy_user_app_ptr->protocol),
					dummy_proxy_user_app_ptr->port_description,
					dummy_proxy_user_app_ptr->lower_port_number);
			else
				sprintf (temp_buff,"     %3d.       %-4s      %s (%04d,%04d)\n\r", 
   	         client_info_ptr->index++,
					get_protocol_type (protocol_buff, dummy_proxy_user_app_ptr->protocol),
					dummy_proxy_user_app_ptr->port_description,
					dummy_proxy_user_app_ptr->lower_port_number,
					dummy_proxy_user_app_ptr->higher_port_number);

			strcat (telnet.tx_buffer,temp_buff);
			if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_IPA;
			}
		}				

		while (entry_number <= no_of_entries)
	   {
			ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) offset;		
	  		if (ptr_to_proxy_user_application->protocol == 0)
	  			ptr_to_proxy_user_application->protocol = 6;
	  		else if (ptr_to_proxy_user_application->protocol == 1)
	  			ptr_to_proxy_user_application->protocol = 17;  

   	   client_info_ptr->no_filters = 0;
      	index++;
			if(!ptr_to_proxy_user_application->higher_port_number)
	      	sprintf (temp_buff,"     %3d.       %-4s      %s (%04d)\n\r", 
   	         client_info_ptr->index++,
					get_protocol_type (protocol_buff, ptr_to_proxy_user_application->protocol),
					ptr_to_proxy_user_application->port_description,
					ptr_to_proxy_user_application->lower_port_number);
			else
				sprintf (temp_buff,"     %3d.       %-4s      %s (%04d,%04d)\n\r", 
   	         client_info_ptr->index++,
					get_protocol_type (protocol_buff, ptr_to_proxy_user_application->protocol),
					ptr_to_proxy_user_application->port_description,
					ptr_to_proxy_user_application->lower_port_number,
					ptr_to_proxy_user_application->higher_port_number);

      	strcat (telnet.tx_buffer,temp_buff);

			if (entry_number == no_of_entries)
				entry_number++;
			
			if (entry_number < no_of_entries)
	  	      cm_get_entry (PROXY_USER_APPLICATION, CM_PROXY_ID, &offset, &entry_number, 0);

	      if (index == MAX_ENTRIES_PER_PAGE && entry_number < no_of_entries)
	      {
				address_to_pass = (ULONG *) offset ; 
				memcpy ((char *) &dup_proxy_user_app_ptr, (char *) address_to_pass, sizeof (STRUCT_PROXY_USER_ENTRY));
				dummy_proxy_user_app_ptr = (STRUCT_PROXY_USER_ENTRY *) &dup_proxy_user_app_ptr;

				if (dummy_proxy_user_app_ptr->protocol == 0)
					dummy_proxy_user_app_ptr->protocol = 6;
				else if (dummy_proxy_user_app_ptr->protocol == 1)
					dummy_proxy_user_app_ptr->protocol = 17; 

            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number;
           	break;
	      }
   	   if (entry_number > no_of_entries)
      	{
         	client_info_ptr->next_screen = 0;
				goto SENDFILT_IPA;
	      }
	   }
SENDFILT_IPA:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit, "); 
      if (client_info_ptr->next_screen)
   	     	strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}

	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
		initialize_proxy_server_user_applications (); 
		client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_ADD_PROXY_USER_APP;      
   }
	else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1))
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_PROXY_USER_APP;
   }
	else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_PROXY_USER_APP;
   }
	else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
		client_info_ptr->menustate = TMS_MODI_PROXY_USER_APP;
	else
		return InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *te_edit_proxy_user_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
   USHORT index;
	ULONG offset; 

   if (!buffer)
      return ("\n\rEnter index of Application:");

   index = atoi (buffer) ;

   client_info_ptr->edit_index = index;
	index--;
	cm_get_entry(PROXY_USER_APPLICATION, CM_PROXY_ID, &offset, &index, 0);

   ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) offset;

   temp_proxy_user_app.lower_port_number = ptr_to_proxy_user_application->lower_port_number;
   temp_proxy_user_app.higher_port_number = ptr_to_proxy_user_application->higher_port_number;
   temp_proxy_user_app.protocol = ptr_to_proxy_user_application->protocol;
	strcpy(temp_proxy_user_app.port_description, ptr_to_proxy_user_application->port_description);
	RangeEnabled = temp_proxy_user_app.higher_port_number? 1 : 0;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_ADD_PROXY_USER_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_proxy_server_user_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE port_buff[20], protocol_buff[20];
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
	ULONG  para_id ; 

   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf (telnet.tx_buffer, ProxyUserAppSMenu,
          get_protocol_type (protocol_buff, temp_proxy_user_app.protocol),
			 (RangeEnabled?"enabled":"disabled"),
          temp_proxy_user_app.lower_port_number,
			 temp_proxy_user_app.higher_port_number,
			 temp_proxy_user_app.port_description);
      return (telnet.tx_buffer);
    }

    client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= PROXY_USER_PROTOCOL &&
      client_info_ptr->modify_option_rcvd <= PROXY_USER_PORT_DESC)
    {
      client_info_ptr->menustate = TMS_PROXY_UPD_USER_APP;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
      if ((temp_proxy_user_app.lower_port_number == 0))
         return("\n\rInvalid Value.Enter exit or ESC to PREV menu : ");

		if (RangeEnabled && !temp_proxy_user_app.higher_port_number)
         return("\n\rInvalid Value for higher port.Enter exit or ESC to PREV menu : ");

		if (!strlen(temp_proxy_user_app.port_description))
         return("\n\rInvalid Value for description.Enter exit or ESC to PREV menu : ");

		if(!client_info_ptr->edit_filter)
			client_info_ptr->edit_index = 0;
		if (is_duplicate_user_application(&temp_proxy_user_app,client_info_ptr->edit_index) == TRUE)
			return("\n\rDuplicate Application! Enter exit or ESC to PREV menu :"); 
      
      modify_config_visited = 1;
      
      if (client_info_ptr->edit_filter)
      {
         client_info_ptr->edit_filter = 0;

			if (temp_proxy_user_app.protocol == 6)
				temp_proxy_user_app.protocol = 0;
			else if (temp_proxy_user_app.protocol == 17)
				temp_proxy_user_app.protocol = 1;  

#if 0
		   if (ptr_to_proxy_user_application->protocol == 6)
				ptr_to_proxy_user_application->protocol = 0;
			else if (ptr_to_proxy_user_application->protocol == 17)
				ptr_to_proxy_user_application->protocol = 1;
#endif
 			
		  if(!cm_edit_entry(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_USER_APPLICATION,
		  		client_info_ptr->edit_index, (void *) &temp_proxy_user_app,0))   
			{
		  	 	return("\nEditing Node Failed.Enter exit or ESC to PREV menu:");
			}
      }
      else
		{
			if (temp_proxy_user_app.protocol == 50)
			{
				temp_proxy_user_app.protocol = 0 ;
				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
					ADD_PROXY_USER_APP, 0, (void *) &temp_proxy_user_app,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						printf("\n\rAdd successful\n\r");
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}

				temp_proxy_user_app.protocol = 1 ;
				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
					ADD_PROXY_USER_APP, 0, (void *) &temp_proxy_user_app,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						printf("\n\rAdd successful\n\r");
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}
			}
			else
			{
				if (temp_proxy_user_app.protocol == 6)
					temp_proxy_user_app.protocol = 0;
				else if (temp_proxy_user_app.protocol == 17)
					temp_proxy_user_app.protocol = 1; 

				switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
					ADD_PROXY_USER_APP, 0, (void *) &temp_proxy_user_app,NULL))
				{
					case CM_ADD_SUCCESSFUL : 
						printf("\n\rAdd successful\n\r");
						break;
					default :  return ("\n\rFailed to add application.Enter exit or ESC to PREV menu:\n");
				}
			}
		}			
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_MODI_PROXY_USER_APP;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    return InvalidChoice;
}

BYTE *upd_proxy_user_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   ULONG value=0;
	BYTE port_buff[20];
	USHORT new_value = 0;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
         case PROXY_USER_PROTOCOL:
				if(client_info_ptr->edit_filter)
   	         return (not_supported);
				else
					return (ProtochoiceBoth);
			
			case PROXY_RANGE_ENABLED:
				return(EnaOrDis);		

			case PROXY_USER_APPLICATION_PORT_HIGHER :
				if(!RangeEnabled)
					return("\n\rRange is disabled.So this option is not supported.\n\r\
Enter your choice(exit or ESC to PREV menu)\n\r");
	
			case PROXY_USER_APPLICATION_PORT_LOWER :
				return("\n\rEnter Application Port :");

			case PROXY_USER_PORT_DESC :
				return("\n\rEnter Description for Port :");

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice,4);
				return(telnet.tx_buffer);
      }
   }
	
	new_value = atoi (buffer);
		
   switch (client_info_ptr->modify_option_rcvd)
   {
   	case PROXY_USER_PROTOCOL :
			if(client_info_ptr->edit_filter)
			{	
				if (new_value == 1)
					temp_proxy_user_app.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_user_app.protocol = 17 ;
				else
					return InvalidChoice;
			}
			else
			{
				if (new_value == 1)
					temp_proxy_user_app.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_user_app.protocol = 17 ;
				else if (new_value == 3)
					temp_proxy_user_app.protocol = 50 ;
				else					
					return InvalidChoice;
			}
			break;

		case PROXY_RANGE_ENABLED :
			if(new_value == 1)
				RangeEnabled = 1;
			else if(new_value == 2)
				RangeEnabled = 0;
			else return InvalidChoice;
			break;
	
		case PROXY_USER_APPLICATION_PORT_LOWER :
			temp_proxy_user_app.lower_port_number = new_value;
			break;

		case PROXY_USER_APPLICATION_PORT_HIGHER :
			temp_proxy_user_app.higher_port_number = new_value;
			break;

		case PROXY_USER_PORT_DESC :
			if(strlen(buffer) > 15)
				return("\n\r\Dont enter more than 15 characters.Enter again:");
			strcpy(temp_proxy_user_app.port_description, buffer);
			break;
	}
   client_info_ptr->menustate = TMS_ADD_PROXY_USER_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *delete_proxy_server_user_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0;
	ULONG  para_id; 

   if (!buffer)
   {
      return ("\n\rEnter index of Application to delete:");
   }

   index = atoi (buffer) - 1;

   switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 
										DELETE_PROXY_USER_APP, client_info_ptr->menu_selected_port, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

	  default :
      	return ("\n\rFailed to delete application.Enter exit or ESC to prev menu\n");
	}

   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_MODI_PROXY_USER_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* Imran 31/12/98 */

BYTE *proxy_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE	filter_type;

   menu_ptr[0] = 0;

	if (!buffer) 
		return (ProxyFiltersMenu);

	filter_type = atoi(buffer);
 	switch( filter_type) {
      case PROXY_SOURCE_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->menu_selected_port = filter_type;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
			parameter_id = PROXY_FILTER_NO_OF_RESTRICTED_CLIENTS_ENTRIES;  
         strcpy(menu_ptr,"Source IP");
			break;

 		case PROXY_DEST_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->menu_selected_port = filter_type;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
			parameter_id = PROXY_FILTER_NO_OF_FORBIDDEN_SITES_ENTRIES;  
         strcpy(menu_ptr,"Destination IP");
			break;

      case PROXY_APP_FILTER:
         client_info_ptr->menustate = TMS_MODI_PROXY;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
			client_info_ptr->menu_selected_port = filter_type; 
			parameter_id = PROXY_FILTER_NO_OF_RESTRICTED_APPLICATION_ENTRIES;  
         strcpy(menu_ptr,"Filter");
			client_info_ptr->menu_selected_port = filter_type;
			break;

 		case PROXY_MAC_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->menu_selected_port = filter_type;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
			parameter_id = PROXY_FILTER_NO_OF_MAC_ADDRESS_ENTRIES;  
         strcpy(menu_ptr,"MAC");
			break;

      case PROXY_DNS_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->menu_selected_port = filter_type;
			parameter_id = PROXY_FILTER_NO_OF_DOMAIN_NAME_ENTRIES;  
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
         strcpy(menu_ptr,"DNS");
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_proxy_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr)
{
   switch ( client_info_ptr->menu_selected_port )
   {
      case PROXY_SOURCE_ADDR_FILTER:
      case PROXY_DEST_ADDR_FILTER:
      	strcpy (temp_proxy_addr_filter.addr, "0.0.0.0");
         break;
      case PROXY_MAC_ADDR_FILTER:
         strcpy (temp_proxy_addr_filter.addr, "000000000000");
         break;
      case PROXY_DNS_ADDR_FILTER:
         strcpy(temp_proxy_addr_filter.addr,"");
         break;
   }
}	

BYTE	*display_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE temp_buff[200],temp_db[100], temp_addr[25];
   USHORT index=0;
	ULONG offset; 
	USHORT entry_number = 0, no_of_entries = 0;   

   if (!buffer)
	{
		get_parameter(client_info_ptr->connection_id,CM_PROXY_SECTION,parameter_id,
					CM_NO_PORT_PARAMETER_PRESENT,CM_USHORT_FORMAT,&no_of_entries,2,NULL);

		if (client_info_ptr->next_screen)
		{
			entry_number = client_info_ptr->index ;
         if (entry_number < no_of_entries )
             cm_get_entry (PROXY_FILTER, CM_PROXY_ID, &offset, &entry_number,client_info_ptr->menu_selected_port);
		}
		else
		{
			if (!no_of_entries)
         {
            client_info_ptr->no_filters = 1;
            sprintf(temp_db,ProxyAddrFilterDB,menu_ptr);
				strcpy (telnet.tx_buffer, temp_db);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
			cm_get_entry (PROXY_FILTER, CM_PROXY_ID, &offset, &entry_number,client_info_ptr->menu_selected_port);
         client_info_ptr->index = 1;
		}

      sprintf(temp_db,ProxyAddrFilterDB,menu_ptr);
		strcpy (telnet.tx_buffer, temp_db);
      if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"     %3d.       %-15s\n\r", 
            client_info_ptr->index++,
            dummy_proxy_addr_filter->addr);
      	strcat (telnet.tx_buffer,temp_buff);
         if (entry_number == no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_PRXSRC;
			}
      }
		
   	while (entry_number <= no_of_entries)
   	{
	/* Imran  8/9/98  */
			get_ip_address_in_required_format(client_info_ptr->menu_selected_port, &offset, temp_addr);
	/* Imran 8/9/98   */

         client_info_ptr->no_filters = 0;
      	index++;
			
      	sprintf (temp_buff,"      %3d.       %-15s\n\r",
            client_info_ptr->index++,
            temp_addr);
      	strcat (telnet.tx_buffer,temp_buff);

			if (entry_number == no_of_entries)
				entry_number++;

         if (entry_number < no_of_entries)
            cm_get_entry (PROXY_FILTER, CM_PROXY_ID, &offset, &entry_number,client_info_ptr->menu_selected_port);

         if (index == MAX_ENTRIES_PER_PAGE && entry_number <= no_of_entries)
         {
				/* Imran  8/9/98  */
				get_ip_address_in_required_format(client_info_ptr->menu_selected_port, &offset, temp_addr);
				/* Imran 8/9/98   */

            memcpy ((char *) &dup_proxy_addr_filter, (char *) &temp_addr[0], sizeof ( STRUCT_PROXY_FILTER)); /* Imran */
            dummy_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &dup_proxy_addr_filter;
            client_info_ptr->next_screen++;
				client_info_ptr->index = entry_number ;
            break;
         }

         if (entry_number > no_of_entries)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_PRXSRC;
         }
	   }
SENDFILT_PRXSRC:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit, "); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_proxy_addr_filter (client_info_ptr);
      client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_PRX_EDIT_SRC_FILT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_PRX_DEL_SRC_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_PRXFILTSRC;
   }
   else
      return InvalidChoice;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE temp_addr[50];
   USHORT index;
	ULONG offset; 
   
   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return InvalidFilter;
   }
   client_info_ptr->edit_index = index;
	index--;
	cm_get_entry(PROXY_FILTER, CM_PROXY_ID, &offset, &index,client_info_ptr->menu_selected_port);

	get_ip_address_in_required_format(client_info_ptr->menu_selected_port, &offset, temp_addr);
	strcpy (temp_proxy_addr_filter.addr, temp_addr);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE  temp_db[255];

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (temp_db, ProxyAddrFilter,
         menu_ptr,menu_ptr,
			temp_proxy_addr_filter.addr);
      strcpy(telnet.tx_buffer,temp_db);
		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd == 1)
   {
      client_info_ptr->menustate = TMS_PRX_UPD_SRC_FILT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      switch ( client_info_ptr->menu_selected_port )
      {
         case PROXY_SOURCE_ADDR_FILTER :
         case PROXY_DEST_ADDR_FILTER :
    			if ((!is_an_ip_address(temp_proxy_addr_filter.addr)) ||
               (strcmp(temp_proxy_addr_filter.addr,"0.0.0.0") == 0))
   	   		return (InvalidIP);
            break;
         case PROXY_MAC_ADDR_FILTER :
            if (!is_valid_mac_address(temp_proxy_addr_filter.addr))
               return ("\n\rMAC Address entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
            else
               format_the_mac_address(temp_proxy_addr_filter.addr);
            break;
         case PROXY_DNS_ADDR_FILTER :
            if (!is_valid_dns_address(temp_proxy_addr_filter.addr))
               return ("\n\rDNS Address entered is invalid.Space is not accepted.\n\r\
Enter exit or ESC to PREV menu : ");
            break;
      }         

      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         client_info_ptr->edit_filter = 0;
			
			if(!cm_edit_entry(client_info_ptr->connection_id,CM_PROXY_SECTION,PROXY_FILTER,
					client_info_ptr->edit_index, (void *) &temp_proxy_addr_filter, client_info_ptr->menu_selected_port))
				 return("\nEditing Filter Failed.Enter exit or ESC to PREV menu:");
      }
      else
		{
      	switch(add_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 	
 					ADD_PROXY_ADDRESS_FILTER, client_info_ptr->menu_selected_port, (void *) &temp_proxy_addr_filter,NULL))
			{
				case CM_ADD_SUCCESSFUL : 
					break;
				default :  return ("\nAdding filter failed.Enter exit or ESC to PREV menu:\n");
			}
		}
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_PRXFILTSRC;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return InvalidChoice;
}  	

BYTE *upd_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value;
   BYTE temp_db[100];

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:
            sprintf ( temp_db,EnterString,menu_ptr);
				return ( temp_db );
		}        
	}

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
         switch ( client_info_ptr->menu_selected_port )
         {
            case PROXY_SOURCE_ADDR_FILTER :
            case PROXY_DEST_ADDR_FILTER :
      			if (!is_an_ip_address(buffer))
   		   		return (InvalidIP);
               break;
            case PROXY_MAC_ADDR_FILTER :
               if (!is_valid_mac_address(buffer))
                  return ("\n\rMAC Address entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
               else
                  format_the_mac_address(buffer);
               break;
            case PROXY_DNS_ADDR_FILTER :
               if (!is_valid_dns_address(buffer))
                  return ("\n\rDNS Address entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
               break;
         }         
         strcpy (temp_proxy_addr_filter.addr, buffer);
         break;
	}
	client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0;

   if (!buffer)
      return EnterFilter;

   index = atoi (buffer) - 1;

	if (index >= client_info_ptr->index || index < 0)
	   return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");

   switch (delete_parameters(client_info_ptr->connection_id,CM_PROXY_SECTION, 	
										DELETE_PROXY_ADDRESS_FILTER, client_info_ptr->menu_selected_port, index, NULL))
	{
		case CM_DELETE_SUCCESSFUL:
			break;

		default :
      	return ("Static Route Entry could not be removed \n") ;
	}
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

	client_info_ptr->menustate = TMS_PRXFILTSRC;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Imran 8/9/98  */
void  get_ip_address_in_required_format(int filter_type, ULONG *offset, BYTE *temp_addr)
{
	ULONG int_ip_address, *temp_ulong_ptr;
	STRUCT_PROXY_FILTER *proxy_addr_filter;

	switch(filter_type)
	{
		case PROXY_DEST_ADDR_FILTER:
		case PROXY_SOURCE_ADDR_FILTER: 
			temp_ulong_ptr =  *offset ;
			int_ip_address = (ULONG) *temp_ulong_ptr;
			get_dot_decimal_ip_address( int_ip_address, temp_addr);
			break;

		default:
   		proxy_addr_filter = (STRUCT_PROXY_FILTER *) *offset;
			strcpy(temp_addr, (char *) proxy_addr_filter->addr);
			break;
	 }	
	 return ;
}

/* Imran 8/9/98 */

/* ...Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports */
void get_ftp_port_numbers(ULONG connection_id, USHORT *ctrl_port, USHORT *data_port)
{
	get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, ctrl_port, sizeof (USHORT), NULL) ;

   get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, data_port, sizeof (USHORT), NULL) ;

	return ;
}
/* Jo 04 Oct 1999 Added to support configurable FTP Data and Control Ports... */
