#include	<defs.h>
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include <kstart.h>

#include	"telnet.h"
#include	"menu.h"

#include	"..\..\lsl\klsl.h"
#include	"..\..\lsl\vbufstr.h"
#include	"..\..\lsl\vlslstr.h"
#include	"..\..\lsl\vlsl.h"

#include "..\..\store\boot.h"
#include <flashmgr.h>

extern void free (void *);

/* sudhir 24-9-96 */
#define YES 1
#define NO 0

/* sudhir 24-9-96 */

BYTE * enabled_or_disabled (BYTE_ENUM (BOOLEAN) status)
{
	return ((status == TRUE) ? "Enabled" : "Disabled");
}

BYTE * wan_or_lan (BYTE_ENUM (BOOLEAN) status)
{
	return ((status == TRUE)? "WAN" : "LAN");
}

void	back_to_normal_mode(TELNET_CLIENT_CLASS *client_info_ptr)
{

   if (client_info_ptr->echoing == FALSE)
      client_info_ptr->echoing = TRUE;

	if (client_info_ptr->was_echoing == FALSE)
	{
		/* If we were not echoing, go back to that mode after finishing with
		multiple screen display */
		client_info_ptr->option_cmd = TCDONT;
		will_echo(client_info_ptr, TOECHO);					
	}

   client_info_ptr->edit_filter = 0;      
	client_info_ptr->more =	0;
	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
}

#if 0 /* Jo 29/04/99 */
void	ClearScreen(TELNET_CLIENT_CLASS *client_info_ptr)
{
	static	BYTE	ClearScreen[] = 
	"\n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \
	\n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r \n\r ";

	send_telnet_packet(client_info_ptr, ClearScreen, strlen(ClearScreen), 0);
}
#endif /* Jo 29/04/99 */

#if 0
char *get_time_in_hms(ULONG SEC, char *Time)
{
	USHORT	days, hrs, mins, secs;
	ULONG		rest;

	days = (USHORT)( SEC / ((int)3600 * 24));
	rest = SEC % ((int)3600 * 24);
	hrs = (USHORT) (rest / 3600);
	rest %= 3600;
	mins = (USHORT) (rest / 60);
	secs = (USHORT) (rest % 60);

	sprintf(Time,"%03u:%02u:%02u:%02u", days, hrs, mins, secs);
	return (Time);
}
#endif

/* sudhir 24-9-96 */
BYTE *CompressString (BYTE *Buffer)
{
	BYTE leading_blank = YES, excess_blank = NO;
	BYTE ch;
	int x=0,y=0;

	do 
	{
		ch = Buffer[x++];
		if (ch == ' ') 
		{
			if (leading_blank == NO) 
			{
				if (excess_blank == NO) 
				{
					Buffer[y++] = ch;
					excess_blank = YES;
				}
			}
		}	
		else 
		{
			leading_blank = NO;
			if (ch == 0 && excess_blank == YES) 
			{
 				Buffer[y-1] = ch;
			}
			else 
			{
				Buffer[y++] = ch;
				excess_blank = NO;
			}
		}			
	} while(ch != 0);
	return(Buffer);
}
/* sudhir 24-9-96 */

BYTE *MakePunctNumStr(BYTE *Buffer, ULONG Num)
{
	BYTE InBuff[20];
	BYTE *Iptr, *Optr;
   USHORT  i;

	sprintf(InBuff, "%15lu", (ULONG)Num);
   
	Iptr = &InBuff[14];
	Optr = &Buffer[14];
	Buffer[15] = 0;

	for (i = 1; *Iptr != ' '; i++) {
		if (i && !(i % 4)) {
			*Optr-- = ',';
		} else {
			*Optr-- = *Iptr--;
		}
	}
	for (;i <= 15; i++)
		*Optr-- = ' ';

/* sudhir 11-9-96 */
	CompressString (Buffer);
/* sudhir 11-9-96 */

	return Buffer;
}
#ifdef _BIG_PROXY_
/* Sudhir 25/10/1996 */
/*
	This routine frees up the linked list that has been allocated to
	hold the configuration. This is called on three possible events :
		. If 'Modify configuration' is entered is entered and nothing
		  is modified.
		. If the administrator exits after having entered
		  'Modify Configuration'.
		. If the administrator exits using alt-x or a similar key
		  combination for the purpose of aborting the telnet client.
*/
void free_linked_list (PARA_STR *sptr_list)
{
	PARA_STR *sptr_temp ;

	while (sptr_list != NULL)
	{
		sptr_temp = sptr_list->next ;
		free (sptr_list) ;
	  	sptr_list = sptr_temp ;
	}
	return ;
}

#define TEL_MOD_DEBUG 1

extern USHORT update_crc (USHORT, BYTE *, ULONG) ;
int flash_write_block (BYTE *, BYTE *, int, enum BOOLEAN) ;
BYTE *last_allocated_block, *last_allocated_block_destination ;
int last_allocated_block_length ;
void start_flash_write (PARA_STR *sptr_list)
{
	USHORT accumulated_crc = 0xFFFF ;
	PARA_STR *sptr_temp, *sptr_next_node = ptr_to_first_node ;
	int this_string_length ;
	ULONG setup_length = 0L ;
	HeaderType *sptr_dram_setup_header, *sptr_flash_setup_header = (HeaderType *)FL_CFG_HDR ;
	BYTE *sptr_flash_setup = (BYTE *)sptr_flash_setup_header->DnLdAddr ;
	BYTE temp_header[512] ;
/*	ULONG idle; */

	/* Make sure this is done before anything */
	memcpy (&temp_header[0], sptr_flash_setup_header, 512) ;

	last_allocated_block = NULL ;
	last_allocated_block_length = 0 ;
	last_allocated_block_destination = NULL ;

	while (sptr_next_node != NULL)
	{
		this_string_length = strlen (&sptr_next_node->parameter[0]) ;
		setup_length = setup_length + (ULONG) this_string_length ;
#if 0
		for (idle = 0; idle < 0x8FFF; idle ++);
		printf ("%s", &sptr_next_node->parameter[0]);
		printf ("This block len = %d, Dest ptr = 0x%x\n", this_string_length, sptr_flash_setup);
#endif
		flash_write_block (&sptr_next_node->parameter[0], sptr_flash_setup, this_string_length, FALSE) ;
		sptr_flash_setup += (ULONG)this_string_length ;
		accumulated_crc = update_crc (accumulated_crc, &sptr_next_node->parameter[0], this_string_length) ;

		sptr_temp = sptr_next_node->next ;
		free (sptr_next_node) ;
		sptr_next_node = sptr_temp ;
	}
	flash_write_block ("\x0\x0", sptr_flash_setup, 2, TRUE) ;
	setup_length += 2L ;

	accumulated_crc = update_crc (accumulated_crc, "\x0\x0\x0\x0", 4) ;

	sptr_dram_setup_header = (HeaderType *)&temp_header[0] ;

	sptr_dram_setup_header->CodeLength = setup_length ;
	sptr_dram_setup_header->CRC = accumulated_crc ;
	flash_write_block ((BYTE *)sptr_dram_setup_header, (BYTE *)FL_CFG_HDR, 512, TRUE) ;
#if TEL_MOD_DEBUG
	printf ("Flash setup CRC : %04X, length : %08X\n", sptr_flash_setup_header->CRC, sptr_flash_setup_header->CodeLength) ;
#endif
}

#if SMALL_MEM_MAP
extern enum BOOLEAN	c_write_to_AMD_flash (BYTE *src, BYTE *dest, int count);
#else
extern int schedule_flash_write (char *src_ptr, char *dest_ptr, unsigned short block_length,
                          void (*fptr_block_write_complete)(), char *buffer_to_free) ;
#endif

void last_setup_block_written ()
{
}

/*
	This is to be called only from Telnet.
	length can never be more than 512
*/
int flash_write_block (BYTE *bptr_src, BYTE *bptr_dest, int length, enum BOOLEAN last_block)
{
	int number_of_bytes_to_copy = length ;
#if 0
	USHORT idle;
	BYTE temp_bfr[1000];
#endif

	if (last_allocated_block == NULL)
	{
		last_allocated_block = malloc (512) ;
		if (last_allocated_block == NULL)
		{
			printf ("Malloc failed in Flash write block\n");
			return (0) ;
		}
#if 0
		printf ("Malloced ptr = 0x%x\n", last_allocated_block);
		for (idle = 0; idle < 0x8FFF; idle ++);
#endif
		last_allocated_block_length = 0 ;
		last_allocated_block_destination = bptr_dest ;
	}

	if ((512 - last_allocated_block_length) < length)
	{
		number_of_bytes_to_copy = 512 - last_allocated_block_length ;
		memcpy (last_allocated_block+last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;

#if 0 
		sprintf (temp_bfr, bptr_src);
		temp_bfr[512] = '\0';
		for (idle = 0; idle < 0x8FFF; idle ++);
			printf ("%s", temp_bfr);
#endif 

#ifndef SMALL_MEM_MAP
		schedule_flash_write (last_allocated_block, last_allocated_block_destination, 512, NULL, last_allocated_block) ;
#else
		c_write_to_AMD_flash (last_allocated_block, last_allocated_block_destination , 512);
#endif
		
		last_allocated_block = malloc (512) ;
		if (last_allocated_block == NULL)
		{
			printf ("Malloc failed in Flash write block\n");
			return (0) ;
		}
#if 0
		printf ("Malloced ptr = 0x%x\n", last_allocated_block);
		for (idle = 0; idle < 0x8FFF; idle ++);
#endif
		last_allocated_block_length = 0 ;
		bptr_src += number_of_bytes_to_copy ;
		number_of_bytes_to_copy = length - number_of_bytes_to_copy ;
		last_allocated_block_destination += 512 ;
	}
	memcpy (last_allocated_block+last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;

#if 0
	sprintf (temp_bfr, bptr_src);
	temp_bfr[513] = '\0';
	for (idle = 0; idle < 0x8FFF; idle ++);
		printf ("%s", temp_bfr);
#endif

	last_allocated_block_length += number_of_bytes_to_copy ;
	if (last_block == TRUE)
	{
#ifndef SMALL_MEM_MAP
		schedule_flash_write (last_allocated_block, last_allocated_block_destination, 512, last_setup_block_written, last_allocated_block) ;
#else
		c_write_to_AMD_flash (last_allocated_block, last_allocated_block_destination , 512);
#endif
		last_allocated_block = NULL ;
		last_allocated_block_length = 0 ;
		last_allocated_block_destination = NULL ;
	}
}

void telnet_flash_write_timer ()
{
	return ;
}
#endif

void wait_for_flash_write_completion ()
{
	int i = 0 ;
	USHORT idle;

	printf ("Waiting for flash write to complete.....\n") ;
	for (idle = 0; idle < 0x8FFF; idle ++);

#ifndef SMALL_MEM_MAP
	while (i < NUMBER_OF_FLASH_PROMS)
	{
		if (flash_accessibility[i] != FLASH_ACCESSIBLE)
		{
			i = 0 ;
		}
		else
			i++ ;
	}
#endif
}
