#include	<defs.h>
#include	<stdio.h>
#include	<stddef.h>
#include	<stdlib.h>
#include	<string.h>

/*Deepak...*/
#include "kstart.h"
/*...Deepak*/

#include	"telnet.h"
#include	"menu.h"
#include	"dialout.h"

#include <serial.h>

/*Deepak 26/01/1997...*/
extern send_packet_on_SMC (BYTE *,USHORT);
/*...Deepak 26/01/1997*/

USHORT	copy_into_delayed_tx_buffer (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT buflen, ULONG flag);
extern void DisableRTSOnWAN(int port_number);
extern void EnableRTSOnWAN(int port_number);

/****************************************************************************
	Routine		: send_telnet_packet
	Input			: Index to TELNET structure corresponding to this connection. 
						buffer to send.
						buflen - number of characters.
						flag to indicate mode in which data is sent (normal/urgent).
	Synopsis		: Sends a buffer in given mode on the TCP connection.
****************************************************************************/

USHORT	send_telnet_packet(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT buflen, ULONG flag)
{
	static	BYTE	goahead[] = { TCIAC, TCGA };
	USHORT	ret_value;
	BYTE *temp_ptr;

/*Deepak 26/01/1997...*/
	if (client_info_ptr->dumbtty)
	{
		send_packet_on_SMC (buffer, buflen);
	 	return 0 ;
	}
/*...Deepak 26/01/1997*/

/* sudhir new change */
#ifdef _BIG_PROXY_ /* Imran */
	if (client_info_ptr->connect_to_ourself == TRUE)
	{	
		temp_ptr = (BYTE *) malloc (buflen);
		if (temp_ptr != NULL)
		{
			memcpy (temp_ptr, buffer, buflen);
			serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, buflen, APPLICATION) ; 
		}
	}
	else	
	if ((ret_value = send_packet_to_client(client_info_ptr, buffer, buflen, flag)) > 0) {
		/* If not Suppressed-Go-Ahead, send GA */
		if(!client_info_ptr->noga)
		{
			return(send_packet_to_client(client_info_ptr, goahead, sizeof(goahead), 0));
		}
	}
	return ret_value;
#endif
}

/*-------------Following functions are for Delayed Send support-------------*/

/****************************************************************************
	Routine		: send_packet_to_client
	Input			: Index to TELNET structure corresponding to this connection. 
						buffer to send.
						buflen - number of characters.
						flag to indicate mode in which data is sent (normal/urgent).
	Synopsis		: Sends the buffer on the TCP connection. If delayed_tx_buffer
					  is != NULL, then a previous 'send' failed and that info has
					  been copied into this buffer. Copy this info also and do
					  a delayed_send from the timer.
****************************************************************************/
USHORT	send_packet_to_client(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT buflen, ULONG flag)
{
	int 		sent;
	int 		cum_sent;
	BYTE		*tx_buffer;
	ULONG		socket_error;
	USHORT 	retval;


	if (client_info_ptr->delayed_tx_buffer != NULL) 
	{
		retval = copy_into_delayed_tx_buffer(client_info_ptr, buffer, buflen, flag);

		/* Since the old buffer is still not sent out, lets play it safe and
		** prevent future serial receives.
		*/
		DisableRTSOnWAN(client_info_ptr->menu_selected_port);	

		return retval;
	}

	cum_sent = 0;
	while (buflen > 0) 
	{
		/*** 
			Allocate a buffer. Copy the transmit data. In case of error, 
			the socket_interface frees it up. Otherwise, keep freeing and 
			reallocating till the send completes.
		***/		

		tx_buffer = table_malloc(buflen, 1);
		if (tx_buffer == NULL)
			return 0;
		memcpy(tx_buffer, buffer + cum_sent, buflen);

		sent = send(client_info_ptr->socket_num, tx_buffer, buflen, flag);
		if (sent == FAILED) 
		{
			/* Buffer has been freed, get the error number */
			lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			if (socket_error != WOULD_BLOCK_ERROR) 
			{
				tel_printf(TELNET_ALARM,"TELNET: Socket send() failed, closing connection\n\r");
#ifdef _BIG_PROXY_
				if (client_info_ptr->menustate == TMS_DIALOUT_CHAT)
				{
					client_info_ptr->force_close = TRUE;
					dialout_chat_hdlr(client_info_ptr, NULL);
				}
				else
#endif
					close_connection(client_info_ptr);
				return 0;
			}
			else
			{
				/* Got a WOULD_BLOCK error. Our socket support does not
				** seem to return such an error. So we conveniently ignore
				** this.
				*/			  
#ifdef DEBUG
				printf("TELNET: WOULD_BLOCK error in imm send\n\r");
#endif /* DEBUG */
			}
		} else {	/* Buffer has not been freed. Free it up */
			if (sent == 0 ) {
				copy_into_delayed_tx_buffer(client_info_ptr, tx_buffer, buflen, flag);
				free (tx_buffer);
				return 1;
			}
			buflen -= sent;
			cum_sent += sent;
			free(tx_buffer);
		}
	}
	return 1;
}

/****************************************************************************
	Routine		: delayed_transmit
	Input			: Index to TELNET structure corresponding to this connection. 
	Synopsis		: Called from the timer. All connections for which delayed_tx_buffer
					  is != NULL, there is some information which is waiting to be sent.
					  As long as this info is waiting to go, we do not receive
					  on this connection. Only try to send.
****************************************************************************/
void delayed_transmit(TELNET_CLIENT_CLASS *client_info_ptr)
{
	int 		sent;
	ULONG		socket_error;
	USHORT	amount_to_send;
	BYTE		*tx_buffer;


	while (client_info_ptr->dtb_head < client_info_ptr->dtb_length) 
	{
		amount_to_send = client_info_ptr->dtb_length - client_info_ptr->dtb_head;
		tx_buffer = table_malloc(amount_to_send, 1);
		if (tx_buffer == NULL)
			return;

		memcpy(tx_buffer, client_info_ptr->delayed_tx_buffer + client_info_ptr->dtb_head, amount_to_send);

		sent = send(client_info_ptr->socket_num, tx_buffer, amount_to_send, client_info_ptr->dtb_flag);
		if (sent == FAILED) 
		{
			/* Buffer has been freed up, get the error number */
			lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			if (socket_error != WOULD_BLOCK_ERROR) 
			{
				tel_printf(TELNET_ALARM,"TELNET: Socket send() failed, closing connection\n");
#ifdef _BIG_PROXY_
				if (client_info_ptr->menustate == TMS_DIALOUT_CHAT)
				{
					client_info_ptr->force_close = TRUE;
					dialout_chat_hdlr(client_info_ptr, NULL);
				}
				else
#endif
					close_connection(client_info_ptr);
				return;
			} 
			else
			{
				/* Got a WOULD_BLOCK error. Our socket support does not
				** seem to return such an error. So we conveniently ignore
				** this.
				*/			  
#ifdef DEBUG
				printf("TELNET: WOULD_BLOCK error in delay send\n\r");
#endif /* DEBUG */
			}
		}
 		else
		{
			/* Buffer has not been freed, free it up */
			free(tx_buffer);
			if (sent == 0) 
				return;

			client_info_ptr->dtb_head += sent;
		}
	}

	free(client_info_ptr->delayed_tx_buffer);
	client_info_ptr->delayed_tx_buffer = NULL;

	/* If we were in a situation that required us to delay transmit like this,
	** we would have had turned off RTS. Turn it on back again.
	*/
	EnableRTSOnWAN(client_info_ptr->menu_selected_port);

	/* After the delayed_tx_buffer has been sent, FLUSH the characters 
	** that have been already sent by the client but not processed.
	*/
	client_info_ptr->option_cmd = TCWILL;
	do_timing_mark(client_info_ptr, TOTIMINGMARK);

	return;
}

/****************************************************************************
	Routine		: copy_into_delayed_tx_buffer
	Input			: Index to TELNET structure corresponding to this connection. 
						buffer to send.
						buflen - number of characters.
						flag to indicate mode in which data is sent (normal/urgent).
	Synopsis		: Called when 'send' returns a 0 indicating that TCP's send-
					  window is full. All the bytes to be sent are copied into 
					  the delayed_tx_buffer of this connection & sent from the timer.
					  The buffer keeps growing as this function keeps getting called.
****************************************************************************/

USHORT	copy_into_delayed_tx_buffer (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT buflen, ULONG flag)
{
	BYTE *free_buf_ptr, *new_buf_ptr;


	if (client_info_ptr->delayed_tx_buffer == NULL) 
	{
		/* Get some space if this is the first time */

		free_buf_ptr = client_info_ptr->delayed_tx_buffer = malloc(buflen);
		if (free_buf_ptr == NULL)
			return 0;

		client_info_ptr->dtb_length = buflen;
		client_info_ptr->dtb_head = 0;
	}
	else
	{
		/* Our own style of re-alloc to increase the size of the buffer */
		new_buf_ptr = malloc(buflen + client_info_ptr->dtb_length);
		if (new_buf_ptr == NULL)
			return 0;

		memcpy(new_buf_ptr, client_info_ptr->delayed_tx_buffer, client_info_ptr->dtb_length);
		free(client_info_ptr->delayed_tx_buffer);
		client_info_ptr->delayed_tx_buffer = new_buf_ptr;
		free_buf_ptr = new_buf_ptr + client_info_ptr->dtb_length;
		client_info_ptr->dtb_length += buflen;
	}

	/* Unload into the delayed_tx_buffer */
	memcpy(free_buf_ptr, buffer, buflen);

	client_info_ptr->dtb_flag = flag;
	return 1;
}
