#include	<defs.h>
#include	<stdio.h>
#include	<string.h>

#include <kstart.h>

#include	"telnet.h"
#include	"menu.h"
#include	"dialout.h"

/* CHAT */
#include	"..\..\devdrvrs\uim\kuim.h"
#include	"..\..\devdrvrs\uim\vuimstr.h"
#include	"..\..\devdrvrs\uim\chat\kchat.h"
#include	"..\..\devdrvrs\uim\chat\vchatstr.h"
#include	"..\..\devdrvrs\uim\chat\vchat.h"

#include <incall.h>
#include <cfgmgr.h>

/* Jo 27/04/99 */
const BYTE	ExitString[] = "exit";
/*const BYTE  Modify[] = "Modify Setup is Downloaded"; 
const BYTE  Save[] = "Do You Want to Save Changes (y/n)"; */

extern int modify_config_visited ;
extern int save_flag ;
extern int reboot_flag ;

#if SMALL_MEM_MAP
#include "..\..\store\boot.h"
extern	BootBinIOPBType BootBinIOPB;
#else
extern	BYTE	*DownloadFlag;
#endif

extern int verifying_remu_pwd;

/*Deepak...*/
extern BYTE	SMCRxState;
extern BYTE *dumbtty_key;
/*void close_dumbtty_connection (TELNET_CLIENT_CLASS *client_info_ptr); */ /* Imran */
extern Bus_error_occured;
/*...Deepak*/

extern void free_linked_list (PARA_STR *) ;
extern void start_flash_write (PARA_STR *) ;
extern int toupper (int);
extern BYTE *save_changes_to_prom (TELNET_CLIENT_CLASS *, BYTE *);
extern void reset(void);
extern int udb_deinit_flag;

/****************************************************************************
	Routine		: save_buffer
	Input			: Index to TELNET structure corresponding to this connection.
						Character - received.
	Synopsis		: Checks the character received for a CRLF sequence or ESC.
						If so, the command is executed. Otherwise, the character
						is saved in the recv_buffer. In case of Chat mode, the
						character is sent to	the wan port.
****************************************************************************/

USHORT	save_buffer(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT	ret_val;
	BYTE star[] = "*";
	BYTE Clean_BS[3];

	/* Urgent data has arrived or we have sent a Timing Mark and are
	waiting for a response from the client. Reject data & Process only cmnds 
	till DM or response */

	if ((client_info_ptr->synching == TRUE) || (client_info_ptr->sndtmark == TRUE))
		return 1;

	/* If this client is in chat mode, send the character to the wan port.
	We check here so that TELNET commands can be normally executed.  */

	if (client_info_ptr->menustate == TMS_CHATMODE) {
		ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* reset this */
		if (chat_send_wan_packet(&character, 1, client_info_ptr->menu_selected_port) == FAIL)
		{
		}
		return 1;
	}


	switch (character) {
		case VPBS:		
			if (client_info_ptr->recv_buffer_index == 0)
				return 1;
			edit_cmnd(client_info_ptr, TCEC);
			client_info_ptr->last_char = 0;
			Clean_BS[0] = character;
			Clean_BS[2] = character;
			Clean_BS[1] = ' ';

         if ((client_info_ptr->verifying_dialout_pwd == FALSE) &&
            (client_info_ptr->verifying_pwd == FALSE) && client_info_ptr->echoing == TRUE)
			   return(send_telnet_packet(client_info_ptr, &Clean_BS, 3,0));
			break;
		case VPLF:
			/* we echo LF only if the previous character was not CR */
			if (client_info_ptr->last_char == VPCR)
				return 1;
			break;
		case (BYTE)NULL:
			return 1;
		case VPCR:
			client_info_ptr->recv_buffer[client_info_ptr->recv_buffer_index] = NULL;
			if (client_info_ptr->more) 
				goto process;
chkstring:
			/* Are we checking the password ? */
			if (client_info_ptr->verifying_pwd == TRUE) 
			{
				ret_val = 
				verify_password(client_info_ptr);
			} 
			else 
			{
				if( !strcmp(client_info_ptr->recv_buffer, ExitString)) 
				{
/*Deepak...*/
					if (client_info_ptr->dumbtty == 1)
					{
						send_telnet_packet(client_info_ptr, CloseCnx, strlen(CloseCnx), 0);
						close_dumbtty_connection (client_info_ptr);
						return ;
					}
/*...Deepak*/
					if (client_info_ptr == ChatClientPtr) 
						send_telnet_packet(client_info_ptr, ChatEnd, strlen(ChatEnd), 0);
					else
					{
						send_telnet_packet(client_info_ptr, CloseCnx, strlen(CloseCnx), 0);
						if (client_info_ptr->modify_config_entered)   
							cm_deinitialize_configuration_manager (client_info_ptr->connection_id);

						client_info_ptr->modify_config_entered = 0;
						modify_config_visited = 0;
						client_info_ptr->verifying_ppp_pwd = FALSE;
						verifying_remu_pwd = 0;
						if (udb_deinit_flag)
						{
/* Jo 10/06/99 		udb_deinitialize (); */
							udb_deinit_flag = 0;
						}
					}
					close_connection(client_info_ptr);
					return 0;
				}
process:
				ret_val = menu_state_machine(client_info_ptr, client_info_ptr->recv_buffer);
			}
			client_info_ptr->recv_buffer_index =0;
			client_info_ptr->last_char = character;
			return ret_val;

		case (BYTE)TESCAPE:
			client_info_ptr->recv_buffer[client_info_ptr->recv_buffer_index++] = character;
			client_info_ptr->recv_buffer[client_info_ptr->recv_buffer_index++] = NULL;

			/* If ESC was pressed when prompting for dialout password, turn off
			** flag indicating this. This is so that future characters will be
			** echo-ed back.
			*/
			if (client_info_ptr->verifying_dialout_pwd == TRUE)
			{
				client_info_ptr->verifying_dialout_pwd = FALSE;
			}
			verifying_remu_pwd = 0;
			client_info_ptr->verifying_ppp_pwd = FALSE;
			if (udb_deinit_flag && client_info_ptr->menustate == TMS_WRITE_FLASH)
			{
/* Jo 10/06/99 		udb_deinitialize (); */
				udb_deinit_flag = 0;
			} 

/* sudhir 28/5/97 */
         if (client_info_ptr->menustate == TMS_SAVE_CHANGES && modify_config_visited)
         {
 			 /* Imran ... */
#ifdef _BIG_PROXY_   
            if (client_info_ptr->dumbtty == 1)
               cm_deinitialize_configuration_manager (CM_OWNED_BY_DTTY);
	          else
               cm_deinitialize_configuration_manager (CM_OWNED_BY_TELNET); 
#else  
				cm_deinitialize_configuration_manager (client_info_ptr->connection_id);
#endif
			  /* ... Imran */

            client_info_ptr->modify_config_entered = 0;
            modify_config_visited = 0;
         }

			goto chkstring;
		default:
         if (client_info_ptr->recv_buffer_index <= MAX_TCP_PKT-1)
         {
   			client_info_ptr->recv_buffer[client_info_ptr->recv_buffer_index++] = character;
	   		client_info_ptr->last_char = character;
         }
			break;
	}


	if (client_info_ptr->verifying_ppp_pwd == TRUE)
		send_telnet_packet(client_info_ptr, star, 1, 0);

	if (verifying_remu_pwd == 1)
		send_telnet_packet(client_info_ptr, star, 1, 0);
		

	/* CR, LF, ESC, NULL and password are already taken care of. */
	/* client_info_ptr->more == 0 && this check removed temp*/

	if (client_info_ptr->echoing == TRUE && client_info_ptr->verifying_pwd == FALSE &&
			client_info_ptr->verifying_dialout_pwd == FALSE &&
			client_info_ptr->verifying_ppp_pwd == FALSE &&
			verifying_remu_pwd == 0	)
		return(send_telnet_packet(client_info_ptr, &character, 1,0));
	return 1;
}		

USHORT call_save_buffer (BYTE *temp_ptr, BYTE *buffer)
{
   TELNET_CLIENT_CLASS *client_info_ptr = (TELNET_CLIENT_CLASS *) temp_ptr;

	client_info_ptr->dumbtty = 1; /* Imran */
   return (save_buffer (client_info_ptr, buffer));

}

/*Deepak...*/
void close_dumbtty_connection (TELNET_CLIENT_CLASS *client_info_ptr)
{
	if (client_info_ptr->modify_config_entered)   
		cm_deinitialize_configuration_manager (client_info_ptr->connection_id);

	client_info_ptr->modify_config_entered = 0;
	modify_config_visited = 0;
	client_info_ptr->verifying_ppp_pwd = FALSE;
	verifying_remu_pwd = 0;
	if (udb_deinit_flag)
	{
/* Jo 10/06/99 		udb_deinitialize (); */
		udb_deinit_flag = 0;
	}			

	client_info_ptr->in_use = 0;
	client_info_ptr->dumbtty = 0;
	dumbtty_key = NULL;  
	SMCRxState = RECV_7E;
	Bus_error_occured = 0;

   return;
}

/*...Deepak*/

/* Added by Imran... */
// Assumes that if TRUE is returned that connection has been deleted and
// if false is returned connection is still kept alive.
int telnet_callback_function (ULONG connection_id, int value)
{
	USHORT	i;
	TELNET_CLIENT_CLASS	*ptr_client_info = telnet.clients_info;

//	printf ("It has come to TELNET/DTTY callback function\n");
	for( i = 0; i < telnet.max_telnet_connections; i++, ptr_client_info++) 
	{
		if( ptr_client_info->connection_id == connection_id) 
		{
#if 0
			if (value == CM_CLOSE_CONNECTION)
			{
				if (ptr_client_info->dumbtty == 1)
					close_dumbtty_connection(ptr_client_info);
				else
				{
					send_telnet_packet(ptr_client_info, CloseCnx, strlen(CloseCnx), 0);
					close_connection(ptr_client_info);
				}
//				printf ("TELNET/DTTY: closed connection %lu\n", connection_id);
			}
			if (value == CM_ACCESS_CHANGED)
			{
				if (ptr_client_info->Permissions != CM_READ_AND_WRITE)
					ptr_client_info->Permissions = CM_READ_AND_WRITE;
//				printf ("changed permissions of TELNET/DTTY to write\n");
			}
#endif
			return TRUE;
		}
	}

	return FALSE;
}
/* ...Added by Imran */
