#include	<defs.h>
#define GLOBAL_FILE
#include	<stdio.h>
#include	<stdarg.h>
#include	<stddef.h>
#include	<stdlib.h>

#include	"telnet.h"
#include	"vnvtel.h"
#include	"menu.h"
#include "menufsm.h"
#include "dialout.h"

#define	WARM_BOOT_MODE	0x5A

extern ULONG get_ip_address(USHORT);
extern	void	stop_chat_on_port(void);
extern	void	Reset(void);

#if SMALL_MEM_MAP
#include "..\..\store\boot.h"
extern	BootBinIOPBType BootBinIOPB;
#else
extern	BYTE	*DownloadFlag;
#endif

extern ULONG str_to_net (BYTE *);

enum TEST telnet_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);

enum TEST initialize_telnet(ULONG clock_ticks_per_second)
{
 /* Imran ... */
#ifdef _BIG_PROXY_
#else 
 	telnet.dumb_tty_enabled = TRUE;
	telnet.enabled = FALSE ;
	telnet.max_telnet_connections = 1 ; /* This is a dubious decision */
#endif
/* ...Imran */

	if (telnet.enabled == FALSE && telnet.dumb_tty_enabled == FALSE)
		return (PASS);

#ifdef _BIG_PROXY_
   if (telnet.enabled)
   {
      telnet.telnet_server_ip_address = str_to_net (telnet.telnet_server_ip_address_string);
	   telnet.timer_enabled = FALSE;
	   telnet.clock_ticks_per_second = clock_ticks_per_second;

	   if (register_telnet() == FAIL)
		   return (FAIL);
   }      
#endif
   /* Sudhir 21 Feb 1998 */
#ifdef _BIG_PROXY_
	telnet.model_number = lsl_control (GET_HARDWARE_MODEL);
#else
	telnet.model_number = MODEL_MTSR3_200 ;
#endif	

	/* Sanjay */
	   telnet.number_of_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + 
											lsl_control(GET_NUMBER_OF_WAN_PORTS);
	/* Adjust some port menu's based on whether 2 port or 4 port is in use */

	   if (telnet.number_of_ports == 2)
	   {
		   menufsmhdlr[TMS_CHATPORT].menu = SelectChatPort_2Port;
		   menufsmhdlr[TMS_CHATPORT].num_of_items = 1 ;
		   menufsmhdlr[TMS_DIALOUT_PORTCHOICE].num_of_items = 1 ;
	   }
	   else
		if (telnet.number_of_ports == 4)
		{
			menufsmhdlr[TMS_CHATPORT].menu = SelectChatPort_4Port;
			menufsmhdlr[TMS_CHATPORT].num_of_items = 3 ;
			menufsmhdlr[TMS_DIALOUT_PORTCHOICE].num_of_items = 3 ;
		}
		else
		{
			/* Currently we have either a 2 port or a 4 port version */
			tel_printf(TELNET_ALARM, "TELNET: Unsupported number of WAN ports...not initializing\n");
			return (FAIL);
		}

#ifdef _BIG_PROXY_
	/* Sanjay */
	if (telnet.enabled)
   {
      if (initialize_telnet_socket_interface() == FAIL)
		   return (FAIL);
   }
#endif

	if (allocate_telnet_buffers() == FAIL)
		return (FAIL);

#ifdef _BIG_PROXY_
	if (initialize_for_dialout() == FAIL)
		return FAIL;

	if (telnet.enabled)
      initialize_telnet_fsm();
#else
      initialize_telnet_fsm();
#endif		

	telnet.num_of_connected_clients = 0;

   if (telnet.enabled)
   	telnet.timer_enabled = TRUE;

	return (PASS);
}


/****************************************************************************
	Routine		: register_telnet
	Synopsis		: Registers TELNET server as an application with LSL
****************************************************************************/
#ifdef _BIG_PROXY_
static enum TEST register_telnet (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "TELNET Server", TELNET_APPLICATION, check_for_telnet_request, telnet_control,
		&telnet.application_id) == FAIL)	{
		tel_printf (TELNET_ALARM,"TELNET: register_application () failed to register TELNET with lsl\n");
		return (FAIL);
	}

	return (PASS);
#else
	return (FAIL);
#endif
}


/****************************************************************************
	Routine		: intialize_telnet_socket_interface
	Synopsis		: Opens , Binds and Listens on the TELNET socket for clients
						requests.
****************************************************************************/
enum TEST initialize_telnet_socket_interface (void)
{
	SOCKADDR_IN local_read_sockaddr_in;

	telnet.local_internet_address = get_ip_address(0);

	/* get a socket */
	telnet.socket_descriptor = socket (AF_INET, SOCK_STREAM, 0x00000000L);
	if (telnet.socket_descriptor == FAILED) {
		tel_printf(TELNET_ALARM,"TELNET: failed to create socket\n");
		return (FAIL);
	}

	associate_application_with_socket (telnet.socket_descriptor, telnet.application_id);

	/* initialize local sockaddr_in structure */
	local_read_sockaddr_in.sin_family      = AF_INET;    /* "Internet" Address Family */
	local_read_sockaddr_in.sin_addr.s_addr = telnet.local_internet_address;    /* Local IP address */
	local_read_sockaddr_in.sin_port = IPPORT_TELNET;    /* Set to "TELNET" Port */ 

	/* bind local ip address & port number to the socket */
	if (bind (telnet.socket_descriptor, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) {
		tel_printf (TELNET_ALARM,"TELNET: failed to bind\n");
		closesocket(telnet.socket_descriptor);
		return (FAIL);
	}
		
	if (listen (telnet.socket_descriptor, 1) == FAILED) {
		tel_printf(TELNET_ALARM,"TELNET: failed to listen\n");
		closesocket(telnet.socket_descriptor);
		return (FAIL);
	} 
	tel_printf(TELNET_RXTX,"\nTELNET:Opened and Bound TELNET socket.\n");
	return (PASS);

}
#endif 
	
/****************************************************************************
	Routine		: allocate_telnet_buffers
	Synopsis		: Allocates receive and transmit buffers for TELNET operations
****************************************************************************/
enum TEST allocate_telnet_buffers(void)
{
	if ((telnet.recv_buffer = (BYTE *)calloc(MAX_TCP_PKT, 1)) == NULL) {
		tel_printf(TELNET_ALARM,"TELNET: Error allocating memory.\n");
		return (FAIL);
	}

	if ((telnet.tx_buffer = (BYTE *)calloc(MAX_BYTES_PER_SCREEN, 1)) == NULL) {
		tel_printf(TELNET_ALARM,"TELNET: Error allocating memory.\n");
		return (FAIL);
	}																										

	/* allocate clients connection structures */
	if ((telnet.clients_info = (TELNET_CLIENT_CLASS *)table_malloc(
			telnet.max_telnet_connections, sizeof(TELNET_CLIENT_CLASS))) == NULL) {
		tel_printf(TELNET_ALARM,"TELNET: Error allocating memory.\n");
		return (FAIL);
	}

	/* state machine matrix */
/*	for (i=0; i<NSTATES; i++)
		if ((soinfsm[i] = (BYTE *)malloc(NCHRS)) == NULL)
			return (FAIL); */
/*
	for (i=0; i<NSSTATES; i++)
		if ((subnegfsm[i] = (BYTE *)malloc(NCHRS)) == NULL)
			return (FAIL); */

	return (PASS);
}


/****************************************************************************
	Routine		: intialize_telnet_fsm
	Input			: Nil
	Synopsis		: Initializes the 2 state machine matrices. One for characters
						received and the other for sub-negotiation. 
****************************************************************************/

void initialize_telnet_fsm(void)
{
	USHORT	i;
	TELNET_CLIENT_CLASS	*ptr_clients_info = telnet.clients_info;

	/* initialize socket input finite-state-machine */
#ifdef _BIG_PROXY_
	fsm_init(soinfsm, soinstab, NSTATES);

	/* initialize sub-negotiation finite-state-machine */
	/* fsm_init(subnegfsm, subnegstab, NSSTATES); */
#endif

	for( i =0; i< telnet.max_telnet_connections; i++, ptr_clients_info++) 
		ptr_clients_info->in_use = FALSE;
}	


/****************************************************************************
	Routine		: shutdown_telnet
	Input			: Nil					  	
	Synopsis		: CLoses all open sockets to bring TELNET server down.
****************************************************************************/

#ifdef _BIG_PROXY_
void	shutdown_telnet(void)
{
	USHORT	i;
	TELNET_CLIENT_CLASS	*ptr_client_info = telnet.clients_info;

	for( i =0; i< telnet.max_telnet_connections; i++, ptr_client_info++) {
		if( ptr_client_info->in_use) 
			close_connection(ptr_client_info);
	}
	telnet.timer_enabled = FALSE;		
	free(telnet.recv_buffer);
	free(telnet.tx_buffer);
	
	table_free((void *)telnet.clients_info);
	closesocket(telnet.socket_descriptor);
}
#endif

/****************************************************************************
	Routine		: close_connection
	Input			: Index to TELNET structure corresponding to this connection.
	Synopsis		: Closes the connection on the socket specified by the 
						structure and frees up buffers for that connection.
****************************************************************************/

void	close_connection(TELNET_CLIENT_CLASS *client_info_ptr)
{
#ifdef _BIG_PROXY_
	closesocket(client_info_ptr->socket_num);
#endif

	client_info_ptr->in_use = 0;
	free(client_info_ptr->recv_buffer);
	free(client_info_ptr->char_buffer_ptr);

	if (client_info_ptr->delayed_tx_buffer != NULL)
		free (client_info_ptr->delayed_tx_buffer);

	telnet.num_of_connected_clients--;
	if (client_info_ptr == ChatClientPtr) 
	{
#if SMALL_MEM_MAP
		BootBinIOPB.BootMode = WARM_BOOT_MODE;
#else		
		*DownloadFlag = WARM_BOOT_MODE;
#endif
		Reset();
	}
}	

#ifdef _BIG_PROXY_
enum TEST
telnet_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1)
{
	return PASS;
}
#endif
