#include	"defs.h"

#include <kstart.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "telnet.h"
#include "menu.h"

extern	send_packet_on_SMC (BYTE *, USHORT);
extern TELNET_CLIENT_CLASS *get_free_client_entry(void);
extern USHORT	initialize_client_for_dumbtty (TELNET_CLIENT_CLASS *client_info_ptr);
extern USHORT 	welcome_to_telnet(TELNET_CLIENT_CLASS *client_info_ptr);

extern BYTE *dumbtty_key;
extern int test_pass;

#ifdef _BIG_PROXY_
extern verifying_remu_pwd ;
#else
int verifying_remu_pwd = 0 ; 
#endif

/* extern BYTE	*CopyrightMsg;  */
extern BYTE	carr_ret[];
/****************************************************************************
*	Routine	: initialize_client_info_ptr_for_dumbtty 							    *
*	Input	: None																	          *
*	Summary	: Called from accept_login or accept_password. If user wants to *
*					configure thru' SMC memory is allocated here to the global   *  
*					TELNET_CLIENT_CLASS * dumbtty_client_info_ptr.				 	 *			 
*					dumbtty_client_info_ptr should hold a NULL if not in use.    *
****************************************************************************/	
BYTE *initialize_client_info_ptr_for_dumbtty()
{ 
 
	TELNET_CLIENT_CLASS *client_info_ptr ;

   client_info_ptr = get_free_client_entry() ;
	if (client_info_ptr == NULL)
		return NULL;
	if(!initialize_client_for_dumbtty (client_info_ptr))
	{
		return NULL;
	}
   client_info_ptr->dumbtty = 1; /*to indicate that configuration is through SMC*/
	client_info_ptr->verifying_pwd = FALSE; 
	client_info_ptr->menustate = TMS_SUPERMENU; /*as soon as password is found correct supermenu is displayed*/
	client_info_ptr->more = 0 ;
	client_info_ptr->verifying_ppp_pwd = FALSE;
	client_info_ptr->verifying_dialout_pwd = FALSE;
	client_info_ptr->echoing = TRUE;
   client_info_ptr->synching = FALSE;
	client_info_ptr->sndtmark = FALSE;
   client_info_ptr->in_use_by_terminal_server = FALSE ;
	test_pass = 1;	/*to make sure that password is not requested again*/
   verifying_remu_pwd = 0;
 	welcome_to_telnet (client_info_ptr); 
	return ((BYTE *)client_info_ptr) ;
}



/****************************************************************************
*	Routine	: deinitialize_client_info_ptr_for_dumbtty 							 *	
*	Input	: TELNET_CLIENT_CLASS type pointer which is to be freed.				 *
*	Summary	: Called when configuration thru' SMC is completed	to free the	 *
*				  memory assigned to the pointer during initialisation			 *
****************************************************************************/	
void deinitialize_client_info_ptr_for_dumbtty(BYTE *client_info_ptr)
{
printf("\nDeiniting dumbtty...");
#ifdef _BIG_PROXY_
    free (client_info_ptr);
#else
	 free(client_info_ptr->recv_buffer);
	 free(client_info_ptr->char_buffer_ptr);
	 free(telnet.recv_buffer);
	 free(telnet.tx_buffer);
	 table_free((void *)telnet.clients_info);
#endif
	
	 dumbtty_key = NULL;
}

/****************************************************************************
*	Routine	: configuration_through_SMC_in_progress   							 *
*	Input	: None																		       *
*  Output : Returns 1 if conf thru' SMC is in progress and 0 if not			 *
*	Summary	: This routine is called to find out whether conf thru' SMC is  *
*				  in progress or not. This is called during printf blocking		 *
****************************************************************************/	
BYTE configuration_through_SMC_in_progress (void)
{
	if (dumbtty_key == NULL)
		return(0);
	return(1);
}
