#include	<defs.h>
#include	<stdio.h>
#include	<stdarg.h>
#include	<stddef.h>
#include	<stdlib.h>

#include	"telnet.h"
#include	"menu.h"
#include "menufsm.h"
#include <incall.h>
#include <cfgmgr.h>

#ifdef _BIG_PROXY_

#define IPX_MAX_NUM_OF_HOPS  17
#define IPX_MIN_NUM_OF_HOPS  0
#define IPX_MAX_PERIODIC_SAP_TX_TIME  32768
#define IPX_MIN_PERIODIC_SAP_TX_TIME  29
#define IPX_MAX_PERIODIC_RIP_TX_TIME  32768
#define IPX_MIN_PERIODIC_RIP_TX_TIME  29
#define IPX_MAX_SAP_AGING_TIMER    32768
#define IPX_MIN_SAP_AGING_TIMER    0
#define IPX_MAX_RIP_AGING_TIMER    32768
#define IPX_MIN_RIP_AGING_TIMER    0
#endif

#define IP_MAX_DEFAULT_TTL  257
#define IP_MIN_DEFAULT_TTL  1
#define IP_MAX_REASSEMBLY_TIMEOUT 65536
#define IP_MIN_REASSEMBLY_TIMEOUT 9
#ifdef _BIG_PROXY_
#define IP_MAX_RIP_ROUTE_AGING_TIMER 65536
#define IP_MIN_RIP_ROUTE_AGING_TIMER 0

#define STP_MAX_ROOT_PATH_COST 100000
#define STP_MIN_ROOT_PATH_COST 0

#define PPP_MAX_CONFIG_REQUESTS 65536
#define PPP_MIN_CONFIG_REQUESTS 2
#define PPP_MAX_TERMINATION_REQUESTS 21
#define PPP_MIN_TERMINATION_REQUESTS 0
#define PPP_MAX_UNACK_ECHO_REQUESTS 21
#define PPP_MIN_UNACK_ECHO_REQUESTS 0
#define PPP_MAX_CONFIG_REQUEST_SENDI 65536
#define PPP_MIN_CONFIG_REQUEST_SENDI 4
#define PPP_MAX_TERMINATION_REQUEST_SENDI 65536
#define PPP_MIN_TERMINATION_REQUEST_SENDI 4
#define PPP_MAX_ECHO_REQUEST_SENDI 65536
#define PPP_MIN_ECHO_REQUEST_SENDI 0
#define PPP_MAX_CONFIG_REQUEST_BROADI  65536
#define PPP_MIN_CONFIG_REQUEST_BROADI 4

#define AG_MAX_INACTIVITY_TIMEOUT 32768
#define AG_MIN_INACTIVITY_TIMEOUT 0
#define PPP_MAX_MRU 4501
#define PPP_MIN_MRU 1499

extern ULONG str_to_net(BYTE *Str);

enum BOOLEAN validate_network_number (BYTE *IPXaddr)
{
	int count = 0;

	while (*IPXaddr)
	{
		if (((*IPXaddr) >= '0') && ((*IPXaddr) <= '9')
			||((*IPXaddr) >= 'a') && ((*IPXaddr) <= 'f')
			||((*IPXaddr) >= 'A') && ((*IPXaddr) <= 'F'))
		{
			count++;
			IPXaddr++;
		}
		else 
			return (FALSE);
	}
	if (count == 8)
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_number_of_hops (ULONG number_of_hops)
{
	if ((number_of_hops > IPX_MIN_NUM_OF_HOPS) &&	(number_of_hops < IPX_MAX_NUM_OF_HOPS))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_SAP_tx_timer (ULONG sap_tx_timer)
{
	if ((sap_tx_timer > IPX_MIN_PERIODIC_SAP_TX_TIME) && (sap_tx_timer <	IPX_MAX_PERIODIC_SAP_TX_TIME))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_RIP_tx_timer (ULONG rip_tx_timer)
{
	if ((rip_tx_timer > IPX_MIN_PERIODIC_RIP_TX_TIME) && (rip_tx_timer <	IPX_MAX_PERIODIC_RIP_TX_TIME))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_SAP_aging_timer (ULONG sap_aging_timer)
{
	if ((sap_aging_timer > IPX_MIN_SAP_AGING_TIMER) && (sap_aging_timer < IPX_MAX_SAP_AGING_TIMER))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_RIP_aging_timer (ULONG rip_aging_timer)
{
	if ((rip_aging_timer > IPX_MIN_RIP_AGING_TIMER) && (rip_aging_timer < IPX_MAX_RIP_AGING_TIMER))
		return (TRUE);
	else
		return (FALSE);
}
#endif

#if 0 /* Jo 29/04/99 */
enum BOOLEAN validate_default_ttl (ULONG ttl)
{
	if ((ttl > IP_MIN_DEFAULT_TTL) && (ttl < IP_MAX_DEFAULT_TTL))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_reassembly_timeout (ULONG reas_timeout)
{
	if ((reas_timeout > IP_MIN_REASSEMBLY_TIMEOUT) && (reas_timeout < IP_MAX_REASSEMBLY_TIMEOUT ))
		return (TRUE);
	else 
		return (FALSE);
}
#endif /* Jo 29/04/99 */

#ifdef _BIG_PROXY_
enum BOOLEAN validate_rip_route_aging_timer ( ULONG rip_timer)
{
	if ((rip_timer > IP_MIN_RIP_ROUTE_AGING_TIMER) && (rip_timer < IP_MAX_RIP_ROUTE_AGING_TIMER))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_root_cost (ULONG root_cost)
{
	if ((root_cost > STP_MIN_ROOT_PATH_COST) && (root_cost < STP_MAX_ROOT_PATH_COST))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_config_req (ULONG config_req)
{
	if ((config_req > PPP_MIN_CONFIG_REQUESTS) && (config_req < PPP_MAX_CONFIG_REQUESTS	))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_term_req (ULONG term_req)
{
	if ((term_req > PPP_MIN_TERMINATION_REQUESTS) && (term_req < PPP_MAX_TERMINATION_REQUESTS))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_unack_echo (ULONG unack_echo)
{
	if ((unack_echo > PPP_MIN_UNACK_ECHO_REQUESTS) && (unack_echo < PPP_MAX_UNACK_ECHO_REQUESTS))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_config_sendi (ULONG config_sendi)
{
	if ((config_sendi	> PPP_MIN_CONFIG_REQUEST_SENDI) && (config_sendi < PPP_MAX_CONFIG_REQUEST_SENDI))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_term_sendi (ULONG term_sendi)
{
	if ((term_sendi > PPP_MIN_TERMINATION_REQUEST_SENDI) && (term_sendi < PPP_MAX_TERMINATION_REQUEST_SENDI))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_echo_sendi (ULONG echo_sendi)
{
	if ((echo_sendi > PPP_MIN_ECHO_REQUEST_SENDI) && (echo_sendi < PPP_MAX_ECHO_REQUEST_SENDI))
		return (TRUE);
	else
		return (FALSE);
}

enum BOOLEAN validate_config_broadi (ULONG config_broadi)
{
	if ((config_broadi > PPP_MIN_CONFIG_REQUEST_BROADI) && (config_broadi < PPP_MAX_CONFIG_REQUEST_BROADI))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_MRU (ULONG MRU)
{
	if ((MRU > PPP_MIN_MRU) && (MRU < PPP_MAX_MRU))
		return (TRUE);
	else 
		return (FALSE);
}

enum BOOLEAN validate_ag_inactivity_time (ULONG age_time)
{
	if ((age_time > AG_MIN_INACTIVITY_TIMEOUT) && (age_time < AG_MAX_INACTIVITY_TIMEOUT))
		return (TRUE);
	else 
		return (FALSE);
}
#endif

enum BOOLEAN validate_ip_address (BYTE *ip_address)
{
	int i=0;

	while (*ip_address)
	{
		if (((*ip_address) >= '0') && ((*ip_address) <= '9')
			||((*ip_address) >= 'a') && ((*ip_address) <= 'f')
				||((*ip_address) >= 'A') && ((*ip_address) <= 'F'))

					ip_address++;
		else if (*ip_address == '.')
		{
			i++;
			ip_address++;
		}
		else 
			return(FALSE);
	}
	if (i == 3)
		return (TRUE);
	else
		return (FALSE);
}		

enum BOOLEAN validate_subnetmask (BYTE *subnet)
{
	int no_of_dots=0, count=0, flag=0;
	BYTE *save_subnet;
	ULONG address;


	save_subnet = subnet;
	while (*subnet)
	{
		if (((*subnet) >= '0') && ((*subnet) <= '9')
/*			||((*subnet) >= 'a') && ((*subnet) <= 'f')
				||((*subnet) >= 'A') && ((*subnet) <= 'F') */)
		{
			subnet++;
		}
		else
			if (*subnet == '.')
		   {
				no_of_dots++;
				subnet++;
			}
		 	else 
		 		return (FALSE);
	}

	if (no_of_dots == 3)
	{
		address  = str_to_net (save_subnet);
		for (count =0;	count < 32 ;count++)
		{
			address <<= 1;
			if (!(address & 0x80000000) && !flag)
  				flag = 1;
			else
				if ((address & 0x80000000) && flag)
					return (FALSE);
		 }
		 return (TRUE);
	}
	else 
		return(FALSE);
}

/* Jo 21/08/99 Added for Validating Gateway Address for Static Routes */

enum BOOLEAN check_if_gateway_is_valid (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT port_number, BYTE msg_string[300])
{
	ULONG int_ip_address1, int_ip_address2, int_address_mask ;
	BYTE ip_address[20], address_mask[20] ;

   ip_address[0] = 0;
	get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_IP_ADDRESS,		
		port_number, CM_ULONG_FORMAT, &int_ip_address1, 20, NULL) ;				

	get_parameter (client_info_ptr->connection_id, CM_IP_SECTION, IP_PORT_SUBNET_MASK,
		port_number, CM_DOT_FORMAT, &address_mask[0], 20, NULL) ;				

	get_dot_decimal_ip_address_even_if_zero (int_ip_address1, &ip_address[0]) ;

	get_ulong_ip_address (buffer, &int_ip_address2) ;
	get_ulong_ip_address (address_mask, &int_address_mask) ;

	if (!buffer[0])
	{
		if (strcmp (ip_address, "0.0.0.0") != 0)
		{
			strcpy (msg_string, "\n\rInvalid Gateway Address") ;
			return (FALSE) ;
		}
		else
			return (TRUE) ;
	}
	else
	{
		if ((strcmp (buffer, "0.0.0.0") == 0) && (strcmp (ip_address, "0.0.0.0") == 0))
			return (TRUE) ;

		if (!is_an_ip_address_even_if_zero (buffer))
		{
			strcpy (msg_string, "\n\rInvalid Gateway Address") ;
			return (FALSE) ;
		}	
		if ((strcmp (buffer, ip_address) == 0)	&& !port_number)
		{
			strcpy (msg_string, "\n\rInvalid Gateway address. Gateway Address is same as LAN Address") ;
			return (FALSE) ;
		}	

		if (((int_ip_address1 & int_address_mask) != (int_ip_address2 & int_address_mask)) && !port_number)
		{
			strcpy (msg_string, "\n\rInvalid Gateway address. Gateway Address should be of the same net as that of ProxyServer") ;
			return (FALSE) ;
		}
	 	if (port_number)
		{
			if ((strcmp (buffer, "0.0.0.0") != 0) && (strcmp (ip_address, "0.0.0.0") != 0))
				if ((int_ip_address1 & int_address_mask) != (int_ip_address2 & int_address_mask))
				{
					strcpy (msg_string, "\n\rInvalid Gateway Address. Gateway Address should be of the same net") ;
					return (FALSE) ;
				}
		}
		if ((strcmp (ip_address, "0.0.0.0") == 0)	&& (strcmp (buffer, "0.0.0.0") != 0))
		{
		 	strcpy (msg_string, "\n\rIP Address is ISP Assigned Dynamic for this port. Do not enter Gateway Address") ;
		 	return (FALSE) ;
		}
	}
	return (TRUE) ;
}

/* Jo 21/08/99 Added for Validating Gateway Address for Static Routes */
