#include	<defs.h>
#include	<string.h>

#include	"telnet.h"
#include	"menu.h"

/****************************************************************************
	Routine		: will_timing_mark
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Generating responses for TIMING MARK option. If you recv a
						DO TM option always send a WILL followed by the new info 
						that you want the client to display. The client sends a 
						Timing-Mark to synchronise with the server.
****************************************************************************/

USHORT	will_timing_mark(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	telnet.tx_buffer[i++] = TCIAC;

	if (client_info_ptr->option_cmd == TCDONT)
		telnet.tx_buffer[i++] = TCWONT;
	else
		telnet.tx_buffer[i++] = TCWILL;

	telnet.tx_buffer[i++] = character;
	send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0);

	if (client_info_ptr->menustate == TMS_CHATMODE) /* 1/12/95 */
		return(1);

#ifdef _BIG_PROXY_
	/* now send the request again */
	if(client_info_ptr->verifying_pwd) {
		return (send_telnet_packet(client_info_ptr, PasswordStr, strlen(PasswordStr), 0));
	}
#endif
	/* if we are in the middle of sending some info, stop sending it.
	We display the previous menu . Only way a user can stop the session, is by typing 'exit' or with IP. */

	if(client_info_ptr->more > 0) 
		back_to_normal_mode(client_info_ptr);
	return (menu_state_machine(client_info_ptr, NULL));
}


/****************************************************************************
	Routine		: do_timing_mark
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Requesting for TIMING MARK option. If you recv a
						WILL/WONT TM option send a DO if not sent earlier.
						WILL/WONT is always a response and never a request.
						The server sends a Timing-Mark to synchronise with the client.
****************************************************************************/

USHORT	do_timing_mark(TELNET_CLIENT_CLASS	*client_info_ptr, BYTE character)
{
	USHORT			i=0;


	if (client_info_ptr->sndtmark) {
		/* Got a response. So reset the flag */
		client_info_ptr->sndtmark = !client_info_ptr->sndtmark;
		return 1;
	}
	/* Sending a request. So set the flag */
	client_info_ptr->sndtmark = !client_info_ptr->sndtmark;
	telnet.tx_buffer[i++] = TCIAC;
	telnet.tx_buffer[i++] = TCDO;
	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}
