#include	<defs.h>
#include	"telnet.h"

/****************************************************************************
	Routine		: will_noga
	Input			: Index to TELNET structure corresponding to this connection.
						Character - option.
	Synopsis		: Generates Response for SUPPRESS GO-AHEAD option.  
****************************************************************************/

USHORT	will_noga(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->noga) {
		if (client_info_ptr->option_cmd == TCDO)
			return 1;
	} else if (client_info_ptr->option_cmd == TCDONT)
			return 1;

	client_info_ptr->noga = !client_info_ptr->noga;

	telnet.tx_buffer[i++] = TCIAC;
	if (client_info_ptr->noga)
		telnet.tx_buffer[i++] = TCWILL;
	else
		telnet.tx_buffer[i++] = TCWONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}

USHORT	do_noga(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->noga)
	{
		if (client_info_ptr->option_cmd == TCWILL)
			return 1;
	}
	else
	{
		if (client_info_ptr->option_cmd == TCWONT)
			return 1;
	}

	client_info_ptr->noga = !client_info_ptr->noga;

	telnet.tx_buffer[i++] = TCIAC;

	if (client_info_ptr->noga)
		telnet.tx_buffer[i++] = TCDO;
	else
		telnet.tx_buffer[i++] = TCDONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}
