#ifndef _KTFTP_H_
#define _KTFTP_H_

/* opcodes for the 5 TFTP packet types */
#define	OPCODE_READ		1
#define	OPCODE_WRITE	2
#define	OPCODE_DATA		3
#define	OPCODE_ACK		4
#define	OPCODE_ERROR	5

/* possible modes for a TFTP Read/Write request */
#define	MODE_NETASCII	"netascii"
#define	MODE_OCTET		"octet"

/* error messages in response to read or write request */
#define	ERR_FILE_NOT_FOUND	"File not found"
#define	ERR_ACCESS_DENIED		"Access denied"

/* arbitrary values just for the sake of structure definition */
#define	MAX_FILE_NAME_AND_MODE	100
#define	MAX_ERROR_MESG_LENGTH	100

#define	MULTIPLE            		3
#define	MAX_RETRIES					10
#define	RETRANSMISSION_PERIOD	20 * 19
#define	MAX_RETRY_COUNT     		10
#define	CONNECTION_ABORT_TIME	(MAX_RETRIES * RETRANSMISSION_PERIOD * MULTIPLE)
#define	MAX_CONNECTIONS			10

#define  MAX_FILES               20		/* maximum TFTP files */

#define	MAX_TFTP_PACKET_SIZE		600
#define	TFTP_BLOCK_SIZE			512
#define	SMALL_PRX_HEADER_SIZE	64
#define	DONT_RESET					1

/* Error codes for Error packet */
#define	ERR_UNDEFINED				0
#define	ERR_NO_FILE					1
#define	ERR_ACCESS_VIOLATION		2
#define	ERR_DISK_FULL				3
#define	ERR_ILLEGAL_TFTP_OP		4
#define	ERR_UNKNOWN_ID				5
#define	ERR_FILE_EXISTS			6
#define	ERR_NO_USER					7

/* Return codes of the state machine handlers */
#define	NO_CHANGE               1
#define	NO_REQUEST              2
#define	CONNECTION_TABLE_FULL   3
#define	CANNOT_OPEN_SOCKET      4
#define	BIND_FAILED             5
#define	FILE_OPEN_ERROR         6
#define	NO_MEMORY               7
#define	INVAID_OPCODE           8
#define	CONNECTION_BROKEN       9
#define	FT_COMPLETE             10
#define	RETRANSMIT_PACKET       11
#define	DUPLICATE_BLOCK         12
#define	SEND_FAILED             13
#define	RECEIVE_FAILED          14
#define	CANNOT_MANIPULATE_SOCKET 15

#define	START_FREE_PORT_NUMBER  1024
#define	TFTP_WELL_KNOWN_PORT    69


#define	STATE_NOP					0
#define	STATE_LISTENING			1
#define	STATE_SEND_DATA			2
#define	STATE_WAIT_FOR_ACK		3
#define	STATE_RETRANSMIT			4
#define	STATE_WAIT_FOR_DATA		5
#define	STATE_SEND_ACK				6
#define	STATE_CLOSE_SOCKET		7
#define	STATE_ABORT_CONNECTION	8

#define	IPPROTO_UDP          	0

#define	MAGIC_NUMBER            0xABCD
 /* needs to be changed if changed in BOOT.H */

enum TFTP_PRINTF_GROUPS
{
	TFTP_INIT_PRINTF,
	TFTP_TRACE_PRINTF
} ;

#define TFTP_HUPAND_REDIAL  25

#if PROXY_SERVER

#define PORT_STATISTICS_FILE_NAME "PORTSTAT.ONL"
#define PORT_STATUS_INFO_HEADER_SIZE 512

#endif

#ifdef EVENT_LOG
#define	EVENTS_LOG_FILE_NAME	"EVENTS.LOG"
#endif

#endif
