/*
	changes chetan 21st July 97
	Checking for invalid mem locations changed
	see comments NEW_BOOT
*/

#include "tftp.h"
#include "..\..\store\boot.h"
#include <flashmgr.h>

/* Jo : 05/01/99 Made changes for TFTP Flash read/write */

#if PROXY_SERVER
#include "..\..\devdrvrs\uim\brcif.h"
void fill_out_port_status (USHORT start_port, USHORT end_port, BYTE *sptr_port_status) ;
#endif

#ifdef EVENT_LOG
#include "..\..\include\logif.h"
#endif

BYTE reboot_needed = 0 ; /* Jo 20/07/99 Reboot if not Default Setup */

void user_database_write_complete (void) ;
extern char *	strchr(const char *, int);

#if	SMALL_MEM_MAP
extern	BootBinIOPBType	BootBinIOPB;
#else
extern unsigned char *DownloadFlag ;
#endif

#define	WARM_BOOT_MODE 0x5A
#define	COLD_BOOT_MODE 0x00

extern int higher_write_to_flash(char *src, char *dest, int size) ;
extern void reset(void) ;
extern ULONG WatchDogServiceRegister;

/* chetan 5/11/96 */
extern int GetFileType (BYTE *FileName) ;
/* chetan 5/11/96 */

/* chetan 6/11/96 */
extern WORD GetPortScrCodLen (USHORT PortNum) ;
/* chetan 6/11/96 */

extern void	big_delay() ;

void c_write_to_flash (char *src, char *dest, int size)
{

/* NEW_BOOT */
#if 1
	if (dest < (char *) FL_CODE_HDR || dest > (char *) FL_PROM_END
				|| (char *) (dest + (DWORD) size) > (char *) FL_PROM_END)
	{
		return ;
	}
#else
	if (dest < (char *)0x11200)
	{
		return ;
	}
#endif
/* NEW_BOOT */

	higher_write_to_flash (src, dest, size) ;
	return ;
}


/****************************************************************************/
FILE_INFO *get_ptr_to_file_info_entry (BYTE *file_name)
{
	USHORT i = 0 ;
	FILE_INFO *sptr_file_info_entry = &file_info_list[0] ;

	while (sptr_file_info_entry->file_name != NULL)
	{
		if (strcmp (sptr_file_info_entry->file_name, file_name) == 0)
			return (sptr_file_info_entry) ;

		sptr_file_info_entry = &file_info_list[++i] ;
	}

	return NULL ;
}


/****************************************************************************/
void free_memory_block_chain (FILE_HANDLE *file_handle)
{
	MEMORY_BLOCK *ptr_memory_block = file_handle->memory_blocks_chain,
	             *ptr_to_next_block ;

	while (ptr_memory_block != NULL)
	{
		ptr_to_next_block = ptr_memory_block->ptr_to_next_block ;
		free (ptr_memory_block) ;
		ptr_memory_block = ptr_to_next_block ;
	}
	return ;
}


/****************************************************************************/
FILE_HANDLE *tftp_open (BYTE *file_name, enum OPEN_MODE open_mode)
{
	FILE_HANDLE *file_handle ;
	FILE_INFO *sptr_file_info_entry ;

	sptr_file_info_entry = get_ptr_to_file_info_entry (file_name) ;

	if (sptr_file_info_entry == NULL)
	{
		tftp_fileio_error_code = FILE_NOT_FOUND ;
		return 0 ;
	}

	if ((open_mode == OPEN_FOR_WRITE) && (sptr_file_info_entry->write_lock == LOCK_STATUS_ON))
	{
		tftp_fileio_error_code = WRITE_ACCESS_DENIED ;
		return 0 ;
	}

#if PROXY_SERVER

   if (strcmpi (PORT_STATISTICS_FILE_NAME, file_name) == 0)
   {
      fill_out_port_status (0, (lsl_control (GET_NUMBER_OF_WAN_PORTS)) - 1, &port_status_info[PORT_STATUS_INFO_HEADER_SIZE]) ;
   }

#endif

	file_handle = (FILE_HANDLE *) malloc (sizeof (FILE_HANDLE)) ;
	
	if (file_handle == NULL)
	{
		tftp_fileio_error_code = HANDLE_TABLE_FULL ;
		return 0 ;
	}

	file_handle->open_mode = open_mode ;
	if (open_mode == OPEN_FOR_WRITE)
	{
		sptr_file_info_entry->write_lock = LOCK_STATUS_ON ;
	}

	strcpy (&file_handle->file_name[0], file_name) ;
	file_handle->file_address = sptr_file_info_entry->file_address ;
	file_handle->file_seek_ptr = sptr_file_info_entry->file_address ;
   file_handle->file_length = sptr_file_info_entry->file_length ;
	file_handle->no_of_bytes_read = 0 ;
	file_handle->memory_blocks_chain = NULL ;
	file_handle->last_memory_block = NULL ;
	file_handle->accumulated_crc = 0xFFFF ;

#if EVENT_LOG
   if (strcmpi (EVENTS_LOG_FILE_NAME, file_name) == 0)
	{
		int	ld;		/* log open descriptor */

		/* we will try to open the event log here itself and store the
		log_descriptor */
		ld = open_log();
		if (ld < 0)
		{
			tftp_fileio_error_code = FILE_NOT_FOUND ;
			free(file_handle);
			return 0 ;
		}
		file_handle->log_descriptor = ld;
	}
	else
	{
		file_handle->log_descriptor = LOG_INVALID_DESCRIPTOR;
	}
#endif

	return (file_handle) ;
}


/****************************************************************************/
ULONG tftp_read (BYTE *buffer_to_read_into, ULONG no_of_bytes, FILE_HANDLE *file_handle)
{
	int	return_value;
	BYTE *port_ptr;
	HEADER_TYPE *ptr_to_header ;
	UDB_HEADER_TYPE *ptr_to_udb_header ;

	/* chetan 5/11/96 */
	int FileType ;
	/* chetan 5/11/96 */

	FileType = GetFileType (file_handle->file_name) ;

	switch (FileType)
	{
		case 0 :  /* CONFIG.INI */
		case 1 :  /* MTROUTER.BIN */ 

			if (file_handle->no_of_bytes_read == 0)
			{
				/* meaning this is the header block */
				ptr_to_header = (HEADER_TYPE *) file_handle->file_seek_ptr ;
				file_handle->file_length = ptr_to_header->code_length + SMALL_PRX_HEADER_SIZE ; /* Jo header size */
				no_of_bytes = (no_of_bytes > TFTP_BLOCK_SIZE) ?
		      					         TFTP_BLOCK_SIZE : no_of_bytes ;

				memcpy (buffer_to_read_into, 
							file_handle->file_seek_ptr, no_of_bytes) ;
				file_handle->file_seek_ptr = ptr_to_header->down_load_address ;
				file_handle->no_of_bytes_read += SMALL_PRX_HEADER_SIZE ;
				return no_of_bytes ;
			}
			else
			{
				no_of_bytes = 
  					(no_of_bytes > (file_handle->file_length - file_handle->no_of_bytes_read)) 
  						? (file_handle->file_length - file_handle->no_of_bytes_read) 
										: no_of_bytes ;
				memcpy (buffer_to_read_into, 
									file_handle->file_seek_ptr, no_of_bytes) ;
				file_handle->file_seek_ptr += no_of_bytes ;
				file_handle->no_of_bytes_read += no_of_bytes ;
				return no_of_bytes ;
			}
/* Jo 08/07/99 changed for UDB read */
		case 3 :  /* USER.DTB */
 
			if (file_handle->no_of_bytes_read == 0)
			{
				/* meaning this is the header block */
				ptr_to_udb_header = (UDB_HEADER *) file_handle->file_seek_ptr ;
				file_handle->file_length = ptr_to_udb_header->code_length + SMALL_PRX_HEADER_SIZE ; /* Jo header size */
				no_of_bytes = (no_of_bytes > TFTP_BLOCK_SIZE) ?
		      					         TFTP_BLOCK_SIZE : no_of_bytes ;

				memcpy (buffer_to_read_into, 
							file_handle->file_seek_ptr, no_of_bytes) ;
				file_handle->file_seek_ptr = ptr_to_udb_header->down_load_address ;
				file_handle->no_of_bytes_read += SMALL_PRX_HEADER_SIZE ;
				return no_of_bytes ;
			}
			else
			{
				no_of_bytes = 
  					(no_of_bytes > (file_handle->file_length - file_handle->no_of_bytes_read)) 
  						? (file_handle->file_length - file_handle->no_of_bytes_read) 
										: no_of_bytes ;
				memcpy (buffer_to_read_into, 
									file_handle->file_seek_ptr, no_of_bytes) ;
				file_handle->file_seek_ptr += no_of_bytes ;
				file_handle->no_of_bytes_read += no_of_bytes ;
				return no_of_bytes ;
			}

		case 6 :   /* PORT1.FIL */
		case 7 :	  /* PORT2.FIL */
		case 8 :	  /* PORT3.FIL */
			if (file_handle->no_of_bytes_read == 0)
			{
				file_handle->file_length = 
					(ULONG) GetPortScrCodLen ((USHORT) FileType - 6) ;
			}

		case 2 :   /* FILE.LST */
		case 4 :   /* BOOT.CFG */
		case 5 :   /* SCRIPT.HDR */
#if PROXY_SERVER
      case 9 : /* PORTSTAT.ONL */
#endif
			no_of_bytes = 
  				(no_of_bytes > (file_handle->file_length - file_handle->no_of_bytes_read)) 
  					? (file_handle->file_length - file_handle->no_of_bytes_read) 
									: no_of_bytes ;
			memcpy (buffer_to_read_into, 
								file_handle->file_seek_ptr, no_of_bytes) ;
			file_handle->file_seek_ptr += no_of_bytes ;
			file_handle->no_of_bytes_read += no_of_bytes ;
			return no_of_bytes ;

#if EVENT_LOG
#if PROXY_SERVER
      case 10 : /*  EVENTS.LOG */
#else
      case 9 : /*  EVENTS.LOG */
#endif
			return_value = read_log(file_handle->log_descriptor,
						buffer_to_read_into,	no_of_bytes);
			if (return_value < 0)		/* we don't handle errors in log */
				return_value = 0;
			file_handle->file_seek_ptr += return_value ;	/* no need */
			file_handle->no_of_bytes_read += return_value ;
			return ((ULONG)return_value);
#endif

		default :
			return 0;
	}
}



/****************************************************************************/
/* Edit plan : tftp_write() can detect if the packet is the first packet/
               last packet / intermediate packet. If it is a the first
					packet and if the magic number is incorrect, return 0. If
					it is the last packet and the checksums do not match,
					return 0
*/
int next_block ;
ULONG tftp_write (BYTE *buffer_to_write_from, ULONG no_of_bytes, FILE_HANDLE *file_handle)
{
	MEMORY_BLOCK *new_block ;
	HEADER_TYPE *header ;
	UDB_HEADER_TYPE *udb_header ;
	USHORT two_zeroes = 0 ;
	int FileType ;

/* Jo 08/07/99 changed for UDB write */
	FileType = GetFileType (file_handle->file_name) ;

	no_of_bytes = (no_of_bytes > TFTP_BLOCK_SIZE) ? TFTP_BLOCK_SIZE : no_of_bytes ;
	new_block = (MEMORY_BLOCK *) malloc (no_of_bytes + sizeof (MEMORY_BLOCK)-1) ;
	if (new_block == NULL)
	{
		tftp_fileio_error_code = MEM_ALLOC_FAILED ;
		return 0 ;
	}
	
	new_block->ptr_to_next_block = NULL ;
	new_block->block_length = no_of_bytes ;
	memcpy (&new_block->start_of_data[0], buffer_to_write_from, no_of_bytes) ;
	
	if (file_handle->memory_blocks_chain == NULL)
	{
		/* This is the first block */
		next_block = 0 ;

		file_handle->memory_blocks_chain = new_block ;
		file_handle->last_memory_block = new_block ;

/* Jo 08/07/99 changed for UDB write */
		if (FileType == 3)	 /* USER.DTB */
		{
			udb_header = (UDB_HEADER_TYPE *)&new_block->start_of_data[0] ;
			if (net_to_host_short(udb_header->magic_number) != MAGIC_NUMBER)
			{
				tftp_fileio_error_code = INCORRECT_MAGIC_NUMBER ;
				return 0 ;
			}
/* Jo 20/07/99	Reboot if not Default Setup */
			if (udb_header->reboot_flag == 1)
				reboot_needed = DONT_RESET ;				
		}
		else
		{
			header = (HEADER_TYPE *)&new_block->start_of_data[0] ;
			if (net_to_host_short(header->magic_number) != MAGIC_NUMBER)
			{
				tftp_fileio_error_code = INCORRECT_MAGIC_NUMBER ;
				return 0 ;
			}
		}
	}
	else
	{
		file_handle->last_memory_block->ptr_to_next_block = new_block ;
		file_handle->last_memory_block = new_block ;

		/* update the cumulative crc.
		   If it is the last packet and if the computed crc does not match
			the crc in the first packet, set the error code and return 0 */
		
		file_handle->accumulated_crc = update_crc(file_handle->accumulated_crc,
		                                          buffer_to_write_from, no_of_bytes) ;

		if (no_of_bytes < TFTP_BLOCK_SIZE) /* meaning last packet */
		{
			file_handle->accumulated_crc = update_crc(file_handle->accumulated_crc,
			                                          &two_zeroes, 2) ;
/* Jo 08/07/99 changed for UDB write */
			if (FileType == 3)	 /* USER.DTB */
			{
				udb_header = (UDB_HEADER_TYPE *)(&file_handle->memory_blocks_chain->start_of_data[0]) ;
				if (net_to_host_short(udb_header->crc) != file_handle->accumulated_crc)
				{
/*					printf("\n\tComputed checksum : %04X, Received checksum : %04X",
				       file_handle->accumulated_crc, net_to_host_short(udb_header->crc)) ; */
					tftp_fileio_error_code = INCORRECT_CHECKSUM ;
					return 0 ;
				}
			}
			else
			{
				header = (HEADER_TYPE *)(&file_handle->memory_blocks_chain->start_of_data[0]) ;
				if (net_to_host_short(header->crc) != file_handle->accumulated_crc)
				{
/*					printf("\n\tComputed checksum : %04X, Received checksum : %04X",
				       file_handle->accumulated_crc, net_to_host_short(header->crc)) ; */
					tftp_fileio_error_code = INCORRECT_CHECKSUM ;
					return 0 ;
				}
			}
		}
	}

	return (no_of_bytes) ;
}

/****************************************************************************/

/* Jo 29/06/99 Modified UDB read and write */
int tftp_close (FILE_HANDLE *file_handle)
{
	HEADER_TYPE header ;
	UDB_HEADER_TYPE udb_header ;
	MEMORY_BLOCK *prev_block, *next_block_to_write = file_handle->memory_blocks_chain ;
	BYTE *flash_address_to_write_next_block ;

	FILE_INFO *file_info ;
	void (*fptr_write_over)(void) ; 
	
	int file_type ;
	int save_pl;		/* location to save interupt priority level */

	ULONG *fail_led_pointer = (ULONG *)0xFF000010L ;
	int	block_count = 0;

	if (file_handle->open_mode == OPEN_FOR_READ)
	{
		free (file_handle) ;
#if EVENT_LOG
		if (file_handle->log_descriptor != LOG_INVALID_DESCRIPTOR)
			close_log(file_handle->log_descriptor);
#endif
		return (-1) ;
	}

	file_type = GetFileType (file_handle->file_name) ;

	file_info = get_ptr_to_file_info_entry (file_handle->file_name) ;

	/* It is required to write the whole memory block to the
	   correct place in the flash, unlock the file and reboot */

	/* make sure that the magic number is correct in the header packet */
	/* make sure that the checksum in the header packet and the checksum
	   that we have computed are the same */
	/* disable interrupts to permit write to flash */

	if (file_type == 0)
	/* chetan 7/11/96 */
		printf ("\nTFTP : Writing configuration to flash\n\n") ;
	else
	/* chetan 7/11/96 */
		if (file_type == 1)
	/* chetan 7/11/96 */
			printf ("\nTFTP : Writing firmware to flash\n\n") ;
		if (file_type == 3)
			printf ("\nTFTP : Writing User database to flash\n\n") ;

	if (file_type == 3) /* USER.DTB */
	{
		memset (&udb_header, 0, SMALL_PRX_HEADER_SIZE) ;
		memcpy (&udb_header, &next_block_to_write->start_of_data[0], SMALL_PRX_HEADER_SIZE) ;
	}
	else
	{
		memset (&header, 0, SMALL_PRX_HEADER_SIZE) ;
		memcpy (&header, &next_block_to_write->start_of_data[0], SMALL_PRX_HEADER_SIZE) ;
	}
	flash_address_to_write_next_block = file_handle->file_address ;

	if ((file_type == 0) || (file_type == 1) || (file_type == 3))
	{
		save_pl = _GPL();
		_SPL(7);
		if (file_type == 3)
			c_write_to_flash((BYTE *)&udb_header, flash_address_to_write_next_block, SMALL_PRX_HEADER_SIZE) ;
		else
			c_write_to_flash((BYTE *)&header, flash_address_to_write_next_block, SMALL_PRX_HEADER_SIZE) ;
	}
	else
		if (file_type == 6 || file_type == 7 || file_type == 8 || file_type == 5)
 		{
		}

#if 0
	printf ("\ntftp : Block # %d written to flash from %08X", block_number++, next_block_to_write) ;
#endif

	prev_block = next_block_to_write ;
	next_block_to_write = next_block_to_write->ptr_to_next_block ;

/* Jo 29/06/99 Free up the block even if UDB */
	free (prev_block) ;

	if (file_type == 3)
		flash_address_to_write_next_block = udb_header.down_load_address ;
	else
		flash_address_to_write_next_block = header.down_load_address ;

	/* write the whole file to the flash */

	*fail_led_pointer = 0xFE;	/* turn the fail led on */
	while (next_block_to_write != NULL)
	{
		if (block_count++ == 10)
			*fail_led_pointer = 0xFF;	/* turn the fail led off */
		if (block_count == 40)
		{
			*fail_led_pointer = 0xFE;	/* turn the fail led on */
			block_count = 0;
		}

		*((BYTE *)WatchDogServiceRegister)= 0xAA;
		*((BYTE *)WatchDogServiceRegister)= 0x55;

		if (file_type == 3)
			c_write_user_database_to_AMD_flash (&next_block_to_write->start_of_data[0], 
				flash_address_to_write_next_block, next_block_to_write->block_length) ;
		else
			c_write_to_flash(&next_block_to_write->start_of_data[0], 
				flash_address_to_write_next_block, next_block_to_write->block_length) ;

		file_info->file_length += next_block_to_write->block_length ;

		flash_address_to_write_next_block += next_block_to_write->block_length ;
		prev_block = next_block_to_write ;
		next_block_to_write = next_block_to_write->ptr_to_next_block ;
		free (prev_block) ;
	}
	*fail_led_pointer = 0xFF;	/* turn the fial led off */

/* Jo 08/07/99 changed for UDB write */
	if ((file_type == 0) || (file_type == 1) || ((file_type == 3) && (reboot_needed != DONT_RESET))) 
	{
printf("\n\rtftp : Rebooting the box.....\n\r\n\r") ;

		if (file_type == 0)
		{
#if	SMALL_MEM_MAP
			BootBinIOPB.BootMode = WARM_BOOT_MODE;
#else
			*DownloadFlag = WARM_BOOT_MODE ;
#endif
		} else {
#if	SMALL_MEM_MAP
			BootBinIOPB.BootMode = COLD_BOOT_MODE;
#else
			*DownloadFlag = COLD_BOOT_MODE ;
#endif
		}
		reset() ;
	}
	else 
	{	
		if (file_type != 3)
			printf ("\nTFTP : Writing script to Flash\n\n") ;
		if (file_type == 3)
		 _SPL(save_pl);
		
		/* chetan 8/11/96 */
		file_info->write_lock = LOCK_STATUS_OFF ;
		if (file_handle)
			free (file_handle) ;
	}
	return (0) ;
}

/****************************************************************************/
/* tftp_release() is similar to tftp_close() except that it does not transfer
   the contents to the flash. All it does is release the buffers allocated
	for the particular handle
*/

void tftp_release (FILE_HANDLE *file_handle)
{
	FILE_INFO *sptr_file_info_entry ;

	free_memory_block_chain (file_handle) ;

	if (file_handle->open_mode == OPEN_FOR_WRITE)
	{
		sptr_file_info_entry = get_ptr_to_file_info_entry (file_handle->file_name) ;
		if (sptr_file_info_entry->write_lock == LOCK_STATUS_ON)
			sptr_file_info_entry->write_lock = LOCK_STATUS_OFF ;
	}
#ifdef EVENT_LOG
	if (file_handle->log_descriptor != LOG_INVALID_DESCRIPTOR)
		close_log(file_handle->log_descriptor);
#endif

	free (file_handle) ;

	return ;
}

#ifdef RAS

int tftp_udb_write_complete = 0 ;

void user_database_write_complete (void)
{
	printf ("\nUser Database write complete") ;
	flash_accessibility[0] = FLASH_WRITE_COMPLETE ;
	tftp_udb_write_complete = 1 ;
}

#endif
