#include <stdlib.h>
#include <stdio.h>
#include "tftp.h"


/* During each timer call, ONE connection descriptor is moved by ONE state.
   This is done with an intention of eating up as little time of the foreground
	as possible. The connection descriptor that has to be moved during the
	current call is maintained in connect_descriptor_to_operate_on.
	If necessary, TFTP transfer can be considerably speeded up by
		(a). operating on all connect-descriptors
		(b). Move by more than one state
*/

connect_descriptor_to_operate_on = 0 ;
void tftp_timer (void)
{
	ULONG this_call ;
	int i, return_value ;

	if ((tftp.enabled == FALSE) || (tftp.socket_interface_enabled == FALSE) || (tftp.socket_interface_initialized == FALSE))
	{
		return ;
	}
	
	if (tftp.timer_class.timer_enabled == FALSE)
	{
		return ;
	}

	this_call = get_timer_marker() ;
	inter_call_gap = this_call - last_call ;
	last_call = this_call ;


	for (i = 0 ; i <= tftp.max_connections ; i++)
	{
		if (connect_info_table[connect_descriptor_to_operate_on].in_use_flag)
		{
			return_value =
			     tftp_state_machine_handlers[connect_info_table[connect_descriptor_to_operate_on].current_state](connect_descriptor_to_operate_on) ;

			if ((connect_info_table[connect_descriptor_to_operate_on].current_state == STATE_SEND_DATA) ||
			    (connect_info_table[connect_descriptor_to_operate_on].current_state == STATE_SEND_ACK))
					return_value =	
					     tftp_state_machine_handlers[connect_info_table[connect_descriptor_to_operate_on].current_state](connect_descriptor_to_operate_on) ;

			connect_descriptor_to_operate_on++ ;
			if (connect_descriptor_to_operate_on > tftp.max_connections)
				connect_descriptor_to_operate_on = 0 ;

			if ((return_value == NO_REQUEST) || (return_value == NO_CHANGE))
				continue ;

			break ;
		}
		else
		{
			connect_descriptor_to_operate_on++ ;
			if (connect_descriptor_to_operate_on > tftp.max_connections)
				connect_descriptor_to_operate_on = 0 ;
		}
	}

	tftp.timer_class.tick_counter++ ;

	for (i = 0 ; i <= tftp.max_connections ; i++)
	{
		if (connect_info_table[i].in_use_flag)
		{
			if (connect_info_table[i].connection_abort_time)
				connect_info_table[i].connection_abort_time-- ;

			if (connect_info_table[i].retransmission_timer)
				connect_info_table[i].retransmission_timer-- ;
		}
	}

}

ULONG get_timer_marker()
{
	return (tftp.timer_class.tick_counter) ;
}



/*
	This is a new timer, which is used to do flash writes.
   Timers 1 and 2 are cascaded to get this 10 ms timer.
	The new timer-isr is new_periodic_timer and it is coded in
	..\..\store\pertimer.68k
*/

void ten_ms_timer ()
{
#ifndef SMALL_MEM_MAP
ULONG ten_ms_counter = 100 * 100 ;
	if (ten_ms_counter)
		ten_ms_counter-- ;
	else
	{
		/* printf ("\nHundred and fifty seconds up") ; */
		ten_ms_counter = 100 * 100 ;
	}
	write_next_page () ;
#endif
}


