/*--------------------------------------------------------------------------
	File         : utils.c
	Synopsis     : This file contains routines to send ACKs, data, errors,
	               receive data and similar routines. The routines are designed
						to use the socket programming interface calls. The entries
						in the sockaddr_in are all IP addresses. So the applications
						that call these routines need only to pass the IP address,
						protocol port, socket and other parameters. The routines
						take care of setting up the general sockaddr_in structure.
	Date         : 22.8.95
	Edit plan    :
	Edit history :
		1. (12.09.95) recvfrom() returns 0 if no data is available at the socket.
		   This is different from the standard documentation. Made changes to
			ReceiveData() so that the caller is presented a uniform "-1 means
			error" interface.
		2. (7.5.1996) To be able to do flash-write on-line, timers 1 and 2 have
		   been programmed for 10 ms. A new flash_write routine, which also
			handles the two flash types AT292040 and AT292040A is included here.
---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "tftp.h"

#if PROXY_SERVER

#include <incall.h>
#include <cfgmgr.h>
#include "..\..\devdrvrs\uim\brcif.h"

#endif

/*
  These are included in flashmgr.c   sudhir 16/12/96
USHORT crctab[256] ; 
/*---------------------------------------------------------------------------
Function	: get_connect_descriptor
Synopsis	: Returns the index of a free connect descriptor
Input 	: none
Output	: descriptor on success else -1
---------------------------------------------------------------------------*/
int get_connect_descriptor()
{
	int i ;

	for (i = 1 ; i <= tftp.max_connections ; i++)
	{
		if (connect_info_table[i].in_use_flag == 0)
		{
			memset(&connect_info_table[i], 0, sizeof(CONNECTION_INFO)) ;
			connect_info_table[i].in_use_flag = 1 ;
			return i ;
		}
	}
	return -1 ;
}


/*---------------------------------------------------------------------------
Function	: free_connect_descriptor
Synopsis	: frees up a connect descriptor which was held up for some connection
Input 	: connect descriptor
Output	: none
---------------------------------------------------------------------------*/
void free_connect_descriptor(int connect_descriptor)
{
	connect_info_table[connect_descriptor].in_use_flag = 0 ;
}


/*
unsigned short SwapWord(unsigned short x)
{
	unsigned char *Pointer = (unsigned char *)&x ;
	unsigned short y = (unsigned short) Pointer[1] ;
	y |= (unsigned short) (Pointer[0] << 8) ;
	return y ;
}
*/

#if 0	/* Jo 25/05/99 */
unsigned long SwapDWord(unsigned long x)
{
	unsigned char *Pointer = (unsigned char *)&x ;
	unsigned long y = (unsigned long) Pointer[3] ;
	y |= (unsigned long) (Pointer[2] << 8) ;
	y |= (unsigned long) (Pointer[1] << 16) ;
	y |= (unsigned long) (Pointer[0] << 24) ;
	return y ;
}
#endif /* Jo 25/05/99 */

ULONG get_ip_address (USHORT) ;

ULONG gethostid()
{
	my_node_ip_address = get_ip_address (0) ;
	return (my_node_ip_address) ;
}

/*
   if next_free_port reaches the maximum value, start with not
   0, but START_FREE_PORT_NUMBER
*/
unsigned short get_free_port()
{
	return next_free_port++ ;
}

#if 0
/* These two functions are included in flashmgr.c */

#define updcrc(cp, crc) (crctab[((crc >> 8) & 0xFF)] ^ (crc << 8) ^ ((cp) & 0xFF))  */


#define P 0x8408
void	calculate_crc_table (void)
{
	register	USHORT b, v;
	register USHORT i;

	for (b = 0 ; ; )
	{
		v = b ;
		for (i = 8 ; i-- ; )
			v = v & 1  ?  (v >> 1) ^ P : v >> 1 ;

		crctab[b] = v & 0xffff ;
		if (++b == 256)
			break ;
	}
}


USHORT update_crc(USHORT accumulated_crc, BYTE *packet, ULONG packet_length)
{
	ULONG i;
	for (i = 0 ; i < packet_length ; i++)
		accumulated_crc = updcrc(0xFF & packet[i], accumulated_crc);

	return (accumulated_crc) ;
}

#endif


void tftp_printf (enum TFTP_PRINTF_GROUPS printf_group, const char *bptr_format, ...)
{
	enum BOOLEAN print_string ;

	va_list argptr ;

	va_start (argptr, bptr_format) ;

	if (tftp.print_class.printing_enabled == FALSE)
	{
		va_end (argptr) ;
		return ;
	}

	print_string = FALSE;

	switch (printf_group)
	{
		case TFTP_INIT_PRINTF :
			print_string = tftp.print_class.init_printing_enabled ;
			break ;

		case TFTP_TRACE_PRINTF :
			print_string = tftp.print_class.trace_printing_enabled ;
			break ;

		default :
			break ;

	}

	if (print_string == TRUE)
	{
		vprintf (bptr_format, argptr);
	}

	va_end (argptr);
}

#if 0
void print_tftp_init_info (void)
{
	tftp_printf (TFTP_INIT_PRINTF, "\nTFTP Maximum Concurrent Connections = %d", tftp.max_connections) ;
	tftp_printf (TFTP_INIT_PRINTF, "\nTFTP Timeout Period = %d", tftp.timeout_period) ;
	tftp_printf (TFTP_INIT_PRINTF, "\nTFTP Number of Retransmissions = %d", tftp.number_of_retransmissions) ;
	tftp_printf (TFTP_INIT_PRINTF, "\nTFTP Initialization successful") ;
}

void print_header_info ()
{
	HEADER_TYPE *code_header, *config_header ;
	int temp = 0 ;
	USHORT my_crc = 0xFFFF ;

	config_header = (HEADER_TYPE *)file_info_list[0].file_address ;
	code_header = (HEADER_TYPE *)file_info_list[1].file_address ;

	printf("\r\n      Config header : %LX", (ULONG)config_header) ;
	printf("\r\nDown load address : %LX", (ULONG)config_header->down_load_address) ;
	printf("\r\n     Load address : %LX", (ULONG)config_header->load_address) ;
	printf("\r\n           Length : %LX", (ULONG)config_header->code_length) ;
	printf("\r\n         Checksum : %X", config_header->crc) ;

	printf("\r\n      Code header : %LX", (ULONG)code_header) ;
	printf("\r\nDown load address : %LX", (ULONG)code_header->down_load_address) ;
	printf("\r\n     Load address : %LX", (ULONG)code_header->load_address) ;
	printf("\r\n           Length : %LX", (ULONG)code_header->code_length) ;
	printf("\r\n         Checksum : %X", code_header->crc) ;

	my_crc = update_crc(0xFFFF, code_header->down_load_address, code_header->code_length) ;
	my_crc = update_crc(my_crc, (char *)&temp, 2) ;
	printf("\r\n Checksum as calculated by me : %X", my_crc) ;
}
#endif /* Jo 27/04/99 */

#if PROXY_SERVER

void fill_out_port_status (USHORT start_port, USHORT end_port, PortStatusResp *sptr_port_status_resp)
{
   USHORT port_number ;
   PortStatusInfo *sptr_port_status ;

   sptr_port_status = &sptr_port_status_resp->port_information[start_port] ;
	sptr_port_status_resp->start_port = start_port ;
	sptr_port_status_resp->end_port = end_port ;
	sptr_port_status_resp->number_of_records = end_port - start_port + 1 ;
	sptr_port_status_resp->system_up_time = lsl.system_mib.sysUpTime / 100;

   for (port_number = start_port ; port_number <= end_port ; port_number++)
   {
      sptr_port_status->port_number = port_number ;
      sptr_port_status->local_ip_address = proxy_get_local_ip_address (port_number) ;
      sptr_port_status->remote_ip_address = proxy_get_remote_ip_address (port_number) ;
      sptr_port_status->subnet_mask = proxy_get_subnet_mask (port_number) ;
      sptr_port_status->status = get_port_status (port_number) ;
      sptr_port_status->baud_rate = get_baud_rate (port_number) ;
      get_modem_name (port_number, &sptr_port_status->modem_name[0], MDM_TYPE_LEN) ;
      get_modem_connect_message (port_number, &sptr_port_status->modem_report[0], 30) ;
      get_ppp_user_name (port_number, &sptr_port_status->user_name[0], 60) ;

      sptr_port_status->connection_up_time = get_connection_up_time (port_number) ;
      sptr_port_status->connection_tx_count = get_connection_tx_count (port_number) ;
      sptr_port_status->connection_rx_count = get_connection_rx_count (port_number) ;

      sptr_port_status->aggregate_tx_count = get_aggregate_tx_count (port_number) ;
      sptr_port_status->aggregate_rx_count = get_aggregate_rx_count (port_number) ;
      sptr_port_status->number_of_calls = get_number_of_calls (port_number) ;
      sptr_port_status->aggregate_connection_time = get_aggregate_connection_time (port_number) ;

      sptr_port_status->connection_tx_packet_count = get_connection_tx_packet_count (port_number) ;
      sptr_port_status->connection_rx_packet_count = get_connection_rx_packet_count (port_number) ;

      sptr_port_status->aggregate_tx_packet_count = get_aggregate_tx_packet_count (port_number) ;
      sptr_port_status->aggregate_rx_packet_count = get_aggregate_rx_packet_count (port_number) ;

      sptr_port_status++ ;
   }
}

#endif

