#ifndef _VTFTPSTR_H_
#define _VTFTPSTR_H_

#include <kstart.h>

typedef struct TFTP_TIMER_CLASS
{
	BYTE_ENUM (BOOLEAN)	timer_enabled ;
	ULONG                tick_counter ;
	ULONG             	clock_ticks_per_second ;
} TFTP_TIMER_CLASS ;

typedef struct TFTP_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN) printing_enabled ;
	BYTE_ENUM (BOOLEAN) init_printing_enabled ;
	BYTE_ENUM (BOOLEAN) trace_printing_enabled ;
} TFTP_PRINTF_CLASS ;

typedef struct TFTP_CLASS
{
	BYTE_ENUM (BOOLEAN)	enabled ;
	BYTE_ENUM (BOOLEAN)	socket_interface_enabled ;
	BYTE_ENUM (BOOLEAN)	socket_interface_initialized ;
	ULONG                application_id ;
	USHORT            	max_connections ;
	USHORT             	number_of_retransmissions ;
	USHORT            	timeout_period ; /* This is used as a starting value */
	TFTP_TIMER_CLASS  	timer_class ;
	TFTP_PRINTF_CLASS    print_class ;
} TFTP_CLASS ;

typedef USHORT OPCODE_TYPE ;

typedef struct READ_WRITE_REQUEST
{
	BYTE file_name_and_mode[MAX_FILE_NAME_AND_MODE] ;
} READ_WRITE_REQUEST ;

typedef struct READ_WRITE_DATA
{
	USHORT data_block_number ;
	BYTE data[512] ;
} READ_WRITE_DATA ;

typedef struct ACK_TYPE
{
	USHORT acked_block_number ;
} ACK_TYPE ;

typedef struct ERROR
{
	USHORT error_number ;
	BYTE error_message[MAX_ERROR_MESG_LENGTH] ;
} ERROR ;

typedef struct TFTP_PACKET
{
	OPCODE_TYPE opcode ;
	union
	{
		READ_WRITE_REQUEST read_write_request ;
		READ_WRITE_DATA read_write_data ;
		ACK_TYPE ack ;
		ERROR error ;
	} message_type ;
} TFTP_PACKET ;

typedef struct CONNETION_INFO
{
	BYTE in_use_flag ;			  /* Reset after the file transfer is complete or 
                                   the connection is aborted */
	int socket ;				     /* Socket descriptor corresponding to the 
                                   connection */
	USHORT current_state ;       /* Current state of the connection in the state machine */
	BYTE operation ;			     /* Read request or Write request */
	USHORT my_protocol_port ;	  /* protocol port */
	ULONG peer_ip_address ;      /* IP address of the client */
	USHORT peer_protocol_port ;  /* protocol port of the client process */
	USHORT sequence_number ;     /* Next block number to go/come */
	FILE_HANDLE *file_pointer ;  /* File pointer corresponding to the open file */
	enum TFTP_FILEIO_ERROR_CODE error_code ;
	BYTE *received_packet ;		  /* Pointer to the place where the packet can be received */
	BYTE *send_packet ;          /* Pointer to the packet that has just been sent         */
	int packet_length ;
	int smoothed_rtt;			     /* The current value of smoothed RTT */
	ULONG retransmission_timer ; /* Retransmission to take place on this timer dying out */
	int retry_count ;			     /* No. of retries already made */
	ULONG connection_abort_time ;/* when this timer dies down to zero, the connection is aborted */
} CONNECTION_INFO ;


/* TFTPSOCK.C */
enum TEST initialize_tftp_socket_interface (void) ;
int send_data_packet (ULONG destination_ip_address, int destination_port,
                      int socket, BYTE *info, ULONG length) ;
int receive_data (ULONG *source_ip_address, int *source_port, int socket,
                  BYTE *packet, int *packet_length) ;
int send_ack_packet(ULONG destination_ip_address, int destination_port,
                    int socket, ULONG sequence_number) ;
int send_error_packet(ULONG destination_ip_address, int destination_port,
                      int socket, BYTE *error_message, USHORT error_code) ;

/* TFTPSTMC.C */
extern int (*tftp_state_machine_handlers[])(int descriptor) ;
extern int nop_state_handler(int descriptor);
extern int listen_state_handler(int descriptor);
extern int send_data_state_handler(int descriptor);
extern int wait_for_ack_state_handler(int descriptor);
extern int retransmit_state_handler(int descriptor);
extern int wait_for_data_state_handler(int descriptor);
extern int send_ack_state_handler(int descriptor);
extern int abort_connection_state_handler(int descriptor);
extern int close_socket_state_handler(int descriptor);


/* TFTPTIMR.C */
extern void tftp_timer(void) ;
extern ULONG get_timer_marker() ;

/* TFTPUTIL.C */
extern int get_connect_descriptor(void) ;
extern void free_connect_descriptor(int) ;
extern USHORT get_free_port(void) ;
extern ULONG gethostid(void) ;
extern void calculate_crc_table(void) ;
extern void tftp_printf (enum TFTP_PRINTF_GROUPS printf_group, const char *bptr_format, ...) ;
extern void print_tftp_init_info (void) ;

/* TFTPINIT.C */
extern enum TEST register_tftp (void) ;
extern enum TEST tftp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1) ;

/* TFTPTRAP.C */
extern void tftp_lsl_trap_function (enum DEVICE_CONTROL_OPERATION control_command) ;

#endif
