/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\webdisp.h"

#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "flowcont.h"



void stop_processing_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{

DataTransferStatus_t *transfer_status;

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

operation_status->status = END_OPERATION ; 

transfer_status->end_of_processing = TRUE ; 

}



void InitStopProcessingOperation(OperationStatus_t *operation_status)
{

operation_status->do_operation = stop_processing_operation ; 
operation_status->handle = NULL ; 
operation_status->close_operation = NULL  ; 

}


void loop_processing_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{

DataTransferStatus_t *external_transfer_status;
DataTransferStatus_t *internal_transfer_status;

external_transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
internal_transfer_status = (DataTransferStatus_t *) operation_status->handle ; 

if (  operation_status->status == START_OPERATION )
  {
    InitDataTransferStatus(internal_transfer_status) ; 
  }


ContinueDataTransfer(internal_transfer_status, FALSE ); 

if (internal_transfer_status->end_of_processing)
  {
    operation_status->status = END_OPERATION ; 
  }
else
  {
    operation_status->status = IN_OPERATION ; 
  }
}

void InitLoopProcessingOperation(OperationStatus_t *operation_status,
			    DataTransferStatus_t *internal_transfer_status)
{

operation_status->do_operation =  loop_processing_operation ; 
operation_status->handle = internal_transfer_status  ; 
operation_status->close_operation =   GenericSimpleFreeState  ; 

}



typedef struct {
void (*function_to_call)(void *parameter, DataTransferStatus_t *) ; 
void *parameter ;  
} CallOneFunctionOperationState_t ; 


void call_function_operation(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
CallOneFunctionOperationState_t  *input_state ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = ( CallOneFunctionOperationState_t *) operation_status->handle ; 

operation_status->status = END_OPERATION ; 

(*input_state->function_to_call)(input_state->parameter, transfer_status) ; 


}

void InitCallOneFucntionOperation(OperationStatus_t *operation_status,
	   void (*function_to_call)(void *parameter, DataTransferStatus_t *),
				   void *parameter )
{

CallOneFunctionOperationState_t *state ; 

operation_status->do_operation =  call_function_operation ; 
operation_status->handle = state = 
              malloc(sizeof( CallOneFunctionOperationState_t ) ) ;  
state->function_to_call = function_to_call ; 
state->parameter = parameter ; 
operation_status->close_operation =   GenericSimpleFreeState  ; 
}










