/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "..\..\sysdep\src\tcprw.h" 
#include "..\..\sysdep\src\timezone.h" 
#include "..\..\htmlform\src\formpars.h"
#include "..\..\htmlform\src\multiprt.h"
#include "..\..\htmlform\src\initoper.h"
#include "readent.h"
#include "flowcont.h"
#include "streamw.h"
#include "apputil.h"
#include "strout.h"
#include "..\..\prochttp\src\formphas.h"
#include "compsum.h"

void InitBasicAuthorizationTest(Request_t *request)
{
char uri_user_name[100]; 
int user_name_length ; 
int unauthorized ; 
int i ; 

char *success_return_string =  
"<HEAD><TITLE>Correct user password!</TITLE></HEAD><BODY><H1>Correct.<P></BODY>" ;

get_unparsed_parts_of_uri(uri_user_name, 100, request ) ; 

printf( "uri_user_name = <%s>\n", uri_user_name );

user_name_length = strlen(uri_user_name) ; 

unauthorized = TRUE ;
if (request->params.authorization.scheme == BASIC_AUTHORIZATION )
  {
 	printf( "scheme == BASIC_AUTHORIZATION\n" );
    for(i = 0 ; i < user_name_length ; i++ )
      {
	if ( (uri_user_name[i] != request->params.authorization.user_name[i]) ||
	     (uri_user_name[i] != 
            request->params.authorization.password[user_name_length - 1 -i]) )
	  {
	    break ; 
	  }
      }
    if ( i == user_name_length)
      {
	if ( (request->params.authorization.password[user_name_length] == 0)
	    && (request->params.authorization.user_name[user_name_length] ==0) )
	  {
	    unauthorized = FALSE ; 
	  }
      }
  }


if (unauthorized)
  {
  	printf( "Call InitReturnUnauthorised\n" );
    InitReturnUnauthorized(request,  "Basic real=\"tests\" ", 
      "<HEAD><TITLE>401 Unauthorized</TITLE></HEAD><BODY>wrong user/password.<P></BODY>", 
			   FALSE) ; 
  }
else
  {
  	printf( "Call InitReturnBuffer\n" );
    InitReturnBuffer(request, success_return_string, 
		     strlen(success_return_string),  
		     HTML_CONTENT_TYPE, FALSE ) ; 
  }


printf( "Outtahere!\n" );
request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 


}


#define INPUT_SOCKET_BUF_SIZE 1024
typedef struct {
  char buffer[INPUT_SOCKET_BUF_SIZE] ; 
  /*** should dynamically allocate buffer ***/
  /** should rewrite all socket input ***/
  Socket_t socket; 
  int total_bytes_to_read ; 
  int bytes_read_so_far_in_buffer ; 
  int total_bytes_yet_to_read ; 
  int should_read_first_time_info ; 
  char *first_time_info ; 
  int first_time_info_length ; 
} SocketInputState_t ; 


typedef struct {
  int done ; 
  char *uri ; 
  int uri_length ; 
} GetMothodFieldsInputState_t ; 


void GetMethodFieldsInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
GetMothodFieldsInputState_t *input_state ; 

char *beginning_of_fields ; 

char *end_uri, *end_fields ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
input_state = ( GetMothodFieldsInputState_t *) operation_status->handle ; 

if (input_state->done )
  {
    transfer_status->end_of_processing = TRUE  ; 
    operation_status->status = END_OPERATION ; 
    return ; 
  }


end_uri = input_state->uri + input_state->uri_length ; 
beginning_of_fields = input_state->uri ; 
while ((beginning_of_fields < end_uri) &&
       (*beginning_of_fields != '?' ) &&
       (*beginning_of_fields != ' ' ) &&
       (*beginning_of_fields != '#' ) &&
       (*beginning_of_fields != '\r' ) &&
       (*beginning_of_fields != '\n' ) )
  {
    beginning_of_fields++ ; 
  }

if (*beginning_of_fields == '?')
  {
    beginning_of_fields++ ; 
    end_fields = beginning_of_fields;
    while ((end_fields < end_uri) &&
       (*end_fields != ' ' ) &&
       (*end_fields != '#' ) &&
       (*end_fields != '\r' ) &&
       (*end_fields != '\n' ) )
      {
	end_fields++ ; 
      }
    transfer_status->data_buffers[0] = beginning_of_fields ;
    transfer_status->buffer_sizes[0] = end_fields - beginning_of_fields ; 
    transfer_status->nof_buffers = 1 ; 
  }
else
  {
    transfer_status->data_buffers[0] = beginning_of_fields ;
    transfer_status->buffer_sizes[0] = 0 ; 
    transfer_status->nof_buffers = 1 ; 
  }
operation_status->status = END_OPERATION ; 
input_state->done = TRUE ; 
}


void SocketInput(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
SocketInputState_t *input_state ; 
int nof_bytes_read ; 

int bytes_to_read ; 
int client_closed_socket ; 
int error;

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = (SocketInputState_t *) operation_status->handle ; 

if (input_state->should_read_first_time_info )
  {
    input_state->should_read_first_time_info = FALSE ; 

    transfer_status->data_buffers[0] = input_state->first_time_info ; 
    transfer_status->buffer_sizes[0] = input_state->first_time_info_length ; 
    transfer_status->nof_buffers = 1 ; 

    operation_status->status = END_OPERATION ; 
    return ; 
  }





if (input_state->total_bytes_yet_to_read <= 0 )
  {
    transfer_status->end_of_processing = TRUE  ; 
    transfer_status->socket_should_be_closed = TRUE ; 
    operation_status->status = END_OPERATION ; 
    return ; 
  }



if (operation_status->status == START_OPERATION)
  {
    input_state->bytes_read_so_far_in_buffer = 0 ; 
  }

bytes_to_read =INPUT_SOCKET_BUF_SIZE -  
               input_state->bytes_read_so_far_in_buffer ;

if (bytes_to_read > input_state->total_bytes_yet_to_read)
  {
    bytes_to_read =  input_state->total_bytes_yet_to_read ; 
  }


#ifndef BLOCKING_IO_ONLY

read_available_data_from_socket(input_state->socket , 
       input_state->buffer + input_state->bytes_read_so_far_in_buffer , 
       bytes_to_read , &nof_bytes_read, &client_closed_socket, &error) ; 
#else

read_data_from_socket(input_state->socket , 
       input_state->buffer + input_state->bytes_read_so_far_in_buffer , 
       bytes_to_read , &nof_bytes_read, &client_closed_socket, &error) ; 

#endif


if ( (error != 0 ) || client_closed_socket )
  {
    transfer_status->end_of_processing = TRUE  ; 
    transfer_status->socket_should_be_closed = TRUE ; 
    operation_status->status = END_OPERATION ; 
    return ; 
  }


input_state->bytes_read_so_far_in_buffer += nof_bytes_read ; 
input_state->total_bytes_yet_to_read -= nof_bytes_read ; 


if (nof_bytes_read < bytes_to_read )
  {
    operation_status->status = IN_OPERATION ; 
    return ; 
  }


transfer_status->data_buffers[0] = input_state->buffer ; 
transfer_status->buffer_sizes[0] = input_state->bytes_read_so_far_in_buffer ; 
if (input_state->total_bytes_yet_to_read < 0 )
  {
    transfer_status->buffer_sizes[0] += input_state->total_bytes_yet_to_read;
  }


transfer_status->nof_buffers = 1 ; 

operation_status->status = END_OPERATION ; 
}


void  FreeSocketInput( OperationStatus_t *operation_status)
{
SocketInputState_t *input_state ; 

input_state = (SocketInputState_t *) operation_status->handle ; 

free(input_state) ; 
}

void InitRequestEntityInput(Request_t *request  , 
			 OperationStatus_t *operation_status)
{


/*SocketInputState_t *input_state ; */
GetMothodFieldsInputState_t *get_input_state ; 

if (request->params.method == POST_METHOD)
  {
    InitFixedSizeSocketInput(request  ,  request->params.content_length,
			     operation_status);
  }
else /*** GET method ****/
  {
    operation_status->handle = get_input_state = 
      malloc(sizeof( GetMothodFieldsInputState_t)) ; 

    get_input_state->uri = request->params.uri ; 
    get_input_state->uri_length = request->params.uri_length ; 

    get_input_state->done = FALSE ; 
    operation_status->do_operation = GetMethodFieldsInput ; 
    operation_status->close_operation = NULL; 
  }



}

void InitReturnEntityTest(Request_t *request)
{
DataTransferStatus_t *data_transfer ; 


request->header_info.status = STATUS_OK ; 
request->response_entity_function = DataTransfer ; 


if (request->params.content_length == NO_CONTENT_LENGTH) 
  {
    InitReturnNotFound(request,   "No Content Length", FALSE ) ; 
  }
else 
  {
    request->response_entity_handle = data_transfer =
      malloc(sizeof(DataTransferStatus_t) ) ; 


    InitDataTransferStatus(data_transfer) ; 

    data_transfer->nof_operations = 2 ; 
    InitRequestEntityInput(request ,  &data_transfer->io_operations[0] ) ;
    InitNonBlockingOutput( request, &data_transfer->io_operations[1] ) ;
    data_transfer->end_of_processing = FALSE ; 
    data_transfer->socket_should_be_closed = FALSE ; 
  }

request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
}


void InitReturnSimpleStringTest(Request_t *request)
{

/*char *return_string =  "This test passed successfully" ; */
	char *return_string = 
	"<h1>MR4800E Controller Card</h1><hr>Operations avaiable:<ul><li>Reset Modem"
	"<li>Set Modem OOS<li>Put Modem In Service</ul>";


InitReturnBuffer(request, return_string, strlen(return_string),  
		 HTML_CONTENT_TYPE, FALSE ) ; 



}

void InitReturnTimeTest(Request_t *request)
{

char temp_buffer[200]; 
HttpDate_t current_date ; 

get_current_date(&current_date) ; 
sprintf(temp_buffer , 
"Current time and date: year: %d month %d day %d hour %d minute %d second %d diff from GMT hour %d minute %d ",
 current_date.year, current_date.month, current_date.day , 
 current_date.hour, current_date.minute, current_date.second,
   hours_diff_from_gmt, minutes_diff_from_gmt   )  ; 


InitReturnBuffer(request, temp_buffer, strlen(temp_buffer), 
		 HTML_CONTENT_TYPE, TRUE ) ; 

}

void InitRefreshedReturnTimeTest(Request_t *request)
{

char temp_buffer[200]; 
HttpDate_t current_date ; 

get_current_date(&current_date) ; 
sprintf(temp_buffer , 
"Current time and date: year: %d month %d day %d hour %d minute %d second %d diff from GMT hour %d minute %d ",
 current_date.year, current_date.month, current_date.day , 
 current_date.hour, current_date.minute, current_date.second,
   hours_diff_from_gmt, minutes_diff_from_gmt   )  ; 


SetClientPull(request, 10, NULL ) ; 

InitReturnBuffer(request, temp_buffer, strlen(temp_buffer), 
		 HTML_CONTENT_TYPE, TRUE ) ; 

}







typedef struct {
  char output_buffer[2*INPUT_SOCKET_BUF_SIZE]; 
  char header[200] ; 
} FormFieldFormatState_t ; 


void TestFormFieldFormat(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
FormFieldFormatState_t *input_state ; 

char input_data[INPUT_SOCKET_BUF_SIZE] ; 
char parse_results[INPUT_SOCKET_BUF_SIZE]; 
char *field_names[100], *field_values[100]; 
int nof_fields ; 

int i_buf; 
int input_size ; 
int i_field ; 
char *pos_in_output ; 
int total_output_length ; 
int string_length ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 

input_state = (FormFieldFormatState_t *) operation_status->handle ; 

input_size = 0 ; 
for(i_buf = 0 ; i_buf < transfer_status->nof_buffers ; i_buf ++ )
  {
    memcpy(input_data+input_size, transfer_status->data_buffers[i_buf],
	   (size_t)transfer_status->buffer_sizes[i_buf] ) ;
    input_size +=    transfer_status->buffer_sizes[i_buf] ; 
  }


parse_form_fields(input_data, input_size, parse_results, 
		 INPUT_SOCKET_BUF_SIZE , field_names, field_values, 
		 &nof_fields ) ; 


transfer_status->nof_buffers = 0 ; 

sprintf(input_state->header, "unpased and parsed input, note that if data is more then %d bytes there mught be wrong parsing because of buffering<p>", 
	INPUT_SOCKET_BUF_SIZE ) ; 

AddStringBuffer(transfer_status, input_state->header) ; 


pos_in_output = input_state->output_buffer ; 
total_output_length = 0 ; 
for(i_field = 0 ; i_field < nof_fields ; i_field++ )
  {
    sprintf(pos_in_output, "name=%s[end name] value=%s[end value<p>\n", 
	    field_names[i_field], field_values[i_field] ) ; 
    string_length = strlen(pos_in_output) ; 
    pos_in_output += string_length ; 
    total_output_length += string_length ; 
  }

AddBuffer( transfer_status, input_state->output_buffer, 
	  total_output_length);



operation_status->status = END_OPERATION ; 

}

void  FreeFormFieldFormat( OperationStatus_t *operation_status)
{
FormFieldFormatState_t *input_state ; 

input_state = (FormFieldFormatState_t *) operation_status->handle ; 
free(input_state) ; 
}

void InitFormFieldsFormat( OperationStatus_t *operation_status) 
{
FormFieldFormatState_t *input_state ; 

operation_status->do_operation = TestFormFieldFormat ; 
operation_status->handle = input_state = 
              malloc(sizeof(FormFieldFormatState_t)) ; 

operation_status->close_operation = FreeFormFieldFormat ; 
}





void InitReturnParsedEntityTest(Request_t *request)
{
DataTransferStatus_t *data_transfer ; 


request->header_info.status = STATUS_OK ; 
request->header_info.content_type = HTML_CONTENT_TYPE ; 

request->response_entity_function = DataTransfer ; 




if ( (request->params.content_length == NO_CONTENT_LENGTH) &&
     (request->params.method == PUT_METHOD) )
  {
    InitReturnNotFound(request,  "Put method with No Content Length" , FALSE ) ; 
  }
else 
  {
    request->response_entity_handle = data_transfer =
      malloc(sizeof(DataTransferStatus_t) ) ; 


    InitDataTransferStatus(data_transfer) ; 

    data_transfer->nof_operations = 3 ; 
    InitRequestEntityInput(request ,  &data_transfer->io_operations[0] ) ;
    InitFormFieldsFormat( &data_transfer->io_operations[1] ) ;
    InitNonBlockingOutput( request, &data_transfer->io_operations[2] ) ;
    data_transfer->end_of_processing = FALSE ; 
    data_transfer->socket_should_be_closed = FALSE ; 
  }

request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
}
/*
					Unwanted portion of the code commented out

#include "ex.h"

void InitParseFormEx7(Request_t *request)
{
char tmp_output[1000];
EX_form_output_type *pizza_data ; 


pizza_data = (EX_form_output_type *)form_data_of_request(request ) ; 

sprintf( tmp_output,  " address %s phone %s pepproni %d sas %d anch %d payment %d call %d ", 
        pizza_data->address , 
	pizza_data->phone,
	pizza_data->topping[EX_topping_pepperoni], 
	pizza_data->topping[EX_topping_sausage ], 
	pizza_data->topping[EX_topping_anchovies], 
	pizza_data->paymethod,
	pizza_data->callfirst ) ; 




InitReturnBuffer(request, tmp_output , strlen(tmp_output), 
		 HTML_CONTENT_TYPE, TRUE ) ; 



}


#include "filesend.h"


void simple_fn_factory(char *file_name, char *field_name, 
                      void *param, UploadedFile_t *uploaded_file )
{
static counter = 0 ; 
strcpy(uploaded_file->original_file_name, file_name ) ; 

sprintf(uploaded_file->local_file_name, "uploads/%s.%d", field_name, counter);

counter++ ; 


}

void InitBasicUpload(Request_t *request ,void *operation_handle)
{
OperationStatus_t *upload_operation ; 

upload_operation = (OperationStatus_t *) operation_handle ; 

InitWriteStreamToFiles(upload_operation,
			   simple_fn_factory, NULL ) ;

}



void InitFileUploadTest(Request_t *request)
{
char char_buffer[300] ; 


FILESEND_form_output_type *uploaded_data;

uploaded_data = (FILESEND_form_output_type *)form_data_of_request(request ) ;

sprintf( char_buffer, " subject %s format %d file pointer address %p local fn %s orig fn %s", 
	uploaded_data->subject , 
	uploaded_data->fileformat , 
	uploaded_data->srcfile,
	(( UploadedFile_t *)(uploaded_data->srcfile))->
                       local_file_name, 
	(( UploadedFile_t *)(uploaded_data->srcfile))->
                       original_file_name);
 


InitReturnBuffer(request, char_buffer , strlen(char_buffer), 
		 HTML_CONTENT_TYPE, TRUE ) ; 

}


#include "filetest.h"

void InitFileTest(Request_t *request)
{

char tmp1[300], tmp2[300], tmp3[300] ; 

char char_buffer[1000] ; 


FILETEST_form_output_type *uploaded_data;

uploaded_data = (FILETEST_form_output_type *)form_data_of_request(request ) ;

get_checksum_test_string(tmp1,  uploaded_data->srcfile1) ; 
get_checksum_test_string(tmp2,  uploaded_data->srcfile2) ; 
get_checksum_test_string(tmp3,  uploaded_data->srcfile3) ; 



sprintf( char_buffer, "One of many options: %d<BR>Many of Many options: %d %d %d<BR>Text field %s<BR>%s<BR>%s<BR>%s<BR>",
	 uploaded_data->f1+1,
	 uploaded_data->f2[0],  uploaded_data->f2[1],uploaded_data->f2[2],
	 uploaded_data->text,
	 tmp1, tmp2, tmp3 ) ; 

InitReturnBuffer(request, char_buffer , strlen(char_buffer), 
		 HTML_CONTENT_TYPE, TRUE ) ; 


deallocate_checksum_results(uploaded_data->srcfile1) ; 
deallocate_checksum_results(uploaded_data->srcfile2) ; 
deallocate_checksum_results(uploaded_data->srcfile3) ; 


}







void *InitReturnParamsHandle(Request_t *request);

void InitReturnParams(Request_t *request)
{
request->header_info.status = STATUS_OK ; 
request->response_entity_function = DataTransfer ; 
request->response_entity_handle = InitReturnParamsHandle(request) ; 
request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 
}


#include "exam7.h"


void InitExample7(Request_t *request)
{
InitCompiledBuffRequest(request , & EX7_compiled_buffer ) ; 
}



#include "testform.h"


void GetFileTestForm(Request_t *request)
{
InitCompiledBuffRequest(request , & FILE_TEST_FORM_compiled_buffer ) ; 
}


*/



