/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"

#include "..\..\htmlform\src\formpars.h"

int hex_to_number[256] ; 

void init_hex_to_number()
{
int i ; 

for(i = 0 ; i < 256 ; i++)
  {
    hex_to_number[i] = 0 ; 
  }

for(i = 0 ; i < 10 ; i++ )
  {
    hex_to_number['0'+i] = i ; 
  }

for(i = 0 ; i < 6 ; i++)
  {
    hex_to_number['A' + i ] = i + 10 ; 
    hex_to_number['a' + i ] = i + 10 ; 
  }
}


#define HEX_DIG_VALUE(c) hex_to_number[(int)(c)] ; 

char hex_to_char(char *hex_string)
{
int dig1, dig2 ; 

dig1 = HEX_DIG_VALUE( hex_string[0] ) ; 
dig2 = HEX_DIG_VALUE( hex_string[1] ) ; 


return (char) ( 16*dig1 + dig2 ) ; 
}


void copy_field(char **pos_in_input_param, 
		char *end_of_input, 
		char **pos_in_output_param, 
		char *end_of_output, 
		char delimiter ) 
{
char *pos_in_input , *pos_in_output ; 


pos_in_input = *pos_in_input_param; 
pos_in_output = *pos_in_output_param; 

while ((*pos_in_input != delimiter) &&
       (pos_in_input < end_of_input) )
  {
    switch( *pos_in_input )
      {
      case '+': { *pos_in_output = ' ' ; 
		  pos_in_output++ ; 
		  pos_in_input++ ; 
		  break ; 
		}
      case '%': { *pos_in_output = hex_to_char(pos_in_input + 1) ; 
		  pos_in_output++ ; 
		  pos_in_input += 3 ; 
		  break ; 
		}
      default: { *pos_in_output = *pos_in_input ; 
		 pos_in_output++ ; 
		  pos_in_input++ ; 
		  break ; 
		}
      }
  }

*pos_in_output = 0 ; 
pos_in_output++ ; 

if (pos_in_input < end_of_input)
  {
    pos_in_input++ ; 
  }

*pos_in_input_param  = pos_in_input ; 
*pos_in_output_param  = pos_in_output ; 

}



void parse_form_fields(char *input_data , 
		      int data_length, 
		      char *output_buffer, 
		      int output_buffer_length, 
		      char **field_names, 
		      char **field_values , 
		      int *nof_fields )
{
char *pos_in_input, *pos_in_output ; 
char *end_of_input, *end_of_output ; 

*nof_fields = 0 ; 
pos_in_input =  input_data ; 
pos_in_output = output_buffer ; 

end_of_input = input_data + data_length ; 
end_of_output = output_buffer + output_buffer_length ; 


while( TRUE )
  {
    field_names[*nof_fields] = pos_in_output ; 
    copy_field(&pos_in_input, end_of_input, &pos_in_output, end_of_output, 
	       '=' ) ; 


    field_values[*nof_fields] = pos_in_output ; 
    copy_field(&pos_in_input, end_of_input, &pos_in_output, end_of_output, 
	       '&' ) ; 


    (*nof_fields)++ ; 
    
    if (pos_in_input >= end_of_input)
      {
	return ; 
      }
  }


}

char *address_of_field(ParseHtmlFieldDescription_t *field_description,
			   HtmlOutputFields_t *html_output_fields)
{
return ( (char *)html_output_fields->form_data_struct_ptr ) +
       field_description->address_offset_of_field ; 
}


void init_field_desciption( ParseHtmlFieldDescription_t *field_description,
			   HtmlOutputFields_t *html_output_fields)
{
int i_field_val ; 

char *field_address ; 

field_address = address_of_field(field_description, html_output_fields);


switch (field_description->field_type) {
 case HTML_TEXT_FIELD: { 
   * ( (char **)field_address ) = NULL ; 
   break ; 
 }
 case HTML_BOOLEAN_FIELD: { 
   *( (int *) field_address ) = FALSE ; 
   break ; 
 }
 case HTML_ONE_OF_MANY_FIELD: { 
   *( (int *) field_address ) = HTML_FIELD_VALUE_WAS_NOT_SENT ; 
   break ; 
 }
 case HTML_MANY_OF_MANY_FIELD: { 
   for(i_field_val  = 0  ; 
       i_field_val <   field_description->values_dictionary->nof_words ; 
       i_field_val++ )
     {
       ( (int *) field_address )[i_field_val] = FALSE ; 
     }
   break ; 
 }
 case HTML_IMAGE_POINT_FIELD: { 
    ( (HtmlImageCoordinate_t *)  field_address )->was_clicked = FALSE ;
   break ; 
 }

 case HTML_STREAM_FIELD: { 
   * ( (void **)field_address ) = NULL ; 
   break ; 
 }

 }

}


int coordinate_image_field(char *field_name, int field_name_length)
{
char last_char ; 

if (field_name_length <= 2 )
  {
    return FALSE ; 
  }

if (field_name[field_name_length-2] != '.' ) 
  {
    return FALSE ; 
  }
    
last_char = field_name[field_name_length-1];


return ((last_char == 'x' ) || 
	(last_char == 'X' ) || 
	(last_char == 'y' ) || 
	(last_char == 'Y' ) ); 
}



void init_all_form_fields(
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields)
{
int i_field ; 
for (i_field = 0 ; i_field < html_form_description->nof_fields ; i_field++)
  {
    init_field_desciption( 
	&html_form_description->parse_html_field_description[i_field],
	html_output_fields);
  }
html_output_fields->nof_chars_used_in_text_buffer = 0 ; 
}


void update_html_field(
		       char *field_name,  
		       int field_name_length,
		       char *field_value ,  
		       int field_value_length,
		       HtmlFormDesc_t *html_form_description, 
		       HtmlOutputFields_t *html_output_fields)
{
ParseHtmlFieldDescription_t *input_field ; 
int field_index ; 
int value_index ; 

char *field_address ; 

char *text_field ; 
HtmlImageCoordinate_t *coordinate_data ; 

/*HTTP_TRACE("forms", sprintf(tmp_trace, "name = %*.*s val= %*.*s",
 			1, field_name_length,    field_name, 1, field_value_length , field_value)  ) ; */


field_index = find_word_case_insensitive(field_name , 
					 field_name_length,
					 &html_form_description->field_names );

    
if (field_index != NOT_FOUND_IN_WORD_LIST)
  {
    input_field = &html_form_description->
               parse_html_field_description[field_index] ; 



    field_address = address_of_field(input_field , html_output_fields);

    switch( input_field->field_type ) 
	{
	case HTML_TEXT_FIELD: {
	  text_field = html_output_fields->text_buffer + 
                     html_output_fields->nof_chars_used_in_text_buffer;


	  * ( (char **)field_address ) = text_field ; 

	  memcpy(text_field, field_value, (size_t)field_value_length ) ; 
	  text_field[ field_value_length ] = 0 ; 

	  html_output_fields->nof_chars_used_in_text_buffer += 
	    ( field_value_length + 1 ) ; 
	  break ; 
	}

	case  HTML_BOOLEAN_FIELD: { 
	   *( (int *) field_address ) = TRUE ; 
	  /*** actual value does not matter.
	   **** the apearance of the name means the result shoudl 
	   **** be true 
	   ***/
	  break ; 
	}
	case HTML_ONE_OF_MANY_FIELD: {
	
	  value_index = find_word_case_sensitive
	          (field_value, 
		   field_value_length, 
		   input_field->values_dictionary) ; 
	  if (value_index != NOT_FOUND_IN_WORD_LIST )
	    {
	      *( (int *) field_address ) =  value_index ; 
	    }
	  else
	    {
	      HTTP_REPORT_ERROR(" invalid value for one of many field ") ; 
	    }
	  break ; 
	}
	case HTML_MANY_OF_MANY_FIELD: {

	  value_index = find_word_case_sensitive(field_value, 
		      field_value_length ,
		      input_field->values_dictionary);
	  if (value_index != NOT_FOUND_IN_WORD_LIST )
	    {
	      ( (int *) field_address )[ value_index ] = TRUE;
	    }
	  else
	    {
	      HTTP_REPORT_ERROR(" invalid value for many of many field ") ; 
	    }
	  break ; 
	}
	case HTML_IMAGE_POINT_FIELD:
	  {
	    HTTP_REPORT_ERROR(" image field without .x or .y ?") ;
	    break ;
	  }
	case HTML_STREAM_FIELD:
	  {
	    HTTP_REPORT_ERROR(" Stream uplaod in url encoding? ") ;
	    break ;
	  }
	}
    }
  else
    {
      /*** maybe image .x or .y field ? ******/
      if (coordinate_image_field(field_name, field_name_length) )
	{
	  field_index = find_word_case_insensitive( field_name , 
			   field_name_length - 2 ,
			   &html_form_description->field_names ) ; 
	  if (field_index != NOT_FOUND_IN_WORD_LIST )
	    {
	      input_field = &html_form_description->
		parse_html_field_description[field_index] ; 
	      if (input_field->field_type ==  HTML_IMAGE_POINT_FIELD )
		{
		  coordinate_data = (HtmlImageCoordinate_t *)  field_address ;

		  if ((field_name[field_name_length-1] == 'x' ) || 
		      (field_name[field_name_length-1] == 'X' ) )
		    {
		      coordinate_data->x = atoi(field_value) ; 
		    }
		  else		/*** y coordinate ***/
		    {
		      coordinate_data->y = atoi(field_value) ; 
		    }
		  coordinate_data->was_clicked = TRUE ; 
		}
	      else
		{
		  HTTP_REPORT_ERROR(".x or .y field is not an image one") ; 

		}
	    }
	  else
	    {
	      HTTP_REPORT_ERROR("Image Field Name was not found!") ; 
	    }
	}
      else
	{
	  HTTP_REPORT_ERROR("Field Name was not found!") ; 
	}
    }



}






void analyze_url_encoded_form_fields(char *input_data, 
			int input_length , 
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields)
{
char field_name[MAX_FIELD_NAME], field_value[MAX_FIELD_VALUE];
char *pos_in_input, *end_of_input;
char *field_name_begin, *field_name_end ; 
char *value_start_buf, *value_end_buf ; 
char *pos_in_text_buffer , *end_text_buffer ; 



int field_name_length ; 


init_all_form_fields(html_form_description, 
		     html_output_fields);


pos_in_input = input_data ; 
end_of_input = input_data + input_length ; 

pos_in_text_buffer = html_output_fields->text_buffer ; 
end_text_buffer = html_output_fields->text_buffer + 
                      html_output_fields->text_buffer_size; 



while (TRUE)
  {
    field_name_begin = field_name ; 
    field_name_end = field_name + MAX_FIELD_NAME ; 
    copy_field(&pos_in_input, end_of_input, 
	       &field_name_begin, field_name_end, 
	       '=' ) ; 
    
    field_name_length =  strlen(field_name) ;


    value_start_buf = field_value ; 
    value_end_buf = field_value + MAX_FIELD_VALUE;
    copy_field(&pos_in_input, end_of_input, 
	       &value_start_buf , value_end_buf , 
	       '&' ) ; 

    update_html_field(field_name,  field_name_length,
		      field_value ,  strlen(field_value),
		      html_form_description, 
		      html_output_fields);


    if (pos_in_input >= end_of_input)
      {
	return ; 
      }
  }

}
			
			
void InitHtmlOutputs(HtmlOutputFields_t *html_outputs,
		     HtmlFormDesc_t *form_description, 
		     void *form_data_base_address , 
		     char *text_buffer,  
		     int size_of_text_buffer ) 
{

html_outputs->text_buffer = text_buffer ; 
html_outputs->text_buffer_size =  size_of_text_buffer ; 
html_outputs->form_data_struct_ptr = form_data_base_address ;
html_outputs->form_description = form_description ; 

}


#ifndef ALLOCATED_SPACE_PER_TEXT_FIELD
#define ALLOCATED_SPACE_PER_TEXT_FIELD 512
#endif

int compute_text_buffer_size 
             ( HtmlFormDesc_t *form_description,
               int content_length ) 
{
int buffer_size ; 
int i_field ; 
int exist_upload_fileds ; 
ParseHtmlFieldDescription_t *current_field ; 

buffer_size = 0 ; 
exist_upload_fileds = FALSE ; 
for(i_field = 0 ; i_field < form_description->nof_fields ; i_field++)
  {
    current_field = &form_description->parse_html_field_description[i_field];
    
    if (current_field->field_type == HTML_STREAM_FIELD)
      {
	exist_upload_fileds = TRUE ; 
      }

    if (current_field->field_type == HTML_TEXT_FIELD )
      {
	buffer_size += ALLOCATED_SPACE_PER_TEXT_FIELD ; 
      }

  }

if (!exist_upload_fileds)
  {
    buffer_size = content_length ; 
  }


return buffer_size ; 


}


