/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\prochttp\src\util.h"
#include "..\..\prochttp\src\datatran.h"
#include "formpars.h"
#include "multiprt.h"
#include "..\..\genapps\src\apputil.h"
#include "..\..\genapps\src\flowcont.h"
#include "..\..\genapps\src\readent.h"
#include "initoper.h"


typedef struct {
HtmlFormDesc_t *form_description ;
HtmlOutputFields_t *output_fields ;
} UrlEncodedFromProcessingState_t ; 


void DoUrlFromProcessing(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
UrlEncodedFromProcessingState_t *state ; 

char *input_data ; 
int input_data_size ; 
int i_buffer ; 
int curr_char ; 
int input_data_was_allocated ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
state = (UrlEncodedFromProcessingState_t *) operation_status->handle ; 


if (transfer_status->nof_buffers == 1 )
  {
    input_data = transfer_status->data_buffers[0] ; 
    input_data_size = transfer_status->buffer_sizes[0] ; 
    input_data_was_allocated = 0 ; 
  }
else
  {
    input_data_size = 0 ; 
    for(i_buffer = 0 ; i_buffer < transfer_status->nof_buffers;
	i_buffer++)
      {
	input_data_size +=  transfer_status->buffer_sizes[i_buffer];
      }
    input_data = malloc(input_data_size ) ; 

    curr_char = 0 ; 
    for(i_buffer = 0 ; i_buffer < transfer_status->nof_buffers ; i_buffer++ )
      {
	memcpy(input_data+curr_char, transfer_status->data_buffers[i_buffer],
	   (size_t)transfer_status->buffer_sizes[i_buffer] ) ;
	curr_char += transfer_status->buffer_sizes[i_buffer] ; 
      }
    input_data_was_allocated =1 ; 
  }




analyze_url_encoded_form_fields(
                    input_data, input_data_size , state->form_description,
		    state->output_fields ); 

if(input_data_was_allocated )
  {
    free(input_data) ; 
  }

operation_status->status = END_OPERATION ; 

}


void InitUrlEncodedFormProcessing(OperationStatus_t *operation_status , 
	       HtmlFormDesc_t *form_description, 
	       HtmlOutputFields_t *output_fields)
{

UrlEncodedFromProcessingState_t *state ; 


operation_status->handle = state = 
  malloc(sizeof( UrlEncodedFromProcessingState_t) ) ; 

state->form_description = form_description  ; 
state->output_fields = output_fields ; 

operation_status->do_operation = DoUrlFromProcessing ; 

operation_status->close_operation =   GenericSimpleFreeState ; 

}

 


void InitRequestEntityInput(Request_t *request  , 
			 OperationStatus_t *operation_status);


#define MULTIPART_BUFFER_LENGTH 4096


void InitInputFromFormOperation
              (OperationStatus_t *operation_status , 
	       HtmlFormDesc_t *form_description, 
	       HtmlOutputFields_t *output_fields,
	       Request_t *request)
{
DataTransferStatus_t *loop_data_transfer ; 


loop_data_transfer = get_initialized_data_transfer();

if ( (request->params.content_type == CONTENT_TYPE_URL_ENCODE)  ||
     (request->params.content_type == NO_CONTENT_TYPE) )
  {
    loop_data_transfer->nof_operations = 3 ; 
    
    InitRequestEntityInput(request ,  &loop_data_transfer->io_operations[0]);
    InitUrlEncodedFormProcessing(  &loop_data_transfer->io_operations[1],
			  form_description, output_fields ) ; 
    InitStopProcessingOperation( &loop_data_transfer->io_operations[2] ) ; 
  }
else /**** MULTIPART encoded form ***/
  {
    loop_data_transfer->nof_operations = 2 ; 
    InitContinuousSocketInput(request , MULTIPART_BUFFER_LENGTH, 
			      &loop_data_transfer->io_operations[0] ) ;
    InitProcMultiPartParse(request,  MULTIPART_BUFFER_LENGTH + 4096 , 
			   form_description,
		           output_fields  ,   
			   &loop_data_transfer->io_operations[1]);
  }


InitLoopProcessingOperation(operation_status, loop_data_transfer ) ; 
}

                
void InitInputFromFormOperationWithUploads
              (OperationStatus_t *operation_status , 
	       HtmlFormDesc_t *form_description, 
	       HtmlOutputFields_t *output_fields,
	       Request_t *request,
	       OperationStatus_t **upload_operation)
{
DataTransferStatus_t *loop_data_transfer ; 


loop_data_transfer = get_initialized_data_transfer();

if ( (request->params.content_type == CONTENT_TYPE_URL_ENCODE)  ||
     (request->params.content_type == NO_CONTENT_TYPE) )
  {
    HTTP_REPORT_ERROR("upload on non-multipart encoding") ; 
  }
else /**** MULTIPART encoded form ***/
  {
    loop_data_transfer->nof_operations = 3 ; 
    InitContinuousSocketInput(request , MULTIPART_BUFFER_LENGTH, 
			      &loop_data_transfer->io_operations[0] ) ;
    InitProcMultiPartParse(request,  MULTIPART_BUFFER_LENGTH + 4096 , 
			   form_description,
		           output_fields  ,   
			   &loop_data_transfer->io_operations[1]);
    
    *upload_operation = &loop_data_transfer->io_operations[2] ; 
  }


InitLoopProcessingOperation(operation_status, loop_data_transfer ) ; 
}

typedef struct {
char *input_text_buffer ; 
char *output_buffer ; 
HtmlFormDesc_t *form_description ; 
HtmlOutputFields_t html_outputs ; 
void *form_data ; 
void (*process_form)(void *form_data, char *output_buffer, 
		     int *output_buffer_size )  ;
} ProcessFormState_t ; 

void DoFormProcessing(void /***DataTransferStatus_t**/ 
			                 *transfer_status_input , 
			  OperationStatus_t *operation_status)
{
DataTransferStatus_t *transfer_status; 
ProcessFormState_t *state ; 
int output_buffer_size ; 

transfer_status = (DataTransferStatus_t *)transfer_status_input ; 
state = ( ProcessFormState_t *) operation_status->handle ; 


(*state->process_form)(state->form_data, state->output_buffer, 
		       &output_buffer_size) ; 


transfer_status->nof_buffers = 1 ; 
transfer_status->data_buffers[0] =  state->output_buffer;
transfer_status->buffer_sizes[0] = output_buffer_size ; 

operation_status->status = END_OPERATION ; 
}



void   FreeFromProcessing( OperationStatus_t *operation_status)
{
ProcessFormState_t *state ; 

state = (ProcessFormState_t *)  operation_status->handle ; 

free(state->input_text_buffer);
free(state->output_buffer);
free(state->form_data) ; 
}

void InitFormatDataOperation(OperationStatus_t *operation_status , 
			HtmlFormDesc_t *form_description, 
			int max_size_of_text_input_data, 
			int max_size_of_output_data, 
		 void (*process_form)(void *form_data, char *output_buffer, 
				      int *output_buffer_size ) )
{
ProcessFormState_t *state ; 

operation_status->handle = state = malloc(sizeof(ProcessFormState_t) ) ; 


state->input_text_buffer = malloc(  max_size_of_text_input_data ) ; 
state->output_buffer = malloc(max_size_of_output_data );
state->form_description = form_description ; 
state->form_data=malloc(form_description->struct_size);
InitHtmlOutputs(&state->html_outputs , form_description, 
		state->form_data, 
		state->input_text_buffer,  max_size_of_text_input_data ) ; 


state->process_form = process_form ; 

operation_status->do_operation = DoFormProcessing ; 

operation_status->close_operation = FreeFromProcessing ; 


}

                


void InitFormProcessingRequest
              (Request_t *request, 
	       HtmlFormDesc_t *form_description, 
	       int max_size_of_text_input_data, 
	       int max_size_of_output_data, 
	       HttpContentType_t content_type , 
	       void (*process_form)(void *form_data, char *output_buffer, 
				    int *output_buffer_size ) ) 
{
DataTransferStatus_t *data_transfer ; 
ProcessFormState_t *format_data;

request->header_info.status = STATUS_OK ; 

request->header_info.content_type =  content_type;

request->response_entity_function = OneIterationDataTransfer ; 

request->response_entity_handle = data_transfer =
      get_initialized_data_transfer() ; 




data_transfer->nof_operations = 3 ; 

InitFormatDataOperation(&data_transfer->io_operations[1],
			form_description, 
			max_size_of_text_input_data, 
			max_size_of_output_data,
			process_form ) ; 

format_data = (ProcessFormState_t *) data_transfer->io_operations[1].handle ; 

InitInputFromFormOperation(&data_transfer->io_operations[0],
			   form_description, 
			    &format_data->html_outputs,
			   request );

InitNonBlockingOutput( request, &data_transfer->io_operations[2] ) ;


request->status.process_status =  IN_SEND_RESPONSE_HEADER ; 



}

		 



