/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef MULTIPRT_H
#define MULTIPRT_H

#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\strfind.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\datatran.h"
#include "..\..\htmlform\src\streamfl.h"
#define MAX_BOUNDARY_SIZE 1024 
#define MAX_FILES_IN_FORM 10 

typedef struct {
enum { MULTIPART_BEFORE_FIRST_BOUNDARY,
       MULTIPART_READING, 
       MULTIPART_JUST_AFTER_BOUNDARY, 
       MULTIPART_AFTER_BOUNDARY_ONE_HYPHEN, 
       MULTIPART_AFTER_LAST  } 
       state ; 
enum { INPART_MIME_HEADER, 
       INPART_MIME_HEADER_AFTER_CR, 
       INPART_MIME_HEADER_AFTER_CR_LF, 
       INPART_MIME_HEADER_AFTER_CR_LF_CR, 
       INPART_BODY } within_part_state ; 
char mime_header[2048] ; 
int nof_chars_in_mime_header ; 
char field_value_buffer[MAX_FIELD_VALUE] ; 
int nof_chars_in_field_value_buffer ; 
char field_name[MAX_FIELD_NAME] ; 
int field_name_index ; 
char upload_file_name[MAX_UPLOAD_FILE_NAME] ; 
StringSearch_t boundary_with_endline_string_search ; 
StringSearch_t boundary_string_search ; 
int position_in_boundary_string ; 
int done ; 
int nof_bytes_yet_to_read ; 
int stream_buffer_size ; 
char *stream_buffer ; 
int beginning_of_current_stream ; 
int nof_chars_in_stream_buffer ; 
int current_field_is_stream ; 
HtmlFormDesc_t *html_form_description ; /*** need to know is a field is stream
                                        **** or not ***/
HtmlOutputFields_t *html_output_fields; /*** to get the stream handle ***/

OutputStreamMessage_t stream_field_messages[MAX_FILES_IN_FORM*3] ; 
int nof_stream_field_messages ; 

}    MultipartAnalyzeState_t ; 

void InitProcMultiPartParse(Request_t *request, 
			    int stream_buffer_size, 
			    HtmlFormDesc_t *html_form_description, 
			    HtmlOutputFields_t *html_output_fields,
			    OperationStatus_t *operation_status
			    );

void analyze_multipart_encoded_form_fields(
                        DataTransferStatus_t *input_data, 
                        MultipartAnalyzeState_t *multipart_state, 
			HtmlFormDesc_t *html_form_description, 
			HtmlOutputFields_t *html_output_fields);


#endif /** MULTIPRT_H **/

