#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"


#include "adipxflt.h"
#include "editipxf.h"
#include "vedipxfl.h"
#include "setdfipa.h"
#include "ipxfilt.h"
#include "setdfipp.h"
#include "setdfipx.h"
#include "setdfstp.h"

#include "edipxffm.h"
#include "addiffm.h"
#include "setdfafm.h"
#include "setdfpfm.h"
#include "setdfifm.h"
#include "setdfsfm.h"


#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"








/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
/*...Extern Decleration*/

/* Local ProtoType ...*/
void display_the_ipx_filter_for_editing(Request_t* request, STRUCT_IPX_FILTER* ipx_filter);
void display_ten_ipx_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page);
void display_prev_ipx_filters(Request_t* request);
void display_next_ten_ipx_filters(Request_t* request);
/*void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node);*/
USHORT modify_the_ipx_template(BYTE* buffer, STRUCT_IPX_FILTER* ipx_filter, USHORT search_to_start_at);
USHORT get_the_number_of_ipx_filters();
void change_the_edited_ipx_filters(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_ipx_filter_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_to_ipx_filter_listing_page(Request_t* request);
BYTE save_the_number_of_ipx_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
PARAMETER_NODE* next_ipx_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save);
void remove_a_perticular_ipx_filter(USHORT index);
PARAMETER_NODE* first_ipx_filter_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save);
/* ... Local ProtoType*/

extern void 		check_for_need_and_hide_irrelevent_fields();

BYTE* types_of_filters[] =
{
	"Filter on Destination Address",
	"Filter on Source Address",
	"Forward on Destination Address",
	"Forward on Source Address"
};

BYTE* types_of_ports[] = 
{
	"LAN",
	"WAN1",
	"WAN2",
	"WAN3"
};

PARAMETER_NODE* ptr_to_start_of_ipx_filters, *ptr_to_first_ipx_filter_of_current_page;
USHORT ipx_filters_till_current_page = 0, total_ipx_filters = 0;
STRUCT_IPX_FILTER contents_of_ipx_filter_page[NUMBER_OF_ROUTES_PER_PAGE];

void display_ipx_filter_menu(Request_t* request)
{
	BYTE rhs_string[200];  
	STRUCT_IPX_FILTER temp_ipx_struct;
	
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ptr_to_first_ipx_filter_of_current_page = ptr_to_start_of_ipx_filters = cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&temp_ipx_struct);
	ipx_filters_till_current_page = 0;
	if (ptr_to_start_of_ipx_filters)
		total_ipx_filters = get_the_number_of_ipx_filters();
	InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_add_ipx_filter_form (Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	InitReturnBuffer(request, ADD_IPX_FILTER_data_ptr, strlen(ADD_IPX_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_ved_ipx_filters_page(Request_t* request)
{
	STRUCT_IPX_FILTER temp_ipx_struct;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ptr_to_first_ipx_filter_of_current_page = ptr_to_start_of_ipx_filters = cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&temp_ipx_struct);
	if (ptr_to_start_of_ipx_filters)
		total_ipx_filters = get_the_number_of_ipx_filters();
	if (!total_ipx_filters)
	{
		InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}
	ipx_filters_till_current_page = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_ipx_filter_from_where_display_is_reqd_to_continue(ptr_to_start_of_ipx_filters, TRUE);
	display_next_ten_ipx_filters(request);
}

void add_the_ipx_filter(Request_t* request)
{
	PARAMETER_NODE* new_node;
	ADD_IPX_FILTER_form_output_type*  ipx_filter_to_add;
	BYTE temp_string[200];
	STRUCT_IPX_FILTER ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ipx_filter_to_add = (ADD_IPX_FILTER_form_output_type*) form_data_of_request(request);

	/* ### pending  -> ipx_filter */
	strcpy(ipx_filter.network_number, ipx_filter_to_add->network_number);
	strcpy(ipx_filter.node_number, ipx_filter_to_add->node_number);
	strcpy(ipx_filter.socket_number, ipx_filter_to_add->socket_number);
	ipx_filter.physical_port = ipx_filter_to_add->physical_port;
	ipx_filter.filter_type = ipx_filter_to_add->filter_type;

	new_node = cm_insert_string(CM_IPX_SECTION, "IPX Filter", (void*)&ipx_filter);
	if (new_node == NULL)
	{
		printf("Failed to Insert the IPX Filter\n");
		InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if (ptr_to_start_of_ipx_filters == NULL)
		ptr_to_first_ipx_filter_of_current_page = ptr_to_start_of_ipx_filters = new_node;
	total_ipx_filters ++;
	InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void delete_the_ipx_filter(Request_t* request)
{
	BYTE index;
	PARAMETER_NODE* node, *prev_first_node_of_the_page;
	STRUCT_IPX_FILTER ipx_filter;

	/*************************************************************************
	NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
	*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	index = save_the_number_of_ipx_filter_being_edited(NULL, FALSE);
	if (index == 1)
	{
		prev_first_node_of_the_page = first_ipx_filter_of_the_current_page(NULL, FALSE);
		
		node =  cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&ipx_filter);
		while (node != prev_first_node_of_the_page)
		{
			node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&ipx_filter);
		}
		node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&ipx_filter);

		if (node)
			first_ipx_filter_of_the_current_page(node, TRUE);
	}
	remove_a_perticular_ipx_filter(index);
	if (total_ipx_filters == 0)
	{
		InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
/*	go_back_to_ipx_filter_listing_page(request);*/
}

void remove_a_perticular_ipx_filter(USHORT index)
{
	BYTE buffer[200];
	STRUCT_IPX_FILTER ipx_filter;
	PARAMETER_NODE* last_displayed_ipx_filter;

	ipx_filter = contents_of_ipx_filter_page[index-1];
	if (cm_remove_string(CM_IPX_SECTION, "IPX Filter", (void*)&ipx_filter) != CM_REMOVING_STRING_SUCCESSFUL)
	{
		printf("Failed to remove the IPX Filter \n");
		return;
	}

	last_displayed_ipx_filter = next_ipx_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (index == 10)
	{
		if (ipx_filters_till_current_page == total_ipx_filters)
		{
			last_displayed_ipx_filter = last_displayed_ipx_filter->previous;
			ipx_filters_till_current_page --;
		}
		else
		{
			last_displayed_ipx_filter = last_displayed_ipx_filter->next;
		}
	}
	else
	if (index == total_ipx_filters)
	{
			last_displayed_ipx_filter = last_displayed_ipx_filter->previous;
			ipx_filters_till_current_page --;
	}
	else
	if(ipx_filters_till_current_page < 10)
	{
			ipx_filters_till_current_page --;
	}
	next_ipx_filter_from_where_display_is_reqd_to_continue(last_displayed_ipx_filter, TRUE);
	total_ipx_filters --;

	/* if the first node is deleted take care */
	if (total_ipx_filters == 0)
	{
		ptr_to_start_of_ipx_filters = NULL;	
		return;
	}
	if (ipx_filters_till_current_page  <= 10 && index == 1)
	{
		 ptr_to_start_of_ipx_filters = ptr_to_start_of_ipx_filters->next;
	}
}

void display_the_ipx_filter_for_editing(Request_t* request, STRUCT_IPX_FILTER* ipx_filter)
{
	BYTE* buffer, i;
	USHORT search_to_start_at;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = malloc(strlen(EDIT_IPX_FILTER_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a IPX filter for editing\n");
		return;
	}
	strcpy(buffer, EDIT_IPX_FILTER_data_ptr);

	search_to_start_at = search_and_replace("#______#", ipx_filter->network_number, buffer, TRUE, 0);
	search_to_start_at = search_and_replace("#__________#", ipx_filter->node_number, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#__#", ipx_filter->socket_number, buffer, TRUE, search_to_start_at);
	for(i=0 ; i<ipx_filter->physical_port ; ++i)
	{
		search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, FALSE, search_to_start_at);
	}
	search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, TRUE, search_to_start_at);
	/* Skip other options in the Port */
	search_to_start_at = search_and_replace("</SELECT>", "", buffer, FALSE, search_to_start_at);

	for(i=0 ; i<ipx_filter->filter_type ; ++i)
	{
		search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, FALSE, search_to_start_at);
	}
	search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, TRUE, search_to_start_at);
	/* Skip other options in the Port */
	search_to_start_at = search_and_replace("</SELECT>", "", buffer, FALSE, search_to_start_at);
     
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_ipx_filter_1(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[0];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(1, TRUE);
}

void display_edit_ipx_filter_2(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[1];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(2, TRUE);
}

void display_edit_ipx_filter_3(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[2];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(3, TRUE);
}

void display_edit_ipx_filter_4(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[3];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(4, TRUE);
}

void display_edit_ipx_filter_5(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[4];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(5, TRUE);
}

void display_edit_ipx_filter_6(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[5];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(6, TRUE);
}

void display_edit_ipx_filter_7(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[6];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(7, TRUE);
}

void display_edit_ipx_filter_8(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[7];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(8, TRUE);
}

void display_edit_ipx_filter_9(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[8];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(9, TRUE);
}

void display_edit_ipx_filter_10(Request_t* request)
{
	STRUCT_IPX_FILTER  ipx_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	ipx_filter = contents_of_ipx_filter_page[9];
	display_the_ipx_filter_for_editing(request, &ipx_filter);
	save_the_number_of_ipx_filter_being_edited(10, TRUE);
}

void display_next_ten_ipx_filters(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	temp_ptr = next_ipx_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_ipx_filters_from(request, temp_ptr, TRUE);
}

void display_prev_ten_ipx_filters(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	temp_ptr = next_ipx_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (ipx_filters_till_current_page <= 2*NUMBER_OF_ROUTES_PER_PAGE)
	{
		for(i=1;i<ipx_filters_till_current_page;++i)
		{
			temp_ptr = cm_get_previous_entry(CM_IPX_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		ipx_filters_till_current_page = 0;
	}
	else
	{
		for(i=1;i<NUMBER_OF_ROUTES_PER_PAGE+(ipx_filters_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?ipx_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);++i)
		{
			temp_ptr = cm_get_previous_entry(CM_IPX_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		ipx_filters_till_current_page -= (NUMBER_OF_ROUTES_PER_PAGE+(ipx_filters_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?ipx_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE));
	}
	display_ten_ipx_filters_from(request, temp_ptr, TRUE);
}

void display_ten_ipx_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page, buffer[100];
	USHORT i, j, k, search_to_start_at = 0;
	STRUCT_IPX_FILTER temp_ipx_struct;
	PARAMETER_NODE* node, *prev_node;
	
	static BYTE number_of_entries_read_in_the_current_node = 0;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	first_ipx_filter_of_the_current_page(starting_from, TRUE);

	if(ipx_filters_till_current_page  == total_ipx_filters)
	{
		InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(VIEW_EDIT_DEL_IPX_FILTER_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display IPX Filter list.\n");
		return;
	}

	strcpy(temp_page, VIEW_EDIT_DEL_IPX_FILTER_data_ptr);
   
	node =  cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&temp_ipx_struct);
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0;
	while (node != starting_from)
	{
		node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&temp_ipx_struct);
	}

	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i=0; i<number_of_entries_read_in_the_current_node ;++i)
		{
			if (!node)
			{
				return;
			}
			node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&temp_ipx_struct);
		}
	}
	number_of_entries_read_in_the_current_node = 0;
	prev_node = starting_from;

	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE;++i)
	{

		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = modify_the_ipx_template(temp_page, &temp_ipx_struct, search_to_start_at);
		contents_of_ipx_filter_page[i] =  temp_ipx_struct;

		ipx_filters_till_current_page++;
		if ((ipx_filters_till_current_page  == total_ipx_filters && is_displaying_next_page)
		    || (ipx_filters_till_current_page  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_ipx_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_ipx_filter_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{
				/* if some IPX Filter in the previous page enable the link hence disable */

				/* No More IPX Filter are there hence remove the link */
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			else
			{
				/* while displaying if we each first page just remove back link */
/*				disable_the_link_to_display_prev_10(temp_page, search_to_start_at);*/

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_ipx_filters > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at);
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_IPX_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
		if (is_displaying_next_page)
		{
			starting_from = cm_get_next_entry(CM_IPX_SECTION, starting_from, (void*)&temp_ipx_struct);
/*			ipx_filters_till_current_page++;*/
		}
		else
		{
			starting_from = cm_get_previous_entry(CM_IPX_SECTION, starting_from, NULL);
			ipx_filters_till_current_page--;
		}

		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++;
		else
      {
			number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_ipx_filter_to_display(i+1, search_to_start_at, temp_page);
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_IPX_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_ipx_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE);

	/* Check if back link is required or not */

	/* Check if forward link is required or not */
	if (total_ipx_filters > ipx_filters_till_current_page)
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

	InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_IPX_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}
/*
void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node)
{
	USHORT i=0, j=0;

	if (node == NULL)
	{
		buffer[0] = 0;
		return;
	}

	while(node->parameter[i] != '=')
	{
		++i;
	}
  	i+=2;
	while(node->parameter[i] != '\0' &&	node->parameter[i] != '\n' && node->parameter[i] != '\r')
		buffer[j++] = node->parameter[i++];
  buffer[j] = 0;
}
*/
USHORT modify_the_ipx_template(BYTE* buffer, STRUCT_IPX_FILTER* ipx_filter, USHORT search_to_start_at)
{
	BYTE temp_string[50];
  	strcpy(temp_string, ipx_filter->network_number);
	strcat(temp_string, " ");
	strcat(temp_string, ipx_filter->node_number);
	strcat(temp_string, " ");
	strcat(temp_string, ipx_filter->socket_number);
	search_to_start_at = search_and_replace("#__________IPX_FILTER_TYPE______#", types_of_filters[ipx_filter->filter_type], buffer, TRUE, 0);
	search_to_start_at = search_and_replace("#PORT#", types_of_ports[ipx_filter->physical_port], buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#__________IPX_NETWORK_INFO_#", temp_string, buffer, TRUE, search_to_start_at);
	return (search_to_start_at);
}

#if 0
PARAMETER_NODE* get_the_pointer_to_start_of_ipx_filters()
{
	PARAMETER_NODE* node, *start_of_ipx_section;
	USHORT i = 0;
	BYTE lhs_string[100];

	start_of_ipx_section = node = sptr_to_ptr_to_sections[IPX_SECTION];
	node = node->previous;
	while (node <= sptr_to_ptr_to_sections[IP_SECTION])
	{
		i = 0;
		while(node->parameter[i] != '=')
		{
		  lhs_string[i] = node->parameter[i];
		  ++i;
		}
		lhs_string[i-1] = 0;
		if (!strcmp(lhs_string, "IP Port BOOTP"))
		{
			if (node->next == start_of_ipx_section)
			{
				return(NULL);
			}
			return(node->next);
		}
		node = node->previous;
	}
}
#endif

USHORT get_the_number_of_ipx_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	BYTE rhs_string[200];
	STRUCT_IPX_FILTER temp_ipx_struct;



	node = cm_get_first_entry(CM_IPX_SECTION, "IPX Filter", (void*)&temp_ipx_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_IPX_SECTION, node, (void*)&temp_ipx_struct);
		count ++;	
	}
	return count;
}

void change_the_edited_ipx_filter(Request_t* request)
{
	CHANGE_THE_IPX_FILTER_form_output_type* edited_ipx_filter;
	BYTE edited_ipx_filter_index, previous_rhs[200], new_rhs[200];
	enum CM_EDIT_STRING_RESULTS result;
	STRUCT_IPX_FILTER new_ipx_filter, old_ipx_filter;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	edited_ipx_filter = (CHANGE_THE_IPX_FILTER_form_output_type*)form_data_of_request(request);
	if (!strcmp(edited_ipx_filter->DeleteIPXFiltButton, "Delete"))
	{
		delete_the_ipx_filter(request);
		return;
	}
	edited_ipx_filter_index = save_the_number_of_ipx_filter_being_edited(NULL, FALSE);
	old_ipx_filter = contents_of_ipx_filter_page[edited_ipx_filter_index-1];
#if 0
	/* ### Pending */
	strcpy(previous_rhs, contents_of_ipx_filter_page[edited_ipx_filter_index-1].ip_address);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_ipx_filter_page[edited_ipx_filter_index-1].gateway_address);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_ipx_filter_page[edited_static_route_index-1].address_mask);
	strcat(previous_rhs, ",");
	strcat(previous_rhs, contents_of_ipx_filter_page[edited_static_route_index-1].metric);
								  
	strcpy(new_static_route.ip_address, edited_static_route->ip_address);
	strcpy(new_static_route.gateway_address, edited_static_route->gateway_address);
	strcpy(new_static_route.address_mask, edited_static_route->ip_address_mask);
	strcpy(new_static_route.metric, edited_static_route->metric);
#endif

	strcpy(new_ipx_filter.network_number, edited_ipx_filter->network_number);
	strcpy(new_ipx_filter.node_number, edited_ipx_filter->node_number);
	strcpy(new_ipx_filter.socket_number, edited_ipx_filter->socket_number);
	new_ipx_filter.physical_port = edited_ipx_filter->port;
	new_ipx_filter.filter_type = edited_ipx_filter->filter_type;

    result = cm_edit_string(CM_IPX_SECTION, "IPX Filter", (void*)&old_ipx_filter, (void*)&new_ipx_filter);
	 if (result != CM_STRING_EDIT_SUCCESSFUL)
	 {
	 	printf("Configuration manager refused to make the changes \n");
	 }
	InitReturnBuffer(request, IPX_FILTER_MENU_data_ptr, strlen(IPX_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
/*	 go_back_to_ipx_filter_listing_page(request);*/
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_ipx_filter_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_ipx_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}

void go_back_to_ipx_filter_listing_page(Request_t* request)
{
	PARAMETER_NODE* temp_node;
	BYTE i, temp, index;
	temp_node = next_ipx_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (ipx_filters_till_current_page%10)?ipx_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE;

	temp_node = first_ipx_filter_of_the_current_page(NULL, FALSE);

	ipx_filters_till_current_page -= ((ipx_filters_till_current_page%10)?ipx_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);
		
	next_ipx_filter_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_ipx_filters(request);
}
#if 0
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;
/*	if (save_whether_next_link_is_enabled_or_not(NULL, FALSE))
		is_replacement_required = FALSE;
	else
		is_replacement_required = TRUE;*/

	search_to_start_at = search_and_replace("<!--$", "<A   ", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("$-->", "</A>", buffer, is_replacement_required, search_to_start_at);
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	return search_to_start_at;
}

USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;
/*	if (save_whether_next_link_is_enabled_or_not(NULL, FALSE))
		is_replacement_required = TRUE;
	else
		is_replacement_required = FALSE;*/

	search_to_start_at = search_and_replace("<A   ", "<!--$", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("</A>", "$-->", buffer, is_replacement_required, search_to_start_at);
	save_whether_next_link_is_enabled_or_not(FALSE, TRUE);
	return search_to_start_at;
}

USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;
/*	if (save_whether_prev_link_is_enabled_or_not(NULL, FALSE))
		is_replacement_required = FALSE;
	else
		is_replacement_required = TRUE;*/

	search_to_start_at = search_and_replace("<!--@", "<A   ", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("@-->", "</A>", buffer, is_replacement_required, search_to_start_at);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	return search_to_start_at;
}

USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;
/*	if (save_whether_prev_link_is_enabled_or_not(NULL, FALSE))
		is_replacement_required = TRUE;
	else
		is_replacement_required = FALSE;*/
	
	search_to_start_at = search_and_replace("<A   ", "<!--@", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("</A>", "@-->", buffer, is_replacement_required, search_to_start_at);
	save_whether_prev_link_is_enabled_or_not(FALSE, TRUE);
	return search_to_start_at;
}

BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save)
{
/*	static BYTE saved_value	;

	if (is_required_to_save)
		saved_value = the_status;
	else	
		return saved_value;					  	*/
	return FALSE;
}

BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save)
{
/*	static BYTE saved_value	;

	if (is_required_to_save)
		saved_value = the_status;
	else	
		return saved_value;					  	*/
	return FALSE;
}
#endif
PARAMETER_NODE* next_ipx_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 

PARAMETER_NODE* first_ipx_filter_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = new_node;
	else
		return saved_node;
}
