/* Author : Jyothi
   Date   : 12/3/98
   Description : Contains routines to handle link usage control  in WAN dialog */

#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"

#include "dellnk.h"
#include "dellnkfm.h"
#include "vdlnk.h"
                  
#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg) ;
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at) ;
extern void    display_framed_or_standard_main_page(Request_t* request) ;
extern BYTE    get_wan_port_number()  ;
extern void    display_wan_page_for_port2(Request_t* request) ;
extern void    display_wan_page_for_port3(Request_t* request) ;

/*...Extern Decleration*/

/* Local ProtoType ...*/

void display_vd_host_address_page(Request_t* request) ;
void delete_the_host_address_entry(Request_t* request) ;
void remove_a_particular_host_address_entry(USHORT index) ;
void display_host_address_for_deleting(Request_t* request, STRUCT_HOST_ENTRY* host_address) ;
void display_next_ten_host_address_entries(Request_t* request) ;
void display_ten_host_address_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page) ;
USHORT get_the_number_of_host_address_entries() ;
USHORT hide_remaining_hyper_links_on_which_there_is_no_host_address_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer) ;
BYTE save_the_number_of_host_address_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save) ;
PARAMETER_NODE* next_host_address_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save) ;
PARAMETER_NODE* first_host_address_entry_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save) ;
USHORT modify_host_address_template(BYTE* buffer, STRUCT_HOST_ENTRY* host_address, USHORT search_to_start_at) ;

/* ... Local ProtoType*/


PARAMETER_NODE* ptr_to_start_of_host_address_entries, *ptr_to_first_host_entry_of_current_page ;
USHORT host_address_entries_till_current_page = 0 , total_number_of_host_address_entries = 0 ;
STRUCT_HOST_ENTRY contents_of_host_addr_entry[NUMBER_OF_ROUTES_PER_PAGE] ;

void display_previous_wan_page(Request_t* request) 
{
   BYTE port_number ;
   
   port_number = get_wan_port_number() ;
   if (port_number == 2)
     display_wan_page_for_port2 (request) ;
   else
     display_wan_page_for_port3 (request) ;
}

void display_vd_host_address_page(Request_t* request) 
{
   STRUCT_HOST_ENTRY host_addr ;
   BYTE port_number ;
   
   port_number = get_wan_port_number() ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;

   host_addr.port = port_number ;
   ptr_to_first_host_entry_of_current_page = ptr_to_start_of_host_address_entries = cm_get_first_entry (CM_PROXY_SECTION, "Privileged User Address", (void *) &host_addr) ;
   total_number_of_host_address_entries = get_the_number_of_host_address_entries() ;

	if (total_number_of_host_address_entries == 0)
	{
      if (port_number == 2)
        display_wan_page_for_port2 (request) ;
      else
        display_wan_page_for_port3 (request) ;
	}
   else
   {
	   host_address_entries_till_current_page = 0 ;
	   save_whether_next_link_is_enabled_or_not(TRUE, TRUE) ;
	   save_whether_prev_link_is_enabled_or_not(TRUE, TRUE) ;
	   next_host_address_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_host_address_entries, TRUE) ;
	   display_next_ten_host_address_entries(request) ;
   }
}

void delete_the_host_address_entry(Request_t* request)
{
	BYTE index ;
	PARAMETER_NODE* node, *prev_first_node_of_the_page ;
   STRUCT_HOST_ENTRY host_addr ;
   BYTE port_number ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
   port_number = get_wan_port_number() ;
	index = save_the_number_of_host_address_entry_being_edited(NULL, FALSE) ;

	if (index == 1)
	{
		prev_first_node_of_the_page = first_host_address_entry_of_the_current_page(NULL, FALSE) ;

      host_addr.port = port_number ;
    	node =  cm_get_first_entry (CM_PROXY_SECTION, "Privileged User Address", (void *)&host_addr) ;
      while (node != prev_first_node_of_the_page)
	   {
         host_addr.port = port_number ;
         node =  cm_get_next_entry (CM_PROXY_SECTION, node, (void *)&host_addr) ;
    	}

      host_addr.port = port_number ;
      node =  cm_get_next_entry (CM_PROXY_SECTION, node, (void *)&host_addr) ;

      if (node)
			first_host_address_entry_of_the_current_page(node, TRUE) ;
	}
	remove_a_particular_host_address_entry(index) ;
	if (total_number_of_host_address_entries == 0)
	{
      if (port_number == 2)
        display_wan_page_for_port2 (request) ;
      else
        display_wan_page_for_port3 (request) ;
	}
   if (port_number == 2)
     display_wan_page_for_port2 (request) ;
   else
     display_wan_page_for_port3 (request) ;
}


void remove_a_particular_host_address_entry(USHORT index)
{
	PARAMETER_NODE* last_displayed_host_address_entry ;
   STRUCT_HOST_ENTRY host_addr ;
   BYTE port_number ;
   
   port_number = get_wan_port_number() ;

   host_addr.port = port_number ;
   strcpy (host_addr.ip_addr, contents_of_host_addr_entry[index-1].ip_addr) ;
	if (cm_remove_string(CM_PROXY_SECTION, "Privileged User Address", (void*)&host_addr) != CM_REMOVING_STRING_SUCCESSFUL)
	{
	   printf("Failed to remove the Host Address Entry\n") ;
	   return ;
	}

	last_displayed_host_address_entry = next_host_address_entry_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
	if (index == 10)
	{
		if (host_address_entries_till_current_page == total_number_of_host_address_entries)
		{
			last_displayed_host_address_entry = last_displayed_host_address_entry->previous ;
			host_address_entries_till_current_page -- ;
		}
		else
			last_displayed_host_address_entry = last_displayed_host_address_entry->next ;
	}
	else
	if (index == total_number_of_host_address_entries)
	{
			last_displayed_host_address_entry = last_displayed_host_address_entry->previous ;
			host_address_entries_till_current_page -- ;
	}
	else
	if(host_address_entries_till_current_page < 10)
			host_address_entries_till_current_page -- ;
	next_host_address_entry_from_where_display_is_reqd_to_continue(last_displayed_host_address_entry, TRUE) ;
	total_number_of_host_address_entries -- ;

	/* if the first node is deleted take care */
	if (total_number_of_host_address_entries == 0)
	{
		ptr_to_start_of_host_address_entries = NULL ;	
		return ;
	}
	if (host_address_entries_till_current_page  <= 10 && index == 1)
		 ptr_to_start_of_host_address_entries = ptr_to_start_of_host_address_entries->next ;
}

void display_host_address_for_deleting(Request_t* request, STRUCT_HOST_ENTRY* host_address)
{
	BYTE* buffer ;
	USHORT search_to_start_at ;

  	buffer = malloc(strlen(DELETE_HOST_ADDRESS_data_ptr)) ;
   
	if (buffer == NULL)
	{
		printf("Out Of memory to display host address for deleting\n") ;
		return ;
	}
   strcpy(buffer, DELETE_HOST_ADDRESS_data_ptr) ;
   search_to_start_at = search_and_replace("#___ADDRESS___#", host_address->ip_addr, buffer, TRUE, 0) ; 
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE) ;
	free(buffer) ;
}

void display_delete_host_address_entry_1(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[0] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(1, TRUE) ;
}

void display_delete_host_address_entry_2(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[1] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(2, TRUE) ;
}
void display_delete_host_address_entry_3(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[2] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(3, TRUE) ;
}
void display_delete_host_address_entry_4(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[3] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(4, TRUE) ;
}
void display_delete_host_address_entry_5(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[4] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(5, TRUE) ;
}
void display_delete_host_address_entry_6(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[5] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(6, TRUE) ;
}
void display_delete_host_address_entry_7(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[6] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(7, TRUE) ;
}
void display_delete_host_address_entry_8(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[7] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(8, TRUE) ;
}
void display_delete_host_address_entry_9(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[8] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(9, TRUE) ;
}
void display_delete_host_address_entry_10(Request_t* request)
{
   STRUCT_HOST_ENTRY host_addr ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return ;

    host_addr = contents_of_host_addr_entry[9] ;
    display_host_address_for_deleting(request, &host_addr) ;
    save_the_number_of_host_address_entry_being_edited(10, TRUE) ;
}

void display_next_ten_host_address_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return ;
			
	temp_ptr = next_host_address_entry_from_where_display_is_reqd_to_continue(NULL, FALSE) ;
	display_ten_host_address_entries_from(request, temp_ptr, TRUE) ;
}

void display_ten_host_address_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page ;
	USHORT i, search_to_start_at = 0 ;
   STRUCT_HOST_ENTRY host_addr ;
	PARAMETER_NODE* node, *prev_node ;
   static BYTE number_of_entries_read_in_the_current_node = 0 ;
   BYTE port_number ;
   
   port_number = get_wan_port_number() ;
	first_host_address_entry_of_the_current_page(starting_from, TRUE) ;

	if(host_address_entries_till_current_page == total_number_of_host_address_entries)
	{
      if (port_number == 2)
        display_wan_page_for_port2 (request) ;
      else
        display_wan_page_for_port3 (request) ;
	}

  	temp_page = malloc(strlen(VIEW_DELETE_HOST_ADDRESS_data_ptr)) ;

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display Host Address list.\n") ;
		return ;
	}

   strcpy(temp_page, VIEW_DELETE_HOST_ADDRESS_data_ptr) ;

   host_addr.port = port_number ;
	node = cm_get_first_entry(CM_PROXY_SECTION, "Privileged User Address", (void*)&host_addr) ;
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0 ;
	while (node != starting_from)
	{
      host_addr.port = port_number ;
      node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&host_addr) ;
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i = 0 ; i < number_of_entries_read_in_the_current_node ; ++i)
		{
			if (!node)
				return ;
         host_addr.port = port_number ;
         node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&host_addr) ;
		}
	}
	number_of_entries_read_in_the_current_node = 0 ;
	prev_node = starting_from ;

	for(i = 0 ; i < NUMBER_OF_ROUTES_PER_PAGE ; ++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at) ;
      search_to_start_at = modify_host_address_template(temp_page, &host_addr, search_to_start_at) ;
      contents_of_host_addr_entry[i] = host_addr ;

		host_address_entries_till_current_page++ ;
		if ((host_address_entries_till_current_page == total_number_of_host_address_entries && is_displaying_next_page)
		    || (host_address_entries_till_current_page == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_host_address_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_host_address_entry_to_display(i+1, search_to_start_at, temp_page) ;
			if (is_displaying_next_page)
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_number_of_host_address_entries > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
			}
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
		if (is_displaying_next_page)
		{
          host_addr.port = port_number ;
		    starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&host_addr) ;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++ ;
		else
		{
         number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_host_address_entry_to_display(i+1, search_to_start_at, temp_page) ;
			InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
			free(temp_page) ;
			return ;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at) ;

	/* Save the lastly displayed node */
	next_host_address_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE) ;

	if (total_number_of_host_address_entries > host_address_entries_till_current_page)
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at) ;
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at) ;

	InitReturnBuffer(request, temp_page, strlen(temp_page), HTML_CONTENT_TYPE, TRUE) ;
	free(temp_page) ;
}

USHORT modify_host_address_template(BYTE* buffer, STRUCT_HOST_ENTRY* host_addr, USHORT search_to_start_at)
{
        search_to_start_at = search_and_replace("#___ADDRESS___#", host_addr->ip_addr, buffer, TRUE, search_to_start_at) ;
        return (search_to_start_at) ;
}

USHORT get_the_number_of_host_address_entries()
{
	USHORT count = 0 ;
	PARAMETER_NODE* node ;
   STRUCT_HOST_ENTRY host_addr ;
   BYTE port_number ;
   
   port_number = get_wan_port_number() ;

   host_addr.port = port_number ;
   node =  cm_get_first_entry (CM_PROXY_SECTION, "Privileged User Address", (void *) &host_addr) ;
	while (node)
	{
      host_addr.port = port_number ;
    	node =  cm_get_next_entry (CM_PROXY_SECTION, node, (void *)&host_addr) ;
		count ++ ;	                     
	}
	return count ;
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_host_address_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i ;
	BYTE comment_opened = FALSE ;
	for(i=0 ;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from ;++i)
	{
		comment_opened = TRUE ;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at) ;
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at) ;
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at) ;
		
	return search_to_start_at ;
}

BYTE save_the_number_of_host_address_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte ;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte ;
	else
		return saved_byte ;
}

PARAMETER_NODE* next_host_address_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = last_node ;
	else
		return saved_node ;
} 

PARAMETER_NODE* first_host_address_entry_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node ;

	if (is_required_to_save)
		saved_node = new_node ;
	else
		return saved_node ;
}

