#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"

#define NUMBER_OF_ENTRIES_PER_PAGE 10


#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

#include "proxy.h"
#include "addproxy.h"
#include "edtproxy.h"
#include "vedproxy.h"
#include "tcplist.h"
#include "udplist.h"

#include "adprxyfm.h"
#include "edtprxfm.h"
#include "tcplstfm.h"
#include "udplstfm.h"

#define ADD_ENTRY 1
#define EDIT_ENTRY 2

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
/*...Extern Decleration*/

/* Local ProtoType ...*/
void display_the_proxy_entry_for_editing(Request_t* request, STRUCT_PROXY_ENTRY* proxy_entry);
void display_ten_proxy_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page);
void display_prev_proxy_entries(Request_t* request);
void display_next_ten_proxy_entries(Request_t* request);
USHORT get_the_number_of_proxy_entries();
void change_the_edited_proxy_entries(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_to_proxy_entry_listing_page(Request_t* request);
BYTE save_the_number_of_proxy_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
PARAMETER_NODE* next_proxy_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save);
void remove_a_perticular_proxy_entry(USHORT index);
PARAMETER_NODE* first_proxy_entry_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save);
USHORT modify_the_proxy_entry_template(BYTE* buffer, STRUCT_PROXY_ENTRY* proxy_entry, USHORT search_to_start_at);
void display_the_list_for_tcp(Request_t* request);
void display_the_list_for_udp(Request_t* request);
void select_the_port_from_tcp_port_list(Request_t* request);
void select_the_port_from_udp_port_list(Request_t* request);
BYTE is_numeric(BYTE* buffer);


/* ... Local ProtoType*/

PARAMETER_NODE* ptr_to_start_of_proxy_entries, *ptr_to_first_proxy_entry_of_current_page;
USHORT proxy_entries_till_current_page = 0, total_proxy_entries = 0;

STRUCT_PROXY_ENTRY contents_of_proxy_entry_page[NUMBER_OF_ENTRIES_PER_PAGE];


typedef struct
{
   BYTE name[70]; /* NOTE: Change this if u change/add names in names_lib struct */
   USHORT port_number;
}STRUCT_NAME_PORT_LIB;

STRUCT_NAME_PORT_LIB names_lib[] = 
{
   {"Conference", 531},
   {"Domain Name Server", 53},
   {"Echo Application", 7},
   {"Finger User Information Protocol", 79},
   {"File Transfer Protocol", 20},
   {"File Transfer Protocol", 21},
   {"Gopher - Distributed Documentation Search and Retrieval", 70},
   {"On-line Host Name Service", 42},
   {"News", 144},
   {"Post Office Protocol(Ver3) e-mail", 110},
   {"Readnews", 532},
   {"Simple Mail Transfer Protocol", 25},
   {"Telnet Application", 23},
   {"Trivial File Transfer Protocol", 69},
   {"World Wide Web-Hyper Text Transfer Protocol", 80},
   {"Network News Transfer Protocol", 119},
   {"Internet Relay Chat Protocol", 194},
   {"Secure Socket Layer Hyper Text Transfer Protocol", 443},
   {"Secure Socket Layer Network News Transfer Protocol", 563},
   {"Secure Socket Layer Simple Mail Transfer Protocol", 465},
   {"Remote Login - Telnet", 513},
   {NULL, 0}
};



void display_proxy_menu(Request_t* request)
{
	STRUCT_PROXY_ENTRY temp_proxy_entry;
	

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ptr_to_first_proxy_entry_of_current_page = ptr_to_start_of_proxy_entries = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	proxy_entries_till_current_page = 0;
	if (ptr_to_first_proxy_entry_of_current_page)
		total_proxy_entries = get_the_number_of_proxy_entries();
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_page_to_add_proxy_entry(Request_t* request)
{
   USHORT search_to_start_at;   
   BYTE* buffer;
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	
	buffer =  (BYTE*)malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, 0); 
   search_to_start_at = search_and_replace("#___TEXT___#___", "", buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
   free(buffer);
}

void display_ved_proxy_entry_page(Request_t* request)
{
	STRUCT_PROXY_ENTRY temp_proxy_entry;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ptr_to_first_proxy_entry_of_current_page = ptr_to_start_of_proxy_entries = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	if (ptr_to_start_of_proxy_entries)
		total_proxy_entries = get_the_number_of_proxy_entries();

	if (!total_proxy_entries)
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}

	proxy_entries_till_current_page = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_proxy_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_proxy_entries, TRUE);
	display_next_ten_proxy_entries(request);
}

BYTE display_port_list_called_from(BYTE new_value, BYTE is_to_save)
{
   static BYTE value = 0;
   if (is_to_save)
      value = new_value;
   else
      return value;
}

void add_the_proxy_entry(Request_t* request)
{
	PARAMETER_NODE* new_node;
	ADD_PROXY_ENTRY_form_output_type*  proxy_entry_to_add;
	STRUCT_PROXY_ENTRY proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry_to_add = (ADD_PROXY_ENTRY_form_output_type*) form_data_of_request(request);
   
   if (!strcmpi(proxy_entry_to_add->choose, "Choose From List..."))
   {
      display_port_list_called_from(ADD_ENTRY, TRUE);
      if (!(proxy_entry_to_add->protocol))
         display_the_list_for_tcp(request);
      else
         display_the_list_for_udp(request);
      return;
   }
   if (!is_numeric(proxy_entry_to_add->port))
   {
      printf("Invalid Port Number Failed to add Proxy Entry\n");
   	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return;
   }

	proxy_entry.protocol = proxy_entry_to_add->protocol;
	proxy_entry.port = atoi(proxy_entry_to_add->port);

	new_node = cm_insert_string(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry);
	if (new_node == NULL)
	{
		printf("Failed to Insert the Proxy Entry\n");
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if (ptr_to_start_of_proxy_entries == NULL)
		ptr_to_first_proxy_entry_of_current_page = ptr_to_start_of_proxy_entries = new_node;
	total_proxy_entries ++;
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_the_list_for_tcp(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   InitReturnBuffer(request, TCP_LIST_data_ptr, strlen(TCP_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_the_list_for_udp(Request_t* request)
{
/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   InitReturnBuffer(request, UDP_LIST_data_ptr, strlen(UDP_LIST_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void select_the_port_from_tcp_port_list(Request_t* request)
{
   TCP_LIST_form_output_type* selected_port;
   BYTE name[80], *buffer;
   USHORT search_to_start_at;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

   selected_port = (TCP_LIST_form_output_type*)form_data_of_request(request);
   
   sprintf(name, "%d", names_lib[selected_port->port].port_number);
   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	buffer = malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
   }
   else
   {
   	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
   }

	if (buffer == NULL)
	{
		printf("Out Of memory to display page for Proxy Entry \n");
		return;
	}
   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
   }
   else
   {
   	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);
   }

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, 0); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, FALSE, search_to_start_at); 
   search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void select_the_port_from_udp_port_list(Request_t* request)
{
   UDP_LIST_form_output_type* selected_port;
   BYTE name[80], *buffer;
   USHORT search_to_start_at;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
   selected_port = (UDP_LIST_form_output_type*)form_data_of_request(request);
   sprintf(name, "%d", names_lib[selected_port->port].port_number);

   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	buffer = malloc(strlen(ADD_PROXY_ENTRY_data_ptr));
   }
   else
   {
   	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
   }
	if (buffer == NULL)
	{
		printf("Out Of memory to display page for adding Proxy Entry \n");
		return;
	}
   if (display_port_list_called_from(FALSE, FALSE) == ADD_ENTRY)
   {
   	strcpy(buffer, ADD_PROXY_ENTRY_data_ptr);
   }
   else
   {
   	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);
   }

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, FALSE, 0); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#___TEXT___#___", name, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void match_the_port_number_to_name(USHORT port_number, BYTE* name)
{
   BYTE i = 0;

   while (names_lib[i].port_number != 0)
   {
      if (port_number == names_lib[i].port_number)
      {
         sprintf(name, "%s(%d)", names_lib[i].name, names_lib[i].port_number);
         return;
      }
      i++;
   }
   sprintf(name, "%d", port_number);
}

void delete_the_proxy_entry(Request_t* request)
{
	BYTE index;
	PARAMETER_NODE* node, *prev_first_node_of_the_page;
	STRUCT_PROXY_ENTRY proxy_entry;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	index = save_the_number_of_proxy_entry_being_edited(NULL, FALSE);
	if (index == 1)
	{
		prev_first_node_of_the_page = first_proxy_entry_of_the_current_page(NULL, FALSE);
		
		node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry);
		while (node != prev_first_node_of_the_page)
		{
			node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_entry);
		}
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&proxy_entry);

		if (node)
			first_proxy_entry_of_the_current_page(node, TRUE);
	}
	remove_a_perticular_proxy_entry(index);
	if (total_proxy_entries == 0)
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void remove_a_perticular_proxy_entry(USHORT index)
{
	STRUCT_PROXY_ENTRY proxy_entry;
	PARAMETER_NODE* last_displayed_proxy_entry;

	proxy_entry = contents_of_proxy_entry_page[index-1];
   if (contents_of_proxy_entry_page[index-1].protocol == 6)
      proxy_entry.protocol = 0;
   else
      proxy_entry.protocol = 1;

	if (cm_remove_string(CM_PROXY_SECTION, "Proxy", (void*)&proxy_entry) != CM_REMOVING_STRING_SUCCESSFUL)
	{
		printf("Failed to remove the Proxy Entry\n");
		return;
	}

	last_displayed_proxy_entry = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (index == 10)
	{
		if (proxy_entries_till_current_page == total_proxy_entries)
		{
			last_displayed_proxy_entry = last_displayed_proxy_entry->previous;
			proxy_entries_till_current_page --;
		}
		else
		{
			last_displayed_proxy_entry = last_displayed_proxy_entry->next;
		}
	}
	else
	if (index == total_proxy_entries)
	{
			last_displayed_proxy_entry = last_displayed_proxy_entry->previous;
			proxy_entries_till_current_page --;
	}
	else
	if(proxy_entries_till_current_page < 10)
	{
			proxy_entries_till_current_page --;
	}
	next_proxy_entry_from_where_display_is_reqd_to_continue(last_displayed_proxy_entry, TRUE);

/*	total_proxy_entries --;*/
	total_proxy_entries = get_the_number_of_proxy_entries();


	/* if the first node is deleted take care */
	if (total_proxy_entries == 0)
	{
		ptr_to_start_of_proxy_entries = NULL;	
		return;
	}
	if (proxy_entries_till_current_page  <= 10 && index == 1)
	{
		 ptr_to_start_of_proxy_entries = ptr_to_start_of_proxy_entries->next;
	}
}

void display_the_proxy_entry_for_editing(Request_t* request, STRUCT_PROXY_ENTRY* proxy_entry)
{
	BYTE* buffer, temp_buffer[20];
	USHORT search_to_start_at;

	buffer = malloc(strlen(EDIT_PROXY_ENTRY_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a Proxy Entry for editing\n");
		return;
	}
	strcpy(buffer, EDIT_PROXY_ENTRY_data_ptr);


   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_entry->protocol == 0x0006, 0); 
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, proxy_entry->protocol == 0x0011, search_to_start_at); 
   sprintf(temp_buffer, "%d", proxy_entry->port);
   search_to_start_at = search_and_replace("#___TEXT___#___", temp_buffer, buffer, TRUE, search_to_start_at);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_proxy_entry_1(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[0];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(1, TRUE);
}

void display_edit_proxy_entry_2(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[1];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(2, TRUE);
}

void display_edit_proxy_entry_3(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[2];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(3, TRUE);
}

void display_edit_proxy_entry_4(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[3];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(4, TRUE);
}

void display_edit_proxy_entry_5(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[4];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(5, TRUE);
}

void display_edit_proxy_entry_6(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[5];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(6, TRUE);
}

void display_edit_proxy_entry_7(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[6];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(7, TRUE);
}

void display_edit_proxy_entry_8(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[7];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(8, TRUE);
}

void display_edit_proxy_entry_9(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[8];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(9, TRUE);
}

void display_edit_proxy_entry_10(Request_t* request)
{
	STRUCT_PROXY_ENTRY  proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	proxy_entry = contents_of_proxy_entry_page[9];
	display_the_proxy_entry_for_editing(request, &proxy_entry);
	save_the_number_of_proxy_entry_being_edited(10, TRUE);
}

void display_next_ten_proxy_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_proxy_entries_from(request, temp_ptr, TRUE);
}

void display_prev_ten_proxy_entries(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (proxy_entries_till_current_page <= 2*NUMBER_OF_ENTRIES_PER_PAGE)
	{
		for(i=1;i<proxy_entries_till_current_page;++i)
		{
			temp_ptr = cm_get_previous_entry(CM_PROXY_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		proxy_entries_till_current_page = 0;
	}
	else
	{
		for(i=1;i<NUMBER_OF_ENTRIES_PER_PAGE+(proxy_entries_till_current_page%NUMBER_OF_ENTRIES_PER_PAGE?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE);++i)
		{
			temp_ptr = cm_get_previous_entry(CM_PROXY_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		proxy_entries_till_current_page -= (NUMBER_OF_ENTRIES_PER_PAGE+(proxy_entries_till_current_page%NUMBER_OF_ENTRIES_PER_PAGE?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE));
	}
	display_ten_proxy_entries_from(request, temp_ptr, TRUE);
}

void display_ten_proxy_entries_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page;
	USHORT i, search_to_start_at = 0;
	STRUCT_PROXY_ENTRY temp_proxy_entry;
	PARAMETER_NODE* node, *prev_node;
	static BYTE number_of_entries_read_in_the_current_node = 0;

	first_proxy_entry_of_the_current_page(starting_from, TRUE);

	if(proxy_entries_till_current_page  == total_proxy_entries)
	{
		InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display Proxy Entry list.\n");
		return;
	}

	strcpy(temp_page, VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr);

	node =  cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0;
	while (node != starting_from)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i=0; i<number_of_entries_read_in_the_current_node ;++i)
		{
			if (!node)
			{
				return;
			}
			node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
		}
	}
	number_of_entries_read_in_the_current_node = 0;
	prev_node = starting_from;

	for(i=0;i < NUMBER_OF_ENTRIES_PER_PAGE;++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = modify_the_proxy_entry_template(temp_page, &temp_proxy_entry, search_to_start_at);
		contents_of_proxy_entry_page[i] =  temp_proxy_entry;

		proxy_entries_till_current_page++;
		if ((proxy_entries_till_current_page  == total_proxy_entries && is_displaying_next_page)
		    || (proxy_entries_till_current_page  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_proxy_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{
				/* if some Proxy Entry in the previous page enable the link hence disable */

				/* No More Proxy Entries are there hence remove the link */
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_proxy_entries > NUMBER_OF_ENTRIES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at);
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
		if (is_displaying_next_page)
		{
			starting_from = cm_get_next_entry(CM_PROXY_SECTION, starting_from, (void*)&temp_proxy_entry);
/*			proxy_entries_till_current_page++;*/
		}
		else
		{
			starting_from = cm_get_previous_entry(CM_PROXY_SECTION, starting_from, NULL);
			proxy_entries_till_current_page--;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++;
		else
      {
			number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(i+1, search_to_start_at, temp_page);
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_proxy_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);

	/* Check if back link is required or not */

	/* Check if forward link is required or not */
	if (total_proxy_entries > proxy_entries_till_current_page)
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

	InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_PROXY_ENTRY_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}
/*
void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node)
{
	USHORT i=0, j=0;

	if (node == NULL)
	{
		buffer[0] = 0;
		return;
	}

	while(node->parameter[i] != '=')
	{
		++i;
	}
  	i+=2;
	while(node->parameter[i] != '\0' &&	node->parameter[i] != '\n' && node->parameter[i] != '\r')
		buffer[j++] = node->parameter[i++];
  buffer[j] = 0;
}
*/
USHORT modify_the_proxy_entry_template(BYTE* buffer, STRUCT_PROXY_ENTRY* proxy_entry, USHORT search_to_start_at)
{
   BYTE temp_buffer[100];

   if (proxy_entry->protocol == 0x0006)
      strcpy(temp_buffer, "TCP");
   else
      strcpy(temp_buffer, "UDP");

	search_to_start_at = search_and_replace("#_PRT", temp_buffer, buffer, TRUE, 0);
   match_the_port_number_to_name(proxy_entry->port, temp_buffer);
	search_to_start_at = search_and_replace("#_______________________________________________________PORT", temp_buffer, buffer, TRUE, 0);
   return (search_to_start_at);
}


USHORT get_the_number_of_proxy_entries()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	STRUCT_PROXY_ENTRY temp_proxy_entry;

	node = cm_get_first_entry(CM_PROXY_SECTION, "Proxy", (void*)&temp_proxy_entry);
	while (node)
	{
		node = cm_get_next_entry(CM_PROXY_SECTION, node, (void*)&temp_proxy_entry);
		count ++;	
	}
	return count;
}

void change_the_edited_proxy_entry(Request_t* request)
{
	EDIT_PROXY_ENTRY_form_output_type* edited_proxy_entry;
	BYTE edited_proxy_entry_index;
	enum CM_EDIT_STRING_RESULTS result;
	STRUCT_PROXY_ENTRY new_proxy_entry, old_proxy_entry;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	edited_proxy_entry = (EDIT_PROXY_ENTRY_form_output_type*)form_data_of_request(request);

	if (!strcmp(edited_proxy_entry->delete_entry, "Delete"))
	{
		delete_the_proxy_entry(request);
		return;
	}

   if (!strcmpi(edited_proxy_entry->choose, "Choose From List..."))
   {
      display_port_list_called_from(EDIT_ENTRY, TRUE);
      if (!(edited_proxy_entry->protocol))
         display_the_list_for_tcp(request);
      else
         display_the_list_for_udp(request);
      return;
   }

   if (!is_numeric(edited_proxy_entry->port))
   {
      printf("Invalid Port Number Failed to change Proxy Entry\n");
   	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return;
   }

	edited_proxy_entry_index = save_the_number_of_proxy_entry_being_edited(NULL, FALSE);
	old_proxy_entry = contents_of_proxy_entry_page[edited_proxy_entry_index-1];
   if (old_proxy_entry.protocol == 6)
      old_proxy_entry.protocol = 0;
   else
      old_proxy_entry.protocol = 1;

	new_proxy_entry.protocol = edited_proxy_entry->protocol;
	new_proxy_entry.port = atoi(edited_proxy_entry->port);

   result = cm_edit_string(CM_PROXY_SECTION, "Proxy", (void*)&old_proxy_entry, (void*)&new_proxy_entry);
	if (result != CM_STRING_EDIT_SUCCESSFUL)
	{
		printf("Configuration manager refused to make the changes \n");
	}
	InitReturnBuffer(request, PROXY_MENU_data_ptr, strlen(PROXY_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_proxy_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ENTRIES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_proxy_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}
#if 0 /* Function not used */
void go_back_to_proxy_entry_listing_page(Request_t* request)
{
	PARAMETER_NODE* temp_node;
	BYTE index;
	temp_node = next_proxy_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (proxy_entries_till_current_page%10)?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE;

	temp_node = first_proxy_entry_of_the_current_page(NULL, FALSE);

	proxy_entries_till_current_page -= ((proxy_entries_till_current_page%10)?proxy_entries_till_current_page:NUMBER_OF_ENTRIES_PER_PAGE);
		
	next_proxy_entry_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_proxy_entries(request);
}
#endif


PARAMETER_NODE* next_proxy_entry_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 

PARAMETER_NODE* first_proxy_entry_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = new_node;
	else
		return saved_node;
}

BYTE is_numeric(BYTE* buffer)
{
   BYTE i;
   for (i=0 ; i<strlen(buffer) ; ++i)
   {
      if (buffer[i] < '0' || buffer[i] > '9')
         return FALSE;
   }
   return TRUE;   
}

