#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include <socklib.h>
#include <stddef.h>

#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\apputil.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"

#include "\rtrware\store\boot.h"

#include <incall.h>
#include <cfgmgr.h>

#include "..\..\genapps\src\strout.h"
#include "STAT1.H"
#include "STAT2.H"

#include "stat.h"


/*  Proxy Statistics for web clients __PCS__  */


#define STATUS_STR_LEN	23
#define USER_NAME_LEN	30
#define USHORT_LEN		6
#define ULONG_LEN		14
#define CLIENT_PULL_NOF_SECONDS		10
#define MODEM_TYPE_LEN  50
#if 0
#define WEB_STAT_DEBUG
#endif

char *port_status_descriptor[] =
{
   "Idle                  ",
   "Off-line              ",
   "Wan Link Up           ",
   "LCP Layer Up          ",
   "PPP Client Up         ",
   "MLPPP Client Up       ",
   "Sending Init Command  ",
   "Waiting For OK        ",
   "Dialing Number        ",
   "Waiting For Connection",
/* Sachin 09/11/1997 */
   "SLIP Client Up        ",
   "Disabled              ",
/* Sachin 09/11/1997 */
   "Unknown State         ",
   NULL
};


BYTE NUMBER_OF_CALLS[] = "#________CALLS";
BYTE TOTAL_BYTES_SENT[] = "#__T_BYTE_SENT";
BYTE TOTAL_BYTES_RECEIVED[] = "#__T_BYTE_RECV";
BYTE TOTAL_PACKETS_SENT[] = "#__T_PACK_SENT";
BYTE TOTAL_PACKETS_RECEIVED[] = "#__T_PACK_RECV";
BYTE CURRENT_BYTES_SENT[] = "#__C_BYTE_SENT";
BYTE CURRENT_BYTES_RECEIVED[] = "#__C_BYTE_RECV";
BYTE CURRENT_PACKETS_SENT[] = "#__C_PACK_SENT";
BYTE CURRENT_PACKETS_RECEIVED[] = "#__C_PACK_RECV";
BYTE PORT_STATUS[] = "#_______________STATUS";
BYTE BAUD_RATE[] = "#_________BAUD";
BYTE PORT[] = "#_PORT";
BYTE USER_NAME[] = "#_____________________USERNAME";
BYTE MODEM_TYPE[] = "#_______________________MODEM";
BYTE CURRENT_UPTIME[] = "#___C_UPTIME";
BYTE TOTAL_UPTIME[] = "#___T_UPTIME";
BYTE CONNECT_MESG[] = "#______________________________CONNECT";
BYTE LOCAL_IP_ADDR[] = "#____LOCAL_ADDR";
BYTE REMOTE_IP_ADDR[] = "#___REMOTE_ADDR";
BYTE IP_ADDR_MASK[] = "#__________MASK";

#if 0
void display_main_statistics_page(Request_t* request)
{
	BYTE	number_of_calls[ULONG_LEN], up_time[ULONG_LEN];
	BYTE	number_of_tx_bytes[ULONG_LEN], number_of_rx_bytes[ULONG_LEN];
	BYTE	number_of_tx_packets[ULONG_LEN], number_of_rx_packets[ULONG_LEN];
	BYTE	port_stat, port_conxn_status[STATUS_STR_LEN];
	ULONG	baud;
	BYTE	baud_rate[ULONG_LEN];
	BYTE	*buffer;
	ULONG	nof_calls = 0, nof_ports = 0;
	ULONG	nof_tx_bytes = 0, nof_rx_bytes = 0;
	ULONG	nof_tx_packets = 0, nof_rx_packets = 0;
	ULONG	conxn_up_time = 0;
	USHORT	search_to_start_at = 0, i;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE*)malloc(strlen(MAIN_STATISTICS_PAGE_data_ptr));
	if (buffer == NULL) {
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Insufficient memory...\n");
#endif
		return;
	}

	strcpy(buffer, MAIN_STATISTICS_PAGE_data_ptr);

	nof_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: %d WAN ports present\n", nof_ports);
#endif


	for (i = 0; i < nof_ports; i++) {
		nof_calls += get_number_of_calls(i);
		nof_tx_bytes += get_aggregate_tx_count(i);
		nof_rx_bytes += get_aggregate_rx_count(i);
		nof_tx_packets += get_aggregate_tx_packet_count(i);
		nof_rx_packets += get_aggregate_rx_packet_count(i);
		conxn_up_time += get_aggregate_connection_time(i);
	}

#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Number of calls(total) is %u\n", nof_calls);
	printf("WEB STAT: %u number of TX bytes(total)\n", nof_tx_bytes);
	printf("WEB STAT: %u number of RX bytes(total)\n", nof_rx_bytes);
	printf("WEB STAT: %u number of TX packets(total)\n", nof_tx_packets);
	printf("WEB STAT: %u number of RX packets(total)\n", nof_rx_packets);
	printf("WEB STAT: %u seconds Uptime(total)\n", conxn_up_time);
#endif

	sprintf(number_of_tx_packets, "%u\0", nof_tx_packets);
	sprintf(number_of_rx_bytes, "%u\0", nof_rx_bytes);
	sprintf(number_of_rx_packets, "%u\0", nof_rx_packets);
	sprintf(number_of_tx_bytes, "%u\0", nof_tx_bytes);
   sprintf(number_of_calls, "%u\0", nof_calls);
	seconds_to_str(conxn_up_time, up_time);
	
	search_to_start_at = search_and_replace(TOTAL_PACKETS_RECEIVED, number_of_rx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_RECEIVED, number_of_rx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_PACKETS_SENT, number_of_tx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_SENT, number_of_tx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(NUMBER_OF_CALLS, number_of_calls, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_UPTIME, up_time, buffer, TRUE, search_to_start_at);

	for (i = 0; i < nof_ports; i++) 
   {
		port_stat = get_port_status(i);
		get_port_status_str(i, port_conxn_status);
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Port status of WAN port %d is %d: %s\n", i+1, port_stat, port_conxn_status);
#endif
		search_to_start_at = search_and_replace(PORT_STATUS, port_conxn_status, buffer, TRUE, search_to_start_at);

		baud = get_baud_rate(i);
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Baud rate for WAN port %d is %u\n", i+1, baud);
#endif
		sprintf(baud_rate, "%u\0", baud);
		search_to_start_at = search_and_replace(BAUD_RATE, baud_rate, buffer, TRUE, search_to_start_at);
	}


	SetClientPull(request, CLIENT_PULL_NOF_SECONDS, NULL);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}
#endif

void display_main_statistics_page(Request_t* request)
{
	BYTE	number_of_calls[ULONG_LEN], up_time[ULONG_LEN];
	BYTE	number_of_tx_bytes[ULONG_LEN], number_of_rx_bytes[ULONG_LEN];
	BYTE	number_of_tx_packets[ULONG_LEN], number_of_rx_packets[ULONG_LEN];
	BYTE	port_stat, port_conxn_status[STATUS_STR_LEN];
	ULONG	baud;
	BYTE	baud_rate[ULONG_LEN];
	BYTE	*buffer;
	ULONG	nof_calls = 0, nof_ports = 0;
	ULONG	nof_tx_bytes = 0, nof_rx_bytes = 0;
	ULONG	nof_tx_packets = 0, nof_rx_packets = 0;
	ULONG	conxn_up_time = 0;
	USHORT	search_to_start_at = 0, i;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE*)malloc(strlen(MAIN_STATISTICS_PAGE_data_ptr));
	if (buffer == NULL) {
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Insufficient memory...\n");
#endif
		return;
	}

	strcpy(buffer, MAIN_STATISTICS_PAGE_data_ptr);

   check_for_model_number_and_replace_in_filters (buffer) ;
	nof_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: %d WAN ports present\n", nof_ports);
#endif

	for (i = 0; i < nof_ports; i++) 
   {
		port_stat = get_port_status(i);
		get_port_status_str(i, port_conxn_status);
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Port status of WAN port %d is %d: %s\n", i+1, port_stat, port_conxn_status);
#endif
		search_to_start_at = search_and_replace(PORT_STATUS, port_conxn_status, buffer, TRUE, search_to_start_at);

		baud = get_baud_rate(i);
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Baud rate for WAN port %d is %u\n", i+1, baud);
#endif
		sprintf(baud_rate, "%u\0", baud);
		search_to_start_at = search_and_replace(BAUD_RATE, baud_rate, buffer, TRUE, search_to_start_at);
	}

	for (i = 0; i < nof_ports; i++) 
   {
		nof_rx_packets += get_aggregate_rx_packet_count(i);
		nof_rx_bytes += get_aggregate_rx_count(i);
		nof_tx_packets += get_aggregate_tx_packet_count(i);
		nof_tx_bytes += get_aggregate_tx_count(i);
		nof_calls += get_number_of_calls(i);
		conxn_up_time += get_aggregate_connection_time(i);
	}

#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Number of calls(total) is %u\n", nof_calls);
	printf("WEB STAT: %u number of TX bytes(total)\n", nof_tx_bytes);
	printf("WEB STAT: %u number of RX bytes(total)\n", nof_rx_bytes);
	printf("WEB STAT: %u number of TX packets(total)\n", nof_tx_packets);
	printf("WEB STAT: %u number of RX packets(total)\n", nof_rx_packets);
	printf("WEB STAT: %u seconds Uptime(total)\n", conxn_up_time);
#endif

	sprintf(number_of_rx_packets, "%u\0", nof_rx_packets);
	sprintf(number_of_rx_bytes, "%u\0", nof_rx_bytes);
	sprintf(number_of_tx_packets, "%u\0", nof_tx_packets);
	sprintf(number_of_tx_bytes, "%u\0", nof_tx_bytes);
   sprintf(number_of_calls, "%u\0", nof_calls);
	seconds_to_str(conxn_up_time, up_time);
	
	search_to_start_at = search_and_replace(TOTAL_PACKETS_RECEIVED, number_of_rx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_RECEIVED, number_of_rx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_PACKETS_SENT, number_of_tx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_SENT, number_of_tx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(NUMBER_OF_CALLS, number_of_calls, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_UPTIME, up_time, buffer, TRUE, search_to_start_at);

	SetClientPull(request, CLIENT_PULL_NOF_SECONDS, NULL);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}



void display_port1_statistics_page(Request_t* request)
{
	display_port_statistics_page(request, 0);
}



void display_port2_statistics_page(Request_t* request)
{
	display_port_statistics_page(request, 1);
}



void display_port3_statistics_page(Request_t* request)
{
	display_port_statistics_page(request, 2);
}



void display_port_statistics_page(Request_t* request, USHORT port_number)
{
	BYTE	port_num[USHORT_LEN];
	BYTE	user_name[USER_NAME_LEN];
	BYTE	modem_type[MODEM_TYPE_LEN];
	ULONG	conxn_up_time;
	BYTE	up_time[12];
	BYTE	connect_message[38];
	BYTE	port_conxn_status[STATUS_STR_LEN], port_stat;
	ULONG	ip_address;
	BYTE	ip_address_str[15];
	ULONG	nof_calls = 0;
	BYTE	number_of_calls[ULONG_LEN];
	ULONG	nof_tx_bytes = 0, nof_rx_bytes = 0;
	ULONG	nof_tx_packets = 0, nof_rx_packets = 0;
	BYTE	number_of_tx_bytes[ULONG_LEN], number_of_rx_bytes[ULONG_LEN];
	BYTE	number_of_tx_packets[ULONG_LEN], number_of_rx_packets[ULONG_LEN];
	ULONG	baud;
	BYTE	baud_rate[ULONG_LEN];
	BYTE	*buffer;
	USHORT	search_to_start_at = 0;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	buffer = (BYTE*)malloc(strlen(PORT_STATISTICS_PAGE_data_ptr));
	if (buffer == NULL) {
#ifdef WEB_STAT_DEBUG
		printf("WEB STAT: Insufficient memory...\n");
#endif
		return;
	}

	strcpy(buffer, PORT_STATISTICS_PAGE_data_ptr);

	sprintf(port_num, "%d\0", port_number+1);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Details of WAN port %d...\n", port_number+1);
#endif
	search_to_start_at = search_and_replace("#_PORT", port_num, buffer, TRUE, search_to_start_at);

   baud = get_baud_rate(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Baud rate is %u\n", baud);
#endif
	sprintf(baud_rate, "%u\0", baud);
	search_to_start_at = search_and_replace(BAUD_RATE, baud_rate, buffer, TRUE, search_to_start_at);

	get_ppp_user_name(port_number, user_name, USER_NAME_LEN);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: User name is %s\n", user_name);
#endif
	search_to_start_at = search_and_replace(USER_NAME, user_name, buffer, TRUE, search_to_start_at);


	get_modem_name(port_number, modem_type, MODEM_TYPE_LEN);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Modem type is %s\n", modem_type);
#endif
	process_back_slash(modem_type);
	search_to_start_at = search_and_replace(MODEM_TYPE, modem_type, buffer, TRUE, search_to_start_at);

	conxn_up_time = get_connection_up_time(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Connection uptime is %u seconds\n", conxn_up_time);
#endif
	seconds_to_str(conxn_up_time, up_time);
	search_to_start_at = search_and_replace(CURRENT_UPTIME, up_time, buffer, TRUE, search_to_start_at);

	get_modem_connect_message(port_number, connect_message, 38);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Connect message is %s\n", connect_message);
#endif
	search_to_start_at = search_and_replace(CONNECT_MESG, connect_message, buffer, TRUE, search_to_start_at);

	port_stat = get_port_status(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Port status is %d\n", port_stat);
#endif
	get_port_status_str(port_number, port_conxn_status);
	search_to_start_at = search_and_replace(PORT_STATUS, port_conxn_status, buffer, TRUE, search_to_start_at);

	ip_address = proxy_get_local_ip_address(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Local IP address is %u\n", ip_address);
#endif
	ulong_to_dot_format(ip_address_str, ip_address);
	search_to_start_at = search_and_replace(LOCAL_IP_ADDR, ip_address_str, buffer, TRUE, search_to_start_at);

	ip_address = proxy_get_remote_ip_address(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Remote IP address is %u\n", ip_address);
#endif
	ulong_to_dot_format(ip_address_str, ip_address);
	search_to_start_at = search_and_replace(REMOTE_IP_ADDR, ip_address_str, buffer, TRUE, search_to_start_at);

	ip_address = proxy_get_subnet_mask(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Subnet address mask is %u\n", ip_address);
#endif
	ulong_to_dot_format(ip_address_str, ip_address);
	search_to_start_at = search_and_replace(IP_ADDR_MASK, ip_address_str, buffer, TRUE, search_to_start_at);

	nof_rx_packets = get_connection_rx_packet_count(port_number);
	nof_rx_bytes = get_connection_rx_count(port_number);
	nof_tx_packets = get_connection_tx_packet_count(port_number);
	nof_tx_bytes = get_connection_tx_count(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: %u number of TX bytes\n", nof_tx_bytes);
	printf("WEB STAT: %u number of RX bytes\n", nof_rx_bytes);
	printf("WEB STAT: %u number of TX packets\n", nof_tx_packets);
	printf("WEB STAT: %u number of RX packets\n", nof_rx_packets);
#endif
	
   sprintf(number_of_rx_packets, "%u\0", nof_rx_packets);
	sprintf(number_of_rx_bytes, "%u\0", nof_rx_bytes);
	sprintf(number_of_tx_packets, "%u\0", nof_tx_packets);
	sprintf(number_of_tx_bytes, "%u\0", nof_tx_bytes);
 
   search_to_start_at = search_and_replace(CURRENT_PACKETS_RECEIVED, number_of_rx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(CURRENT_BYTES_RECEIVED, number_of_rx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(CURRENT_PACKETS_SENT, number_of_tx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(CURRENT_BYTES_SENT, number_of_tx_bytes, buffer, TRUE, search_to_start_at);

	conxn_up_time = get_aggregate_connection_time(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: %u seconds total uptime\n", conxn_up_time);
#endif
	seconds_to_str(conxn_up_time, up_time);
	search_to_start_at = search_and_replace(TOTAL_UPTIME, up_time, buffer, TRUE, search_to_start_at);

	nof_calls = get_number_of_calls(port_number);
#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: Number of calls is %u\n", nof_calls);
#endif
	sprintf(number_of_calls, "%u\0", nof_calls);
	search_to_start_at = search_and_replace(NUMBER_OF_CALLS, number_of_calls, buffer, TRUE, search_to_start_at);

	nof_rx_packets = get_aggregate_rx_packet_count(port_number);
	nof_rx_bytes = get_aggregate_rx_count(port_number);
	nof_tx_packets = get_aggregate_tx_packet_count(port_number);
	nof_tx_bytes = get_aggregate_tx_count(port_number);

#ifdef WEB_STAT_DEBUG
	printf("WEB STAT: %u number of TX bytes(total)\n", nof_tx_bytes);
	printf("WEB STAT: %u number of RX bytes(total)\n", nof_rx_bytes);
	printf("WEB STAT: %u number of TX packets(total)\n", nof_tx_packets);
	printf("WEB STAT: %u number of RX packets(total)\n", nof_rx_packets);
#endif

	sprintf(number_of_rx_packets, "%u\0", nof_rx_packets);
	sprintf(number_of_rx_bytes, "%u\0", nof_rx_bytes);
	sprintf(number_of_tx_packets, "%u\0", nof_tx_packets);
	sprintf(number_of_tx_bytes, "%u\0", nof_tx_bytes);
	
	search_to_start_at = search_and_replace(TOTAL_PACKETS_RECEIVED, number_of_rx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_RECEIVED, number_of_rx_bytes, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_PACKETS_SENT, number_of_tx_packets, buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace(TOTAL_BYTES_SENT, number_of_tx_bytes, buffer, TRUE, search_to_start_at);

	SetClientPull(request, CLIENT_PULL_NOF_SECONDS, NULL);
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}



char* seconds_to_str(ULONG seconds, char* time_str)
{
	int	days, hours, minutes;

	days = seconds / 86400;
	seconds %= 86400;

	hours = seconds / 3600;
	seconds %= 3600;

	minutes = seconds / 60;
	seconds %= 60;

	sprintf(time_str, "%03d:%02d:%02d:%02d\0", days, hours, minutes, seconds);

	return time_str;
}


char* get_port_status_str(USHORT port_number, char* port_status_str)
{
	BYTE	port_stat;

	port_stat = get_port_status(port_number);

	strcpy(port_status_str, port_status_descriptor[port_stat]);

	return port_status_str;
}
