#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"


#include "adstpflt.h"
#include "edtstpfl.h"
#include "vedstpflt.h"
#include "stpflt.h"
#include "edtstpfm.h"
#include "adstpfm.h"
#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
/*...Extern Decleration*/

/* Local ProtoType ...*/
void display_the_stp_filter_for_editing(Request_t* request, STRUCT_STP_FILTER* stp_filter);
void display_ten_stp_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page);
void display_prev_stp_filters(Request_t* request);
void display_next_ten_stp_filters(Request_t* request);
/*void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node);*/
USHORT modify_the_stp_template(BYTE* buffer, STRUCT_STP_FILTER* stp_filter, USHORT search_to_start_at);
USHORT get_the_number_of_stp_filters();
void change_the_edited_stp_filters(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_stp_filter_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_to_stp_filter_listing_page(Request_t* request);
BYTE save_the_number_of_stp_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
USHORT enable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT enable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_the_link_to_display_prev_10(BYTE* buffer, USHORT search_to_start_at);
BYTE save_whether_next_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
BYTE save_whether_prev_link_is_enabled_or_not(BYTE the_status, BYTE is_required_to_save);
PARAMETER_NODE* next_stp_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save);
void remove_a_perticular_stp_filter(USHORT index);
PARAMETER_NODE* first_stp_filter_of_the_current_page(PARAMETER_NODE* new_value, BYTE is_required_to_save);
/* ... Local ProtoType*/

#if 0
BYTE* types_of_filters[] =
{
	"Filter on Destination Address",
	"Filter on Source Address",
	"Forward on Destination Address",
	"Forward on Source Address"
};

BYTE* types_of_ports[] = 
{
	"LAN",
	"WAN1",
	"WAN2",
	"WAN3"
};
#endif

extern BYTE* types_of_filters[];
extern BYTE* types_of_ports[];


PARAMETER_NODE* ptr_to_start_of_stp_filters, *ptr_to_first_stp_filter_of_current_page;
USHORT stp_filters_till_current_page = 0, total_stp_filters = 0;
STRUCT_STP_FILTER contents_of_stp_filter_page[NUMBER_OF_ROUTES_PER_PAGE];

void display_stp_filter_menu(Request_t* request)
{
	BYTE rhs_string[200];  
	STRUCT_STP_FILTER temp_stp_struct;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	
	ptr_to_first_stp_filter_of_current_page = ptr_to_start_of_stp_filters = cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&temp_stp_struct);
	stp_filters_till_current_page = 0;
	if (ptr_to_start_of_stp_filters)
		total_stp_filters = get_the_number_of_stp_filters();
	InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_add_stp_filter_form (Request_t* request)
{

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	InitReturnBuffer(request, ADD_STP_FILTER_data_ptr, strlen(ADD_STP_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_ved_stp_filters_page(Request_t* request)
{
	STRUCT_STP_FILTER temp_stp_struct;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	ptr_to_first_stp_filter_of_current_page = ptr_to_start_of_stp_filters = cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&temp_stp_struct);
	if (ptr_to_start_of_stp_filters)
		total_stp_filters = get_the_number_of_stp_filters();
	if (!total_stp_filters)
	{
		InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;	
	}

	stp_filters_till_current_page = 0;
	save_whether_next_link_is_enabled_or_not(TRUE, TRUE);
	save_whether_prev_link_is_enabled_or_not(TRUE, TRUE);
	next_stp_filter_from_where_display_is_reqd_to_continue(ptr_to_start_of_stp_filters, TRUE);
	display_next_ten_stp_filters(request);
}

void add_the_stp_filter(Request_t* request)
{
	PARAMETER_NODE* new_node;
	ADD_STP_FILTER_form_output_type*  stp_filter_to_add;
	BYTE temp_string[200];
	STRUCT_STP_FILTER stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter_to_add = (ADD_STP_FILTER_form_output_type*) form_data_of_request(request);

	/* ### pending  -> stp_filter */
	strcpy(stp_filter.ethernet_address, stp_filter_to_add->ethernet_address);
	stp_filter.physical_port = stp_filter_to_add->port;
	stp_filter.filter_type = stp_filter_to_add->filter_type;

	new_node = cm_insert_string(CM_SPANTREE_SECTION, "STP Filter", (void*)&stp_filter);
	if (new_node == NULL)
	{
		printf("Failed to Insert the STP Filter\n");
		InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	if (ptr_to_start_of_stp_filters == NULL)
		ptr_to_first_stp_filter_of_current_page = ptr_to_start_of_stp_filters = new_node;
	total_stp_filters ++;
	InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void delete_the_stp_filter(Request_t* request)
{
	BYTE index;
	PARAMETER_NODE* node, *prev_first_node_of_the_page;
	STRUCT_STP_FILTER stp_filter;


/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	index = save_the_number_of_stp_filter_being_edited(NULL, FALSE);
	if (index == 1)
	{
		prev_first_node_of_the_page = first_stp_filter_of_the_current_page(NULL, FALSE);
		
		node =  cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&stp_filter);
		while (node != prev_first_node_of_the_page)
		{
			node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&stp_filter);
		}
		node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&stp_filter);

		if (node)
			first_stp_filter_of_the_current_page(node, TRUE);
	}
	remove_a_perticular_stp_filter(index);
	if (total_stp_filters == 0)
	{
		InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
	InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
/*	go_back_to_stp_filter_listing_page(request);*/
}

void remove_a_perticular_stp_filter(USHORT index)
{
	BYTE buffer[200];
	STRUCT_STP_FILTER stp_filter;
	PARAMETER_NODE* last_displayed_stp_filter;

	stp_filter = contents_of_stp_filter_page[index-1];
	if (cm_remove_string(CM_SPANTREE_SECTION, "STP Filter", (void*)&stp_filter) != CM_REMOVING_STRING_SUCCESSFUL)
	{
		printf("Failed to remove the STP Filter \n");
		return;
	}

	last_displayed_stp_filter = next_stp_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (index == 10)
	{
		if (stp_filters_till_current_page == total_stp_filters)
		{
			last_displayed_stp_filter = last_displayed_stp_filter->previous;
			stp_filters_till_current_page --;
		}
		else
		{
			last_displayed_stp_filter = last_displayed_stp_filter->next;
		}
	}
	else
	if (index == total_stp_filters)
	{
			last_displayed_stp_filter = last_displayed_stp_filter->previous;
			stp_filters_till_current_page --;
	}
	else
	if(stp_filters_till_current_page < 10)
	{
			stp_filters_till_current_page --;
	}
	next_stp_filter_from_where_display_is_reqd_to_continue(last_displayed_stp_filter, TRUE);
	total_stp_filters --;

	/* if the first node is deleted take care */
	if (total_stp_filters == 0)
	{
		ptr_to_start_of_stp_filters = NULL;	
		return;
	}
	if (stp_filters_till_current_page  <= 10 && index == 1)
	{
		 ptr_to_start_of_stp_filters = ptr_to_start_of_stp_filters->next;
	}
}

void display_the_stp_filter_for_editing(Request_t* request, STRUCT_STP_FILTER* stp_filter)
{
	BYTE* buffer, i;
	USHORT search_to_start_at;

	buffer = malloc(strlen(EDIT_STP_FILTER_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a STP filter for editing\n");
		return;
	}
	strcpy(buffer, EDIT_STP_FILTER_data_ptr);
     
	search_to_start_at = search_and_replace("#_ETHER_AD_#", stp_filter->ethernet_address, buffer, TRUE, 0);

	for(i=0 ; i<stp_filter->physical_port ; ++i)
	{
		search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, FALSE, search_to_start_at);
	}
	search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, TRUE, search_to_start_at);
	/* Skip other options in the Port */
	search_to_start_at = search_and_replace("</SELECT>", "", buffer, FALSE, search_to_start_at);

	for(i=0 ; i<stp_filter->filter_type ; ++i)
	{
		search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, FALSE, search_to_start_at);
	}
	search_to_start_at = search_and_replace("#_SELECT", "selected", buffer, TRUE, search_to_start_at);
	/* Skip other options in the Port */
	search_to_start_at = search_and_replace("</SELECT>", "", buffer, FALSE, search_to_start_at);
           
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_edit_stp_filter_1(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[0];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(1, TRUE);
}

void display_edit_stp_filter_2(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[1];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(2, TRUE);
}

void display_edit_stp_filter_3(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[2];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(3, TRUE);
}

void display_edit_stp_filter_4(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[3];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(4, TRUE);
}

void display_edit_stp_filter_5(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[4];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(5, TRUE);
}

void display_edit_stp_filter_6(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[5];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(6, TRUE);
}

void display_edit_stp_filter_7(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[6];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(7, TRUE);
}

void display_edit_stp_filter_8(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[7];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(8, TRUE);
}

void display_edit_stp_filter_9(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[8];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(9, TRUE);
}

void display_edit_stp_filter_10(Request_t* request)
{
	STRUCT_STP_FILTER  stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	stp_filter = contents_of_stp_filter_page[9];
	display_the_stp_filter_for_editing(request, &stp_filter);
	save_the_number_of_stp_filter_being_edited(10, TRUE);
}

void display_next_ten_stp_filters(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_stp_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_stp_filters_from(request, temp_ptr, TRUE);
}

void display_prev_ten_stp_filters(Request_t* request)
{
	PARAMETER_NODE* temp_ptr;
	USHORT i;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_stp_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (stp_filters_till_current_page <= 2*NUMBER_OF_ROUTES_PER_PAGE)
	{
		for(i=1;i<stp_filters_till_current_page;++i)
		{
			temp_ptr = cm_get_previous_entry(CM_SPANTREE_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		stp_filters_till_current_page = 0;
	}
	else
	{
		for(i=1;i<NUMBER_OF_ROUTES_PER_PAGE+(stp_filters_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?stp_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);++i)
		{
			temp_ptr = cm_get_previous_entry(CM_SPANTREE_SECTION, temp_ptr, NULL);
			if (temp_ptr == NULL)
			{
				break;
			}
		}
		stp_filters_till_current_page -= (NUMBER_OF_ROUTES_PER_PAGE+(stp_filters_till_current_page%NUMBER_OF_ROUTES_PER_PAGE?stp_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE));
	}
	display_ten_stp_filters_from(request, temp_ptr, TRUE);
}

void display_ten_stp_filters_from(Request_t* request, PARAMETER_NODE* starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page, buffer[100];
	USHORT i, j, k, search_to_start_at = 0;
	STRUCT_STP_FILTER temp_stp_struct;
	PARAMETER_NODE* node, *prev_node;
	static BYTE number_of_entries_read_in_the_current_node = 0;

	first_stp_filter_of_the_current_page(starting_from, TRUE);

	if(stp_filters_till_current_page  == total_stp_filters)
	{
		InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(VIEW_EDIT_DEL_STP_FILTER_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display STP Filter list.\n");
		return;
	}

	strcpy(temp_page, VIEW_EDIT_DEL_STP_FILTER_data_ptr);
	node =  cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&temp_stp_struct);
	if (node == starting_from)
		number_of_entries_read_in_the_current_node = 0;
	while (node != starting_from)
	{
		node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&temp_stp_struct);
	}
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i=0; i<number_of_entries_read_in_the_current_node ;++i)
		{
			if (!node)
			{
				return;
			}
			node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&temp_stp_struct);
		}
	}
	number_of_entries_read_in_the_current_node = 0;
	prev_node = starting_from;

	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE;++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = modify_the_stp_template(temp_page, &temp_stp_struct, search_to_start_at);
		contents_of_stp_filter_page[i] =  temp_stp_struct;

		stp_filters_till_current_page++;
		if ((stp_filters_till_current_page  == total_stp_filters && is_displaying_next_page)
		    || (stp_filters_till_current_page  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_stp_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_stp_filter_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{
				/* if some STP Filter in the previous page enable the link hence disable */

				/* No More STP Filter are there hence remove the link */
				search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			else
			{
				/* while displaying if we each first page just remove back link */

				/* While displaying if reach first page if there are some more pages enable forward link else remove forward link */
				if (total_stp_filters > NUMBER_OF_ROUTES_PER_PAGE)
					enable_the_link_to_display_next_10(temp_page, search_to_start_at);
				else
					disable_the_link_to_display_next_10(temp_page, search_to_start_at);
			}
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STP_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
		if (is_displaying_next_page)
		{
			starting_from = cm_get_next_entry(CM_SPANTREE_SECTION, starting_from, (void*)&temp_stp_struct);
/*			stp_filters_till_current_page++;*/
		}
		else
		{
			starting_from = cm_get_previous_entry(CM_SPANTREE_SECTION, starting_from, NULL);
			stp_filters_till_current_page--;
		}
		if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++;
		else
			number_of_entries_read_in_the_current_node = 0;

		prev_node = starting_from;
		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_stp_filter_to_display(i+1, search_to_start_at, temp_page);
			InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STP_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
			return;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_stp_filter_from_where_display_is_reqd_to_continue(starting_from, TRUE);

	/* Check if back link is required or not */

	/* Check if forward link is required or not */
	if (total_stp_filters > stp_filters_till_current_page)
		search_to_start_at = enable_the_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_the_link_to_display_next_10(temp_page, search_to_start_at);

	InitReturnBuffer(request, temp_page, strlen(VIEW_EDIT_DEL_STP_FILTER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}
/*
void get_rhs_string(BYTE* buffer, PARAMETER_NODE* node)
{
	USHORT i=0, j=0;

	if (node == NULL)
	{
		buffer[0] = 0;
		return;
	}

	while(node->parameter[i] != '=')
	{
		++i;
	}
  	i+=2;
	while(node->parameter[i] != '\0' &&	node->parameter[i] != '\n' && node->parameter[i] != '\r')
		buffer[j++] = node->parameter[i++];
  buffer[j] = 0;
}
*/
USHORT modify_the_stp_template(BYTE* buffer, STRUCT_STP_FILTER* stp_filter, USHORT search_to_start_at)
{
	search_to_start_at = search_and_replace("#__________IP__FILTER_TYPE______#", types_of_filters[stp_filter->filter_type], buffer, TRUE, 0);
	search_to_start_at = search_and_replace("#PORT#", types_of_ports[stp_filter->physical_port], buffer, TRUE, search_to_start_at);
	search_to_start_at = search_and_replace("#_ETHER_AD_#", stp_filter->ethernet_address, buffer, TRUE, search_to_start_at);
	return (search_to_start_at);
}


USHORT get_the_number_of_stp_filters()
{
	USHORT count = 0;
	PARAMETER_NODE* node;
	BYTE rhs_string[200];
	STRUCT_STP_FILTER temp_stp_struct;



	node = cm_get_first_entry(CM_SPANTREE_SECTION, "STP Filter", (void*)&temp_stp_struct);
	while (node)
	{
		node = cm_get_next_entry(CM_SPANTREE_SECTION, node, (void*)&temp_stp_struct);
		count ++;	
	}
	return count;
}

void change_the_edited_stp_filter(Request_t* request)
{
	CHANGE_THE_STP_FILTER_form_output_type* edited_stp_filter;
	BYTE edited_stp_filter_index, previous_rhs[200], new_rhs[200];
	enum CM_EDIT_STRING_RESULTS result;
	STRUCT_STP_FILTER new_stp_filter, old_stp_filter;

/*************************************************************************
NOTE: Check for Authentication (This will be done for each and every page
	                              before displaying that page) 
*************************************************************************/
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	edited_stp_filter = (CHANGE_THE_STP_FILTER_form_output_type*)form_data_of_request(request);

	if (!strcmp(edited_stp_filter->DeleteSTPFiltButton, "Delete"))
	{
		delete_the_stp_filter(request);
		return;
	}
	edited_stp_filter_index = save_the_number_of_stp_filter_being_edited(NULL, FALSE);
	old_stp_filter = contents_of_stp_filter_page[edited_stp_filter_index-1];
#if 0
	strcpy(new_stp_filter.network_number, edited_stp_filter->network_number);
	strcpy(new_stp_filter.node_number, edited_stp_filter->node_number);
	strcpy(new_stp_filter.socket_number, edited_stp_filter->socket_number);
	new_stp_filter.physical_port = edited_stp_filter->port;
	new_stp_filter.filter_type = edited_stp_filter->filter_type;
#endif 
	strcpy(new_stp_filter.ethernet_address ,edited_stp_filter->ethernet_address);
	new_stp_filter.physical_port = edited_stp_filter->port;
	new_stp_filter.filter_type = edited_stp_filter->filter_type;
   result = cm_edit_string(CM_SPANTREE_SECTION, "STP Filter", (void*)&old_stp_filter, (void*)&new_stp_filter);
	if (result != CM_STRING_EDIT_SUCCESSFUL)
	{
		printf("Configuration manager refused to make the changes \n");
	}
	InitReturnBuffer(request, STP_FILTER_MENU_data_ptr, strlen(STP_FILTER_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
/*	go_back_to_stp_filter_listing_page(request);*/
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_stp_filter_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_stp_filter_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}

void go_back_to_stp_filter_listing_page(Request_t* request)
{
	PARAMETER_NODE* temp_node;
	BYTE i, temp, index;
	temp_node = next_stp_filter_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (stp_filters_till_current_page%10)?stp_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE;

	temp_node = first_stp_filter_of_the_current_page(NULL, FALSE);

	stp_filters_till_current_page -= ((stp_filters_till_current_page%10)?stp_filters_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);
		
	next_stp_filter_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_stp_filters(request);
}
PARAMETER_NODE* next_stp_filter_from_where_display_is_reqd_to_continue(PARAMETER_NODE* last_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 

PARAMETER_NODE* first_stp_filter_of_the_current_page(PARAMETER_NODE* new_node, BYTE is_required_to_save)
{
	static PARAMETER_NODE* saved_node;

	if (is_required_to_save)
		saved_node = new_node;
	else
		return saved_node;
}

