/* Author : Jyothi
   Date   : 15/2/98
   Description : Contains routines to handle USER DATABASE */

#include "defs.h"
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
/* Added by Naveen.P.N. ... */
#include <stddef.h>
/* ... Naveen.P.N.*/

#include "cons.h"
#include "..\..\prochttp\src\httpd.h"
#include "..\..\genapps\src\strout.h"
#include "..\..\prochttp\src\reqlist.h"
#include "..\..\htmlform\src\formpars.h"
#include "..\..\prochttp\src\formphas.h"
#include "\rtrware\store\boot.h"
#include "\rtrware\include\udb.h"
#include "pppudb.h"

#define NUMBER_OF_ENTRIES_PER_PAGE 10

#include <incall.h>
#include <cfgmgr.h> /* Included for Configuration Manager */
#include "..\..\localapp\src\urlfns.h"

#include "udbmenu.h"
#include "udb.h"
#include "vedudb.h"
#include "editudb.h"
#include "udbfm.h" 
#include "edtudbfm.h"

/*...Extern Decleration*/

extern int udb_get_number_of_users () ;
extern enum UDB_MODIFY udb_initialize () ;
extern enum UDB_MODIFY udb_deinitialize () ;
extern RAS_USER_DATABASE_RECORD *udb_get_user_entry_from_index (int index) ;
extern RAS_USER_DATABASE_RECORD *udb_get_user_entry_from_name (char *user_name) ;
extern enum UDB_MODIFY udb_insert (RAS_USER_DATABASE_RECORD *sptr_new_record) ;
extern enum UDB_MODIFY udb_delete (char *user_name) ;
extern enum UDB_MODIFY udb_edit (RAS_USER_DATABASE_RECORD *sptr_record_to_delete) ;
extern enum UDB_MODIFY udb_update_after_changes () ;
extern void display_framed_or_standard_main_page(Request_t* request) ;

/*Extern Decleration ... */
extern int 		get_max_parameter_length (BYTE *start_of_cfg);
extern int 		search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern BYTE*   templates[];
/*...Extern Decleration*/

/* Local ProtoType ...*/
USHORT enable_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
USHORT disable_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at);
void display_the_udb_entry_for_editing(Request_t* request, RAS_USER_DATABASE_RECORD *database_entry);
void display_ten_udb_entries_from(Request_t* request, RAS_USER_DATABASE_RECORD* starting_from, BYTE is_displaying_next_page);
void display_next_ten_udb_entries(Request_t* request);
/*void get_rhs_string(BYTE* buffer, RAS_USER_DATABASE_RECORD* node);*/
USHORT modify_the_udb_entry_template(BYTE* buffer, RAS_USER_DATABASE_RECORD *database_entry, USHORT search_to_start_at);
void change_edited_entry_in_user_database(Request_t* request);
USHORT hide_remaining_hyper_links_on_which_there_is_no_udb_entry_to_display(USHORT i, USHORT search_to_start_at, BYTE* buffer);

void go_back_udb_entry_listing_page(Request_t* request);
BYTE save_the_number_of_udb_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save);
RAS_USER_DATABASE_RECORD* next_udb_entry_from_where_display_is_reqd_to_continue(RAS_USER_DATABASE_RECORD* last_node, BYTE is_required_to_save);
void remove_a_particular_udb_entry(BYTE index);
RAS_USER_DATABASE_RECORD* first_udb_entry_of_the_current_page(RAS_USER_DATABASE_RECORD* new_value, BYTE is_required_to_save);
void display_udb_menu_page(Request_t* request) ;
void display_add_user_database_entry(Request_t* request) ;
void display_ved_user_database_entry(Request_t* request) ;
void add_user_database_entry(Request_t* request) ;
void call_deinitialize() ;

RAS_USER_DATABASE_RECORD *ptr_to_start_of_udb_entry, *ptr_to_first_udb_entry_of_current_page;
USHORT udb_entries_till_current_page = 0, total_udb_entries = 0;
RAS_USER_DATABASE_RECORD contents_of_udb_entries_page[NUMBER_OF_ROUTES_PER_PAGE];

enum UDB_MODIFY return_value;
extern enum BOOLEAN udb_handler_inited ;

void display_udb_menu_page(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
         printf("database initialized \n");
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
	ptr_to_first_udb_entry_of_current_page = ptr_to_start_of_udb_entry = udb_get_user_entry_from_index(0);
	udb_entries_till_current_page = 0;
	if (ptr_to_start_of_udb_entry)
	total_udb_entries = udb_get_number_of_users();
   printf("number of users : %d\n",total_udb_entries) ;
   call_deinitialize() ;
   InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void display_add_user_database_entry(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
	InitReturnBuffer(request, UDB_ADD_USER_data_ptr, strlen(UDB_ADD_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
}


void display_ved_user_database_entry(Request_t* request)
{
	if(!check_whether_user_is_authenticated_or_not(request))
		return;

	if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
         printf("database initialized \n");
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
   ptr_to_first_udb_entry_of_current_page = ptr_to_start_of_udb_entry = udb_get_user_entry_from_index(0) ;
	if (ptr_to_start_of_udb_entry)
	 total_udb_entries = udb_get_number_of_users();
	if (!total_udb_entries)
	{
      call_deinitialize() ;
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	}

   call_deinitialize() ;
	udb_entries_till_current_page = 0;
	next_udb_entry_from_where_display_is_reqd_to_continue(ptr_to_start_of_udb_entry, TRUE);
	display_next_ten_udb_entries(request);
}

void add_user_database_entry(Request_t* request)
{
  UDB_ADD_USER_form_output_type* user_to_add ;	
  RAS_USER_DATABASE_RECORD temp_record ; 
   int temp_int = 0;

  if(!check_whether_user_is_authenticated_or_not(request))
		return;

   if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
         printf("database initialized \n");
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
  user_to_add = (UDB_ADD_USER_form_output_type*) form_data_of_request(request);

  strcpy(temp_record.user_name, user_to_add->udb_user_name) ; 
  if (strcmp (user_to_add->udb_user_name, "") == 0)
  {
		printf("Invalid User Name\n");
      call_deinitialize() ;
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE) ;
      return ;
  }

  strcpy(temp_record.password, user_to_add->udb_user_password) ; 

  temp_record.dial_in_port_mask = 0 ;

  if(user_to_add->udb_dial_in_wan1)
    temp_record.dial_in_port_mask |= 1 ;
  if(user_to_add->udb_dial_in_wan2)
    temp_record.dial_in_port_mask |= 2 ;
  if(user_to_add->udb_dial_in_wan3)
    temp_record.dial_in_port_mask |= 4 ;
  
                           
  temp_record.dial_out_port_mask = 0 ;
  if(user_to_add->udb_dial_out_wan1)
    temp_record.dial_out_port_mask |= 1 ;
  if(user_to_add->udb_dial_out_wan2)
    temp_record.dial_out_port_mask |= 2 ;
  if(user_to_add->udb_dial_out_wan3)
    temp_record.dial_out_port_mask |= 4 ;
  
   temp_record.protocol_mask = (BYTE) user_to_add->udb_protocol_mask ; 

   if (user_to_add->udb_call_back_enabled)
     temp_record.call_back_security = (BYTE)user_to_add->udb_call_back_security ; 
   else
     temp_record.call_back_security = 0 ; 

   if (user_to_add->udb_call_back_enabled)   
   {
      strcpy(temp_record.call_back_number, user_to_add->udb_call_back_number) ; 

      sscanf(user_to_add->udb_call_back_delay, "%d", &temp_int);
      if ((temp_int < 0) || (temp_int > 255)) 
         temp_record.call_back_delay = 0 ;
      else
         temp_record.call_back_delay = temp_int; 
   }
   else
   {
      strcpy(temp_record.call_back_number," ") ;
      temp_record.call_back_delay = 0 ;
   }
   temp_record.call_back_enabled = (BYTE)user_to_add->udb_call_back_enabled ; 
  return_value = udb_insert(&temp_record) ;
  
  if (return_value !=  INSERT_SUCCESSFUL)
  {
		printf("Failed to Insert the database entry\n");
      call_deinitialize() ;
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return ;
  }
  if (ptr_to_start_of_udb_entry == NULL)
		ptr_to_first_udb_entry_of_current_page = ptr_to_start_of_udb_entry = udb_get_user_entry_from_name (user_to_add->udb_user_name) ;
  total_udb_entries ++;

  return_value = udb_update_after_changes () ;
  switch(return_value)
  {
    case UDB_HANDLER_NOT_INITED :   printf("Failed to update database : handler not initialized\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_NO_MEMORY :   printf("Failed to update database : no memory\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_SUCCESSFUL :   printf("database updated ! :  \n");
                               call_deinitialize() ;
                                    break;
  }
    
  call_deinitialize() ;
  InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void delete_the_udb_entry(Request_t* request)
{
	BYTE index;
   int k=1 ;
	RAS_USER_DATABASE_RECORD *node, *prev_first_node_of_the_page ;

   if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
      {
         printf("database initialized \n");
      }
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }

	index = save_the_number_of_udb_entry_being_edited(NULL, FALSE);
	if (index == 1)
	{
		prev_first_node_of_the_page = first_udb_entry_of_the_current_page(NULL, FALSE);
		
      node = udb_get_user_entry_from_index(0) ;
	   while (node != prev_first_node_of_the_page)
         node = udb_get_user_entry_from_index(k++) ;
      node = udb_get_user_entry_from_index(k++) ;
		if (node)
			first_udb_entry_of_the_current_page(node, TRUE);
	}

	node = &contents_of_udb_entries_page[index-1];
	return_value = udb_delete(node->user_name);
   if (return_value != DELETE_SUCCESSFUL)
   {
      printf("Failed to delete the database entry\n");
      call_deinitialize() ;
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
      return ;
   }
    remove_a_particular_udb_entry(index) ;
    return_value = udb_update_after_changes () ;
  
  switch(return_value)
  {
    case UDB_HANDLER_NOT_INITED :   printf("Failed to update database : handler not initialized\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_NO_MEMORY :   printf("Failed to update database : no memory\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_SUCCESSFUL :   printf("database updated ! :  \n");
                               call_deinitialize() ;
                                    break;
  }
   call_deinitialize() ;
	if (total_udb_entries == 0)
	{
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}
   InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

void remove_a_particular_udb_entry(BYTE index)
{
	RAS_USER_DATABASE_RECORD *last_displayed_udb_entry;

	last_displayed_udb_entry = next_udb_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	if (index == 10)
	{
		if (udb_entries_till_current_page == total_udb_entries)
		{
/*         last_displayed_udb_entry = last_displayed_udb_entry->previous;*/
			udb_entries_till_current_page --;
	   }
   }
   else
	if (index == total_udb_entries)
	{
/*			last_displayed_udb_entry = last_displayed_udb_entry->previous;*/
			udb_entries_till_current_page --;
	}
	else
	if(udb_entries_till_current_page < 10)
	{
			udb_entries_till_current_page --;
	}
	next_udb_entry_from_where_display_is_reqd_to_continue(last_displayed_udb_entry, TRUE);
	total_udb_entries --;

	/* if the first node is deleted take care */
	if (total_udb_entries == 0)
	{
		ptr_to_start_of_udb_entry = NULL;	
		return;
	}
/*	if (udb_entries_till_current_page  <= 10 && index == 1)
	{
		 ptr_to_start_of_udb_entry = ptr_to_start_of_udb_entry->next;
	} */

}

void display_the_udb_entry_for_editing(Request_t* request, RAS_USER_DATABASE_RECORD *database_entry)
{
	BYTE* buffer ;
   enum BOOLEAN flag ;
   USHORT search_to_start_at;
   char temp_char_delay[3];
   buffer = malloc(strlen(UDB_EDIT_USER_data_ptr));
	if (buffer == NULL)
	{
		printf("Out Of memory to display a udb entry for editing\n");
		return;
	}
   strcpy(buffer, UDB_EDIT_USER_data_ptr);

   if(database_entry->call_back_enabled)
      flag = TRUE ;
   else 
      flag = FALSE ;

      search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, 0); 
   
   if( (database_entry->call_back_security) &&  (database_entry->call_back_enabled))
      flag = TRUE ;
   else 
      flag = FALSE ;
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 

   if(database_entry->protocol_mask)
      flag = TRUE ;
   else 
      flag = FALSE ;
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 

   search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", database_entry->user_name, buffer, TRUE, search_to_start_at); 
   search_to_start_at = search_and_replace("#_TEXT_#", database_entry->password, buffer, TRUE, search_to_start_at); 
   
   if (database_entry->call_back_enabled) 
      search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", database_entry->call_back_number, buffer, TRUE, search_to_start_at); 
   else 
      search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", "  ", buffer, TRUE, search_to_start_at); 

   sprintf( temp_char_delay,"%d", database_entry->call_back_delay );
   if (database_entry->call_back_enabled) 
       search_to_start_at = search_and_replace("#_#", temp_char_delay, buffer, TRUE, search_to_start_at); 
   else
       search_to_start_at = search_and_replace("#_#", "   ", buffer, TRUE, search_to_start_at); 

   if(database_entry->dial_in_port_mask == 1 || database_entry->dial_in_port_mask == 3 || database_entry->dial_in_port_mask == 5 || database_entry->dial_in_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;
   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 

   if(database_entry->dial_in_port_mask == 2 || database_entry->dial_in_port_mask == 3 || database_entry->dial_in_port_mask == 6 || database_entry->dial_in_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 

   if(database_entry->dial_in_port_mask == 4 || database_entry->dial_in_port_mask == 5 || database_entry->dial_in_port_mask == 6 || database_entry->dial_in_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;

   search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 


   if(database_entry->dial_out_port_mask == 1 || database_entry->dial_out_port_mask == 3 || database_entry->dial_out_port_mask == 5 || database_entry->dial_out_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;

    search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 

   if(database_entry->dial_out_port_mask == 2 || database_entry->dial_out_port_mask == 3 || database_entry->dial_out_port_mask == 6 || database_entry->dial_out_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;

    search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 
   
   if(database_entry->dial_out_port_mask == 4 || database_entry->dial_out_port_mask == 5 || database_entry->dial_out_port_mask == 6 || database_entry->dial_out_port_mask == 7) 
      flag = TRUE ;
   else 
      flag = FALSE ;

    search_to_start_at = search_and_replace("#__CBOX", "checked", buffer, flag, search_to_start_at); 
    
	InitReturnBuffer(request, buffer, strlen(buffer), HTML_CONTENT_TYPE, TRUE);
	free(buffer);
}

void display_udb_user_1(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;
   if(!check_whether_user_is_authenticated_or_not(request))
		return;
   if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
      {
         printf("database initialized \n");
      }
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
			
	database_entry = &contents_of_udb_entries_page[0];
   display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(1, TRUE);
}

void display_udb_user_2(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[1];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(2, TRUE);
}

void display_udb_user_3(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[2];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(3, TRUE);
}

void display_udb_user_4(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[3];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(4, TRUE);
}

void display_udb_user_5(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[4];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(5, TRUE);
}

void display_udb_user_6(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[5];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(6, TRUE);
}

void display_udb_user_7(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[6];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(7, TRUE);
}

void display_udb_user_8(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[7];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(8, TRUE);
}

void display_udb_user_9(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[8];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(9, TRUE);
}

void display_udb_user_10(Request_t* request)
{
   RAS_USER_DATABASE_RECORD *database_entry ;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	database_entry = &contents_of_udb_entries_page[9];
	display_the_udb_entry_for_editing(request, database_entry);
	save_the_number_of_udb_entry_being_edited(10, TRUE);
}

void display_next_ten_udb_entries(Request_t* request)
{
	 RAS_USER_DATABASE_RECORD *temp_ptr;

	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	temp_ptr = next_udb_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);
	display_ten_udb_entries_from(request, temp_ptr, TRUE);
}


void display_ten_udb_entries_from(Request_t* request, RAS_USER_DATABASE_RECORD *starting_from, BYTE is_displaying_next_page)
{
	BYTE* temp_page;
	USHORT i, search_to_start_at = 0;
	RAS_USER_DATABASE_RECORD temp_udb_entry;
	RAS_USER_DATABASE_RECORD *node, *prev_node;
	static BYTE number_of_entries_read_in_the_current_node = 0;
	int k = 1 ;

	first_udb_entry_of_the_current_page(starting_from, TRUE);

	if(udb_entries_till_current_page  == total_udb_entries)
	{
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
		return;
	}

	temp_page = malloc(strlen(UDB_VIEW_EDIT_DEL_USER_data_ptr));

	if (temp_page == NULL)
	{
		printf("Out of memory failed to display udb entry list.\n");
		return;
	}

	if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
      {
         printf("database initialized \n");
      }
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
	strcpy(temp_page, UDB_VIEW_EDIT_DEL_USER_data_ptr);

   node = udb_get_user_entry_from_index(0) ;
   temp_udb_entry = *(node) ;
   if (node == starting_from)
    	number_of_entries_read_in_the_current_node = 0;
	while (node != starting_from)
	{
      node = udb_get_user_entry_from_index(k++) ;
      temp_udb_entry = *(node) ;
   }
   
	if (number_of_entries_read_in_the_current_node)
	{
	  	for(i=0; i<number_of_entries_read_in_the_current_node ;++i)
		{
			if (!node)
			{
				return;
			}
         node = udb_get_user_entry_from_index(k++) ;
         temp_udb_entry = *(node) ;
		}
	}
	number_of_entries_read_in_the_current_node = 0;
   prev_node = starting_from;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE;++i)
	{
		search_to_start_at = search_and_replace("#@@#", "   ", temp_page, TRUE, search_to_start_at);
		search_to_start_at = modify_the_udb_entry_template(temp_page, &temp_udb_entry, search_to_start_at);
		contents_of_udb_entries_page[i] =  temp_udb_entry ;

		udb_entries_till_current_page++;
		if ((udb_entries_till_current_page  == total_udb_entries && is_displaying_next_page)
		    || (udb_entries_till_current_page  == 0 && !is_displaying_next_page)) 
		{

			/* Save the lastly displayed node */
			next_udb_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);

			search_to_start_at = hide_remaining_hyper_links_on_which_there_is_no_udb_entry_to_display(i+1, search_to_start_at, temp_page);
			if (is_displaying_next_page)
			{

				/* No More udb entries, hence remove the link */
				search_to_start_at = disable_link_to_display_next_10(temp_page, search_to_start_at);
			}
         call_deinitialize() ;
			InitReturnBuffer(request, temp_page, strlen(UDB_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
         return ;
		}
		if (is_displaying_next_page)
		{
        starting_from = udb_get_user_entry_from_index(k++) ;
        temp_udb_entry = *(starting_from) ;

		}

      if (prev_node == starting_from)
			number_of_entries_read_in_the_current_node ++;
		else
      {
			number_of_entries_read_in_the_current_node = 0 ;
         prev_node = starting_from ;
      }

		if (starting_from == NULL)
		{
			hide_remaining_hyper_links_on_which_there_is_no_udb_entry_to_display(i+1, search_to_start_at, temp_page);
         call_deinitialize() ;
			InitReturnBuffer(request, temp_page, strlen(UDB_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
			free(temp_page);
         return ;
		}
	}
      
	search_to_start_at = search_and_replace("#$$#", "   ", temp_page, TRUE, search_to_start_at);

	/* Save the lastly displayed node */
	next_udb_entry_from_where_display_is_reqd_to_continue(starting_from, TRUE);
	
   if (total_udb_entries > udb_entries_till_current_page)
		search_to_start_at = enable_link_to_display_next_10(temp_page, search_to_start_at);
	else
		search_to_start_at = disable_link_to_display_next_10(temp_page, search_to_start_at);

   call_deinitialize() ;
	InitReturnBuffer(request, temp_page, strlen(UDB_VIEW_EDIT_DEL_USER_data_ptr), HTML_CONTENT_TYPE, TRUE);
	free(temp_page);
}

USHORT modify_the_udb_entry_template(BYTE* buffer, RAS_USER_DATABASE_RECORD *database_entry, USHORT search_to_start_at)
{
   int enable ;
   search_to_start_at = search_and_replace("#___TEXT___#___#___TEXT___#___TEXT___#___", database_entry->user_name, buffer, TRUE, search_to_start_at); 
   return (search_to_start_at);
}


void change_edited_entry_in_user_database(Request_t* request)
{
	CHANGE_UDB_EDIT_USER_form_output_type* edited_udb_entry;
	BYTE edited_udb_entry_index;
   int temp_int = 0;
	RAS_USER_DATABASE_RECORD new_udb_record ;
	if(!check_whether_user_is_authenticated_or_not(request))
		return;
			
	if (udb_handler_inited == FALSE)
   {
      return_value = udb_initialize () ;
      if(return_value == INIT_SUCCESSFUL)
      {
         printf("database initialized \n");
      }
      else
      {
         printf("Failed to initialize database entry\n");
		   return;
      }
   }
	edited_udb_entry = (CHANGE_UDB_EDIT_USER_form_output_type*)form_data_of_request(request);

	if (!strcmp(edited_udb_entry->DeleteUDBButton, "Delete"))
	{
		delete_the_udb_entry(request);
      call_deinitialize() ;
      return ;
   }
	edited_udb_entry_index = save_the_number_of_udb_entry_being_edited(NULL, FALSE);

  strcpy(new_udb_record.user_name, edited_udb_entry->udb_user_name) ; 
  strcpy(new_udb_record.password, edited_udb_entry->udb_user_password) ; 

  new_udb_record.dial_in_port_mask = 0 ;
  if(edited_udb_entry->udb_dial_in_wan1)
    new_udb_record.dial_in_port_mask |= 1 ;
  if(edited_udb_entry->udb_dial_in_wan2)
    new_udb_record.dial_in_port_mask |= 2 ;
  if(edited_udb_entry->udb_dial_in_wan3)
    new_udb_record.dial_in_port_mask |= 4 ;
                           
  new_udb_record.dial_out_port_mask = 0 ;
  if(edited_udb_entry->udb_dial_out_wan1)
    new_udb_record.dial_out_port_mask |= 1 ;
  if(edited_udb_entry->udb_dial_out_wan2)
    new_udb_record.dial_out_port_mask |= 2 ;
  if(edited_udb_entry->udb_dial_out_wan3)
    new_udb_record.dial_out_port_mask |= 4 ;

  new_udb_record.protocol_mask = (BYTE) edited_udb_entry->udb_protocol_mask ; 
  if (edited_udb_entry->udb_call_back_enabled)
  {
    new_udb_record.call_back_security = (BYTE) edited_udb_entry->udb_call_back_security ; 
    strcpy(new_udb_record.call_back_number, edited_udb_entry->udb_call_back_number) ; 
    sscanf(edited_udb_entry->udb_call_back_delay, "%d", &temp_int);
    if ((temp_int < 0) || (temp_int > 255)) 
      new_udb_record.call_back_delay = 0 ; 
    else
      new_udb_record.call_back_delay = temp_int; 
  }
  else
  {
    new_udb_record.call_back_security = 0 ; 
    strcpy (new_udb_record.call_back_number, " ") ; 
    new_udb_record.call_back_delay = 0 ;
  }
  new_udb_record.call_back_enabled = (BYTE) edited_udb_entry->udb_call_back_enabled ; 
 
   return_value = udb_edit(&new_udb_record);
	if (return_value != EDIT_SUCCESSFUL)
	{
		printf("Configuration manager refused to make the changes \n");
      call_deinitialize() ;
		InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
	}
  return_value = udb_update_after_changes () ;
  switch(return_value)
  {
    case UDB_HANDLER_NOT_INITED :   printf("Failed to update database : handler not initialized\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_NO_MEMORY :   printf("Failed to update database : no memory\n");
                                    call_deinitialize() ;
                                    break;
    case UPDATE_SUCCESSFUL :   printf("database updated ! :  \n");
                               call_deinitialize() ;
                                    break;
  }
   call_deinitialize() ;
	InitReturnBuffer(request, UDB_MENU_data_ptr, strlen(UDB_MENU_data_ptr), HTML_CONTENT_TYPE, TRUE);
}

USHORT hide_remaining_hyper_links_on_which_there_is_no_udb_entry_to_display(USHORT disable_starting_from, USHORT search_to_start_at, BYTE* buffer)
{
	USHORT i;
	BYTE comment_opened = FALSE;
	for(i=0;i < NUMBER_OF_ROUTES_PER_PAGE - disable_starting_from;++i)
	{
		comment_opened = TRUE;
		search_to_start_at = search_and_replace("#@@#", "<!--", buffer, TRUE, search_to_start_at);
	}
	if (comment_opened)
		search_to_start_at = search_and_replace("#$$#", "-->", buffer, TRUE, search_to_start_at);
	else
		search_to_start_at = search_and_replace("#$$#", "   ", buffer, TRUE, search_to_start_at);
		
	return search_to_start_at;
}

BYTE save_the_number_of_udb_entry_being_edited(BYTE to_be_saved_byte, BYTE is_required_to_save)
{
	static BYTE saved_byte;
	if (is_required_to_save)
		saved_byte = to_be_saved_byte;
	else
		return saved_byte;
}

void go_back_udb_entry_listing_page(Request_t* request)
{
	RAS_USER_DATABASE_RECORD *temp_node;
	BYTE index;
	temp_node = next_udb_entry_from_where_display_is_reqd_to_continue(NULL, FALSE);

	index = (udb_entries_till_current_page%10)?udb_entries_till_current_page:NUMBER_OF_ROUTES_PER_PAGE;

	temp_node = first_udb_entry_of_the_current_page(NULL, FALSE);

	udb_entries_till_current_page -= ((udb_entries_till_current_page%10)?udb_entries_till_current_page:NUMBER_OF_ROUTES_PER_PAGE);
		
	next_udb_entry_from_where_display_is_reqd_to_continue(temp_node, TRUE);
	display_next_ten_udb_entries(request);
}

RAS_USER_DATABASE_RECORD* next_udb_entry_from_where_display_is_reqd_to_continue(RAS_USER_DATABASE_RECORD* last_node, BYTE is_required_to_save)
{
	static RAS_USER_DATABASE_RECORD* saved_node;

	if (is_required_to_save)
		saved_node = last_node;
	else
		return saved_node;
} 

RAS_USER_DATABASE_RECORD* first_udb_entry_of_the_current_page(RAS_USER_DATABASE_RECORD* new_node, BYTE is_required_to_save)
{
	static RAS_USER_DATABASE_RECORD* saved_node;

	if (is_required_to_save)
		saved_node = new_node;
	else
		return saved_node;
}

USHORT enable_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;

	search_to_start_at = search_and_replace("<!--$", "<A   ", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("$-->", "</A>", buffer, is_replacement_required, search_to_start_at);
	return search_to_start_at;
}

USHORT disable_link_to_display_next_10(BYTE* buffer, USHORT search_to_start_at)
{
	BYTE is_replacement_required = TRUE;
	search_to_start_at = search_and_replace("<A   ", "<!--$", buffer, is_replacement_required, search_to_start_at);
	search_to_start_at = search_and_replace("</A>", "$-->", buffer, is_replacement_required, search_to_start_at);
	save_whether_next_link_is_enabled_or_not(FALSE, TRUE);
	return search_to_start_at;
}

void call_deinitialize()
{

   if (udb_handler_inited == TRUE)
   {
      return_value = udb_deinitialize () ;
      if(return_value == DEINIT_SUCCESSFUL)
      {
         printf("database deinitialized \n");
         return ;
      }
      else
      {
         printf("Failed to deinitialize database entry\n");
		   return;
      }
   }
}
