#define DEFAULT_TTL_LENGTH 4
#define TIME_LENGTH 			6
#define NETWORK_LENGTH 		11
#define HOPS_LENGTH			3
#define ROUTER_NAME_LENGTH 48
#define COST_LENGTH			6
#define PASWORD_LENGTH		8
#define IPX_RECV_PER_SESS_LENGTH 4
#define DIAL_NUMBER_LENGTH 40
#define GENERAL_NAME			9
#define SPECIFIC_NAME		15
#define NUMBER_OF_ROUTES_PER_PAGE 10
#define STRING_LENGTH_FOR_GET 100

#define 	NUMBER_OF_RADIO_BUTTONS_FOR_MODES 	2
#define 	NUMBER_OF_BAUD_VALUES					10
#define 	NUMBER_OF_CLOCK_SPEEDS					12





typedef struct 
{
	BYTE ip_address[IP_ADDRES_LENGTH];
	BYTE ip_address_mask[IP_ADDRES_LENGTH];
	BYTE metric[METRIC_LENGTH];
	BYTE remote_ip_address[IP_ADDRES_LENGTH];

	BYTE ip_port_enable;
	BYTE rip;
	BYTE rip_poison_reverse;
	BYTE icmp_redirect;
	BYTE icmp_mask_reply;
	BYTE arp;
	BYTE proxy_arp;
	BYTE frame_type;
}struct_ip_config;

typedef struct
{
	BYTE ip_routing_enable;

	BYTE ip_node_address[IP_ADDRES_LENGTH];
	BYTE default_ttl[TIME_LENGTH];
	BYTE rip_response_time[TIME_LENGTH];
	BYTE reassembly_timeout[TIME_LENGTH];
	BYTE rip_route_aging_time[TIME_LENGTH];

	BYTE dhcp_client;
	BYTE dhcp_relay_agent;
	BYTE dhcp_server_ip_address[IP_ADDRES_LENGTH];
}struct_advanced_ip_config;

typedef struct
{
	BYTE 		ipxnetwork[NETWORK_LENGTH];
	BYTE 		hops[HOPS_LENGTH];
	BYTE 		rip_broadcast_interval[TIME_LENGTH];
	BYTE 		rip_aging_timer[TIME_LENGTH];
	BYTE 		rip_transport_time[TIME_LENGTH];
	BYTE 		sap_broadcast_interval[TIME_LENGTH];
	BYTE 		sap_aging_time[TIME_LENGTH];
	BYTE  	port_enable;
	BYTE  	netbios_enable;
	BYTE  	periodic_rip;
	BYTE  	ipx_watchdog_spooling;
	BYTE  	periodic_sap;
	BYTE  	spx_watchdog_spooling;
	BYTE  	discard_serialization_packets;
}struct_ipx_config;

typedef struct
{
	BYTE router_name[ROUTER_NAME_LENGTH]; 
	BYTE ipx_routing_enable;
	BYTE autolearn_network_number;
	BYTE printf_enable;
	BYTE alarm_printf_enable;
}struct_advanced_ipx_config;

typedef struct
{
	BYTE port1_cost[COST_LENGTH];
	BYTE port2_cost[COST_LENGTH];
	BYTE port3_cost[COST_LENGTH];
	BYTE port4_cost[COST_LENGTH];
	BYTE bridging_enable;
	BYTE spanning_tree_algorithm_enable;
	BYTE printf_enable;
	BYTE data_printf_enable;
	BYTE port1_state;
	BYTE port2_state;
	BYTE port3_state;
	BYTE port4_state;
}struct_spanning_tree_config;


typedef struct
{
	BYTE dial_number[DIAL_NUMBER_LENGTH];
	BYTE general_name[GENERAL_NAME];
	BYTE specific_name[SPECIFIC_NAME];
	BYTE port_inactivity_timeout[TIME_LENGTH];
	BYTE wan_port_enable;
	BYTE send_idle_flag;
	BYTE direct_connect;
	BYTE mode;
	BYTE baud_rate;
	BYTE clock;
	BYTE clock_speed;
	BYTE connection;
	BYTE modem;
}struct_wan_config;


typedef struct
{
	BYTE snmp_enabled;
	BYTE printf_enabled;
	BYTE receive_printf_enabled;
	BYTE data_printf_enabled;
	BYTE init_printf_enabled;
	BYTE transmit_printf_enabled;
	BYTE mib_printf_enabled;
	BYTE parse_printf_enabled;
	BYTE socket_printf_enabled;
	BYTE alarm_printf_enabled;
}struct_snmp_config;

typedef struct
{
	BYTE router_password[PASWORD_LENGTH];
	BYTE ipx_receives_per_session[IPX_RECV_PER_SESS_LENGTH];
	BYTE telnet_server_enable;
	BYTE tftp_server_enable;
	BYTE ag_server_enable;
	BYTE display_connection_manager_menu;
}struct_application_config;

/*typedef struct
{
	BYTE ip_address[IP_ADDRES_LENGTH];
	BYTE address_mask[IP_ADDRES_LENGTH];
	BYTE gateway_address[IP_ADDRES_LENGTH];
	BYTE metric[METRIC_LENGTH];
}STRUCT_STATIC_ROUTE;*/


enum template_types {ENUM_CHECK_BOX = 0, ENUM_TEXT_BOX, ENUM_STATIC_TEXT, ENUM_MENU, ENUM_RADIO, ENUM_STATIC_IP_ADDRESS, ENUM_GATEWAY_ADDRESS, ENUM_ADDRESS_MASK, ENUM_METRIC, ENUM_TEXT_BOX_2, ENUM_LONG_TEXT_BOX};

enum ip_port_types  {ETHERNET_PORT = 0, WAN_PORT_1, WAN_PORT_2, WAN_PORT_3, ADVANCED_CONFIG};

enum ipx_port_types {IPX_RAW=0, IPX_LLC, IPX_TYPE2, IPX_SNAP, IPX_WAN1, IPX_WAN2, IPX_WAN3, ADVANCED_IPX};

enum wan_port_types {WAN_PORT1=0, WAN_PORT2, WAN_PORT3, ADVANCED_PPP_CONFIG};

typedef struct 
{
	USHORT string_starting_index;
	enum	template_types template_type;
} SAVE_INDEX_STRUCT;


enum section_type {LSL_SECTION = 0, SOCKET_SECTION, IP_SECTION, IPX_SECTION, PPP_SECTION, CCP_SECTION, CIPX_SECTION, VJC_SECTION, SNMP_SECTION, SPANTREE_SECTION, WAN_SECTION, TCP_SECTION, TELNET_SECTION, TFTP_SECTION, SPX_SECTION, AG_SECTION, DHCP_SECTION};



extern PARAMETER_NODE* sptr_to_ptr_to_sections[20];

extern BYTE* get_lhs_string(ULONG offset, CONFIGURATION_TABLE* configuration_table, BYTE* lhs_para_str);
extern CONFIGURATION_TABLE ip_configuration_table;


extern struct_ip_config 	ether_ip;
extern struct_ip_config		wan1_ip;
extern struct_ip_config		wan2_ip;
extern struct_ip_config		wan3_ip;
extern struct_advanced_ip_config advanced_ip_params;
 
extern struct_ipx_config raw_ipx;
extern struct_ipx_config llc_ipx;
extern struct_ipx_config type2_ipx;
extern struct_ipx_config snap_ipx;
extern struct_ipx_config wan1_ipx;
extern struct_ipx_config wan2_ipx;
extern struct_ipx_config wan3_ipx;
 
extern struct_advanced_ipx_config advanced_ipx_params;

extern struct_spanning_tree_config spanning_tree_params;

extern struct_wan_config wan_port1_params;
extern struct_wan_config wan_port2_params;
extern struct_wan_config wan_port3_params;

extern struct_snmp_config snmp_params;

extern struct_application_config app_params;
#if 0
extern BYTE get_rhs_string_from_offset_1(BYTE port_number, CONFIGURATION_TABLE* configuration_table, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* field_value, BYTE* error_message, ULONG offset, BYTE port_parameter_present);
extern BYTE get_rhs_string_from_offset_2(BYTE port_number, CONFIGURATION_TABLE* configuration_table, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* field_value, USHORT field_size, BYTE* error_message, ULONG offset, BYTE port_parameter_present);
extern BYTE get_rhs_string_from_offset_3(BYTE port_number, CONFIGURATION_TABLE* configuration_table, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* field_value, BYTE* err_message, BYTE* lhs_string, BYTE port_parameter_present);
extern BYTE get_rhs_string_from_offset_4(BYTE port_number, CONFIGURATION_TABLE* configuration_table, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* field_value, USHORT field_size, BYTE* err_message, BYTE* lhs_string, BYTE port_parameter_present);
#endif
extern PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_return_rhs_string(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* rhs_string, BYTE port_paramter_present);
extern PARAMETER_NODE* match_the_lhs_string_in_the_linked_list_and_write_the_new_value(BYTE* lhs_string, PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, BYTE* new_value_string, BYTE port_paramter_present);
extern BYTE this_port_present_in_the_current_router(Request_t* request, BYTE port_number);

extern int search_and_replace(char* search_string, char* replace_string, char* buffer, BYTE required_to_replace, USHORT search_to_start_at);
extern SAVE_INDEX_STRUCT  		saved_indices[50];
extern USHORT             		number_of_saved_indices; 
extern BYTE* templates[];
extern PARAMETER_NODE* sptr_to_ptr_to_sections[20];
					
extern BYTE index_to_sections;
extern BYTE check_whether_user_is_authenticated_or_not(Request_t* request);

