/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

#include "httpd.h"
#include "reqlist.h"

#define MAX_NUMBER_OF_CONCURRENT_REQUESTS 10

RequestNode_t request_nodes[MAX_NUMBER_OF_CONCURRENT_REQUESTS]; 
RequestNode_t *next_free_request_node ; 
int next_never_allocated_request ; 



void init_requests_memory_management(void)
{
next_free_request_node = NULL ; 
next_never_allocated_request = 0 ; 
}

RequestNode_t *allocate_new_request_node(void)
{
RequestNode_t *return_val ; 


if (next_free_request_node == NULL)
  {
	 HTTP_TRACE("memory", sprintf( tmp_trace, "next_never_allocated_request = %d", next_never_allocated_request ) );
    if ( next_never_allocated_request == MAX_NUMBER_OF_CONCURRENT_REQUESTS)
      {
	 HTTP_TRACE_MSG( "memory", "allocate_new_request_node: returning NULL!!" );
	return NULL ; 
      }

    HTTP_TRACE("memory", sprintf(tmp_trace, " allocating %d ", 
				 next_never_allocated_request ) ) ; 
    
    return_val = request_nodes + next_never_allocated_request ; 
    HTTP_TRACE("memory", sprintf(tmp_trace, " return_val = %8.8lX ", 
				 return_val ) ) ; 
    next_never_allocated_request++; 
    HTTP_TRACE("memory", sprintf(tmp_trace, " next_never_allocated_request = %d ", 
				 next_never_allocated_request ) ) ; 
       /*** Yes, I could have writen the ++ inside the return command ***/
    return return_val ; 
  }

/*** use the freed list ***/

if (next_free_request_node == NULL)
  {
/*	 printf( "allocate_new_request_node: returning NULL!!\n" );*/
	 HTTP_TRACE_MSG( "memory", "allocate_new_request_node: returning NULL!!" );
	 return NULL ; 
  }

return_val = next_free_request_node ; 
next_free_request_node = *( (RequestNode_t **) next_free_request_node ) ; 

HTTP_TRACE("memory", sprintf(tmp_trace, " reusing %d ", 
				 return_val - request_nodes ) ) ; 

/*printf( "return_val = %8.8lX\n", return_val );*/
return return_val ; 

}


void delete_request_node(RequestNode_t *request_node)
{

*( (RequestNode_t **) request_node )  = next_free_request_node ; 

next_free_request_node = request_node ; 

/*printf( "next_free_request_node = %8.8lX\n", next_free_request_node ); */
HTTP_TRACE("delete", sprintf(tmp_trace, " next_free_request_node = %8.8lX ", 
	next_free_request_node ) ) ; 

}




void init_request_list(RequestList_t *request_list )
{
request_list->first = NULL ; 
request_list->last = NULL ; 
}

void InitStatus( RequestStatus_t *status )
{
status->process_status = HTTP_HEADER ; 
status->http_header_status = HTTP_HEADER_LINE1 ; 
status->header_line_status = IN_LINE ; 
status->nof_chars_in_header = 0 ; 
status->total_bytes_read_for_header = 0 ; 
}
 

void init_new_request( Request_t *request , Socket_t *new_socket,
		     struct sockaddr_in *client_address, 
		     int client_address_length)

{
int address_size ; 

request->socket = *new_socket ; 
request->response_entity_function = NULL ; 
request->response_entity_handle = NULL ; 

address_size = client_address_length ; 
if (address_size > sizeof( request->client_address) )
  {
    address_size = sizeof( request->client_address) ;
  }

memcpy( &request->client_address , client_address , (size_t)address_size ) ; 

InitStatus( &request->status ) ; 

}





void add_new_request(RequestList_t *request_list, Socket_t *new_socket, 
		     struct sockaddr_in *client_address, 
		     int client_address_length)
{

RequestNode_t *new_request_node ; 


new_request_node = allocate_new_request_node() ;
HTTP_TRACE("memory", sprintf( tmp_trace, "new_request_node = %8.8lX", new_request_node) );

if (request_list->first == NULL ) 
  {
HTTP_TRACE_MSG("memory", "request_list->first == NULL" );
    request_list->first = new_request_node ; 
  }
else
  {
HTTP_TRACE_MSG("memory", "request_list->first != NULL" );
    request_list->last->next = new_request_node ; 
  }

new_request_node->next = NULL ; 
new_request_node->prev = request_list->last ; 

request_list->last = new_request_node ; 


init_new_request(&new_request_node->request , new_socket, client_address,
		  client_address_length ) ; 

}


void delete_request(RequestNode_t *request_node,
		    RequestList_t *request_list )
{
if (request_node->prev != NULL )
  {
    request_node->prev->next = request_node->next ; 
  }

if (request_node->next != NULL )
  {
    request_node->next->prev = request_node->prev ; 
  }


if (request_node == request_list->first )
  {
    request_list->first = request_node->next ; 
  }

if (request_node == request_list->last )
  {
    request_list->last = request_node->prev ; 
  }

delete_request_node(request_node) ; 


}











