/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include "httpd.h"
#include "util.h"

#include "..\..\sysdep\src\timezone.h"
#include "..\..\sysdep\src\syslib.h"

extern char my_tolower(char x);





int find_word_case_insensitive(char *word, int word_length ,  
			   WordList_t *word_list  )
{
int i_word, i_char ; 
Word_t *curr_word ; 

for(i_word = 0, curr_word = word_list->words ; 
    i_word < word_list->nof_words ; i_word++, curr_word++)
  {
    if (word_length == curr_word->length)
      {
	for(i_char = 0 ; i_char <word_length ; i_char ++ )
	  {
	    if (my_tolower( word[i_char] ) != 
		my_tolower( curr_word->word[i_char] ) )
		break ; 
	      
	  }
	if (i_char == word_length)
	  {
	    return curr_word->index ; 
	  }
      }
  }
return NOT_FOUND_IN_WORD_LIST ; 
}

int find_word_case_sensitive(char *word, int word_length ,  
			   WordList_t *word_list  )
{
int i_word, i_char ; 
Word_t *curr_word ; 

for(i_word = 0, curr_word = word_list->words ; 
    i_word < word_list->nof_words ; i_word++, curr_word++)
  {
    if (word_length == curr_word->length)
      {
	for(i_char = 0 ; i_char <word_length ; i_char ++ )
	  {
	    if (word[i_char] !=  curr_word->word[i_char] )
		break ; 
	      
	  }
	if (i_char == word_length)
	  {
	    return curr_word->index ; 
	  }
      }
  }
return NOT_FOUND_IN_WORD_LIST ; 
}




void get_next_word(char **p , int *length, char *end_of_buf )  
/**** on input p points to a buffer, on output it will point to the next word
***** and length will be the length of the word. word is defined as anything 
***** between whitespace. if \n \r or 0 are found a word length of 
***** 0 is returned.
****/
{
char *p1 ; 

while  ( (**p == ' ') ||  (**p == '\t')  )
  {
    (*p)++ ; 
    if (*p == end_of_buf) 
      {
	*length = 0 ; 
	return ; 
      }
  }

if ( (**p == 0) || (**p == '\n') || (**p == '\r') )
  {
    *length = 0 ; 
    return ; 
  }

p1 = *p ; 
*length = 0 ;
while ( (*p1 != ' ' ) && (*p1 != '\t' ) && (*p1 != '\n' ) &&
        (*p1 != '\r' ) && (*p1 != 0 ) )
  {
    p1++ ; 
    (*length)++ ; 
    if (p1 == end_of_buf)
      {
	break ; 
      }
  }
}


#if defined(UNIX_EMULATION)  && !defined(VXWORKS) &&!defined(WINDOWS_VC) && !defined(RTXC_SYSTEM)
#include <unistd.h>
#endif

void wait_time(int time_in_ms)
{
#if defined(UNIX_EMULATION)  && !defined(VXWORKS) &&!defined(WINDOWS_VC) && !defined(RTXC_SYSTEM)
usleep(time_in_ms*1000) ; 
#elif defined(RTXC_SYSTEM)
sleep( time_in_ms );
#endif
}



void copy_date_struct(HttpDate_t *source, HttpDate_t *dest)
{
memcpy(dest, source, sizeof(HttpDate_t) ) ; 
}



void set_null_date(HttpDate_t *date )
{
date->year = 0 ; 
date->month = 0 ; 
date->day = 0 ; 
date->hour = 0 ; 
date->minute = 0 ; 
date->second = 0 ; 
}


int test_if_date_is_null(HttpDate_t *date)
{
if (date->year != 0 ) return FALSE  ; 
if (date->month != 0 ) return FALSE  ; 
if (date->day != 0 ) return FALSE  ; 
if (date->hour != 0 ) return FALSE  ; 
if (date->minute != 0 ) return FALSE  ; 
if (date->second != 0 ) return FALSE  ; 

return TRUE ; 
}



void update_with_carry( int *num , int cycle  , int *carry ) 
{
*carry = 0 ; 
if (*num >= cycle  )
  {
    *carry = 1 ; 
    *num  -= cycle ; 
  }

if (*num  < 0 )
  {
    *carry = -1 ; 
    *num  += cycle ; 
  }

}

void update_with_carry_lq( int *num , int cycle  , int *carry ) 
{
*carry = 0 ; 
if (*num > cycle  )
  {
    *carry = 1 ; 
    *num  -= cycle ; 
  }

if (*num  <= 0 )
  {
    *carry = -1 ; 
    *num  += cycle ; 
  }

}

int days_in_month_table[] = {0, 31, 28 , 31, 30, 31 , 30 , 31 , 31 , 30 , 31 , 
30 , 31 } ;  
/** first 0 is because mnonth are 1-12 ***/

int HTTP_days_in_month(int month, int year )
{
/***
HTTP_TRACE("dates", sprintf(tmp_trace, " days in %d %d", month, year ) ); 
***/

if (month != 2 )
  {
    return days_in_month_table[month] ; 
  }

if (year%4 != 0)
  {
    return 28 ; 
  }

if (year%20 != 0 )
  {
    return 29 ; 
  }

if (year%100 != 0 )
  {
    return 28 ; 
  }

if (year%400 != 0 )
  {
    return 29 ;
  }

return 28 ; 
}



void convert_timedate_to_GMT_timedate(HttpDate_t *date, 
				     HttpDate_t *gmt_date )
{
int hours_carry ; 
int days_carry; 
int month_carry ;
int year_carry ; 

if (should_update_diff_from_gmt)
  {
    init_diff_from_gmt() ; 
  }

gmt_date->second = date->second ; 
gmt_date->minute = date->minute + minutes_diff_from_gmt ; 


update_with_carry( &gmt_date->minute, 60 , &hours_carry ) ; 

gmt_date->hour = date->hour + hours_diff_from_gmt + hours_carry ; 

update_with_carry( &gmt_date->hour , 24 , &days_carry ) ; 

gmt_date->day = date->day + days_carry ; 

update_with_carry_lq( &gmt_date->day , 
		  HTTP_days_in_month(date->month, date->year ) , &month_carry ) ; 

gmt_date->month = date->month + month_carry ; 

update_with_carry_lq( &gmt_date->month, 12 , &year_carry ) ; 

gmt_date->year = date->year + year_carry ; 



}

#ifdef UNIX_EMULATION
#include <time.h>
#endif

unsigned char days_in_week_table[] = {
/**** day of the week of the first in each month for each year 
***** starting from 1950. The days of the week of 1st of month M
***** in year Y is days_in_week_table[ 12*(Y-1950) + M-1]
***** M is 1-12, day is 0-6 (0==Sunday)
****/
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 , 
2 , 5 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 , 
0 , 3 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 5 , 1 , 3 , 6 , 1 , 4 , 0 , 2 , 5 , 0 , 
3 , 6 , 6 , 2 , 4 , 0 , 2 , 5 , 1 , 3 , 6 , 1 , 
4 , 0 , 0 , 3 , 5 , 1 , 3 , 6 , 2 , 4 , 0 , 2 , 
5 , 1 , 1 , 4 , 6 , 2 , 4 , 0 , 3 , 5 , 1 , 3 , 
6 , 2 , 3 , 6 , 1 , 4 , 6 , 2 , 5 , 0 , 3 , 5 , 
1 , 4 , 4 , 0 , 2 , 5 , 0 , 3 , 6 , 1 , 4 , 6 } ;  


int day_of_week_compute(HttpDate_t *date)
{
int result_day_in_week ; 

#ifdef UNIX_EMULATION
struct tm tmp_tm ; 

time_t t ; 
#endif

if ( (date->year < 1950) || (date->year >= 2030) )
  {
    HTTP_REPORT_ERROR(" Year not between 1950 and 2030, can not compute day");
    return 0 ; 
  }


result_day_in_week = days_in_week_table[ 12*(date->year-1950) + date->month-1];

result_day_in_week += date->day - 1 ; 

result_day_in_week = result_day_in_week % 7 ; 



#ifdef UNIX_EMULATION

tmp_tm.tm_sec = date->second ; 
tmp_tm.tm_min = date->minute ; 
tmp_tm.tm_hour = date->hour ;  
tmp_tm.tm_mon = date->month - 1 ; 
tmp_tm.tm_mday = date->day ; 
tmp_tm.tm_year  = date->year - 1900 ; 
tmp_tm.tm_isdst= 0 ; 


t = mktime(&tmp_tm) ; 

if ( tmp_tm.tm_wday != result_day_in_week )
  {
/*    HTTP_REPORT_ERROR(" Conflicting Days In Week! ");*/
  }

#endif 


return result_day_in_week ; 
}


static char *month_names[] =
{
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

static char *wkday_names[] = 
{ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri" , "Sat" } ; 



void convert_date_to_text(HttpDate_t *date,
			  char *text_buffer)
{
int weekday ; 
int year ; 

weekday = day_of_week_compute(date) ; 

year = date->year ; 
if ( (year > 50) && (year < 100) )
  {
    HTTP_REPORT_ERROR(" Years should be 4 digits !!! ") ; 
    year+= 1900 ; 
  }

sprintf(text_buffer,"%s, %02d %s %04d %02d:%02d:%02d GMT",
		wkday_names[weekday],
		date->day,
		month_names[date->month-1],
		year ,
		date->hour,
		date->minute,
		date->second);
}


void local_date_to_GMT_text(HttpDate_t *date,
			  char *text_buffer)
{
HttpDate_t gmt_date ; 

convert_timedate_to_GMT_timedate(date, &gmt_date ) ; 

convert_date_to_text(&gmt_date, text_buffer) ; 


}



void get_current_date(HttpDate_t *date);

Word_t month_names_dict[] = {
  { "Jan", 3 , 1 } , 
  { "Feb", 3 , 2 } , 
  { "Mar", 3 , 3 } , 
  { "Apr", 3 , 4 } , 
  { "May", 3 , 5 } , 
  { "Jun", 3 , 6 } , 
  { "Jul", 3 , 7 } , 
  { "Aug", 3 , 8 } , 
  { "Sep", 3 , 9 } , 
  { "Oct", 3 , 10 } , 
  { "Nov", 3 , 11 } , 
  { "Dec", 3 , 12 } } ; 
 
WordList_t month_names_list = { month_names_dict, 12 } ; 


int str_to_num(char *str) 
{
int num ; 

while (*str == ' ' )
  {
    str++ ; 
  }

num  = 0 ; 
while ( (*str >= '0') && (*str <= '9') )
  {
    num = num*10 + *str - '0' ; 
    str++ ; 
  }
return num ; 
}



void parse_rfc822(char *date_string, HttpDate_t *date )
{
date->year = str_to_num(date_string + 12 ) ; 
date->day = str_to_num(date_string + 5    ) ; 
date->hour = str_to_num(date_string + 17    ) ; 
date->minute = str_to_num(date_string + 20    ) ; 
date->second = str_to_num(date_string + 23    ) ; 
date->month =  find_word_case_insensitive(date_string + 8,3,&month_names_list) ; 
}


void parse_rfc850(char *date_string, HttpDate_t *date )
{

while ( (*date_string != ',') &&
       (*date_string != '\n') &&
       (*date_string != '\r') &&
       (*date_string !=  0 ) )
  {
    date_string++ ; 
  }

if (*date_string != ',' ) 
  {
    set_null_date(date);
    return ; 
  }



date->year = 1900 + str_to_num(date_string + 9 ) ; 
date->day = str_to_num(date_string + 2    ) ; 
date->hour = str_to_num(date_string + 12    ) ; 
date->minute = str_to_num(date_string + 15    ) ; 
date->second = str_to_num(date_string + 18    ) ; 
date->month =  find_word_case_insensitive(date_string + 5,3,&month_names_list); 
}



void parse_asctime(char *date_string, HttpDate_t *date )
{
date->year = str_to_num(date_string + 21 ) ; 
date->day = str_to_num(date_string + 9    ) ; 
date->hour = str_to_num(date_string + 12    ) ; 
date->minute = str_to_num(date_string + 15    ) ; 
date->second = str_to_num(date_string + 18    ) ; 
date->month =  find_word_case_insensitive(date_string + 4,3,&month_names_list) ; 
}




void parse_http_date(char *date_string, HttpDate_t *date )
{
char *date_begin; 

date_begin = date_string ; 
while ( (*date_begin ==  ' ') || (*date_begin == ':' ) )
  {
    date_begin++ ; 
  }


switch ( date_begin[3] )
  {
  case ',': { /**** format 1: 
	      * Sun, 06 Nov 1994 08:49:37 GMT  ; RFC 822, updated by RFC 1123
	      ********************/
           parse_rfc822(date_begin, date ) ; 
	   return ; 
	 }
  case ' ': { /*** asc time format (format 3 )
              *  Sun Nov  6 08:49:37 1994         ; ANSI C's asctime() format
              ***********/
             parse_asctime(date_begin, date ) ; 
	   return ; 
	   }
  default: { /**** format 2 
             **** Sunday, 06-Nov-94 08:49:37 GMT
             ****    ; RFC 850, obsoleted by RFC 1036
	     **/
             parse_rfc850(date_begin, date ) ; 
	   return ; 
	   }
  }
return ; 

}

int compare_dates(HttpDate_t *date1 , HttpDate_t *date2  )
/**** returns true if date1 is later or equal than date 2 ****/
{
if (date1->year != date2->year ) return (date1->year >= date2->year ) ; 
if (date1->month != date2->month ) return (date1->month >= date2->month ) ; 
if (date1->day != date2->day ) return (date1->day >= date2->day ) ; 
if (date1->hour != date2->hour ) return (date1->hour >= date2->hour ) ; 
if (date1->minute != date2->minute ) return (date1->minute >= date2->minute ) ; 

return (date1->second >= date2->second ) ; 

}



void parse_mime_header_type_line( char *buffer , 
				  int   buffer_length , 
				  char **field_name, 
                                  int *field_name_length , 
                                  char **field_value, 
                                  int *field_value_length , 
                                  int max_nof_attribtues_value_pairs,
                                  char **attributes, 
                                  int *attributes_length, 
                                  char **values, 
                                  int *values_length, 
                                  int *nof_attribtues_value_pairs )
/***** parse a line of the form:
        Content-type: multipart/form-data;boundary=xxxxxx
    or
        Content-type: multipart/form-data;boundary="xxxxxx"
***************/

{
char *start_parameter ; 
char *start_value ; 
char *start_field_value ; 
int parameter_length ; 
int value_length ; 


int temp_length ; 
int value_is_quoted_string ; 

char *last_char ; 

last_char = buffer + buffer_length ; 

*field_name = buffer ; 
temp_length = 0 ; 

while( (buffer[temp_length] != ':' ) &&
       (temp_length < buffer_length) )
  {
    temp_length++ ; 
  }

*field_name_length = temp_length ; 


start_field_value = buffer + temp_length + 1  ; 
while (*start_field_value == ' ')
  {
    start_field_value++ ; 
  }



temp_length = 0 ; 
while ( (start_field_value + temp_length < last_char ) &&
        (start_field_value[temp_length] != ',') &&  
                         /*** rfc 1867 specified ',' though all
                         *** the others specify ';' ******/
        (start_field_value[temp_length] != ';') &&
        (start_field_value[temp_length] != ' ') &&
        (start_field_value[temp_length] != '\n') &&
        (start_field_value[temp_length] != '\r') )
  {
    temp_length++ ; 
  }


*field_value = start_field_value ; 
*field_value_length = temp_length ; 

start_parameter =  start_field_value + temp_length;

*nof_attribtues_value_pairs = 0 ; 


while (1)
  {

    while ( ( *start_parameter == ',' ) || 
                            /*** rfc 1867 specified ',' though all
			    **** the others specify ';' ******/
	   ( *start_parameter == ';' ) ||
	   ( *start_parameter == ' ' )  )
      {
	start_parameter++ ; 
      }

    if ( ( *start_parameter == '\n' ) ||
        ( *start_parameter == '\r' ) ||
        (start_parameter  >= last_char ) )
      {
	break ; 
      }

    parameter_length = 0 ; 
    while ((start_parameter[parameter_length] != '=' ) && 
	   (start_parameter + parameter_length < last_char ) )
      {
	parameter_length++ ; 
      }


    start_value = start_parameter + parameter_length + 1 ; 
    if (*start_value == '\"' ) /*** quoted string ***/
      {
	start_value++ ; 
	value_length = 0 ; 
	while (start_value[value_length] != '\"' )
	  {
	    value_length++ ; 
	  }
	value_is_quoted_string = TRUE ; 
      }
    else /*** token and not quoted string ***/
      {
	value_is_quoted_string = FALSE ; 
	value_length = 0 ; 
	while ( (start_value[value_length] != ' ' ) &&
                (start_value[value_length] != '\n' ) &&
                (start_value[value_length] != '\r' ) &&
                (start_value[value_length] != ';' ) &&
                (start_value[value_length] != ',' )  )
	  {
	    value_length++ ; 
	  }
      }


    attributes[ *nof_attribtues_value_pairs ] = start_parameter ; 
    attributes_length[ *nof_attribtues_value_pairs ] = parameter_length ; 

    values[ *nof_attribtues_value_pairs ] = start_value ; 
    values_length[ *nof_attribtues_value_pairs ] = value_length ; 

    (*nof_attribtues_value_pairs)++ ; 

    if ( *nof_attribtues_value_pairs >=  max_nof_attribtues_value_pairs)
      {
	break ; 
      }

    start_parameter = start_value + value_length  ; 

    if (value_is_quoted_string)
      {
	start_parameter++ ;
      }

  }
}



#ifdef malloc
#undef malloc
#endif

void *allocate_memory_block(size_t size, char *file_name, int line_number)
{
void *tmp ; 

tmp = malloc(size) ; 

#ifdef INTERMETRICS
/* size_t is long*/
HTTP_TRACE("memory", sprintf(tmp_trace, " allocated %p size %ld from %s line %d ", 
			     tmp, size, file_name, line_number ) ) ; 
#else
/* size_t is a short*/
HTTP_TRACE("memory", sprintf(tmp_trace, " allocated %p size %ld from %s line %d ", 
			     tmp, size, file_name, line_number ) ) ; 
#endif

if (tmp == NULL )
  {
    HTTP_REPORT_ERROR(" malloc failed !!!!!");
  }


return tmp ; 


}

#define malloc ERROR ERROR ERROR SEE __FILE__ __LINE__
/***** malloc was undefed *****/

#ifdef free
#undef free
#endif

void free_memory_block(void *ptr, char *file_name, int line_number)
{

HTTP_TRACE("memory", sprintf(tmp_trace, " free %p  from %s line %d ", 
			     ptr,  file_name, line_number ) ) ; 

free(ptr);

}

#define free ERROR ERROR ERROR SEE __FILE__ __LINE__
/***** free was undefed *****/



