/********** COPYRIGHT 1996, AN UNPUBLISHED WORK BY MAGMA INFORMATION
*********** TECHNOLOGIES, ALL RIGHTS RESERVED. THIS PROGRAM IS AN
*********** UNPUBLISHED WORK PROTECTED BY THE UNITED STATES COPYRIGHT
*********** LAWS (TITLE 17 UNITES STATES CODE) AND CONTAINS TRADE SECRETS 
*********** OF MAGMA INFORMATION TECHNOLOGIES WHICH MUST BE HELD IN STRICT
*********** CONFIDENCE.
**********/
#ifndef SYSLIB_H
#define SYSLIB_H

/*** memory managment and string operations ***/
#if defined(WINDOWS_VC)
#include <memory.h>
#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#endif

#ifdef UNIX_EMULATION
#include <stdlib.h>
#endif

#if defined( SPECIAL_CST)
       int atoi( char *nptr);
#endif


#ifdef  SPECIAL_CST
void *malloc(int size); 
void free(void *p);
#endif 



#ifdef  SPECIAL_CST

char my_tolower(char x);

#endif

#ifdef UNIX_TCPIP
/*#define my_tolower(x) my_tolower(x) */
char my_tolower(char x);
#endif

#ifdef _BIG_PROXY_
#ifndef NO_MEMORY_DEBUG
void *allocate_memory_block(size_t size, char *file_name, int line_number);
void free_memory_block(void *ptr, char *file_name, int line_number);

#define malloc(SIZE) allocate_memory_block(SIZE, __FILE__, __LINE__ )
#define free(PTR) free_memory_block(PTR, __FILE__, __LINE__ )

#endif
#endif




#endif /*** SYSLIB_H ***/
