/*
	MODULE	:	websock.c
	AUTHOR	:  Rajesh Marathe
	DATE		:  29-11-96
	SYNOPSIS	:	This file contains Socket Library  Interface routines
					for WEB Server.
*/

#include "defs.h"

#include <stdio.h>
#include <string.h>   
#include <stdlib.h>
/* @@@#include <sys\types.h>*/
#include <errno.h>
#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>

/* Added By Naveen ...*/
#include <ksocket.h>
/* ... Naveen*/
#include "..\..\prochttp\src\httpd.h"
#include "tcprw.h"
#include "incall.h"
#include "cfgmgr.h"

WEB_CLASS web;

extern ULONG host_to_net_long( ULONG host_order_long_value);
extern USHORT host_to_net_short( USHORT host_order_short_value);
extern ULONG get_ip_address(USHORT);

/****************************************************************************
 Fucntion	:	read_available_data_from_socket()
 Synopsis	:	A recv() call is made here to record the incoming data
					form the stream socket.	
****************************************************************************/
void read_available_data_from_socket(Socket_t socket , 
					void *buffer , 
				   int max_bytes_to_read, 
				   int *nof_bytes_actually_read , 
				   int *client_closed_the_socket,
				   int *error)
/***** Does a non-blocking read *********/
{
	int error_was_detected; 
	int would_block_condition_detected ; 
	int socket_error;

	*nof_bytes_actually_read =  recv(socket, buffer, max_bytes_to_read,  0 ) ; 

	error_was_detected = FALSE ; 
	would_block_condition_detected = FALSE; 

	if (*nof_bytes_actually_read == 0 )
	{
#if 1
/* Naveen.P.N.... Following portion of the code is not working can be removed*/
			/* get the error number */
			lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			if (socket_error != WOULD_BLOCK_ERROR) 
			{
				cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);
				*client_closed_the_socket = TRUE ; 
				return;
			}
#endif
		*client_closed_the_socket = TRUE ; 
		*error = NO_ERROR ; 
		return ; 
	}

	error_was_detected = ((*nof_bytes_actually_read) == FAILED ) ;

	if (error_was_detected)
	{
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (int *)error);
		would_block_condition_detected = (*error == WOULD_BLOCK_ERROR);
	}

	if (!error_was_detected)
	{
		*client_closed_the_socket = 0 ; 
		*error = NO_ERROR ; 
  		web.http_timer = web.http_idle_timeout; 
		return ; 
	}
	else
	{
   	if (would_block_condition_detected)
    	{
			*nof_bytes_actually_read = 0 ; 
			*client_closed_the_socket = 0 ; 
			*error = NO_ERROR ; 
 	 		web.http_timer = web.http_idle_timeout; 
			return ; 
      }
    	else
      { /*** still need to find the client_closed_the_socket condition **/
			*nof_bytes_actually_read = 0 ; 
			*client_closed_the_socket = 1 ; 
			return ; 
      }
	}
}

/****************************************************************************
 Fucntion	:	read_data_from_socket()
 Synopsis	:	A recv() call is made here to record the incoming data
					form the stream socket.	
****************************************************************************/
void read_data_from_socket(Socket_t socket , 
/**** commented out since blockign read is done only using
**** read_data_from_socket_until_delimiter*/
				   void *buffer , 
				   int max_bytes_to_read, 
				   int *nof_bytes_actually_read , 
				   int *client_closed_the_socket,
				   int *error)
/***** Does a blocking read *********/
{
	*nof_bytes_actually_read =  recv(socket, buffer, max_bytes_to_read,  0 ) ; 

	if (*nof_bytes_actually_read != FAILED )
	{	 
		*client_closed_the_socket = 1 ; /*** bug ? ****/
		*error = NO_ERROR ; 
    	return ; 
	}
	else
	{
		/*** still need to find the client_closed_the_socket condition **/

		*nof_bytes_actually_read = 0 ; 
		*client_closed_the_socket = 1 ; 
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (int *)error);
		if (error != WOULD_BLOCK_ERROR) 
		{
			cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);
			*client_closed_the_socket = TRUE ; 
			return;
		}

		return ; 
	}
}


/****************************************************************************
 Fucntion	:	read_data_from_socket_until_delimiter()
 Synopsis	:	A recv() call is made here to record the incoming data
					form the stream socket.	The data is recorded until the
					delimiter is detected
****************************************************************************/
void read_data_from_socket_until_delimiter(Socket_t socket , 
					void *buffer , 
				   int max_bytes_to_read, 
				   int *nof_bytes_actually_read , 
				   int *client_closed_the_socket,
				   int *error , 
				   char delimiter )
/** used when only blocking IO is available ********/
{
	char *p ; 
	int bytes_read ; 
	int error_was_detected ; 

	p = buffer ; 
	*nof_bytes_actually_read = 0 ; 

	while (1) 
	{
		bytes_read =  recv(socket, buffer, max_bytes_to_read,  0 ) ; 

		error_was_detected = FALSE ; 

		error_was_detected =  (bytes_read == FAILED );
		if (error_was_detected)
		{
			lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
				(ULONG) SOCKETS_INTERFACE, (int *)error);
		}
		if (!error_was_detected )
   	{
   		(*nof_bytes_actually_read)++ ; 
	      if ((*p == delimiter) ||   (*p == '-') || 
   	      /*** patch to makeup for multipart encoding *****/
	  		(*nof_bytes_actually_read == max_bytes_to_read ) )
			{
				*client_closed_the_socket = 0 ; 
				*error = NO_ERROR ; 
				return ; 
			}
		}
	  	else /*** error was detected ***/
   	{
   		*client_closed_the_socket = 1 ;
			if (error != WOULD_BLOCK_ERROR) 
			{
				cm_deinitialize_configuration_manager(CM_OWNED_BY_HTTP);
				*client_closed_the_socket = TRUE ; 
				return;
			}
	      return ; 
		}
		p++ ; 
	}
}


/****************************************************************************
 Fucntion	:	set_nonblocking_socket()
 Synopsis	:	A "fcntl()" call is made which manipulates the socket state
					i.e F_SETFL sets the descriptor status flags using the 
					command O_NONBLOCK	
****************************************************************************/
void set_nonblocking_socket( Socket_t server_socket,
					int *error )

{
	*error = NO_ERROR ; 
}


/****************************************************************************
 Fucntion	:	initialize_new_server_socket()
 Synopsis	:	This function gets a new socket_descriptor , binds it to the
					local address and listens for any connection requests from
					HTTP clients	
****************************************************************************/
void initialize_new_server_socket(
					Socket_t *server_socket, 
					Port_t port_address, 
	    			int backlog, 
	    			int *error )
{
	struct sockaddr_in server_sockaddr ; 

	*error = NO_ERROR ; 
	*server_socket = socket(AF_INET , SOCK_STREAM , 0x00000000L ) ; 

/* Added by Rajesh: 2-12-96*/
	web.socket_descriptor = *server_socket;

	if (*server_socket == FAILED)
	{
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (int *)error);
		printf("Socket() Call failed\n");
		return ; 
	}
	 /* printf("Socket() Call Successful\n"); */
/* Added by Rajesh: 2-12-96*/
	associate_application_with_socket(web.socket_descriptor, web.application_id);

#ifndef  BLOCKING_IO_ONLY 
	set_nonblocking_socket(*server_socket, error ) ;
	if (*error != NO_ERROR )
  	{
		return  ; 
	}
#endif

	server_sockaddr.sin_family = AF_INET;
/*	server_sockaddr.sin_port = host_to_net_short(port_address);*/
	server_sockaddr.sin_port = port_address;
	server_sockaddr.sin_addr.s_addr = get_ip_address(0);

	*error = bind( *server_socket, (struct sockaddr  *) &server_sockaddr, 
		sizeof(server_sockaddr) );

	if (*error == FAILED)
	{
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (int *)error);
		printf("bind() Call failed\n");
    	return ; 
	}

	/* printf("Bind() Call Successful\n"); */
	*error = listen( *server_socket, backlog ) ; 

	if (*error == FAILED)
	{
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (int *)error);
		printf("listen() Call failed\n");
		return ; 
	}
	/* printf("Listen() Call Successful\n"); */
}

/****************************************************************************
 Fucntion	:	accept_new_connection()
 Synopsis	:	This function is called if a new_connection is being
					received	and the connection is established to the 
					remote client
****************************************************************************/
void accept_new_connection(Socket_t server_socket , 
					Socket_t *new_client_socket, 
				   int *new_client_was_found,
				   struct sockaddr_in *client_address,
				   int *addr_length )
{
	int error ; 

/* 
						Commented out temp. because right now we
						are not supporting the call setsockopt()..
#ifndef FUSION_TCPIP
	struct linger linger_params ; 

	linger_params.l_onoff = 1 ; 
	linger_params.l_linger = 100 ; 
#endif
*/

	*addr_length = sizeof(*client_address) ;

	*new_client_socket = accept(server_socket, 
								(struct sockaddr *) client_address, 
			   				addr_length) ; 
/*	if ( *new_client_socket != FAILED )
		printf ("accept() call success: client found\n");*/
	*new_client_was_found = (*new_client_socket != FAILED) ;

	if (!*new_client_was_found)
  	{
		return ; 
	}

	set_nonblocking_socket(*new_client_socket, &error ) ;
	if (error != NO_ERROR )
	{
    	return  ; 
	} 
/*
								Take care of this later	
	setsockopt(*new_client_socket , SOL_SOCKET, SO_LINGER , (char *)&linger_params ,
		sizeof(linger_params) ) ; 
*/

} 


/****************************************************************************
 Fucntion	:	write_data_to_socket()
 Synopsis	:	This function basically sends data over the socket	
****************************************************************************/
void write_data_to_socket(Socket_t *socket, 
					void *data, 
					int length, 
			  		int *nof_bytes_written, 
			  		int *client_closed_the_socket,
			  		int *error)
{
	int error_was_detected; 
	int would_block_condition_detected ; 

	*error = 0 ; 

	*nof_bytes_written = send(*socket, data, length, 0  ) ; 

	error_was_detected = FALSE ; 
	would_block_condition_detected = FALSE; 
	*client_closed_the_socket = FALSE ; 

	error_was_detected =  (*nof_bytes_written == FAILED );
	if (error_was_detected)
  	{
		/* Get the error number */
		lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (unsigned long *)error);
		would_block_condition_detected = ( *error == WOULD_BLOCK_ERROR );

/*		if (*error == EPIPE)*/

		if (*error != WOULD_BLOCK_ERROR)
      {
			*client_closed_the_socket = TRUE ; 
      }
	}

	if (*client_closed_the_socket)
	{
   	*nof_bytes_written = 0 ;
    	return ; 
	}

	if (error_was_detected)
  	{
   	*nof_bytes_written = 0 ; 
#ifndef BLOCKING_IO_ONLY
    	if (would_block_condition_detected) 
		{ 
			*nof_bytes_written = 0 ; 
	  		*error = NO_ERROR ; 
      	return ; 
    	}
#endif /** NON BLOCKING IO ***/
    	*nof_bytes_written = 0 ; 
	}
/*** end of UNIX_TCP_IP ****/
}

/****************************************************************************
 Fucntion	:	shutdown_socket()
 Synopsis	:	closes the socket previously opened	
****************************************************************************/
void shutdown_socket(Socket_t *socket)
{
	shutdown(*socket, 2 ) ; 
}

