#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <memory.h>
#include "cnffile.h"
#include <cfgmgr.h>
#include "fncdefs.h"

USHORT ftp_prev_ctrl_port_number = 0, ftp_prev_data_port_number = 0 ; 
void set_ftp_port_numbers_in_global_structure(ULONG connection_id, BYTE ftp_ctrl, USHORT prev_port) ; /* 07/10/99 */

extern void *memmove (void *s1, const void *s2, size_t n);
extern void *get_pointer_to_first_entry_in_list (LINK *sptr_link);
extern void encrypt (char *src, char *dest) ;
extern void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index) ; 

/* Jo 29/04/99 */
const PTR_TO_FUNCTION ptr_to_function [] = {	
					  #ifdef _BIG_PROXY_
					   		get_lsl_field_info,
								get_socket_field_info,
					  #endif
								get_ip_field_info,
								get_wan_field_info,
								get_ppp_field_info,
								get_proxy_field_info,
							 	get_dhcp_field_info,
					  #ifdef _BIG_PROXY_
								get_cipx_field_info,
								get_vjc_field_info,
								get_snmp_field_info,
								get_tcp_field_info,
								get_telnet_field_info,
								get_tftp_field_info,
								get_web_field_info,
					  #endif
								};

/* Imran, 10.3.99 */
const SPECIAL_FORMAT special_format[] = {
	{	PPP_PORT_USER_PASSWORD,								NULL, 								encrypt_password_string },
#if 0
	{	PPP_PORT_OPTION_LCP_AUTHENTICATION_PAP, 		get_pap_chap_enabled,			set_pap_chap_enabled},
	{	PPP_PORT_OPTION_LCP_AUTHENTICATION_CHAP, 		get_pap_chap_enabled,			set_pap_chap_enabled},

	{	TELNET_SERVER_PASSWORD,								NULL, 								encrypt_server_password_string },

	{	IP_FILTER_PORT_TOTAL_NUMBER_OF_FILTERS, 		get_no_of_ip_port_filters, 	NULL},
	{	IP_FILTER_ADDRESS_TOTAL_NUMBER_OF_FILTERS, 	get_no_of_ip_address_filters, NULL},
	{	IP_FILTER_PORT_FILTER_TYPE, 						get_ip_port_filter_type, 		change_ip_port_filter_type},
	{	IP_FILTER_ADDRESS_FILTER_TYPE, 					get_ip_address_filter_type, 	change_ip_address_filter_type},

	{	IPX_FILTER_ADDRESS_TOTAL_NUMBER_OF_FILTERS, 	get_no_of_ipx_filters, 			NULL},
	{	IPX_FILTER_ADDRESS_FILTER_TYPE, 					get_ipx_filter_type, 			change_ipx_filter_type},

	{	STP_FILTER_ADDRESS_TOTAL_NUMBER_OF_FILTERS, 	get_no_of_stp_filters, 			NULL},
	{	STP_FILTER_ADDRESS_FILTER_TYPE, 					get_stp_filter_type, 			change_stp_filter_type},
#endif

	{	NULL, 									NULL, 								NULL}
};
/* Imran, 10.3.99 */


/* Jo 29/04/99 */
const ADD_PARAMETERS add_a_set_of_parameters[] =	{
/* { 	ADD_IP_PORT,									 add_ip_port			  					},*/

/*	{ 	ADD_FORBIDDEN_SITES_ENTRIES,				 add_proxy_address_filter				},	
	{  ADD_RESTRICTED_CLIENTS_ENTRIES,			 add_proxy_address_filter				},	*/
	{	ADD_RESTRICTED_APPLICATION_ENTRIES,		 add_restricted_application_filters },
/*	{	ADD_MAC_ADDRESS_ENTRIES,					 add_proxy_address_filter				},	
	{	ADD_DOMAIN_NAME_ENTRIES,					 add_proxy_address_filter				}, */
	{	ADD_PROXY_ADDRESS_FILTER,					 add_proxy_address_filter				},
	{	ADD_PROXY_APPLICATION,						 add_proxy_application					},
	{	ADD_PROXY_USER_APP,							 add_proxy_user_defined_application },
	{	ADD_PROXY_ADDRESS_ENTRIES,					 add_proxy_address_entries				},
	{	ADD_GLOBAL_ADDRESS_ENTRIES,				 add_global_address_entries			},
	{	ADD_PROXY_STATIC_MAPPING,					 add_proxy_static_mapping				},
	{	ADD_PROXY_DYNAMIC_MAPPING,	   			 add_proxy_dynamic_mapping				},
	{ 	ADD_STATIC_ROUTE,								 add_static_route_entry					},
	
#if 0
	{ 	ADD_IPX_PORT,									 add_ipx_port			  },
	{ 	ADD_STP_PORT,									 add_stp_port			  },

	{ 	ADD_IP_FILTER_DEST_PORT_ENTRY,			 add_ip_filter			  },
	{ 	ADD_IP_FILTER_SOURCE_PORT_ENTRY,		 	 add_ip_filter			  },
	{ 	ADD_IP_FORWARD_DEST_PORT_ENTRY,		 	 add_ip_filter			  },
	{ 	ADD_IP_FORWARD_SOURCE_PORT_ENTRY,		 add_ip_filter			  },

	{ 	ADD_IP_FILTER_DEST_ADDRESS_ENTRY,		 add_ip_filter			  },
	{ 	ADD_IP_FILTER_SOURCE_ADDRESS_ENTRY,	 	 add_ip_filter			  },
	{ 	ADD_IP_FORWARD_DEST_ADDRESS_ENTRY,	  	 add_ip_filter			  },
	{ 	ADD_IP_FORWARD_SOURCE_ADDRESS_ENTRY,	 add_ip_filter			  },
	{	ADD_IPX_FILTER_DEST_ADDRESS_ENTRY,	 	 add_ipx_address_filter},
	{	ADD_IPX_FILTER_SOURCE_ADDRESS_ENTRY,	 add_ipx_address_filter},
	{	ADD_IPX_FORWARD_DEST_ADDRESS_ENTRY,	 	 add_ipx_address_filter},
	{	ADD_IPX_FORWARD_SOURCE_ADDRESS_ENTRY, 	 add_ipx_address_filter},

	{	ADD_STP_FILTER_DEST_ADDRESS_ENTRY,	 	 add_stp_address_filter},
	{	ADD_STP_FILTER_SOURCE_ADDRESS_ENTRY,	 add_stp_address_filter},
	{	ADD_STP_FORWARD_DEST_ADDRESS_ENTRY,	 	 add_stp_address_filter},
	{	ADD_STP_FORWARD_SOURCE_ADDRESS_ENTRY, 	 add_stp_address_filter},
#endif
	{	(ULONG) NULL, 													NULL		  }
	};

/* Jo 29/04/99 */
const DELETE_PARAMETERS delete_a_set_of_parameters[] =	{
/*	{ 	DELETE_IP_PORT,									 delete_ip_port			}, 
	{  DELETE_FORBIDDEN_SITES_ENTRIES,			 	 delete_proxy_address_filters  			},	
	{	DELETE_RESTRICTED_CLIENTS_ENTRIES,			 delete_proxy_address_filters 			},	*/
	{	DELETE_RESTRICTED_APPLICATION_ENTRIES,		 delete_restricted_application_filters },
/*	{	DELETE_MAC_ADDRESS_ENTRIES,					 delete_proxy_address_filters				},
	{	DELETE_DOMAIN_NAME_ENTRIES, 					 delete_proxy_address_filters				},*/
	{	DELETE_PROXY_ADDRESS_FILTER,					 delete_proxy_address_filters				},

	{	DELETE_PROXY_APPLICATION,						 delete_proxy_application					},
	{	DELETE_PROXY_USER_APP,							 delete_proxy_user_application_entries },
	{	DELETE_PROXY_ADDRESS_ENTRIES,					 delete_proxy_address_entries				},
	{  DELETE_GLOBAL_ADDRESS_ENTRIES,				 delete_virtual_server_entries			},
	{	DELETE_PROXY_STATIC_MAPPING,					 delete_virtual_server_entries			},
	{	DELETE_PROXY_DYNAMIC_MAPPING,	   			 delete_virtual_server_entries			},
	{ 	DELETE_STATIC_ROUTE,								 delete_static_route_entry					},

#if 0
	{ 	DELETE_IPX_PORT,										delete_ipx_port		},
	{ 	DELETE_STP_PORT,										delete_stp_port		},
	{ 	DELETE_IP_FILTER_PORT_ENTRY,						delete_ip_filter		},
	{ 	DELETE_IP_FILTER_ADDRESS_ENTRY,					delete_ip_filter		},
	{	DELETE_IPX_FILTER_ADDRESS_ENTRY,			delete_ipx_address_filter	},
	{	DELETE_STP_FILTER_ADDRESS_ENTRY,			delete_stp_address_filter	},
#endif

	{	(ULONG) NULL, 											NULL						}
	};

/* Jo 29/04/99 */
const GET_OFFSET_PARAMETERS get_offset_to_parameters[] = {
 	{ PROXY_APPLICATION,		  calculate_offset_of_proxy_application_entries  },
	{ PROXY_USER_APPLICATION, calculate_offset_of_proxy_user_defined_application_entries },
	{ PROXY_FILTER,			  calculate_offset_of_proxy_filter					 },
	{ PROXY_NAT,				  calculate_offset_of_proxy_virtual_entry        },
	{ (ULONG) NULL,			  NULL														 }
};

#ifdef _BIG_PROXY_
enum CM_DATA_FORMAT get_lsl_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			default : return CM_UNKNOWN_FORMAT;
		}
}

enum CM_DATA_FORMAT get_socket_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			default : return CM_UNKNOWN_FORMAT;
		}
}
#endif

enum CM_DATA_FORMAT get_wan_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{

	if (parameter_id < WAN_ENABLE || parameter_id > WAN_PORT_RESPONSE_STRING)
		return CM_UNKNOWN_FORMAT;

	if (parameter_id < WAN_PORT_ENABLE)	
	{
		switch (parameter_id)
		{
			case WAN_ENABLE						:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.enabled);
				return CM_BYTE_FORMAT;

			case WAN_NUMBER_OF_PORTS			:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.number_of_ports);
				return CM_BYTE_FORMAT;
#ifdef _BIG_PROXY_
			case WAN_PRINTF						:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.wan_printfs);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case WAN_INITIALIZATION_PRINTF	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.wan_printfs);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case WAN_RX_PRINTF					:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.wan_printfs);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

			case WAN_TX_PRINTF					:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_header.wan_printfs);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;
#endif

			default : return CM_UNKNOWN_FORMAT;
		}
	}

	switch (parameter_id)
	{
		case WAN_PORT_ENABLE	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].enabled);
				return CM_BYTE_FORMAT;

		case WAN_PORT_SPEED :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].speed);
		  /*	if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_wan_async_speed_interdep; */
				return CM_ULONG_FORMAT;

		case WAN_PORT_SCRIPT_ENABLE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].script_enabled);
				return CM_BYTE_FORMAT;

		case WAN_PORT_RESTART_SCRIPT_ON_COMM_FAILURE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].restart_script_on_comm_failure);
				return CM_BYTE_FORMAT;

		case WAN_PORT_DIRECT_CONNECT :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].direct_connect);
				return CM_BYTE_FORMAT;

		case WAN_PORT_AUTO_ANSWER :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].auto_answer);
		  /*	if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_wan_port_answering; */                                                                                                     
				return CM_BYTE_FORMAT;

		case WAN_PORT_MODEM_TYPE  :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_type[0]);
				valid_range[0] = 50;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_MODEM_INITIALIZATION_STRING1 :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_init_string1[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_MODEM_INITIALIZATION_STRING2 :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_init_string2[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_MODEM_INITIALIZATION_STRING3 :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_init_string3[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_MODEM_INITIALIZATION_STRING4 :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_init_string4[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_MODEM_INITIALIZATION_STRING5 :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].modem_init_string5[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_DIAL_PREFIX :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].dial_prefix[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_DIAL_NUMBER :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].dial_number[0]);
				valid_range[0] = 60;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_DIAL_SUFFIX :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].dial_suffix[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_RING_MESSAGE	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].ring_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_HANGUP_STRING :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].hangup_string[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_OK_MESSAGE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].ok_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_NO_CARRIER_MESSAGE	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].no_carrier_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_ERROR_MESSAGE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].error_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_NO_DIAL_TONE_MESSAGE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].no_dial_tone_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_BUSY_MESSAGE	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].busy_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_NO_ANSWER_MESSAGE :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].no_answer_message[0]);
				valid_range[0] = 21;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

		case WAN_PORT_RESPONSE_STRING	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].response_string[0]);
				valid_range[0] = 41;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

#if 0
		case WAN_PORT_CONNECTION_STARTED_BY_DCD :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].connection_started_by_dcd);
				return CM_BYTE_FORMAT;

		case WAN_PORT_CONNECTION_DROPPED_BY_DCD :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].connection_dropped_by_dcd);
				return CM_BYTE_FORMAT;

		case WAN_PORT_CONNECTION_STARTED_BY_MODEM_RESPONSE	:
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].connection_started_by_modem_response);
				return CM_BYTE_FORMAT;

		case WAN_PORT_SEND_IDLE_FLAGS :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].send_idle_flags);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_wan_port_idle_flags;
				return CM_BYTE_FORMAT;

		case WAN_PORT_INTERNAL_CLOCK :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].internal_clock);
				return CM_BYTE_FORMAT;

		case WAN_PORT_SYNCHRONOUS_SPEED :
				*exact_offset += (ULONG) offsetof (CNF_WAN, wan_ports[port_no].sync_speed);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 4800;
					valid_range[2] = 2048000;
				}
				return CM_ULONG_FORMAT;
#endif

		default : return CM_UNKNOWN_FORMAT;
	}
}															  

enum CM_DATA_FORMAT get_ppp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
	if (parameter_id < PPP_ENABLE || 
			parameter_id > PPP_OPTION_VALUE)
	{
		return CM_UNKNOWN_FORMAT;
	}

	if (parameter_id < PPP_PORT_ENABLE)	
	{
		switch (parameter_id)
		{
			case PPP_ENABLE:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.enabled);
#if 0
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_ppp_enable;
		  		if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_ppp_interdep_para; 
#endif
				return CM_BYTE_FORMAT;

			case PPP_NUMBER_OF_PORTS:											
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.number_of_ports);
				return CM_USHORT_FORMAT;

			case PPP_NEED_TO_DIAL_OUT_INITIALLY :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.need_to_dial_out_initially);
				return CM_BYTE_FORMAT;

#if 0
			case PPP_CCP:															
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.ccp);
				return CM_BYTE_FORMAT;

			case PPP_MAXIMUM_NUMBER_OF_CONFIGURATION_REQUESTS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_number_of_config_requests);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 3;
					valid_range[2] = 65535;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_NUMBER_OF_TERMINATION_REQUESTS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_number_of_termination_requests);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 20;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_NUMBER_OF_UNACKNOWLEDGED_ECHO_REQUESTS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_number_of_unacked_echo_requests);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 20;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_CONFIGURATION_REQUEST_SEND_INTERVAL:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_config_request_send_interval);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 5;
					valid_range[2] = 65535;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_TERMINATION_REQUEST_SEND_INTERVAL:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_termination_request_send_interval);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 0;
					valid_range[2] = 65535;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_ECHO_REQUEST_SEND_INTERVAL:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_echo_request_send_interval);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 0;
					valid_range[2] = 65535;
				}
				return CM_ULONG_FORMAT;

			case PPP_MAXIMUM_CONFIGURATION_REQUEST_BACKOFF_INTERVAL:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.max_config_request_backoff_interval);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 5;
					valid_range[2] = 65535;
				}
				return CM_ULONG_FORMAT;

			case PPP_PRINTF_DATA:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.ppp_printfs);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case PPP_PRINTF_MEMORY:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_header.ppp_printfs);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;
#endif
			case PPP_PRINTF:
				*exact_offset += (ULONG) (sizeof(USHORT) * 3 + sizeof(BYTE) * 2 );
				valid_range[0] = 7;
				return CM_BIT_FORMAT;
				

			case PPP_PRINTF_LCP:
				*exact_offset += (ULONG) (sizeof(USHORT) * 3 + sizeof(BYTE) * 2 );
				valid_range[0] = 6;
				return CM_BIT_FORMAT; 
		
			case PPP_PRINTF_NCP:
				*exact_offset += (ULONG) (sizeof(USHORT) * 3 + sizeof(BYTE) * 2 );
				valid_range[0] = 5;
				return CM_BIT_FORMAT; 
				

			case PPP_PRINTF_ALARM:
				*exact_offset += (ULONG) (sizeof(USHORT) * 3 + sizeof(BYTE) * 2 );
				valid_range[0] = 4;
				return CM_BIT_FORMAT; 
		
			default : return CM_UNKNOWN_FORMAT;
		}
	}

	switch (parameter_id)
	{
		case PPP_PORT_ENABLE :												
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].enabled);
#if 0
				if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_ppp_interdep_para; 
#endif
				return CM_BYTE_FORMAT;

		case PPP_PORT_USER_NAME:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].user_name[0]);
				valid_range[0] = 128;	/* its length is 128 */	
				valid_range[1] = 0; 	  /* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_USER_PASSWORD:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].user_password[0]);
				valid_range[0] = 128;  	/* its length is 128 */
				valid_range[1] = 0;	  /* it is a null terminated string */
				return CM_SPECIAL_FORMAT;  /* Imran 10.3.99 */
			  
	
#if 0
		case PPP_PORT_MAXIMUM_RECEIVE_UNIT:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].max_receive_unit);
				return CM_ULONG_FORMAT;

		case PPP_PORT_MAXIMUM_REMOTE_RECEIVE_UNIT:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].max_remote_receive_unit);
				return CM_ULONG_FORMAT;

		case PPP_PORT_MAXIMUM_NUMBER_OF_AUTHENTICATION_RETRIES:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].max_number_of_authentication_retries);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 3;
					valid_range[2] = 255;
				}
				return CM_BYTE_FORMAT;

		case PPP_PORT_SEND_ID_STRING:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].send_ID_string);
				return CM_BYTE_FORMAT;

		case PPP_PORT_SEND_TIME_REMAINING:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].send_time_remaining);
				return CM_BYTE_FORMAT;

		case PPP_PORT_ID_STRING:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ID_string[0]);
				valid_range[0] = 128;	/* its length is 128 */	
				valid_range[1] = 0;	  /* it is a null terminated string */
				return CM_STRING_FORMAT;
#endif
		case PPP_PORT_CONNECTION_DIAL_ON_DEMAND :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].connection_dod);
				return CM_BYTE_FORMAT;

		case PPP_PORT_HANGUP_TIME :
		 		*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].hangup_time);	
				if(ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 60;
					valid_range[2] = 30000;
				}
				return CM_USHORT_FORMAT;
		
		case PPP_PORT_IP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ip);
				return CM_BYTE_FORMAT;

      case PPP_PORT_AUTHENTICATION_TYPE :
				 *exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].authentication_type);
				 return CM_BYTE_FORMAT;

/* Jo 12/07/99 Added for RAS */
		case PPP_PORT_REMOTE_PORT_CLIENT_ONLY:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_port_client_only);
				return CM_BYTE_FORMAT;

#if 0
		case PPP_PORT_IPX:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipx);
				return CM_BYTE_FORMAT;

		case PPP_PORT_STP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].stp);
				return CM_BYTE_FORMAT;

		case PPP_PORT_NETBIOS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].netbios);
				return CM_BYTE_FORMAT;

		case PPP_PORT_PRIMARY_PRIORITY_FACTOR:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ppp_priority_factors[0]);
				if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_ppp_priority_interdep;
				return CM_BYTE_FORMAT;

		case PPP_PORT_SECONDARY_PRIORITY_FACTOR:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ppp_priority_factors[1]);
				return CM_BYTE_FORMAT;

		case PPP_PORT_IP_PRIORITY:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ppp_ip_priority_level);
					return CM_BYTE_FORMAT;

		case PPP_PORT_IPX_PRIORITY:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ppp_ipx_priority_level);
				return CM_BYTE_FORMAT;
				
		case PPP_PORT_STP_PRIORITY:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ppp_stp_priority_level);
				return CM_BYTE_FORMAT;
				
		case PPP_PORT_TIME_TO_SEND_LQR:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].time_to_send_LQR);
					return CM_ULONG_FORMAT;

		case PPP_PORT_PERIODIC_AUTHENTICATION_TIMER:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].periodic_authentication_timer);
				return CM_ULONG_FORMAT;
#endif

		case PPP_PORT_OPTION_LCP_ACCM:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_accm);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_ACCM:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_accm);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_OPTION_LCP_MRU:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_mru);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_MRU:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_mru);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_AUTHENTICATION :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_authentication);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_OPTION_LCP_MAGIC_NUMBER:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_magic_number);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_MAGIC_NUMBER:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_magic_number);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_OPTION_IPCP_IP_ADDRESS :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipcp_ip_address);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_IPCP_IP_ADDRESS :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_ipcp_ip_address);		
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_OPTION_LCP_EPD :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_epd);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_EPD :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_epd);		
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_OPTION_LCP_MRRU :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_mrru);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_MRRU :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_mrru);
				return CM_STRUCTURE_FORMAT; 

		case PPP_PORT_REMOTE_OPTION_LCP_CALLBACK :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_callback);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_IPCP_DNS_ADDRESS1 :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipcp_dns_address1);
				return CM_STRUCTURE_FORMAT;

		case PPP_PORT_IPCP_DNS_ADDRESS2 :
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipcp_dns_address2);
				return CM_STRUCTURE_FORMAT;

		case PPP_OPTION_TYPE :
				*exact_offset += (ULONG) offsetof (CNF_PPP_OPTION, option_type);
				return CM_BYTE_FORMAT;

		case PPP_OPTION_AUTO :
				*exact_offset += sizeof(BYTE);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

		case PPP_OPTION_NEG_NOT_REQD :
				*exact_offset += sizeof(BYTE) ;
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

		case PPP_OPTION_NEGOTIABLE :
				*exact_offset += sizeof(BYTE);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;


		case PPP_OPTION_VALID :
				*exact_offset += sizeof(BYTE);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;

		case PPP_OPTION_VALUE_TYPE :
				*exact_offset += (ULONG) offsetof (CNF_PPP_OPTION, value_type);
				return CM_USHORT_FORMAT;

		case PPP_OPTION_VALUE :
				*exact_offset += (ULONG) offsetof (CNF_PPP_OPTION, option_value);	
				return CM_BYTE_FORMAT;	

#if 0
			case PPP_PORT_OPTION_IPXCP_NETWORK_NUMBER:
					*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipxcp_network_number);
					valid_range[0] = 128;	/* its length is 128	*/
					valid_range[1] = 0;	/* it is a null terminated string */
					return CM_STRING_FORMAT;

			case PPP_PORT_REMOTE_OPTION_IPXCP_NETWORK_NUMBER:
					*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_ipxcp_network_number);
					valid_range[0] = 128;	/* its length is 128 */
					valid_range[1] = 0;	/* it is a null terminated string */
					return CM_STRING_FORMAT;
		
			case PPP_PORT_OPTION_IPXCP_COMPRESSION:
					*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipxcp_compression);
					valid_range[0] = 128;	/* its length is 128 */
					valid_range[1] = 0;	/* it is a null terminated string */
					return CM_STRING_FORMAT;

			case PPP_PORT_REMOTE_OPTION_IPXCP_COMPRESSION:
					*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_ipxcp_compression);
					valid_range[0] = 128;	/* its length is 128 */
					valid_range[1] = 0;	/* it is a null terminated string */
					return CM_STRING_FORMAT;

			case PPP_PORT_OPTION_IPCP_IP_ADDRESS:
					*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipcp_ip_address);
					valid_range[0] = 128;	/* its length is 128 */
					valid_range[1] = 0;	/* it is a null terminated string */
					return CM_STRING_FORMAT;

		case PPP_PORT_REMOTE_OPTION_IPCP_IP_ADDRESS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_ipcp_ip_address);
				valid_range[0] = 128;  	/* its length is 128 */
				valid_range[1] = 0;	  /* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_OPTION_IPCP_COMPRESSION:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].ipcp_compression);
				valid_range[0] = 128; 	/* its length is 128 */
				valid_range[1] = 0;	 /* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_REMOTE_OPTION_IPCP_COMPRESSION:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_ipcp_compression);
				valid_range[0] = 128;	/* its length is 128 */ 
				valid_range[1] = 0;	/* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_OPTION_LCP_AUTHENTICATION_PAP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_pap);
				valid_range[0] = 128;  	/* its length is 128 */
				valid_range[1] = 0;	  /* it is a null terminated string */
				return CM_SPECIAL_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_AUTHENTICATION_PAP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_pap);
				valid_range[0] = 128;	/* its length is 128 */  
				valid_range[1] = 0;	/* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_OPTION_LCP_AUTHENTICATION_CHAP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].lcp_chap);
				valid_range[0] = 128; 	 	/* its length is 128 */
				valid_range[1] = 0;		 /* it is a null terminated string */
				return CM_SPECIAL_FORMAT;

		case PPP_PORT_REMOTE_OPTION_LCP_AUTHENTICATION_CHAP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].remote_lcp_chap);
				valid_range[0] = 128;	/* its length is 128 */	
				valid_range[1] = 0;	 /* it is a null terminated string */
				return CM_STRING_FORMAT;

		case PPP_PORT_CONNECTION_DIAL_ON_DEMAND:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].connection_DOD);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_ppp_port_dod_enable;
				if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_dial_on_demand_interdep;
				return CM_BYTE_FORMAT;

		case PPP_PORT_CONNECTION_IDLE_TIMER:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].connection_idle_timer);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 0;
					valid_range[2] = 546;
				}
				return CM_ULONG_FORMAT;

		case PPP_PORT_ASYNCHRONOUS_LINK:
				*exact_offset += (ULONG) offsetof (CNF_PPP, ppp_ports[port_no].async_link);
				return CM_BYTE_FORMAT;

		case PPP_PORT_SLIP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, 
							ppp_ports[port_no].slip_options.enabled);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_slip_enable;
				if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_slip_interdep_para;
				return CM_BYTE_FORMAT;

		case PPP_PORT_CSLIP:
				*exact_offset += (ULONG) offsetof (CNF_PPP, 
							ppp_ports[port_no].slip_options.cslip_enabled);
				return CM_BYTE_FORMAT;

		case PPP_PORT_SLIP_MAXIMUM_TRANSMIT_UNIT:
				*exact_offset += (ULONG) offsetof (CNF_PPP, 
							ppp_ports[port_no].slip_options.max_transmit_unit);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 0;
					valid_range[2] = 10000;
				}
				return CM_USHORT_FORMAT;

		case PPP_PORT_NUMBER_OF_SLIP_BUFFERS:
				*exact_offset += (ULONG) offsetof (CNF_PPP, 
							ppp_ports[port_no].slip_options.number_of_buffers);
				return CM_USHORT_FORMAT;
#endif

		default : return CM_UNKNOWN_FORMAT;
	}
}

#ifdef _BIG_PROXY_
enum CM_DATA_FORMAT get_ccp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case CCP_PORT_ENABLE	:
				*exact_offset += (ULONG) offsetof (CNF_CCP, ccp_ports[0].enabled);
				return CM_BYTE_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}
#endif


enum CM_DATA_FORMAT get_ip_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{

	if (parameter_id < IP_NUMBER_OF_PORTS || parameter_id > IP_PORT_REMOTE_ADDRESS)
		return CM_UNKNOWN_FORMAT;

		switch (parameter_id)
		{		
	  /* Imran 19/8/98 */
			case IP_NUMBER_OF_PORTS	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.number_of_ports);
				return CM_USHORT_FORMAT;

#if 0 /* Jo 31/08/99 No more Default Gateway. So the function doesn't make any sense anymore */
			case IP_DEFAULT_GATEWAY :
			  	*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.default_gateway);
				if(ptr_to_validation_function)
					*ptr_to_validation_function = validate_ip_gateway_address;
				return CM_ULONG_FORMAT;
#endif
			case IP_DNS_ENABLED	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.dns_enabled);
				return CM_BYTE_FORMAT;

			case IP_DNS_PRIMARY_ADDRESS :
			   *exact_offset += (ULONG) offsetof (CNF_IP, ip_header.primary_address);
				if(ptr_to_validation_function)
				{
					valid_range[11] = 1;
					*ptr_to_validation_function = validate_ip_dns_ip_address;
				}
				return CM_ULONG_FORMAT;

			case IP_DNS_SECONDARY_ADDRESS :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.secondary_address);
				if(ptr_to_validation_function)
				{
					valid_range[11] = 2;
					*ptr_to_validation_function = validate_ip_dns_ip_address;
				}
				return CM_ULONG_FORMAT;

		   case IP_PORT_ISP_ASSIGNS_ADDRESS :
			   *exact_offset += (ULONG) offsetof (CNF_IP, ip_ports[port_no].isp_assigns_address); 
				return CM_BYTE_FORMAT;

/* Jo 09/07/99 Added for RAS */
		  	case IP_PORT_BOOTP :
		  		*exact_offset += (ULONG) offsetof (CNF_IP, ip_ports[port_no].bootp);
/*		  		if (ptr_to_interdependency_function)
		  			*ptr_to_interdependency_function = set_ip_port_bootp_interdep; */
		  		return CM_BYTE_FORMAT;
/* Jo 09/07/99 Added for RAS */

			case IP_PORT_IP_ADDRESS :
				 *exact_offset += (ULONG) offsetof (CNF_IP, ip_ports[port_no].ip_address);
/*	Jo			 if(ptr_to_validation_function)
					*ptr_to_validation_function = validate_ip_port_address;*/
				 return CM_ULONG_FORMAT;

			case IP_PORT_SUBNET_MASK :
			 	  *exact_offset += (ULONG) offsetof (CNF_IP, ip_ports[port_no].subnet_mask);	
				  return CM_ULONG_FORMAT;

/* Jo 12/07/99 Added for RAS */
			case IP_PORT_REMOTE_ADDRESS :
					*exact_offset += (ULONG) offsetof (CNF_IP, ip_ports[port_no].remote_ip_address);
					return CM_ULONG_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		 }
		  /* Imran 19/8/98 */
#if 0				
			case IP_DEFAULT_ROUTE :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.default_route);
				return CM_ULONG_FORMAT;

			case IP_DEFAULT_METRIC :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.default_metric);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 16;
				}
				return CM_ULONG_FORMAT;

			case IP_PRINTF :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case IP_PRINTF_ALARM	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case IP_PRINTF_ARP :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

			case IP_PRINTF_DATA :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;

			case IP_PRINTF_DIAGNOSTIC :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 3;
				return CM_BIT_FORMAT;

			case IP_PRINTF_ICMP :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 2;
				return CM_BIT_FORMAT;

			case IP_PRINTF_MEMORY :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 1;
				return CM_BIT_FORMAT;

			case IP_PRINTF_RIP :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_1);
				valid_range[0] = 0;
				return CM_BIT_FORMAT;

			case IP_PRINTF_UDP :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_2);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case IP_PRINTF_IP	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_header.ip_printfs_2);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}

	if (parameter_id < IP_DNS)	
	{
		switch (parameter_id)
		{
			case IP_RIP	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.enabled);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_ip_port_rip_bits;
				return CM_BYTE_FORMAT;

			case IP_RIP_ROUTE_AGING_TIMEOUT :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.route_aging_timeout);
				if (ptr_to_validation_function)
				{
					#if (0)
						*ptr_to_validation_function = validate_ip_port_rip_bits;
					#else
						*ptr_to_validation_function = check_whether_value_in_limit;
					#endif
					valid_range[0] = 2;
					valid_range[1] = 0;
					valid_range[2] = 65535;
				}
				return CM_USHORT_FORMAT;

			case IP_RIP_ROUTE_GARBAGE_COLLECTION_TIMEOUT:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.route_garbage_collection_timeout);
				return CM_USHORT_FORMAT;

			case IP_RIP_RESPONSE_INTERVAL	:
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.response_interval);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 10;
					valid_range[2] = 65535;
				}
				return CM_USHORT_FORMAT;

			case IP_RIP_NEIGHBOR_LIST :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.neighbour_list);
				return CM_BYTE_FORMAT;

			case IP_RIP_NEIGHBOR_LIST_ENTRIES :
				*exact_offset += (ULONG) offsetof (CNF_IP, ip_rip.neighbour_list_entries);
				return CM_ULONG_FORMAT;

		}
	}

	ptr_to_ip = (CNF_IP *) *exact_offset;
	offset_to_add = sizeof (CNF_IP_HEADER) + sizeof (CNF_IP_RIP) +	(sizeof (ULONG) *
							(ptr_to_ip->ip_rip.number_of_neighbour_list_entries - 1)) ;
	
	if (parameter_id < IP_PORT_ENABLE)	
	{
		switch (parameter_id)
		{
			case IP_DNS :
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, enabled);
				return CM_BYTE_FORMAT;

			case IP_DNS_MAXIMUM_RTX_TIMEOUT :
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, max_rtx_timeout);
				return CM_USHORT_FORMAT;

			case IP_DNS_MINIMUM_RTX_TIMEOUT :
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, min_rtx_timeout);
				return CM_USHORT_FORMAT;

			case IP_DNS_MAXIMUM_RETRANSMISSIONS	:
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, max_referals);
				return CM_USHORT_FORMAT;

			case IP_DNS_SERVER_ADDRESS1 :
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, server_address_1);
				return CM_ULONG_FORMAT;

			case IP_DNS_SERVER_ADDRESS2 :
				*exact_offset += offset_to_add + offsetof (CNF_IP_DNS, server_address_2);
				return CM_ULONG_FORMAT;

			case IP_STATIC_ROUTE_TABLE_ENTRIES :
				*exact_offset += offsetof (CNF_IP_HEADER, number_of_static_route_table_entries);
				return CM_USHORT_FORMAT;
		}
	}

	if (parameter_id < IP_PORT_ENABLE)
	{
		if (valid_range[0] >= ptr_to_ip->ip_header.number_of_static_route_table_entries)
				return CM_UNKNOWN_FORMAT;
		*exact_offset += offset_to_add + sizeof (CNF_IP_DNS) + 
				valid_range[0]  * sizeof (CNF_IP_STATIC_ROUTE);
		switch (parameter_id)
		{
			case IP_STATIC_ROUTE_TARGET :
				*exact_offset += offsetof (CNF_IP_STATIC_ROUTE, target);
				return CM_ULONG_FORMAT;

			case IP_STATIC_ROUTE_GATEWAY :
				*exact_offset += offsetof (CNF_IP_STATIC_ROUTE, gateway);
				return CM_ULONG_FORMAT;

			case IP_STATIC_ROUTE_MASK :
				*exact_offset += offsetof (CNF_IP_STATIC_ROUTE, mask);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = verify_ip_subnet_mask; 	
				if (ptr_to_interdependency_function)
				{
					*ptr_to_interdependency_function = set_static_route_mask_interdep;
				}
				return CM_ULONG_FORMAT;

			case IP_STATIC_ROUTE_METRIC :
				*exact_offset += offsetof (CNF_IP_STATIC_ROUTE, metric);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 16;
				}
				return CM_ULONG_FORMAT;

			case IP_STATIC_ROUTE_HOST :
				*exact_offset += offsetof (CNF_IP_STATIC_ROUTE, host);
				return CM_BYTE_FORMAT;
		}
	}

	if (port_no >= ptr_to_ip->ip_header.number_of_ports)
		return CM_UNKNOWN_FORMAT;
	offset_to_add += 	(ULONG) sizeof (CNF_IP_DNS) +
							(ULONG) sizeof (CNF_IP_STATIC_ROUTE) * 
			(ptr_to_ip->ip_header.number_of_static_route_table_entries);
	filter_offset_to_add = offset_to_add;
	for (i = 0; i < port_no; i ++)
	{
		ptr_to_ip_port = (CNF_IP_PORT *) (*exact_offset + filter_offset_to_add);
		filter_offset_to_add += sizeof (CNF_IP_PORT) + (
			(	ptr_to_ip_port->number_of_filter_dest_port_entries +
				ptr_to_ip_port->number_of_filter_source_port_entries +
				ptr_to_ip_port->number_of_forward_dest_port_entries +
				ptr_to_ip_port->number_of_forward_source_port_entries - 4) 
				* sizeof (CNF_IP_FILTER_PORT_INFO)) + (
			(	ptr_to_ip_port->number_of_filter_dest_address_entries +
				ptr_to_ip_port->number_of_filter_source_address_entries +
				ptr_to_ip_port->number_of_forward_dest_address_entries +
				ptr_to_ip_port->number_of_forward_source_address_entries - 4)
				* sizeof (CNF_IP_FILTER_ADDRESS_INFO));
	}

	switch (parameter_id)
	{
		case IP_PORT_ENABLE :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, enabled);
				return CM_BYTE_FORMAT;

		case IP_PORT_ADDRESS	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, address);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = validate_ip_port_address;	
				if (ptr_to_interdependency_function)
				{
					if (!port_no)
						*ptr_to_interdependency_function = set_snmp_local_internet_address_interdep;
					if (port_no == 1)
							*ptr_to_interdependency_function = set_ip_address_interdep;
				}
				return CM_ULONG_FORMAT;

		case IP_PORT_ADDRESS_MASK :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, address_mask);
				if (ptr_to_validation_function)
					*ptr_to_validation_function = verify_ip_subnet_mask; 	
/*					*ptr_to_validation_function = validate_ip_port_address; */	
				return CM_ULONG_FORMAT;			 

		case IP_PORT_FRAME_TYPE	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, frame_type);
				return CM_USHORT_FORMAT;

		case IP_PORT_METRIC :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, metric);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 16;
				}
				return CM_USHORT_FORMAT;

		case IP_PORT_MTU :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, mtu);
				return CM_USHORT_FORMAT;

		case IP_PORT_MAXIMUM_REASSEMBLY_SIZE :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, max_reassembly_size);
				return CM_USHORT_FORMAT;

		case IP_PORT_ARP :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, arp_enabled);
				return CM_BYTE_FORMAT;

		case IP_PORT_ARP_AGING_TIMEOUT :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, arp_aging_timeout);
				return CM_ULONG_FORMAT;

		case IP_PORT_ARP_REPLY_TIMEOUT :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, arp_reply_timeout);
				return CM_USHORT_FORMAT;

		case IP_PORT_ARP_NUMBER_OF_RETRANSMISSIONS :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, arp_number_of_retransmissions);
				return CM_USHORT_FORMAT;

		case IP_PORT_ICMP_MASK_REPLY :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

		case IP_PORT_ICMP_REDIRECT	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

		case IP_PORT_POINT_TO_POINT_LINK	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

		case IP_PORT_PROXY_ARP :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;

		case IP_PORT_RFC1042	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 3;
				return CM_BIT_FORMAT;

		case IP_PORT_REMOTE_ACCESS	:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 2;
				return CM_BIT_FORMAT;

		case IP_PORT_RARP_CLIENT :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_bits);
				valid_range[0] = 1;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_SEND_REQUESTS :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_SEND_RESPONSES :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_SPLIT_HORIZON :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_POISON_REVERSE :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_SUMMARIZE_ROUTES :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 3;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_ANNOUNCE_STATIC_ROUTES :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 2;
				return CM_BIT_FORMAT;

		case IP_PORT_RIP_ANNOUNCE_HOST_ROUTES :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, ip_port_rip_bits);
				valid_range[0] = 1;
				return CM_BIT_FORMAT;

		
		case IP_PORT_ICMP_PACKET_TYPES_ECHO_REPLY:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[0]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_DST_UNREACHABLE:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[1]);
				return CM_BYTE_FORMAT;


		case IP_PORT_ICMP_PACKET_TYPES_SRC_QUENCH:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[2]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_REDIRECT:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[3]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_ECHO_REQUEST:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[4]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_TIME_EXCEEDED:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[5]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_PARAM_PROBLEM:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[6]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_TIME_STAMP_REQUEST:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[7]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_TIME_STAMP_REPLY:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[8]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_ADR_MASK_REQUEST:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[9]);
				return CM_BYTE_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES_ADR_MASK_REPLY:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types[10]);
				return CM_BYTE_FORMAT;

		case IP_PORT_NOF_FILTER_DEST_PORT_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_filter_dest_port_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_NOF_FILTER_SOURCE_PORT_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_filter_source_port_entries);
				return CM_USHORT_FORMAT;
		
		case IP_PORT_NOF_FORWARD_DEST_PORT_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_forward_dest_port_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_NOF_FORWARD_SOURCE_PORT_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_forward_source_port_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_NOF_FILTER_DEST_ADDRESS_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_filter_dest_address_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_NOF_FILTER_SOURCE_ADDRESS_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_filter_source_address_entries);
				return CM_USHORT_FORMAT;
		
		case IP_PORT_NOF_FORWARD_DEST_ADDRESS_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_forward_dest_address_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_NOF_FORWARD_SOURCE_ADDRESS_ENTRIES:
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, number_of_forward_source_address_entries);
				return CM_USHORT_FORMAT;

		case IP_PORT_ICMP_PACKET_TYPES :
				*exact_offset += filter_offset_to_add + offsetof (CNF_IP_PORT, icmp_packet_types);
				valid_range[0] = NUMBER_OF_RECOGNIZED_ICMP_PACKET_TYPES ;
				valid_range[1] = 1;
				return CM_STRING_FORMAT;
	}

	*exact_offset +=	filter_offset_to_add;
	if ((parameter_id >= IP_FILTER_PORT_INFO_LOWER_END_PROTOCOL) &&
		 (parameter_id <= IP_FILTER_PORT_INFO_HIGHER_END_PORT_NUMBER))
	{
		if (!calculate_offset_of_ip_port_filter (exact_offset, valid_range[0]))
		{
			return CM_UNKNOWN_FORMAT;
		}
	}

	switch (parameter_id)
	{
		case IP_FILTER_PORT_INFO_LOWER_END_PROTOCOL:
				*exact_offset += offsetof (CNF_IP_FILTER_PORT_INFO, 
											lower_end_protocol);
				return CM_BYTE_FORMAT;
				
		case IP_FILTER_PORT_INFO_LOWER_END_PORT_NUMBER:
				*exact_offset += offsetof (CNF_IP_FILTER_PORT_INFO, 
											lower_end_port_number);
				return CM_USHORT_FORMAT;
				
		case IP_FILTER_PORT_INFO_HIGHER_END_PROTOCOL:
				*exact_offset += offsetof (CNF_IP_FILTER_PORT_INFO, 
											higher_end_protocol);
				return CM_BYTE_FORMAT;
				
		case IP_FILTER_PORT_INFO_HIGHER_END_PORT_NUMBER:
				*exact_offset += offsetof (CNF_IP_FILTER_PORT_INFO, 
											higher_end_port_number);
				return CM_USHORT_FORMAT;
				
		case IP_FILTER_PORT_TOTAL_NUMBER_OF_FILTERS :
		case IP_FILTER_PORT_FILTER_TYPE:
				return CM_SPECIAL_FORMAT;
	}


	if ((parameter_id >= IP_FILTER_ADDRESS_INFO_LOWER_END_IP_ADDRESS) &&
		 (parameter_id <= IP_FILTER_ADDRESS_INFO_HIGHER_END_IP_ADDRESS))
	{
		if (!calculate_offset_of_ip_address_filter (exact_offset, valid_range[0]))
		{
			return CM_UNKNOWN_FORMAT;
		}
	}

	switch (parameter_id)
	{
		case IP_FILTER_ADDRESS_INFO_LOWER_END_IP_ADDRESS:
				*exact_offset += offsetof (CNF_IP_FILTER_ADDRESS_INFO, 
											lower_end_ip_address);
				return CM_ULONG_FORMAT;
				
		case IP_FILTER_ADDRESS_INFO_HIGHER_END_IP_ADDRESS:
				*exact_offset += offsetof (CNF_IP_FILTER_ADDRESS_INFO, 
											higher_end_ip_address);
				return CM_ULONG_FORMAT;
				
		case IP_FILTER_ADDRESS_TOTAL_NUMBER_OF_FILTERS :
		case IP_FILTER_ADDRESS_FILTER_TYPE:
				return CM_SPECIAL_FORMAT;

		default : return CM_UNKNOWN_FORMAT;
	}
#endif
}

#if 0
enum CM_DATA_FORMAT get_cipx_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case CIPX_PPP_PORT_ENABLE:
				*exact_offset += offsetof (CNF_CIPX, cipx_ports[port_no].enabled);
				return CM_BYTE_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}


enum CM_DATA_FORMAT get_vjc_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case VJC_ENABLE:
				*exact_offset += offsetof (CNF_VJC, vjc_header.enabled);
				return CM_BYTE_FORMAT;

			case VJC_PORT_ENABLE:
				*exact_offset += offsetof (CNF_VJC, vjc_ports[port_no].enabled);
				if (ptr_to_interdependency_function)
					*ptr_to_interdependency_function = set_vjc_interdep;
				return CM_BYTE_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}

enum CM_DATA_FORMAT get_snmp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case SNMP_ENABLE :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.enabled);
				return CM_BYTE_FORMAT;

			case SNMP_SOCKET_INTERFACE :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.socket_interface);
				return CM_BYTE_FORMAT;

			case SNMP_MTU :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.mtu);
				return CM_USHORT_FORMAT;

			case SNMP_LOCAL_INTERNET_ADDRESS	:
				*exact_offset += offsetof (CNF_SNMP, snmp_header.local_internet_address);
				return CM_ULONG_FORMAT;

			case SNMP_PRINTF : 
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_INIT :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_SOCKET	:
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_PARSE :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 4;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_RECEIVE :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 3;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_TRANSMIT :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 2;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_MIB	:
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 1;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_DATA :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_1);
				valid_range[0] = 0;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_MEMORY	:
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_2);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case SNMP_PRINTF_ALARM	:
				*exact_offset += offsetof (CNF_SNMP, snmp_header.snmp_printfs_2);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case SNMP_TRAP_MANAGER_COMMUNITY_NAME :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.trap_manager_community_name);
				valid_range[0] = CNF_COMMUNITY_NAME_LENGTH;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

			case SNMP_TRAP_MANAGER_INTERNET_ADDRESS :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.trap_manager_internet_address);
				return CM_ULONG_FORMAT;

			case SNMP_TRAP_MANAGER_UDP_PORT_NUMBER :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.udp_port_number);
				if (ptr_to_validation_function)
				{
					*ptr_to_validation_function = check_whether_value_in_limit;
					valid_range[0] = 2;
					valid_range[1] = 1;
					valid_range[2] = 64000;
				}
				return CM_USHORT_FORMAT;

			case SNMP_COMMUNITY_NAME1 :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.community_name1);
				valid_range[0] = CNF_COMMUNITY_NAME_LENGTH;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

			case SNMP_PERMISSION1 :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.permission1);
				return CM_BYTE_FORMAT;

			case SNMP_COMMUNITY_NAME2 :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.community_name2);
				valid_range[0] = CNF_COMMUNITY_NAME_LENGTH;	
				valid_range[1] = 0;	
				return CM_STRING_FORMAT;

			case SNMP_PERMISSION2 :
				*exact_offset += offsetof (CNF_SNMP, snmp_header.permission2);
				return CM_BYTE_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}

enum CM_DATA_FORMAT get_tcp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			default : return CM_UNKNOWN_FORMAT;
		}
}


enum CM_DATA_FORMAT get_telnet_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case TELNET_SERVER_ENABLE :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.enabled);
				return CM_BYTE_FORMAT;

			case TELNET_SERVER_PASSWORD :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.server_password);
				valid_range[0] = 48;
				valid_range[1] = 1;
				if (ptr_to_validation_function)	
					return CM_SPECIAL_FORMAT;
				else
					return CM_STRING_FORMAT;

			case TELNET_MAXIMUM_NUMBER_OF_CONNECTIONS	:
				*exact_offset += offsetof (CNF_TELNET, telnet_header.max_number_of_connections);
				return CM_USHORT_FORMAT;

			case TELNET_DUMB_TTY_MANAGEMENT :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.dumb_tty_management);
				return CM_BYTE_FORMAT;

			case TELNET_TERMINAL_SERVER :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.terminal_server);
				return CM_BYTE_FORMAT;

			case TELNET_DEFAULT_SERVER_ADDRESS :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.default_server_address);
				return CM_ULONG_FORMAT;

			case TELNET_PRINTF :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.telnet_printfs);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case TELNET_PRINTF_RXTX	:
				*exact_offset += offsetof (CNF_TELNET, telnet_header.telnet_printfs);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case TELNET_PRINTF_ALARM :
				*exact_offset += offsetof (CNF_TELNET, telnet_header.telnet_printfs);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

			case TELNET_PORT_TERMINAL_SERVER	:
				if (port_no >= 1)
					return CM_UNKNOWN_FORMAT;
				*exact_offset += offsetof (CNF_TELNET, telnet_ports[port_no].terminal_server);
				return CM_BYTE_FORMAT;

			case TELNET_PORT_DEFAULT_SERVER_ADDRESS :
				if (port_no >= 1)
					return CM_UNKNOWN_FORMAT;
				*exact_offset += offsetof (CNF_TELNET, telnet_ports[port_no].default_server_address);
				return CM_ULONG_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}


enum CM_DATA_FORMAT get_tftp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case TFTP_ENABLE :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.enabled);
				return CM_BYTE_FORMAT;

			case TFTP_SOCKET_INTERFACE	:
				*exact_offset += offsetof (CNF_TFTP, tftp_header.socket_interface);
				return CM_BYTE_FORMAT;

			case TFTP_MAXIMUM_CONCURRENT_CONNECTIONS :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.max_concurrent_connections);
				return CM_USHORT_FORMAT;

			case TFTP_TIMEOUT_PERIOD :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.timeout_period);
				return CM_USHORT_FORMAT;

			case TFTP_NUMBER_OF_RETRANSMISSIONS :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.number_of_retransmissions);
				return CM_USHORT_FORMAT;

			case TFTP_PRINTF :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.tftp_printfs);
				valid_range[0] = 7;
				return CM_BIT_FORMAT;

			case TFTP_INIT_PRINTF :
				*exact_offset += offsetof (CNF_TFTP, tftp_header.tftp_printfs);
				valid_range[0] = 6;
				return CM_BIT_FORMAT;

			case TFTP_TRACE_PRINTF:
				*exact_offset += offsetof (CNF_TFTP, tftp_header.tftp_printfs);
				valid_range[0] = 5;
				return CM_BIT_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}
#endif 


enum CM_DATA_FORMAT get_dhcp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		CNF_DHCP_HEADER	*temp_dhcp_header_ptr;
		CNF_DHCP_ADDRESS_RANGE	*temp_dhcp_address_range_ptr;
  
		switch (parameter_id)
		{
			case DHCP_NUMBER_OF_ADDRESS_RANGE_ENTRIES :
				*exact_offset += offsetof (CNF_DHCP, dhcp_header.number_of_address_range_entries);
		 		return CM_USHORT_FORMAT;

			case DHCP_SERVER_ENABLE :
				*exact_offset += offsetof (CNF_DHCP, dhcp_header.dhcp_server_enabled);
				return CM_BYTE_FORMAT;

			case DHCP_CLIENT_ENABLE :
				*exact_offset += offsetof (CNF_DHCP, dhcp_header.dhcp_client_enabled);
				return CM_BYTE_FORMAT;

			case DHCP_SERVER_IP_ADDRESS :
				*exact_offset += offsetof (CNF_DHCP, dhcp_header.dhcp_server_ip_address);
				return CM_ULONG_FORMAT;

			default: return CM_UNKNOWN_FORMAT ;
		}
}


enum CM_DATA_FORMAT get_proxy_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{		
	int i;
	CNF_PROXY_PORT *proxy_port_ptr ;
	CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
	CNF_PROXY_APPLICATION   *proxy_application_ptr ;
	CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_defined_app_ptr;
	CNF_PROXY_FILTER *proxy_filter_ptr ; 
	CNF_PROXY_HEADER *temp_header_ptr = NULL ;


 	if ((parameter_id < PROXY_NUMBER_OF_PORTS || parameter_id > PROXY_PORT_ADDRESS))	
 		return CM_UNKNOWN_FORMAT;

 	if (parameter_id < PROXY_NUMBER_OF_APPLICATION_ENTRIES)
 	{
 		switch(parameter_id)
		{
			case PROXY_NUMBER_OF_PORTS :
			  	*exact_offset += offsetof (CNF_PROXY, proxy_header.number_of_ports);
				return CM_USHORT_FORMAT;
 		
			case PROXY_ENABLE :
				*exact_offset += offsetof (CNF_PROXY, proxy_header.enabled);				
				return CM_BYTE_FORMAT;

			case PROXY_ANY_APP :
				*exact_offset += offsetof (CNF_PROXY, proxy_header.proxy_any_app);				
				return CM_BYTE_FORMAT;
		}
	}
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	if (parameter_id == PROXY_FTP_CONTROL_CONNECTION)
	{
	 	*exact_offset += offsetof (CNF_PROXY, proxy_header.ftp_control_port) ;
	 	return CM_USHORT_FORMAT ;
	}
	if (parameter_id == PROXY_FTP_DATA_CONNECTION)
	{
	 	*exact_offset += offsetof (CNF_PROXY, proxy_header.ftp_data_port) ;
	 	return CM_USHORT_FORMAT ;
	}
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	
	temp_header_ptr = (CNF_PROXY_HEADER *) *exact_offset ;
	proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
	*exact_offset = (ULONG) proxy_application_ptr;
  	
	if (parameter_id == PROXY_NUMBER_OF_APPLICATION_ENTRIES)
	{
		*exact_offset +=  offsetof (CNF_PROXY_APPLICATION, number_of_application_entries);				
		return CM_USHORT_FORMAT;
	}

	proxy_user_defined_app_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)
		 ((char *)proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + 
			(4 * (proxy_application_ptr->number_of_application_entries - 1))))) ;
	*exact_offset = (ULONG) proxy_user_defined_app_ptr;

	if(parameter_id == PROXY_NUMBER_OF_USER_DEFINED_APPLICATION_ENTRIES)
	{
		*exact_offset +=  offsetof (CNF_PROXY_USER_DEFINED_APPLICATION, number_of_user_defined_application_entries);				
		return CM_USHORT_FORMAT;
	}

	proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_app_ptr + 
		(sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * 
				(proxy_user_defined_app_ptr->number_of_user_defined_application_entries - 1))))) ;
	*exact_offset = (ULONG) proxy_virtual_server_ptr ;

	if (parameter_id < PROXY_FILTER_NO_OF_FORBIDDEN_SITES_ENTRIES)
	{
		switch (parameter_id)
		{
   	   case PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES :
		  		*exact_offset += offsetof (CNF_PROXY_VIRTUAL_SERVER, number_of_global_address_entries);				
				return CM_USHORT_FORMAT;

   	   case PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_VIRTUAL_SERVER, number_of_static_mapping_entries);
				return CM_USHORT_FORMAT;

			case PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_VIRTUAL_SERVER, number_of_dynamic_mapping_entries);
				return CM_USHORT_FORMAT;

			case PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS :
				*exact_offset += offsetof (CNF_PROXY_VIRTUAL_SERVER, dynamic_mapping_global_address);			 
				return CM_ULONG_FORMAT;
		}
	}
	proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
	                       (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
	                       (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
	                       (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 

	*exact_offset = (ULONG) proxy_filter_ptr;

	if (parameter_id < PROXY_PORT_ENABLE)
	{
		switch(parameter_id)
		{
			case PROXY_FILTER_NO_OF_FORBIDDEN_SITES_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_FILTER, number_of_forbidden_sites_entries);			 
				return CM_USHORT_FORMAT;

			case PROXY_FILTER_NO_OF_RESTRICTED_CLIENTS_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_FILTER, number_of_restricted_clients_entries);
				return CM_USHORT_FORMAT;

			case PROXY_FILTER_NO_OF_RESTRICTED_APPLICATION_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_FILTER, number_of_restricted_application_entries);
				return CM_USHORT_FORMAT;

			case PROXY_FILTER_NO_OF_MAC_ADDRESS_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_FILTER, number_of_mac_address_entries);
				return CM_USHORT_FORMAT;

			case PROXY_FILTER_NO_OF_DOMAIN_NAME_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_FILTER, number_of_domain_name_entries);
				return CM_USHORT_FORMAT;
		}
	}	
	proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
	                   (proxy_filter_ptr->number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
	                   (proxy_filter_ptr->number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
	                   (proxy_filter_ptr->number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
	                   (proxy_filter_ptr->number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
	                   (proxy_filter_ptr->number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

	*exact_offset = (ULONG) proxy_port_ptr;

	for ( i = 0; i < port_no; i++)
	{
		proxy_port_ptr = (CNF_PROXY_PORT *) *exact_offset ;
		*exact_offset += sizeof (CNF_PROXY_PORT) + 
			((proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)) ;
	}	
  
	switch(parameter_id)
 	{
			case PROXY_PORT_ENABLE :
			*exact_offset += offsetof (CNF_PROXY_PORT, enabled);
				return CM_BYTE_FORMAT;

 			case PROXY_PORT_NUMBER_OF_ADDRESS_ENTRIES :
				*exact_offset += offsetof (CNF_PROXY_PORT, number_of_address_entries);
				return CM_USHORT_FORMAT;

			case PROXY_PORT_NUMBER_OF_CONNECTIONS_TO_TRIGGER :
				*exact_offset += offsetof (CNF_PROXY_PORT, number_of_connections_to_trigger);
				return CM_USHORT_FORMAT;

			case PROXY_PORT_NUMBER_OF_HOSTS_TO_TRIGGER :
				*exact_offset += offsetof (CNF_PROXY_PORT, number_of_hosts_to_trigger);
				return CM_USHORT_FORMAT;

			case PROXY_PORT_ADDRESS :
				*exact_offset += (sizeof(CNF_PROXY_PORT) - sizeof(CNF_PROXY_ADDRESS_INFO)) + offsetof (CNF_PROXY_ADDRESS_INFO, address);
				return CM_ULONG_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}
/* ...Imran 19.8.98 */ 

#ifdef _BIG_PROXY_
enum CM_DATA_FORMAT get_web_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			case WEB_SERVER_ENABLE :
				*exact_offset += offsetof (CNF_WEB, web_header.server_enabled);
				return CM_BYTE_FORMAT;

			default : return CM_UNKNOWN_FORMAT;
		}
}
#endif

#if 0
enum CM_DATA_FORMAT get_ag_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			default : return CM_UNKNOWN_FORMAT;
		}
}

enum CM_DATA_FORMAT get_script_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *))
{
		switch (parameter_id)
		{
			default : return CM_UNKNOWN_FORMAT;
		}
}
#endif

int get_the_section_number (enum CM_SECTIONS section_id)
{
	return((int)section_id);
}

/* General API Functions */				

enum CM_GET_RESULTS get_parameter (ULONG connection_id,
											enum CM_SECTIONS section_id,
											ULONG parameter_id,
											USHORT port_number,
											enum CM_DATA_FORMAT required_data_format,
											void *data_ptr,
											int nbytes,
											char *error_string)
{
	enum CM_DATA_FORMAT actual_data_type, special_format_type;
	int section_num_value, bit_position, value_to_shift, length;
	ULONG offset, temp = 0;
	static ULONG save_offset = 0;   /* this is reqd. to handle ppp options */
	ULONG range_value[100], no_null_char;
	char store_temp_value[128];

	USER_LIST *ptr_to_user;

	ptr_to_user = (USER_LIST *) ptr_user_list.sptr_forward_link;
	if (connection_id == ptr_to_user->Connection_ID)
		offset = (ULONG) write_permitted_structures[section_id].ptr_to_struct;
	else
	{
		ptr_to_user = (USER_LIST *) ptr_to_user->links.sptr_forward_link;
		while (ptr_to_user != NULL)
		{
			if (ptr_to_user->Connection_ID == connection_id)
				break;
			ptr_to_user = (USER_LIST *) ptr_to_user->links.sptr_forward_link;
		}
		if (ptr_to_user == NULL)
		{
			if (error_string != NULL)
				strcpy (error_string, "Your ID is not there in user list");			
			printf ("returning off since ID %lu is not in list\n", connection_id);
			return CM_GET_ILLEGAL_USER_ID;
		}
		offset = (ULONG) read_only_structures[section_id].ptr_to_struct;
	}
	cm_keep_alive_configuration_manager (connection_id);

	section_num_value = get_the_section_number (section_id);

/*	if (required_data_format == CM_STRUCTURE_FORMAT) */
	range_value[0] = (ULONG) nbytes;
	range_value[5] = 1; 

	/* Imran 2/9/98 */
	/* To handle PPP options,two calls should be made to get_parameter.The first
	   call should contain the para_id of the parameter whose option is 
		required and the next call should contain the para_id of the option */
	if ((parameter_id > PPP_PORT_IPCP_DNS_ADDRESS2 )  && (parameter_id < WAN_ENABLE))
	{
	 	if (save_offset)
		{
			actual_data_type = (*ptr_to_function[section_num_value].get_field_info) (parameter_id, 
					port_number, &save_offset, range_value, NULL, NULL);
			offset = save_offset ;
			save_offset = 0;
		}
		else
		{
			return CM_GET_FAILED;
		}
	}
	else
	{
		actual_data_type = (*ptr_to_function[section_num_value].get_field_info) (parameter_id, 
					port_number, &offset, range_value, NULL, NULL);
/* Jo 12/07/99 Changed for RAS */
		if (parameter_id > PPP_PORT_REMOTE_PORT_CLIENT_ONLY  &&  parameter_id < PPP_OPTION_TYPE)
		{
			save_offset = offset ;
			return CM_GET_SUCCESSFUL; /* On returning,another call should be made to get the reqd. option */
		}
   }
	/* Imran 2/9/98 */

	if (actual_data_type == CM_UNKNOWN_FORMAT)
	{
		if (error_string != NULL)
			strcpy (error_string, "Invalid or Unprocessed Parameter ID");
		printf ("error :get data %lu and section %u of port no %d error while reading\n", 
					parameter_id, section_id, port_number);
	 	return CM_GET_UNKNOWN_PARAMETER_ID;
	}

	switch (actual_data_type)
	{
		case CM_USHORT_FORMAT 	:	temp = (ULONG) *((USHORT *) offset);
											break;
		case CM_ULONG_FORMAT 	:	temp = (ULONG) *((ULONG *) offset);
											break;
		case CM_BYTE_FORMAT 		:	temp = (ULONG) *((BYTE *) offset);
											break;

		case CM_STRING_FORMAT 	:	length = range_value[0]; 
		/* range string will contain the actual length of the string followed by 
		 whether it is null terminated (0) or no null terminating char (1) */
											no_null_char = range_value[1];
											if (no_null_char)
											{
												memcpy (store_temp_value, (char *) offset, length);
												store_temp_value[length] = 0;
											}
											else
												strcpy (store_temp_value, (char *) offset);

											length = strlen (store_temp_value);
											length ++; /* one for null char */
											if (length  > nbytes && range_value[5])
											{
												if (error_string != NULL)
													sprintf (error_string, "%lu", range_value[0]);
												printf ("error :INsufficient buffer, required is %d sent is %d\n", length, nbytes);
												return CM_GET_INSUFFICIENT_BUFFER_SPACE;
											}
											if (required_data_format != CM_STRING_FORMAT)
											{
												if (convert_from_string_to_long (store_temp_value, &temp) == FALSE)
												{
												 	if (error_string != NULL)
														strcpy (error_string, "Actual is String Format");
													printf ("error :INvalid data format\n");
													return CM_GET_INVALID_DATA_FORMAT;
												}
											}
											else
											{
												temp = (ULONG) strlen (store_temp_value);
												if ((nbytes >= (int) temp) || !range_value[5])
												{
													strcpy (data_ptr, store_temp_value);
													return CM_GET_SUCCESSFUL;
												}
												else
												{
													if (error_string != NULL)
												 		sprintf (error_string, "%d", temp);
													return CM_GET_INVALID_STRING_LENGTH;
												}
											}
											break;

		case CM_BIT_FORMAT 		:	temp = (ULONG) *((BYTE *) offset);
			/* assuming that in valid range we are obtaining exact bit position */
											value_to_shift = (int) range_value[0];
											bit_position = 1;
											bit_position <<= value_to_shift;
											temp &= bit_position;
											if (temp)
												temp = 1;
											break;
											/* valid_range will contain the length */ 
		case CM_STRUCTURE_FORMAT:	if (required_data_format != CM_STRUCTURE_FORMAT)
											{
												if (error_string != NULL)
													strcpy (error_string, "Only Structure Format");
												return CM_GET_INVALID_DATA_FORMAT;
											}

											break;

/* Imran , 10.3.99 */
		case CM_SPECIAL_FORMAT:		
			if(parameter_id == PPP_PORT_USER_PASSWORD)
			{
				strcpy(data_ptr,(char *) offset);
				return CM_GET_SUCCESSFUL;
			}
			break;

#if 0
				i = 0;
				temp = nbytes;	
				while (special_format[i].parameter_id != NULL)
				{
					if (special_format[i].parameter_id == parameter_id)
						if (special_format[i].read_processing_fn != NULL)
						{
							special_format_type = (special_format[i].read_processing_fn) (connection_id, parameter_id, port_number, &temp);
							if (special_format_type == CM_UNKNOWN_FORMAT)
							{
								printf ("Invalid Special data format\n");
								return CM_GET_FAILED;
							}
							break;
						}
					i ++;
				}
				break;
#endif
	}

	switch (required_data_format)
	{
		case CM_USHORT_FORMAT 	:	* (USHORT *) data_ptr = (USHORT) temp;
											break;

		case CM_ULONG_FORMAT 	:	*(ULONG *) data_ptr = (ULONG) temp;
											break;

		case CM_BIT_FORMAT 		:	
		case CM_BYTE_FORMAT 		:	* (BYTE *) data_ptr = (BYTE) temp;
											break;

		case CM_STRING_FORMAT 	:	if (actual_data_type != CM_SPECIAL_FORMAT)
											{
												sprintf (data_ptr, "%lu", temp);
											}
											else
											{
												if (special_format_type == CM_STRING_FORMAT)
												{
													strcpy (data_ptr, (char *) temp);
													free ((void *) temp);
												}
												else
													sprintf (data_ptr, "%lu", temp);
											}
											break;

		case CM_DOT_FORMAT		:	get_dot_decimal_ip_address (temp, (char *) data_ptr);
											break;
		case CM_STRUCTURE_FORMAT:	
											break;
	}
	return CM_GET_SUCCESSFUL;
}

enum CM_SET_RESULTS set_parameter (ULONG connection_id,
											enum CM_SECTIONS section_id,
											ULONG parameter_id,
											USHORT port_number,
											enum CM_DATA_FORMAT data_format,
											void *data_ptr,
											int nbytes,
											char *error_string)
{
	ULONG actual_value, offset;
	static ULONG save_offset;  /* used for ppp options */
	enum CM_DATA_FORMAT actual_data_type;
	char store_temp_value[128];
	char no_null_char, store_byte_value, store_valid_range_string[10];
	ULONG range_value[15];	
	int section_num_value, bit_value_to_set, value_to_shift, length;
	void *ptr_to_send; 
	enum BOOLEAN (*validation_fn_ptr)(ULONG *, char *);
	void (*interdependency_fn_ptr)(void *data_ptr, USHORT port_no, int index);
	int i;
	BYTE ftp_ctrl = 0 ;
	USHORT ftp_prev_port_number = 0 ;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[section_id].ptr_to_struct;
	else
	{
		if (error_string != NULL)
			put_write_access_owner_type (error_string);
	 	return CM_SET_NO_WRITE_PERMISSION;
	}

	cm_keep_alive_configuration_manager (connection_id);

	interdependency_fn_ptr =  NULL;
	validation_fn_ptr = NULL;
	section_num_value = get_the_section_number (section_id);

	range_value[0] = nbytes;

	/* Imran 2/9/98 */
	/* To handle PPP options,two calls should be made to get_parameter.The first
	   call should contain the para_id of the parameter whose option is 
		required and the next call should contain the para_id of the option */
	if ((parameter_id > PPP_PORT_IPCP_DNS_ADDRESS2 )  && (parameter_id < WAN_ENABLE))
	{
	 	if (save_offset)
		{
			actual_data_type = (*ptr_to_function[section_num_value].get_field_info) (parameter_id, 
					port_number, &save_offset, range_value, &interdependency_fn_ptr, &validation_fn_ptr);
			offset = save_offset ;
			save_offset = 0;
		}
		else
		{
			return CM_SET_FAILED;
		}
	 }
	 else
	 {
		actual_data_type = (*ptr_to_function[section_num_value].get_field_info) (parameter_id, 
					port_number, &offset, range_value, &interdependency_fn_ptr, &validation_fn_ptr);
		if (parameter_id >= PPP_PORT_OPTION_LCP_ACCM  &&  parameter_id <= PPP_PORT_IPCP_DNS_ADDRESS2)
		{
			save_offset = offset ;
			return CM_SET_SUCCESSFUL; /* On returning,another call should be made to get the reqd. option */
		}
	 }
	/* Imran 2/9/98 */

	if (actual_data_type == CM_UNKNOWN_FORMAT)
	{
		if (error_string != NULL)
			strcpy (error_string, "Invalid or Unprocessed Parameter ID");
	 	return CM_SET_UNKNOWN_PARAMETER_ID;
	}

/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */

	if ((section_id == CM_PROXY_SECTION) && (parameter_id == PROXY_FTP_CONTROL_CONNECTION))
	{
      get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION, 
	 		CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_prev_port_number, sizeof (USHORT), NULL) ;
		ftp_prev_ctrl_port_number = ftp_prev_port_number ;
	}

	if ((section_id == CM_PROXY_SECTION) && (parameter_id == PROXY_FTP_DATA_CONNECTION))
	{
      get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_prev_port_number, sizeof (USHORT), NULL) ;
		ftp_prev_data_port_number = ftp_prev_port_number ;
	}
/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */

	if (actual_data_type == CM_STRING_FORMAT)
		ptr_to_send = (void *) store_temp_value;
	else
		ptr_to_send = (void *) &actual_value;
	actual_value = 0;

	/* range string will contain the actual length of the string */
	length = range_value[0]; 
	if (!convert_data_format (data_format, data_ptr, actual_data_type, ptr_to_send, &length))
	{
		if (error_string != NULL)
			strcpy (error_string, "Error While Conversion");
		return CM_SET_INVALID_DATA_FORMAT;
	}

	/* check whether values passed are proper, checks for interdependencies */
	if (validation_fn_ptr)
	{
		range_value[10] = port_number;	
		if ((*validation_fn_ptr) (range_value, ptr_to_send) == FALSE)
		{
			if (error_string != NULL)
			{
				sprintf (error_string, "%lu", range_value[0]);
				if (actual_data_type != CM_STRING_FORMAT)
					for (i = 0; i < range_value[0]; i ++)
					{
						sprintf (store_valid_range_string, "%lu", range_value[i]);
						strcat (error_string, store_valid_range_string);
					}
			}
			return CM_ERROR_WHILE_VALIDATING;
		}
	}

	switch (actual_data_type)
	{
		case CM_USHORT_FORMAT 	:	*((USHORT *) offset) = (USHORT)actual_value;
											break;

		case CM_ULONG_FORMAT 	:	*((ULONG *) offset) = actual_value;
											break;

		case CM_BYTE_FORMAT 		:	*((BYTE *) offset) = (BYTE)actual_value;
											break;

		case CM_STRING_FORMAT 	:	
		/* whether it is null terminated (0) or no null terminating char (1) */
											no_null_char = range_value[1];
											if (no_null_char)
												memcpy ((char *) offset, store_temp_value, length);
											else
												strcpy ((char *) offset, store_temp_value);
											break;
	
		case CM_BIT_FORMAT 		:	store_byte_value = *((BYTE *) offset);
			/* Assuming that in valid range we are obtaining exact bit position
			 Previous value of byte has to be retrieved and only one bit in
			 that has to be changed*/
											value_to_shift = range_value[0];
											bit_value_to_set = 1;
											bit_value_to_set <<= value_to_shift;
											if (actual_value)
												store_byte_value |= bit_value_to_set;
											else
												store_byte_value &= ~bit_value_to_set;
											*((BYTE *) offset) = store_byte_value;
											break;


/* Imran , 10.3.99 */
		case CM_SPECIAL_FORMAT:		
				i = 0;
				while (special_format[i].parameter_id != NULL)
				{
					if (special_format[i].parameter_id == parameter_id)
						if (special_format[i].write_processing_fn != NULL)
					 	{
/*							if ((special_format[i].write_processing_fn) (parameter_id, port_number, nbytes, (char *) data_ptr) == CM_UNKNOWN_FORMAT)*/
/* Jo 21/09/99 Changed to store proper password */
							if ((special_format[i].write_processing_fn) ((char *) data_ptr, port_number, parameter_id, nbytes) == CM_UNKNOWN_FORMAT)
								return CM_SET_INVALID_DATA_FORMAT;
/*							(special_format[i].write_processing_fn) (parameter_id, port_number, nbytes, (char *) data_ptr);*/
						  	break;
						}
					i ++;
				}
				break;

				default : 
							if (error_string != NULL)
								strcpy (error_string, "Not Supported");
							return CM_SET_INVALID_DATA_FORMAT;
	}

/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */

	if ((section_id == CM_PROXY_SECTION) && (parameter_id == PROXY_FTP_CONTROL_CONNECTION))
	{
		ftp_ctrl = 1 ;
		set_ftp_port_numbers_in_global_structure(connection_id, ftp_ctrl, ftp_prev_port_number) ;
	}

	if ((section_id == CM_PROXY_SECTION) && (parameter_id == PROXY_FTP_DATA_CONNECTION))
	{
		ftp_ctrl = 0 ;
		set_ftp_port_numbers_in_global_structure(connection_id, ftp_ctrl, ftp_prev_port_number) ;
	}

/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */

	/* set interdependencies if there are any corresponding to given para id */
	if (interdependency_fn_ptr)
		(*interdependency_fn_ptr) (ptr_to_send, port_number, nbytes);

	return CM_SET_SUCCESSFUL;
}

enum CM_ADD_RESULTS add_parameters (ULONG connection_id,
											enum CM_SECTIONS section_id,
					   					ULONG parameter_id,
											USHORT port_number,
											void *struct_to_write,
											char *error_string)
{
	int i;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
	{
		cm_keep_alive_configuration_manager (connection_id);
		i = 0;
		while (add_a_set_of_parameters[i].parameter_id != (ULONG) NULL)
		{
			if (add_a_set_of_parameters[i].parameter_id == parameter_id)
				if ((add_a_set_of_parameters[i].add_parameters_to_section) (parameter_id,
						 port_number, struct_to_write))
					return CM_ADD_SUCCESSFUL;
				else
					return CM_ADD_FAILED;
			i ++;
		}
	}
	else
	{
		if (error_string != NULL)
			put_write_access_owner_type (error_string);
/*			strcpy (error_string, "You do not have write permission"); */
		return CM_ADD_NO_WRITE_PERMISSION;
	}
	return CM_ADD_INVALID_PARAMETER_ID;
}


enum CM_DELETE_RESULTS delete_parameters (ULONG connection_id,
											enum CM_SECTIONS section_id,
											ULONG parameter_id,
											USHORT port_number,
											int index_of_route_or_filter,
											char *error_string)
{
	int i;
	
	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
	{
		cm_keep_alive_configuration_manager (connection_id);
		i = 0;
		while (delete_a_set_of_parameters[i].parameter_id != (ULONG) NULL)
		{
			if (delete_a_set_of_parameters[i].parameter_id == parameter_id)
				if ((delete_a_set_of_parameters[i].delete_parameters_from_section) (parameter_id,
						 port_number, index_of_route_or_filter))
					return CM_DELETE_SUCCESSFUL;
				else
					return CM_DELETE_FAILED;
			i ++;
		}
	}
	else
	{
		if (error_string != NULL)
/*			strcpy (error_string, "You do not have write permission");*/
			put_write_access_owner_type (error_string);
	 	return CM_DELETE_NO_WRITE_PERMISSION;
	}
	return CM_DELETE_INVALID_PARAMETER_ID;
}

/*  Imran 4/9/98  */
int cm_get_entry(USHORT  parameter_id, USHORT section_id, ULONG *offset,
						USHORT *entry_num,USHORT index)
{
	int i = 0;
	ULONG temp_offset, ret_offset, size_of_struct;

	temp_offset = (ULONG) write_permitted_structures[section_id].ptr_to_struct;

	while (get_offset_to_parameters[i].parameter_id != (ULONG) NULL)
	{
 		if (get_offset_to_parameters[i].parameter_id == parameter_id)
		{
			get_offset_to_parameters[i].get_offset_to_section(&temp_offset);
			break;
		}
		else
			i ++;
	}

	switch (parameter_id)
	{
		case PROXY_FILTER :
			switch(index)
			{
				case PROXY_DEST_ADDR_FILTER :
								index = 0;
								size_of_struct = sizeof(CNF_PROXY_ADDRESS_INFO);
								break;

				case PROXY_SOURCE_ADDR_FILTER :
								index = 1;
								size_of_struct = sizeof(CNF_PROXY_ADDRESS_INFO);
								break;

				case PROXY_APP_FILTER :		
								index = 2;
								size_of_struct = sizeof(CNF_PROXY_APP);
								break;

				case PROXY_MAC_ADDR_FILTER :
								index = 3;
								size_of_struct = sizeof(CNF_PROXY_MAC_ADDRESS_INFO);
								break;

				case PROXY_DNS_ADDR_FILTER :
								index = 4;
								size_of_struct = sizeof(CNF_PROXY_DOMAIN_NAME_INFO);
								break;
			}
			calculate_offset_to_each_proxy_filter(&temp_offset, &ret_offset, index);
			temp_offset = ret_offset;
			temp_offset += (size_of_struct * (*entry_num));
			break;

		case PROXY_APPLICATION :
			temp_offset += sizeof(USHORT) + (sizeof(CNF_PROXY_APP) * (*entry_num));
			break;

		case PROXY_USER_APPLICATION :
			temp_offset += sizeof(USHORT) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (*entry_num));
			break;

		case PROXY_LINK :
			calculate_offset_of_proxy_port(&temp_offset, index);
			temp_offset += sizeof(BYTE) + (3 * sizeof(USHORT)) +  (sizeof(CNF_PROXY_ADDRESS_INFO) * (*entry_num));
			break;

		case PROXY_NAT :
	 		calculate_offset_to_each_proxy_entry(&temp_offset, &ret_offset, index);
	 		temp_offset = ret_offset ;
	 		switch(index)
	 		{
	 			case 0 : temp_offset += (sizeof(CNF_PROXY_ADDRESS_INFO) * (*entry_num));
	 						break;

	 			case 1 : temp_offset += (sizeof(CNF_PROXY_STATIC_INFO) * (*entry_num));
	 						break;

	 			case 2:  temp_offset += (sizeof(CNF_PROXY_DYNAMIC_INFO) * (*entry_num));
	 						break;
	 		}
	 		break;
	}
	(*entry_num)++;
	*offset = temp_offset ;
	return TRUE;
}
	 
int cm_edit_entry(ULONG connection_id, enum CM_SECTIONS section_id,ULONG parameter_id,
							USHORT index, void *struct_to_write,int filter_type_or_port_no)
{
	ULONG del_para_id, add_para_id ;

	switch(parameter_id)
	{
		case PROXY_APPLICATION:
			del_para_id = DELETE_PROXY_APPLICATION ;
			add_para_id = ADD_PROXY_APPLICATION;
			break;
	
		case PROXY_USER_APPLICATION:
			del_para_id = DELETE_PROXY_USER_APP ;
			add_para_id = ADD_PROXY_USER_APP;
			break;

		case PROXY_FILTER:
			switch(filter_type_or_port_no)
			{
				case PROXY_APP_FILTER:
					del_para_id = DELETE_RESTRICTED_APPLICATION_ENTRIES;
					add_para_id = ADD_RESTRICTED_APPLICATION_ENTRIES;
					break;

				default  :
					del_para_id = DELETE_PROXY_ADDRESS_FILTER;
					add_para_id = ADD_PROXY_ADDRESS_FILTER;
			}
			break;

		 case	PROXY_NAT :
			switch(filter_type_or_port_no)		 	
			{
				case 0 :
					del_para_id = DELETE_GLOBAL_ADDRESS_ENTRIES;
					add_para_id = ADD_GLOBAL_ADDRESS_ENTRIES;
					break;

				case 1 :
					del_para_id = DELETE_PROXY_STATIC_MAPPING;
					add_para_id = ADD_PROXY_STATIC_MAPPING;
					break;

				case 2:
					del_para_id = DELETE_PROXY_DYNAMIC_MAPPING;
					add_para_id = ADD_PROXY_DYNAMIC_MAPPING;
					break;
			}
			break;
	}	

	switch(delete_parameters(connection_id,section_id, del_para_id, filter_type_or_port_no,
										(index-1), NULL))
	{
		 case CM_DELETE_SUCCESSFUL : break;
		 default : return FALSE;
	 }
	switch(add_parameters(connection_id,section_id, add_para_id, filter_type_or_port_no, struct_to_write,NULL))
	{
		case CM_ADD_SUCCESSFUL : break;
		default : return FALSE;
	}
	return TRUE;
}
/*  Imran 4/9/98  */

/* Jo 19/08/99 Added for static routes */

void get_number_of_static_routes (USHORT *number_of_entries)
{
	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;

	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	*number_of_entries = static_routes_header_ptr->number_of_static_routes ;	
}

int cm_get_static_entry (enum CM_SECTIONS section_id, STRUCT_STATIC_ROUTE **static_route_entry,	
			USHORT *entry_num)
{
	ULONG offset, ret_offset, size_of_struct ;

	offset = (ULONG) write_permitted_structures[section_id].ptr_to_struct ;
	calculate_offset_of_static_route_entry (&offset) ;
	offset += (sizeof(STRUCT_STATIC_ROUTE) * (*entry_num)) ;
	*static_route_entry = (STRUCT_STATIC_ROUTE *) offset ;
	(*entry_num)++ ;
	return TRUE ;
}

void calculate_offset_of_static_route_entry (ULONG *offset)
{
	CNF_STATIC_ROUTES_HEADER *temp_static_routes_header_ptr ;
	CNF_STATIC_ROUTES_INFO *temp_static_routes_info_ptr ;

	temp_static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) *offset ;
	temp_static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) ((char *)temp_static_routes_header_ptr + sizeof (CNF_STATIC_ROUTES_HEADER)) ;
	*offset = (ULONG)	temp_static_routes_info_ptr ;
}

int cm_edit_static_route_entry (ULONG connection_id, enum CM_SECTIONS section_id,
							USHORT index, void *struct_to_write, int filter_type_or_port_no)
{
	switch (delete_parameters (connection_id, section_id, DELETE_STATIC_ROUTE, filter_type_or_port_no,
										(index-1), NULL))
	{
		 case CM_DELETE_SUCCESSFUL : break ;
		 default : return FALSE ;
	}
	switch (add_parameters (connection_id, section_id, ADD_STATIC_ROUTE, filter_type_or_port_no, struct_to_write, NULL))
	{
		case CM_ADD_SUCCESSFUL : break ;
		default : return FALSE ;
	}
	return TRUE ;
}

int add_static_route_entry (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, SizetoRealloc, SizeToMove, dst_offset ;

	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;
	CNF_STATIC_ROUTES_INFO *static_routes_info_ptr ;
	STRUCT_STATIC_ROUTE	*struct_static_routes_ptr ;

	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;

	SizetoRealloc = static_routes_header_ptr->section_length + sizeof (CNF_STATIC_ROUTES_INFO) ;
	write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct = (char *) my_realloc (write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct,
						static_routes_header_ptr->section_length, SizetoRealloc) ;
	write_permitted_structures[CM_STATIC_ROUTES_ID].size_of_struct = (USHORT) SizetoRealloc ;

	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	static_routes_header_ptr->section_length = (USHORT) SizetoRealloc ;
	offset = (ULONG) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	calculate_offset_of_static_route_entry (&offset) ;

	offset += (sizeof(CNF_STATIC_ROUTES_INFO) * static_routes_header_ptr->number_of_static_routes) ;
	SizeToMove = (ULONG) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct + static_routes_header_ptr->section_length - offset ;
	dst_offset = offset + sizeof(CNF_STATIC_ROUTES_INFO) ;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	calculate_offset_of_static_route_entry (&offset) ;
	static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) (offset + 
		(sizeof(CNF_STATIC_ROUTES_INFO) * static_routes_header_ptr->number_of_static_routes)) ;
	
	struct_static_routes_ptr = (STRUCT_STATIC_ROUTE *) struct_to_write ;

	static_routes_info_ptr->port_number = struct_static_routes_ptr->port_number ;
	static_routes_info_ptr->host_ip_address = struct_static_routes_ptr->ip_address ;
	static_routes_info_ptr->host_gateway = struct_static_routes_ptr->gateway_address ;
	static_routes_info_ptr->host_address_mask = struct_static_routes_ptr->address_mask ;
	static_routes_info_ptr->metric = struct_static_routes_ptr->metric ;

	static_routes_header_ptr->number_of_static_routes++ ;	

	return TRUE ;
}

int delete_static_route_entry (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, SizetoRealloc, SizeToMove, dst_offset ;
	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;
	CNF_STATIC_ROUTES_INFO *static_routes_info_ptr ;

	offset = (ULONG) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) offset ;
	
	if (index_to_delete < 0 || index_to_delete > static_routes_header_ptr->number_of_static_routes-1)
		return FALSE ;

	static_routes_header_ptr->number_of_static_routes-- ;	
	calculate_offset_of_static_route_entry (&offset) ;

	offset += sizeof(CNF_STATIC_ROUTES_INFO) * (index_to_delete + 1) ;
	dst_offset = offset - sizeof(CNF_STATIC_ROUTES_INFO) ;
	SizeToMove = (ULONG) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct + static_routes_header_ptr->section_length - offset ;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
	SizetoRealloc = (static_routes_header_ptr->section_length - sizeof(CNF_STATIC_ROUTES_INFO)) ;
	write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct = (char *) my_realloc (write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct,	
						static_routes_header_ptr->section_length, SizetoRealloc) ;
	write_permitted_structures[CM_STATIC_ROUTES_ID].size_of_struct = (USHORT) SizetoRealloc ;
	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) write_permitted_structures[CM_STATIC_ROUTES_ID].ptr_to_struct ;
	static_routes_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE ;
}
/* Jo 19/08/99 Added for static routes */

#if 0
enum CM_DATA_FORMAT get_pap_chap_enabled (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG 		offset;
	USER_LIST 	*ptr_to_user;
	CNF_PPP 		*ptr_to_ppp;
	char			check_for_pap_string[128];
	
	ptr_to_user = (USER_LIST *) ptr_user_list.sptr_forward_link;
	if (connection_id == ptr_to_user->Connection_ID)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_PPP_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_PPP_SECTION].ptr_to_struct;

	ptr_to_ppp = (CNF_PPP *) offset;
	if (parameter_id == PPP_PORT_OPTION_LCP_AUTHENTICATION_CHAP)
	{
		if (ptr_to_ppp->ppp_ports[0].lcp_chap.options[0])
			*value_got = 1;
		else
			*value_got = 0;
		return CM_BYTE_FORMAT;
	}

	if (ptr_to_ppp->ppp_ports[0].lcp_pap.options[0])
	{
	 	*value_got = 1;
		return CM_BYTE_FORMAT;
	}

 	*value_got = 0;
	if (ptr_to_ppp->ppp_ports[0].lcp_chap.options[0])
	{
		strcpy (check_for_pap_string, &ptr_to_ppp->ppp_ports[0].lcp_chap.options[0]);
		if (strstr (check_for_pap_string, "Not Negotiable") == NULL)	
		 	*value_got = 1;
	}

	return CM_BYTE_FORMAT;
}

enum CM_DATA_FORMAT  get_no_of_ip_port_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	CNF_IP_PORT *ptr_to_ip_port;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ip_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	ptr_to_ip_port = (CNF_IP_PORT *) offset;
	*value_got = 	ptr_to_ip_port->number_of_filter_dest_port_entries +
						ptr_to_ip_port->number_of_filter_source_port_entries +
						ptr_to_ip_port->number_of_forward_dest_port_entries +
						ptr_to_ip_port->number_of_forward_source_port_entries;

	return CM_USHORT_FORMAT;
}

enum CM_DATA_FORMAT  get_no_of_ip_address_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	CNF_IP_PORT *ptr_to_ip_port;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ip_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	ptr_to_ip_port = (CNF_IP_PORT *) offset;
	*value_got = 	ptr_to_ip_port->number_of_filter_dest_address_entries +
						ptr_to_ip_port->number_of_filter_source_address_entries +
						ptr_to_ip_port->number_of_forward_dest_address_entries +
						ptr_to_ip_port->number_of_forward_source_address_entries;

	return CM_USHORT_FORMAT;
}

enum CM_DATA_FORMAT  get_ip_port_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	int index_of_filter;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ip_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	index_of_filter = *value_got;
	*value_got = get_actual_ip_port_filter_type (offset, index_of_filter);

	return CM_USHORT_FORMAT;
}

int get_actual_ip_port_filter_type (ULONG offset, int index_of_filter)
{
	CNF_IP_PORT *ptr_to_ip_port;
	ptr_to_ip_port = (CNF_IP_PORT *) offset;

	if (index_of_filter < ptr_to_ip_port->number_of_filter_dest_port_entries)
		return FILTER_TYPE_FILTER_DESTINATION;
	else
		if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_port_entries +
			ptr_to_ip_port->number_of_filter_source_port_entries))
				return FILTER_TYPE_FILTER_SOURCE;
		else
			if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_port_entries +
				ptr_to_ip_port->number_of_filter_source_port_entries +
				ptr_to_ip_port->number_of_forward_dest_port_entries))
					return FILTER_TYPE_FORWARD_DESTINATION;
			else
				if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_port_entries +
					ptr_to_ip_port->number_of_filter_source_port_entries +
					ptr_to_ip_port->number_of_forward_source_port_entries +
					ptr_to_ip_port->number_of_forward_dest_port_entries))
						return FILTER_TYPE_FORWARD_SOURCE;
				else
					return -1;
}


enum CM_DATA_FORMAT  get_ip_address_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	int index_of_filter;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ip_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	index_of_filter = *value_got;
	*value_got = get_actual_ip_address_filter_type (offset, index_of_filter);

	return CM_USHORT_FORMAT;
}

int get_actual_ip_address_filter_type (ULONG offset, int index_of_filter)
{
	CNF_IP_PORT *ptr_to_ip_port;
	ptr_to_ip_port = (CNF_IP_PORT *) offset;
	if (index_of_filter < ptr_to_ip_port->number_of_filter_dest_address_entries)
		return FILTER_TYPE_FILTER_DESTINATION;
	else
		if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_address_entries +
			ptr_to_ip_port->number_of_filter_source_address_entries))
				 return FILTER_TYPE_FILTER_SOURCE;
		else
			if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_address_entries +
				ptr_to_ip_port->number_of_filter_source_address_entries +
				ptr_to_ip_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_DESTINATION;
			else
			if (index_of_filter < (ptr_to_ip_port->number_of_filter_dest_address_entries +
				ptr_to_ip_port->number_of_filter_source_address_entries +
				ptr_to_ip_port->number_of_forward_source_address_entries +
				ptr_to_ip_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_SOURCE;
			else
				return -1;
}

enum CM_DATA_FORMAT  get_no_of_ipx_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	CNF_IPX_PORT *ptr_to_ipx_port;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IPX_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IPX_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ipx_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	ptr_to_ipx_port = (CNF_IPX_PORT *) offset;
	*value_got = 	ptr_to_ipx_port->number_of_filter_dest_address_entries +
						ptr_to_ipx_port->number_of_filter_source_address_entries +
						ptr_to_ipx_port->number_of_forward_dest_address_entries +
						ptr_to_ipx_port->number_of_forward_source_address_entries;

	return CM_USHORT_FORMAT;
}


enum CM_DATA_FORMAT  get_ipx_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	int index_of_filter;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IPX_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_IPX_SECTION].ptr_to_struct;

	if (!calculate_offset_of_ipx_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	index_of_filter = *value_got;
	*value_got = get_actual_ipx_filter_type (offset, index_of_filter);

	return CM_USHORT_FORMAT;
}

int get_actual_ipx_filter_type (ULONG offset, int index_of_filter)
{
	CNF_IPX_PORT *ptr_to_ipx_port;
	ptr_to_ipx_port = (CNF_IPX_PORT *) offset;

	if (index_of_filter < ptr_to_ipx_port->number_of_filter_dest_address_entries)
		 return FILTER_TYPE_FILTER_DESTINATION;
	else
		if (index_of_filter < (ptr_to_ipx_port->number_of_filter_dest_address_entries +
			ptr_to_ipx_port->number_of_filter_source_address_entries))
				return FILTER_TYPE_FILTER_SOURCE;
		else
			if (index_of_filter < (ptr_to_ipx_port->number_of_filter_dest_address_entries +
				ptr_to_ipx_port->number_of_filter_source_address_entries +
				ptr_to_ipx_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_DESTINATION;
			else
			if (index_of_filter < (ptr_to_ipx_port->number_of_filter_dest_address_entries +
				ptr_to_ipx_port->number_of_filter_source_address_entries +
				ptr_to_ipx_port->number_of_forward_source_address_entries +
				ptr_to_ipx_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_SOURCE;
			else
				return -1;
}


enum CM_DATA_FORMAT  get_no_of_stp_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	CNF_STP_PORT *ptr_to_stp_port;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_SPANTREE_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_SPANTREE_SECTION].ptr_to_struct;

	if (!calculate_offset_of_stp_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	ptr_to_stp_port = (CNF_STP_PORT *) offset;
	*value_got = 	ptr_to_stp_port->number_of_filter_dest_address_entries +
						ptr_to_stp_port->number_of_filter_source_address_entries +
						ptr_to_stp_port->number_of_forward_dest_address_entries +
						ptr_to_stp_port->number_of_forward_source_address_entries;

	return CM_USHORT_FORMAT;
}


enum CM_DATA_FORMAT  get_stp_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got)
{
	ULONG offset;
	int index_of_filter;

	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
		offset = (ULONG) write_permitted_structures[(BYTE) CM_SPANTREE_SECTION].ptr_to_struct;
	else
		offset = (ULONG) read_only_structures[(BYTE) CM_SPANTREE_SECTION].ptr_to_struct;

	if (!calculate_offset_of_stp_port (&offset, port_no))
		return CM_UNKNOWN_FORMAT;
	
	index_of_filter = *value_got;
	*value_got = get_actual_stp_filter_type (offset, index_of_filter);

	return CM_USHORT_FORMAT;
}

int get_actual_stp_filter_type (ULONG offset, int index_of_filter)
{

	CNF_STP_PORT *ptr_to_stp_port;
	ptr_to_stp_port = (CNF_STP_PORT *) offset;

	if (index_of_filter < ptr_to_stp_port->number_of_filter_dest_address_entries)
		return FILTER_TYPE_FILTER_DESTINATION;
	else
		if (index_of_filter < (ptr_to_stp_port->number_of_filter_dest_address_entries +
			ptr_to_stp_port->number_of_filter_source_address_entries))
				return FILTER_TYPE_FILTER_SOURCE;
		else
			if (index_of_filter < (ptr_to_stp_port->number_of_filter_dest_address_entries +
				ptr_to_stp_port->number_of_filter_source_address_entries +
				ptr_to_stp_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_DESTINATION;
			else
			if (index_of_filter < (ptr_to_stp_port->number_of_filter_dest_address_entries +
				ptr_to_stp_port->number_of_filter_source_address_entries +
				ptr_to_stp_port->number_of_forward_source_address_entries +
				ptr_to_stp_port->number_of_forward_dest_address_entries))
					return FILTER_TYPE_FORWARD_SOURCE;
			else
				return -1;
}


enum CM_DATA_FORMAT set_pap_chap_enabled (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set)
{
	ULONG 		offset;
	CNF_PPP 		*ptr_to_ppp;
	char			pap_chap_string[128];
	int 			Prev_PAP_Enabled = 0, Prev_CHAP_Enabled = 0;
	
	offset = (ULONG) write_permitted_structures[(BYTE) CM_PPP_SECTION].ptr_to_struct;

	ptr_to_ppp = (CNF_PPP *) offset;
	if (ptr_to_ppp->ppp_ports[0].lcp_chap.options[0])
	{
		Prev_CHAP_Enabled = 1;
		strcpy (pap_chap_string, &ptr_to_ppp->ppp_ports[0].lcp_chap.options[0]);
		if (strstr (pap_chap_string, "Not Negotiable") == NULL)
			Prev_PAP_Enabled = 1;
	}

	if (ptr_to_ppp->ppp_ports[0].lcp_pap.options[0])
		Prev_PAP_Enabled = 1;

	
	if (*value_to_set)
	{
		if (ptr_to_ppp->ppp_ports[0].user_name[0])	
		{
			strcpy (&ptr_to_ppp->ppp_ports[0].remote_lcp_chap.options[0],
  	 			 "3,Auto,Negotiation Not Required,Negotiable,H3,c22305");
		}
	}

	if (parameter_id == PPP_PORT_OPTION_LCP_AUTHENTICATION_PAP)
	{
		if (Prev_PAP_Enabled == *value_to_set)	
			return CM_STRING_FORMAT;
	
		if (*value_to_set)	
		{
			if (Prev_CHAP_Enabled)
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0],
					"3,Auto,Negotiation Not Required,Negotiable,H3,c22305");
			else
			{
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_pap.options[0],
					"3,Auto,Negotiation Not Required,Not Negotiable,H2,c023");
			}
			return CM_STRING_FORMAT;

		}
		else	
		{
			if (Prev_CHAP_Enabled)	
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0],
					"3,Auto,Negotiation Not Required,Not Negotiable,H3,c22305");
			else
			{
				memset (&ptr_to_ppp->ppp_ports[0].lcp_pap.options[0], 0, 128);
				memset (&ptr_to_ppp->ppp_ports[0].remote_lcp_chap.options[0], 0, 128);
			}
			return CM_STRING_FORMAT;

		}
	}
	else		
	{
		if (Prev_CHAP_Enabled == *value_to_set)	
			return CM_STRING_FORMAT;

		if (*value_to_set)	
		{
			if (Prev_PAP_Enabled)
			{
				memset (&ptr_to_ppp->ppp_ports[0].lcp_pap.options[0], 0, 128);
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0],
					"3,Auto,Negotiation Not Required,Negotiable,H3,c22305");
			}
			else
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0],
  		 			"3,Auto,Negotiation Not Required,Not Negotiable,H3,c22305");
			return CM_STRING_FORMAT;

		}
		else	
		{
			if (Prev_PAP_Enabled)	
			{
				memset (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0], 0, 128);
				strcpy (&ptr_to_ppp->ppp_ports[0].lcp_pap.options[0],
					"3,Auto,Negotiation Not Required,Not Negotiable,H2,c023");
			}
			else	
			{
				memset (&ptr_to_ppp->ppp_ports[0].lcp_chap.options[0], 0, 128);
				memset (&ptr_to_ppp->ppp_ports[0].remote_lcp_chap.options[0], 0, 128);
			}
			return CM_STRING_FORMAT;

		}
	}
}

enum CM_DATA_FORMAT change_ip_port_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set)
{
	ULONG offset;
	ULONG para_id_to_set_to;
	CNF_IP_FILTER_PORT_INFO store_filter_info;
	int NewFilterType, ActualFilterType;
	
	offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	
	if (!calculate_offset_of_ip_port (&offset, port_no))
	{
		return CM_UNKNOWN_FORMAT;
	}

	NewFilterType = *(int *) value_to_set;
	ActualFilterType = get_actual_ip_port_filter_type (offset, filter_index);
	if (ActualFilterType == NewFilterType)
			return CM_STRING_FORMAT;

	if (!calculate_offset_of_ip_port_filter (&offset, filter_index))
	{
		return CM_UNKNOWN_FORMAT;
	}

	store_filter_info = * ((CNF_IP_FILTER_PORT_INFO *) offset);
	delete_ip_filter (DELETE_IP_FILTER_PORT_ENTRY, port_no, filter_index);
	switch (NewFilterType)
	{
		case FILTER_TYPE_FILTER_DESTINATION : 
			para_id_to_set_to = ADD_IP_FILTER_DEST_PORT_ENTRY;
			break;

		case FILTER_TYPE_FILTER_SOURCE :
			para_id_to_set_to = ADD_IP_FILTER_SOURCE_PORT_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_DESTINATION : 
			para_id_to_set_to = ADD_IP_FORWARD_DEST_PORT_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_SOURCE :
			para_id_to_set_to = ADD_IP_FORWARD_SOURCE_PORT_ENTRY;
			break;
	}
	add_ip_filter (para_id_to_set_to, port_no, (void *) &store_filter_info);
	return CM_STRING_FORMAT;
}

enum CM_DATA_FORMAT change_ip_address_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set)
{
	ULONG offset;
	ULONG para_id_to_set_to;
	CNF_IP_FILTER_ADDRESS_INFO store_filter_info;
	int NewFilterType, ActualFilterType;
	
	offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	
	if (!calculate_offset_of_ip_port (&offset, port_no))
	{
		return CM_UNKNOWN_FORMAT;

	}

	NewFilterType = *(int *) value_to_set;
	ActualFilterType = get_actual_ip_address_filter_type (offset, filter_index);
	if (ActualFilterType == NewFilterType)
			return CM_STRING_FORMAT;

	if (!calculate_offset_of_ip_address_filter (&offset, filter_index))
	{
		return CM_UNKNOWN_FORMAT;

	}
	
	store_filter_info = * ((CNF_IP_FILTER_ADDRESS_INFO *) offset);
	delete_ip_filter (DELETE_IP_FILTER_ADDRESS_ENTRY, port_no, filter_index);
	switch (NewFilterType)
	{
		case FILTER_TYPE_FILTER_DESTINATION : 
			para_id_to_set_to = ADD_IP_FILTER_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FILTER_SOURCE :
			para_id_to_set_to = ADD_IP_FILTER_SOURCE_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_DESTINATION : 
			para_id_to_set_to = ADD_IP_FORWARD_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_SOURCE :
			para_id_to_set_to = ADD_IP_FORWARD_SOURCE_ADDRESS_ENTRY;
			break;
	}
	add_ip_filter (para_id_to_set_to, port_no, (void *) &store_filter_info);
	return CM_STRING_FORMAT;
}

enum CM_DATA_FORMAT change_ipx_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set)
{
	ULONG offset;
	ULONG para_id_to_set_to;
	CNF_IPX_FILTER_ADDRESS_INFO store_filter_info;
	int NewFilterType, ActualFilterType;
	
	offset = (ULONG) write_permitted_structures[(BYTE) CM_IPX_SECTION].ptr_to_struct;
	
	if (!calculate_offset_of_ipx_port (&offset, port_no))
	{
		return CM_UNKNOWN_FORMAT;

	}
	NewFilterType = *(int *) value_to_set;
	ActualFilterType = get_actual_ipx_filter_type (offset, filter_index);
	if (ActualFilterType == NewFilterType)
			return CM_STRING_FORMAT;

	if (!calculate_offset_of_ipx_filter (&offset, filter_index))
	{
		return CM_UNKNOWN_FORMAT;

	}
	
	store_filter_info = * ((CNF_IPX_FILTER_ADDRESS_INFO *) offset);
	delete_ipx_address_filter (DELETE_IPX_FILTER_ADDRESS_ENTRY, port_no, filter_index);
	switch (NewFilterType)
	{
		case FILTER_TYPE_FILTER_DESTINATION : 
			para_id_to_set_to = ADD_IPX_FILTER_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FILTER_SOURCE :
			para_id_to_set_to = ADD_IPX_FILTER_SOURCE_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_DESTINATION : 
			para_id_to_set_to = ADD_IPX_FORWARD_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_SOURCE :
			para_id_to_set_to = ADD_IPX_FORWARD_SOURCE_ADDRESS_ENTRY;
			break;
	}
	add_ipx_address_filter (para_id_to_set_to, port_no, (void *) &store_filter_info);
	return CM_STRING_FORMAT;
}

enum CM_DATA_FORMAT change_stp_filter_type(ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set)
{
	ULONG offset;
	ULONG para_id_to_set_to;
	CNF_STP_FILTER_ADDRESS_INFO store_filter_info;
	int NewFilterType, ActualFilterType;
	
	offset = (ULONG) write_permitted_structures[(BYTE) CM_SPANTREE_SECTION].ptr_to_struct;
	
	if (!calculate_offset_of_stp_port (&offset, port_no))
	{
		printf ("Invalid port num %d for modifying filter type\n", port_no);
		return CM_UNKNOWN_FORMAT;
	}
	NewFilterType = *(int *) value_to_set;
	ActualFilterType = get_actual_stp_filter_type (offset, filter_index);
	if (ActualFilterType == NewFilterType)
			return CM_STRING_FORMAT;

	if (!calculate_offset_of_stp_filter (&offset, filter_index))
	{
		printf ("Invalid index %d for modifying filter type of port %d\n", filter_index, port_no);
		return CM_UNKNOWN_FORMAT;
	}
	
	store_filter_info = * ((CNF_STP_FILTER_ADDRESS_INFO *) offset);
	delete_stp_address_filter (DELETE_STP_FILTER_ADDRESS_ENTRY, port_no, filter_index);
	switch (NewFilterType)
	{
		case FILTER_TYPE_FILTER_DESTINATION : 
			para_id_to_set_to = ADD_STP_FILTER_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FILTER_SOURCE :
			para_id_to_set_to = ADD_STP_FILTER_SOURCE_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_DESTINATION : 
			para_id_to_set_to = ADD_STP_FORWARD_DEST_ADDRESS_ENTRY;
			break;

		case FILTER_TYPE_FORWARD_SOURCE :
			para_id_to_set_to = ADD_STP_FORWARD_SOURCE_ADDRESS_ENTRY;
			break;
	}
	add_stp_address_filter (para_id_to_set_to, port_no, (void *) &store_filter_info);
	return CM_STRING_FORMAT;
}
#endif /* ...Not required for Proxy */

enum ACCESS_PERMISSIONS	get_access_permission (ULONG connection_id)
{
	USER_LIST *ptr_to_user;
	
	ptr_to_user = (USER_LIST *) ptr_user_list.sptr_forward_link;
	if (connection_id == ptr_to_user->Connection_ID)
		return CM_READ_AND_WRITE;
	else
	{
		ptr_to_user = (USER_LIST *) ptr_to_user->links.sptr_forward_link;
		while (ptr_to_user != NULL)
		{
			if (ptr_to_user->Connection_ID == connection_id)
				return CM_READ_ONLY;
			ptr_to_user = (USER_LIST *) ptr_to_user->links.sptr_forward_link;
		}
		if (ptr_to_user == NULL)
			return CM_NO_READ_WRITE_ACCESS;
	}
}


/*--------------------------------------------------------------------------*/
/* FUNCTION NAME  : get_write_access_owner_type()
** PURPOSE		   : returns the type of user who has the write access with
**						  configuration manager 
**--------------------------------------------------------------------------*/
/* Jo 29/04/99 */
#if 0
int cm_get_write_access_owner_type()
{
	USER_LIST *ptr_to_user;
	ptr_to_user = (USER_LIST *)get_pointer_to_first_entry_in_list((LINK *)&ptr_user_list);

	if (ptr_to_user != NULL)
	{
		return((int)ptr_to_user->Owner_Type);
	}
	else
	{
		return((int)CM_OWNED_BY_NONE);
	}
}
#endif
/* Jo 29/04/99 */


void put_write_access_owner_type (char *str)
{
	USER_LIST *ptr_to_user;
	
	ptr_to_user = (USER_LIST *) ptr_user_list.sptr_forward_link;
	
	switch (ptr_to_user->Owner_Type)
	{
		case CM_OWNED_BY_NONE:		strcpy (str, "NONE");
											break;
#ifdef _BIG_PROXY_
		case CM_OWNED_BY_SNMP:		strcpy (str, "SNMP");
											break;
#endif
		case CM_OWNED_BY_TELNET:	strcpy (str, "TELNET");
											break;

#ifdef _BIG_PROXY_
		case CM_OWNED_BY_HTTP:		strcpy (str, "WEB");
											break;
#endif
		case CM_OWNED_BY_UIM:		strcpy (str, "ROUCON");
											break;
		case CM_OWNED_BY_DTTY:		strcpy (str, "Dumb Terminal");
											break;
#if 0
		case CM_OWNED_BY_TFTP:		strcpy (str, "TFTP");
											break;
#endif

	}
}

#ifdef _BIG_PROXY_

void set_snmp_local_internet_address_interdep (void *data_ptr, USHORT port_no, int index)
{
	CNF_SNMP	*ptr_to_snmp;
	CNF_PPP	*ptr_to_ppp;
	CNF_IP_PORT	*ptr_to_ip_port;
	ULONG offset;
	
	ptr_to_snmp = (CNF_SNMP *) write_permitted_structures[(BYTE) CM_SNMP_SECTION].ptr_to_struct;
	ptr_to_snmp->snmp_header.local_internet_address = *(ULONG *) data_ptr;

	ptr_to_ppp = (CNF_PPP *) write_permitted_structures[(BYTE) CM_PPP_SECTION].ptr_to_struct;
	
	if (ptr_to_ppp->ppp_ports[port_no].remote_port_client_only)
	{
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
		calculate_offset_of_ip_port (&offset, port_no + 1);
		ptr_to_ip_port = (CNF_IP_PORT *) offset;
		ptr_to_ip_port->address = *(ULONG *) data_ptr;
		set_ip_address_interdep (data_ptr, port_no + 1, 0);
	}
/*	printf ("It has INTER DEP  set_snmp_local_internet_address\n");*/
}
#endif

void set_ip_port_bootp_interdep (void *data_ptr, USHORT port_no, int index)
{
	ULONG 		offset;
	CNF_IP_PORT *ptr_to_ip_port;
	int i;
	BYTE value_to_set;

	offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
	value_to_set = (BYTE) (*(ULONG *) data_ptr);
	for (i = 0; i < 4; i ++)
	{
		offset = (ULONG) write_permitted_structures[(BYTE) CM_IP_SECTION].ptr_to_struct;
		calculate_offset_of_ip_port (&offset, i);
		ptr_to_ip_port = (CNF_IP_PORT *) offset;
		ptr_to_ip_port->bootp = (value_to_set) ? 1 : 0;
	}
/*	printf ("bootp value %lu INTER DEP  set_ip_port_bootp\n", *(ULONG *) data_ptr);*/
}

int calculate_offset_of_ip_port (ULONG *offset, USHORT port_no)
{
	CNF_IP *ptr_to_ip;
/*	CNF_IP_PORT *ptr_to_ip_port; */
	int i;

	ptr_to_ip = (CNF_IP *) *offset;

	if (port_no >= ptr_to_ip->ip_header.number_of_ports)
	{
		printf ("Invalid IP port number %d for address calc\n", port_no);
		return FALSE;
	}
	*offset += 	sizeof (CNF_IP_HEADER) ;
	for (i = 0; i < port_no; i ++)
	{
		*offset += sizeof (CNF_IP_PORT);
	}
	*offset += sizeof(BYTE);

	return TRUE;
}

enum CM_DATA_FORMAT encrypt_password_string (void *data_ptr, USHORT port_no)
{
	CNF_PPP	*ptr_to_ppp;
	char 		store_passwd_string[140]; /* Imran , 10.3.99 */
	

	ptr_to_ppp = (CNF_PPP *) write_permitted_structures[(BYTE) CM_PPP_SECTION].ptr_to_struct;
	strcpy (store_passwd_string, (char *) data_ptr);	
	if (*(char *) data_ptr)
	{
		encrypt (store_passwd_string, ptr_to_ppp->ppp_ports[port_no].user_password);
/*		printf ("ENCRYPTED Password stored to PPP"); */
	}
	else
		memset (ptr_to_ppp->ppp_ports[port_no].user_password, 0, 128);   /* Imran , 10.3.99 */
	return CM_STRING_FORMAT;
}

#ifdef _BIG_PROXY_
enum CM_DATA_FORMAT encrypt_server_password_string (void *data_ptr, USHORT port_no)
{
	CNF_TELNET	*ptr_to_telnet;
	char 		store_passwd_string[64];

	ptr_to_telnet = (CNF_TELNET *) write_permitted_structures[(BYTE) CM_TELNET_SECTION].ptr_to_struct;
	strcpy (store_passwd_string, (char *) data_ptr);	

	if (*(char *) data_ptr)
	{
		encrypt (store_passwd_string, ptr_to_telnet->telnet_header.server_password);
		printf ("ENCRYPTED Password stored to TELNET");
	}
	else
		memset (ptr_to_telnet->telnet_header.server_password, 0, 128);
		return CM_STRING_FORMAT;
}
#endif /*_BIG_PROXY_*/

void *my_realloc (void *ptr_to_old_block, int old_block_size, int new_block_size)
{
	BYTE *ptr_to_new_block;
	int no_of_bytes_to_copy;
	
	ptr_to_new_block = calloc (1, new_block_size);
	if (ptr_to_new_block == NULL)
	{
		printf ("calloc failed in my_realloc \n");	
		return ptr_to_new_block;
	}

	no_of_bytes_to_copy = (old_block_size < new_block_size) ? 
										old_block_size : new_block_size;
	memcpy (ptr_to_new_block, ptr_to_old_block, no_of_bytes_to_copy);
	free (ptr_to_old_block);
	return ptr_to_new_block;
}

/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */

void set_ftp_port_numbers_in_global_structure(ULONG connection_id, BYTE ftp_ctrl, USHORT prev_port)
{
	USHORT protocol, port_index = 0, ftp_ctrl_port = 0, ftp_data_port = 0;

	if (ftp_ctrl)
	{
      get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_CONTROL_CONNECTION, 
	 		CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_ctrl_port, sizeof (USHORT), NULL) ;

		if (ftp_ctrl_port == 0)
			ftp_ctrl_port = FTP21 ;
	}
	else
	{
      get_parameter (connection_id, CM_PROXY_SECTION, PROXY_FTP_DATA_CONNECTION, 
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, &ftp_data_port, sizeof (USHORT), NULL) ;
		if (ftp_data_port == 0)
			ftp_data_port = FTP20 ;
	}

	protocol = 0x0006 ; /* TCP Protocol */
	port_index = get_port_index (protocol, prev_port) ;

	if ( port_index != 0xFF )
	{
		if (ftp_ctrl)
			set_protocol_port_number(protocol, ftp_ctrl_port, port_index) ;
		else
			set_protocol_port_number(protocol, ftp_data_port, port_index) ;
	}

	protocol = 0x0011 ; /* UDP Protocol */
	port_index = get_port_index (protocol, prev_port) ;
	if (port_index != 0xFF)
	{
		if (ftp_ctrl)
			set_protocol_port_number(protocol, ftp_ctrl_port, port_index) ;
		else
			set_protocol_port_number(protocol, ftp_data_port, port_index) ;
	}
	return ;
}

/* Jo 07/10/99 Added to support configurable FTP Data and Control Ports */
