/* 
History of Changes :
		{Jo, 24 Nov 1999, Changed function cm_flash_write_block(). UDB header length was sent 
					as 512 instead of 64 and so all the other headers, script etc 
					residing in that 8k sector was overwritten}
*/

#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include "cnffile.h"
#include <kstart.h>

#include <flashmgr.h>
#include <cfgmgr.h>
#include "fncdefs.h"
#include "\rtrware\store\boot.h"

//void cm_setup_block_written ();

#if SMALL_MEM_MAP
extern	BootBinIOPBType BootBinIOPB;
#else
extern BYTE* DownloadFlag;
#endif

/* Imran 13/9/98 */
CONFIGURATION_MANAGER_CLASS cfgmgr_class = {NULL,0};
extern void cm_convert_tag_list_to_cnf_format();
extern void cm_free_tag_list(BYTE free_cfgmgr_list);
/* Imran 13/9/98 */

/* initialize the write permitted structures with magic numbers */
/* write permitted will always have read permission also */

ALL_STRUCTURES write_permitted_structures[] = 
{
	{ CNF_IP_MAGIC_NUMBER, 				 NULL, 	sizeof(CNF_IP) 	},
	{ CNF_WAN_MAGIC_NUMBER, 			 NULL,	sizeof(CNF_WAN) 	},
	{ CNF_PPP_MAGIC_NUMBER,				 NULL,	sizeof(CNF_PPP) 	},
	{ CNF_PROXY_MAGIC_NUMBER,			 NULL,	sizeof(CNF_PROXY) },
	{ CNF_DHCP_MAGIC_NUMBER, 			 NULL, 	sizeof(CNF_DHCP)	},
	{ CNF_STATIC_ROUTES_MAGIC_NUMBER, NULL, 	sizeof (CNF_STATIC_ROUTES) },
	{ END_OF_SECTION,	 					 NULL,	0					   }	
};

/* initialize the read only structures with magic numbers */

ALL_STRUCTURES read_only_structures[] = 
{
	{ CNF_IP_MAGIC_NUMBER, 				 NULL, 	sizeof(CNF_IP) 	},	
	{ CNF_WAN_MAGIC_NUMBER, 			 NULL,	sizeof(CNF_WAN) 	},
	{ CNF_PPP_MAGIC_NUMBER,				 NULL,	sizeof(CNF_PPP) 	},
	{ CNF_PROXY_MAGIC_NUMBER,			 NULL,	sizeof(CNF_PROXY) },
	{ CNF_DHCP_MAGIC_NUMBER, 			 NULL, 	sizeof(CNF_DHCP)	},
	{ CNF_STATIC_ROUTES_MAGIC_NUMBER, NULL, 	sizeof (CNF_STATIC_ROUTES) },
	{ END_OF_SECTION,	 					 NULL,	0					   }	
};

/* -------------------------------------------------------------------- */

LINK ptr_user_list;
int no_of_current_users = 0;

// second parameter is both input and output. Its input value will 
// contain the timeout value requested. Its output will contain the permissions
// If its value is <= 0 then timeout is initialized to default value
ULONG cm_initialize_configuration_manager (enum CM_AGENT_TYPE agent_type,
				int *Life_Time_Permissions,
				int (*fn_ptr_to_callback) (ULONG, int ))
{
	USER_LIST *ptr_new_user;

	if (no_of_current_users < CM_MAX_NUMBER_OF_USERS)
	{
		ptr_new_user = (USER_LIST *) malloc (sizeof (USER_LIST));
		if (ptr_new_user == NULL)
		{
			printf ("Malloc Failed in cm_initialize_configuration_manager\n");
			*Life_Time_Permissions = CM_NO_READ_WRITE_ACCESS;
			return 0;
		}

		add_entry_to_list (&ptr_user_list, &ptr_new_user->links);

		ptr_new_user->Connection_ID = (ULONG) ptr_new_user;
		ptr_new_user->Owner_Type = agent_type; 
		ptr_new_user->fn_ptr_to_callback = fn_ptr_to_callback;
//		ptr_new_user->Timeout_Count = CM_LIFE_TIME;
		if (*Life_Time_Permissions <= 0)
			ptr_new_user->Timeout_Count = CM_LIFE_TIME;
		else
			ptr_new_user->Timeout_Count = *Life_Time_Permissions;

/*		if (agent_type != CM_OWNED_BY_UIM)	 Prasanna.C 16.2.98 */
		{
			if (!no_of_current_users)
			{
				/* read the values into structures for modifying */	
				initialize_cm_structures ( &write_permitted_structures[0], 1);
				*Life_Time_Permissions = CM_READ_AND_WRITE;
printf ("cm1\n")	;
			}
			else
			{
				/* store address of sections which are there in flash to temp ptrs */
				if (no_of_current_users < 2)
				{
					initialize_cm_structures ( &read_only_structures[0], 0);
printf ("cm2\n")	;
				}
				*Life_Time_Permissions = CM_READ_ONLY;
			}
		}
	/* Imran 13/9/98 */
		if(cfgmgr_class.sptr_tag_list == NULL)
		{
			if (cm_initialise_dhcp_address_range_list() == FALSE)
			{
				*Life_Time_Permissions = CM_NO_READ_WRITE_ACCESS;
			   cm_deinitialize_configuration_manager(ptr_new_user->Connection_ID);		
				return 0;
			}
		}
	/* Imran 13/9/98 */
		no_of_current_users++;
		return ptr_new_user->Connection_ID ;		
  	}
	else
	{
		*Life_Time_Permissions = CM_NO_READ_WRITE_ACCESS;
		return 0;
	}
}

void cm_deinitialize_configuration_manager (ULONG connection_id)
{  
	USER_LIST *ptr_to_traverse, *ptr_to_first_entry;
	int i;

	ptr_to_traverse = (USER_LIST *) ptr_user_list.sptr_forward_link;

	if (ptr_to_traverse->Connection_ID == connection_id) // he has right access
	{
		for (i = 0; write_permitted_structures[i].magic_number != END_OF_SECTION; i ++)
			free (write_permitted_structures[i].ptr_to_struct);
		if (no_of_current_users > 1) 
		{
			initialize_cm_structures ( &write_permitted_structures[0], 1);
			ptr_to_first_entry = (USER_LIST *) ptr_to_traverse->links.sptr_forward_link;
			if (ptr_to_first_entry)
			{
				if (ptr_to_first_entry->fn_ptr_to_callback)
				{
					(*ptr_to_first_entry->fn_ptr_to_callback) (ptr_to_first_entry->Connection_ID,
								CM_ACCESS_CHANGED);
				}
			}
		}
	}

	while (ptr_to_traverse != NULL )
	{
		if (ptr_to_traverse->Connection_ID == connection_id)
		{
			delete_entry_from_list (&ptr_user_list, &ptr_to_traverse->links);
			no_of_current_users --;
			break;
		}
		else
			ptr_to_traverse = (USER_LIST *) ptr_to_traverse->links.sptr_forward_link;
	}
 /* Imran 14/9/98 */
	if (!no_of_current_users)
		cm_free_tag_list(TRUE);
  /* Imran 14/9/98 */
}

void cm_keep_alive_configuration_manager (ULONG connection_id)
{
	USER_LIST *ptr_to_traverse;

	ptr_to_traverse = (USER_LIST *) ptr_user_list.sptr_forward_link;
	while (ptr_to_traverse != NULL )
	{
		if (ptr_to_traverse->Connection_ID == connection_id)
		{
			ptr_to_traverse->Timeout_Count = CM_LIFE_TIME;
			return;
		}
		ptr_to_traverse = (USER_LIST *) ptr_to_traverse->links.sptr_forward_link;
	}
}
#if 0 /* Jo 03/05/99 */
void cm_decrement_configuration_manager_lifetime()
{

	USER_LIST *ptr_to_traverse, *ptr_to_next_entry, *ptr_to_first_entry;

	ptr_to_traverse = (USER_LIST *) ptr_user_list.sptr_forward_link;
	ptr_to_first_entry =  (USER_LIST *) ptr_user_list.sptr_forward_link;
	while (ptr_to_traverse != NULL )
	{
		ptr_to_traverse->Timeout_Count --;
		if (!ptr_to_traverse->Timeout_Count)
		{
			ptr_to_traverse->Timeout_Count = CM_LIFE_TIME;
			if (ptr_to_traverse->fn_ptr_to_callback)
			{
				if ((*ptr_to_traverse->fn_ptr_to_callback) (ptr_to_traverse->Connection_ID, 
							CM_CLOSE_CONNECTION))
				{
					if (ptr_to_first_entry->Connection_ID == ptr_to_traverse->Connection_ID)
						initialize_cm_structures ( &write_permitted_structures[0], 1);
						
					ptr_to_next_entry = (USER_LIST *) ptr_to_traverse->links.sptr_forward_link;
					cm_deinitialize_configuration_manager (ptr_to_traverse->Connection_ID);
					ptr_to_traverse = ptr_to_next_entry ;
					ptr_to_first_entry =  (USER_LIST *) ptr_user_list.sptr_forward_link;
					continue;
				}
			}
		}
		ptr_to_traverse = (USER_LIST *) ptr_to_traverse->links.sptr_forward_link;
	}
}

void cm_last_setup_block_written()
{
	printf ("finished writing last set of block");
}

void cm_setup_block_written ()
{
//	printf ("one block written\n");
//	num_of_blocks_written ++;
}

#endif /* Jo 03/05/99 */

enum CM_WRITE_RESULTS cm_write_configuration (ULONG connection_id)
{
//	if (cfgmgr_class.owner == CM_OWNED_BY_UIM)
//	{ /* For Roucon the configuration is not written through configuration manager */
//		return CM_WRITE_SUCCESS;
//	}        
	if (get_access_permission (connection_id) == CM_READ_AND_WRITE)
	{
	   printf("\nFlash Write in Progress...\n");
		cm_convert_tag_list_to_cnf_format(); 
		cm_start_flash_write ();
#if SMALL_MEM_MAP
		BootBinIOPB.BootMode = WARM_BOOT_MODE;
#else		
		*DownloadFlag = WARM_BOOT_MODE;
#endif
		cm_wait_for_flash_write_completion() ;
		reset();
	   
		return CM_WRITE_SUCCESSFUL;
	}
	else
	   printf ("You do not have Write Access\n");
		
	return CM_WRITE_FAILED;
}

/* -------------------------------------------------------------------- */

BYTE *cm_last_allocated_block, *cm_last_allocated_block_destination ;
int cm_last_allocated_block_length ;

void cm_start_flash_write ()
{
	USHORT accumulated_crc = 0xFFFF ;
	int this_structure_length ;
	ULONG setup_length = 0L ;
	HeaderType *sptr_dram_setup_header, *sptr_flash_setup_header = (HeaderType *)FL_CFG_HDR ;
	BYTE *sptr_flash_setup = (BYTE *)sptr_flash_setup_header->DnLdAddr ;
	BYTE temp_header[512] ;
	int i = 0;
	BYTE *ptr_to_section_block;
	int max_block_length = 256;
	int block_length_remaining;

	/* Make sure this is done before anything */
	memcpy (&temp_header[0], sptr_flash_setup_header, 64) ; /* changed 512 to 64 - Imran */

	cm_last_allocated_block = NULL ;
	cm_last_allocated_block_length = 0 ;
	cm_last_allocated_block_destination = NULL ;

	i = 0;
	printf ("\n\rStarting flash write address is %lu\n", sptr_flash_setup);
	while (write_permitted_structures[i].magic_number != END_OF_SECTION)
	{
		this_structure_length = write_permitted_structures[i].size_of_struct;
		setup_length = setup_length + (ULONG) this_structure_length ;

		// Checks for maximum block size that should be sent
		block_length_remaining = this_structure_length;
		ptr_to_section_block = write_permitted_structures[i].ptr_to_struct; 
		while (block_length_remaining > max_block_length)
		{
			cm_flash_write_block (ptr_to_section_block, sptr_flash_setup, max_block_length, FALSE) ;
			sptr_flash_setup += (ULONG) max_block_length;
			ptr_to_section_block +=	max_block_length;
			block_length_remaining  -=  max_block_length;
		}
		if (block_length_remaining > 0)		
		{
			cm_flash_write_block (ptr_to_section_block, sptr_flash_setup, block_length_remaining, FALSE) ;
			sptr_flash_setup += (ULONG) block_length_remaining;
		}
		accumulated_crc = update_crc (accumulated_crc, (BYTE *) write_permitted_structures[i].ptr_to_struct, this_structure_length) ;
		free (write_permitted_structures[i].ptr_to_struct);
		i ++;
	}
	cm_flash_write_block ((char *) &write_permitted_structures[i].magic_number, sptr_flash_setup, 2, TRUE) ;
	setup_length += 2L ;

	accumulated_crc = update_crc(accumulated_crc, (BYTE *) &write_permitted_structures[i].magic_number, 2) ;
	accumulated_crc = update_crc(accumulated_crc, "\x0\x0", 2) ;
/* accumulated_crc = update_crc(accumulated_crc, "\x0\x0\x0\x0", 4) ; */

	sptr_dram_setup_header = (HeaderType *)&temp_header[0] ;

	sptr_dram_setup_header->CodeLength = setup_length ;
	sptr_dram_setup_header->CRC = accumulated_crc ;
	cm_flash_write_block ((BYTE *)sptr_dram_setup_header, (BYTE *)FL_CFG_HDR, 64, TRUE) ; /* changed 512 to 64 - Imran */
	printf ("\ncrc cal is %lu setup length is %lu", accumulated_crc, setup_length);
}

int cm_flash_write_block(BYTE *bptr_src, BYTE *bptr_dest, int length, enum BOOLEAN last_block)
{
	int number_of_bytes_to_copy = length ;

	if (cm_last_allocated_block == NULL)
	{
		cm_last_allocated_block = malloc (512) ;
		if (cm_last_allocated_block == NULL)
		{
			return (0) ;
		}
		cm_last_allocated_block_length = 0 ;
		cm_last_allocated_block_destination = bptr_dest ;
	}

	if ((512 - cm_last_allocated_block_length) < length)
	{
		number_of_bytes_to_copy = 512 - cm_last_allocated_block_length ;
		memcpy (cm_last_allocated_block+cm_last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;
#if SMALL_MEM_MAP
		c_write_to_AMD_flash(cm_last_allocated_block, cm_last_allocated_block_destination, 512);
#else
		schedule_flash_write (cm_last_allocated_block, cm_last_allocated_block_destination, 512, NULL, cm_last_allocated_block) ;
#endif
		cm_last_allocated_block = malloc (512) ;
		if (cm_last_allocated_block == NULL)
		{
			return (0) ;
		}
		cm_last_allocated_block_length = 0 ;
		bptr_src += number_of_bytes_to_copy ;
		number_of_bytes_to_copy = length - number_of_bytes_to_copy ;
		cm_last_allocated_block_destination += 512 ;
	}
	memcpy (cm_last_allocated_block+cm_last_allocated_block_length, bptr_src, number_of_bytes_to_copy) ;
	cm_last_allocated_block_length += number_of_bytes_to_copy ;
	if (last_block == TRUE)
	{
#ifndef SMALL_MEM_MAP
		schedule_flash_write (cm_last_allocated_block, cm_last_allocated_block_destination, 512, cm_last_setup_block_written, cm_last_allocated_block) ;
#else
/* ...Jo Changed on 24 Nov 1999. UDB header length was sent as 512 instead of actual length and 
	so all the other headers, script etc residing in that 8k sector was overwritten */

		c_write_to_AMD_flash(cm_last_allocated_block, cm_last_allocated_block_destination, length);
#endif
		
		cm_last_allocated_block = NULL ;
		cm_last_allocated_block_length = 0 ;
		cm_last_allocated_block_destination = NULL ;
	}
}

void cm_wait_for_flash_write_completion ()
{
	int i = 0 ;

	printf ("Waiting for flash write to complete.....\n") ;
#ifndef SMALL_MEM_MAP
	while (i < CM_NUMBER_OF_FLASH_PROMS)
	{
		if (flash_accessibility[i] != FLASH_ACCESSIBLE)
		{
			i = 0 ;
		}
		else
			i++ ;
	}
#endif
}

// flag = 1 it will write to write_permitted structures and 
//	flag is 0 it will write addresses into read only structures
void initialize_cm_structures (ALL_STRUCTURES *address_to_store, int flag)
{
	HeaderType *cfg_hdr ;
	USHORT *cfg_start ;
	char *address_to_read_from;
	int index_value;

	cfg_hdr = (HeaderType *) FL_CFG_HDR;
	address_to_read_from = (BYTE *) cfg_hdr->DnLdAddr; 
   cfg_start = (USHORT *) cfg_hdr->DnLdAddr; 
	while (*cfg_start != END_OF_SECTION)
	{
		index_value = 0;
		while (address_to_store[index_value].magic_number != END_OF_SECTION)
		{
			if (address_to_store[index_value].magic_number	== *cfg_start)
			{	// copy all the values from memory to structures
				address_to_store[index_value].size_of_struct = *(cfg_start + 1);
				if (flag)
				{
					if ((address_to_store[index_value].ptr_to_struct = (char *)
								malloc (*(cfg_start + 1))) == NULL)
					{
						printf ("MALLOC Failed while allocating for section %u\n", *cfg_start);
						return;
					}
					memcpy (address_to_store[index_value].ptr_to_struct, 
									address_to_read_from, 
									address_to_store[index_value].size_of_struct);
				}
				else
					address_to_store[index_value].ptr_to_struct = address_to_read_from;

				address_to_read_from += 
								address_to_store[index_value].size_of_struct;
				cfg_start = (USHORT *) address_to_read_from; 
				break;
			}
			else
				index_value ++;
		}
		if (address_to_store[index_value].magic_number	== END_OF_SECTION)
		{	// Error, magic number not found so just update the values to next section 
			address_to_read_from += (*(cfg_start + 1));
			cfg_start = (USHORT *) address_to_read_from; 
		}
	}	// All the sections have been completed so return
}

/* Jo 20/08/99 */
#if 0
void print_static_route_bmp()
{
	char *ptr;
	int i ;

	ptr = (char *)write_permitted_structures[5].ptr_to_struct ;
	printf("\n\rmagic_number : 0x%x", ptr->static_routes_header.magic_number) ;
	printf("\n\rsection length : %d", ptr->static_routes_header.section_length) ;
	printf("\n\rnumber of entries : %d", ptr->static_routes_header.number_of_static_routes) ;
	for (i = 0; i < ptr->static_routes_header.number_of_static_routes; i++)
	{
		printf("\n\rIP address : %lu", ptr->static_routes_info[i].host_ip_address) ;
		printf("\n\rGateway : %lu", ptr->static_routes_info[i].host_gateway) ;
		printf("\n\rMask : %lu", ptr->static_routes_info[i].host_address_mask) ;
		printf("\n\rPort Number : %d", ptr->static_routes_info[i].port_number) ;
		printf("\n\rMetric : %d", ptr->static_routes_info[i].metric) ;
	}
}
#endif
/* Jo 20/08/99 */

#if 0
int print_entire_bmp_file()
{
	char *ptr;
	int i;
#if 0
	ptr = (char *)write_permitted_structures[0].ptr_to_struct;
	printf("\n\rmagic_number : 0x%x",ptr->ip_header.magic_number);
	printf("\n\rsection_length : %d",ptr->ip_header.section_length);
	printf("\n\rnumber_of_ports : %d",ptr->ip_header.number_of_ports);
	printf("\n\rdns_enabled : %d",ptr->ip_header.dns_enabled);
	printf("\n\rprimary_address : %d",ptr->ip_header.primary_address);
	for(i=0;i<4;i++)
	{
	printf("\n\rport no : %d",i);
	printf("\n\risp_assigns_address : %ld",ptr->ip_ports[i].isp_assigns_address);
	printf("\n\rbootp : %d",ptr->ip_ports[i].bootp);
	printf("\n\rip_address : %ld",ptr->ip_ports[i].ip_address);
	printf("\n\rsubnet_mask : %ld",ptr->ip_ports[i].subnet_mask);
	}
	ptr = (char *)write_permitted_structures[1].ptr_to_struct;
	printf("\n\rmagic_number : 0x%x",ptr->ppp_header.magic_number);
	printf("\n\rsection_length : %d",ptr->ppp_header.section_length);
#endif
	ptr = (char *)write_permitted_structures[2].ptr_to_struct;
	printf("\n\rmagic_number : 0x%x",ptr->wan_header.magic_number);
	printf("\n\rsection_length : %d",ptr->wan_header.section_length);
	printf("\n\renabled : %d",ptr->wan_header.enabled);
	printf("\n\rnumber_of_ports: %d",ptr->wan_header.number_of_ports);
	for(i=0;i<3;i++)
	{
	printf("\n\renabled : %d",ptr->wan_ports[i].enabled);
	printf("\n\rspeed : %d",ptr->wan_ports[i].speed);
	printf("\n\rscript_enabled : %d",ptr->wan_ports[i].script_enabled);
	printf("\n\rrestart_script_on_comm_fail : %d",ptr->wan_ports[i].restart_script_on_comm_failure);
	printf("\n\rdirect_connect : %d",ptr->wan_ports[i].direct_connect);
	printf("\n\rauto_answer : %d",ptr->wan_ports[i].auto_answer);
	printf("\n\rmodem_type : %s",ptr->wan_ports[i].modem_type);
	printf("\n\rmodem_init_string1 : %s",ptr->wan_ports[i].modem_init_string1);
	printf("\n\rmodem_init_string2 : %s",ptr->wan_ports[i].modem_init_string2);
	printf("\n\rmodem_init_string3 : %s",ptr->wan_ports[i].modem_init_string3);
	printf("\n\rmodem_init_string4 : %s",ptr->wan_ports[i].modem_init_string4);
	printf("\n\rmodem_init_string5 : %s",ptr->wan_ports[i].modem_init_string5);
	printf("\n\rdial_prefix: %s",ptr->wan_ports[i].dial_prefix);
	printf("\n\rdial_number: %s",ptr->wan_ports[i].dial_number);
	printf("\n\rdial_suffix: %s",ptr->wan_ports[i].dial_suffix);
	printf("\n\rring msg: %s",ptr->wan_ports[i].ring_message);
	printf("\n\rhangup_string: %s",ptr->wan_ports[i].hangup_string);
	printf("\n\rok_message: %s",ptr->wan_ports[i].ok_message);
	printf("\n\rno_carrier_message: %s",ptr->wan_ports[i].no_carrier_message);
	printf("\n\rerror_message: %s",ptr->wan_ports[i].error_message);
	printf("\n\rno_dial_tone_message : %s",ptr->wan_ports[i].no_dial_tone_message);
	printf("\n\rbusy_message: %s",ptr->wan_ports[i].busy_message);
	printf("\n\rno_answer_message: %s",ptr->wan_ports[i].no_answer_message);
	printf("\n\rresponse_string: %s",ptr->wan_ports[i].response_string);
	}
}
#endif


/* ---------------------------------------------------------------------- */


