/***************************************************************************** 
	Author    - 	Md.Imran Naveed
	Date	    - 	22  Aug 98
	Synopsis  -    Contains routines for Link handling
							(adding and deleting links)
*****************************************************************************/

#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <memory.h>
#include "cnffile.h"
#include <cfgmgr.h>
#include "fncdefs.h"

int calculate_offset_of_proxy_port (ULONG *offset, int port_number)
{
	 int i;	
    CNF_PROXY_PORT *proxy_port_ptr ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (4 * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;
    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (proxy_filter_ptr->number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (proxy_filter_ptr->number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

   *offset = (ULONG) proxy_port_ptr ;
   for (i = 0; i < port_number; i++)
   {
		proxy_port_ptr = (CNF_PROXY_PORT *) *offset ;
		*offset += sizeof (CNF_PROXY_PORT) + ((proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)) ;
   }	
   return TRUE;
}

int add_proxy_address_entries (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, int_ip_addr;
   CNF_PROXY_PORT *proxy_port_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_ADDRESS_INFO  *proxy_address_ptr ;
	STRUCT_HOST_ENTRY  *host_address;
   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
					
	SizetoRealloc = (proxy_header_ptr->section_length + sizeof(CNF_PROXY_ADDRESS_INFO));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_port (&offset, port_no) ;
	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;
	
	return_offset = offset + sizeof(BYTE) + (3 * sizeof(USHORT));
   return_offset += (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_port_ptr->number_of_address_entries);

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	dst_offset = return_offset + sizeof(CNF_PROXY_ADDRESS_INFO);
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_port(&offset, port_no);
	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;
	return_offset = offset + sizeof(BYTE) + (3 * sizeof(USHORT));	

	proxy_address_ptr = (CNF_PROXY_ADDRESS_INFO *) (return_offset +
				 			sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_port_ptr->number_of_address_entries); 
	proxy_port_ptr->number_of_address_entries++;

	host_address = (STRUCT_HOST_ENTRY *) struct_to_write ;
	get_ulong_ip_address( &host_address->ip_addr[0], &int_ip_addr);
	proxy_address_ptr->address = int_ip_addr;
	return TRUE;
}

int delete_proxy_address_entries (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset;
   CNF_PROXY_PORT  *proxy_port_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;

   offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) offset;
	calculate_offset_of_proxy_port(&offset, port_no);
	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

	if((index_to_delete > (proxy_port_ptr->number_of_address_entries-1))
			|| (index_to_delete < 0))
		return FALSE;

	proxy_port_ptr->number_of_address_entries-- ;

	offset += sizeof(BYTE) + (3 * sizeof(USHORT));
	offset += (sizeof(CNF_PROXY_ADDRESS_INFO) * index_to_delete ) ;

  	dst_offset = offset ;
  	offset += sizeof(CNF_PROXY_ADDRESS_INFO);

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset ;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
					
	SizetoRealloc = (proxy_header_ptr->section_length - sizeof(CNF_PROXY_ADDRESS_INFO));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE;
}

