/****************************************************************************
	Author    - 	Md.Imran Naveed
	Date	    - 	26 Aug 98
	Synopsis  -    Contains routines for NAT handling
*****************************************************************************/

#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <memory.h>
#include "cnffile.h"
#include <cfgmgr.h>
#include "fncdefs.h"

extern void *memmove (void *s1, const void *s2, size_t n);
int special_handling_for_dynamic_mapping(int indx_to_del); /* Imran,10.3.99 */

int add_global_address_entries (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, int_ip_addr;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_global_address_ptr ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

	SizetoRealloc = (proxy_header_ptr->section_length + sizeof(CNF_PROXY_ADDRESS_INFO));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_virtual_entry (&offset) ;
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;

	return_offset += (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_ptr->number_of_global_address_entries);
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset ;
	dst_offset = return_offset + sizeof(CNF_PROXY_ADDRESS_INFO);
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_virtual_entry(&offset);
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0);

	proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) (return_offset +
				 			sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_ptr->number_of_global_address_entries); 

	get_ulong_ip_address( (char *) struct_to_write, &int_ip_addr); 
	proxy_global_address_ptr->address = int_ip_addr;
	proxy_virtual_ptr->number_of_global_address_entries++;
	return TRUE;
}

int add_proxy_static_mapping (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, int_ip_addr, SizetoRealloc ;
	ULONG SizeToMove, dst_offset;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_STATIC_INFO *static_mapping_ptr ; 
	STRUCT_NAT_STATIC_ENTRY *static_entry;

   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

	SizetoRealloc = (proxy_header_ptr->section_length + sizeof(CNF_PROXY_STATIC_INFO));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_virtual_entry (&offset) ;
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
	static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;
	return_offset += (sizeof(CNF_PROXY_STATIC_INFO) * proxy_virtual_ptr->number_of_static_mapping_entries);
				 
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset; 
	dst_offset = return_offset + sizeof(CNF_PROXY_STATIC_INFO) ; 
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_virtual_entry (&offset);
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1);
	static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) (return_offset +
				 			sizeof(CNF_PROXY_STATIC_INFO) * proxy_virtual_ptr->number_of_static_mapping_entries); 
	
	static_entry = (STRUCT_NAT_STATIC_ENTRY *) struct_to_write;
	get_ulong_ip_address ( static_entry->local_addr, &int_ip_addr) ;
	static_mapping_ptr->local_address = int_ip_addr;
	get_ulong_ip_address ( static_entry->global_addr, &int_ip_addr) ; 
	static_mapping_ptr->global_address = int_ip_addr;

	proxy_virtual_ptr->number_of_static_mapping_entries++;
	return TRUE;
}

/* Imran, 10.3.99 */
int add_proxy_dynamic_mapping (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, int_ip_addr, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, no_of_ports, Size;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
	CNF_PROXY_DYNAMIC_INFO *dynamic_triplet_ptr ;
	STRUCT_NAT_DYNAMIC_ENTRY *dynamic_entry;

   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) struct_to_write;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
		
	if ((dynamic_entry->port == proxy_header_ptr->ftp_control_port) ||
			(dynamic_entry->port == proxy_header_ptr->ftp_data_port))
	{
			Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2 ;
			no_of_ports = 2;
	}
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	else
	{
		switch(dynamic_entry->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
/*			case 20	:
			case 21	:	*/
			case 989 :
			case 990	:
			case 900 :
			case 902 :
			case 5004 :
			case 5005 :
			case 5006 :
			case 5007 :
				Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2 ;
				no_of_ports = 2;
				break;
			
			default: 
				Size = sizeof(CNF_PROXY_DYNAMIC_INFO);
				no_of_ports = 1; 
		}
	}

	SizetoRealloc = (proxy_header_ptr->section_length + Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_virtual_entry (&offset) ;
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
	return_offset += (sizeof(CNF_PROXY_DYNAMIC_INFO) * proxy_virtual_ptr->number_of_dynamic_mapping_entries) ;

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset ;
	dst_offset = return_offset + Size;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_virtual_entry (&offset);
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2);
	return_offset += (sizeof(CNF_PROXY_DYNAMIC_INFO) * proxy_virtual_ptr->number_of_dynamic_mapping_entries); 
	dynamic_triplet_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset;
	
	proxy_virtual_ptr->number_of_dynamic_mapping_entries += no_of_ports ;
 	get_ulong_ip_address ( dynamic_entry->local_addr, &int_ip_addr) ; 
	dynamic_triplet_ptr->local_address = int_ip_addr;
	dynamic_triplet_ptr->protocol = dynamic_entry->protocol ? 17 : 6 ;
	dynamic_triplet_ptr->port = dynamic_entry->port ;
	if(no_of_ports > 1)
	{
		dynamic_triplet_ptr++;
		dynamic_triplet_ptr->local_address = int_ip_addr;
		dynamic_triplet_ptr->protocol = dynamic_entry->protocol ? 17 : 6 ;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

		if (dynamic_entry->port == proxy_header_ptr->ftp_data_port)
			dynamic_triplet_ptr->port =  proxy_header_ptr->ftp_control_port ;
		else if (dynamic_entry->port == proxy_header_ptr->ftp_control_port)
		{
			dynamic_triplet_ptr->port = proxy_header_ptr->ftp_control_port ;
			dynamic_triplet_ptr-- ;
			dynamic_triplet_ptr->port = proxy_header_ptr->ftp_data_port ;
		}
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
		else
		{
			switch(dynamic_entry->port)
			{
/*				case 20:*/
				case 989:
					dynamic_triplet_ptr->port = dynamic_entry->port + 1 ;
					break;

/* Jo 08/06/99 Added new ports for VOIP */
				case 900:
				case 5004:
				case 5005:
					dynamic_triplet_ptr->port = dynamic_entry->port + 2 ;
					break;

/*				case 21:*/
				case 990:
					dynamic_triplet_ptr->port = dynamic_entry->port ;
					dynamic_triplet_ptr--;
					dynamic_triplet_ptr->port--; /* This is just to store the lower port first */
					break;

/* Jo 08/06/99 Added new ports for VOIP */
				case 902:
				case 5006:
				case 5007:
					dynamic_triplet_ptr->port = dynamic_entry->port ;
					dynamic_triplet_ptr--;
					dynamic_triplet_ptr->port = dynamic_triplet_ptr->port - 2; /* This is just to store the lower port first */
					break;
			}
		}
	}
	return TRUE;
}

int delete_virtual_server_entries (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, return_offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, Size;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
   proxy_header_ptr = (CNF_PROXY_HEADER *) offset ;

	calculate_offset_of_proxy_virtual_entry(&offset);
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset;

	switch(parameter_id)
	{
		case DELETE_GLOBAL_ADDRESS_ENTRIES :
			calculate_offset_to_each_proxy_entry(&offset, &return_offset, 0);
			if((index_to_delete > (proxy_virtual_ptr->number_of_global_address_entries-1))
					|| (index_to_delete < 0))
				return FALSE;
			proxy_virtual_ptr->number_of_global_address_entries--;
			Size = sizeof(CNF_PROXY_ADDRESS_INFO);
			break;

		case DELETE_PROXY_STATIC_MAPPING :
			calculate_offset_to_each_proxy_entry(&offset, &return_offset, 1);
			if((index_to_delete > (proxy_virtual_ptr->number_of_static_mapping_entries-1))
					|| (index_to_delete < 0))
				return FALSE;
			proxy_virtual_ptr->number_of_static_mapping_entries--;
			Size = sizeof(CNF_PROXY_STATIC_INFO);
			break;

		case DELETE_PROXY_DYNAMIC_MAPPING :
			 if((index_to_delete > (proxy_virtual_ptr->number_of_dynamic_mapping_entries-1))
			 		|| (index_to_delete < 0))
			 	return FALSE;
			 return(special_handling_for_dynamic_mapping(index_to_delete));

		default : return FALSE ;
	}

	return_offset += Size * (index_to_delete + 1);
	dst_offset = return_offset - Size;
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	SizetoRealloc = (proxy_header_ptr->section_length - Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;
	return TRUE;
}

int special_handling_for_dynamic_mapping(int indx_to_del)
{
	ULONG offset, return_offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, Size, no_of_ports;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
   proxy_header_ptr = (CNF_PROXY_HEADER *) offset ;

	calculate_offset_of_proxy_virtual_entry(&offset);
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset;
	calculate_offset_to_each_proxy_entry(&offset, &return_offset, 2);			
	return_offset += (sizeof(CNF_PROXY_DYNAMIC_INFO) * indx_to_del);

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	
	if ((((CNF_PROXY_DYNAMIC_INFO *) return_offset)->port) == proxy_header_ptr->ftp_data_port)
	{
	 	dst_offset = return_offset ;
	 	return_offset += sizeof(CNF_PROXY_DYNAMIC_INFO) * 2 ;
	 	no_of_ports = 2 ;
	 	Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2 ;
	}
	else if ((((CNF_PROXY_DYNAMIC_INFO *) return_offset)->port)	== proxy_header_ptr->ftp_control_port)
	{
		dst_offset = return_offset - sizeof(CNF_PROXY_DYNAMIC_INFO) ;
		return_offset += sizeof(CNF_PROXY_DYNAMIC_INFO) ;
		no_of_ports = 2 ;
		Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2 ;
	}
	else
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	{	
		switch(((CNF_PROXY_DYNAMIC_INFO *) return_offset)->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
/*			case 20 :*/
			case 989:
			case 900:
			case 5004:
			case 5005:
				dst_offset = return_offset;
				return_offset += sizeof(CNF_PROXY_DYNAMIC_INFO) * 2;
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2;
				break;
		
/*			case 21 :*/
			case 990 :
			case 902:
			case 5006:
			case 5007:
				dst_offset = return_offset - sizeof(CNF_PROXY_DYNAMIC_INFO);
				return_offset += sizeof(CNF_PROXY_DYNAMIC_INFO);
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_DYNAMIC_INFO) * 2;
				break;

			default :
				dst_offset = return_offset;
				return_offset += sizeof(CNF_PROXY_DYNAMIC_INFO);
	 			no_of_ports = 1;
				Size = sizeof(CNF_PROXY_DYNAMIC_INFO);
				break;
		}
	}
	proxy_virtual_ptr->number_of_dynamic_mapping_entries -= no_of_ports;
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset ;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	SizetoRealloc = (proxy_header_ptr->section_length - Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return 1;
}
/* Imran, 10.3.99 */
