/**************************************************************************
	Author    - 	Md.Imran Naveed
	Date	    - 	22  Aug 98
	Synopsis  -    Contains proxy server support routines
***************************************************************************/

#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <memory.h>
#include "cnffile.h"
#include <cfgmgr.h>
#include "fncdefs.h"

extern USHORT ftp_prev_ctrl_port_number, ftp_prev_data_port_number ; 

extern void *memmove (void *s1, const void *s2, size_t n);
extern int get_ulong_ip_address(char *dot_decimal_ip_address, ULONG *int_ip_address);
extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);

int  calculate_offset_of_proxy_application_entries (ULONG *offset)
{
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    *offset = (ULONG) proxy_application_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_user_defined_application_entries (ULONG *offset)
{
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (4 * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    *offset = (ULONG) proxy_user_defined_application_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_filter (ULONG *offset)
{
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (4 * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 
   *offset = (ULONG) proxy_filter_ptr ;
   return TRUE;
}

int calculate_offset_to_each_proxy_filter (ULONG *offset, ULONG *return_offset, int filter_number) 
{
   CNF_PROXY_FILTER *proxy_filter_ptr ; 

   proxy_filter_ptr = (CNF_PROXY_FILTER *) *offset ;
   switch (filter_number)
   {
    	case 0 : *return_offset = (ULONG) proxy_filter_ptr + (5 * sizeof(USHORT)) ;
					 break ;
    	case 1 : *return_offset = ((ULONG) proxy_filter_ptr + (5 * sizeof(USHORT)) + 
					 (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries)) ;
					 break ;
		case 2 : *return_offset = ((ULONG) proxy_filter_ptr + (5 * sizeof(USHORT)) + 
					 (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
					 (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries)) ;
					 break ;

		case 3 : *return_offset = ((ULONG) proxy_filter_ptr + (5 * sizeof(USHORT)) + 
				  	(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
				  	(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries) +
				  	(sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries)) ;
					 break ;
		case 4 : *return_offset = ((ULONG) proxy_filter_ptr + (5 * sizeof(USHORT)) + 
				  	(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
				  	(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries) +
				  	(sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries) +
				  	(sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * proxy_filter_ptr->number_of_mac_address_entries)) ; 
					break ;
   }
   return TRUE ;
}

int calculate_offset_of_proxy_virtual_entry (ULONG *offset)
{
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (4 * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    *offset = (ULONG) proxy_virtual_server_ptr ;
    return TRUE;
}

int calculate_offset_to_each_proxy_entry (ULONG *offset, ULONG *return_offset, int entry_type) 
{
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;

    proxy_virtual_server_ptr = (CNF_PROXY_VIRTUAL_SERVER *) *offset ;
    switch (entry_type)
    {
	    	case 0 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG)) ;
						 break ;
	    	case 1 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) + 
					   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries)) ;
		 				break ;
			case 2 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) + 
					   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries) +
				  		(sizeof(CNF_PROXY_STATIC_INFO) * proxy_virtual_server_ptr->number_of_static_mapping_entries)) ;
						break ;
    }
    return TRUE ;
}

int add_restricted_application_filters (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, SizetoRealloc, Size ;
	ULONG SizeToMove, dst_offset;
	int no_of_ports;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_APP *proxy_application_ptr ;
	STRUCT_PROXY_ENTRY *struct_proxy_entry ;

	struct_proxy_entry = (STRUCT_PROXY_ENTRY *) struct_to_write;

   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
		
	if ((struct_proxy_entry->port == proxy_header_ptr->ftp_control_port) ||
			(struct_proxy_entry->port == proxy_header_ptr->ftp_data_port))
	{
			Size = sizeof(CNF_PROXY_APP) * 2 ;
			no_of_ports = 2 ;
	}

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	else
	{
		switch(struct_proxy_entry->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
/*			case 20	:
			case 21	:	*/
			case 989	:
			case 990 :
			case 900 :
			case 902 :
			case 5004 :
			case 5005 :
			case 5006 :
			case 5007 :
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				no_of_ports = 2;
				break;
			
			default: 
				Size = sizeof(CNF_PROXY_APP);
				no_of_ports = 1; 
		}
	}
					
	SizetoRealloc = (proxy_header_ptr->section_length + Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;

	calculate_offset_of_proxy_filter (&offset) ;
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
   return_offset += (sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries);
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	dst_offset = return_offset + Size;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2);

	proxy_application_ptr = (CNF_PROXY_APP *) (return_offset +
				 			sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries); 
	proxy_filter_ptr->number_of_restricted_application_entries += no_of_ports;
	proxy_application_ptr->port = struct_proxy_entry->port;
	proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

	if (struct_proxy_entry->port == proxy_header_ptr->ftp_data_port)
	{
		proxy_application_ptr++ ;
		proxy_application_ptr->port = proxy_header_ptr->ftp_control_port ;
		proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6 ;
	}
	else if (struct_proxy_entry->port == proxy_header_ptr->ftp_control_port)
	{
		proxy_application_ptr->port = proxy_header_ptr->ftp_data_port ;
		proxy_application_ptr++ ;
		proxy_application_ptr->port = proxy_header_ptr->ftp_control_port ;
		proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6 ;
	}
	else
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	{
		switch(struct_proxy_entry->port)
		{
/*			case 20	:*/
			case 989 :
				proxy_application_ptr++;
				proxy_application_ptr->port = struct_proxy_entry->port + 1;
				proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
				break;

/* Jo 08/06/99 Added new ports for VOIP */
			case 900:
			case 5004:
			case 5005:
				proxy_application_ptr++;
				proxy_application_ptr->port = struct_proxy_entry->port + 2;
				proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
				break;

/*			case 21	:*/
			case 990 :
				proxy_application_ptr->port--;
				proxy_application_ptr++;
				proxy_application_ptr->port = struct_proxy_entry->port;
				proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
			   break;

/* Jo 08/06/99 Added new ports for VOIP */
			case 902:
			case 5006:
			case 5007:
				proxy_application_ptr->port = proxy_application_ptr->port - 2;
				proxy_application_ptr++;
				proxy_application_ptr->port = struct_proxy_entry->port;
				proxy_application_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
			   break;
		}
	}
	return TRUE;
}

int delete_restricted_application_filters (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, return_offset, SizetoRealloc, Size ;
	ULONG SizeToMove, dst_offset;
	int no_of_ports;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_APP *proxy_application_ptr ;

   offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) offset;
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2);
	return_offset += sizeof(CNF_PROXY_APP) * (index_to_delete) ;
	proxy_application_ptr = (CNF_PROXY_APP *) return_offset ;
	
	if((index_to_delete > (proxy_filter_ptr->number_of_restricted_application_entries-1))
			|| (index_to_delete < 0))
		return FALSE;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

	if (proxy_application_ptr->port == proxy_header_ptr->ftp_data_port)
	{
		dst_offset = return_offset ;
		return_offset += sizeof(CNF_PROXY_APP) * 2 ;
		no_of_ports = 2 ;
		Size = sizeof(CNF_PROXY_APP) * 2 ;
	}
	else if (proxy_application_ptr->port == proxy_header_ptr->ftp_control_port)
	{
		dst_offset = return_offset - sizeof(CNF_PROXY_APP) ;
		return_offset += sizeof(CNF_PROXY_APP) ;
		no_of_ports = 2 ;
		Size = sizeof(CNF_PROXY_APP) * 2 ;
	}
	else
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	{
		switch(proxy_application_ptr->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
/*			case 20 :*/
			case 989 :
			case 900 :
			case 5004 :
			case 5005 :
				dst_offset = return_offset;
				return_offset += sizeof(CNF_PROXY_APP) * 2;
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				break;
			
/*			case 21 :*/
			case 990 :
			case 902 :
			case 5006 :
			case 5007 :
				dst_offset = return_offset - sizeof(CNF_PROXY_APP);
				return_offset += sizeof(CNF_PROXY_APP);
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				break;

			default :
				dst_offset = return_offset ;
				return_offset += sizeof(CNF_PROXY_APP);
				no_of_ports = 1;
				Size = sizeof(CNF_PROXY_APP) ;
				break;
		}
	}
	proxy_filter_ptr->number_of_restricted_application_entries -= no_of_ports;
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
					
	SizetoRealloc = (proxy_header_ptr->section_length - Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE;
}

int add_proxy_address_filter (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, return_offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset, Size, int_ip_addr;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_MAC_ADDRESS_INFO *proxy_mac_address_ptr ;
	CNF_PROXY_DOMAIN_NAME_INFO *proxy_domain_name_ptr ;
	CNF_PROXY_ADDRESS_INFO *proxy_address_ptr ;
	STRUCT_PROXY_FILTER *struct_proxy_filter ;

   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

	switch(port_no)
	{
		case PROXY_DEST_ADDR_FILTER:
			if(is_duplicate_ip_addr_filter((char *) struct_to_write,0) == TRUE)
				return FALSE;
			Size = sizeof(CNF_PROXY_ADDRESS_INFO);
			break;
			
		case PROXY_SOURCE_ADDR_FILTER :
				if(is_duplicate_ip_addr_filter((char *) struct_to_write,1) == TRUE)
					return FALSE;
				Size = sizeof(CNF_PROXY_ADDRESS_INFO);
				break;

		case PROXY_MAC_ADDR_FILTER :
				if(is_duplicate_mac_addr_filter((char *) struct_to_write) == TRUE)
					return FALSE;
				Size = sizeof(CNF_PROXY_MAC_ADDRESS_INFO);
				break;

		case PROXY_DNS_ADDR_FILTER:
				if(is_duplicate_domain_name_filter((char *) struct_to_write) == TRUE)
					return FALSE;
				Size = sizeof(CNF_PROXY_DOMAIN_NAME_INFO);
				break;

      default : return FALSE;
	}
	SizetoRealloc = proxy_header_ptr->section_length + Size;
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;

	calculate_offset_of_proxy_filter (&offset) ;
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	switch(port_no)
	{
	case  PROXY_DEST_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
			return_offset += (sizeof(ULONG) * proxy_filter_ptr->number_of_forbidden_sites_entries);
			break;

	case  PROXY_SOURCE_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
			return_offset += (sizeof(ULONG) * proxy_filter_ptr->number_of_restricted_clients_entries);
			break;

	case  PROXY_MAC_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
			return_offset += (sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * proxy_filter_ptr->number_of_mac_address_entries);
			break;
	
	case  PROXY_DNS_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
			return_offset += (sizeof(CNF_PROXY_DOMAIN_NAME_INFO) * proxy_filter_ptr->number_of_domain_name_entries);
			break;
	}

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	dst_offset = return_offset + Size;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;

	struct_proxy_filter =  (STRUCT_PROXY_FILTER *) struct_to_write;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;

	switch(port_no)
	{
	case PROXY_DEST_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
			proxy_address_ptr = (CNF_PROXY_ADDRESS_INFO *) (return_offset +
			     			sizeof(ULONG) * proxy_filter_ptr->number_of_forbidden_sites_entries);
			get_ulong_ip_address ( (char *) struct_proxy_filter->addr, &int_ip_addr) ; 

			proxy_address_ptr->address = int_ip_addr;
			proxy_filter_ptr->number_of_forbidden_sites_entries++;
			break;

	case PROXY_SOURCE_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
			proxy_address_ptr = (CNF_PROXY_ADDRESS_INFO *) (return_offset +
					sizeof(ULONG) * proxy_filter_ptr->number_of_restricted_clients_entries);
			get_ulong_ip_address ( (char *) struct_proxy_filter->addr, &int_ip_addr) ; 
			proxy_address_ptr->address = int_ip_addr;
			proxy_filter_ptr->number_of_restricted_clients_entries++;
			break;

	case PROXY_MAC_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
			proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) (return_offset +
						 			sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * proxy_filter_ptr->number_of_mac_address_entries); 
			strcpy(proxy_mac_address_ptr->address, (char *) struct_proxy_filter->addr);
			proxy_filter_ptr->number_of_mac_address_entries++;
			break;

	case PROXY_DNS_ADDR_FILTER :
			calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
			proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) (return_offset +	
						 			sizeof(CNF_PROXY_DOMAIN_NAME_INFO) * proxy_filter_ptr->number_of_domain_name_entries); 
			strcpy(proxy_domain_name_ptr->domain_name, struct_proxy_filter->addr);	
			proxy_filter_ptr->number_of_domain_name_entries++;
			break;
	}
	return TRUE;
}

int delete_proxy_address_filters (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, return_offset, SizetoRealloc, Size ;
	ULONG SizeToMove, dst_offset;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
   proxy_header_ptr = (CNF_PROXY_HEADER *) offset ;
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;

	switch(port_no)
	{
		case PROXY_DEST_ADDR_FILTER	:
				if((index_to_delete > (proxy_filter_ptr->number_of_forbidden_sites_entries-1))
						|| (index_to_delete < 0))
					return FALSE;

				proxy_filter_ptr->number_of_forbidden_sites_entries-- ;
				calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0);
				Size = sizeof(CNF_PROXY_ADDRESS_INFO);
				break;

		case PROXY_SOURCE_ADDR_FILTER :
				if((index_to_delete > (proxy_filter_ptr->number_of_restricted_clients_entries-1))
						|| (index_to_delete < 0))
					return FALSE;

				proxy_filter_ptr->number_of_restricted_clients_entries-- ;
				calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1);
				Size = sizeof(CNF_PROXY_ADDRESS_INFO);
				break;

		case PROXY_MAC_ADDR_FILTER :
				if((index_to_delete > (proxy_filter_ptr->number_of_mac_address_entries-1))
						|| (index_to_delete < 0))
					return FALSE;

				proxy_filter_ptr->number_of_mac_address_entries-- ;
				calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3);
				Size = sizeof(CNF_PROXY_MAC_ADDRESS_INFO);
				break;

		case PROXY_DNS_ADDR_FILTER :
				if((index_to_delete > (proxy_filter_ptr->number_of_domain_name_entries-1))
						|| (index_to_delete < 0))
					return FALSE;
				proxy_filter_ptr->number_of_domain_name_entries-- ;
				calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4);
  				Size = sizeof(CNF_PROXY_DOMAIN_NAME_INFO);
  				break;

      default : return FALSE;
	}

	return_offset +=  Size * (index_to_delete + 1);
	dst_offset = return_offset - Size ;

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset;
	memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
					
	SizetoRealloc = (proxy_header_ptr->section_length - Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,	
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE;
}

int add_proxy_application (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, SizetoRealloc, Size ;
	ULONG SizeToMove, dst_offset;
	int no_of_ports;
   CNF_PROXY_APPLICATION *proxy_application_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_APP *proxy_app_ptr ;
	STRUCT_PROXY_ENTRY *struct_proxy_entry ;

	struct_proxy_entry = (STRUCT_PROXY_ENTRY *) struct_to_write;
   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
		
	if ((struct_proxy_entry->port == proxy_header_ptr->ftp_control_port) ||
			(struct_proxy_entry->port == proxy_header_ptr->ftp_data_port))
	{
			Size = sizeof(CNF_PROXY_APP) * 2 ;
			no_of_ports = 2 ;
	}

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

	else
	{
		switch(struct_proxy_entry->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
#if 0
			case 20	:
			case 21	:	
#endif
			case 989 :
			case 990	:
			case 900 :
			case 902 :
			case 5004 :
			case 5005 :
			case 5006 :
			case 5007 :
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				no_of_ports = 2;
				break;

			default: 
				Size = sizeof(CNF_PROXY_APP);
				no_of_ports = 1; 
		}
	}
					
	SizetoRealloc = (proxy_header_ptr->section_length + Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_application_entries (&offset) ;
	proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

   offset += (2 + (sizeof(CNF_PROXY_APP) * proxy_application_ptr->number_of_application_entries));
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset;
	dst_offset = offset + Size;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_application_entries(&offset);
	proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

	proxy_app_ptr = (CNF_PROXY_APP *) (offset + sizeof(USHORT) +
				 			sizeof(CNF_PROXY_APP) * proxy_application_ptr->number_of_application_entries); 
	proxy_application_ptr->number_of_application_entries += no_of_ports;
	proxy_app_ptr->port = struct_proxy_entry->port;
	proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

	if (struct_proxy_entry->port == proxy_header_ptr->ftp_data_port)
	{
		proxy_app_ptr++ ;
		proxy_app_ptr->port = proxy_header_ptr->ftp_control_port ;
		proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6 ;
	}
	else if (struct_proxy_entry->port == proxy_header_ptr->ftp_control_port)
	{
		proxy_app_ptr->port = proxy_header_ptr->ftp_data_port ;
		proxy_app_ptr++ ;
		proxy_app_ptr->port = proxy_header_ptr->ftp_control_port ;
		proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6 ;
	}
	else
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	{
		switch(struct_proxy_entry->port)
		{
/*			case 20	:*/
			case 989 :
				proxy_app_ptr++;
				proxy_app_ptr->port = struct_proxy_entry->port + 1;
				proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
				break;

/* Jo 08/06/99 Added new ports for VOIP */
			case 900:
			case 5004:
			case 5005:
				proxy_app_ptr++;
				proxy_app_ptr->port = struct_proxy_entry->port + 2;
				proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
				break;

/*			case 21	:*/
			case 990 :
				proxy_app_ptr->port--;
				proxy_app_ptr++;
				proxy_app_ptr->port = struct_proxy_entry->port;
				proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
		   	break;

/* Jo 08/06/99 Added new ports for VOIP */
			case 902:
			case 5006:
			case 5007:
				proxy_app_ptr->port = proxy_app_ptr->port - 2;
				proxy_app_ptr++;
				proxy_app_ptr->port = struct_proxy_entry->port;
				proxy_app_ptr->protocol = struct_proxy_entry->protocol ? 17 : 6;
		   	break;
		}
	}
	return TRUE;
}

int add_proxy_user_defined_application (ULONG parameter_id, USHORT port_no, void *struct_to_write)
{
   ULONG offset, SizetoRealloc,proto;
	ULONG SizeToMove, dst_offset;
   CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_defined_application_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_USER_DEFINED_APP *proxy_user_app_ptr ;
	STRUCT_PROXY_USER_ENTRY *struct_proxy_user_entry ;

	struct_proxy_user_entry = (STRUCT_PROXY_USER_ENTRY *) struct_to_write;
   proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	SizetoRealloc = (proxy_header_ptr->section_length + sizeof(CNF_PROXY_USER_DEFINED_APP));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
	proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

   offset += (2 + (sizeof(CNF_PROXY_USER_DEFINED_APP) * proxy_user_defined_application_ptr->number_of_user_defined_application_entries));
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset;
	dst_offset = offset + sizeof(CNF_PROXY_USER_DEFINED_APP);
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ; 
	calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
	proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;
	proxy_user_app_ptr = (CNF_PROXY_USER_DEFINED_APP *) (offset + sizeof(USHORT) +
				 			sizeof(CNF_PROXY_USER_DEFINED_APP) * proxy_user_defined_application_ptr->number_of_user_defined_application_entries); 
	proxy_user_defined_application_ptr->number_of_user_defined_application_entries++ ;

	proxy_user_app_ptr->protocol = struct_proxy_user_entry->protocol ? 17 : 6;
	proxy_user_app_ptr->lower_port_number = struct_proxy_user_entry->lower_port_number;
	proxy_user_app_ptr->higher_port_number = struct_proxy_user_entry->higher_port_number;
	strcpy(proxy_user_app_ptr->port_description, struct_proxy_user_entry->port_description);
	return TRUE;
}

int delete_proxy_user_application_entries (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, SizetoRealloc ;
	ULONG SizeToMove, dst_offset;
   CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_defined_application_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;

   offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) offset;
	calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
	proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

	if((index_to_delete > (proxy_user_defined_application_ptr->number_of_user_defined_application_entries-1))
			|| (index_to_delete < 0))
		return FALSE;

	proxy_user_defined_application_ptr->number_of_user_defined_application_entries-- ;
	offset += sizeof(USHORT) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * index_to_delete) ;

  	dst_offset = offset ;
  	offset += sizeof(CNF_PROXY_USER_DEFINED_APP);
	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset ;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
					
	SizetoRealloc = (proxy_header_ptr->section_length - sizeof(CNF_PROXY_USER_DEFINED_APP));
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE;
}

int delete_proxy_application (ULONG parameter_id, USHORT port_no, int index_to_delete)
{
   ULONG offset, SizetoRealloc, Size ;
	ULONG SizeToMove, dst_offset;
	int no_of_ports;
   CNF_PROXY_APPLICATION *proxy_application_ptr ;
	CNF_PROXY_HEADER *proxy_header_ptr ;
   CNF_PROXY_APP *proxy_app_ptr ;

   offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) offset;
	calculate_offset_of_proxy_application_entries(&offset);
	proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

	if((index_to_delete >= proxy_application_ptr->number_of_application_entries)
			|| (index_to_delete < 0))
		return FALSE;

	offset += sizeof(USHORT) + (sizeof(CNF_PROXY_APP) * index_to_delete ) ;
	proxy_app_ptr = (CNF_PROXY_APP *) offset ;

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

	if (proxy_app_ptr->port == ftp_prev_data_port_number)
	{
		dst_offset = offset ;
		offset += sizeof(CNF_PROXY_APP) * 2 ;
		no_of_ports = 2 ;
		Size = sizeof(CNF_PROXY_APP) * 2 ;
	}
	else if (proxy_app_ptr->port == ftp_prev_ctrl_port_number)
	{
		dst_offset = offset - sizeof(CNF_PROXY_APP) ;
		offset += sizeof(CNF_PROXY_APP) ;
		no_of_ports = 2 ;
		Size = sizeof(CNF_PROXY_APP) * 2 ;
	}	
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
	else
	{
		switch(proxy_app_ptr->port)
		{
/* Jo 08/06/99 Added new ports for VOIP */
/*			case 20 	:*/
			case 989 :
			case 900:
			case 5004:
			case 5005:
				dst_offset = offset;
				offset += sizeof(CNF_PROXY_APP) * 2;
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				break;

/*			case 21 	:*/
			case 990	:
			case 902:
			case 5006:
			case 5007:
				dst_offset = offset - sizeof(CNF_PROXY_APP);
				offset += sizeof(CNF_PROXY_APP);
				no_of_ports = 2;
				Size = sizeof(CNF_PROXY_APP) * 2 ;
				break;

			default :
				dst_offset = offset ;
				offset += sizeof(CNF_PROXY_APP);
				no_of_ports = 1;
				Size = sizeof(CNF_PROXY_APP) ;
				break;
		}
	}
	proxy_application_ptr->number_of_application_entries -= no_of_ports;

	SizeToMove = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset ;
	memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
					
	SizetoRealloc = (proxy_header_ptr->section_length - Size);
	write_permitted_structures[CM_PROXY_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_PROXY_ID].ptr_to_struct,
						proxy_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_PROXY_ID].size_of_struct = (USHORT) SizetoRealloc ;

	proxy_header_ptr = (CNF_PROXY_HEADER *) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	proxy_header_ptr->section_length = (USHORT) SizetoRealloc ;

	return TRUE;
}

BYTE is_duplicate_application(USHORT protocol, USHORT port, USHORT index)
{			
	ULONG offset,return_offset ;		
	USHORT count,bflag=0;
	CNF_PROXY_FILTER *proxy_filter_ptr;
	CNF_PROXY_APPLICATION *proxy_application_ptr;
	CNF_PROXY_APP *proxy_app_ptr;

CheckForTcpUdp:
	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	switch(index)
	{
		case PROXY_APPLICATION :
				calculate_offset_of_proxy_application_entries(&offset);
				proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset;
			   proxy_app_ptr = (CNF_PROXY_APP *) (offset + sizeof(USHORT));
				count = proxy_application_ptr->number_of_application_entries;
				break;

		case PROXY_FILTER :
				calculate_offset_of_proxy_filter(&offset);
				proxy_filter_ptr = (CNF_PROXY_FILTER *) offset;
				count = proxy_filter_ptr->number_of_restricted_application_entries;
				calculate_offset_to_each_proxy_filter(&offset,&return_offset,2);
				proxy_app_ptr = (CNF_PROXY_APP *) return_offset;
				break;
	}

	if (protocol == 50)
	{
		protocol = 6;
		bflag = 1;
	}

	while(count--)
	{
		if((protocol == proxy_app_ptr->protocol) && (port == proxy_app_ptr->port))
			 return TRUE;
		proxy_app_ptr++;
	}

	if(bflag)
	{
		protocol = 17;
		bflag = 0;
		goto	CheckForTcpUdp;
	}
	return FALSE;
}

BYTE is_duplicate_user_application(STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_entry,int edit_index)
{
	ULONG offset,return_offset ;		
	USHORT count,check_indx=0,protocol, Loport, Hiport, port,bflag=0,proto = 6, index;
	BYTE port_desc[20],port_string[20];
	CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_application_ptr ; 
	CNF_PROXY_USER_DEFINED_APP *proxy_user_app_ptr ;

	edit_index--;
	protocol = ptr_to_proxy_user_entry->protocol;
	Loport = ptr_to_proxy_user_entry->lower_port_number;
	Hiport = ptr_to_proxy_user_entry->higher_port_number;
	strcpy(port_desc,ptr_to_proxy_user_entry->port_description);

	if (protocol == 50)
	{
		protocol = 6;
		bflag = 1;
	}

/* Jo 08/06/99 Max number of Proxy ports = 39 */
	for(index = 1; index <= MAX_TCP_APPLICATIONS ; index++)
	{
		port = get_protocol_port_number(proto, index);
		if((port == Loport) || (port == Hiport) || ((port >= Loport) && (port <= Hiport)))
		{
			printf("\n\rApplication overlaps a standard port(%d)",port);
			return TRUE;
		}
		get_port_type(port_string,(enum IP_PROTOCOL_VALUE) proto, port);
		if(!strcmpi(port_string,port_desc))
		{
			printf("\n\rPort description matches a standard port description");
			return TRUE;
		}
	}
	
	if(Hiport != 0)
	{
	  	return(is_duplicate_port_range(ptr_to_proxy_user_entry->protocol,Loport,Hiport,port_desc,edit_index));
	}

CHECK_AGAIN :
	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_user_defined_application_entries(&offset);
	count = ((CNF_PROXY_USER_DEFINED_APPLICATION *)offset)->number_of_user_defined_application_entries;
	proxy_user_app_ptr = (CNF_PROXY_USER_DEFINED_APP *) ((char *) offset + 2);
	while(count--)
	{
		if(edit_index == check_indx++) /* When editing,dont compare with the same entry */
		{
			proxy_user_app_ptr++;
			continue;
		}
		if(protocol == proxy_user_app_ptr->protocol)
		{
			if((Loport == proxy_user_app_ptr->lower_port_number) ||
					(Loport == proxy_user_app_ptr->higher_port_number))
			{
				printf ("\n\rDuplicate Port number")	;
				return TRUE;
			}
			if((Loport > proxy_user_app_ptr->lower_port_number) &&
					(Loport < proxy_user_app_ptr->higher_port_number))
			{
				printf("\n\rPort is already defined by a range");
				return TRUE;
			}
		}

		proxy_user_app_ptr++;
	}
	if(bflag)
	{
		bflag = 0;
		protocol = 17;
		goto CHECK_AGAIN;
	}
	return FALSE;
}						  

BYTE is_duplicate_port_range(USHORT protocol,USHORT Loport,USHORT Hiport,char *port_desc,int edit_index)
{
	ULONG offset;
	USHORT check_indx=0,count,bflag=0;
	CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_application_ptr ; 
	CNF_PROXY_USER_DEFINED_APP *proxy_user_app_ptr ;

	if (protocol == 50)
	{
		protocol = 6;
		bflag = 1;
	}
CHECK_NEXT :
	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_user_defined_application_entries(&offset);
	count = ((CNF_PROXY_USER_DEFINED_APPLICATION *)offset)->number_of_user_defined_application_entries;
	proxy_user_app_ptr = (CNF_PROXY_USER_DEFINED_APP *) ((char *) offset + 2);
	while(count--)
	{
		if(edit_index == check_indx++) /* When editing,dont compare with the same entry */
		{
			proxy_user_app_ptr++;
			continue;
		}

		if(protocol == proxy_user_app_ptr->protocol)
		{
			if((Loport == proxy_user_app_ptr->lower_port_number) || (Hiport == proxy_user_app_ptr->higher_port_number) ||
				(Loport == proxy_user_app_ptr->higher_port_number) || (Hiport == proxy_user_app_ptr->lower_port_number))
			{
				printf("\n\rPort number matched defined range Boundaries") ;
				return TRUE;
			}
			if(((Loport >= proxy_user_app_ptr->lower_port_number) && (Loport <= proxy_user_app_ptr->higher_port_number)) ||
							((Hiport >= proxy_user_app_ptr->lower_port_number) && (Hiport <= proxy_user_app_ptr->higher_port_number)))
			{
				printf("\n\rRange is covered by previously defined range");
				return TRUE;
			}

			if(((proxy_user_app_ptr->lower_port_number >= Loport) && (proxy_user_app_ptr->lower_port_number <= Hiport)) ||
						((proxy_user_app_ptr->higher_port_number >= Loport) && (proxy_user_app_ptr->higher_port_number <= Hiport)))
			{
				printf("\n\rRange covers previously defined range");
				return TRUE;
			}
		}
		proxy_user_app_ptr++;
	}
 	if(bflag)
	{
		bflag = 0;
		protocol = 17;
		goto CHECK_NEXT;
	}
	return FALSE;
}


BYTE is_duplicate_ip_addr_filter(BYTE *ip_addr, USHORT index)
{			
	ULONG offset, return_offset, ulong_ip_addr ;		
	USHORT count;
	CNF_PROXY_FILTER *proxy_filter_ptr;
	CNF_PROXY_ADDRESS_INFO *proxy_addr_ptr;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset;
													  
	(count = index ? proxy_filter_ptr->number_of_restricted_clients_entries :
							proxy_filter_ptr->number_of_forbidden_sites_entries);
	calculate_offset_to_each_proxy_filter(&offset,&return_offset,index);
	proxy_addr_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset;
	get_ulong_ip_address(ip_addr, &ulong_ip_addr);

	while(count)
	{
		if(ulong_ip_addr == proxy_addr_ptr->address)
			 return TRUE;
		proxy_addr_ptr++;
		count--;
	}
	return FALSE;
}

BYTE is_duplicate_mac_addr_filter(BYTE *mac_addr)
{			
	ULONG offset, return_offset;
	USHORT count;
	CNF_PROXY_FILTER *proxy_filter_ptr;
	CNF_PROXY_MAC_ADDRESS_INFO  *proxy_mac_addr_ptr ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset;
	calculate_offset_to_each_proxy_filter(&offset,&return_offset,3);
	count = proxy_filter_ptr->number_of_mac_address_entries ;
	proxy_mac_addr_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset;

	while(count)
	{
		if (!strcmp(mac_addr,proxy_mac_addr_ptr->address))
			 return TRUE;
		proxy_mac_addr_ptr++;
		count--;
	}
	return FALSE;
}

BYTE is_duplicate_domain_name_filter(BYTE *domain_name)
{			
	ULONG offset, return_offset;
	USHORT count;
	CNF_PROXY_FILTER *proxy_filter_ptr;
	CNF_PROXY_DOMAIN_NAME_INFO  *proxy_domain_name_ptr ;

	offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct;
	calculate_offset_of_proxy_filter(&offset);
	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset;
	calculate_offset_to_each_proxy_filter(&offset,&return_offset,4);
	count = proxy_filter_ptr->number_of_domain_name_entries ;
	proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset;

	while(count)
	{
		if (!strcmp(domain_name,proxy_domain_name_ptr->domain_name))
			 return TRUE;
		proxy_domain_name_ptr++;
		count--;
	}
	return FALSE;
}

