#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>

#include <cfgmgr.h>
#include "fncdefs.h"
#include "cnffile.h"
#define NUMBER_OF_BYTES_IN_IP_ADDRESS	4
#define LOWER_LIMIT_OF_BYTE_IN_IP_ADDRESS 0
#define UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS 255
#define NUMBER_OF_BITS_IN_A_BYTE 8

/* Local Prototypes ... */
char *get_user_port_type (char *port_type_string, USHORT protocol_type, USHORT protocol_port_number);
BYTE is_an_ip_address(BYTE* address);
BYTE is_an_ip_address_even_if_zero(BYTE* address); /* Jo 08/04/99 */
BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
BYTE valid_bit_sequence(BYTE* mask);
BYTE mask_compatible_with_ip_address(BYTE* address, BYTE* mask);
BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
void format_address(BYTE* address);
BYTE is_valid_ipx_network_number(BYTE* string_ptr);
BYTE is_valid_string_to_read_data(BYTE* buffer);

/* Jo Added for RAS 
void set_client_only_interdep (USHORT port_no) ;
void set_ppp_strings (ULONG parameter_id, USHORT port_number, BYTE valid) ;
enum BOOLEAN set_mlppp_dependencies (enum BOOLEAN flag) ;
BOOL IsStrNumericAndValid (char *Str) ;

/* ... Local Prototypes */

#if 0
int get_ulong_ip_from_dot_decimal (const char *dot_decimal_ip_address, unsigned long *int_ip_address)
{
	unsigned long addr1, addr2, addr3, addr4 ;

	addr1 = addr2 = addr3 = addr4 = 0L ;

	sscanf (dot_decimal_ip_address, "%03u.%03u.%03u.%03u", &addr1, &addr2, &addr3, &addr4) ;
	*int_ip_address = (addr1 << 24) + (addr2 << 16) + (addr3 << 8) + addr4 ;
	return 1 ;
}
#endif

/* Jo 05/05/99 */
#if 0
/* Imran,30/12/98 */
char *get_user_port_type (char *port_type_string, USHORT protocol_type, USHORT protocol_port_number)
{
	int total_entries ;
	ULONG offset;
	CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_app_ptr;
	CNF_PROXY_USER_DEFINED_APP *proxy_user_defined_app_ptr;

   offset = (ULONG) write_permitted_structures[CM_PROXY_ID].ptr_to_struct ;
	calculate_offset_of_proxy_user_defined_application_entries (&offset);
	proxy_user_app_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;
	total_entries = proxy_user_app_ptr->number_of_user_defined_application_entries;
	
	proxy_user_defined_app_ptr = (CNF_PROXY_USER_DEFINED_APP *) ((char *)proxy_user_app_ptr + 2);
	strcpy(port_type_string , "not defined");
	while(total_entries)
	{
		if((proxy_user_defined_app_ptr->lower_port_number == protocol_port_number)
			 	&& (proxy_user_defined_app_ptr->protocol == protocol_type))
		{
			sprintf(port_type_string, proxy_user_defined_app_ptr->port_description);
			break;
		}
		total_entries-- ;
		proxy_user_defined_app_ptr += sizeof(CNF_PROXY_USER_DEFINED_APP) ;
	}
	return(port_type_string);
}
/* Imran,30/12/98 */
#endif
/* Jo 05/05/99 */

/* Imran, 10.3.99 */
BYTE valid_characters_in(BYTE* address)
{
	BYTE i;

	for( i = 0 ; i < strlen(address) ; i++ )
	{														
		if (address[i] == '.' || (address[i] >= '0' && address[i] <= '9'))
			continue;
		else
			return FALSE;
	}
	return TRUE;
}
/* Jo 04/10/99 */
BOOL IsStrNumericAndValid (char *Str)
{
	char *tmpStr;
	int	LenStr;
	ULONG Value;

	tmpStr = Str;

	while (*Str)
		if (*Str < '0' || *Str > '9')
			return FALSE;
		else
			Str++;

	LenStr = strlen(tmpStr);	//If string id more than 5 digits error
	if (LenStr > 5)
		return FALSE;

	sscanf(tmpStr, "%ld", &Value);

	if (Value > 0xFFFFl)
		return FALSE;

	return TRUE;
}
/* Jo 04/10/99 */

BYTE is_an_ip_address(BYTE* address)
{
	BYTE main_index = 0, i, number_of_dots = 0;
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	USHORT number_of_characters;

	/* Check For Number of Dots */
	for(i=0;i<strlen(address);++i)
	{
		if (address[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(address))
		return FALSE;

   /* The following function will remove unwanted zeros in the address */
   format_address(address);

	/* Check whether this address forms an ip address. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(address))
		{
			if (address[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters || number_of_characters > 3)
			return FALSE;
	}

	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));

	/* Each Byte Should be in the Range 1-254. Otherwise it is not an valid
	   IP address */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		if (ip_address_array[i] < LOWER_LIMIT_OF_BYTE_IN_IP_ADDRESS 
		    || ip_address_array[i] > UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS)
		{
			return FALSE;
		}
	}
	/* Now the passed address is an valid ip address hence return TRUE */
	return TRUE;
}

/*	Jo 08/04/99 Consider Zero IP Address as valid to handle Global
	Address in Virtual Server */

BYTE is_an_ip_address_even_if_zero(BYTE* address)
{
	BYTE main_index = 0, i, number_of_dots = 0;
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	USHORT number_of_characters;

	/* Check For Number of Dots */
	for(i=0;i<strlen(address);++i)
	{
		if (address[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(address))
		return FALSE;


   /* The following function will remove unwanted zeros in the address */
/*   format_address(address);*/

	/* Check whether this address forms an ip address. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(address))
		{
			if (address[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters || number_of_characters > 3)
			return FALSE;
	}

	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));

	/* Each Byte Should be in the Range 1-254. Otherwise it is not an valid
	   IP address */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		if (ip_address_array[i] < LOWER_LIMIT_OF_BYTE_IN_IP_ADDRESS 
		    || ip_address_array[i] > UPPER_LIMIT_OF_BYTE_IN_IP_ADDRESS)
		{
			return FALSE;
		}
	}
	/* Now the passed address is an valid ip address hence return TRUE */
	return TRUE;
}

/*	Jo 08/04/99 Consider Zero IP Address as valid to handle Global
	Address in Virtual Server */

BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask)
{
	BYTE main_index = 0, i, number_of_characters, number_of_dots = 0;
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];

	/* Check whether ip address is valid or not. */
	if (!is_an_ip_address(address))
	{
		return FALSE;
	}

	/* Cheack For Number of Dots */
	for(i=0;i<strlen(mask);++i)
	{
		if (mask[i] == '.')
			number_of_dots ++;
	}
	if (number_of_dots != 3)
		return FALSE;

	if (!valid_characters_in(mask))
		return FALSE;

   format_address(mask);

	/* Check whether this address forms ip address mask. For this check whether 
	   all the four bytes are present and they are in dot form */
	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		number_of_characters = 0;
		while (main_index < strlen(mask))
		{
			if (mask[main_index++] == '.') 
				break;
			number_of_characters++;
		}
		if (!number_of_characters  || number_of_characters > 3)
		{
			return FALSE;
		}
	}

	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

	/* For a valid mask first 8 bit should be 1 */
	if (ip_mask_array[0] != 255)
	{
		return FALSE;
	}
	
	/* Check for the sequence of bits. First some bytes will be 1 afterwards
		it should be continues zeros. Once 0 bit starts 1 bit should not 
		come in between */

	if (!valid_bit_sequence(mask))
	{
		return FALSE;
	}

	/* check whether the ip address  and mask are compatible 
      if the first byte of ip address is in the range
       193 - 254 mask should be wider then or equal to 255.255.255.0
       128 - 192 mask should be wider then or equal to 255.255.0.0
       1   - 127 mask should be wider then or equal to 255.0.0.0
   */
	if (!mask_compatible_with_ip_address(address, mask))
   {
      return FALSE;
   }

	/* Now the passed mask is valid for ip address hence return TRUE */
	return TRUE;
}
/* Imran, 10.3.99 */



BYTE valid_bit_sequence(BYTE* mask)
{
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   BYTE local_byte, local_mask, zero_bit_found = FALSE, i, j;

	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

	for(i=0; i<NUMBER_OF_BYTES_IN_IP_ADDRESS; ++i)
	{
		local_byte = (BYTE)ip_mask_array[i];
      local_mask = 0x80;
      for(j=0; j<NUMBER_OF_BITS_IN_A_BYTE; ++j)
      {
         if (local_byte & local_mask)
         {
            if (zero_bit_found)
               return FALSE;
         }
         else
            zero_bit_found = TRUE;
         local_mask >>= 1;
      }
	}
}

BYTE mask_compatible_with_ip_address(BYTE* address, BYTE* mask)
{
	ULONG ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG ip_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   ULONG local_mask, actual_mask;
   BYTE* temp_ptr;
	/* Read each of the bytes into an array of ULONG */
	sscanf(address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_address_array[0]),(ULONG *)(&ip_address_array[1]),
		(ULONG *)(&ip_address_array[2]),(ULONG *)(&ip_address_array[3]));


	/* Read each of the bytes from mask into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&ip_mask_array[0]),(ULONG *)(&ip_mask_array[1]),
		(ULONG *)(&ip_mask_array[2]),(ULONG *)(&ip_mask_array[3]));

   temp_ptr = (BYTE*)&local_mask;
   *(temp_ptr) = 255;
   *(temp_ptr+3) = 0;
   if (ip_address_array[0] >= 193 && ip_address_array[0] <= 254)
   {
      *(temp_ptr+1) = *(temp_ptr+2) = 255;
   }
   else
   if(ip_address_array[0] >= 128 && ip_address_array[0] <= 192)
   {
      *(temp_ptr+1) = 255;
      *(temp_ptr+2) = 0;
   }
   else
   if(ip_address_array[0] >= 1 && ip_address_array[0] <= 127)
   {
      *(temp_ptr+1) = *(temp_ptr+2) = 0;
   }

   temp_ptr = (BYTE*)&actual_mask;
   *(temp_ptr+3) = ip_mask_array[3];
   *(temp_ptr+2) = ip_mask_array[2];
   *(temp_ptr+1) = ip_mask_array[1];
   *(temp_ptr)   = ip_mask_array[0];
  
   if (actual_mask < local_mask)   
      return FALSE;
   else
      return TRUE;
}


BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask)
{
	ULONG local_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG remote_ip_address_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
	ULONG local_mask_array[NUMBER_OF_BYTES_IN_IP_ADDRESS];
   ULONG local_ulong_ip, remote_ulong_ip, local_mask;
   BYTE* temp_ptr;


/*	printf("**********-> %s <-> %s <-> %s\n", local_ip_address, mask, remote_ip_address); */

#if 0
	if (!is_an_ip_address(local_ip_address))
	{
		printf("Invalid Local Ip Address while Validating Remote IP Address\n");
      return FALSE;
	}

   if (!is_an_ip_address_mask(local_ip_address, mask))
	{
		printf("Invalid mask for IP Address while Validating Remote IP Address\n");
      return FALSE;
	}
#endif

   if (!is_an_ip_address(remote_ip_address))
      return FALSE;
   if (!is_an_ip_address_mask(remote_ip_address, mask))
      return FALSE;
   
	/* Read each of the bytes into an array of ULONG */
	sscanf(remote_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&remote_ip_address_array[0]),(ULONG *)(&remote_ip_address_array[1]),
		(ULONG *)(&remote_ip_address_array[2]),(ULONG *)(&remote_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(local_ip_address, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_ip_address_array[0]),(ULONG *)(&local_ip_address_array[1]),
		(ULONG *)(&local_ip_address_array[2]),(ULONG *)(&local_ip_address_array[3]));

	/* Read each of the bytes into an array of ULONG */
	sscanf(mask, "%03u.%03u.%03u.%03u", 	
		(ULONG *)(&local_mask_array[0]),(ULONG *)(&local_mask_array[1]),
		(ULONG *)(&local_mask_array[2]),(ULONG *)(&local_mask_array[3]));

   temp_ptr = (BYTE*)&local_ulong_ip;
   *(temp_ptr+3) = local_ip_address_array[3];
   *(temp_ptr+2) = local_ip_address_array[2];
   *(temp_ptr+1) = local_ip_address_array[1];
   *(temp_ptr)   = local_ip_address_array[0];
  
   temp_ptr = (BYTE*)&remote_ulong_ip;
   *(temp_ptr+3) = remote_ip_address_array[3];
   *(temp_ptr+2) = remote_ip_address_array[2];
   *(temp_ptr+1) = remote_ip_address_array[1];
   *(temp_ptr)   = remote_ip_address_array[0];
  
   temp_ptr = (BYTE*)&local_mask;
   *(temp_ptr+3) = local_mask_array[3];
   *(temp_ptr+2) = local_mask_array[2];
   *(temp_ptr+1) = local_mask_array[1];
   *(temp_ptr)   = local_mask_array[0];
  
   if ((remote_ulong_ip & local_mask) != (local_ulong_ip & local_mask))
      return FALSE;
   return TRUE;
}

void format_address(BYTE* address)
{        
   BYTE temp_address[100];
   BYTE got_non_zero = FALSE, i, j = 0;

   strcpy(temp_address, address);
   for(i=0; i<strlen(temp_address); ++i)
   {
      if (temp_address[i] == '0' && !got_non_zero && i != (strlen(temp_address)-1))
         continue;
      got_non_zero = TRUE;
      address[j++] = temp_address[i];
      if (temp_address[i] == '.')
         got_non_zero = FALSE;
   }
   address[j] = 0;
}

BYTE is_valid_ipx_network_number(BYTE* string_ptr)
{
	BYTE i;

	for(i=0;i<strlen(string_ptr);++i)
	{
		if (string_ptr[i] < '0' || (string_ptr[i] > '9' && string_ptr[i] < 'A') || (string_ptr[i] > 'F' && string_ptr[i] < 'a') || string_ptr[i] > 'f')
		{
			return FALSE;
		}
	}
	return TRUE;
}

enum BOOLEAN convert_from_string_to_long (char *store_temp_value, ULONG *temp)
{
	int len, index;
	len = strlen (store_temp_value);
	if (len > 5)
		return FALSE;
	index = 0;

	#if (0)
		temp = 0;
	#else
		*temp = 0;
	#endif

	while (store_temp_value[index] != 0)
	{
		#if (0)
			if ((store_temp_value[index] > '0') && (store_temp_value[index] < '9'))
				*temp = (*temp * 10) + (store_temp_value[index++] - '0');
			else
				return FALSE;
		#endif

		if ((store_temp_value[index] >= '0') && (store_temp_value[index] <= '9'))
			*temp = (*temp * 10) + (store_temp_value[index++] - '0');
		else
			return FALSE;
	}
	return TRUE;
}

BYTE is_valid_string_to_read_data(BYTE* buffer)
{
	USHORT i, buffer_length;

	buffer_length = strlen(buffer);
	for(i=0; i<buffer_length; ++i)
	{
		if (buffer[i] >= '0' && buffer[i] <= '9')
			continue;
		return(FALSE);
	}
	return(TRUE);
}

#if 0	/* Jo 30/04/99 */
enum BOOLEAN check_valid_hex_sequence (char *value_to_check)
{
	while (*value_to_check)
	{
		if (((*value_to_check <= '9') && (*value_to_check >= '0')) ||
			((*value_to_check <= 'f') && (*value_to_check >= 'a')) ||
			((*value_to_check <= 'F') && (*value_to_check >= 'A')))
			value_to_check ++;
		else
			return FALSE;
	}				
	return TRUE;
}
#endif /* Jo 30/04/99 */

enum BOOLEAN check_valid_int_sequence (char *value_to_check)
{
	while (*value_to_check)
	{
		if ((*value_to_check > '9') || (*value_to_check < '0')) 
			return FALSE;
		else
			value_to_check ++;
	}				
	if (strlen (value_to_check) > 10)
		return FALSE;
	return TRUE;
}

enum BOOLEAN convert_data_format (	enum CM_DATA_FORMAT sent_data_format, 
												void *sent_data_ptr, 
												enum CM_DATA_FORMAT converted_data_format, 
												void *converted_value, 
												int *length)
{
	switch (sent_data_format)
	{
		case CM_STRING_FORMAT:
				if ((converted_data_format != CM_STRING_FORMAT) &&
					 (converted_data_format != CM_SPECIAL_FORMAT)) /* Imran, 10.3.99 */
				{
					if (!check_valid_int_sequence( (char *) sent_data_ptr))
						return (FALSE);
					if (!sscanf ((char *) sent_data_ptr, "%lu", (ULONG *) converted_value))
						return FALSE;
					return TRUE;
				}
				break;

		case CM_USHORT_FORMAT:
				if (converted_data_format != CM_STRING_FORMAT)
				{
//					if (!check_valid_int_sequence((char *) sent_data_ptr))
//						return (FALSE);
					*(ULONG *) converted_value = (ULONG)*(USHORT *) sent_data_ptr;
					return TRUE;
				}
				break;

		case CM_ULONG_FORMAT:
				if (converted_data_format != CM_STRING_FORMAT)
				{
//					if (!check_valid_int_sequence( (char *) sent_data_ptr))
//						return (FALSE);
					*(ULONG *) converted_value = (ULONG)*((ULONG *) sent_data_ptr);
					return TRUE;
				}
				break;

		case CM_BYTE_FORMAT:
				if (converted_data_format != CM_STRING_FORMAT)
				{
					*(ULONG *) converted_value = (ULONG)*((BYTE *) sent_data_ptr);
					return TRUE;
				}
				break;

		case CM_DOT_FORMAT:
				if (converted_data_format == CM_ULONG_FORMAT)
				{
					if (is_an_ip_address ((char *) sent_data_ptr))
						if (get_ulong_ip_address ((char *) sent_data_ptr, (ULONG *) converted_value))
							return TRUE;
				}
				return FALSE;
	}

	switch (converted_data_format)
	{
		case CM_STRING_FORMAT 	:	
			if (sent_data_format == CM_STRING_FORMAT)
			{
				memcpy (converted_value, sent_data_ptr, *length);
				* ((char *) (converted_value) + (*length)) = 0;
				*length = strlen (converted_value);
				*(BYTE *) converted_value = *(BYTE *) sent_data_ptr;
				return TRUE;
			}
			else
				return FALSE;


		case CM_BIT_FORMAT 		:	
			*(BYTE *) converted_value = *(BYTE *) sent_data_ptr;
			return TRUE;

		case CM_STRUCTURE_FORMAT:	
			if (sent_data_format != CM_STRUCTURE_FORMAT)
				return FALSE;
			memcpy (converted_value, sent_data_ptr, *length);
			return TRUE;
				
	}
	return TRUE;
}

// checks whether value is within min and max value
enum BOOLEAN check_whether_value_in_limit (ULONG *range_value, char *value_to_check)
{
	ULONG check_value;

	check_value = *(ULONG *) value_to_check;
	if ((check_value < range_value[1]) || (check_value > range_value[2]))
	{
		printf ("\n\rVERROR :value sent is %lu, should have been between %lu and %lu\n",
						check_value, range_value[1], range_value[2]);
		return FALSE;
	}
	return TRUE;
}

#if 0
// first value will contain count of settable values
enum BOOLEAN check_only_for_a_set_of_values (ULONG *range_value, char *value_to_check)
{
	int i;
	ULONG check_value;

	check_value = * (ULONG *) value_to_check;
	for (i = 1; i <= range_value[0]; i ++)
		if (check_value == range_value[i])
			return TRUE;

	printf ("\n\rValue Not Within Specified Range\n");
	return FALSE;
}

enum BOOLEAN check_for_string_length (ULONG *range_value, char *value_to_check)
{
	if ((strlen (value_to_check) < range_value[0]) && range_value[1])
	{
	 	printf ("\n\rINVALID Data is %s min length should be %lu port number %lu\n", 
						value_to_check, range_value[0], range_value[10]);
		return FALSE;
	}
	return TRUE;
}
#endif

enum BOOLEAN validate_ip_dns_ip_address(ULONG *range_value, char *value_to_check)
{
	ULONG check_value, check_with_value;
	CNF_IP_HEADER *ptr_to_ip;

	check_value = *(ULONG *) value_to_check;
	ptr_to_ip = (CNF_IP_HEADER *) write_permitted_structures[CM_IP_SECTION].ptr_to_struct;
	if(range_value[11] == 1)
		check_with_value = ptr_to_ip->secondary_address;
	else
		check_with_value = ptr_to_ip->primary_address;
	if(check_value == check_with_value)
		return FALSE;
	return TRUE;
}	

enum BOOLEAN validate_ip_gateway_address(ULONG *range_value, char *value_to_check)
{
	CNF_IP 	*ptr_to_ip;
	ULONG check_value;

	check_value = *(ULONG *) value_to_check;
	ptr_to_ip = (CNF_IP *) write_permitted_structures[CM_IP_SECTION].ptr_to_struct;
	if(check_value == ptr_to_ip->ip_ports[0].ip_address)
		return FALSE;
	return TRUE;			
}

#ifdef _BIG_PROXY_
// check  whether there are any interdependent parameters bcos of which 
// this parameter cannot be set to the specified value
enum BOOLEAN validate_ip_enable (ULONG *range_value, char *value_to_check)
{
	ULONG check_value;
	CNF_PPP *ptr_to_ppp;

	check_value = *(ULONG *) value_to_check;
	ptr_to_ppp = (CNF_PPP *) write_permitted_structures[CM_PPP_SECTION].ptr_to_struct;

	if (!check_value)
		if (ptr_to_ppp->ppp_ports[0].slip_options.enabled)
			return FALSE;

	return TRUE;
}
#endif

#if 0 /* Jo 31/08/99 No more Default Gateway. So the function doesn't make any sense anymore */
enum BOOLEAN validate_ip_port_address (ULONG *range_value, char *value_to_check)
{
	USHORT port_no;
	CNF_IP *ptr_to_ip;
	ULONG check_value;

	port_no = range_value[10];	// will contain the port number
	if (port_no > 0)	
		return TRUE;
	
	check_value = *(ULONG *) value_to_check;
	ptr_to_ip = (CNF_IP *) write_permitted_structures[CM_IP_SECTION].ptr_to_struct;
/*	if(check_value == ptr_to_ip->ip_header.default_gateway)
		return FALSE;*/
	
	return TRUE;
}
#endif

/* Jo 14/07/99 Added for RAS */
void set_client_only_interdep (USHORT port_no)
{
	CNF_PPP *ppp_ptr ;
	CNF_WAN *wan_ptr ;
	CNF_PROXY_PORT *proxy_port_ptr ;
	ULONG offset ;

	ppp_ptr = (CNF_PPP *) write_permitted_structures[CM_PPP_SECTION].ptr_to_struct ;
	wan_ptr = (CNF_WAN *) write_permitted_structures[CM_WAN_SECTION].ptr_to_struct ;
	offset = (ULONG) write_permitted_structures[CM_PROXY_SECTION].ptr_to_struct ;
	calculate_offset_of_proxy_port (&offset, port_no+1) ;
	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;
	if (wan_ptr->wan_ports[port_no].auto_answer == 1)
	 	proxy_port_ptr->enabled = 0 ;
	else
	 	proxy_port_ptr->enabled = 1 ;
	
}

void set_ppp_strings (ULONG parameter_id, USHORT port_number, BYTE valid) 
{
	CNF_PPP *ppp_ptr ;
	CNF_IP *ip_ptr ;
   char temp_dot_value[20] ; 
	int i ;

	ip_ptr = (CNF_IP *) write_permitted_structures[CM_IP_SECTION].ptr_to_struct ;
	ppp_ptr = (CNF_PPP *) write_permitted_structures[CM_PPP_SECTION].ptr_to_struct ;
	switch (parameter_id)
	{
		case PPP_PORT_REMOTE_OPTION_LCP_AUTHENTICATION : 
   
				if (ppp_ptr->ppp_ports[port_number].authentication_type == 0)
				{
					ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.Negotiable = 0 ;
	   		   ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.value_type = H2 ;
			      strcpy ((char *)ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.option_value, "c023") ;
				}
				else if (ppp_ptr->ppp_ports[port_number].authentication_type == 1)
				{
					ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.Negotiable = 0 ;
				   ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.value_type = H3 ;
				   strcpy ((char *)ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.option_value, "c22305") ;
				}
				else
				{
				   ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.Negotiable = 1 ;
				   ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.value_type = H2 ;
				   strcpy ((char *)ppp_ptr->ppp_ports[port_number].remote_lcp_authentication.option_value, "c023") ;
				}
				break ;	

		case PPP_PORT_OPTION_LCP_EPD : 
				for (i = 0; i < CM_ALL_PORTS; i++)
				{
					ppp_ptr->ppp_ports[i].remote_lcp_epd.valid = valid ;
					ppp_ptr->ppp_ports[i].lcp_mrru.valid = valid ;
					ppp_ptr->ppp_ports[i].remote_lcp_mrru.valid = valid ;
				}
				break ;

		case PPP_PORT_REMOTE_OPTION_LCP_CALLBACK : 
				ppp_ptr->ppp_ports[port_number].remote_lcp_callback.valid = !valid ;
				break ;
		
		case PPP_PORT_IPCP_DNS_ADDRESS1 : 
				if (ip_ptr->ip_header.primary_address != 0)
				for (i = 0; i < CM_ALL_PORTS; i++)
				{
			    	ppp_ptr->ppp_ports[i].ipcp_dns_address1.valid = 0 ;
		    		ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
    				ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.valid = 1 ;
					get_dot_decimal_ip_address (ip_ptr->ip_header.primary_address, temp_dot_value) ;
					strcpy ((char *)ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.option_value, temp_dot_value) ;
				}
				else
				{
					for (i = 0; i < CM_ALL_PORTS; i++)
					{
			    		ppp_ptr->ppp_ports[i].ipcp_dns_address1.Negotiable = 1 ;
    					ppp_ptr->ppp_ports[i].ipcp_dns_address1.valid = 1 ;
						strcpy ((char *)ppp_ptr->ppp_ports[i].ipcp_dns_address1.option_value, "0.0.0.0") ;

    					ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
			    		ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.valid = 1 ;
						strcpy ((char *)ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.option_value, "0.0.0.0") ;
					}
				}
				break ;

		case PPP_PORT_IPCP_DNS_ADDRESS2 : 
				if (ip_ptr->ip_header.secondary_address != 0)
				for (i = 0; i < CM_ALL_PORTS; i++)
				{
			    	ppp_ptr->ppp_ports[i].ipcp_dns_address2.valid = 0 ;
		    		ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
    				ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.valid = 1 ;
					get_dot_decimal_ip_address (ip_ptr->ip_header.secondary_address, temp_dot_value) ;
					strcpy ((char *)ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.option_value, temp_dot_value) ;
				}
				else
				{
					for (i = 0; i < CM_ALL_PORTS; i++)
					{
			    		ppp_ptr->ppp_ports[i].ipcp_dns_address2.Negotiable = 1 ;
    					ppp_ptr->ppp_ports[i].ipcp_dns_address2.valid = 1 ;
						strcpy ((char *)ppp_ptr->ppp_ports[i].ipcp_dns_address2.option_value, "0.0.0.0") ;

    					ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
			    		ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.valid = 1 ;
						strcpy ((char *)ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.option_value, "0.0.0.0") ;
					}
				}
				break ;

		case PPP_PORT_OPTION_IPCP_IP_ADDRESS : 			
				if (ip_ptr->ip_ports[port_number].ip_address == 0)  
				{
					ip_ptr->ip_ports[port_number].isp_assigns_address = 1 ;
    				ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.Negotiable = 1 ;
	    			ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.valid = 1 ;
   	         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.option_value, "0.0.0.0") ;
				}	
				else
				{
					ip_ptr->ip_ports[port_number].isp_assigns_address = 0 ;
    				ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.Negotiable = 0 ;
	    			ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.valid = 1 ;
					get_dot_decimal_ip_address (ip_ptr->ip_ports[port_number].ip_address, temp_dot_value) ;
   	         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ipcp_ip_address.option_value, temp_dot_value) ;
				}					 
				break ;
				
		case PPP_PORT_REMOTE_OPTION_IPCP_IP_ADDRESS : 
				
				if (ppp_ptr->ppp_ports[port_number-1].remote_port_client_only)
				{
					if (ip_ptr->ip_ports[port_number].remote_ip_address == 0)
					{
    					ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.Negotiable = 1 ;
    					ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.valid = 1 ;
	   	         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.option_value, "0.0.0.0") ;

			    		ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.Negotiable = 1 ;
   	 				ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.valid = 1 ;
						get_dot_decimal_ip_address (ip_ptr->ip_ports[0].ip_address, temp_dot_value) ;
			         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.option_value, temp_dot_value) ;

			    		ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
	    				ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.valid = 1 ;
			         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.option_value, "0.0.0.0") ;
					}
					else
					{
			    		ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.Negotiable = 1 ;
   	 				ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.valid = 1 ;
						get_dot_decimal_ip_address (ip_ptr->ip_ports[0].ip_address, temp_dot_value) ;
			         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.option_value, temp_dot_value) ;

			    		ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
   	 				ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.valid = 1 ;
						get_dot_decimal_ip_address (ip_ptr->ip_ports[port_number].remote_ip_address, temp_dot_value) ;
			         strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.option_value, temp_dot_value) ;
					}
				} 
				else
				{
	  				ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.Negotiable = 1 ;
   	 			ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.valid = 1 ;
  	   	      strcpy ((char *)ppp_ptr->ppp_ports[port_number-1].remote_ipcp_ip_address.option_value, "0.0.0.0") ;

  					ppp_ptr->ppp_ports[port_number-1].ras_ipcp_ip_address.valid = 0 ;
	  				ppp_ptr->ppp_ports[port_number-1].ras_remote_ipcp_ip_address.valid = 0 ;
				}
				break ;			
	}
}

enum BOOLEAN set_mlppp_dependencies (enum BOOLEAN flag)
{
	CNF_PPP *ppp_ptr ;
	CNF_WAN *wan_ptr ;
	int i ;

	ppp_ptr = (CNF_PPP *) write_permitted_structures[CM_PPP_SECTION].ptr_to_struct ;
	if (!flag)
		if (ppp_ptr->ppp_ports[0].lcp_epd.valid)
			return TRUE ;
		else
			return FALSE ;

	wan_ptr = (CNF_WAN *) write_permitted_structures[CM_WAN_SECTION].ptr_to_struct ;

	if (ppp_ptr->ppp_ports[0].lcp_epd.valid)
	{
		for (i = 0; i < CM_ALL_PORTS; i++)
		{
			ppp_ptr->ppp_ports[i].remote_port_client_only = 0 ;
			wan_ptr->wan_ports[i].auto_answer = 0 ;
		}
	}
}	
/* Jo 14/07/99 Added for RAS */
