/***************************************************************************
	Author    - 	Md.Imran Naveed
	Date	    - 	19 Sep '98
	Synopsis  -    Contains dhcp support routines
***************************************************************************/
#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <memory.h>
#include "cnffile.h"
#include <cfgmgr.h>
#include "fncdefs.h"
#include "incall.h"

extern void *memmove (void *s1, const void *s2, size_t n);
extern void get_hex_format_for_ip_address(DHCP_OPTION_ENTRY* sptr_option, BYTE* converted_string);

int calculate_offset_of_dhcp_address_range_entries (ULONG *offset, int index) 
{
    CNF_DHCP_HEADER *temp_dhcp_header_ptr ;
    CNF_DHCP_ADDRESS_RANGE *temp_dhcp_address_range_ptr ;
	 int i;

    temp_dhcp_header_ptr = (CNF_DHCP_HEADER *) *offset ;
    temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) ((char*) temp_dhcp_header_ptr + sizeof(CNF_DHCP_HEADER)) ;
    *offset = (ULONG) temp_dhcp_address_range_ptr ;

    for (i = 0; i < index; i++)
    {
    	temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) *offset ;
		*offset+= (sizeof(CNF_DHCP_ADDRESS_RANGE) + ((temp_dhcp_address_range_ptr->number_of_bindings_entries - 1) * sizeof(CNF_BINDING_INFO))) ;
    }
    return TRUE ;
}

int calculate_offset_of_dhcp_binding_entries (ULONG *offset, ULONG *return_offset) 
{
    USHORT offset_to_binding_entries ;
    CNF_DHCP_ADDRESS_RANGE *temp_dhcp_address_range_ptr ;

    temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) *offset ;
    offset_to_binding_entries = (sizeof(CNF_DHCP_ADDRESS_RANGE) - sizeof(CNF_OPTIONS_INFO) - sizeof(CNF_BINDING_INFO)) ;
    *return_offset = ((ULONG)temp_dhcp_address_range_ptr + sizeof(CNF_OPTIONS_INFO) 
		     + offset_to_binding_entries) ; 
    return TRUE ;
}

void cm_clean_up_existing_dhcp_configuration()
{
	USHORT no_of_tags,no_of_binds;
	ULONG offset,SizetoRealloc,dst_offset,SizetoMove;	
	CNF_DHCP_HEADER *dhcp_header_ptr;
	CNF_DHCP_ADDRESS_RANGE *dhcp_addr_range_ptr;

	dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
	no_of_tags = dhcp_header_ptr->number_of_address_range_entries;
	while(no_of_tags--)
	{
		offset = (ULONG) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
		calculate_offset_of_dhcp_address_range_entries(&offset,0);
		dhcp_addr_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset;
		no_of_binds = dhcp_addr_range_ptr->number_of_bindings_entries;

		dst_offset = offset;
		offset += sizeof(CNF_DHCP_ADDRESS_RANGE) + ((no_of_binds - 1) * sizeof(CNF_BINDING_INFO));
		SizetoMove = (ULONG) (write_permitted_structures[CM_DHCP_ID].ptr_to_struct + dhcp_header_ptr->section_length) - offset;
		memmove( (void *)dst_offset, (void *) offset , SizetoMove);
		
		SizetoRealloc = (ULONG) (dhcp_header_ptr->section_length - (sizeof(CNF_DHCP_ADDRESS_RANGE) +
							 	(no_of_binds - 1) * sizeof(CNF_BINDING_INFO)));
		write_permitted_structures[CM_DHCP_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_DHCP_ID].ptr_to_struct,
							dhcp_header_ptr->section_length, SizetoRealloc);
		write_permitted_structures[CM_DHCP_ID].size_of_struct = (USHORT) SizetoRealloc ;

	 	dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
		dhcp_header_ptr->section_length = SizetoRealloc;
	}
	dhcp_header_ptr->number_of_address_range_entries = 0;
}	

BYTE cm_form_dhcp_range_structure(USHORT tag_number)
{
	BYTE *option_in_string_format;
	ULONG offset,SizetoRealloc, ulong_ip_address;
  	CNF_DHCP_HEADER *dhcp_header_ptr;
	CNF_DHCP_ADDRESS_RANGE *dhcp_addr_range_ptr;
	CNF_OPTIONS_INFO *dhcp_option_ptr;
	DHCP_EXCLUSION_ENTRY* sptr_exclusion;
	DHCP_OPTION_ENTRY* sptr_option;

	dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;

	SizetoRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_DHCP_ADDRESS_RANGE) - sizeof(CNF_BINDING_INFO)));
	write_permitted_structures[CM_DHCP_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_DHCP_ID].ptr_to_struct,
						dhcp_header_ptr->section_length, SizetoRealloc);
	write_permitted_structures[CM_DHCP_ID].size_of_struct = (USHORT) SizetoRealloc ;

 	dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
	dhcp_header_ptr->section_length = SizetoRealloc;
	dhcp_header_ptr->number_of_address_range_entries++;
	
	offset = (ULONG) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
	calculate_offset_of_dhcp_address_range_entries(&offset, tag_number);
	dhcp_addr_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset;
	dhcp_addr_range_ptr->lower_ip_address = cfgmgr_class.sptr_tag_list[tag_number].lower_ip_address;
	dhcp_addr_range_ptr->higher_ip_address = cfgmgr_class.sptr_tag_list[tag_number].higher_ip_address;
	dhcp_addr_range_ptr->address_mask = cfgmgr_class.sptr_tag_list[tag_number].subnet_mask;
	dhcp_addr_range_ptr->number_of_bindings_entries = 0;

	sptr_exclusion = cfgmgr_class.sptr_tag_list[tag_number].sptr_exclusion_list;
	if(sptr_exclusion)
	{
		dhcp_addr_range_ptr->exclude_lower_ip_address = sptr_exclusion->lower_ip_address;
		dhcp_addr_range_ptr->exclude_higher_ip_address = sptr_exclusion->higher_ip_address;
	}
	else
	{
		dhcp_addr_range_ptr->exclude_lower_ip_address = 0;
		dhcp_addr_range_ptr->exclude_higher_ip_address = 0;
	}
	dhcp_option_ptr = (CNF_OPTIONS_INFO *) ((ULONG) dhcp_addr_range_ptr + (sizeof(ULONG) * 5)
												+ sizeof(USHORT));
	sptr_option = cfgmgr_class.sptr_tag_list[tag_number].sptr_option_list;

	while(sptr_option)
	{
		switch(sptr_option->option_type)
      {
         case 3:
				get_hex_format_for_ip_address(sptr_option, option_in_string_format);	
				get_ulong_ip_address(option_in_string_format, &ulong_ip_address);
				dhcp_option_ptr->router_address = ulong_ip_address;
				break;

         case 15:
				strcpy(dhcp_option_ptr->domain_name,sptr_option->option_data.byte_array);
				break;

         case 22:
				dhcp_option_ptr->reassembly_size = sptr_option->option_data._ushort;
				break;

         case 26:
				dhcp_option_ptr->mtu = sptr_option->option_data._ushort;				
            break;

         case 23:
				dhcp_option_ptr->default_ip_ttl = sptr_option->option_data._byte;				
				break;	

         case 37:
				dhcp_option_ptr->default_tcp_ttl = sptr_option->option_data._byte;				
				break;						 

         case 51:
				dhcp_option_ptr->lease_time = sptr_option->option_data._ulong;				
            break;
      };
		sptr_option = sptr_option->sptr_next_option_entry;
	}
}

BYTE cm_form_dhcp_bindings_structure(USHORT tag_number)
{
	DHCP_STATIC_BINDING_ENTRY* sptr_bind;
	CNF_DHCP_HEADER *dhcp_header_ptr;
	CNF_BINDING_INFO *dhcp_bind_ptr;
	CNF_DHCP_ADDRESS_RANGE *dhcp_addr_range_ptr;
	ULONG offset,SizetoRealloc,return_offset;
	int index;
	BYTE temp_string[4];

	sptr_bind = cfgmgr_class.sptr_tag_list[tag_number].sptr_binding_list;
	while(sptr_bind)
	{
 		dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
		SizetoRealloc = (dhcp_header_ptr->section_length + sizeof(CNF_BINDING_INFO));
		write_permitted_structures[CM_DHCP_ID].ptr_to_struct = (char *) my_realloc(write_permitted_structures[CM_DHCP_ID].ptr_to_struct,
							dhcp_header_ptr->section_length, SizetoRealloc);
		write_permitted_structures[CM_DHCP_ID].size_of_struct = (USHORT) SizetoRealloc ;

		dhcp_header_ptr = (CNF_DHCP_HEADER *) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
		dhcp_header_ptr->section_length = SizetoRealloc;

		offset = (ULONG) write_permitted_structures[CM_DHCP_ID].ptr_to_struct;
		calculate_offset_of_dhcp_address_range_entries(&offset, tag_number);
		dhcp_addr_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset;

		calculate_offset_of_dhcp_binding_entries(&offset ,&return_offset);
		return_offset += (sizeof(CNF_BINDING_INFO) * dhcp_addr_range_ptr->number_of_bindings_entries);
		dhcp_bind_ptr = (CNF_BINDING_INFO *) return_offset;

		dhcp_bind_ptr->ip_address = sptr_bind->ip_address;
		dhcp_bind_ptr->mac_address_length = sptr_bind->mac_address_length;
#if 0
		memmove((void *) dhcp_bind_ptr->mac_address ,(void *) sptr_bind->mac_address, (int) sptr_bind->mac_address_length);
#else
		dhcp_bind_ptr->mac_address[0] = 0;
		for(index = 0; index < sptr_bind->mac_address_length ; index++)
		{
			sprintf(temp_string,"%02X",sptr_bind->mac_address[index]);
			strcat(dhcp_bind_ptr->mac_address, temp_string);
		}
#endif
		dhcp_addr_range_ptr->number_of_bindings_entries++;

		sptr_bind = sptr_bind->sptr_next_entry;
	}
	return(TRUE);
}


