#include <stdio.h>
#define ULONG unsigned long

/*
some of the IP network support routines 
project : multirouter
author : vidyasagaran
date	: 3rd June 1997
modified by oss on 10-6-97 
*/


int get_ulong_ip_address(char *dot_decimal_ip_address, ULONG *int_ip_address)
{
	ULONG addr1, addr2, addr3, addr4;
	char *ch;
	int dot_count;
	int char_flag;

	addr1 = addr2 = addr3 = addr4 = 0l;
	dot_count = 0;
	char_flag = 0;

	*int_ip_address = 0;
	ch = dot_decimal_ip_address;
	while (*ch)
	{
		if (*ch == '.')
		{
			if(char_flag!=1)
			{
				dot_count ++;
				char_flag = 1;
			}
			else
				return 0;

		}
		else
			char_flag = 0;
		ch ++;
	}
	if (dot_count < 3)
		return 0;

	sscanf (dot_decimal_ip_address, "%u.%u.%u.%u", &addr1, &addr2, &addr3, &addr4);
	if ((addr1 > 255) || (addr2 > 255) || (addr3 > 255) || (addr4 > 255))
		return 0;
	*int_ip_address = (addr1 << 24) + (addr2 << 16) + (addr3 << 8) + addr4;
	return 1;
}

int get_dot_decimal_ip_address (ULONG int_ip_address, char *dot_decimal_ip_address)
{
	unsigned short addr1, addr2, addr3, addr4;

	addr4 = int_ip_address & 0xFF;
	addr3 = (int_ip_address & 0xFF00) >> 8;
	addr2 = (int_ip_address & 0xFF0000) >> 16;
	addr1 = (int_ip_address & 0xFF000000) >> 24;

	if (int_ip_address)
		return sprintf (dot_decimal_ip_address, "%u.%u.%u.%u", addr1, addr2, addr3, addr4);
/*	 else
	 	return sprintf (dot_decimal_ip_address, "0.0.0.0");  */

	*dot_decimal_ip_address = 0;
	return 1; 
}

/* Jo 08/04/99	To handle Zero IP Address for Global address in Virtual server */

int get_dot_decimal_ip_address_even_if_zero (ULONG int_ip_address, char *dot_decimal_ip_address)
{
	unsigned short addr1, addr2, addr3, addr4;

	addr4 = int_ip_address & 0xFF;
	addr3 = (int_ip_address & 0xFF00) >> 8;
	addr2 = (int_ip_address & 0xFF0000) >> 16;
	addr1 = (int_ip_address & 0xFF000000) >> 24;

	if (int_ip_address)
		return sprintf (dot_decimal_ip_address, "%u.%u.%u.%u", addr1, addr2, addr3, addr4);
	 else
	 	return sprintf (dot_decimal_ip_address, "0.0.0.0");  

	return 1; 
}

/* Returns 0 if subnet mask is invalid and 1 if mask is valid */
enum BOOLEAN verify_ip_subnet_mask (ULONG *range_value, char *value_to_check)
/* int verify_ip_subnet_mask (ULONG subnet_mask) */
{
	ULONG subnet_mask, check_bit_position, high_bits_turned_off_value;

#if 0
	if (!get_ulong_ip_address(dot_decimal, &subnet_mask))
		return 0;
#endif

	subnet_mask = *(ULONG *) value_to_check;

	if ((subnet_mask == 0) || (subnet_mask == 0xFFFFFFFF))
		return 0;

	check_bit_position = 0x80000000l;
	high_bits_turned_off_value = subnet_mask; /* init it to the subnet mask first */

	while (check_bit_position) 
	{
		high_bits_turned_off_value &= ~check_bit_position; /* turn this bit off */
		if ((subnet_mask & check_bit_position) == 0)
			return (!high_bits_turned_off_value);
	  check_bit_position >>= 1;
	}
	return 0;
}

#if 0  /* Imran */
ULONG get_next_ip_address(ULONG ip_address, ULONG subnet_mask)
{
	ULONG ValueToAdd, new_ip_address;

	ValueToAdd = 0x00000001l;
	while ((ValueToAdd & subnet_mask) == 0)
		ValueToAdd <<= 1;
	new_ip_address = ip_address + ValueToAdd;
	return new_ip_address;
}

int verify_ip_address (char *dot_decimal_ip_addr, char *ip_mask)
{
	ULONG subnet_mask, ip_address;

	get_ulong_ip_address (dot_decimal_ip_addr, &ip_address);
	get_ulong_ip_address (ip_mask, &subnet_mask);

	if ((subnet_mask == 0) || (subnet_mask == 0xFFFFFFFF) || 
		(ip_address == 0)  || (ip_address == 0xFFFFFFFF))
		return 0;

	if (((ip_address & subnet_mask) == 0x00000000) ||			
		((ip_address & subnet_mask) == subnet_mask) ||
		((ip_address & (~subnet_mask)) == 0x00000000) || 
		((ip_address & (~subnet_mask)) == ~subnet_mask))
		return 0;
	return 1;
}

int verify_ulong_ip_address (ULONG ip_address, ULONG subnet_mask)
{
	if ((subnet_mask == 0) || (subnet_mask == 0xFFFFFFFF) || 
		(ip_address == 0)  || (ip_address == 0xFFFFFFFF))
		return 0;

	if (((ip_address & subnet_mask) == 0x00000000) ||			
		((ip_address & subnet_mask) == subnet_mask) ||
		((ip_address & (~subnet_mask)) == 0x00000000) || 
		((ip_address & (~subnet_mask)) == ~subnet_mask))
		return 0;

	return 1;
}
#endif /* #if 0 */
