/* ------------------------------------------------------------------------
 FILENAME : fncdefs.h
 Author 	: O.S.Sridhar
 Date		: 28-7-97
--------------------------------------------------------------------------*/

typedef struct DEFINE_ALL_STRUCTURES
{
	USHORT	magic_number;			/* stores the magic number of the section */
	char 	*ptr_to_struct;
	USHORT 	size_of_struct;		/* stores length of that section */
}ALL_STRUCTURES;

typedef struct PTR_TO_FUNCTION
{
	 enum CM_DATA_FORMAT (*get_field_info) (ULONG parameter_id, 
 											USHORT port_no,
	 										ULONG *exact_offset,
	 										ULONG *valid_range,
	 										void  (**ptr_to_interdependency_function) (void *data_ptr, USHORT port_no, int index),
	 										enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

} PTR_TO_FUNCTION;

typedef struct SPECIAL_FORMAT_STRUCT
{
	 ULONG parameter_id;
	 enum CM_DATA_FORMAT (*read_processing_fn) 	(ULONG connection_id, ULONG parameter_id,  USHORT port_no, ULONG *value_got);
	 enum CM_DATA_FORMAT (*write_processing_fn) 	(ULONG parameter_id,  USHORT port_no, int filter_index, void *value_to_set); /* Imran, 10.3.99 */
/*	 void (*write_processing_fn) 	(ULONG parameter_id,  USHORT port_no, int filter_index, char *value_to_set); */

} SPECIAL_FORMAT;

typedef struct ADD_PARA_STRUCT
{
	 ULONG parameter_id;
	 int (*add_parameters_to_section) (ULONG parameter_id, USHORT port_no, void *struct_to_write);
} ADD_PARAMETERS;

typedef struct DELETE_PARAMETERS_STRUCT
{
	 ULONG parameter_id;
	 int (*delete_parameters_from_section) (ULONG parameter_id, USHORT port_no, int index_to_delete);
} DELETE_PARAMETERS;

/* Imran 4/9/98 */
typedef struct STRUCT_GET_OFFSET_PARAMETERS
{
	 ULONG parameter_id;
	 int (*get_offset_to_section) (ULONG *offset);
} GET_OFFSET_PARAMETERS;
/* Imran 4/9/98 */


/* Define functions of each section used to get field info */

#ifdef _BIG_PROXY_
extern enum CM_DATA_FORMAT get_lsl_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_socket_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

#endif


extern enum CM_DATA_FORMAT get_wan_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_ppp_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

/* Imran 19/8/98 */
extern enum CM_DATA_FORMAT get_proxy_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

#ifdef _BIG_PROXY_
extern enum CM_DATA_FORMAT get_ccp_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));
#endif


extern enum CM_DATA_FORMAT get_ip_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

#if 0
extern enum CM_DATA_FORMAT get_ipx_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_stp_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_spx_field_info (	ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));
#endif

#ifdef _BIG_PROXY_
extern enum CM_DATA_FORMAT get_cipx_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_vjc_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_snmp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_tcp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_telnet_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_tftp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));
#endif

extern enum CM_DATA_FORMAT get_dhcp_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

#ifdef _BIG_PROXY
extern enum CM_DATA_FORMAT get_web_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));
#endif

#if 0
extern enum CM_DATA_FORMAT get_ag_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));

extern enum CM_DATA_FORMAT get_script_field_info (ULONG parameter_id, 
					USHORT port_no,
					ULONG *exact_offset,
					ULONG *valid_range,
					void  (**ptr_to_interdependency_function)(void *data_ptr, USHORT port_no, int index),
					enum BOOLEAN (**ptr_to_validation_function)(ULONG *, char *));
extern enum BOOLEAN check_valid_hex_sequence (char *value_to_check);
#endif

/* External Function Declarations */
extern int get_the_section_number (enum CM_SECTIONS section_id); /* defined in cfgmgr.c */
extern void *my_realloc (void *ptr_to_old_block, int old_block_length, int new_block_length);

extern enum BOOLEAN convert_from_string_to_long (char *store_temp_value, ULONG *temp);
extern enum BOOLEAN convert_data_format (	enum CM_DATA_FORMAT data_format, 
												void *data_ptr, 
												enum CM_DATA_FORMAT actual_data_type, 
												void *actual_value,
												int *length);

extern int get_dot_decimal_ip_address (ULONG ip_address, char *dot_ip_address);
extern int get_ulong_ip_address (char *string_ip_address, ULONG *ip_address);

extern int verify_ulong_ip_address (ULONG ip_address, ULONG subnet_mask);

/* External Functions */
extern void add_entry_to_list (LINK *sptr_link, LINK *sptr_link_to_add);
extern void *get_entry_from_list (LINK *sptr_link);
extern void delete_entry_from_list (LINK *sptr_list_link, LINK *sptr_link_to_delete);
extern void reset();
extern USHORT update_crc (USHORT, BYTE *, ULONG) ;
extern int schedule_flash_write (char *src_ptr, char *dest_ptr, unsigned short block_length,void (*fptr_block_write_complete)(), char *buffer_to_free) ;

/* External Variables */
extern LINK ptr_user_list;
extern ALL_STRUCTURES write_permitted_structures[];
extern ALL_STRUCTURES read_only_structures[];

/* Functions of cminit.c */
extern void initialize_cm_structures (ALL_STRUCTURES *ptr_to_all_struct, int Flag);
extern int cm_flash_write_block(BYTE *, BYTE *, int, enum BOOLEAN) ;
extern void cm_start_flash_write ();
extern void cm_last_setup_block_written();
extern int cm_flash_write_block(BYTE *bptr_src, BYTE *bptr_dest, int length, enum BOOLEAN last_block);
extern void cm_wait_for_flash_write_completion ();


extern enum CM_DATA_FORMAT  get_pap_chap_enabled (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);

extern enum CM_DATA_FORMAT  get_no_of_ip_port_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);
extern enum CM_DATA_FORMAT  get_no_of_ip_address_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);
extern enum CM_DATA_FORMAT  get_ip_port_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);
/* extern enum CM_DATA_FORMAT  get_ip_address_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got); */ 

extern int get_actual_ip_port_filter_type (ULONG offset, int filter_index);
extern int get_actual_ip_address_filter_type (ULONG offset, int filter_index);
#if 0
extern int get_actual_ipx_filter_type (ULONG offset, int filter_index);
extern int get_actual_stp_filter_type (ULONG offset, int filter_index);

extern enum CM_DATA_FORMAT  get_no_of_ipx_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);
extern enum CM_DATA_FORMAT  get_ipx_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);

extern enum CM_DATA_FORMAT  get_no_of_stp_filters (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);
extern enum CM_DATA_FORMAT  get_stp_filter_type (ULONG connection_id, ULONG parameter_id, USHORT port_no, ULONG *value_got);

#endif

extern enum CM_DATA_FORMAT set_pap_chap_enabled (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set);
extern enum CM_DATA_FORMAT encrypt_password_string (void *data_ptr, USHORT port_no);
extern enum CM_DATA_FORMAT encrypt_server_password_string (void *data_ptr, USHORT port_no);

extern enum CM_DATA_FORMAT change_ip_port_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set);
extern enum CM_DATA_FORMAT change_ip_address_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set);
#if 0
extern enum CM_DATA_FORMAT change_ipx_filter_type (ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set);
extern enum CM_DATA_FORMAT change_stp_filter_type(ULONG parameter_id, USHORT port_no, int filter_index, char *value_to_set);
#endif

extern enum ACCESS_PERMISSIONS get_access_permission (ULONG connection_id);

/* These are for add function call */
#if 0
extern int add_ip_port	(ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write); */
#endif

extern int add_restricted_application_filters (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_proxy_address_filter (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

extern int add_proxy_application (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_proxy_user_defined_application (ULONG parameter_id, USHORT port_no, void *struct_to_write);
extern int add_proxy_address_entries (ULONG parameter_id, USHORT port_no, void *struct_to_write);

extern int add_global_address_entries (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_proxy_static_mapping (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_proxy_dynamic_mapping (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

#if 0
extern int add_ipx_port	(ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_stp_port	(ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

extern int add_static_route (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);
extern int add_ip_filter	(ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

extern int add_ipx_address_filter (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

extern int add_stp_address_filter (ULONG parameter_id, USHORT port_no_or_filt_index, void *struct_to_write);

/* these functions are for handling the deletion part in sections */

extern int delete_ipx_port	(ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_stp_port	(ULONG parameter_id, USHORT port_no, int index_to_delete);
#endif

/* extern int delete_ip_port	(ULONG parameter_id, USHORT port_no, int index_to_delete); */

extern int delete_proxy_address_filters (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_restricted_application_filters (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_proxy_application (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_proxy_user_application_entries (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_proxy_address_entries (ULONG parameter_id, USHORT port_no, int index_to_delete);

extern int delete_virtual_server_entries (ULONG parameter_id, USHORT port_no, int index_to_delete);

#if 0
extern int delete_static_route (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_ip_filter	(ULONG parameter_id, USHORT port_no, int index_to_delete);

extern int delete_ipx_address_filter (ULONG parameter_id, USHORT port_no, int index_to_delete);
extern int delete_stp_address_filter (ULONG parameter_id, USHORT port_no, int index_to_delete);
#endif

extern ULONG get_next_ip_address(ULONG ip_address, ULONG subnet_mask);

/* dhcp support functions */
extern void cm_clean_up_existing_dhcp_configuration() ;
extern BYTE cm_form_dhcp_range_structure(USHORT tag_number);
extern BYTE cm_form_dhcp_bindings_structure(USHORT tag_number);

/* for calculating offsets */
extern int calculate_offset_of_ip_port (ULONG *offset, USHORT port_no);

extern int calculate_offset_of_proxy_application_entries (ULONG *offset);
extern int calculate_offset_of_proxy_user_defined_application_entries (ULONG *offset);
extern int calculate_offset_of_proxy_filter (ULONG *offset);
extern int calculate_offset_to_each_proxy_filter (ULONG *offset, ULONG *return_offset, int filter_number);
extern int calculate_offset_of_proxy_port (ULONG *offset, int port_number); 
extern int calculate_offset_of_proxy_virtual_entry (ULONG *offset);
extern int calculate_offset_to_each_proxy_entry (ULONG *offset,ULONG *return_offset,int entry_type);

extern int calculate_offset_of_dhcp_address_range_entries (ULONG *offset, int index) ;
extern int calculate_offset_of_dhcp_binding_entries (ULONG *offset, ULONG *return_offset) ;

extern CM_STRUCT_DHCP_RANGE* convert_ulong_dhcp_address_range_values_to_dot_decimal(ULONG *offset);

#if 0
extern int calculate_offset_of_ipx_port (ULONG *offset, USHORT port_no);
extern int calculate_offset_of_stp_port (ULONG *offset, USHORT port_no);
#endif

/* for calculating offset of filters */
extern int calculate_offset_of_ip_port_filter (ULONG *offset, int index_of_filter);
extern int calculate_offset_of_ip_address_filter (ULONG *offset, int index_of_filter);
#if 0
extern int calculate_offset_of_ipx_filter (ULONG *offset, int index_of_filter);
extern int calculate_offset_of_stp_filter (ULONG *offset, int index_of_filter);
#endif

/* for sprintfing who has the control */
extern void put_write_access_owner_type (char *str);

extern void set_ip_port_bootp_interdep (void *data_ptr, USHORT port_no, int index);
#if 0
/* Interdependency functions */
extern void set_wan_port_type_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_ppp_interdep_para (void *data_ptr, USHORT port_no, int index);
extern void set_slip_interdep_para (void *data_ptr, USHORT port_no, int index);

extern void set_snmp_local_internet_address_interdep (void *data_ptr, USHORT port_no, int index);

extern void set_ip_address_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_remote_ip_address_interdep (void *data_ptr, USHORT port_no, int index);
/*
extern void set_ipx_network_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_ipx_autolearn_interdep (void *data_ptr, USHORT port_no, int index);
*/
#ifdef _BIG_PROXY_
extern void set_vjc_interdep (void *data_ptr, USHORT port_no, int index);
#endif

extern void set_wan_async_speed_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_dial_on_demand_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_client_only_interdep (void *data_ptr, USHORT port_no, int index);
extern void set_static_route_mask_interdep (void *data_ptr, USHORT port_no, int index);

extern void set_ppp_priority_interdep (void *data_ptr, USHORT port_no, int index);
#endif

/* For encrypting password */
extern void encrypt (char *src, char *dest) ;

/* validation functions  */
extern enum BOOLEAN check_whether_value_in_limit (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN check_only_for_a_set_of_values (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN check_for_string_length (ULONG *range_value, char *value_to_check);

/* IP Validation	.... */
extern enum BOOLEAN validate_ip_dns_ip_address(ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ip_gateway_address(ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ip_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ip_port_remote_address (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ip_port_rip_bits (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN verify_ip_subnet_mask (ULONG *range_value, char *value_to_check);
/* End of IP Validation	 */

#if 0
/* IPX Validation	.... */
extern enum BOOLEAN validate_ip_port_address (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ipx_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ipx_network_number (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ipx_port_periodic_bits_for_dod (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ipx_port_periodic_aging_for_dod (ULONG *range_value, char *value_to_check);
/* End of IPX Validation	 */

/* STP Validation	.... */
extern enum BOOLEAN validate_stp_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_stp_port_state (ULONG *range_value, char *value_to_check);
/* End of STP Validation */

/* WAN Validation	.... */
extern enum BOOLEAN validate_wan_port_async (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_wan_port_answering (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_wan_port_idle_flags (ULONG *range_value, char *value_to_check);
/* END of WAN Validation */

/* Data Port Validation	.... */
extern enum BOOLEAN validate_data_port_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_data_port_mode (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_data_port_dest_chan_num (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_data_port_pacing_ack_comp (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_data_port_pass_xon (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_data_port_xon_xoff (ULONG *range_value, char *value_to_check);
/* End of Data Port Validation	 */

/* PPP Validation	.... */
extern enum BOOLEAN validate_ppp_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_ppp_port_dod_enable (ULONG *range_value, char *value_to_check);
extern enum BOOLEAN validate_slip_enable (ULONG *range_value, char *value_to_check);

/* kiran 16/7/98 */
extern enum BOOLEAN validate_ppp_port_clientonly (ULONG *range_value, char *value_to_check);
#endif

/* End of PPP Validation */

/*  Imran... */
extern char *get_user_port_type (char *port_type_string, USHORT protocol_type, USHORT protocol_port_number);
extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE valid_bit_sequence(BYTE* mask);
extern BYTE mask_compatible_with_ip_address(BYTE* address, BYTE* mask);
extern BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
extern void format_address(BYTE* address);
extern BYTE is_valid_ipx_network_number(BYTE* string_ptr);
/* ...Imran  */

/* Jo 12/07/99 Added for RAS */
extern void set_client_only_interdep (USHORT port_no) ;
extern void set_ppp_strings (ULONG parameter_id, USHORT port_number, BYTE valid) ;
extern enum BOOLEAN set_mlppp_dependencies (enum BOOLEAN flag) ; 
/* Jo 12/07/99 Added for RAS */

/* Jo 19/08/99 Added for static routes */

extern int add_static_route_entry (ULONG parameter_id, USHORT port_no, void *struct_to_write) ;
extern int delete_static_route_entry (ULONG parameter_id, USHORT port_no, int index_to_delete) ;

/* Jo 19/08/99 Added for static routes */

