/*	$Modname: cipxprnt.c$  $version: 1.5$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 02/27/95 titus Changes for dynamic loading
1.4 03/30/95 titus Cosmetic changes for cipx_printf format strings
1.5 04/06/95 titus Changes for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	<stdarg.h>
#include	"cipx.h"
#include "vcipxprt.h"
/**************************************************************************/
void cipx_printf (enum CIPX_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	BYTE_ENUM(BOOLEAN) print_string;
	va_list argptr;

	va_start (argptr, cptr_format);

	if (cipx.print_class.cipx_print_switch_on == FALSE)
		{
		va_end (argptr);

		return;
		}

	switch (printf_group)
		{
		case CIPX_PRINTF:

			print_string = cipx.print_class.cipx_printing_enabled;

			break;

		case CIPX_INIT_PRINTF:

			print_string = cipx.print_class.init_printing_enabled;

			break;

		case CIPX_COMPRESS_PRINTF:

			print_string = cipx.print_class.compress_printing_enabled;

			break;

		case CIPX_UNCOMPRESS_PRINTF:

			print_string = cipx.print_class.uncompress_printing_enabled;

			break;

		case CIPX_ENCODE_PRINTF:

			print_string = cipx.print_class.encode_printing_enabled;

			break;

		case CIPX_DECODE_PRINTF:

			print_string = cipx.print_class.decode_printing_enabled;

			break;

		case CIPX_CHECKSUM_PRINTF:

			print_string = cipx.print_class.checksum_printing_enabled;

			break;

		case CIPX_STRING_PRINTF:

			print_string = cipx.print_class.string_printing_enabled;

			break;

		case CIPX_ALARM_PRINTF:

			print_string = cipx.print_class.alarm_printing_enabled;

			break;

		case CIPX_MEMORY_PRINTF:

			print_string = cipx.print_class.memory_printing_enabled;

			break;

		case CIPX_DATA_PRINTF:

			print_string = cipx.print_class.data_printing_enabled;

			break;

		case CIPX_DIAGNOSTIC_PRINTF:

			print_string = cipx.print_class.diagnostic_printing_enabled;

			break;

		default:

			print_string = FALSE;

			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format, argptr);
		}

	va_end (argptr);
}
/************************************************************************************/
void print_compressed_header_in_cipx_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes)
{
	BYTE *bptr_compressed_header;
	BYTE flags_octet;
	USHORT checksum;
	USHORT length;

	PARAMETER_NOT_USED (sptr_line_compression_state);

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		bptr_compressed_header = (BYTE *) &sptr_ipx_packet->ipx_header;

		flags_octet = *bptr_compressed_header;

		cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: COMPRESSED %s:", cptr_cipx_communication_modes[mode],
			cptr_cipx_packet_direction[packet_direction]);

		cipx_printf (CIPX_DATA_PRINTF, "%x", flags_octet);

		++bptr_compressed_header;

		if ((flags_octet & SLOT_NUMBER_FIELD) != 0x00)
			{
			cipx_printf (CIPX_DATA_PRINTF, ", %u", *bptr_compressed_header);

			++bptr_compressed_header;
			}

		if ((flags_octet & CHECKSUM_FIELD) != 0x00)
			{
			checksum = *bptr_compressed_header;

			checksum = (USHORT) (checksum << NUMBER_OF_BITS_IN_BYTE);

			++bptr_compressed_header;

			checksum = (USHORT) (checksum | *bptr_compressed_header);

			++bptr_compressed_header;

			cipx_printf (CIPX_DATA_PRINTF, ", %x", checksum);
			}

		length = 0x0000;

		if ((flags_octet & LENGTH_FIELD) != 0x00)
			{
			if (*bptr_compressed_header <= ONE_TWENTY_SEVEN)
				{
				length = *bptr_compressed_header;

				++bptr_compressed_header;
				}
			else if (*bptr_compressed_header < ONE_NINETY_TWO)
				{
				length = *bptr_compressed_header;

				length = length & TWO_BYTE_LENGTH_MASK;

				length = (USHORT) (length << NUMBER_OF_BITS_IN_BYTE);

				++bptr_compressed_header;

				length = (USHORT) (length | *bptr_compressed_header);

				++bptr_compressed_header;
				}
			else if (*bptr_compressed_header == ONE_NINETY_TWO)
				{
				++bptr_compressed_header;

				length = *bptr_compressed_header;

				length = (USHORT) (length << NUMBER_OF_BITS_IN_BYTE);

				++bptr_compressed_header;

				length = (USHORT) (length | *bptr_compressed_header);

				++bptr_compressed_header;
				}

			cipx_printf (CIPX_DATA_PRINTF, ", %u", length);
			}

		if ((flags_octet & TASK_NUMBER_FIELD) != 0x00)
			{
			cipx_printf (CIPX_DATA_PRINTF, ", %u", *bptr_compressed_header);
			}

		cipx_printf (CIPX_DATA_PRINTF, ", %u", number_of_bytes);

		cipx_printf (CIPX_DATA_PRINTF, "\n");
		}
}
/************************************************************************************/
void print_uncompressed_header (IPX_HEADER *sptr_ipx_header, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		cipx_printf (CIPX_DATA_PRINTF, ":%x, %u, ", sptr_ipx_header->checksum, net_to_host_short (sptr_ipx_header->length));

		cipx_printf (CIPX_DATA_PRINTF, "%u", sptr_ipx_header->packet_type);

		if ((sptr_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET) &&
			((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)))
			{
			sptr_ncp_header = get_pointer_to_ncp_header (sptr_ipx_header);

			cipx_printf (CIPX_DATA_PRINTF, ":%x, ", net_to_host_short (sptr_ncp_header->packet_type));

			cipx_printf (CIPX_DATA_PRINTF, "%u, %u", sptr_ncp_header->sequence_number, sptr_ncp_header->task_number);
			}
		}
}
/************************************************************************************/
void print_header_in_regular_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes)
{
	IPX_HEADER *sptr_ipx_header;
	BYTE *bptr_cipx_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		bptr_cipx_header = (BYTE *) &sptr_ipx_packet->ipx_header;

		cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: REGULAR %s:", cptr_cipx_communication_modes[mode],
			cptr_cipx_packet_direction[packet_direction]);

		cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

		cipx_printf (CIPX_DATA_PRINTF, "%u", number_of_bytes);

		sptr_ipx_header = (IPX_HEADER *) (bptr_cipx_header + 1);

		print_uncompressed_header (sptr_ipx_header, sptr_line_compression_state);

		cipx_printf (CIPX_DATA_PRINTF, "\n");
		}
}
/************************************************************************************/
void print_header_in_initial_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes)
{
	IPX_HEADER *sptr_ipx_header;
	BYTE *bptr_cipx_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		bptr_cipx_header = (BYTE *) &sptr_ipx_packet->ipx_header;

		if ((*bptr_cipx_header & PACKET_TYPE_MASK) == TYPE_CONFIRMED_INITIAL)
			{
			cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: CONFIRMED INITIAL %s:", cptr_cipx_communication_modes[mode],
				cptr_cipx_packet_direction[packet_direction]);

			cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

			++bptr_cipx_header;

			cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);

			++bptr_cipx_header;

			cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);
			}
		else if ((*bptr_cipx_header & PACKET_TYPE_MASK) == TYPE_UNCONFIRMED_INITIAL)
			{
			cipx_printf (CIPX_DATA_PRINTF, "\nCIPX: %s: UNCONFIRMED INITIAL %s:", cptr_cipx_communication_modes[mode],
				cptr_cipx_packet_direction[packet_direction]);

			cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

			++bptr_cipx_header;

			cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);
			}
		else
			{
			return;
			}

		cipx_printf (CIPX_DATA_PRINTF, "%u", number_of_bytes);

		sptr_ipx_header = (IPX_HEADER *) (bptr_cipx_header + 1);

		print_uncompressed_header (sptr_ipx_header, sptr_line_compression_state);

		cipx_printf (CIPX_DATA_PRINTF, "\n");
		}
}
/************************************************************************************/
void print_header_in_confirm_packet (CIPX_PACKET *sptr_cipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes)
{
	BYTE *bptr_cipx_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		bptr_cipx_header = (BYTE *) &sptr_cipx_packet->cipx_header[0];

		cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: CONFIRM %s:", cptr_cipx_communication_modes[mode],
			cptr_cipx_packet_direction[packet_direction]);

		cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

		++bptr_cipx_header;

		cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);

		++bptr_cipx_header;

		cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);

		cipx_printf (CIPX_DATA_PRINTF, "%u\n", number_of_bytes);
		}
}
/************************************************************************************/
void print_header_in_reject_packet (CIPX_PACKET *sptr_cipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes)
{
	BYTE *bptr_cipx_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		bptr_cipx_header = (BYTE *) &sptr_cipx_packet->cipx_header[0];

		cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: REJECT %s:", cptr_cipx_communication_modes[mode],
			cptr_cipx_packet_direction[packet_direction]);

		cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

		++bptr_cipx_header;

		cipx_printf (CIPX_DATA_PRINTF, "%u, ", *bptr_cipx_header);

		++bptr_cipx_header;

		cipx_printf (CIPX_DATA_PRINTF, "%x, ", *bptr_cipx_header);

		cipx_printf (CIPX_DATA_PRINTF, "%u\n", number_of_bytes);
		}
}
/************************************************************************************/
void print_cipx_connection_state (BYTE *bptr_uncompressed_header, enum COMMUNICATION_MODE mode, enum HEADER_AGE header_age,
	CIPX_CONNECTION_STATE *sptr_connection_state, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	IPX_HEADER *sptr_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		sptr_ipx_header = (IPX_HEADER *) bptr_uncompressed_header;

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: %s: CONNECTION STATE %s:", cptr_cipx_communication_modes[mode],
			cptr_cipx_header_age[header_age]);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, ", sptr_connection_state->slot_number);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, ", sptr_connection_state->unconfirmed_initial_packet);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, ", sptr_connection_state->last_confirmed_initial_packet_id);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, ", sptr_connection_state->last_confirm_packet_id);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%x, ", sptr_connection_state->last_rejected_flags);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, ", sptr_connection_state->header_length);

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%x, %u, ", sptr_ipx_header->checksum,
			net_to_host_short (sptr_ipx_header->length));

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u", sptr_ipx_header->packet_type);

		if ((sptr_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET) &&
			((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE)	||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)))
			{
			if (sptr_connection_state->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
				{
				sptr_ncp_header = get_pointer_to_ncp_header (sptr_ipx_header);

				cipx_printf (CIPX_DIAGNOSTIC_PRINTF, ":%x, ", net_to_host_short (sptr_ncp_header->packet_type));

				cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "%u, %u", sptr_ncp_header->sequence_number, sptr_ncp_header->task_number);
				}
			}

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "\n");
		}
}
/************************************************************************************/
void print_uncompressed_header_in_ipx_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes)
{
	IPX_HEADER *sptr_ipx_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		cipx_printf (CIPX_DATA_PRINTF, "CIPX: %s: UNCOMPRESSED %s", cptr_cipx_communication_modes[mode],
			cptr_cipx_packet_direction[packet_direction]);

		sptr_ipx_header = &sptr_ipx_packet->ipx_header;

		print_uncompressed_header (sptr_ipx_header, sptr_line_compression_state);

		cipx_printf (CIPX_DATA_PRINTF, ", %u\n", number_of_bytes);
		}
}
/************************************************************************************/
void print_addresses_in_ipx_packet (IPX_PACKET *sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	IPX_HEADER *sptr_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;

	if (cipx.print_class.cipx_print_switch_on == TRUE)
		{
		sptr_ipx_header = &sptr_ipx_packet->ipx_header;

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "\tIPX: %x : %x,%x : %x", net_to_host_long (sptr_ipx_header->source.network),
			net_to_host_long (sptr_ipx_header->source.node_address._ulong),
			net_to_host_short (sptr_ipx_header->source.node_address._ushort),
			net_to_host_short (sptr_ipx_header->source.socket));

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, " -> %x : %x,%x : %x", net_to_host_long (sptr_ipx_header->destination.network),
			net_to_host_long (sptr_ipx_header->destination.node_address._ulong),
			net_to_host_short (sptr_ipx_header->destination.node_address._ushort),
			net_to_host_short (sptr_ipx_header->destination.socket));

		if ((sptr_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET) &&
			((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE)	||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)))
			{
			sptr_ncp_header = get_pointer_to_ncp_header (sptr_ipx_header);

			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "\tNCP: %x,%x", sptr_ncp_header->connection_number_low,
				sptr_ncp_header->connection_number_high);
			}

		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "\n");
		}
}
