/*	$Modname: cipxrxde.c$  $version: 1.3$      $date: 03/30/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters and for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "cipx.h"
/************************************************************************************/
static void	set_byte_pointer_and_flags_octet (IPX_PACKET *sptr_ipx_packet, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_flags_octet);
static enum BOOLEAN check_for_valid_slot_number (BYTE flags_octet, BYTE **ptr_to_bptr_compressed_header,
	enum BOOLEAN *eptr_bad_header, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,	IPX_PACKET *sptr_ipx_packet,
	BYTE *bptr_rejected_flags);
static void get_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state, IPX_HEADER **ptr_to_sptr_ipx_header, USHORT *usptr_header_length,
	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_ncp_header);
static void	fix_up_connection_state_based_on_flags_octet (BYTE flags_octet, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, BYTE **ptr_to_bptr_compressed_header, USHORT number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet, BYTE *bptr_rejected_flags);
static void update_checksum_field (IPX_HEADER *sptr_ipx_header, BYTE **ptr_to_bptr_compressed_header, BYTE *bptr_rejected_flags);
static void set_checksum_field (IPX_HEADER *sptr_ipx_header, USHORT checksum);
static void update_length_field (IPX_HEADER *sptr_ipx_header, BYTE **ptr_to_bptr_compressed_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet, BYTE *bptr_rejected_flags);
static void set_length_field (BYTE flags_octet, IPX_HEADER *sptr_ipx_header, USHORT length);
static void update_task_number_field (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_rejected_flags);
static void increment_ncp_sequence_number (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header);
static void	align_header_on_4_byte_boundary (IPX_PACKET *sptr_ipx_packet, BYTE **ptr_to_bptr_compressed_header,
	USHORT *usptr_number_of_bytes, enum BOOLEAN *eptr_bad_header);
static void	copy_uncompressed_header_and_adjust_number_of_bytes (CIPX_CONNECTION_STATE *sptr_connection_state,
	BYTE **ptr_to_bptr_compressed_header, USHORT *usptr_number_of_bytes, IPX_HEADER *sptr_ipx_header);
static void cipx_tx_completion (USHORT protocol_virtual_port_number, void *sptr_buffer);
/************************************************************************************/
enum PROCESS_RESULT process_compressed_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,	USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	IPX_HEADER *sptr_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;
	USHORT header_length;
	BYTE flags_octet;
	enum BOOLEAN bad_header;
	BYTE rejected_flags;
	BYTE *bptr_compressed_header;

#ifdef DEBUG
	print_compressed_header_in_cipx_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, FROM_LOWER_LEVEL, sptr_line_compression_state,
		*usptr_number_of_bytes);
#endif

	++cipx.statistics.type_compressed_packets_received;
			
	set_byte_pointer_and_flags_octet (*ptr_to_sptr_ipx_packet, &bptr_compressed_header, &flags_octet);

	rejected_flags = *bptr_compressed_header;

	if (*usptr_number_of_bytes < (sizeof (UNION_MAC_HEADER) + MINIMUM_COMPRESSED_HEADER_LENGTH))
		{
		/* discard packet */

		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: too few bytes in COMPRESSED packet : %u\n", *usptr_number_of_bytes);

		return (END_OF_PROCESSING);
		}

	if (check_for_valid_slot_number (flags_octet, &bptr_compressed_header, &bad_header, sptr_line_compression_state,
		*ptr_to_sptr_ipx_packet, &rejected_flags) == FALSE)
		{
		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: slot_number in COMPRESSED packet exceeds MAXIMUM NUMBER OF SLOTS : %u\n",
			sptr_line_compression_state->maximum_number_of_slots);

		return (END_OF_PROCESSING);
		}
	
	get_connection_state (sptr_line_compression_state, &sptr_connection_state,	&sptr_ipx_header, &header_length,
		&sptr_ncp_header);

#ifdef DEBUG
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, OLD, sptr_connection_state,
		sptr_line_compression_state);
#endif

	fix_up_connection_state_based_on_flags_octet (flags_octet, sptr_ipx_header, sptr_ncp_header,	&bptr_compressed_header,
		*usptr_number_of_bytes, sptr_line_compression_state, *ptr_to_sptr_ipx_packet, &rejected_flags);
	
	align_header_on_4_byte_boundary (*ptr_to_sptr_ipx_packet, &bptr_compressed_header,
		usptr_number_of_bytes, &bad_header);

	if (bad_header == TRUE)
		{
		process_bad_header_event (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, rejected_flags, TRUE);

		cipx_printf (CIPX_UNCOMPRESS_PRINTF, "CIPX: error in header alignment of COMPRESSED packet\n");

		return (END_OF_PROCESSING);
		}

	copy_uncompressed_header_and_adjust_number_of_bytes (sptr_connection_state, &bptr_compressed_header, usptr_number_of_bytes,
		sptr_ipx_header);

	bptr_compressed_header -= sizeof (UNION_MAC_HEADER);

	*ptr_to_sptr_ipx_packet = (IPX_PACKET *) bptr_compressed_header;

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: Final pointer to packet has value %p\n", *ptr_to_sptr_ipx_packet);
	print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], RECEIVE_MODE, NEW, sptr_connection_state,
		sptr_line_compression_state);

	print_addresses_in_ipx_packet (*ptr_to_sptr_ipx_packet, sptr_line_compression_state);

	print_uncompressed_header_in_ipx_packet (*ptr_to_sptr_ipx_packet, RECEIVE_MODE, TO_UPPER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

	return (CONTINUE_PROCESSING);
}
/************************************************************************************/
static void	set_byte_pointer_and_flags_octet (IPX_PACKET *sptr_ipx_packet, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_flags_octet)
{
	*ptr_to_bptr_compressed_header = (BYTE *) &sptr_ipx_packet->ipx_header;

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: pointer to ipx header has value %p\n", *ptr_to_bptr_compressed_header);
#endif

	*bptr_flags_octet = **ptr_to_bptr_compressed_header;

	++(*ptr_to_bptr_compressed_header);
}
/************************************************************************************/
static enum BOOLEAN check_for_valid_slot_number (BYTE flags_octet, BYTE **ptr_to_bptr_compressed_header,
	enum BOOLEAN *eptr_bad_header, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet,
	BYTE *bptr_rejected_flags)
{
	USHORT slot_number;

	if ((flags_octet & SLOT_NUMBER_FIELD) != 0x00)
		{
     	if (**ptr_to_bptr_compressed_header > sptr_line_compression_state->maximum_number_of_slots)
			{
			*eptr_bad_header = TRUE;

			return (FALSE);
			}

		sptr_line_compression_state->valid_flag = TRUE;

		sptr_line_compression_state->last_received_slot_number = **ptr_to_bptr_compressed_header;

		++(*ptr_to_bptr_compressed_header);

		*bptr_rejected_flags = *bptr_rejected_flags & (BYTE) ~SLOT_NUMBER_FIELD;

		return (TRUE);
		}
	else
		{
		if ((sptr_line_compression_state->confirmed_initial_packet_enabled == FALSE) &&
			(sptr_line_compression_state->slot_number_compression_enabled == TRUE))
			{
			slot_number = sptr_line_compression_state->last_received_slot_number;

			if ((sptr_line_compression_state->valid_flag == FALSE) ||
				((sptr_line_compression_state->sptr_received_connection_states + slot_number)->unconfirmed_initial_packet == FALSE))
				{
				/* packet is discarded */

				return (FALSE);
				}

			return (TRUE);
			}
		else
			{
			process_bad_header_event (sptr_line_compression_state, sptr_ipx_packet, *bptr_rejected_flags, TRUE);

			return (FALSE);
			}
		}
}
/************************************************************************************/
static void get_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state, IPX_HEADER **ptr_to_sptr_ipx_header, USHORT *usptr_header_length,
	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_ncp_header)
{
	USHORT slot_number;

	slot_number = sptr_line_compression_state->last_received_slot_number;

	*ptr_to_sptr_connection_state = sptr_line_compression_state->sptr_received_connection_states + slot_number;

	*ptr_to_sptr_ipx_header = (IPX_HEADER *) &(*ptr_to_sptr_connection_state)->uncompressed_header[0];

	*usptr_header_length = (*ptr_to_sptr_connection_state)->header_length;

	*ptr_to_sptr_ncp_header = NULL;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		((*ptr_to_sptr_ipx_header)->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (*usptr_header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
			{
			*ptr_to_sptr_ncp_header = get_pointer_to_ncp_header (*ptr_to_sptr_ipx_header);
			}
		}
}
/************************************************************************************/
static void	fix_up_connection_state_based_on_flags_octet (BYTE flags_octet, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, BYTE **ptr_to_bptr_compressed_header, USHORT number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet, BYTE *bptr_rejected_flags)
{
	if ((flags_octet & CHECKSUM_FIELD) != 0x00)
		{
		update_checksum_field (sptr_ipx_header, ptr_to_bptr_compressed_header, bptr_rejected_flags);
		}
	else
		{
		if (sptr_line_compression_state->ipx_checksum_enabled == TRUE)
			{
			process_bad_header_event (sptr_line_compression_state, sptr_ipx_packet, *bptr_rejected_flags, TRUE);

			return;
			}
		else
			{
			set_checksum_field (sptr_ipx_header, DEFAULT_CHECKSUM); 
			}
		}

	if ((flags_octet & LENGTH_FIELD) != 0x00)
		{
		update_length_field (sptr_ipx_header, ptr_to_bptr_compressed_header, sptr_line_compression_state, sptr_ipx_packet,
			bptr_rejected_flags);
		}
	else
		{
		if (sptr_line_compression_state->determine_length_from_mac_header_enabled == TRUE)
			{
			set_length_field (flags_octet, sptr_ipx_header, number_of_bytes);
			}
		else
			{
			process_bad_header_event (sptr_line_compression_state, sptr_ipx_packet, *bptr_rejected_flags, TRUE);

			return;
			}
		}

	if ((flags_octet & TASK_NUMBER_FIELD) != 0x00)
		{
		if (sptr_ncp_header != NULL)
			{
			update_task_number_field (sptr_ncp_header, ptr_to_bptr_compressed_header, bptr_rejected_flags);
			}
		else
			{
			process_bad_header_event (sptr_line_compression_state, sptr_ipx_packet, *bptr_rejected_flags, TRUE);

			return;
			}
		}

	if (sptr_ncp_header != NULL)
		{
		increment_ncp_sequence_number (sptr_ncp_header);
		}
}
/************************************************************************************/
static void update_checksum_field (IPX_HEADER *sptr_ipx_header, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_rejected_flags)
{
	USHORT checksum;

	checksum = **ptr_to_bptr_compressed_header;

	checksum = (USHORT) (checksum << NUMBER_OF_BITS_IN_BYTE);

	++(*ptr_to_bptr_compressed_header);

	checksum = (USHORT) (checksum | **ptr_to_bptr_compressed_header);

	sptr_ipx_header->checksum = checksum;

	++(*ptr_to_bptr_compressed_header);

	*bptr_rejected_flags = (BYTE) (*bptr_rejected_flags & ~CHECKSUM_FIELD);
}
/************************************************************************************/
static void set_checksum_field (IPX_HEADER *sptr_ipx_header, USHORT checksum)
{
	sptr_ipx_header->checksum = checksum;
}
/************************************************************************************/
static void update_length_field (IPX_HEADER *sptr_ipx_header, BYTE **ptr_to_bptr_compressed_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet, BYTE *bptr_rejected_flags)
{
	USHORT length;

	if (**ptr_to_bptr_compressed_header <= ONE_TWENTY_SEVEN)
		{
		length = **ptr_to_bptr_compressed_header;
		}
	else
		{
		if (**ptr_to_bptr_compressed_header < ONE_NINETY_TWO)
			{
			length = **ptr_to_bptr_compressed_header;

			length = length & TWO_BYTE_LENGTH_MASK;

			length = (USHORT) (length << NUMBER_OF_BITS_IN_BYTE);

			++(*ptr_to_bptr_compressed_header);

			length = (USHORT) (length | **ptr_to_bptr_compressed_header);
			}
		else
			{
			if (**ptr_to_bptr_compressed_header == ONE_NINETY_TWO)
				{
				++(*ptr_to_bptr_compressed_header);

				length = **ptr_to_bptr_compressed_header;

				length = (USHORT) (length << NUMBER_OF_BITS_IN_BYTE);

				++(*ptr_to_bptr_compressed_header);

				length = (USHORT) (length | **ptr_to_bptr_compressed_header);
				}
			else
				{
				process_bad_header_event (sptr_line_compression_state, sptr_ipx_packet, *bptr_rejected_flags, TRUE);

				return;
				}
			}
		}

	sptr_ipx_header->length = length;

	++(*ptr_to_bptr_compressed_header);

	*bptr_rejected_flags = (BYTE) (*bptr_rejected_flags & ~LENGTH_FIELD);
}
/************************************************************************************/
static void set_length_field (BYTE flags_octet, IPX_HEADER *sptr_ipx_header, USHORT length)
{
	USHORT compressed_header_length;

	compressed_header_length = 0x0001;

	if ((flags_octet & SLOT_NUMBER_FIELD) != 0x00)
		{
		++compressed_header_length;
		}

	if ((flags_octet & CHECKSUM_FIELD) != 0x00)
		{
		compressed_header_length += (USHORT) 0x0002;
		}

	if ((flags_octet & TASK_NUMBER_FIELD) != 0x00)
		{
		++compressed_header_length;
		}

	length -= (USHORT) (sizeof (UNION_MAC_HEADER) + compressed_header_length);

	sptr_ipx_header->length = length;
}
/************************************************************************************/
static void update_task_number_field (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, BYTE **ptr_to_bptr_compressed_header,
	BYTE *bptr_rejected_flags)
{
	sptr_ncp_header->task_number = **ptr_to_bptr_compressed_header;

	++(*ptr_to_bptr_compressed_header);

	*bptr_rejected_flags = (USHORT) (*bptr_rejected_flags & ~TASK_NUMBER_FIELD);
}
/************************************************************************************/
static void increment_ncp_sequence_number (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header)
{
	sptr_ncp_header->sequence_number += (BYTE) 0x01;
}
/************************************************************************************/
static void	align_header_on_4_byte_boundary (IPX_PACKET *sptr_ipx_packet, BYTE **ptr_to_bptr_compressed_header,
	USHORT *usptr_number_of_bytes, enum BOOLEAN *eptr_bad_header)
{
	BYTE *aligned_bptr_compressed_header;
	USHORT length;

	*eptr_bad_header = FALSE;

	/*
 	 * At this point, bptr_compressed_header points to the first byte of data in the packet.
	 * If we're not aligned on a 4-byte boundary, copy the data down so the IP & TCP headers will be aligned.
 	 */

	length = (USHORT) (*ptr_to_bptr_compressed_header - (BYTE *) &sptr_ipx_packet->ipx_header);

	if (length > *usptr_number_of_bytes)
		{
		/* we must have dropped some characters (crc should detect this but the old slip framing won't) */

		cipx_printf (CIPX_ALARM_PRINTF, "CIPX: RX: error in length %x,%p->%p\n", length, &sptr_ipx_packet->ipx_header,
			*ptr_to_bptr_compressed_header); 

		*eptr_bad_header = TRUE;

		return;
		}
	else
		{
		*usptr_number_of_bytes -= length;
		}

	if (cipx.align_header_on_4_byte_boundary_enabled == TRUE)
		{
		if (((ULONG) *ptr_to_bptr_compressed_header & FOUR_BYTE_BOUNDARY_MASK) != 0x00000000L)
			{
			aligned_bptr_compressed_header = (BYTE *) ((ULONG) *ptr_to_bptr_compressed_header & ~FOUR_BYTE_BOUNDARY_MASK);

			if (*usptr_number_of_bytes > 0x0000)
				{
				memmove ((void *) aligned_bptr_compressed_header, (const void *) *ptr_to_bptr_compressed_header,
					*usptr_number_of_bytes);
				}

#ifdef DEBUG
			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: RX: headers aligned by %u bytes\n",
				(USHORT) ((ULONG) *ptr_to_bptr_compressed_header & FOUR_BYTE_BOUNDARY_MASK));
#endif

			*ptr_to_bptr_compressed_header = aligned_bptr_compressed_header;
			}
		}
}
/************************************************************************************/
static void	copy_uncompressed_header_and_adjust_number_of_bytes (CIPX_CONNECTION_STATE *sptr_connection_state,
	BYTE **ptr_to_bptr_compressed_header, USHORT *usptr_number_of_bytes, IPX_HEADER *sptr_ipx_header)
{
	/*
 	 * At this point, bptr_compressed_header points to the first byte of data in the packet.
	 * Back up bptr_compressed_header by the TCP/IP header length to make room for reconstructed header (we assume the packet
	 *	we were handed has enough space to prepend 128 bytes of header).
	 *	Adjust the number_of_bytes to account for the new header & fill in the IP total length.
 	 */

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: *ptr_to_bptr_compressed_header has old value %p\n",
		*ptr_to_bptr_compressed_header);
#endif

	*ptr_to_bptr_compressed_header -= sptr_connection_state->header_length;

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: *ptr_to_bptr_compressed_header has new value %p\n",
		*ptr_to_bptr_compressed_header);

	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: *usptr_number_of_bytes has old value %p\n", *usptr_number_of_bytes);
#endif

	*usptr_number_of_bytes += sptr_connection_state->header_length;

#ifdef DEBUG
	cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: *usptr_number_of_bytes has new value %p\n", *usptr_number_of_bytes);
#endif

	/* sizeof (UNION_MAC_HEADER) is subtracted from number_of_bytes */

	sptr_ipx_header->length = host_to_net_short ((USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER)));

	memcpy ((void *) *ptr_to_bptr_compressed_header, (const void *) &sptr_connection_state->uncompressed_header[0],
		sptr_connection_state->header_length);
}
/************************************************************************************/
void send_cipx_reject_packet (IPX_PACKET *sptr_ipx_packet, BYTE rejected_flags,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_PACKET *sptr_cipx_packet_to_send;
	BYTE *bptr_cipx_header_to_send;
	BYTE *bptr_cipx_header;

	sptr_cipx_packet_to_send = (CIPX_PACKET *) table_malloc (1, sizeof (CIPX_PACKET));

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: Allocated memory at %p\n", sptr_cipx_packet_to_send);

	bptr_cipx_header_to_send = &sptr_cipx_packet_to_send->cipx_header[0];

	if (bptr_cipx_header_to_send == NULL)
		{
		cipx_printf (CIPX_STRING_PRINTF, "CIPX: RX: table_malloc failed in allocating reject packet\n");

		return;
		}

	bptr_cipx_header = (BYTE *) &sptr_ipx_packet->ipx_header;

	*bptr_cipx_header_to_send = TYPE_REJECT;

	++bptr_cipx_header_to_send;

	++bptr_cipx_header;

	*bptr_cipx_header_to_send = *bptr_cipx_header;

	++bptr_cipx_header_to_send;

	*bptr_cipx_header_to_send = rejected_flags;

	/* call ppp to send reject packet */

	print_header_in_reject_packet (sptr_cipx_packet_to_send, TRANSMIT_MODE, TO_LOWER_LEVEL, sizeof (CIPX_PACKET));

	if (send_cipx_packet (sptr_line_compression_state->port_number, sptr_cipx_packet_to_send, LENGTH_OF_REJECT_HEADER,
		cipx_tx_completion) == FAIL)
		{
		cipx_printf (CIPX_ALARM_PRINTF, "CIPX: send_cipx_packet failed to send confirm packet\n");
		}
}
/************************************************************************************/
void send_cipx_confirm_packet (CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_PACKET *sptr_cipx_packet;
	BYTE *bptr_cipx_header;

	sptr_cipx_packet = (CIPX_PACKET *) table_malloc (1, sizeof (CIPX_PACKET));

#ifdef DEBUG
	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: Allocated memory at %p\n", sptr_cipx_packet);
#endif

	bptr_cipx_header = (BYTE *) &sptr_cipx_packet->cipx_header[0];

	if (bptr_cipx_header == NULL)
		{
		cipx_printf (CIPX_STRING_PRINTF, "CIPX: RX: table_malloc failed in allocating confirm packet\n");

		return;
		}

	*bptr_cipx_header = TYPE_CONFIRM;

	++bptr_cipx_header;

	*bptr_cipx_header = sptr_connection_state->slot_number;

	++bptr_cipx_header;

	*bptr_cipx_header = sptr_connection_state->last_confirmed_initial_packet_id;

	/* call ppp to send confirm packet */

#ifdef DEBUG
	print_header_in_confirm_packet (sptr_cipx_packet, TRANSMIT_MODE, TO_LOWER_LEVEL, sizeof (CIPX_PACKET));
#endif

	if (send_cipx_packet (sptr_line_compression_state->port_number, sptr_cipx_packet, LENGTH_OF_CONFIRM_HEADER,
		cipx_tx_completion) == FAIL)
		{
		cipx_printf (CIPX_ALARM_PRINTF, "CIPX: send_cipx_packet failed to send confirm packet\n");
		}
	else
		{
		sptr_connection_state->last_confirm_packet_id = sptr_connection_state->last_confirmed_initial_packet_id;
		}
}
/************************************************************************************/
static void cipx_tx_completion (USHORT protocol_virtual_port_number, void *sptr_buffer)
{
	PARAMETER_NOT_USED (protocol_virtual_port_number);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: Freed memory at %p\n", sptr_buffer);

	table_free (sptr_buffer);
}

