/*	$Modname: cipxtxck.c$  $version: 1.4$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters
1.4 04/06/95 titus Changes for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "cipx.h"
/************************************************************************************/
static void determine_send_packet_type (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	IPX_PACKET *sptr_ipx_packet, IPX_HEADER **ptr_to_sptr_ipx_header,	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_ncp_header,
	USHORT number_of_bytes, enum BOOLEAN *eptr_send_ncp_uncompressed, enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type);
static enum BOOLEAN check_if_packet_is_a_valid_ipx_packet (IPX_HEADER *sptr_ipx_header, ULONG number_of_bytes);
static enum BOOLEAN check_if_ipx_packet_type_is_ncp (IPX_HEADER *sptr_ipx_header);
static void set_local_variables_for_compression_processing (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state, BYTE **ptr_to_bptr_change_mask, BYTE **ptr_to_bptr_cipx_header,
	BYTE *bptr_cipx_header, USHORT *usptr_header_length, enum BOOLEAN send_ncp_uncompressed);
static void locate_or_create_connection_state (CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,
	enum BOOLEAN send_ncp_uncompressed);
static enum BOOLEAN check_if_most_recently_used_connection_state_matches_current_packet (IPX_HEADER *sptr_ipx_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER *sptr_old_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	enum BOOLEAN send_ncp_uncompressed, CIPX_CONNECTION_STATE *sptr_connection_state);
static CIPX_CONNECTION_STATE *search_and_get_matching_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	enum BOOLEAN *eptr_found_slot, CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum BOOLEAN send_ncp_uncompressed);
static void move_connection_state_to_front_of_list (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, CIPX_CONNECTION_STATE *sptr_previous_connection_state);
static void set_pointers_to_last_header_that_was_saved_in_connection_state (CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER **ptr_to_sptr_old_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_old_ncp_header, enum BOOLEAN send_ncp_uncompressed);
static void	check_if_confirm_packet_type_received_for_this_connection (CIPX_CONNECTION_STATE *sptr_connection_state,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
/************************************************************************************/
void compress_header (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CIPX_CONNECTION_STATE *sptr_connection_state;
	IPX_HEADER *sptr_ipx_header;							  					/* current IPX header */
	IPX_HEADER *sptr_old_ipx_header;											/* last IPX header */
	USHORT header_length;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header;					/* last NETWORK_CORE_PROTOCOL header */
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;    					/* current NETWORK_CORE_PROTOCOL header */
	BYTE *bptr_change_mask;        											/* change mask */
	BYTE cipx_header[MAXIMUM_COMPRESSED_HEADER_LENGTH];      		/* changes from last to current */
	BYTE *bptr_cipx_header;
	enum BOOLEAN send_ncp_uncompressed;
	enum CIPX_PACKET_TYPE send_cipx_packet_type;

#ifdef DEBUG
	print_uncompressed_header_in_ipx_packet (*ptr_to_sptr_ipx_packet, TRANSMIT_MODE, FROM_UPPER_LEVEL,
		sptr_line_compression_state, *usptr_number_of_bytes);

	print_addresses_in_ipx_packet (*ptr_to_sptr_ipx_packet, sptr_line_compression_state);

	cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);
#endif

	determine_send_packet_type (sptr_line_compression_state, *ptr_to_sptr_ipx_packet, &sptr_ipx_header, &sptr_ncp_header,
		*usptr_number_of_bytes, &send_ncp_uncompressed, &send_cipx_packet_type);

	++cipx.statistics.packets_transmitted_by_cipx;

	if (send_cipx_packet_type == TYPE_REGULAR)
		{
		send_cipx_regular_packet (ptr_to_sptr_ipx_packet, sptr_line_compression_state, usptr_number_of_bytes);

		return;
		}
	else
		{
		set_local_variables_for_compression_processing (sptr_line_compression_state, &sptr_connection_state, &bptr_change_mask,
			&bptr_cipx_header, &cipx_header[0], &header_length, send_ncp_uncompressed);

		locate_or_create_connection_state (&sptr_connection_state, sptr_line_compression_state, sptr_ipx_header, sptr_ncp_header,
			&send_cipx_packet_type, send_ncp_uncompressed);

#ifdef DEBUG
		print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], TRANSMIT_MODE, OLD, sptr_connection_state,
			sptr_line_compression_state);
#endif

		if (send_cipx_packet_type == TYPE_CONFIRMED_INITIAL)
			{
			send_cipx_confirmed_initial_packet (sptr_line_compression_state, sptr_connection_state,
				sptr_ipx_header, header_length, ptr_to_sptr_ipx_packet, usptr_number_of_bytes);

			return;
			}
		else if (send_cipx_packet_type == TYPE_UNCONFIRMED_INITIAL)
			{
			send_cipx_unconfirmed_initial_packet (sptr_line_compression_state, sptr_connection_state,
				sptr_ipx_header, header_length, ptr_to_sptr_ipx_packet, usptr_number_of_bytes);

			return;
			}

		check_if_confirm_packet_type_received_for_this_connection (sptr_connection_state, &send_cipx_packet_type,
			sptr_line_compression_state);

		if (send_cipx_packet_type == TYPE_CONFIRMED_INITIAL)
			{
			send_cipx_confirmed_initial_packet (sptr_line_compression_state, sptr_connection_state, sptr_ipx_header,
				header_length,	ptr_to_sptr_ipx_packet, usptr_number_of_bytes);

			return;
			}

		set_pointers_to_last_header_that_was_saved_in_connection_state (sptr_connection_state, sptr_line_compression_state,
			&sptr_old_ipx_header, &sptr_old_ncp_header, send_ncp_uncompressed);

		if ((cipx_check_if_any_changes_to_fields_that_we_didnot_expect_to_change (sptr_ipx_header, sptr_old_ipx_header,
			sptr_ncp_header, &send_cipx_packet_type, sptr_old_ncp_header, sptr_line_compression_state) == TRUE) ||
			(cipx_check_if_no_changes_to_fields_that_were_expected_to_change (sptr_ipx_header, sptr_old_ipx_header,
			sptr_ncp_header, &send_cipx_packet_type, sptr_old_ncp_header, sptr_line_compression_state) == TRUE)) 
			{
			if (send_cipx_packet_type == TYPE_CONFIRMED_INITIAL)
				{
				send_cipx_confirmed_initial_packet (sptr_line_compression_state, sptr_connection_state,
					sptr_ipx_header, header_length, ptr_to_sptr_ipx_packet, usptr_number_of_bytes);

				return;
				}
			else if (send_cipx_packet_type == TYPE_UNCONFIRMED_INITIAL)
				{
				send_cipx_unconfirmed_initial_packet (sptr_line_compression_state, sptr_connection_state,
					sptr_ipx_header, header_length, ptr_to_sptr_ipx_packet, usptr_number_of_bytes);

				return;
				}
			}
		else
			{
			cipx_figure_out_which_of_the_fields_changed (bptr_change_mask, &send_ncp_uncompressed, sptr_ipx_header, sptr_ncp_header,
				sptr_old_ncp_header,	&bptr_cipx_header, sptr_connection_state, sptr_line_compression_state);

			cipx_update_connection_state_with_new_header (sptr_connection_state, sptr_ipx_header, header_length);

			send_cipx_compressed_packet (ptr_to_sptr_ipx_packet, sptr_line_compression_state, sptr_connection_state,
				header_length, &bptr_cipx_header, &cipx_header[0], sptr_ipx_header, usptr_number_of_bytes);

#ifdef DEBUG
			print_cipx_connection_state (&sptr_connection_state->uncompressed_header[0], TRANSMIT_MODE, NEW, sptr_connection_state,
				sptr_line_compression_state);

			cipx_printf (CIPX_MEMORY_PRINTF, "CIPX: value of sptr_ipx_packet is : %p\n", *ptr_to_sptr_ipx_packet);

			print_compressed_header_in_cipx_packet (*ptr_to_sptr_ipx_packet, TRANSMIT_MODE, TO_LOWER_LEVEL,
				sptr_line_compression_state, *usptr_number_of_bytes);

			cipx_printf (CIPX_DATA_PRINTF, "\n");
#endif

			++cipx.statistics.type_compressed_packets_transmitted;

			return;
			}
		}
}
/************************************************************************************/
static void determine_send_packet_type (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	IPX_PACKET *sptr_ipx_packet, IPX_HEADER **ptr_to_sptr_ipx_header,	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_ncp_header,
	USHORT number_of_bytes, enum BOOLEAN *eptr_send_ncp_uncompressed, enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type)
{
	*eptr_send_cipx_packet_type = TYPE_REGULAR;

	if (cipx.only_type_regular_is_enabled == TRUE)
		{
		return;
		}

	*eptr_send_ncp_uncompressed = TRUE;

	*ptr_to_sptr_ipx_header = (IPX_HEADER *) &sptr_ipx_packet->ipx_header;

	*ptr_to_sptr_ncp_header = NULL;

	if (check_if_packet_is_a_valid_ipx_packet (*ptr_to_sptr_ipx_header, number_of_bytes) == FALSE)
		{
		cipx_printf (CIPX_COMPRESS_PRINTF, "CIPX: packet is not a valid ipx packet\n");

		return;
		}

	if (cipx.only_confirmed_initial_is_enabled == TRUE)
		{
		*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;

		return;
		}

	if (cipx.only_unconfirmed_initial_is_enabled == TRUE)
		{
		*eptr_send_cipx_packet_type = TYPE_UNCONFIRMED_INITIAL;

		return;
		}

	if ((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE)	||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION))
		{
		if (check_if_ipx_packet_type_is_ncp (*ptr_to_sptr_ipx_header) == TRUE)
			{
			*ptr_to_sptr_ncp_header = get_pointer_to_ncp_header (*ptr_to_sptr_ipx_header);

			if (check_if_ncp_packet_type_is_compressible (*ptr_to_sptr_ncp_header) == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_COMPRESSED;

				*eptr_send_ncp_uncompressed = FALSE;

#ifdef DEBUG
				cipx_printf (CIPX_COMPRESS_PRINTF, "CIPX: NCP/IPX header is compressible\n");
#endif
				}
			else if (sptr_line_compression_state->combined_compression_strategy_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_COMPRESSED;

#ifdef DEBUG
				cipx_printf (CIPX_COMPRESS_PRINTF, "CIPX: only IPX header is compressible\n");
#endif
				}
			}
		else
			{
			if (sptr_line_compression_state->combined_compression_strategy_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_COMPRESSED;

#ifdef DEBUG
				cipx_printf (CIPX_COMPRESS_PRINTF, "CIPX: only IPX header is compressible\n");
#endif
				}
			}
		}
	else
		{
		*eptr_send_cipx_packet_type = TYPE_COMPRESSED;

#ifdef DEBUG
		cipx_printf (CIPX_COMPRESS_PRINTF, "CIPX: only IPX header is compressible\n");
#endif
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_packet_is_a_valid_ipx_packet (IPX_HEADER *sptr_ipx_header, ULONG number_of_bytes)
{
	if (((sptr_ipx_header->packet_type == UNKNOWN_TYPE_PACKET) || (sptr_ipx_header->packet_type == IPX_TYPE_PACKET) ||
		(sptr_ipx_header->packet_type == SPX_TYPE_PACKET) || (sptr_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET) ||
		(sptr_ipx_header->packet_type == ERROR_TYPE_PACKET) || (sptr_ipx_header->packet_type == NETBIOS_NAME_PACKET) ||
		(sptr_ipx_header->packet_type == NETWARE_LITE_PACKET) || (sptr_ipx_header->packet_type == NETWARE_LITE_ACK_PACKET) ||
		(sptr_ipx_header->packet_type == ROUTER_TYPE_PACKET) || (sptr_ipx_header->packet_type == ECHO_TYPE_PACKET))
		&&	(number_of_bytes > (sizeof (UNION_MAC_HEADER) + sizeof (IPX_HEADER))))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_ipx_packet_type_is_ncp (IPX_HEADER *sptr_ipx_header)
{
	if (sptr_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET) 
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
NETWORK_CORE_PROTOCOL_HEADER *get_pointer_to_ncp_header (IPX_HEADER *sptr_ipx_header)
{
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header;

	sptr_ncp_header = (NETWORK_CORE_PROTOCOL_HEADER *) ((BYTE *) sptr_ipx_header + IPX_HEADER_LENGTH);

	return (sptr_ncp_header);
}
/************************************************************************************/
enum BOOLEAN check_if_ncp_packet_type_is_compressible (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header)
{
	if ((net_to_host_short (sptr_ncp_header->packet_type) == NETWORK_CORE_PROTOCOL_REQUEST_TYPE) ||
		(net_to_host_short (sptr_ncp_header->packet_type) == NETWORK_CORE_PROTOCOL_REPLY_TYPE))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static void set_local_variables_for_compression_processing (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state, BYTE **ptr_to_bptr_change_mask, BYTE **ptr_to_bptr_cipx_header,
	BYTE *bptr_cipx_header, USHORT *usptr_header_length, enum BOOLEAN send_ncp_uncompressed)
{
	*ptr_to_sptr_connection_state = sptr_line_compression_state->sptr_last_connection_state->sptr_connection_state_next;

	*ptr_to_bptr_change_mask = bptr_cipx_header;

	**ptr_to_bptr_change_mask = 0x00;

	*ptr_to_bptr_cipx_header = bptr_cipx_header + 1;

	*usptr_header_length = IPX_HEADER_LENGTH;

	if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) && (send_ncp_uncompressed == FALSE))
		{
		*usptr_header_length += (USHORT) MINIMUM_NCP_HEADER_LENGTH;
		}
}
/************************************************************************************/
static void locate_or_create_connection_state (CIPX_CONNECTION_STATE **ptr_to_sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,
	enum BOOLEAN send_ncp_uncompressed)
{
	enum BOOLEAN found_slot;
	IPX_HEADER *sptr_old_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header;
	enum BOOLEAN most_recently_used_connection_state_is_matched;

	found_slot = FALSE;

	sptr_old_ipx_header = (IPX_HEADER *) &(*ptr_to_sptr_connection_state)->uncompressed_header[0];

	sptr_old_ncp_header = NULL;

	if ((((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(send_ncp_uncompressed == FALSE)) && (sptr_old_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if ((*ptr_to_sptr_connection_state)->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
			{
			sptr_old_ncp_header = get_pointer_to_ncp_header (sptr_old_ipx_header);
			}
		}

	most_recently_used_connection_state_is_matched =
		check_if_most_recently_used_connection_state_matches_current_packet (sptr_ipx_header, sptr_line_compression_state,
		sptr_old_ipx_header, sptr_ncp_header, sptr_old_ncp_header, send_ncp_uncompressed, *ptr_to_sptr_connection_state);

	if (most_recently_used_connection_state_is_matched == FALSE)
		{
		*ptr_to_sptr_connection_state = search_and_get_matching_connection_state (sptr_line_compression_state, &found_slot,
			*ptr_to_sptr_connection_state, sptr_ipx_header, sptr_ncp_header, send_ncp_uncompressed);

		if (found_slot == FALSE)
			{
			if (sptr_line_compression_state->confirmed_initial_packet_enabled == TRUE)
				{
				*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;
				}
			else
				{
				*eptr_send_cipx_packet_type = TYPE_UNCONFIRMED_INITIAL;
				}

#ifdef DEBUG
			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: least recently used connection state replaced\n");
#endif
			}
		else
			{
#ifdef DEBUG
			cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: matching connection state found\n");
#endif
			}
		}
	else
		{
#ifdef DEBUG
		cipx_printf (CIPX_DIAGNOSTIC_PRINTF, "CIPX: matching connection state found\n");
#endif
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_most_recently_used_connection_state_matches_current_packet (IPX_HEADER *sptr_ipx_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER *sptr_old_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	enum BOOLEAN send_ncp_uncompressed, CIPX_CONNECTION_STATE *sptr_connection_state)
{
	if ((sptr_ipx_header->source.network != sptr_old_ipx_header->source.network) ||
		(sptr_ipx_header->source.node_address._ulong != sptr_old_ipx_header->source.node_address._ulong) ||
		(sptr_ipx_header->source.node_address._ushort != sptr_old_ipx_header->source.node_address._ushort) ||
		(sptr_ipx_header->source.socket != sptr_old_ipx_header->source.socket) ||
		(sptr_ipx_header->destination.network != sptr_old_ipx_header->destination.network) ||
		(sptr_ipx_header->destination.node_address._ulong != sptr_old_ipx_header->destination.node_address._ulong) ||
		(sptr_ipx_header->destination.node_address._ushort != sptr_old_ipx_header->destination.node_address._ushort) ||
		(sptr_ipx_header->destination.socket != sptr_old_ipx_header->destination.socket))
		{
		return (FALSE);
		}

	if (sptr_old_ncp_header != NULL) 
		{
		if ((sptr_ncp_header->connection_number_low != sptr_old_ncp_header->connection_number_low) ||
			(sptr_ncp_header->connection_number_high != sptr_old_ncp_header->connection_number_high))
			{
			return (FALSE);
			}
		}
	else if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) && (send_ncp_uncompressed == FALSE))
		{
		return (FALSE);
		}
	else if ((send_ncp_uncompressed == TRUE) &&
		(sptr_connection_state->header_length	==	(IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH)))
		{
		return (FALSE);
		}

	++cipx.statistics.matching_connection_state_was_the_most_recently_used_one;

	return (TRUE);
}
/************************************************************************************/
static CIPX_CONNECTION_STATE *search_and_get_matching_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	enum BOOLEAN *eptr_found_slot, CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum BOOLEAN send_ncp_uncompressed)
{
	IPX_HEADER *sptr_old_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header;
	CIPX_CONNECTION_STATE *sptr_previous_connection_state;
	CIPX_CONNECTION_STATE *sptr_last_connection_state;


	*eptr_found_slot = FALSE;
	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;

	sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

	sptr_old_ncp_header = NULL;

	while (sptr_connection_state && sptr_connection_state != sptr_last_connection_state)
		{

		if ((((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
			(send_ncp_uncompressed == FALSE)) && (sptr_old_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
			{
			if (sptr_connection_state->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
				{
				sptr_old_ncp_header = get_pointer_to_ncp_header (sptr_old_ipx_header);
				}
			}

		if ((sptr_ipx_header->source.network != sptr_old_ipx_header->source.network) ||
			(sptr_ipx_header->source.node_address._ulong != sptr_old_ipx_header->source.node_address._ulong) ||
			(sptr_ipx_header->source.node_address._ushort != sptr_old_ipx_header->source.node_address._ushort) ||
			(sptr_ipx_header->source.socket != sptr_old_ipx_header->source.socket) ||
			(sptr_ipx_header->destination.network != sptr_old_ipx_header->destination.network) ||
			(sptr_ipx_header->destination.node_address._ulong != sptr_old_ipx_header->destination.node_address._ulong) ||
			(sptr_ipx_header->destination.node_address._ushort != sptr_old_ipx_header->destination.node_address._ushort) ||
			(sptr_ipx_header->destination.socket != sptr_old_ipx_header->destination.socket))
			{
			goto try_next;
			}

		if (sptr_old_ncp_header != NULL)
			{
			if ((sptr_ncp_header->connection_number_low != sptr_old_ncp_header->connection_number_low) ||
				(sptr_ncp_header->connection_number_high != sptr_old_ncp_header->connection_number_high))
				{
				goto try_next;
				}
			}
		else if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) && (send_ncp_uncompressed == FALSE))
			{
			goto try_next;
			}
		else if ((send_ncp_uncompressed == TRUE) &&
			(sptr_connection_state->header_length	==	(IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH)))
			{
			goto try_next;
			}

		*eptr_found_slot = TRUE;

		break;
try_next:
		sptr_previous_connection_state = sptr_connection_state;

		sptr_connection_state = sptr_connection_state->sptr_connection_state_next;

		sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

		sptr_old_ncp_header = NULL;
     	}

	if (*eptr_found_slot == FALSE)
		{
		++cipx.statistics.least_recently_used_connection_state_was_replaced;

		sptr_line_compression_state->sptr_last_connection_state = sptr_previous_connection_state;
		}
	else
		{ /* Found it -- move to the front of the connection state list. */

		++cipx.statistics.matching_connection_state_was_found;

		move_connection_state_to_front_of_list (sptr_line_compression_state,	sptr_connection_state,
			sptr_previous_connection_state);
		}

	return (sptr_connection_state);
}
/************************************************************************************/
static void move_connection_state_to_front_of_list (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, CIPX_CONNECTION_STATE *sptr_previous_connection_state)
{
	CIPX_CONNECTION_STATE *sptr_last_connection_state;

	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;

	if (sptr_last_connection_state == sptr_connection_state)
		{
 	   sptr_line_compression_state->sptr_last_connection_state = sptr_previous_connection_state;
		}
  	else
		{
		sptr_previous_connection_state->sptr_connection_state_next = sptr_connection_state->sptr_connection_state_next;

 	   sptr_connection_state->sptr_connection_state_next = sptr_last_connection_state->sptr_connection_state_next;

		sptr_last_connection_state->sptr_connection_state_next = sptr_connection_state;
    	}
}
/************************************************************************************/
static void set_pointers_to_last_header_that_was_saved_in_connection_state (CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_HEADER **ptr_to_sptr_old_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER **ptr_to_sptr_old_ncp_header, enum BOOLEAN send_ncp_uncompressed)
{
	*ptr_to_sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

	*ptr_to_sptr_old_ncp_header = NULL;

	if ((((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
		(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
		(send_ncp_uncompressed == FALSE)) && ((*ptr_to_sptr_old_ipx_header)->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
		{
		if (sptr_connection_state->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
			{
			*ptr_to_sptr_old_ncp_header = get_pointer_to_ncp_header (*ptr_to_sptr_old_ipx_header);
			}
		}
}
/************************************************************************************/
static void	check_if_confirm_packet_type_received_for_this_connection (CIPX_CONNECTION_STATE *sptr_connection_state,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	if (sptr_line_compression_state->confirmed_initial_packet_enabled == TRUE)
		{
		if ((BYTE)sptr_connection_state->last_confirmed_initial_packet_id > (BYTE)sptr_connection_state->last_confirm_packet_id)
			{
			*eptr_send_cipx_packet_type = TYPE_CONFIRMED_INITIAL;
			}
		}
}

