/*	$Modname: kcipx.h$  $version: 1.2$      $date: 03/30/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 03/30/95 titus Changes to accomodate new configurable parameters
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _KCIPX_H_
#define _KCIPX_H_


#define NUMBER_OF_CIPX_PORTS 						0x03

#define MAXIMUM_HEADER_LENGTH 					0x24     /* max IPX & NCP header length (by protocol def) */

#define MAXIMUM_COMPRESSED_HEADER_LENGTH 		0x08

#define MINIMUM_COMPRESSED_HEADER_LENGTH 		0x01

#define IPX_HEADER_LENGTH							0x1e

#define MINIMUM_NCP_HEADER_LENGTH				0x06

#define LENGTH_OF_CONFIRMED_INITIAL_HEADER 	0x03

#define LENGTH_OF_UNCONFIRMED_INITIAL_HEADER 0x02

#define LENGTH_OF_CONFIRM_HEADER 				0x03

#define LENGTH_OF_REJECT_HEADER 					0x03

#define LENGTH_OF_CIPX_REGULAR_HEADER			0x01

#define DEFAULT_CHECKSUM							0xffff

#define NUMBER_OF_BITS_IN_BYTE 					0x08

#define MEMCOMPARE_MATCH		 					0x00

#define INVALID_SLOT_NUMBER 						0xff

#define PACKET_TYPE_MASK 							0x0f

#define FOUR_BYTE_BOUNDARY_MASK 					0x00000003L

#define ONE_TWENTY_SEVEN		 					0x7f

#define ONE_NINETY_TWO			 					0xc0


enum IPX_PACKET_TYPE
{
	UNKNOWN_TYPE_PACKET								= 0x00,
	ROUTER_TYPE_PACKET								= 0x01,
	ECHO_TYPE_PACKET									= 0x02,
	ERROR_TYPE_PACKET									= 0x03,
	IPX_TYPE_PACKET									= 0x04,
	SPX_TYPE_PACKET	 								= 0x05,
	NETWORK_CORE_PROTOCOL_TYPE_PACKET		 	= 0x11,
	NETBIOS_NAME_PACKET								= 0x14,
	NETWARE_LITE_PACKET								= 0x19,
	NETWARE_LITE_ACK_PACKET							= 0x1a
};


enum NETWORK_CORE_PROTOCOL_PACKET_TYPE
{
	CREATE_CONNECTION_TYPE					= 0x1111,
	NETWORK_CORE_PROTOCOL_REQUEST_TYPE	= 0x2222,
	NETWORK_CORE_PROTOCOL_REPLY_TYPE		= 0x3333,
	DESTROY_CONNECTION_TYPE					= 0x5555,
	BURSTY_MODE_PACKET_TYPE					= 0x7777,
	SERVER_BUSY_PACKET_TYPE					= 0x9999
};


enum CIPX_COMPRESSION_TYPE
{
	IPX_COMPRESSION,
	NCP_IPX_COMPRESSION
};


/*
 * Bits in first octet of compressed packet
 */

#define TYPE_NORMAL_IPX 			0xff


enum CIPX_PACKET_TYPE
{
	TYPE_COMPRESSED 				= 0x00,
	TYPE_REGULAR 					= 0x01,
	TYPE_CONFIRMED_INITIAL 		= 0x03,
	TYPE_CONFIRM 					= 0x05,
	TYPE_UNCONFIRMED_INITIAL 	= 0x07,
	TYPE_REJECT 					= 0x09
};


enum FIELD_TYPE
{
	SLOT_NUMBER_FIELD 		= 0x80,
	CHECKSUM_FIELD 			= 0x40,
	LENGTH_FIELD 				= 0x20,
	TWO_BYTE_LENGTH			= 0x80,
	THREE_BYTE_LENGTH			= 0xc0,
	TWO_BYTE_LENGTH_MASK    = 0x3f,
	TASK_NUMBER_FIELD 		= 0x10
};


enum CIPX_PRINTF_GROUPS
{
	CIPX_PRINTF,
	CIPX_INIT_PRINTF,
	CIPX_COMPRESS_PRINTF,
	CIPX_UNCOMPRESS_PRINTF,
	CIPX_ENCODE_PRINTF,
	CIPX_DECODE_PRINTF,
	CIPX_CHECKSUM_PRINTF,
	CIPX_STRING_PRINTF,
	CIPX_ALARM_PRINTF,
	CIPX_MEMORY_PRINTF,
	CIPX_DATA_PRINTF,
	CIPX_DIAGNOSTIC_PRINTF
};

#ifndef _COM_MODE_
#define _COM_MODE_
enum COMMUNICATION_MODE
{
	TRANSMIT_MODE,
	RECEIVE_MODE
};


enum PACKET_DIRECTION
{
	FROM_UPPER_LEVEL,
	TO_LOWER_LEVEL,
	FROM_LOWER_LEVEL,
	TO_UPPER_LEVEL
};


enum HEADER_AGE
{
	OLD,
	NEW
};
#endif

enum PROCESS_RESULT
{
	END_OF_PROCESSING,
	CONTINUE_PROCESSING
};

#endif /* _KCIPX_H_ */

