/*	$Modname: cipxtxck.c$  $version: 1.4$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters
1.4 04/06/95 titus Changes for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "cipx.h"
static CIPX_CONNECTION_STATE *search_and_get_matching_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	enum BOOLEAN *eptr_found_slot, CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum BOOLEAN send_ncp_uncompressed)
{
	IPX_HEADER *sptr_old_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header;
	CIPX_CONNECTION_STATE *sptr_previous_connection_state;
	CIPX_CONNECTION_STATE *sptr_last_connection_state;


	*eptr_found_slot = FALSE;
	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;
#ifdef DEBUG
	printf("Last Pointer = %p\n", sptr_last_connection_state);
#endif

	sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

	sptr_old_ncp_header = NULL;

	while (sptr_connection_state != sptr_last_connection_state && sptr_connection_state != NULL)
		{
		if ((((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
			(send_ncp_uncompressed == FALSE)) && (sptr_old_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
			{
			if (sptr_connection_state->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
				{
				sptr_old_ncp_header = get_pointer_to_ncp_header (sptr_old_ipx_header);
				}
			}

		if ((sptr_ipx_header->source.network != sptr_old_ipx_header->source.network) ||
			(sptr_ipx_header->source.node_address._ulong != sptr_old_ipx_header->source.node_address._ulong) ||
			(sptr_ipx_header->source.node_address._ushort != sptr_old_ipx_header->source.node_address._ushort) ||
			(sptr_ipx_header->source.socket != sptr_old_ipx_header->source.socket) ||
			(sptr_ipx_header->destination.network != sptr_old_ipx_header->destination.network) ||
			(sptr_ipx_header->destination.node_address._ulong != sptr_old_ipx_header->destination.node_address._ulong) ||
			(sptr_ipx_header->destination.node_address._ushort != sptr_old_ipx_header->destination.node_address._ushort) ||
			(sptr_ipx_header->destination.socket != sptr_old_ipx_header->destination.socket))
			{
			goto next_try;
			}

		if (sptr_old_ncp_header != NULL)
			{
			if ((sptr_ncp_header->connection_number_low != sptr_old_ncp_header->connection_number_low) ||
				(sptr_ncp_header->connection_number_high != sptr_old_ncp_header->connection_number_high))
				{
				goto next_try;
				}
			}
		else if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) && (send_ncp_uncompressed == FALSE))
			{
			goto next_try;
			}
		else if ((send_ncp_uncompressed == TRUE) &&
			(sptr_connection_state->header_length	==	(IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH)))
			{
			goto next_try;
			}

		*eptr_found_slot = TRUE;
		break;
next_try:
		sptr_previous_connection_state = sptr_connection_state;

		sptr_connection_state = sptr_connection_state->sptr_connection_state_next;

		sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

		sptr_old_ncp_header = NULL;

     	}

	if (*eptr_found_slot == FALSE)
		{
		++cipx.statistics.least_recently_used_connection_state_was_replaced;

		sptr_line_compression_state->sptr_last_connection_state = sptr_previous_connection_state;
		}
	else
		{ /* Found it -- move to the front of the connection state list. */

		++cipx.statistics.matching_connection_state_was_found;

		move_connection_state_to_front_of_list (sptr_line_compression_state,	sptr_connection_state,
			sptr_previous_connection_state);
		}

	return (sptr_connection_state);
}




static CIPX_CONNECTION_STATE *search_and_get_matching_connection_state (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	enum BOOLEAN *eptr_found_slot, CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header,
	NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, enum BOOLEAN send_ncp_uncompressed)
{
	IPX_HEADER *sptr_old_ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header;
	CIPX_CONNECTION_STATE *sptr_previous_connection_state;
	CIPX_CONNECTION_STATE *sptr_last_connection_state;


	*eptr_found_slot = FALSE;
	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;

	do
		{
		sptr_previous_connection_state = sptr_connection_state;

		sptr_connection_state = sptr_connection_state->sptr_connection_state_next;

		sptr_old_ipx_header = (IPX_HEADER *) &sptr_connection_state->uncompressed_header[0];

		sptr_old_ncp_header = NULL;

		if ((((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) &&
			(send_ncp_uncompressed == FALSE)) && (sptr_old_ipx_header->packet_type == NETWORK_CORE_PROTOCOL_TYPE_PACKET))
			{
			if (sptr_connection_state->header_length == (IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH))
				{
				sptr_old_ncp_header = get_pointer_to_ncp_header (sptr_old_ipx_header);
				}
			}

		if ((sptr_ipx_header->source.network != sptr_old_ipx_header->source.network) ||
			(sptr_ipx_header->source.node_address._ulong != sptr_old_ipx_header->source.node_address._ulong) ||
			(sptr_ipx_header->source.node_address._ushort != sptr_old_ipx_header->source.node_address._ushort) ||
			(sptr_ipx_header->source.socket != sptr_old_ipx_header->source.socket) ||
			(sptr_ipx_header->destination.network != sptr_old_ipx_header->destination.network) ||
			(sptr_ipx_header->destination.node_address._ulong != sptr_old_ipx_header->destination.node_address._ulong) ||
			(sptr_ipx_header->destination.node_address._ushort != sptr_old_ipx_header->destination.node_address._ushort) ||
			(sptr_ipx_header->destination.socket != sptr_old_ipx_header->destination.socket))
			{
			continue;
			}

		if (sptr_old_ncp_header != NULL)
			{
			if ((sptr_ncp_header->connection_number_low != sptr_old_ncp_header->connection_number_low) ||
				(sptr_ncp_header->connection_number_high != sptr_old_ncp_header->connection_number_high))
				{
				continue;
				}
			}
		else if (((sptr_line_compression_state->combined_compression_strategy_enabled == TRUE) ||
			(sptr_line_compression_state->compression_type_enabled == NCP_IPX_COMPRESSION)) && (send_ncp_uncompressed == FALSE))
			{
			continue;
			}
		else if ((send_ncp_uncompressed == TRUE) &&
			(sptr_connection_state->header_length	==	(IPX_HEADER_LENGTH + MINIMUM_NCP_HEADER_LENGTH)))
			{
			continue;
			}

		*eptr_found_slot = TRUE;

		break;
     	}
	while (sptr_connection_state != sptr_last_connection_state);
