/*	$Modname: vcipxstr.h$  $version: 1.4$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 09/07/94 titus
1.1 01/06/95 titus Added Copyright, Cosmetic Changes
1.2 02/06/95 titus
1.3 03/30/95 titus Changes for new configurable parameters
1.4 04/06/95 titus Changes for Windows 95 testing
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VCIPXSTR_H_	
#define _VCIPXSTR_H_


#ifndef IPX_HEADER_FILE
#define IPX_HEADER_FILE
typedef struct IPX_ADDRESS
{
	ULONG						network;	
	MAC_ADDRESS				node_address;	
	USHORT					socket; 	
} IPX_ADDRESS;


typedef struct IPX_HEADER
{
	USHORT									checksum;			
	USHORT									length; 				
	BYTE										transport_control_hop_count;
	BYTE_ENUM (IPX_PACKET_TYPE)		packet_type;								/* see kcipx.h */
	IPX_ADDRESS								destination;		
	IPX_ADDRESS								source;
} IPX_HEADER;


typedef struct IPX_PACKET
{
	UNION_MAC_HEADER		mac_header;
	IPX_HEADER				ipx_header;
	BYTE						data[1];						
} IPX_PACKET;
#endif

typedef struct NETWORK_CORE_PROTOCOL_HEADER
{
	/* This is an NCP or NETWORK CORE PROTOCOL request header */

	USHORT_ENUM (NETWORK_CORE_PROTOCOL_PACKET_TYPE) 		packet_type;
	BYTE										 							sequence_number;
	BYTE										 							connection_number_low;
	BYTE										 							task_number;
	BYTE										 							connection_number_high;
} NETWORK_CORE_PROTOCOL_HEADER;


typedef struct NETWORK_CORE_PROTOCOL_PACKET
{
	UNION_MAC_HEADER							mac_header;
	IPX_HEADER									ipx_header;
	NETWORK_CORE_PROTOCOL_HEADER			ncp_header;
	BYTE											data[1];						
} NETWORK_CORE_PROTOCOL_PACKET;


typedef struct	CIPX_PACKET
{
	UNION_MAC_HEADER  			mac_header;
	BYTE 								cipx_header[3];
} CIPX_PACKET;


typedef struct FLAGS_OCTET
{
	unsigned int 			packet_type :4;
	unsigned int 			task_number :1;
	unsigned int 			length :1;
	unsigned	int 			checksum :1;
	unsigned	int 			slot_number :1;
} FLAGS_OCTET;


/*
 * "state" data for each active conversation on the wire.  This is basically a copy of the entire header from
 * the last packet together with a small identifier the transmit & receive ends of the line use to locate the saved header.
 */

typedef struct CIPX_CONNECTION_STATE 
{
	struct CIPX_CONNECTION_STATE  	*sptr_connection_state_next;  			 	/* next most recently used connection_state
																											(used by transmit only) */
	USHORT 									header_length;         						 	/* size of header (used by receive only) */
	USHORT 									slot_number;			            		 	/* slot # associated with this connection_state */
	BYTE_ENUM (BOOLEAN)					unconfirmed_initial_packet;					/* set to TRUE when an unconfirmed initial packet
																												has been sent */
	USHORT									last_confirmed_initial_packet_id;
	USHORT									last_confirm_packet_id;
	USHORT									last_rejected_flags;
	BYTE										uncompressed_header[MAXIMUM_HEADER_LENGTH]; 	 /* header from most recent packet */
} CIPX_CONNECTION_STATE;


/*
 * all the state data for one serial line (we need one of these per line).
 */

typedef struct CIPX_LINE_COMPRESSION_STATE
{
	USHORT 					 							port_number;
	BYTE 						 							maximum_number_of_slots; 								/* must be >2 and <255 */

	BYTE_ENUM (BOOLEAN) 			 					slot_number_compression_enabled;
	BYTE_ENUM (BOOLEAN) 			 					ipx_checksum_enabled;
	BYTE_ENUM (BOOLEAN) 			 					determine_length_from_mac_header_enabled;
	BYTE_ENUM (BOOLEAN) 			 					combined_compression_strategy_enabled;
	BYTE_ENUM (CIPX_COMPRESSION_TYPE) 			compression_type_enabled;
	BYTE_ENUM (BOOLEAN) 			 					confirmed_initial_packet_enabled;
	CIPX_CONNECTION_STATE 							*sptr_last_connection_state;      				/* pointer to the most recently used
																															transmitted_connection_state */
	BYTE 						 				last_received_slot_number;            							/* last received slot number */
	BYTE 						 				last_transmitted_slot_number;         							/* last transmitted slot number */
	BYTE_ENUM (BOOLEAN) 			 		valid_flag;																/* line compression state flag */
	CIPX_CONNECTION_STATE 				*sptr_transmitted_connection_states; 							/* transmit connection states */
	CIPX_CONNECTION_STATE 				*sptr_received_connection_states; 								/* receive connection states */
} CIPX_LINE_COMPRESSION_STATE;


typedef struct CIPX_STATISTICS_CLASS
{
	ULONG 			packets_received_by_cipx;
	ULONG 			normal_ipx_packets_received;
	ULONG 			type_compressed_packets_received;
	ULONG 			type_regular_packets_received;
	ULONG 			type_confirmed_initial_packets_received;
	ULONG 			type_unconfirmed_initial_packets_received;
	ULONG 			type_confirm_packets_received;
	ULONG 			type_reject_packets_received;
	ULONG 			bad_cipx_header_events;
	ULONG 			packets_transmitted_by_cipx;
	ULONG 			type_compressed_packets_transmitted;
	ULONG 			type_regular_packets_transmitted;
	ULONG 			type_confirmed_initial_packets_transmitted;
	ULONG 			type_unconfirmed_initial_packets_transmitted;
	ULONG 			type_confirm_packets_transmitted;
	ULONG 			type_reject_packets_transmitted;
	ULONG 			bandwidth_in_bytes_saved_by_header_compression;
	ULONG 			matching_connection_state_was_the_most_recently_used_one;
	ULONG 			least_recently_used_connection_state_was_replaced;
	ULONG 			matching_connection_state_was_found;
	ULONG 			transmit_port_number_was_invalid;
	ULONG 			cipx_compression_disabled_for_transmit_port;
	ULONG 			cipx_compression_disabled_for_receive_port;
	ULONG 			receive_port_number_was_invalid;
} CIPX_STATISTICS_CLASS;


typedef	struct CIPX_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN) 			cipx_print_switch_on;
	BYTE_ENUM (BOOLEAN) 			cipx_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			init_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			compress_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			uncompress_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			encode_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			decode_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			checksum_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			string_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			memory_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			data_printing_enabled;
	BYTE_ENUM (BOOLEAN) 			diagnostic_printing_enabled;
} CIPX_PRINT_CLASS;


typedef struct CIPX_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN) 						cipx_compression_enabled;
	CIPX_LINE_COMPRESSION_STATE 			line_compression_state;
} CIPX_PORT_CLASS;


typedef struct CIPX_CLASS
{
	BYTE_ENUM (BOOLEAN) 			enabled;
	BYTE_ENUM (BOOLEAN) 			only_type_regular_is_enabled;
	BYTE_ENUM (BOOLEAN) 			only_confirmed_initial_is_enabled;
	BYTE_ENUM (BOOLEAN) 			only_unconfirmed_initial_is_enabled;
	BYTE_ENUM (BOOLEAN) 			align_header_on_4_byte_boundary_enabled;
	USHORT 				 			number_of_ports;
	CIPX_PORT_CLASS 				port[NUMBER_OF_CIPX_PORTS];
	CIPX_STATISTICS_CLASS 		statistics;
	CIPX_PRINT_CLASS 				print_class;
} CIPX_CLASS;



/* cipxapi.c */

void cipx_compress_header (USHORT transmit_port_number, IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes);
enum PROCESS_RESULT cipx_uncompress_header (USHORT receive_port_number, IPX_PACKET **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes);
BYTE cipx_get_maximum_connection_states (USHORT real_port_number);
enum BOOLEAN cipx_get_compress_slot_number (USHORT real_port_number);
enum TEST cipx_set_maximum_connection_states (USHORT real_port_number, BYTE maximum_number_of_slots);
enum TEST cipx_set_compress_slot_number (USHORT real_port_number, enum BOOLEAN compress_slot_number);


/* cipxcnfg.c */

enum TEST cipx_configuration (enum DEVICE_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);


/* cipxinit.c */

enum TEST initialize_cipx (ULONG clock_ticks_per_second);
void set_cipx_class_to_zero (void);


/* cipxtxck.c */

void compress_header (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
NETWORK_CORE_PROTOCOL_HEADER *get_pointer_to_ncp_header (IPX_HEADER *sptr_ipx_header);
enum BOOLEAN check_if_ncp_packet_type_is_compressible (NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header);


/* cipxtxen.c */

enum BOOLEAN cipx_check_if_any_changes_to_fields_that_we_didnot_expect_to_change (IPX_HEADER *sptr_ipx_header,
	IPX_HEADER *sptr_old_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
enum BOOLEAN cipx_check_if_no_changes_to_fields_that_were_expected_to_change (IPX_HEADER *sptr_ipx_header,
	IPX_HEADER *sptr_old_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header,
	enum CIPX_PACKET_TYPE *eptr_send_cipx_packet_type,	NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void send_cipx_regular_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	USHORT *usptr_number_of_bytes);
void send_cipx_confirmed_initial_packet (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header, USHORT header_length,
	IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes);
void send_cipx_unconfirmed_initial_packet (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, IPX_HEADER *sptr_ipx_header, USHORT header_length,
	IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes);
void cipx_figure_out_which_of_the_fields_changed (BYTE *bptr_change_mask, enum BOOLEAN *eptr_send_ncp_uncompressed,
	IPX_HEADER *sptr_ipx_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_ncp_header, NETWORK_CORE_PROTOCOL_HEADER *sptr_old_ncp_header,
	BYTE **ptr_to_bptr_cipx_header, CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void cipx_update_connection_state_with_new_header (CIPX_CONNECTION_STATE *sptr_connection_state,
	IPX_HEADER *sptr_ipx_header, USHORT header_length);
void send_cipx_compressed_packet (IPX_PACKET **ptr_to_sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CIPX_CONNECTION_STATE *sptr_connection_state, USHORT header_length, BYTE **ptr_to_bptr_cipx_header, BYTE *compressed_header,
	IPX_HEADER *sptr_ipx_header, USHORT *usptr_number_of_bytes);

/* cipxrxun.c */

enum PROCESS_RESULT uncompress_header (IPX_PACKET **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void process_bad_header_event (CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, IPX_PACKET *sptr_ipx_packet,
	BYTE rejected_flags, enum BOOLEAN send_reject);


/* cipxrxde.c */

enum PROCESS_RESULT process_compressed_packet (IPX_PACKET **ptr_to_sptr_ipx_packet,	USHORT *usptr_number_of_bytes,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void send_cipx_reject_packet (IPX_PACKET *sptr_ipx_packet, BYTE rejected_flags,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void send_cipx_confirm_packet (CIPX_CONNECTION_STATE *sptr_connection_state,
	CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);


/* cipxprnt.c */

void cipx_printf (enum CIPX_PRINTF_GROUPS printf_group, const char *cptr_format, ...);
void print_compressed_header_in_cipx_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes);
void print_uncompressed_header (IPX_HEADER *sptr_ipx_header, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void print_header_in_regular_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes);
void print_header_in_initial_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes);
void print_header_in_confirm_packet (CIPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes);
void print_header_in_reject_packet (CIPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, USHORT number_of_bytes);
void print_cipx_connection_state (BYTE *bptr_uncompressed_header, enum COMMUNICATION_MODE mode, enum HEADER_AGE header_age,
	CIPX_CONNECTION_STATE *sptr_connection_state, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);
void print_uncompressed_header_in_ipx_packet (IPX_PACKET *sptr_ipx_packet, enum COMMUNICATION_MODE mode,
	enum PACKET_DIRECTION packet_direction, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state, USHORT number_of_bytes);
void print_addresses_in_ipx_packet (IPX_PACKET *sptr_ipx_packet, CIPX_LINE_COMPRESSION_STATE *sptr_line_compression_state);


/* prototypes external to CIPX */

extern enum TEST send_cipx_packet (USHORT real_port_number, void *sptr_tx_packet, USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT protocol_virtual_port_number, void *sptr_buffer));
extern void ppp_register_ipx_compression (USHORT port_number, void (*fptr_cipx_compress_header)
	(USHORT real_port_number, void **ptr_to_sptr_ipx_packet, USHORT *usptr_number_of_bytes),
	BYTE (*fptr_cipx_get_maximum_connection_states) (USHORT real_port_number),
	enum BOOLEAN (*fptr_cipx_get_compress_connection_id) (USHORT real_port_number),
	enum TEST (*fptr_cipx_uncompress_header) (USHORT receive_port_number, void **ptr_to_sptr_ipx_packet,
	USHORT *usptr_number_of_bytes));

#endif
