/*	$Modname: vjcapi.c$  $version: 1.5$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 08/30/94 titus Modified vj_get_maximum_connection_states Modified vj_get_compress_connection_id
1.4 08/30/94 titus
1.5 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "vjc.h"
/************************************************************************************/
BYTE vj_compress_tcp_header (USHORT transmit_port_number, IP_PACKET **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes)
{
	BYTE type_of_packet;
	LINE_COMPRESSION_STATE *sptr_line_compression_state;

	if (vjc.enabled == TRUE)
		{
		if (transmit_port_number < NUMBER_OF_VJC_PORTS)
			{
			if (vjc.port[transmit_port_number].vjc_compression_enabled == TRUE)
				{
				sptr_line_compression_state =	&vjc.port[transmit_port_number].line_compression_state;

				type_of_packet = (BYTE) vjc_compress_tcp_header (ptr_to_sptr_ip_packet, usptr_number_of_bytes,
					sptr_line_compression_state);

				return (type_of_packet);
				}
			else
				{
				++vjc.statistics.vjc_compression_disabled_for_transmit_port;

#ifdef DEBUG
				vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: vjc compression for transmit port number %u is disabled\n",
					transmit_port_number);
#endif

				type_of_packet = (BYTE) TYPE_IP_PACKET;

				return (type_of_packet);
				}
			}
		else
			{
			++vjc.statistics.transmit_port_number_was_invalid;

			vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: transmit port number %u is invalid\n", transmit_port_number);

			type_of_packet = (BYTE) TYPE_IP_PACKET;

			return (type_of_packet);
			}
		}
	else
		{
#ifdef DEBUG
		vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: vj compression/decompression disabled\n");
#endif

		type_of_packet = (BYTE) TYPE_IP_PACKET;

		return (type_of_packet);
		}
}
/************************************************************************************/
void vj_uncompress_tcp_header (USHORT receive_port_number, IP_PACKET **ptr_to_sptr_ip_packet,
	USHORT *usptr_number_of_bytes, BYTE type_of_packet)
{
	LINE_COMPRESSION_STATE *sptr_line_compression_state;

	if (vjc.enabled == TRUE)
		{
		if (receive_port_number < NUMBER_OF_VJC_PORTS)
			{
			if (vjc.port[receive_port_number].vjc_compression_enabled == TRUE)
				{
				sptr_line_compression_state =	&vjc.port[receive_port_number].line_compression_state;

				*ptr_to_sptr_ip_packet = vjc_uncompress_tcp_header (*ptr_to_sptr_ip_packet, usptr_number_of_bytes, type_of_packet,
					sptr_line_compression_state);
				}
			else
				{
				++vjc.statistics.vjc_compression_disabled_for_receive_port;

#ifdef DEBUG
				vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: vjc compression for receive port number %u is disabled\n",
					receive_port_number);
#endif
				}
			}
		else
			{
			++vjc.statistics.receive_port_number_was_invalid;

#ifdef DEBUG
			vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: receive port number %u is invalid\n", receive_port_number);
#endif
			}
		}
	else
		{
#ifdef DEBUG
		vjc_printf (VJC_DIAGNOSTIC_PRINTF, "VJC: vj compression/decompression disabled\n");
#endif
		}

	return;
}
/************************************************************************************/
BYTE vj_get_maximum_connection_states (USHORT real_port_number)
{
	if (real_port_number < NUMBER_OF_VJC_PORTS)
		{
		return (MAXIMUM_NUMBER_OF_CONNECTION_STATES);
		}
	else
		{
		return (0x0000);
		}
}
/************************************************************************************/
enum BOOLEAN vj_get_compress_connection_id (USHORT real_port_number)
{
	VJC_PORT_CLASS *sptr_port_class;

	if (real_port_number < NUMBER_OF_VJC_PORTS)
		{
		sptr_port_class = &vjc.port[real_port_number];

		return (enum BOOLEAN) (sptr_port_class->connection_id_compression_enabled);
		}
	else
		{
		return (FALSE);
		}
}


